/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.system;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.logging.LoggerKt;
import com.jetpackduba.gitnuro.managers.ShellManager;
import com.jetpackduba.gitnuro.system.OSKt;
import com.jetpackduba.gitnuro.system.PickerType;
import java.awt.FileDialog;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0086\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetpackduba/gitnuro/system/OpenFilePickerUseCase;", "", "shellManager", "Lcom/jetpackduba/gitnuro/managers/ShellManager;", "<init>", "(Lcom/jetpackduba/gitnuro/managers/ShellManager;)V", "invoke", "", "pickerType", "Lcom/jetpackduba/gitnuro/system/PickerType;", "basePath", "openDirectoryDialogLinux", "openJvmDialog", "isLinux", "", "isMac", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class OpenFilePickerUseCase {
    @NotNull
    private final ShellManager shellManager;
    public static final int $stable;

    @Inject
    public OpenFilePickerUseCase(@NotNull ShellManager shellManager) {
        Intrinsics.checkNotNullParameter((Object)shellManager, (String)"shellManager");
        this.shellManager = shellManager;
    }

    @Nullable
    public final String invoke(@NotNull PickerType pickerType, @Nullable String basePath) {
        Intrinsics.checkNotNullParameter((Object)((Object)pickerType), (String)"pickerType");
        boolean isLinux = OSKt.getCurrentOs().isLinux();
        boolean isMac = OSKt.getCurrentOs().isMac();
        return isLinux ? this.openDirectoryDialogLinux(pickerType) : this.openJvmDialog(pickerType, basePath, false, isMac);
    }

    private final String openDirectoryDialogLinux(PickerType pickerType) {
        String dirToOpen = null;
        Object[] objectArray = new String[]{"which", "zenity", "2>/dev/null"};
        String checkZenityInstalled = this.shellManager.runCommand(CollectionsKt.listOf((Object[])objectArray));
        CharSequence charSequence = checkZenityInstalled;
        boolean isZenityInstalled = !(charSequence == null || charSequence.length() == 0);
        LoggerKt.printLog("SystemDialogs", "IsZenityInstalled " + isZenityInstalled);
        if (isZenityInstalled) {
            List command = switch (WhenMappings.$EnumSwitchMapping$0[pickerType.ordinal()]) {
                case 1 -> {
                    Object[] var8_7 = new String[]{"zenity", "--file-selection", "--title=Open"};
                    yield CollectionsKt.listOf((Object[])var8_7);
                }
                case 2 -> {
                    Object[] var8_7 = new String[]{"zenity", "--file-selection", "--title=Open", "--directory"};
                    yield CollectionsKt.listOf((Object[])var8_7);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            String string2 = this.shellManager.runCommand(command);
            String openDirectory = string2 != null ? StringsKt.replace$default((String)string2, (String)"\n", (String)"", (boolean)false, (int)4, null) : null;
            CharSequence charSequence2 = openDirectory;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                dirToOpen = openDirectory;
            }
        } else {
            dirToOpen = this.openJvmDialog(pickerType, "", true, false);
        }
        return dirToOpen;
    }

    private final String openJvmDialog(PickerType pickerType, String basePath, boolean isLinux, boolean isMac) {
        if (!isLinux) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        if (isMac) {
            Object object;
            Object object2;
            if (pickerType == PickerType.DIRECTORIES) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
            }
            if ((object2 = (CharSequence)basePath) == null || object2.length() == 0) {
                object = new FileDialog(null, "Open", 0);
            } else {
                Object $this$openJvmDialog_u24lambda_u240 = object2 = new FileDialog(null, "Open", 0);
                boolean bl = false;
                ((FileDialog)$this$openJvmDialog_u24lambda_u240).setDirectory(basePath);
                object = object2;
            }
            FileDialog fileChooser = object;
            fileChooser.setMultipleMode(false);
            fileChooser.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            if (fileChooser.getFile() != null && fileChooser.getDirectory() != null) {
                return fileChooser.getDirectory() + fileChooser.getFile();
            }
            return null;
        }
        CharSequence charSequence = basePath;
        JFileChooser fileChooser = charSequence == null || charSequence.length() == 0 ? new JFileChooser() : new JFileChooser(basePath);
        fileChooser.setFileSelectionMode(pickerType.getValue());
        fileChooser.showOpenDialog(null);
        return fileChooser.getSelectedFile() != null ? fileChooser.getSelectedFile().getAbsolutePath() : null;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PickerType.values().length];
            try {
                nArray[PickerType.FILES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PickerType.DIRECTORIES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

