/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.ssh.libssh.streams;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.exceptions.SshException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetpackduba/gitnuro/ssh/libssh/streams/SshChannelInputStream;", "Ljava/io/InputStream;", "sshChannel", "LChannel;", "<init>", "(LChannel;)V", "read", "", "b", "", "off", "len", "close", "", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class SshChannelInputStream
extends InputStream {
    @NotNull
    private final Channel sshChannel;
    public static final int $stable = 8;

    public SshChannelInputStream(@NotNull Channel sshChannel) {
        Intrinsics.checkNotNullParameter((Object)sshChannel, (String)"sshChannel");
        this.sshChannel = sshChannel;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ReadResult readResult = this.sshChannel.read(false, len);
        if (readResult == null) {
            throw new SshException("Could not read result from SSH channel. Please check your network connectivity and try again.");
        }
        ReadResult result = readResult;
        if (result.getReadCount() == 0L) {
            return -1;
        }
        byte[] byteArray = result.getData();
        long read = result.getReadCount();
        for (int i = 0; i < len; ++i) {
            b[off + i] = byteArray[i];
        }
        return (int)read;
    }

    @Override
    public int read() {
        ReadResult readResult = this.sshChannel.read(false, 1L);
        if (readResult == null) {
            throw new SshException("Could not read result from SSH channel. Please check your network connectivity and try again.");
        }
        ReadResult result = readResult;
        if (result.getReadCount() == 0L) {
            return -1;
        }
        byte first = ArraysKt.first((byte[])result.getData());
        return first;
    }

    @Override
    public void close() {
    }
}

