/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.ssh.libssh;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.exceptions.SshException;
import com.jetpackduba.gitnuro.extensions.StringExtensionsKt;
import com.jetpackduba.gitnuro.ssh.libssh.streams.SshChannelInputErrStream;
import com.jetpackduba.gitnuro.ssh.libssh.streams.SshChannelInputStream;
import com.jetpackduba.gitnuro.ssh.libssh.streams.SshChannelOutputStream;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001f"}, d2={"Lcom/jetpackduba/gitnuro/ssh/libssh/ChannelWrapper;", "", "sshSession", "LSession;", "<init>", "(LSession;)V", "channel", "LChannel;", "isClosed", "", "closeMutex", "Ljava/util/concurrent/Semaphore;", "outputStream", "Lcom/jetpackduba/gitnuro/ssh/libssh/streams/SshChannelOutputStream;", "getOutputStream", "()Lcom/jetpackduba/gitnuro/ssh/libssh/streams/SshChannelOutputStream;", "inputStream", "Lcom/jetpackduba/gitnuro/ssh/libssh/streams/SshChannelInputStream;", "getInputStream", "()Lcom/jetpackduba/gitnuro/ssh/libssh/streams/SshChannelInputStream;", "errorOutputStream", "Lcom/jetpackduba/gitnuro/ssh/libssh/streams/SshChannelInputErrStream;", "getErrorOutputStream", "()Lcom/jetpackduba/gitnuro/ssh/libssh/streams/SshChannelInputErrStream;", "openSession", "", "requestExec", "commandName", "", "isOpen", "close", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class ChannelWrapper {
    @NotNull
    private final Channel channel;
    private boolean isClosed;
    @NotNull
    private Semaphore closeMutex;
    @NotNull
    private final SshChannelOutputStream outputStream;
    @NotNull
    private final SshChannelInputStream inputStream;
    @NotNull
    private final SshChannelInputErrStream errorOutputStream;
    public static final int $stable = 8;

    public ChannelWrapper(@NotNull Session sshSession) {
        Intrinsics.checkNotNullParameter((Object)sshSession, (String)"sshSession");
        Channel channel = Channel.Companion.new(sshSession);
        if (channel == null) {
            throw new SshException("Could not obtain the channel, this is likely a bug. Please file a report.");
        }
        this.channel = channel;
        this.closeMutex = new Semaphore(1);
        this.outputStream = new SshChannelOutputStream(this.channel);
        this.inputStream = new SshChannelInputStream(this.channel);
        this.errorOutputStream = new SshChannelInputErrStream(this.channel);
    }

    @NotNull
    public final SshChannelOutputStream getOutputStream() {
        return this.outputStream;
    }

    @NotNull
    public final SshChannelInputStream getInputStream() {
        return this.inputStream;
    }

    @NotNull
    public final SshChannelInputErrStream getErrorOutputStream() {
        return this.errorOutputStream;
    }

    public final void openSession() {
        this.channel.openSession();
    }

    public final void requestExec(@NotNull String commandName) {
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        StringExtensionsKt.throwIfSshMessage(this.channel.requestExec(commandName));
    }

    public final boolean isOpen() {
        return this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        this.closeMutex.acquire();
        try {
            if (!this.isClosed) {
                StringExtensionsKt.throwIfSshMessage(this.channel.closeChannel());
                this.channel.close();
                this.isClosed = true;
            }
        }
        finally {
            this.closeMutex.release();
        }
    }
}

