/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.managers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.exceptions.CommandExecutionFailed;
import com.jetpackduba.gitnuro.logging.LoggerKt;
import com.jetpackduba.gitnuro.managers.IShellManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetpackduba/gitnuro/managers/ShellManager;", "Lcom/jetpackduba/gitnuro/managers/IShellManager;", "<init>", "()V", "runCommand", "", "command", "", "runCommandInPath", "", "path", "runCommandWithoutResult", "", "runCommandProcess", "Ljava/lang/Process;", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class ShellManager
implements IShellManager {
    public static final int $stable;

    @Inject
    public ShellManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String runCommand(@NotNull List<String> command) {
        String string2;
        Intrinsics.checkNotNullParameter(command, (String)"command");
        LoggerKt.printLog("ShellManager", "runCommand: " + CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        try {
            String result = null;
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Closeable closeable = processBuilder.start().getInputStream();
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new Scanner(inputStream).useDelimiter("\\A");
                Throwable throwable2 = null;
                try {
                    Scanner s = (Scanner)closeable2;
                    boolean bl2 = false;
                    result = s.hasNext() ? s.next() : null;
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            string2 = null;
        }
        return string2;
    }

    @Override
    public void runCommandInPath(@NotNull List<String> command, @NotNull String path) {
        ProcessBuilder processBuilder;
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LoggerKt.printLog("ShellManager", "runCommandInPath: " + CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        ProcessBuilder $this$runCommandInPath_u24lambda_u242 = processBuilder = new ProcessBuilder(command);
        boolean bl = false;
        $this$runCommandInPath_u24lambda_u242.directory(new File(path));
        ProcessBuilder processBuilder2 = processBuilder;
        processBuilder2.start();
    }

    @Override
    public boolean runCommandWithoutResult(@NotNull List<String> command) {
        boolean bl;
        Intrinsics.checkNotNullParameter(command, (String)"command");
        LoggerKt.printLog("ShellManager", "runCommandWithoutResult: " + CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        try {
            boolean bl2;
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Process process = processBuilder.start();
            if (process == null) {
                return false;
            }
            Process p = process;
            try {
                boolean bl3;
                int exitValue = p.exitValue();
                if (exitValue == 0) {
                    LoggerKt.printLog("ShellManager", "Process ended immediately.");
                    bl3 = false;
                } else {
                    LoggerKt.printError$default("ShellManager", "Process crashed.", null, 4, null);
                    bl3 = false;
                }
                bl2 = bl3;
            }
            catch (IllegalThreadStateException itse) {
                LoggerKt.printLog("ShellManager", "Process is running.");
                bl2 = true;
            }
            bl = bl2;
        }
        catch (IOException e) {
            LoggerKt.printError("ShellManager", "Error running command: " + e.getMessage(), e);
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Process runCommandProcess(@NotNull List<String> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        LoggerKt.printLog("ShellManager", "runCommandProcess: " + CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        try {
            Process process = new ProcessBuilder(command).start();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"start(...)");
            return process;
        }
        catch (IOException ex) {
            String string2 = ex.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            throw new CommandExecutionFailed(string2, ex);
        }
    }
}

