/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.managers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.managers.IShellManager;
import com.jetpackduba.gitnuro.managers.ShellManager;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u0004\u0018\u00010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\bH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetpackduba/gitnuro/managers/FlatpakShellManager;", "Lcom/jetpackduba/gitnuro/managers/IShellManager;", "shellManager", "Lcom/jetpackduba/gitnuro/managers/ShellManager;", "<init>", "(Lcom/jetpackduba/gitnuro/managers/ShellManager;)V", "flatpakPrefix", "", "", "runCommand", "command", "runCommandInPath", "", "path", "runCommandWithoutResult", "", "runCommandProcess", "Ljava/lang/Process;", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class FlatpakShellManager
implements IShellManager {
    @NotNull
    private final ShellManager shellManager;
    @NotNull
    private final List<String> flatpakPrefix;
    public static final int $stable = 8;

    @Inject
    public FlatpakShellManager(@NotNull ShellManager shellManager) {
        Intrinsics.checkNotNullParameter((Object)shellManager, (String)"shellManager");
        this.shellManager = shellManager;
        Object[] objectArray = new String[]{"/usr/bin/flatpak-spawn", "--host", "--env=TERM=xterm-256color"};
        this.flatpakPrefix = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public String runCommand(@NotNull List<String> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        return this.shellManager.runCommand(CollectionsKt.plus((Collection)this.flatpakPrefix, (Iterable)command));
    }

    @Override
    public void runCommandInPath(@NotNull List<String> command, @NotNull String path) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.shellManager.runCommandInPath(CollectionsKt.plus((Collection)this.flatpakPrefix, (Iterable)command), path);
    }

    @Override
    public boolean runCommandWithoutResult(@NotNull List<String> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        return this.shellManager.runCommandWithoutResult(CollectionsKt.plus((Collection)this.flatpakPrefix, (Iterable)command));
    }

    @Override
    @NotNull
    public Process runCommandProcess(@NotNull List<String> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        return this.shellManager.runCommandProcess(CollectionsKt.plus((Collection)this.flatpakPrefix, (Iterable)command));
    }
}

