/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.managers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.logging.LoggerKt;
import com.jetpackduba.gitnuro.system.OS;
import com.jetpackduba.gitnuro.system.OSKt;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetpackduba/gitnuro/managers/AppFilesManager;", "", "<init>", "()V", "getAppFolder", "Ljava/io/File;", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class AppFilesManager {
    public static final int $stable;

    @Inject
    public AppFilesManager() {
    }

    @NotNull
    public final File getAppFolder() {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[OSKt.getCurrentOs().ordinal()]) {
            case 1: {
                Object configFolder = System.getenv("XDG_CONFIG_HOME");
                CharSequence charSequence = (CharSequence)configFolder;
                if (charSequence == null || charSequence.length() == 0) {
                    configFolder = System.getenv("HOME") + "/.config";
                }
                object = configFolder;
                break;
            }
            case 2: {
                object = System.getenv("APPDATA");
                if (object != null) break;
                object = "";
                break;
            }
            case 3: {
                object = System.getProperty("user.home") + "/Library/Application";
                break;
            }
            default: {
                LoggerKt.printError$default("AppFilesManager", "Unknown OS", null, 4, null);
                throw new Exception("Invalid OS");
            }
        }
        Object baseFolderPath = object;
        File baseFolder = new File((String)baseFolderPath);
        baseFolder.mkdirs();
        File appFolder = new File(baseFolder, "gitnuro");
        if (!appFolder.exists() || !appFolder.isDirectory()) {
            appFolder.mkdir();
        }
        return appFolder;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.LINUX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.WINDOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MAC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

