/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.lfs;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.Result;
import com.jetpackduba.gitnuro.extensions.StringExtensionsKt;
import com.jetpackduba.gitnuro.git.lfs.AuthenticateLfsServerWithSshUseCase;
import com.jetpackduba.gitnuro.git.lfs.DownloadLfsObjectUseCase;
import com.jetpackduba.gitnuro.git.lfs.GetLfsObjectsUseCase;
import com.jetpackduba.gitnuro.lfs.GetLfsUrlUseCase;
import com.jetpackduba.gitnuro.lfs.LfsError;
import com.jetpackduba.gitnuro.lfs.OperationType;
import com.jetpackduba.gitnuro.models.lfs.LfsObject;
import com.jetpackduba.gitnuro.models.lfs.LfsObjectBatch;
import com.jetpackduba.gitnuro.models.lfs.LfsObjects;
import com.jetpackduba.gitnuro.models.lfs.LfsSshAuthenticateResult;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.lfs.Lfs;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lfs.errors.LfsException;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001BG\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetpackduba/gitnuro/lfs/LfsSmudgeFilter;", "Lorg/eclipse/jgit/attributes/FilterCommand;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "getLfsUrlUseCase", "Lcom/jetpackduba/gitnuro/lfs/GetLfsUrlUseCase;", "getLfsObjectsUseCase", "Lcom/jetpackduba/gitnuro/git/lfs/GetLfsObjectsUseCase;", "authenticateLfsServerWithSshUseCase", "Lcom/jetpackduba/gitnuro/git/lfs/AuthenticateLfsServerWithSshUseCase;", "downloadLfsObjectUseCase", "Lcom/jetpackduba/gitnuro/git/lfs/DownloadLfsObjectUseCase;", "<init>", "(Lorg/eclipse/jgit/lib/Repository;Ljava/io/InputStream;Ljava/io/OutputStream;Lcom/jetpackduba/gitnuro/lfs/GetLfsUrlUseCase;Lcom/jetpackduba/gitnuro/git/lfs/GetLfsObjectsUseCase;Lcom/jetpackduba/gitnuro/git/lfs/AuthenticateLfsServerWithSshUseCase;Lcom/jetpackduba/gitnuro/git/lfs/DownloadLfsObjectUseCase;)V", "downloadLfsResource", "", "lfsPointer", "Lorg/eclipse/jgit/lfs/LfsPointer;", "run", "", "Gitnuro"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLfsSmudgeFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LfsSmudgeFilter.kt\ncom/jetpackduba/gitnuro/lfs/LfsSmudgeFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class LfsSmudgeFilter
extends FilterCommand {
    @NotNull
    private final GetLfsUrlUseCase getLfsUrlUseCase;
    @NotNull
    private final GetLfsObjectsUseCase getLfsObjectsUseCase;
    @NotNull
    private final AuthenticateLfsServerWithSshUseCase authenticateLfsServerWithSshUseCase;
    @NotNull
    private final DownloadLfsObjectUseCase downloadLfsObjectUseCase;
    public static final int $stable = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AssistedInject
    public LfsSmudgeFilter(@Assisted @NotNull Repository repository, @Assisted @NotNull InputStream input, @Assisted @NotNull OutputStream output, @NotNull GetLfsUrlUseCase getLfsUrlUseCase, @NotNull GetLfsObjectsUseCase getLfsObjectsUseCase, @NotNull AuthenticateLfsServerWithSshUseCase authenticateLfsServerWithSshUseCase, @NotNull DownloadLfsObjectUseCase downloadLfsObjectUseCase) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)getLfsUrlUseCase, (String)"getLfsUrlUseCase");
        Intrinsics.checkNotNullParameter((Object)getLfsObjectsUseCase, (String)"getLfsObjectsUseCase");
        Intrinsics.checkNotNullParameter((Object)authenticateLfsServerWithSshUseCase, (String)"authenticateLfsServerWithSshUseCase");
        Intrinsics.checkNotNullParameter((Object)downloadLfsObjectUseCase, (String)"downloadLfsObjectUseCase");
        super(input.markSupported() ? input : (InputStream)new BufferedInputStream(input), output);
        this.getLfsUrlUseCase = getLfsUrlUseCase;
        this.getLfsObjectsUseCase = getLfsObjectsUseCase;
        this.authenticateLfsServerWithSshUseCase = authenticateLfsServerWithSshUseCase;
        this.downloadLfsObjectUseCase = downloadLfsObjectUseCase;
        InputStream from = input;
        try {
            LfsPointer res = LfsPointer.parseLfsPointer((InputStream)from);
            if (res != null) {
                Lfs lfs = new Lfs(repository);
                AnyLongObjectId oid = res.getOid();
                Path mediaFile = lfs.getMediaFile(oid);
                if (!Files.exists(mediaFile, new LinkOption[0])) {
                    this.downloadLfsResource(repository, res);
                }
                this.in = Files.newInputStream(mediaFile, new OpenOption[0]);
            } else {
                from = null;
            }
            inputStream = from;
        }
        catch (Throwable throwable) {
            from.close();
            throw throwable;
        }
        if (inputStream != null) {
            inputStream.close();
        }
    }

    private final void downloadLfsResource(Repository repository, LfsPointer lfsPointer) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, repository, lfsPointer, null){
            Object L$0;
            int label;
            final /* synthetic */ LfsSmudgeFilter this$0;
            final /* synthetic */ Repository $repository;
            final /* synthetic */ LfsPointer $lfsPointer;
            {
                this.this$0 = $receiver;
                this.$repository = $repository;
                this.$lfsPointer = $lfsPointer;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                block16: {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = LfsSmudgeFilter.access$getGetLfsUrlUseCase$p(this.this$0).invoke(this.$repository, null, (Continuation<? super String>)((Continuation)this));
                            if (v0 == var13_2) {
                                return var13_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            v1 = (String)v0;
                            if (v1 == null) {
                                throw new Exception("LFS Url not found");
                            }
                            lfsServerUrl = v1;
                            isHttpUrl = StringExtensionsKt.isHttpOrHttps(lfsServerUrl);
                            v2 = this.$lfsPointer.getOid().name();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"name(...)");
                            lfsObjectBatches = CollectionsKt.listOf((Object)new LfsObjectBatch(v2, this.$lfsPointer.getSize()));
                            var5_6 = null;
                            if (!isHttpUrl) break;
                            finalServerUrl = lfsServerUrl;
                            var7_8 = LfsSmudgeFilter.access$getGetLfsObjectsUseCase$p(this.this$0);
                            var8_9 /* !! */  = OperationType.DOWNLOAD;
                            v3 = this.$repository.getFullBranch();
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getFullBranch(...)");
                            var9_10 = v3;
                            var10_12 = MapsKt.emptyMap();
                            this.L$0 = finalServerUrl;
                            this.label = 2;
                            v4 = var7_8.invoke(lfsServerUrl, (OperationType)var8_9 /* !! */ , var9_10, lfsObjectBatches, var10_12, (Continuation<? super Result<LfsObjects, ? extends LfsError>>)((Continuation)this));
                            if (v4 == var13_2) {
                                return var13_2;
                            }
                            ** GOTO lbl41
                        }
                        case 2: {
                            finalServerUrl = (String)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl41:
                            // 2 sources

                            var5_6 = (Result)v4;
                            ** GOTO lbl73
                        }
                    }
                    this.L$0 = lfsObjectBatches;
                    this.label = 3;
                    v5 = LfsSmudgeFilter.access$getAuthenticateLfsServerWithSshUseCase$p(this.this$0).invoke((String)var2_3, OperationType.DOWNLOAD, (Continuation<? super LfsSshAuthenticateResult>)((Continuation)this));
                    if (v5 == var13_2) {
                        return var13_2;
                    }
                    ** GOTO lbl53
                    {
                        case 3: {
                            lfsObjectBatches = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl53:
                            // 2 sources

                            lfsServerInfo = (LfsSshAuthenticateResult)v5;
                            finalServerUrl = lfsServerInfo.getHref();
                            var8_9 /* !! */  = LfsSmudgeFilter.access$getGetLfsObjectsUseCase$p(this.this$0);
                            var9_11 = lfsServerInfo.getHref();
                            var10_13 = OperationType.DOWNLOAD;
                            v6 = this.$repository.getFullBranch();
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getFullBranch(...)");
                            var11_14 = v6;
                            var12_15 = lfsServerInfo.getHeader();
                            this.L$0 = finalServerUrl;
                            this.label = 4;
                            v7 = var8_9 /* !! */ .invoke(var9_11, var10_13, var11_14, lfsObjectBatches, var12_15, (Continuation<? super Result<LfsObjects, ? extends LfsError>>)((Continuation)this));
                            if (v7 == var13_2) {
                                return var13_2;
                            }
                            ** GOTO lbl72
                        }
                        case 4: {
                            finalServerUrl = (String)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl72:
                            // 2 sources

                            lfsObjects = (Result)v7;
lbl73:
                            // 2 sources

                            var7_8 = lfsObjects;
                            if (var7_8 instanceof Result.Err) {
                                throw new LfsException("Gettings LFS objects failed with error: " + ((Result.Err)lfsObjects).getError());
                            }
                            if (!(var7_8 instanceof Result.Ok)) break;
                            lfsObject = (LfsObject)CollectionsKt.firstOrNull((List)((LfsObjects)((Result.Ok)lfsObjects).getValue()).getObjects());
                            if (lfsObject != null) {
                                v8 = LfsSmudgeFilter.access$getDownloadLfsObjectUseCase$p(this.this$0);
                                v9 = this.$lfsPointer.getOid();
                                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getOid(...)");
                                this.L$0 = null;
                                this.label = 5;
                                v10 = v8.invoke(this.$repository, finalServerUrl, lfsObject, v9, (Continuation<? super Unit>)((Continuation)this));
                                if (v10 == var13_2) {
                                    return var13_2;
                                }
                            }
                            break block16;
                        }
                        case 5: {
                            ResultKt.throwOnFailure((Object)$result);
                            v10 = $result;
                            break block16;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public int run() throws IOException {
        try {
            int length;
            int totalRead;
            block5: {
                totalRead = 0;
                length = 0;
                if (this.in != null) {
                    byte[] buf = new byte[8192];
                    do {
                        int n;
                        int it = n = this.in.read(buf);
                        boolean bl = false;
                        length = it;
                        if (n == -1) break block5;
                        this.out.write(buf, 0, length);
                    } while ((totalRead += length) < 0x10000000);
                    return totalRead;
                }
            }
            if (totalRead == 0 && length == -1) {
                this.in.close();
                this.out.close();
                return length;
            }
            return totalRead;
        }
        catch (IOException e) {
            this.in.close();
            this.out.close();
            throw e;
        }
    }

    public static final /* synthetic */ GetLfsUrlUseCase access$getGetLfsUrlUseCase$p(LfsSmudgeFilter $this) {
        return $this.getLfsUrlUseCase;
    }

    public static final /* synthetic */ GetLfsObjectsUseCase access$getGetLfsObjectsUseCase$p(LfsSmudgeFilter $this) {
        return $this.getLfsObjectsUseCase;
    }

    public static final /* synthetic */ AuthenticateLfsServerWithSshUseCase access$getAuthenticateLfsServerWithSshUseCase$p(LfsSmudgeFilter $this) {
        return $this.authenticateLfsServerWithSshUseCase;
    }

    public static final /* synthetic */ DownloadLfsObjectUseCase access$getDownloadLfsObjectUseCase$p(LfsSmudgeFilter $this) {
        return $this.downloadLfsObjectUseCase;
    }
}

