/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.lfs;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.Result;
import com.jetpackduba.gitnuro.extensions.StringExtensionsKt;
import com.jetpackduba.gitnuro.git.lfs.AuthenticateLfsServerWithSshUseCase;
import com.jetpackduba.gitnuro.git.lfs.GetLfsObjectsUseCase;
import com.jetpackduba.gitnuro.git.lfs.UploadLfsObjectUseCase;
import com.jetpackduba.gitnuro.git.lfs.VerifyUploadLfsObjectUseCase;
import com.jetpackduba.gitnuro.lfs.GetLfsUrlUseCase;
import com.jetpackduba.gitnuro.lfs.LfsError;
import com.jetpackduba.gitnuro.lfs.OperationType;
import com.jetpackduba.gitnuro.models.lfs.LfsObject;
import com.jetpackduba.gitnuro.models.lfs.LfsObjectBatch;
import com.jetpackduba.gitnuro.models.lfs.LfsObjects;
import com.jetpackduba.gitnuro.models.lfs.LfsSshAuthenticateResult;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import java.io.Closeable;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lfs.errors.LfsException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BS\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001e\u0010\u001c\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetpackduba/gitnuro/lfs/LfsPrePushHook;", "Lorg/eclipse/jgit/hooks/PrePushHook;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "outputStream", "Ljava/io/PrintStream;", "errorStream", "getLfsUrlUseCase", "Lcom/jetpackduba/gitnuro/lfs/GetLfsUrlUseCase;", "getLfsObjectsUseCase", "Lcom/jetpackduba/gitnuro/git/lfs/GetLfsObjectsUseCase;", "uploadLfsObjectUseCase", "Lcom/jetpackduba/gitnuro/git/lfs/UploadLfsObjectUseCase;", "verifyUploadLfsObjectUseCase", "Lcom/jetpackduba/gitnuro/git/lfs/VerifyUploadLfsObjectUseCase;", "authenticateLfsServerWithSshUseCase", "Lcom/jetpackduba/gitnuro/git/lfs/AuthenticateLfsServerWithSshUseCase;", "<init>", "(Lorg/eclipse/jgit/lib/Repository;Ljava/io/PrintStream;Ljava/io/PrintStream;Lcom/jetpackduba/gitnuro/lfs/GetLfsUrlUseCase;Lcom/jetpackduba/gitnuro/git/lfs/GetLfsObjectsUseCase;Lcom/jetpackduba/gitnuro/git/lfs/UploadLfsObjectUseCase;Lcom/jetpackduba/gitnuro/git/lfs/VerifyUploadLfsObjectUseCase;Lcom/jetpackduba/gitnuro/git/lfs/AuthenticateLfsServerWithSshUseCase;)V", "refs", "", "Lorg/eclipse/jgit/transport/RemoteRefUpdate;", "setRefs", "", "toRefs", "findObjectsToPush", "", "Lorg/eclipse/jgit/lfs/LfsPointer;", "findLfsPointers", "toPush", "", "walk", "Lorg/eclipse/jgit/revwalk/ObjectWalk;", "getObjectSize", "", "r", "Lorg/eclipse/jgit/lib/ObjectReader;", "obj", "Lorg/eclipse/jgit/revwalk/RevObject;", "loadLfsPointer", "Lorg/eclipse/jgit/lib/AnyObjectId;", "excludeRemoteRefs", "remote", "", "call", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class LfsPrePushHook
extends PrePushHook {
    @NotNull
    private final GetLfsUrlUseCase getLfsUrlUseCase;
    @NotNull
    private final GetLfsObjectsUseCase getLfsObjectsUseCase;
    @NotNull
    private final UploadLfsObjectUseCase uploadLfsObjectUseCase;
    @NotNull
    private final VerifyUploadLfsObjectUseCase verifyUploadLfsObjectUseCase;
    @NotNull
    private final AuthenticateLfsServerWithSshUseCase authenticateLfsServerWithSshUseCase;
    @NotNull
    private Collection<? extends RemoteRefUpdate> refs;
    public static final int $stable = 8;

    @AssistedInject
    public LfsPrePushHook(@Assisted @NotNull Repository repository, @Assisted(value="outputStream") @Nullable PrintStream outputStream, @Assisted(value="errorStream") @Nullable PrintStream errorStream, @NotNull GetLfsUrlUseCase getLfsUrlUseCase, @NotNull GetLfsObjectsUseCase getLfsObjectsUseCase, @NotNull UploadLfsObjectUseCase uploadLfsObjectUseCase, @NotNull VerifyUploadLfsObjectUseCase verifyUploadLfsObjectUseCase, @NotNull AuthenticateLfsServerWithSshUseCase authenticateLfsServerWithSshUseCase) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)getLfsUrlUseCase, (String)"getLfsUrlUseCase");
        Intrinsics.checkNotNullParameter((Object)getLfsObjectsUseCase, (String)"getLfsObjectsUseCase");
        Intrinsics.checkNotNullParameter((Object)uploadLfsObjectUseCase, (String)"uploadLfsObjectUseCase");
        Intrinsics.checkNotNullParameter((Object)verifyUploadLfsObjectUseCase, (String)"verifyUploadLfsObjectUseCase");
        Intrinsics.checkNotNullParameter((Object)authenticateLfsServerWithSshUseCase, (String)"authenticateLfsServerWithSshUseCase");
        super(repository, outputStream, errorStream);
        this.getLfsUrlUseCase = getLfsUrlUseCase;
        this.getLfsObjectsUseCase = getLfsObjectsUseCase;
        this.uploadLfsObjectUseCase = uploadLfsObjectUseCase;
        this.verifyUploadLfsObjectUseCase = verifyUploadLfsObjectUseCase;
        this.authenticateLfsServerWithSshUseCase = authenticateLfsServerWithSshUseCase;
        this.refs = CollectionsKt.emptyList();
    }

    public void setRefs(@NotNull Collection<? extends RemoteRefUpdate> toRefs) {
        Intrinsics.checkNotNullParameter(toRefs, (String)"toRefs");
        this.refs = toRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<LfsPointer> findObjectsToPush() {
        Set toPush = new TreeSet();
        AutoCloseable autoCloseable = (AutoCloseable)new ObjectWalk(this.getRepository());
        Throwable throwable = null;
        try {
            ObjectWalk walk = (ObjectWalk)autoCloseable;
            boolean bl = false;
            for (RemoteRefUpdate remoteRefUpdate2 : this.refs) {
                if (remoteRefUpdate2.isDelete()) continue;
                walk.setRewriteParents(false);
                this.excludeRemoteRefs(walk);
                walk.markStart(walk.parseCommit((AnyObjectId)remoteRefUpdate2.getNewObjectId()));
                while (walk.next() != null) {
                }
                this.findLfsPointers(toPush, walk);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return toPush;
    }

    private final void findLfsPointers(Set<LfsPointer> toPush, ObjectWalk walk) {
        RevObject obj = null;
        ObjectReader r = walk.getObjectReader();
        obj = walk.nextObject();
        while (obj != null) {
            if (obj.getType() == 3) {
                LfsPointer ptr;
                Intrinsics.checkNotNull((Object)r);
                if (this.getObjectSize(r, obj) < 200L && (ptr = this.loadLfsPointer(r, (AnyObjectId)obj)) != null) {
                    toPush.add(ptr);
                }
            }
            obj = walk.nextObject();
        }
    }

    private final long getObjectSize(ObjectReader r, RevObject obj) {
        return r.getObjectSize((AnyObjectId)obj.getId(), 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LfsPointer loadLfsPointer(ObjectReader r, AnyObjectId obj) {
        Closeable closeable = (Closeable)r.open(obj, 3).openStream();
        Throwable throwable = null;
        try {
            ObjectStream is = (ObjectStream)closeable;
            boolean bl = false;
            LfsPointer lfsPointer = LfsPointer.parseLfsPointer((InputStream)((InputStream)is));
            return lfsPointer;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void excludeRemoteRefs(ObjectWalk walk) {
        RefDatabase refDatabase = this.getRepository().getRefDatabase();
        List remoteRefs = refDatabase.getRefsByPrefix(this.remote());
        for (Ref r : remoteRefs) {
            RevObject o;
            ObjectId oid = r.getPeeledObjectId();
            if (oid == null) {
                oid = r.getObjectId();
            }
            if (oid == null || (o = walk.parseAny((AnyObjectId)oid)).getType() != 1 && o.getType() != 4) continue;
            walk.markUninteresting(o);
        }
    }

    private final String remote() {
        String remoteName = this.getRemoteName() == null ? "origin" : this.getRemoteName();
        return "refs/remotes/" + remoteName;
    }

    @NotNull
    public String call() {
        return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            final /* synthetic */ LfsPrePushHook this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                block22: {
                    var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            toPush = LfsPrePushHook.access$findObjectsToPush(this.this$0);
                            if (toPush.isEmpty()) {
                                return "";
                            }
                            if (LfsPrePushHook.access$isDryRun(this.this$0)) break block22;
                            v0 = LfsPrePushHook.access$getGetLfsUrlUseCase$p(this.this$0);
                            v1 = LfsPrePushHook.access$getRepository(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"access$getRepository(...)");
                            this.L$0 = toPush;
                            this.label = 1;
                            v2 = v0.invoke(v1, LfsPrePushHook.access$remote(this.this$0), (Continuation<? super String>)((Continuation)this));
                            if (v2 == var19_2) {
                                return var19_2;
                            }
                            ** GOTO lbl22
                        }
                        case 1: {
                            toPush = (Set)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl22:
                            // 2 sources

                            v3 = (String)v2;
                            if (v3 == null) {
                                throw new Exception("LFS Url not found");
                            }
                            lfsServerUrl = v3;
                            isHttpUrl = StringExtensionsKt.isHttpOrHttps(lfsServerUrl);
                            $this$map$iv = toPush;
                            $i$f$map = false;
                            var8_9 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            var11_13 = $this$mapTo$iv$iv.iterator();
                            while (var11_13.hasNext()) {
                                item$iv$iv /* !! */  = var11_13.next();
                                var13_15 = (LfsPointer)item$iv$iv /* !! */ ;
                                var18_20 = destination$iv$iv;
                                $i$a$-map-LfsPrePushHook$call$1$lfsObjectBatches$1 = false;
                                v4 = it.getOid().name();
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"name(...)");
                                var18_20.add(new LfsObjectBatch(v4, it.getSize()));
                            }
                            lfsObjectBatches = (List)destination$iv$iv;
                            $this$map$iv = null;
                            if (!isHttpUrl) break;
                            finalServerUrl = lfsServerUrl;
                            $this$mapTo$iv$iv = LfsPrePushHook.access$getGetLfsObjectsUseCase$p(this.this$0);
                            var9_10 /* !! */  = OperationType.UPLOAD;
                            v5 = LfsPrePushHook.access$getRepository(this.this$0).getFullBranch();
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getFullBranch(...)");
                            $i$f$mapTo = v5;
                            var11_13 = MapsKt.emptyMap();
                            this.L$0 = toPush;
                            this.L$1 = finalServerUrl;
                            this.label = 2;
                            v6 = $this$mapTo$iv$iv.invoke(lfsServerUrl, (OperationType)var9_10 /* !! */ , $i$f$mapTo, lfsObjectBatches, (Map<String, String>)var11_13, (Continuation<? super Result<LfsObjects, ? extends LfsError>>)((Continuation)this));
                            if (v6 == var19_2) {
                                return var19_2;
                            }
                            ** GOTO lbl66
                        }
                        case 2: {
                            finalServerUrl = (String)this.L$1;
                            toPush = (Set)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl66:
                            // 2 sources

                            $this$map$iv = (Result)v6;
                            ** GOTO lbl102
                        }
                    }
                    this.L$0 = toPush;
                    this.L$1 = lfsObjectBatches;
                    this.label = 3;
                    v7 = LfsPrePushHook.access$getAuthenticateLfsServerWithSshUseCase$p(this.this$0).invoke(lfsServerUrl, OperationType.UPLOAD, (Continuation<? super LfsSshAuthenticateResult>)((Continuation)this));
                    if (v7 == var19_2) {
                        return var19_2;
                    }
                    ** GOTO lbl80
                    {
                        case 3: {
                            lfsObjectBatches = (List)this.L$1;
                            toPush = (Set)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl80:
                            // 2 sources

                            lfsServerInfo = (LfsSshAuthenticateResult)v7;
                            finalServerUrl = lfsServerInfo.getHref();
                            var9_10 /* !! */  = LfsPrePushHook.access$getGetLfsObjectsUseCase$p(this.this$0);
                            $i$f$mapTo = lfsServerInfo.getHref();
                            var11_13 = OperationType.UPLOAD;
                            v8 = LfsPrePushHook.access$getRepository(this.this$0).getFullBranch();
                            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getFullBranch(...)");
                            item$iv$iv /* !! */  = v8;
                            it = lfsServerInfo.getHeader();
                            this.L$0 = toPush;
                            this.L$1 = finalServerUrl;
                            this.label = 4;
                            v9 = var9_10 /* !! */ .invoke($i$f$mapTo, (OperationType)var11_13, item$iv$iv /* !! */ , lfsObjectBatches, it, (Continuation<? super Result<LfsObjects, ? extends LfsError>>)((Continuation)this));
                            if (v9 == var19_2) {
                                return var19_2;
                            }
                            ** GOTO lbl101
                        }
                        case 4: {
                            finalServerUrl = (String)this.L$1;
                            toPush = (Set)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v9 = $result;
lbl101:
                            // 2 sources

                            lfsObjects = (Result)v9;
lbl102:
                            // 2 sources

                            var8_9 = lfsObjects;
                            if (var8_9 instanceof Result.Err) {
                                throw new LfsException("Gettings LFS objects failed with error: " + ((Result.Err)lfsObjects).getError());
                            }
                            if (!(var8_9 instanceof Result.Ok)) break;
                            var9_10 /* !! */  = toPush.iterator();
lbl107:
                            // 3 sources

                            while (var9_10 /* !! */ .hasNext()) {
                                p = (LfsPointer)var9_10 /* !! */ .next();
                                $this$firstOrNull$iv = ((LfsObjects)((Result.Ok)lfsObjects).getValue()).getObjects();
                                $i$f$firstOrNull = false;
                                for (E element$iv : $this$firstOrNull$iv) {
                                    it = (LfsObject)element$iv;
                                    $i$a$-firstOrNull-LfsPrePushHook$call$1$lfsObject$1 = false;
                                    if (!Intrinsics.areEqual((Object)it.getOid(), (Object)p.getOid().name())) continue;
                                    v10 = element$iv;
                                    ** GOTO lbl118
                                }
                                v10 = null;
lbl118:
                                // 2 sources

                                if ((lfsObject = (LfsObject)v10) == null) continue;
                                v11 = LfsPrePushHook.access$getUploadLfsObjectUseCase$p(this.this$0);
                                v12 = LfsPrePushHook.access$getRepository(this.this$0);
                                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"access$getRepository(...)");
                                v13 = p.getOid();
                                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"getOid(...)");
                                this.L$0 = lfsObjects;
                                this.L$1 = finalServerUrl;
                                this.L$2 = var9_10 /* !! */ ;
                                this.L$3 = p;
                                this.L$4 = lfsObject;
                                this.label = 5;
                                v14 = v11.invoke(finalServerUrl, lfsObject, v12, v13, (Continuation<? super Result<Unit, ? extends LfsError>>)((Continuation)this));
                                if (v14 == var19_2) {
                                    return var19_2;
                                }
                                ** GOTO lbl143
                            }
                            break block22;
                        }
                        case 5: {
                            lfsObject = (LfsObject)this.L$4;
                            p = (LfsPointer)this.L$3;
                            var9_10 /* !! */  = (Iterator)this.L$2;
                            finalServerUrl = (String)this.L$1;
                            lfsObjects = (Result)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v14 = $result;
lbl143:
                            // 2 sources

                            if ((uploadResult = (Result)v14) instanceof Result.Err) {
                                throw new LfsException("Objects upload failed: " + ((Result.Err)uploadResult).getError());
                            }
                            v15 = LfsPrePushHook.access$getVerifyUploadLfsObjectUseCase$p(this.this$0);
                            var14_19 = p.getOid();
                            Intrinsics.checkNotNullExpressionValue((Object)var14_19, (String)"getOid(...)");
                            this.L$0 = lfsObjects;
                            this.L$1 = finalServerUrl;
                            this.L$2 = var9_10 /* !! */ ;
                            this.L$3 = null;
                            this.L$4 = null;
                            this.label = 6;
                            v16 = v15.invoke(finalServerUrl, lfsObject, var14_19, (Continuation<? super Result<Unit, ? extends LfsError>>)((Continuation)this));
                            if (v16 == var19_2) {
                                return var19_2;
                            }
                            ** GOTO lbl164
                        }
                        case 6: {
                            var9_10 /* !! */  = (Iterator)this.L$2;
                            finalServerUrl = (String)this.L$1;
                            lfsObjects = (Result)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v16 = $result;
lbl164:
                            // 2 sources

                            if (!((verifyResult = (Result)v16) instanceof Result.Err)) ** GOTO lbl107
                            throw new LfsException("Objects verification failed: " + ((Result.Err)verifyResult).getError());
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return "";
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ Set access$findObjectsToPush(LfsPrePushHook $this) {
        return $this.findObjectsToPush();
    }

    public static final /* synthetic */ boolean access$isDryRun(LfsPrePushHook $this) {
        return $this.isDryRun();
    }

    public static final /* synthetic */ GetLfsUrlUseCase access$getGetLfsUrlUseCase$p(LfsPrePushHook $this) {
        return $this.getLfsUrlUseCase;
    }

    public static final /* synthetic */ Repository access$getRepository(LfsPrePushHook $this) {
        return $this.getRepository();
    }

    public static final /* synthetic */ String access$remote(LfsPrePushHook $this) {
        return $this.remote();
    }

    public static final /* synthetic */ GetLfsObjectsUseCase access$getGetLfsObjectsUseCase$p(LfsPrePushHook $this) {
        return $this.getLfsObjectsUseCase;
    }

    public static final /* synthetic */ AuthenticateLfsServerWithSshUseCase access$getAuthenticateLfsServerWithSshUseCase$p(LfsPrePushHook $this) {
        return $this.authenticateLfsServerWithSshUseCase;
    }

    public static final /* synthetic */ UploadLfsObjectUseCase access$getUploadLfsObjectUseCase$p(LfsPrePushHook $this) {
        return $this.uploadLfsObjectUseCase;
    }

    public static final /* synthetic */ VerifyUploadLfsObjectUseCase access$getVerifyUploadLfsObjectUseCase$p(LfsPrePushHook $this) {
        return $this.verifyUploadLfsObjectUseCase;
    }
}

