/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.lfs;

import androidx.compose.runtime.internal.StabilityInferred;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.lfs.Lfs;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lfs.errors.CorruptMediaFile;
import org.eclipse.jgit.lfs.internal.AtomicObjectOutputStream;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetpackduba/gitnuro/lfs/LfsCleanFilter;", "Lorg/eclipse/jgit/attributes/FilterCommand;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "<init>", "(Lorg/eclipse/jgit/lib/Repository;Ljava/io/InputStream;Ljava/io/OutputStream;)V", "lfs", "Lorg/eclipse/jgit/lfs/Lfs;", "size", "", "tmpFile", "Ljava/nio/file/Path;", "getTmpFile", "()Ljava/nio/file/Path;", "tmpFile$delegate", "Lkotlin/Lazy;", "aOut", "Lorg/eclipse/jgit/lfs/internal/AtomicObjectOutputStream;", "run", "", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class LfsCleanFilter
extends FilterCommand {
    @NotNull
    private final Lfs lfs;
    private long size;
    @NotNull
    private final Lazy tmpFile$delegate;
    @Nullable
    private AtomicObjectOutputStream aOut;
    @NotNull
    private final InputStream input;
    public static final int $stable = 8;

    @AssistedInject
    public LfsCleanFilter(@Assisted @NotNull Repository repository, @Assisted @NotNull InputStream input, @Assisted @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super(input, output);
        this.lfs = new Lfs(repository);
        this.tmpFile$delegate = LazyKt.lazy(() -> LfsCleanFilter.tmpFile_delegate$lambda$0(this));
        this.aOut = new AtomicObjectOutputStream(this.getTmpFile().toAbsolutePath());
        InputStream inputStream = this.in;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"in");
        this.input = inputStream;
    }

    private final Path getTmpFile() {
        Lazy lazy = this.tmpFile$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Path)object;
    }

    public int run() throws IOException {
        try {
            byte[] buf = new byte[8192];
            int length = this.input.read(buf);
            if (length != -1) {
                AtomicObjectOutputStream atomicObjectOutputStream = this.aOut;
                if (atomicObjectOutputStream != null) {
                    atomicObjectOutputStream.write(buf, 0, length);
                }
                this.size += (long)length;
                return length;
            }
            AtomicObjectOutputStream atomicObjectOutputStream = this.aOut;
            if (atomicObjectOutputStream != null) {
                atomicObjectOutputStream.close();
            }
            AtomicObjectOutputStream atomicObjectOutputStream2 = this.aOut;
            Object object = atomicObjectOutputStream2 != null ? atomicObjectOutputStream2.getId() : null;
            if (object == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            AnyLongObjectId oid = object;
            this.aOut = null;
            Path mediaFile = this.lfs.getMediaFile(oid);
            if (Files.isRegularFile(mediaFile, new LinkOption[0])) {
                long fsSize = Files.size(mediaFile);
                if (fsSize != this.size) {
                    throw new CorruptMediaFile(mediaFile, this.size, fsSize);
                }
                FileUtils.delete((File)this.getTmpFile().toFile());
            } else {
                Path parent = mediaFile.getParent();
                if (parent != null) {
                    FileUtils.mkdirs((File)parent.toFile(), (boolean)true);
                }
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                FileUtils.rename((File)this.getTmpFile().toFile(), (File)mediaFile.toFile(), (CopyOption[])copyOptionArray);
            }
            LfsPointer lfsPointer = new LfsPointer(oid, this.size);
            lfsPointer.encode(this.out);
            this.input.close();
            this.out.close();
            return -1;
        }
        catch (IOException e) {
            AtomicObjectOutputStream atomicObjectOutputStream = this.aOut;
            if (atomicObjectOutputStream != null) {
                atomicObjectOutputStream.abort();
            }
            this.input.close();
            this.out.close();
            throw e;
        }
    }

    private static final Path tmpFile_delegate$lambda$0(LfsCleanFilter this$0) {
        Files.createDirectories(this$0.lfs.getLfsTmpDir(), new FileAttribute[0]);
        return this$0.lfs.createTmpFile();
    }
}

