/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.lfs;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.extensions.StringExtensionsKt;
import com.jetpackduba.gitnuro.git.branches.GetCurrentBranchUseCase;
import com.jetpackduba.gitnuro.git.branches.GetTrackingBranchUseCase;
import com.jetpackduba.gitnuro.lfs.GetLfsUrlUseCase;
import com.jetpackduba.gitnuro.logging.LoggerKt;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0086B\u00a2\u0006\u0002\u0010\rJ\"\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0082@\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetpackduba/gitnuro/lfs/GetLfsUrlUseCase;", "", "getTrackingBranchUseCase", "Lcom/jetpackduba/gitnuro/git/branches/GetTrackingBranchUseCase;", "getCurrentBranchUseCase", "Lcom/jetpackduba/gitnuro/git/branches/GetCurrentBranchUseCase;", "<init>", "(Lcom/jetpackduba/gitnuro/git/branches/GetTrackingBranchUseCase;Lcom/jetpackduba/gitnuro/git/branches/GetCurrentBranchUseCase;)V", "invoke", "", "repository", "Lorg/eclipse/jgit/lib/Repository;", "remoteName", "(Lorg/eclipse/jgit/lib/Repository;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLfsUrlFromRemote", "git", "Lorg/eclipse/jgit/api/Git;", "(Lorg/eclipse/jgit/api/Git;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Gitnuro"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nGetLfsUrlUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetLfsUrlUseCase.kt\ncom/jetpackduba/gitnuro/lfs/GetLfsUrlUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n295#2,2:69\n*S KotlinDebug\n*F\n+ 1 GetLfsUrlUseCase.kt\ncom/jetpackduba/gitnuro/lfs/GetLfsUrlUseCase\n*L\n58#1:69,2\n*E\n"})
public final class GetLfsUrlUseCase {
    @NotNull
    private final GetTrackingBranchUseCase getTrackingBranchUseCase;
    @NotNull
    private final GetCurrentBranchUseCase getCurrentBranchUseCase;
    public static final int $stable;

    @Inject
    public GetLfsUrlUseCase(@NotNull GetTrackingBranchUseCase getTrackingBranchUseCase, @NotNull GetCurrentBranchUseCase getCurrentBranchUseCase) {
        Intrinsics.checkNotNullParameter((Object)getTrackingBranchUseCase, (String)"getTrackingBranchUseCase");
        Intrinsics.checkNotNullParameter((Object)getCurrentBranchUseCase, (String)"getCurrentBranchUseCase");
        this.getTrackingBranchUseCase = getTrackingBranchUseCase;
        this.getCurrentBranchUseCase = getCurrentBranchUseCase;
    }

    @Nullable
    public final Object invoke(@NotNull Repository repository, @Nullable String remoteName, @NotNull Continuation<? super String> $completion) {
        String lfsConfigUrl;
        Git git = new Git(repository);
        File configFile = new File(repository.getWorkTree(), ".lfsconfig");
        FileBasedConfig config = new FileBasedConfig(configFile, repository.getFS());
        config.load();
        String string2 = lfsConfigUrl = config.getString("lfs", null, "url");
        if (string2 == null) {
            return this.getLfsUrlFromRemote(git, remoteName, $completion);
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getLfsUrlFromRemote(Git var1_1, String var2_2, Continuation<? super String> $completion) {
        if (!($completion instanceof getLfsUrlFromRemote.1)) ** GOTO lbl-1000
        var14_4 = $completion;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GetLfsUrlUseCase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GetLfsUrlUseCase.access$getLfsUrlFromRemote(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (remoteName == null) ** GOTO lbl15
                v0 = remoteName;
                ** GOTO lbl35
lbl15:
                // 1 sources

                $continuation.L$0 = git;
                $continuation.label = 1;
                v1 = this.getCurrentBranchUseCase.invoke(git, (Continuation<? super Ref>)$continuation);
                if (v1 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                git = (Git)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl25:
                // 2 sources

                if ((currentBranch = (Ref)v1) == null) {
                    LoggerKt.printError$default("LfsRepository", "Current branch is null and couldn't obtain tracking branch remote.", null, 4, null);
                    return null;
                }
                v2 = trackingBranch = this.getTrackingBranchUseCase.invoke(git, currentBranch);
                v3 = currentBranchTracedRemote = v2 != null ? v2.getRemote() : null;
                if (currentBranchTracedRemote != null) {
                    v0 = "refs/remotes/" + currentBranchTracedRemote;
                } else {
                    LoggerKt.printError$default("LfsRepository", "Remote name is null and couldn't obtain tracking branch remote.", null, 4, null);
                    return null;
                }
lbl35:
                // 2 sources

                remotePath = v0;
                v4 = var1_1.remoteList().call();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"call(...)");
                $this$firstOrNull$iv = v4;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (RemoteConfig)element$iv;
                    $i$a$-firstOrNull-GetLfsUrlUseCase$getLfsUrlFromRemote$remoteUrl$1 = false;
                    if (!Intrinsics.areEqual((Object)("refs/remotes/" + it.getName()), (Object)remotePath)) continue;
                    v5 = element$iv;
                    ** GOTO lbl47
                }
                v5 = null;
lbl47:
                // 2 sources

                var6_8 = v5;
                v6 = remoteUrl = var6_8 != null && (var7_9 = var6_8.getURIs()) != null ? (URIish)CollectionsKt.firstOrNull((List)var7_9) : null;
                if (remoteUrl == null) ** GOTO lbl-1000
                v7 = remoteUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"toString(...)");
                if (StringExtensionsKt.isHttpOrHttps(v7)) {
                    v8 = remoteUrl + "/info/lfs";
                } else lbl-1000:
                // 2 sources

                {
                    v9 = remoteUrl;
                    v8 = v9 != null ? v9.toString() : null;
                }
                return v8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$getLfsUrlFromRemote(GetLfsUrlUseCase $this, Git git, String remoteName, Continuation $completion) {
        return $this.getLfsUrlFromRemote(git, remoteName, (Continuation<? super String>)$completion);
    }
}

