/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.lfs;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.lfs.LfsCleanFilterFactory;
import com.jetpackduba.gitnuro.lfs.LfsPrePushHookFactory;
import com.jetpackduba.gitnuro.lfs.LfsSmudgeFilterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.lfs.InstallBuiltinLfsCommand;
import org.eclipse.jgit.lfs.LfsBlobFilter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.LfsFactory;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0017J&\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0017J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetpackduba/gitnuro/lfs/AppLfsFactory;", "Lorg/eclipse/jgit/util/LfsFactory;", "lfsPrePushHookFactory", "Lcom/jetpackduba/gitnuro/lfs/LfsPrePushHookFactory;", "lfsSmudgeFilterFactory", "Lcom/jetpackduba/gitnuro/lfs/LfsSmudgeFilterFactory;", "lfsCleanFilterFactory", "Lcom/jetpackduba/gitnuro/lfs/LfsCleanFilterFactory;", "<init>", "(Lcom/jetpackduba/gitnuro/lfs/LfsPrePushHookFactory;Lcom/jetpackduba/gitnuro/lfs/LfsSmudgeFilterFactory;Lcom/jetpackduba/gitnuro/lfs/LfsCleanFilterFactory;)V", "isAvailable", "", "applySmudgeFilter", "Lorg/eclipse/jgit/lib/ObjectLoader;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "loader", "attribute", "Lorg/eclipse/jgit/attributes/Attribute;", "applyCleanFilter", "Lorg/eclipse/jgit/util/LfsFactory$LfsInputStream;", "input", "Ljava/io/InputStream;", "length", "", "getPrePushHook", "Lorg/eclipse/jgit/hooks/PrePushHook;", "repo", "outputStream", "Ljava/io/PrintStream;", "errorStream", "isEnabled", "getInstallCommand", "Lorg/eclipse/jgit/util/LfsFactory$LfsInstallCommand;", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class AppLfsFactory
extends LfsFactory {
    @NotNull
    private final LfsPrePushHookFactory lfsPrePushHookFactory;
    @NotNull
    private final LfsSmudgeFilterFactory lfsSmudgeFilterFactory;
    @NotNull
    private final LfsCleanFilterFactory lfsCleanFilterFactory;
    public static final int $stable = 8;

    @Inject
    public AppLfsFactory(@NotNull LfsPrePushHookFactory lfsPrePushHookFactory, @NotNull LfsSmudgeFilterFactory lfsSmudgeFilterFactory, @NotNull LfsCleanFilterFactory lfsCleanFilterFactory) {
        Intrinsics.checkNotNullParameter((Object)lfsPrePushHookFactory, (String)"lfsPrePushHookFactory");
        Intrinsics.checkNotNullParameter((Object)lfsSmudgeFilterFactory, (String)"lfsSmudgeFilterFactory");
        Intrinsics.checkNotNullParameter((Object)lfsCleanFilterFactory, (String)"lfsCleanFilterFactory");
        this.lfsPrePushHookFactory = lfsPrePushHookFactory;
        this.lfsSmudgeFilterFactory = lfsSmudgeFilterFactory;
        this.lfsCleanFilterFactory = lfsCleanFilterFactory;
        FilterCommandRegistry.register((String)"jgit://builtin/lfs/smudge", (arg_0, arg_1, arg_2) -> AppLfsFactory._init_$lambda$0(this, arg_0, arg_1, arg_2));
        FilterCommandRegistry.register((String)"jgit://builtin/lfs/clean", (arg_0, arg_1, arg_2) -> AppLfsFactory._init_$lambda$1(this, arg_0, arg_1, arg_2));
    }

    public boolean isAvailable() {
        return true;
    }

    @NotNull
    public ObjectLoader applySmudgeFilter(@NotNull Repository repository, @NotNull ObjectLoader loader, @org.jetbrains.annotations.Nullable Attribute attribute) throws IOException {
        ObjectLoader objectLoader;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        if (!this.isEnabled(repository) || attribute != null && !this.isEnabled(repository, attribute)) {
            objectLoader = loader;
        } else {
            ObjectLoader objectLoader2 = LfsBlobFilter.smudgeLfsBlob((Repository)repository, (ObjectLoader)loader);
            Intrinsics.checkNotNull((Object)objectLoader2);
            objectLoader = objectLoader2;
        }
        return objectLoader;
    }

    @NotNull
    public LfsFactory.LfsInputStream applyCleanFilter(@NotNull Repository repository, @NotNull InputStream input, long length, @org.jetbrains.annotations.Nullable Attribute attribute) throws IOException {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.isEnabled(repository, attribute) ? new LfsFactory.LfsInputStream(LfsBlobFilter.cleanLfsBlob((Repository)repository, (InputStream)input)) : new LfsFactory.LfsInputStream(input, length);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public PrePushHook getPrePushHook(@NotNull Repository repo, @org.jetbrains.annotations.Nullable PrintStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        return this.getPrePushHook(repo, outputStream, null);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public PrePushHook getPrePushHook(@NotNull Repository repository, @org.jetbrains.annotations.Nullable PrintStream outputStream, @org.jetbrains.annotations.Nullable PrintStream errorStream) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return this.isEnabled(repository) ? (PrePushHook)this.lfsPrePushHookFactory.create(repository, outputStream, errorStream) : null;
    }

    public boolean isEnabled(@NotNull Repository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return true;
    }

    private final boolean isEnabled(Repository repository, Attribute attribute) {
        return attribute == null ? false : this.isEnabled(repository) && Intrinsics.areEqual((Object)"lfs", (Object)attribute.getValue());
    }

    @NotNull
    public LfsFactory.LfsInstallCommand getInstallCommand() {
        return (LfsFactory.LfsInstallCommand)new InstallBuiltinLfsCommand();
    }

    private static final FilterCommand _init_$lambda$0(AppLfsFactory this$0, Repository repository, InputStream input, OutputStream output) {
        LfsSmudgeFilterFactory lfsSmudgeFilterFactory = this$0.lfsSmudgeFilterFactory;
        Intrinsics.checkNotNull((Object)repository);
        Intrinsics.checkNotNull((Object)input);
        Intrinsics.checkNotNull((Object)output);
        return lfsSmudgeFilterFactory.create(repository, input, output);
    }

    private static final FilterCommand _init_$lambda$1(AppLfsFactory this$0, Repository repository, InputStream input, OutputStream output) {
        LfsCleanFilterFactory lfsCleanFilterFactory = this$0.lfsCleanFilterFactory;
        Intrinsics.checkNotNull((Object)repository);
        Intrinsics.checkNotNull((Object)input);
        Intrinsics.checkNotNull((Object)output);
        return lfsCleanFilterFactory.create(repository, input, output);
    }
}

