/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.stash;

import androidx.compose.runtime.internal.StabilityInferred;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.SkipWorkTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/jetpackduba/gitnuro/git/stash/SnapshotStashCreateCommand;", "Lorg/eclipse/jgit/api/GitCommand;", "Lorg/eclipse/jgit/revwalk/RevCommit;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "indexMessage", "", "workingDirectoryMessage", "ref", "person", "Lorg/eclipse/jgit/lib/PersonIdent;", "includeUntracked", "", "<init>", "(Lorg/eclipse/jgit/lib/Repository;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/eclipse/jgit/lib/PersonIdent;Z)V", "parseCommit", "reader", "Lorg/eclipse/jgit/lib/ObjectReader;", "headId", "Lorg/eclipse/jgit/lib/ObjectId;", "createBuilder", "Lorg/eclipse/jgit/lib/CommitBuilder;", "updateStashRef", "", "commitId", "refLogIdent", "refLogMessage", "head", "Lorg/eclipse/jgit/lib/Ref;", "getHead", "()Lorg/eclipse/jgit/lib/Ref;", "call", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class SnapshotStashCreateCommand
extends GitCommand<RevCommit> {
    @NotNull
    private final String indexMessage;
    @NotNull
    private final String workingDirectoryMessage;
    @NotNull
    private final String ref;
    @NotNull
    private final PersonIdent person;
    private final boolean includeUntracked;
    public static final int $stable = 8;

    public SnapshotStashCreateCommand(@NotNull Repository repository, @NotNull String indexMessage, @NotNull String workingDirectoryMessage, @NotNull String ref, @NotNull PersonIdent person, boolean includeUntracked) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)indexMessage, (String)"indexMessage");
        Intrinsics.checkNotNullParameter((Object)workingDirectoryMessage, (String)"workingDirectoryMessage");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)person, (String)"person");
        super(repository);
        this.indexMessage = indexMessage;
        this.workingDirectoryMessage = workingDirectoryMessage;
        this.ref = ref;
        this.person = person;
        this.includeUntracked = includeUntracked;
    }

    public /* synthetic */ SnapshotStashCreateCommand(Repository repository, String string2, String string3, String string4, PersonIdent personIdent, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "index on {0}: {1} {2}";
        }
        if ((n & 4) != 0) {
            string3 = "Snapshot WIP on {0}: {1} {2}";
        }
        if ((n & 8) != 0) {
            string4 = "refs/stash";
        }
        if ((n & 0x10) != 0) {
            personIdent = new PersonIdent(repository);
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(repository, string2, string3, string4, personIdent, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RevCommit parseCommit(ObjectReader reader, ObjectId headId) throws IOException {
        AutoCloseable autoCloseable = (AutoCloseable)new RevWalk(reader);
        Throwable throwable = null;
        try {
            RevWalk walk = (RevWalk)autoCloseable;
            boolean bl = false;
            RevCommit revCommit = walk.parseCommit((AnyObjectId)headId);
            Intrinsics.checkNotNullExpressionValue((Object)revCommit, (String)"parseCommit(...)");
            RevCommit revCommit2 = revCommit;
            return revCommit2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final CommitBuilder createBuilder() {
        CommitBuilder builder = new CommitBuilder();
        builder.setAuthor(this.person);
        builder.setCommitter(this.person);
        return builder;
    }

    private final void updateStashRef(ObjectId commitId, PersonIdent refLogIdent, String refLogMessage) throws IOException {
        Ref currentRef = this.repo.findRef(this.ref);
        RefUpdate refUpdate = this.repo.updateRef(this.ref);
        refUpdate.setNewObjectId((AnyObjectId)commitId);
        refUpdate.setRefLogIdent(refLogIdent);
        refUpdate.setRefLogMessage(refLogMessage, false);
        refUpdate.setForceRefLog(true);
        Ref ref = currentRef;
        if (ref != null) {
            refUpdate.setExpectedOldObjectId((AnyObjectId)ref.getObjectId());
        } else {
            refUpdate.setExpectedOldObjectId((AnyObjectId)ObjectId.zeroId());
        }
        refUpdate.forceUpdate();
    }

    /*
     * WARNING - void declaration
     */
    private final Ref getHead() throws GitAPIException {
        void var1_1;
        try {
            Ref head = this.repo.exactRef("HEAD");
            if (head == null || head.getObjectId() == null) {
                throw new NoHeadException(JGitText.get().headRequiredToStash);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashFailed, (Throwable)e);
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public RevCommit call() throws GitAPIException {
        this.checkCallable();
        Ref head = this.getHead();
        try {
            AutoCloseable autoCloseable = (AutoCloseable)this.repo.newObjectReader();
            Throwable throwable = null;
            try {
                Ref.ObjectRef commitId;
                ObjectReader reader;
                block47: {
                    reader = (ObjectReader)autoCloseable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)reader);
                    ObjectId objectId = head.getObjectId();
                    Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"getObjectId(...)");
                    RevCommit headCommit = this.parseCommit(reader, objectId);
                    DirCache cache = this.repo.lockDirCache();
                    commitId = new Ref.ObjectRef();
                    try {
                        RevCommit revCommit;
                        Throwable throwable2;
                        AutoCloseable autoCloseable2;
                        block46: {
                            autoCloseable2 = (AutoCloseable)this.repo.newObjectInserter();
                            throwable2 = null;
                            try {
                                RevCommit revCommit2;
                                Throwable throwable3;
                                AutoCloseable autoCloseable3;
                                block45: {
                                    ObjectInserter inserter = (ObjectInserter)autoCloseable2;
                                    boolean bl2 = false;
                                    autoCloseable3 = (AutoCloseable)new TreeWalk(this.repo, reader);
                                    throwable3 = null;
                                    try {
                                        Object[] objectArray;
                                        Object[] workingTreeIterator;
                                        TreeWalk treeWalk = (TreeWalk)autoCloseable3;
                                        boolean bl3 = false;
                                        treeWalk.setRecursive(true);
                                        treeWalk.addTree((AnyObjectId)headCommit.getTree());
                                        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
                                        treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(this.repo));
                                        ((FileTreeIterator)treeWalk.getTree(2, FileTreeIterator.class)).setDirCacheIterator(treeWalk, 1);
                                        treeWalk.setFilter(AndTreeFilter.create((TreeFilter)((TreeFilter)new SkipWorkTreeFilter(1)), (TreeFilter)((TreeFilter)new IndexDiffFilter(1, 2))));
                                        if (!treeWalk.next()) {
                                            RevCommit revCommit3 = null;
                                            RevCommit revCommit4 = revCommit3;
                                            RevCommit revCommit5 = revCommit4;
                                            RevCommit revCommit6 = revCommit5;
                                            return revCommit6;
                                        }
                                        MutableObjectId id = new MutableObjectId();
                                        List wtEdits = new ArrayList();
                                        List wtDeletes = new ArrayList();
                                        List untracked = new ArrayList();
                                        boolean hasChanges = false;
                                        do {
                                            AbstractTreeIterator headIter = treeWalk.getTree(0, AbstractTreeIterator.class);
                                            DirCacheIterator indexIterator = (DirCacheIterator)treeWalk.getTree(1, DirCacheIterator.class);
                                            workingTreeIterator = (Object[])treeWalk.getTree(2, WorkingTreeIterator.class);
                                            if (indexIterator != null && !indexIterator.getDirCacheEntry().isMerged()) {
                                                throw new UnmergedPathsException((Throwable)new UnmergedPathException(indexIterator.getDirCacheEntry()));
                                            }
                                            if (workingTreeIterator != null) {
                                                if (indexIterator == null && headIter == null && !this.includeUntracked) continue;
                                                hasChanges = true;
                                                if (indexIterator != null && workingTreeIterator.idEqual((AbstractTreeIterator)indexIterator) || headIter != null && workingTreeIterator.idEqual(headIter)) continue;
                                                treeWalk.getObjectId(id, 0);
                                                DirCacheEntry entry = new DirCacheEntry(treeWalk.getRawPath());
                                                entry.setLength(workingTreeIterator.getEntryLength());
                                                entry.setLastModified(workingTreeIterator.getEntryLastModifiedInstant());
                                                entry.setFileMode(workingTreeIterator.getEntryFileMode());
                                                long contentLength = workingTreeIterator.getEntryContentLength();
                                                objectArray = workingTreeIterator.openEntryStream();
                                                Throwable throwable4 = null;
                                                try {
                                                    InputStream in = (InputStream)objectArray;
                                                    boolean bl4 = false;
                                                    entry.setObjectId((AnyObjectId)inserter.insert(3, contentLength, in));
                                                    Unit unit = Unit.INSTANCE;
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable4 = throwable5;
                                                    throw throwable5;
                                                }
                                                finally {
                                                    CloseableKt.closeFinally((Closeable)objectArray, (Throwable)throwable4);
                                                }
                                                boolean bl5 = indexIterator == null && headIter == null ? untracked.add(entry) : wtEdits.add(new DirCacheEditor.PathEdit(entry){
                                                    final /* synthetic */ DirCacheEntry $entry;
                                                    {
                                                        this.$entry = $entry;
                                                        super($entry);
                                                    }

                                                    public void apply(DirCacheEntry ent) {
                                                        Intrinsics.checkNotNullParameter((Object)ent, (String)"ent");
                                                        ent.copyMetaData(this.$entry);
                                                    }
                                                });
                                            }
                                            hasChanges = true;
                                            if (workingTreeIterator != null || headIter == null) continue;
                                            String string2 = treeWalk.getPathString();
                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPathString(...)");
                                            wtDeletes.add(string2);
                                        } while (treeWalk.next());
                                        if (!hasChanges) {
                                            RevCommit revCommit7 = null;
                                            revCommit2 = revCommit7;
                                            break block45;
                                        }
                                        String branch = Repository.shortenRefName((String)head.getTarget().getName());
                                        CommitBuilder builder = this.createBuilder();
                                        builder.setParentId((AnyObjectId)headCommit);
                                        builder.setTreeId((AnyObjectId)cache.writeTree(inserter));
                                        workingTreeIterator = new Object[]{branch, headCommit.abbreviate(7).name(), headCommit.getShortMessage()};
                                        builder.setMessage(MessageFormat.format(this.indexMessage, workingTreeIterator));
                                        ObjectId indexCommit = inserter.insert(builder);
                                        ObjectId untrackedCommit = null;
                                        if (!((Collection)untracked).isEmpty()) {
                                            DirCache untrackedDirCache = DirCache.newInCore();
                                            DirCacheBuilder untrackedBuilder = untrackedDirCache.builder();
                                            for (DirCacheEntry entry : untracked) {
                                                untrackedBuilder.add(entry);
                                            }
                                            untrackedBuilder.finish();
                                            builder.setParentIds(new ObjectId[0]);
                                            builder.setTreeId((AnyObjectId)untrackedDirCache.writeTree(inserter));
                                            objectArray = new Object[]{branch, headCommit.abbreviate(7).name(), headCommit.getShortMessage()};
                                            builder.setMessage(MessageFormat.format("untracked files on {0}: {1} {2}", objectArray));
                                            untrackedCommit = inserter.insert(builder);
                                        }
                                        if (!((Collection)wtEdits).isEmpty() || !((Collection)wtDeletes).isEmpty()) {
                                            DirCacheEditor editor = cache.editor();
                                            for (DirCacheEditor.PathEdit edit : wtEdits) {
                                                editor.add(edit);
                                            }
                                            for (String path : wtDeletes) {
                                                editor.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(path));
                                            }
                                            editor.finish();
                                        }
                                        builder.setParentId((AnyObjectId)headCommit);
                                        builder.addParentId((AnyObjectId)indexCommit);
                                        if (untrackedCommit != null) {
                                            builder.addParentId((AnyObjectId)untrackedCommit);
                                        }
                                        Object[] objectArray2 = new Object[]{branch, headCommit.abbreviate(7).name(), headCommit.getShortMessage()};
                                        builder.setMessage(MessageFormat.format(this.workingDirectoryMessage, objectArray2));
                                        builder.setTreeId((AnyObjectId)cache.writeTree(inserter));
                                        ObjectId objectId2 = inserter.insert(builder);
                                        Intrinsics.checkNotNullExpressionValue((Object)objectId2, (String)"insert(...)");
                                        commitId.element = objectId2;
                                        inserter.flush();
                                        ObjectId objectId3 = (ObjectId)commitId.element;
                                        PersonIdent personIdent = builder.getAuthor();
                                        Intrinsics.checkNotNullExpressionValue((Object)personIdent, (String)"getAuthor(...)");
                                        String string3 = builder.getMessage();
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMessage(...)");
                                        this.updateStashRef(objectId3, personIdent, string3);
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable6) {
                                        throwable3 = throwable6;
                                        throw throwable6;
                                    }
                                }
                                revCommit = revCommit2;
                                break block46;
                                Unit unit = Unit.INSTANCE;
                                break block47;
                                finally {
                                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                                }
                            }
                            catch (Throwable throwable7) {
                                throwable2 = throwable7;
                                throw throwable7;
                            }
                        }
                        RevCommit revCommit8 = revCommit;
                        return revCommit8;
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                        }
                    }
                    finally {
                        cache.unlock();
                    }
                }
                RevCommit revCommit = this.parseCommit(reader, (ObjectId)commitId.element);
                return revCommit;
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashFailed, (Throwable)e);
        }
    }
}

