/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.rebase;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002\u00a8\u0006\f"}, d2={"Lcom/jetpackduba/gitnuro/git/rebase/GetCommitFromRebaseLineUseCase;", "", "<init>", "()V", "invoke", "Lorg/eclipse/jgit/revwalk/RevCommit;", "git", "Lorg/eclipse/jgit/api/Git;", "commit", "Lorg/eclipse/jgit/lib/AbbreviatedObjectId;", "shortMessage", "", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class GetCommitFromRebaseLineUseCase {
    public static final int $stable;

    @Inject
    public GetCommitFromRebaseLineUseCase() {
    }

    @Nullable
    public final RevCommit invoke(@NotNull Git git, @NotNull AbbreviatedObjectId commit2, @NotNull String shortMessage) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)shortMessage, (String)"shortMessage");
        try {
            object = CollectionsKt.listOf((Object)git.getRepository().resolve(commit2.name() + "^{commit}"));
        }
        catch (AmbiguousObjectException ex) {
            Collection collection = ex.getCandidates();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCandidates(...)");
            object = CollectionsKt.toList((Iterable)collection);
        }
        List resolvedList = object;
        if (resolvedList.isEmpty()) {
            System.out.println((Object)("Commit search failed for line " + commit2 + " - " + shortMessage));
            return null;
        }
        if (((Collection)resolvedList).size() == 1) {
            ObjectId resolvedId = (ObjectId)CollectionsKt.firstOrNull((List)resolvedList);
            return resolvedId == null ? null : git.getRepository().parseCommit((AnyObjectId)resolvedId);
        }
        System.out.println((Object)("Multiple matching commits for line " + commit2 + " - " + shortMessage));
        for (ObjectId candidateId : resolvedList) {
            RevCommit candidateCommit = git.getRepository().parseCommit((AnyObjectId)candidateId);
            if (!Intrinsics.areEqual((Object)shortMessage, (Object)candidateCommit.getShortMessage())) continue;
            return candidateCommit;
        }
        System.out.println((Object)"None of the matching commits has a matching short message");
        return null;
    }
}

