/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.lfs;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.credentials.SshCredentialsProvider;
import com.jetpackduba.gitnuro.credentials.SshRemoteSession;
import com.jetpackduba.gitnuro.extensions.InputStreamExtensionsKt;
import com.jetpackduba.gitnuro.git.lfs.AuthenticateLfsServerWithSshUseCase;
import com.jetpackduba.gitnuro.lfs.OperationType;
import com.jetpackduba.gitnuro.models.lfs.LfsSshAuthenticateResult;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.eclipse.jgit.lfs.errors.LfsException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B%\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086B\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetpackduba/gitnuro/git/lfs/AuthenticateLfsServerWithSshUseCase;", "", "sshRemoteSessionProvider", "Ljavax/inject/Provider;", "Lcom/jetpackduba/gitnuro/credentials/SshRemoteSession;", "sshCredentialsProvider", "Lcom/jetpackduba/gitnuro/credentials/SshCredentialsProvider;", "<init>", "(Ljavax/inject/Provider;Ljavax/inject/Provider;)V", "json", "Lkotlinx/serialization/json/Json;", "invoke", "Lcom/jetpackduba/gitnuro/models/lfs/LfsSshAuthenticateResult;", "lfsServerUrl", "", "operationType", "Lcom/jetpackduba/gitnuro/lfs/OperationType;", "(Ljava/lang/String;Lcom/jetpackduba/gitnuro/lfs/OperationType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class AuthenticateLfsServerWithSshUseCase {
    @NotNull
    private final Provider<SshRemoteSession> sshRemoteSessionProvider;
    @NotNull
    private final Provider<SshCredentialsProvider> sshCredentialsProvider;
    @NotNull
    private final Json json;
    public static final int $stable = 8;

    @Inject
    public AuthenticateLfsServerWithSshUseCase(@NotNull Provider<SshRemoteSession> sshRemoteSessionProvider, @NotNull Provider<SshCredentialsProvider> sshCredentialsProvider) {
        Intrinsics.checkNotNullParameter(sshRemoteSessionProvider, (String)"sshRemoteSessionProvider");
        Intrinsics.checkNotNullParameter(sshCredentialsProvider, (String)"sshCredentialsProvider");
        this.sshRemoteSessionProvider = sshRemoteSessionProvider;
        this.sshCredentialsProvider = sshCredentialsProvider;
        this.json = JsonKt.Json$default(null, AuthenticateLfsServerWithSshUseCase::json$lambda$0, (int)1, null);
    }

    @Nullable
    public final Object invoke(@NotNull String lfsServerUrl, @NotNull OperationType operationType, @NotNull Continuation<? super LfsSshAuthenticateResult> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LfsSshAuthenticateResult>, Object>(operationType, this, lfsServerUrl, null){
            int label;
            final /* synthetic */ OperationType $operationType;
            final /* synthetic */ AuthenticateLfsServerWithSshUseCase this$0;
            final /* synthetic */ String $lfsServerUrl;
            {
                this.$operationType = $operationType;
                this.this$0 = $receiver;
                this.$lfsServerUrl = $lfsServerUrl;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String operation = switch (invoke.WhenMappings.$EnumSwitchMapping$0[this.$operationType.ordinal()]) {
                            case 1 -> "upload";
                            case 2 -> "download";
                            default -> throw new NoWhenBranchMatchedException();
                        };
                        SshRemoteSession sshRemoteSession = (SshRemoteSession)AuthenticateLfsServerWithSshUseCase.access$getSshRemoteSessionProvider$p(this.this$0).get();
                        URIish uri = new URIish(this.$lfsServerUrl);
                        Object object2 = AuthenticateLfsServerWithSshUseCase.access$getSshCredentialsProvider$p(this.this$0).get();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                        sshRemoteSession.setup(uri, (CredentialsProvider)object2);
                        Process process = sshRemoteSession.exec("git-lfs-authenticate " + uri.getPath() + " " + operation, 0);
                        InputStream inputStream = process.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                        byte[] byArray = InputStreamExtensionsKt.readUntilValue(inputStream, -1);
                        String inputString = new String(byArray, Charsets.UTF_8);
                        Object object3 = process.getErrorStream();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getErrorStream(...)");
                        object3 = InputStreamExtensionsKt.readUntilValue((InputStream)object3, -1);
                        String errorString = new String((byte[])object3, Charsets.UTF_8);
                        if (!StringsKt.isBlank((CharSequence)errorString)) {
                            throw new LfsException(errorString);
                        }
                        if (StringsKt.isBlank((CharSequence)inputString)) {
                            throw new LfsException("SSH LFS Authentication failed, server returned invalid empty data.");
                        }
                        Json this_$iv = AuthenticateLfsServerWithSshUseCase.access$getJson$p(this.this$0);
                        boolean $i$f$decodeFromString = false;
                        this_$iv.getSerializersModule();
                        return this_$iv.decodeFromString((DeserializationStrategy)LfsSshAuthenticateResult.Companion.serializer(), inputString);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LfsSshAuthenticateResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Provider access$getSshRemoteSessionProvider$p(AuthenticateLfsServerWithSshUseCase $this) {
        return $this.sshRemoteSessionProvider;
    }

    public static final /* synthetic */ Provider access$getSshCredentialsProvider$p(AuthenticateLfsServerWithSshUseCase $this) {
        return $this.sshCredentialsProvider;
    }

    public static final /* synthetic */ Json access$getJson$p(AuthenticateLfsServerWithSshUseCase $this) {
        return $this.json;
    }
}

