/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.graph;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.git.graph.GraphNode;
import com.jetpackduba.gitnuro.git.graph.GraphNodeKt;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001#B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0014J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\bH\u0002J\u0014\u0010!\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetpackduba/gitnuro/git/graph/GraphWalk;", "Lorg/eclipse/jgit/revwalk/RevWalk;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "<init>", "(Lorg/eclipse/jgit/lib/Repository;)V", "additionalRefMap", "", "Lorg/eclipse/jgit/lib/AnyObjectId;", "", "Lorg/eclipse/jgit/lib/Ref;", "reverseRefMap", "stashes", "dispose", "", "sort", "revSort", "Lorg/eclipse/jgit/revwalk/RevSort;", "use", "", "createCommit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "id", "next", "Lcom/jetpackduba/gitnuro/git/graph/GraphNode;", "getRefs", "", "commitId", "markStartAllRefs", "prefix", "", "markStartObjectId", "objectId", "markStartStashes", "stashList", "GraphRefComparator", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class GraphWalk
extends RevWalk {
    @Nullable
    private Repository repository;
    @Nullable
    private Map<AnyObjectId, Set<Ref>> additionalRefMap;
    @Nullable
    private Map<AnyObjectId, Set<Ref>> reverseRefMap;
    @NotNull
    private Set<? extends AnyObjectId> stashes;
    public static final int $stable = 8;

    public GraphWalk(@Nullable Repository repository) {
        super(repository);
        this.repository = repository;
        this.additionalRefMap = new HashMap();
        this.stashes = SetsKt.emptySet();
        super.sort(RevSort.TOPO, true);
    }

    public void dispose() {
        super.dispose();
        if (this.reverseRefMap != null) {
            Map<AnyObjectId, Set<Ref>> map2 = this.reverseRefMap;
            if (map2 != null) {
                map2.clear();
            }
            this.reverseRefMap = null;
        }
        if (this.additionalRefMap != null) {
            Map<AnyObjectId, Set<Ref>> map3 = this.additionalRefMap;
            if (map3 != null) {
                map3.clear();
            }
            this.additionalRefMap = null;
        }
        this.repository = null;
    }

    public void sort(@NotNull RevSort revSort, boolean use) {
        Intrinsics.checkNotNullParameter((Object)revSort, (String)"revSort");
        if (!(revSort != RevSort.TOPO || use)) {
            boolean bl = false;
            String string2 = JGitText.get().topologicalSortRequired;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"topologicalSortRequired");
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        super.sort(revSort, use);
    }

    @NotNull
    protected RevCommit createCommit(@NotNull AnyObjectId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new GraphNode(id);
    }

    @Nullable
    public GraphNode next() {
        GraphNode graphNode = (GraphNode)super.next();
        if (graphNode != null) {
            List<Ref> refs = this.getRefs((AnyObjectId)graphNode);
            graphNode.setRefs(refs);
            graphNode.setStash(this.stashes.contains(graphNode));
        }
        return graphNode;
    }

    private final List<Ref> getRefs(AnyObjectId commitId) {
        Repository repository = this.repository;
        Map reverseRefMap = this.reverseRefMap;
        Map<AnyObjectId, Set<Ref>> additionalRefMap = this.additionalRefMap;
        if (reverseRefMap == null && repository != null && additionalRefMap != null) {
            this.reverseRefMap = reverseRefMap = repository.getAllRefsByPeeledObjectId();
            for (Map.Entry entry : additionalRefMap.entrySet()) {
                Set refsSet = (Set)reverseRefMap.get(entry.getKey());
                Set additional = CollectionsKt.toMutableSet((Iterable)((Iterable)entry.getValue()));
                if (refsSet != null) {
                    if (additional.size() == 1) {
                        additional = new HashSet(additional);
                    }
                    additional.addAll(refsSet);
                }
                Map map2 = reverseRefMap;
                Intrinsics.checkNotNull((Object)map2);
                map2.put(entry.getKey(), additional);
            }
            additionalRefMap.clear();
            this.additionalRefMap = additionalRefMap = null;
        }
        if (reverseRefMap == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        Set set = (Set)reverseRefMap.get(commitId);
        if (set == null) {
            return GraphNodeKt.getNO_REFS();
        }
        Set refsSet = set;
        List list = CollectionsKt.toList((Iterable)refsSet);
        CollectionsKt.sortedWith((Iterable)list, (Comparator)new GraphRefComparator());
        return list;
    }

    public final void markStartAllRefs(@NotNull String prefix) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Repository repository = this.repository;
            if (repository == null) break block1;
            Repository repo = repository;
            boolean bl = false;
            for (Ref ref : repo.getRefDatabase().getRefsByPrefix(prefix)) {
                if (ref.isSymbolic()) continue;
                ObjectId objectId = ref.getLeaf().getObjectId();
                Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"getObjectId(...)");
                this.markStartObjectId((AnyObjectId)objectId);
            }
        }
    }

    private final void markStartObjectId(AnyObjectId objectId) {
        try {
            RevObject refTarget;
            RevObject revObject = refTarget = this.parseAny(objectId);
            if (revObject instanceof RevCommit) {
                this.markStart((RevCommit)refTarget);
            } else if (revObject instanceof RevTag) {
                if (((RevTag)refTarget).getObject() instanceof RevCommit) {
                    RevCommit commit2 = this.lookupCommit((AnyObjectId)((RevTag)refTarget).getObject());
                    this.markStart(commit2);
                } else {
                    System.out.println((Object)("Tag " + ((RevTag)refTarget).getTagName() + " is pointing to " + Reflection.getOrCreateKotlinClass(((RevTag)refTarget).getObject().getClass()).getSimpleName()));
                }
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
    }

    public final void markStartStashes(@NotNull List<? extends RevCommit> stashList) {
        Intrinsics.checkNotNullParameter(stashList, (String)"stashList");
        for (RevCommit revCommit : stashList) {
            this.markStartObjectId((AnyObjectId)revCommit);
        }
        this.stashes = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)stashList), GraphWalk::markStartStashes$lambda$2));
    }

    private static final ObjectId markStartStashes$lambda$2(RevCommit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toObjectId();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetpackduba/gitnuro/git/graph/GraphWalk$GraphRefComparator;", "Ljava/util/Comparator;", "Lorg/eclipse/jgit/lib/Ref;", "Lkotlin/Comparator;", "<init>", "(Lcom/jetpackduba/gitnuro/git/graph/GraphWalk;)V", "compare", "", "o1", "o2", "timeOf", "", "revObject", "Lorg/eclipse/jgit/revwalk/RevObject;", "kind", "r", "Gitnuro"})
    public final class GraphRefComparator
    implements Comparator<Ref> {
        @Override
        public int compare(@NotNull Ref o1, @NotNull Ref o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            try {
                RevObject obj1 = GraphWalk.this.parseAny((AnyObjectId)o1.getObjectId());
                RevObject obj2 = GraphWalk.this.parseAny((AnyObjectId)o2.getObjectId());
                Intrinsics.checkNotNull((Object)obj1);
                long t1 = this.timeOf(obj1);
                Intrinsics.checkNotNull((Object)obj2);
                long t2 = this.timeOf(obj2);
                if (t1 > t2) {
                    return -1;
                }
                if (t1 < t2) {
                    return 1;
                }
            }
            catch (IOException obj1) {
                // empty catch block
            }
            int cmp = this.kind(o1) - this.kind(o2);
            if (cmp == 0) {
                String string2 = o1.getName();
                String string3 = o2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                cmp = string2.compareTo(string3);
            }
            return cmp;
        }

        private final long timeOf(RevObject revObject) {
            if (revObject instanceof RevCommit) {
                return ((RevCommit)revObject).getCommitTime();
            }
            if (revObject instanceof RevTag) {
                try {
                    GraphWalk.this.parseBody(revObject);
                }
                catch (IOException e) {
                    return 0L;
                }
                PersonIdent who = ((RevTag)revObject).getTaggerIdent();
                Object object = who;
                return object != null && (object = object.getWhen()) != null ? ((Date)object).getTime() : 0L;
            }
            return 0L;
        }

        private final int kind(Ref r) {
            String string2 = r.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string2, (String)"refs/tags/", (boolean)false, (int)2, null)) {
                return 0;
            }
            String string3 = r.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string3, (String)"refs/heads/", (boolean)false, (int)2, null)) {
                return 1;
            }
            String string4 = r.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            return StringsKt.startsWith$default((String)string4, (String)"refs/remotes/", (boolean)false, (int)2, null) ? 2 : 3;
        }
    }
}

