/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.graph;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.git.graph.GraphLane;
import com.jetpackduba.gitnuro.git.graph.GraphNodeKt;
import com.jetpackduba.gitnuro.git.graph.IGraphNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\tJ\u000e\u0010/\u001a\u00020-2\u0006\u0010.\u001a\u00020\tJ\u000e\u00100\u001a\u00020-2\u0006\u0010.\u001a\u00020\tJ\u0018\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u00002\b\b\u0002\u00103\u001a\u00020(J\b\u00108\u001a\u00020-H\u0016J)\u00109\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010.\u001a\u00020\t2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010;J\u0010\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u000205H\u0016R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\rR\u001a\u0010\u0015\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR \u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010)\"\u0004\b*\u0010+R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u0010<\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u00107\u00a8\u0006@"}, d2={"Lcom/jetpackduba/gitnuro/git/graph/GraphNode;", "Lorg/eclipse/jgit/revwalk/RevCommit;", "Lcom/jetpackduba/gitnuro/git/graph/IGraphNode;", "id", "Lorg/eclipse/jgit/lib/AnyObjectId;", "<init>", "(Lorg/eclipse/jgit/lib/AnyObjectId;)V", "forkingOffLanes", "", "Lcom/jetpackduba/gitnuro/git/graph/GraphLane;", "getForkingOffLanes", "()[Lcom/jetpackduba/gitnuro/git/graph/GraphLane;", "setForkingOffLanes", "([Lcom/jetpackduba/gitnuro/git/graph/GraphLane;)V", "[Lcom/jetpackduba/gitnuro/git/graph/GraphLane;", "passingLanes", "getPassingLanes", "setPassingLanes", "mergingLanes", "getMergingLanes", "setMergingLanes", "lane", "getLane", "()Lcom/jetpackduba/gitnuro/git/graph/GraphLane;", "setLane", "(Lcom/jetpackduba/gitnuro/git/graph/GraphLane;)V", "children", "getChildren", "()[Lcom/jetpackduba/gitnuro/git/graph/GraphNode;", "setChildren", "([Lcom/jetpackduba/gitnuro/git/graph/GraphNode;)V", "[Lcom/jetpackduba/gitnuro/git/graph/GraphNode;", "refs", "", "Lorg/eclipse/jgit/lib/Ref;", "getRefs", "()Ljava/util/List;", "setRefs", "(Ljava/util/List;)V", "isStash", "", "()Z", "setStash", "(Z)V", "addForkingOffLane", "", "graphLane", "addPassingLane", "addMergingLane", "addChild", "c", "addFirst", "childCount", "", "getChildCount", "()I", "reset", "addLane", "lanes", "(Lcom/jetpackduba/gitnuro/git/graph/GraphLane;[Lcom/jetpackduba/gitnuro/git/graph/GraphLane;)[Lcom/jetpackduba/gitnuro/git/graph/GraphLane;", "graphParentCount", "getGraphParentCount", "getGraphParent", "nth", "Gitnuro"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGraphNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphNode.kt\ncom/jetpackduba/gitnuro/git/graph/GraphNode\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,105:1\n37#2:106\n36#2,3:107\n*S KotlinDebug\n*F\n+ 1 GraphNode.kt\ncom/jetpackduba/gitnuro/git/graph/GraphNode\n*L\n53#1:106\n53#1:107,3\n*E\n"})
public class GraphNode
extends RevCommit
implements IGraphNode {
    @NotNull
    private GraphLane[] forkingOffLanes = GraphNodeKt.access$getNO_LANES$p();
    @NotNull
    private GraphLane[] passingLanes = GraphNodeKt.access$getNO_LANES$p();
    @NotNull
    private GraphLane[] mergingLanes = GraphNodeKt.access$getNO_LANES$p();
    @NotNull
    private GraphLane lane = GraphNodeKt.access$getNO_LANE$p();
    @NotNull
    private GraphNode[] children = GraphNodeKt.access$getNO_CHILDREN$p();
    @NotNull
    private List<? extends Ref> refs = GraphNodeKt.getNO_REFS();
    private boolean isStash;
    public static final int $stable = 8;

    public GraphNode(@Nullable AnyObjectId id) {
        super(id);
    }

    @NotNull
    public final GraphLane[] getForkingOffLanes() {
        return this.forkingOffLanes;
    }

    public final void setForkingOffLanes(@NotNull GraphLane[] graphLaneArray) {
        Intrinsics.checkNotNullParameter((Object)graphLaneArray, (String)"<set-?>");
        this.forkingOffLanes = graphLaneArray;
    }

    @NotNull
    public final GraphLane[] getPassingLanes() {
        return this.passingLanes;
    }

    public final void setPassingLanes(@NotNull GraphLane[] graphLaneArray) {
        Intrinsics.checkNotNullParameter((Object)graphLaneArray, (String)"<set-?>");
        this.passingLanes = graphLaneArray;
    }

    @NotNull
    public final GraphLane[] getMergingLanes() {
        return this.mergingLanes;
    }

    public final void setMergingLanes(@NotNull GraphLane[] graphLaneArray) {
        Intrinsics.checkNotNullParameter((Object)graphLaneArray, (String)"<set-?>");
        this.mergingLanes = graphLaneArray;
    }

    @NotNull
    public final GraphLane getLane() {
        return this.lane;
    }

    public final void setLane(@NotNull GraphLane graphLane) {
        Intrinsics.checkNotNullParameter((Object)graphLane, (String)"<set-?>");
        this.lane = graphLane;
    }

    @NotNull
    public final GraphNode[] getChildren() {
        return this.children;
    }

    public final void setChildren(@NotNull GraphNode[] graphNodeArray) {
        Intrinsics.checkNotNullParameter((Object)graphNodeArray, (String)"<set-?>");
        this.children = graphNodeArray;
    }

    @NotNull
    public final List<Ref> getRefs() {
        return this.refs;
    }

    public final void setRefs(@NotNull List<? extends Ref> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.refs = list;
    }

    public final boolean isStash() {
        return this.isStash;
    }

    public final void setStash(boolean bl) {
        this.isStash = bl;
    }

    public final void addForkingOffLane(@NotNull GraphLane graphLane) {
        Intrinsics.checkNotNullParameter((Object)graphLane, (String)"graphLane");
        this.forkingOffLanes = this.addLane(graphLane, this.forkingOffLanes);
    }

    public final void addPassingLane(@NotNull GraphLane graphLane) {
        Intrinsics.checkNotNullParameter((Object)graphLane, (String)"graphLane");
        this.passingLanes = this.addLane(graphLane, this.passingLanes);
    }

    public final void addMergingLane(@NotNull GraphLane graphLane) {
        Intrinsics.checkNotNullParameter((Object)graphLane, (String)"graphLane");
        this.mergingLanes = this.addLane(graphLane, this.mergingLanes);
    }

    public final void addChild(@NotNull GraphNode c, boolean addFirst) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        int childrenCount = this.children.length;
        switch (childrenCount) {
            case 0: {
                GraphNode[] graphNodeArray = new GraphNode[]{c};
                this.children = graphNodeArray;
                break;
            }
            case 1: {
                GraphNode[] graphNodeArray;
                if (c.getId().equals((AnyObjectId)this.children[0].getId())) break;
                if (addFirst) {
                    GraphNode[] graphNodeArray2 = new GraphNode[]{c, this.children[0]};
                    graphNodeArray = graphNodeArray2;
                } else {
                    GraphNode[] graphNodeArray3 = new GraphNode[]{this.children[0], c};
                    graphNodeArray = graphNodeArray3;
                }
                this.children = graphNodeArray;
                break;
            }
            default: {
                GraphNode[] graphNodeArray;
                for (GraphNode pc : this.children) {
                    if (!c.getId().equals((AnyObjectId)pc.getId())) continue;
                    return;
                }
                if (addFirst) {
                    Object[] objectArray = new GraphNode[]{c};
                    List childList = CollectionsKt.mutableListOf((Object[])objectArray);
                    CollectionsKt.addAll((Collection)childList, (Object[])this.children);
                    Collection $this$toTypedArray$iv = childList;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    graphNodeArray = thisCollection$iv.toArray(new GraphNode[0]);
                } else {
                    Object[] objectArray = Arrays.copyOf(this.children, childrenCount + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                    Object[] $this$addChild_u24lambda_u240 = objectArray;
                    boolean bl = false;
                    $this$addChild_u24lambda_u240[childrenCount] = c;
                    graphNodeArray = (GraphNode[])ArraysKt.requireNoNulls((Object[])$this$addChild_u24lambda_u240);
                }
                GraphNode[] resultArray = graphNodeArray;
                this.children = resultArray;
            }
        }
    }

    public static /* synthetic */ void addChild$default(GraphNode graphNode, GraphNode graphNode2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addChild");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        graphNode.addChild(graphNode2, bl);
    }

    public final int getChildCount() {
        return this.children.length;
    }

    public void reset() {
        this.forkingOffLanes = GraphNodeKt.access$getNO_LANES$p();
        this.passingLanes = GraphNodeKt.access$getNO_LANES$p();
        this.mergingLanes = GraphNodeKt.access$getNO_LANES$p();
        this.children = GraphNodeKt.access$getNO_CHILDREN$p();
        this.lane = GraphNodeKt.access$getNO_LANE$p();
        super.reset();
    }

    private final GraphLane[] addLane(GraphLane graphLane, GraphLane[] lanes) {
        GraphLane[] newLines = lanes;
        int linesCount = newLines.length;
        switch (linesCount) {
            case 0: {
                GraphLane[] graphLaneArray = new GraphLane[]{graphLane};
                newLines = graphLaneArray;
                break;
            }
            case 1: {
                GraphLane[] graphLaneArray = new GraphLane[]{newLines[0], graphLane};
                newLines = graphLaneArray;
                break;
            }
            default: {
                Object[] objectArray = Arrays.copyOf(newLines, linesCount + 1);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                Object[] $this$addLane_u24lambda_u241 = objectArray;
                boolean bl = false;
                $this$addLane_u24lambda_u241[linesCount] = graphLane;
                GraphLane[] n = (GraphLane[])ArraysKt.requireNoNulls((Object[])$this$addLane_u24lambda_u241);
                newLines = n;
            }
        }
        return newLines;
    }

    @Override
    public int getGraphParentCount() {
        return this.getParentCount();
    }

    @Override
    @NotNull
    public GraphNode getGraphParent(int nth) {
        RevCommit revCommit = this.getParent(nth);
        Intrinsics.checkNotNull((Object)revCommit, (String)"null cannot be cast to non-null type com.jetpackduba.gitnuro.git.graph.GraphNode");
        return (GraphNode)revCommit;
    }
}

