/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.graph;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.git.graph.GraphLane;
import com.jetpackduba.gitnuro.git.graph.GraphNode;
import com.jetpackduba.gitnuro.git.graph.GraphWalk;
import com.jetpackduba.gitnuro.git.graph.UncommittedChangesGraphNode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\rJ\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0002H\u0002J\"\u0010(\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u00022\b\u0010*\u001a\u0004\u0018\u00010\u0002H\u0002J2\u0010+\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00022\b\u0010*\u001a\u0004\u0018\u00010\u00022\u0006\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u0012H\u0002J \u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0012H\u0002J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u0012H\u0002J\u0010\u00103\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0002H\u0002J\u0014\u00104\u001a\u00020\u00122\n\b\u0002\u00105\u001a\u0004\u0018\u000106H\u0002J\u0012\u00107\u001a\u00020\r2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u001a\u00108\u001a\u00020\u001e2\u0006\u00105\u001a\u0002062\b\u00109\u001a\u0004\u0018\u00010\u0002H\u0002J\u0006\u0010:\u001a\u00020\u001eJ\u0011\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0002H\u0096\u0001J\u0019\u0010;\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\r2\u0006\u0010=\u001a\u00020\u0002H\u0096\u0001J\u0017\u0010>\u001a\u00020<2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020@H\u0096\u0001J\u001f\u0010>\u001a\u00020<2\u0006\u0010%\u001a\u00020\r2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020@H\u0096\u0001J\u0011\u0010A\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0002H\u0096\u0003J\u0017\u0010B\u001a\u00020<2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020@H\u0096\u0001J\u0011\u0010C\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\rH\u0096\u0003J\u0011\u0010D\u001a\u00020\r2\u0006\u0010=\u001a\u00020\u0002H\u0096\u0001J\t\u0010E\u001a\u00020<H\u0096\u0001J\u000f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00020GH\u0096\u0003J\u0011\u0010H\u001a\u00020\r2\u0006\u0010=\u001a\u00020\u0002H\u0096\u0001J\u000f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00020JH\u0096\u0001J\u0017\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00020J2\u0006\u0010%\u001a\u00020\rH\u0096\u0001J\u0011\u0010K\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0002H\u0096\u0001J\u0017\u0010L\u001a\u00020<2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020@H\u0096\u0001J\u0011\u0010M\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\rH\u0096\u0001J\u0017\u0010N\u001a\u00020<2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00020@H\u0096\u0001J\u0019\u0010O\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\r2\u0006\u0010=\u001a\u00020\u0002H\u0096\u0003J\u001f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010Q\u001a\u00020\r2\u0006\u0010R\u001a\u00020\rH\u0096\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\t\u0010S\u001a\u00020\rX\u0096\u0005\u00a8\u0006T"}, d2={"Lcom/jetpackduba/gitnuro/git/graph/GraphCommitList;", "", "Lcom/jetpackduba/gitnuro/git/graph/GraphNode;", "commits", "<init>", "(Ljava/util/List;)V", "walker", "Lcom/jetpackduba/gitnuro/git/graph/GraphWalk;", "getWalker", "()Lcom/jetpackduba/gitnuro/git/graph/GraphWalk;", "setWalker", "(Lcom/jetpackduba/gitnuro/git/graph/GraphWalk;)V", "positionsAllocated", "", "freePositions", "Ljava/util/TreeSet;", "activeLanes", "Ljava/util/HashSet;", "Lcom/jetpackduba/gitnuro/git/graph/GraphLane;", "parentId", "Lorg/eclipse/jgit/lib/AnyObjectId;", "graphCommit", "Lcom/jetpackduba/gitnuro/git/graph/UncommittedChangesGraphNode;", "value", "maxLine", "getMaxLine", "()I", "laneLength", "Ljava/util/HashMap;", "clear", "", "fillTo", "highMark", "addUncommittedChangesGraphCommit", "parent", "Lorg/eclipse/jgit/revwalk/RevCommit;", "enter", "index", "currCommit", "continueActiveLanes", "handleBlockedLanes", "currentNode", "childOnLane", "handleMerge", "child", "laneToUse", "drawLaneToChild", "commitIndex", "laneToContinue", "closeLane", "lane", "setupChildren", "nextFreeLane", "blockedPositions", "Ljava/util/BitSet;", "getFreePosition", "addBlockedPosition", "graphNode", "calcMaxLine", "add", "", "element", "addAll", "elements", "", "contains", "containsAll", "get", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "subList", "fromIndex", "toIndex", "size", "Gitnuro"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGraphCommitList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphCommitList.kt\ncom/jetpackduba/gitnuro/git/graph/GraphCommitList\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,393:1\n1310#2,2:394\n6482#2:396\n1#3:397\n*S KotlinDebug\n*F\n+ 1 GraphCommitList.kt\ncom/jetpackduba/gitnuro/git/graph/GraphCommitList\n*L\n56#1:394,2\n129#1:396\n*E\n"})
public final class GraphCommitList
implements List<GraphNode>,
KMutableList {
    @NotNull
    private final List<GraphNode> commits;
    @Nullable
    private GraphWalk walker;
    private int positionsAllocated;
    @NotNull
    private final TreeSet<Integer> freePositions;
    @NotNull
    private final HashSet<GraphLane> activeLanes;
    @Nullable
    private AnyObjectId parentId;
    @NotNull
    private final UncommittedChangesGraphNode graphCommit;
    private int maxLine;
    @NotNull
    private final HashMap<GraphLane, Integer> laneLength;
    public static final int $stable = 8;

    public GraphCommitList(@NotNull List<GraphNode> commits) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        this.commits = commits;
        this.freePositions = new TreeSet();
        this.activeLanes = new HashSet(32);
        this.graphCommit = new UncommittedChangesGraphNode();
        this.laneLength = new HashMap(32);
    }

    public /* synthetic */ GraphCommitList(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        this(list);
    }

    @Nullable
    public final GraphWalk getWalker() {
        return this.walker;
    }

    public final void setWalker(@Nullable GraphWalk graphWalk) {
        this.walker = graphWalk;
    }

    public final int getMaxLine() {
        return this.maxLine;
    }

    @Override
    public void clear() {
        this.positionsAllocated = 0;
        this.freePositions.clear();
        this.activeLanes.clear();
        this.laneLength.clear();
        this.commits.clear();
    }

    public final void fillTo(int highMark) {
        if (this.size() <= highMark) {
            GraphNode c = null;
            do {
                GraphNode stashChild;
                block5: {
                    GraphNode graphNode;
                    GraphWalk graphWalk = this.walker;
                    GraphNode graphNode2 = c = graphWalk != null ? graphWalk.next() : null;
                    if (c == null) continue;
                    GraphNode[] $this$firstOrNull$iv = c.getChildren();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        GraphNode element$iv;
                        GraphNode it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!it.isStash()) continue;
                        graphNode = element$iv;
                        break block5;
                    }
                    graphNode = stashChild = null;
                }
                if (stashChild != null) {
                    RevCommit[] revCommitArray = stashChild.getParents();
                    Intrinsics.checkNotNullExpressionValue((Object)revCommitArray, (String)"getParents(...)");
                    if (!Intrinsics.areEqual((Object)ArraysKt.firstOrNull((Object[])revCommitArray), (Object)c)) continue;
                }
                this.enter(this.size(), c);
                this.add(c);
            } while (c != null && this.size() <= highMark);
            if (c == null) {
                this.walker = null;
            }
        }
    }

    public final void addUncommittedChangesGraphCommit(@NotNull RevCommit parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parentId = (AnyObjectId)parent.getId();
        this.graphCommit.setLane(GraphCommitList.nextFreeLane$default(this, null, 1, null));
    }

    public final void enter(int index, @NotNull GraphNode currCommit) {
        block10: {
            int lengthOfReservedLane;
            GraphNode childOnReservedLane;
            GraphLane reservedLane;
            int nChildren;
            block13: {
                block12: {
                    boolean isUncommittedChangesNodeParent;
                    block11: {
                        Integer len;
                        block9: {
                            Intrinsics.checkNotNullParameter((Object)currCommit, (String)"currCommit");
                            isUncommittedChangesNodeParent = false;
                            if (Intrinsics.areEqual((Object)currCommit.getId(), (Object)this.parentId)) {
                                this.graphCommit.setGraphParent(currCommit);
                                currCommit.addChild(this.graphCommit, true);
                                isUncommittedChangesNodeParent = true;
                            }
                            this.setupChildren(currCommit);
                            nChildren = currCommit.getChildCount();
                            if (nChildren != 0) break block9;
                            currCommit.setLane(GraphCommitList.nextFreeLane$default(this, null, 1, null));
                            break block10;
                        }
                        if (nChildren != 1 || currCommit.getChildren()[0].getGraphParentCount() >= 2) break block11;
                        GraphNode graphNode = currCommit.getChildren()[0];
                        currCommit.setLane(graphNode.getLane());
                        Integer n = len = this.laneLength.get(currCommit.getLane());
                        Integer n2 = len = n != null ? Integer.valueOf(n + 1) : Integer.valueOf(0);
                        if (currCommit.getLane().getPosition() != -1) {
                            ((Map)this.laneLength).put(currCommit.getLane(), len);
                        }
                        break block10;
                    }
                    reservedLane = null;
                    childOnReservedLane = null;
                    lengthOfReservedLane = -1;
                    if (!isUncommittedChangesNodeParent) break block12;
                    Integer length = this.laneLength.get(this.graphCommit.getLane());
                    if (length == null) break block13;
                    reservedLane = this.graphCommit.getLane();
                    childOnReservedLane = this.graphCommit;
                    lengthOfReservedLane = length;
                    break block13;
                }
                GraphNode[] $this$sortedBy$iv = currCommit.getChildren();
                boolean $i$f$sortedBy = false;
                List children = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        GraphNode it = (GraphNode)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getLane().getPosition());
                        it = (GraphNode)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getLane().getPosition()));
                    }
                });
                for (GraphNode child : children) {
                    Integer length;
                    if (child.getGraphParent(0) != currCommit) continue;
                    if (child.getLane().getPosition() < 0) {
                        System.out.println((Object)("child.lane.position is invalid (" + child.getLane().getPosition() + ")"));
                    }
                    if ((length = this.laneLength.get(child.getLane())) == null || length <= lengthOfReservedLane) continue;
                    reservedLane = child.getLane();
                    childOnReservedLane = child;
                    lengthOfReservedLane = length;
                    break;
                }
            }
            if (reservedLane != null) {
                currCommit.setLane(reservedLane);
                ((Map)this.laneLength).put(reservedLane, lengthOfReservedLane + 1);
                this.handleBlockedLanes(index, currCommit, childOnReservedLane);
            } else {
                currCommit.setLane(GraphCommitList.nextFreeLane$default(this, null, 1, null));
                this.handleBlockedLanes(index, currCommit, null);
            }
            for (int i = 0; i < nChildren; ++i) {
                GraphNode graphNode = currCommit.getChildren()[i];
                GraphNode firstParent = graphNode.getGraphParent(0);
                if (firstParent.getLane().getPosition() == -1 || firstParent.getLane() == graphNode.getLane()) continue;
                this.closeLane(graphNode.getLane());
            }
        }
        this.continueActiveLanes(currCommit);
        if (currCommit.getParentCount() == 0 && currCommit.getLane().getPosition() == -1) {
            this.closeLane(currCommit.getLane());
        }
        if (currCommit.getChildCount() == 1 && ((GraphNode)ArraysKt.first((Object[])currCommit.getChildren())).isStash() && currCommit.getParentCount() == 0) {
            this.closeLane(currCommit.getLane());
        }
    }

    private final void continueActiveLanes(GraphNode currCommit) {
        Iterator<GraphLane> iterator = this.activeLanes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<GraphLane> iterator2 = iterator;
        while (iterator2.hasNext()) {
            GraphLane lane;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (lane == currCommit.getLane()) continue;
            currCommit.addPassingLane(lane);
        }
    }

    private final void handleBlockedLanes(int index, GraphNode currentNode, GraphNode childOnLane) {
        for (GraphNode child : currentNode.getChildren()) {
            GraphLane laneToUse;
            boolean childIsMerge;
            if (child == childOnLane) continue;
            boolean bl = childIsMerge = child.getGraphParent(0) != currentNode;
            if (childIsMerge) {
                laneToUse = currentNode.getLane();
                laneToUse = this.handleMerge(index, currentNode, childOnLane, child, laneToUse);
                child.addMergingLane(laneToUse);
                continue;
            }
            laneToUse = child.getLane();
            currentNode.addForkingOffLane(laneToUse);
        }
    }

    private final GraphLane handleMerge(int index, GraphNode currCommit, GraphNode childOnLane, GraphNode child, GraphLane laneToUse) {
        GraphLane newLaneToUse = laneToUse;
        int childIndex = index;
        BitSet blockedPositions = new BitSet();
        for (int r = index - 1; -1 < r; --r) {
            GraphNode graphNode = this.get(r);
            if (graphNode == child) {
                childIndex = r;
                break;
            }
            this.addBlockedPosition(blockedPositions, graphNode);
        }
        if (blockedPositions.get(newLaneToUse.getPosition())) {
            int r;
            int n;
            boolean needDetour = false;
            if (childOnLane != null && (n = childIndex + 1) <= (r = index - 1)) {
                while (true) {
                    GraphNode graphNode;
                    if ((graphNode = this.get(r)) == childOnLane) {
                        needDetour = true;
                        break;
                    }
                    if (r == n) break;
                    --r;
                }
            }
            if (needDetour) {
                newLaneToUse = this.nextFreeLane(blockedPositions);
                currCommit.addForkingOffLane(newLaneToUse);
                this.closeLane(newLaneToUse);
            } else {
                int newPos = this.getFreePosition(blockedPositions);
                this.freePositions.add(newLaneToUse.getPosition());
                newLaneToUse.setPosition(newPos);
            }
        }
        this.drawLaneToChild(index, child, newLaneToUse);
        return newLaneToUse;
    }

    private final void drawLaneToChild(int commitIndex, GraphNode child, GraphLane laneToContinue) {
        GraphNode graphNode;
        for (int index = commitIndex - 1; -1 < index && (graphNode = this.get(index)) != child; --index) {
            GraphNode graphNode2 = graphNode;
            if (graphNode2 == null) continue;
            graphNode2.addPassingLane(laneToContinue);
        }
    }

    private final void closeLane(GraphLane lane) {
        if (this.activeLanes.remove(lane)) {
            this.laneLength.remove(lane);
            this.freePositions.add(lane.getPosition());
        }
    }

    private final void setupChildren(GraphNode currCommit) {
        Iterator iterator = ArrayIteratorKt.iterator((Object[])currCommit.getParents());
        while (iterator.hasNext()) {
            RevCommit parent = (RevCommit)iterator.next();
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type com.jetpackduba.gitnuro.git.graph.GraphNode");
            GraphNode.addChild$default((GraphNode)parent, currCommit, false, 2, null);
        }
    }

    private final GraphLane nextFreeLane(BitSet blockedPositions) {
        GraphLane newPlotLane = new GraphLane(this.getFreePosition(blockedPositions));
        this.activeLanes.add(newPlotLane);
        ((Map)this.laneLength).put(newPlotLane, 1);
        return newPlotLane;
    }

    static /* synthetic */ GraphLane nextFreeLane$default(GraphCommitList graphCommitList, BitSet bitSet, int n, Object object) {
        if ((n & 1) != 0) {
            bitSet = null;
        }
        return graphCommitList.nextFreeLane(bitSet);
    }

    private final int getFreePosition(BitSet blockedPositions) {
        if (this.freePositions.isEmpty()) {
            int n = this.positionsAllocated;
            this.positionsAllocated = n + 1;
            return n;
        }
        if (blockedPositions != null) {
            Iterator<Integer> iterator = this.freePositions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Integer> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Integer n = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"next(...)");
                int pos = ((Number)n).intValue();
                if (blockedPositions.get(pos)) continue;
                this.freePositions.remove(pos);
                return pos;
            }
            int n = this.positionsAllocated;
            this.positionsAllocated = n + 1;
            return n;
        }
        Integer min = this.freePositions.first();
        this.freePositions.remove(min);
        return min;
    }

    private final void addBlockedPosition(BitSet blockedPositions, GraphNode graphNode) {
        if (graphNode != null) {
            GraphLane lane = graphNode.getLane();
            if (lane.getPosition() != -1) {
                blockedPositions.set(lane.getPosition());
            }
            for (GraphLane graphLane : graphNode.getForkingOffLanes()) {
                blockedPositions.set(graphLane.getPosition());
            }
            for (GraphLane graphLane : graphNode.getMergingLanes()) {
                blockedPositions.set(graphLane.getPosition());
            }
        }
    }

    public final void calcMaxLine() {
        if (!((Collection)this).isEmpty()) {
            int n;
            Iterable iterable = this;
            GraphCommitList graphCommitList = this;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            GraphNode it = (GraphNode)iterator.next();
            boolean bl = false;
            int n2 = it.getLane().getPosition();
            while (iterator.hasNext()) {
                GraphNode it2 = (GraphNode)iterator.next();
                $i$a$-maxOf-GraphCommitList$calcMaxLine$1 = false;
                int n3 = it2.getLane().getPosition();
                if (n2 >= n3) continue;
                n2 = n3;
            }
            graphCommitList.maxLine = n = n2;
        }
    }

    @Override
    public boolean add(@NotNull GraphNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.commits.add(element);
    }

    @Override
    public void add(int index, @NotNull GraphNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.commits.add(index, element);
    }

    public boolean remove(@NotNull GraphNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.commits.remove(element);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends GraphNode> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.commits.addAll(elements);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends GraphNode> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.commits.addAll(index, elements);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.commits.removeAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.commits.retainAll(elements);
    }

    @Override
    @NotNull
    public GraphNode set(int index, @NotNull GraphNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.commits.set(index, element);
    }

    @NotNull
    public GraphNode removeAt(int index) {
        return this.commits.remove(index);
    }

    @Override
    @NotNull
    public ListIterator<GraphNode> listIterator() {
        return this.commits.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<GraphNode> listIterator(int index) {
        return this.commits.listIterator(index);
    }

    @Override
    @NotNull
    public List<GraphNode> subList(int fromIndex, int toIndex) {
        return this.commits.subList(fromIndex, toIndex);
    }

    public int getSize() {
        return this.commits.size();
    }

    @Override
    public boolean isEmpty() {
        return this.commits.isEmpty();
    }

    public boolean contains(@NotNull GraphNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.commits.contains(element);
    }

    @Override
    @NotNull
    public Iterator<GraphNode> iterator() {
        return this.commits.iterator();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.commits.containsAll(elements);
    }

    @Override
    @NotNull
    public GraphNode get(int index) {
        return this.commits.get(index);
    }

    public int indexOf(@NotNull GraphNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.commits.indexOf(element);
    }

    public int lastIndexOf(@NotNull GraphNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.commits.lastIndexOf(element);
    }

    public GraphCommitList() {
        this(null, 1, null);
    }

    @Override
    public <T> T[] toArray(T[] array2) {
        Intrinsics.checkNotNullParameter(array2, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array2);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

