/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.diff;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.git.diff.DiffResult;
import com.jetpackduba.gitnuro.git.diff.Hunk;
import com.jetpackduba.gitnuro.git.diff.Line;
import com.jetpackduba.gitnuro.git.diff.LineType;
import com.jetpackduba.gitnuro.git.diff.SplitHunk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0002J0\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetpackduba/gitnuro/git/diff/GenerateSplitHunkFromDiffResultUseCase;", "", "<init>", "()V", "invoke", "", "Lcom/jetpackduba/gitnuro/git/diff/SplitHunk;", "diffFormat", "Lcom/jetpackduba/gitnuro/git/diff/DiffResult$Text;", "fillWithNulls", "", "oldSideLines", "", "Lcom/jetpackduba/gitnuro/git/diff/Line;", "newSideLines", "consecutiveChangedLines", "", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class GenerateSplitHunkFromDiffResultUseCase {
    public static final int $stable;

    @Inject
    public GenerateSplitHunkFromDiffResultUseCase() {
    }

    @NotNull
    public final List<SplitHunk> invoke(@NotNull DiffResult.Text diffFormat) {
        Intrinsics.checkNotNullParameter((Object)diffFormat, (String)"diffFormat");
        List<Hunk> unifiedHunksList = diffFormat.getHunks();
        List hunksList = new ArrayList();
        for (Hunk hunk : unifiedHunksList) {
            List<Line> lines = hunk.getLines();
            List newSideLines = new ArrayList();
            List oldSideLines = new ArrayList();
            int consecutiveChangedLines = 0;
            for (Line line : lines) {
                switch (WhenMappings.$EnumSwitchMapping$0[line.getLineType().ordinal()]) {
                    case 1: {
                        if (consecutiveChangedLines != 0) {
                            this.fillWithNulls(oldSideLines, newSideLines, consecutiveChangedLines);
                            consecutiveChangedLines = 0;
                        }
                        oldSideLines.add(line);
                        boolean bl = newSideLines.add(line);
                        break;
                    }
                    case 2: {
                        ++consecutiveChangedLines;
                        boolean bl = newSideLines.add(line);
                        break;
                    }
                    case 3: {
                        --consecutiveChangedLines;
                        boolean bl = oldSideLines.add(line);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (consecutiveChangedLines != 0) {
                this.fillWithNulls(oldSideLines, newSideLines, consecutiveChangedLines);
            }
            List newHunkLines = new ArrayList();
            int n = ((Collection)newSideLines).size();
            for (int i = 0; i < n; ++i) {
                Line old = (Line)oldSideLines.get(i);
                Line line = (Line)newSideLines.get(i);
                newHunkLines.add(TuplesKt.to((Object)old, (Object)line));
            }
            hunksList.add(new SplitHunk(hunk, newHunkLines));
        }
        return hunksList;
    }

    private final void fillWithNulls(List<Line> oldSideLines, List<Line> newSideLines, int consecutiveChangedLines) {
        if (!(consecutiveChangedLines != 0)) {
            throw new IllegalStateException("Check failed.");
        }
        List<Line> listToUpdate = consecutiveChangedLines > 0 ? oldSideLines : (consecutiveChangedLines < 0 ? newSideLines : null);
        int n = Math.abs(consecutiveChangedLines);
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            List<Line> list = listToUpdate;
            if (list == null) continue;
            list.add(null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineType.values().length];
            try {
                nArray[LineType.CONTEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineType.ADDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineType.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

