/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.diff;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.extensions.RawTextExtensionsKt;
import com.jetpackduba.gitnuro.git.diff.Hunk;
import com.jetpackduba.gitnuro.git.diff.Line;
import com.jetpackduba.gitnuro.git.diff.LineType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.patch.FileHeader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0086\u0002J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u001e\u0010\u001f\u001a\u00020\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020 0\u00052\u0006\u0010!\u001a\u00020\u0016H\u0002J\u001e\u0010\"\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u00052\u0006\u0010!\u001a\u00020\u0016H\u0002J\u001e\u0010$\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u00052\u0006\u0010!\u001a\u00020\u0016H\u0002J \u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0016H\u0002\u00a8\u0006)"}, d2={"Lcom/jetpackduba/gitnuro/git/diff/FormatHunksUseCase;", "", "<init>", "()V", "invoke", "", "Lcom/jetpackduba/gitnuro/git/diff/Hunk;", "fileHeader", "Lorg/eclipse/jgit/patch/FileHeader;", "rawOld", "Lorg/eclipse/jgit/diff/RawText;", "rawNew", "isDisplayFullFile", "", "format", "edits", "Lorg/eclipse/jgit/diff/EditList;", "oldRawText", "newRawText", "createHunkHeader", "", "oldStartLine", "", "oldEndLine", "newStartLine", "newEndLine", "createRange", "symbol", "", "begin", "linesCount", "findCombinedEnd", "Lorg/eclipse/jgit/diff/Edit;", "i", "combineA", "e", "combineB", "end", "edit", "a", "b", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class FormatHunksUseCase {
    public static final int $stable;

    @Inject
    public FormatHunksUseCase() {
    }

    @NotNull
    public final List<Hunk> invoke(@NotNull FileHeader fileHeader, @NotNull RawText rawOld, @NotNull RawText rawNew, boolean isDisplayFullFile) {
        List<Hunk> list;
        Intrinsics.checkNotNullParameter((Object)fileHeader, (String)"fileHeader");
        Intrinsics.checkNotNullParameter((Object)rawOld, (String)"rawOld");
        Intrinsics.checkNotNullParameter((Object)rawNew, (String)"rawNew");
        if (fileHeader.getPatchType() == FileHeader.PatchType.UNIFIED) {
            EditList editList = fileHeader.toEditList();
            Intrinsics.checkNotNullExpressionValue((Object)editList, (String)"toEditList(...)");
            list = this.format(editList, rawOld, rawNew, isDisplayFullFile);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Hunk> format(EditList edits, RawText oldRawText, RawText newRawText, boolean isDisplayFullFile) {
        int curIdx = 0;
        List hunksList = new ArrayList();
        while (curIdx < ((Collection)edits).size()) {
            Edit curEdit = (Edit)edits.get(curIdx);
            int endIdx = isDisplayFullFile ? CollectionsKt.getLastIndex((List)((List)edits)) : this.findCombinedEnd((List)edits, curIdx);
            Edit endEdit = (Edit)edits.get(endIdx);
            int oldCurrentLine = 0;
            int newCurrentLine = 0;
            int oldEndLine = 0;
            int newEndLine = 0;
            if (isDisplayFullFile) {
                oldCurrentLine = 0;
                newCurrentLine = 0;
                oldEndLine = oldRawText.size();
                newEndLine = newRawText.size();
            } else {
                oldCurrentLine = Math.max(0, curEdit.getBeginA() - 3);
                newCurrentLine = Math.max(0, curEdit.getBeginB() - 3);
                oldEndLine = Math.min(oldRawText.size(), endEdit.getEndA() + 3);
                newEndLine = Math.min(newRawText.size(), endEdit.getEndB() + 3);
            }
            String headerText = this.createHunkHeader(oldCurrentLine, oldEndLine, newCurrentLine, newEndLine);
            List lines = new ArrayList();
            while (oldCurrentLine < oldEndLine || newCurrentLine < newEndLine) {
                if (oldCurrentLine < curEdit.getBeginA() || endIdx + 1 < curIdx) {
                    lineText = RawTextExtensionsKt.lineAt(oldRawText, oldCurrentLine);
                    lines.add(new Line(lineText, oldCurrentLine, newCurrentLine, LineType.CONTEXT, null, 16, null));
                    ++oldCurrentLine;
                    ++newCurrentLine;
                } else if (oldCurrentLine < curEdit.getEndA()) {
                    lineText = RawTextExtensionsKt.lineAt(oldRawText, oldCurrentLine);
                    lines.add(new Line(lineText, oldCurrentLine, newCurrentLine, LineType.REMOVED, null, 16, null));
                    ++oldCurrentLine;
                } else if (newCurrentLine < curEdit.getEndB()) {
                    lineText = RawTextExtensionsKt.lineAt(newRawText, newCurrentLine);
                    lines.add(new Line(lineText, oldCurrentLine, newCurrentLine, LineType.ADDED, null, 16, null));
                    ++newCurrentLine;
                }
                Edit edit = curEdit;
                Intrinsics.checkNotNull((Object)edit);
                if (!this.end(edit, oldCurrentLine, newCurrentLine) || ++curIdx >= edits.size()) continue;
                curEdit = (Edit)edits.get(curIdx);
            }
            hunksList.add(new Hunk(headerText, lines));
        }
        return hunksList;
    }

    private final String createHunkHeader(int oldStartLine, int oldEndLine, int newStartLine, int newEndLine) throws IOException {
        String prefix = "@@";
        String contentRemoved = this.createRange('-', oldStartLine + 1, oldEndLine - oldStartLine);
        String contentAdded = this.createRange('+', newStartLine + 1, newEndLine - newStartLine);
        String suffix = " @@";
        return prefix + contentRemoved + contentAdded + suffix;
    }

    private final String createRange(char symbol, int begin, int linesCount) {
        return switch (linesCount) {
            case 0 -> " " + symbol + (begin - 1) + ",0";
            case 1 -> " " + symbol + begin;
            default -> " " + symbol + begin + "," + linesCount;
        };
    }

    private final int findCombinedEnd(List<? extends Edit> edits, int i) {
        int end;
        for (end = i + 1; end < edits.size() && (this.combineA(edits, end) || this.combineB(edits, end)); ++end) {
        }
        return end - 1;
    }

    private final boolean combineA(List<? extends Edit> e, int i) {
        return e.get(i).getBeginA() - e.get(i - 1).getEndA() <= 6;
    }

    private final boolean combineB(List<? extends Edit> e, int i) {
        return e.get(i).getBeginB() - e.get(i - 1).getEndB() <= 6;
    }

    private final boolean end(Edit edit, int a, int b) {
        return edit.getEndA() <= a && edit.getEndB() <= b;
    }
}

