/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.diff;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0003=>?B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J6\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J:\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001a0#2\u0006\u0010$\u001a\u00020\u001aH\u0002J$\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0(H\u0004J\u001a\u0010)\u001a\u00020\u001a2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010*\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J%\u0010,\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010-2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0004\u00a2\u0006\u0002\u0010.J-\u0010/\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010-2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u00103J\u0014\u00104\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0014\u00105\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0018\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020\u000fH\u0002J\u0014\u0010<\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch;", "", "diffTimeout", "", "<init>", "(F)V", "getDiffTimeout", "()F", "setDiffTimeout", "matchMaxBits", "", "diffMain", "Ljava/util/LinkedList;", "Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch$Diff;", "text1", "", "text2", "checkLines", "", "deadline", "", "diffCompute", "diffLineMode", "diffBisect", "diffBisectsplit", "x", "", "y", "diffLinesToChars", "Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch$LinesToCharsResult;", "diffLinesToCharsMunge", "text", "lineArray", "", "lineHash", "", "maxLines", "diffCharsToLines", "", "diffs", "", "diffCommonPrefix", "diffCommonSuffix", "diffCommonoverlap", "diff_halfMatch", "", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "diff_halfMatchI", "longtext", "shorttext", "i", "(Ljava/lang/String;Ljava/lang/String;I)[Ljava/lang/String;", "diffCleanupSemantic", "diffCleanupsemanticlossless", "diffCleanupSemanticScore", "one", "two", "BLANKLINEEND", "Ljava/util/regex/Pattern;", "BLANKLINESTART", "diffCleanupMerge", "LinesToCharsResult", "Operation", "Diff", "Gitnuro"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiffMatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffMatch.kt\ncom/jetpackduba/gitnuro/git/diff/DiffMatchPatch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1251:1\n1#2:1252\n*E\n"})
public final class DiffMatchPatch {
    private float diffTimeout;
    private final short matchMaxBits;
    @NotNull
    private final Pattern BLANKLINEEND;
    @NotNull
    private final Pattern BLANKLINESTART;
    public static final int $stable = 8;

    public DiffMatchPatch(float diffTimeout) {
        this.diffTimeout = diffTimeout;
        this.matchMaxBits = (short)32;
        Pattern pattern = Pattern.compile("\\n\\r?\\n\\Z", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.BLANKLINEEND = pattern;
        Pattern pattern2 = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        this.BLANKLINESTART = pattern2;
    }

    public /* synthetic */ DiffMatchPatch(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        this(f);
    }

    public final float getDiffTimeout() {
        return this.diffTimeout;
    }

    public final void setDiffTimeout(float f) {
        this.diffTimeout = f;
    }

    @JvmOverloads
    @NotNull
    public final LinkedList<Diff> diffMain(@NotNull String text1, @NotNull String text2, boolean checkLines) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        long deadline = 0L;
        deadline = this.diffTimeout <= 0.0f ? Long.MAX_VALUE : System.currentTimeMillis() + (long)(this.diffTimeout * (float)1000);
        return this.diffMain(text1, text2, checkLines, deadline);
    }

    public static /* synthetic */ LinkedList diffMain$default(DiffMatchPatch diffMatchPatch, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return diffMatchPatch.diffMain(string2, string3, bl);
    }

    private final LinkedList<Diff> diffMain(String text1, String text2, boolean checkLines, long deadline) {
        LinkedList<Diff> diffs = null;
        if (Intrinsics.areEqual((Object)text1, (Object)text2)) {
            diffs = new LinkedList<Diff>();
            if (((CharSequence)text1).length() > 0) {
                diffs.add(new Diff(Operation.EQUAL, text1));
            }
            return diffs;
        }
        int commonLength = this.diffCommonPrefix(text1, text2);
        String string2 = text1.substring(0, commonLength);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String commonPrefix = string2;
        String string3 = text1.substring(commonLength);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String newText1 = string3;
        String string4 = text2.substring(commonLength);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String newText2 = string4;
        commonLength = this.diffCommonSuffix(newText1, newText2);
        String string5 = newText1.substring(newText1.length() - commonLength);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        String commonSuffix = string5;
        String string6 = newText1.substring(0, newText1.length() - commonLength);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        newText1 = string6;
        String string7 = newText2.substring(0, newText2.length() - commonLength);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
        newText2 = string7;
        diffs = this.diffCompute(newText1, newText2, checkLines, deadline);
        if (((CharSequence)commonPrefix).length() > 0) {
            diffs.addFirst(new Diff(Operation.EQUAL, commonPrefix));
        }
        if (((CharSequence)commonSuffix).length() > 0) {
            diffs.addLast(new Diff(Operation.EQUAL, commonSuffix));
        }
        this.diffCleanupMerge(diffs);
        return diffs;
    }

    private final LinkedList<Diff> diffCompute(String text1, String text2, boolean checkLines, long deadline) {
        String shortText;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        if (((CharSequence)text1).length() == 0) {
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        if (((CharSequence)text2).length() == 0) {
            diffs.add(new Diff(Operation.DELETE, text1));
            return diffs;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        int i = StringsKt.indexOf$default((CharSequence)longtext, (String)(shortText = text1.length() > text2.length() ? text2 : text1), (int)0, (boolean)false, (int)6, null);
        if (i != -1) {
            Operation op = text1.length() > text2.length() ? Operation.DELETE : Operation.INSERT;
            String string2 = longtext.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            diffs.add(new Diff(op, string2));
            diffs.add(new Diff(Operation.EQUAL, shortText));
            String string3 = longtext.substring(i + shortText.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            diffs.add(new Diff(op, string3));
            return diffs;
        }
        if (shortText.length() == 1) {
            diffs.add(new Diff(Operation.DELETE, text1));
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        String[] hm = this.diff_halfMatch(text1, text2);
        if (hm != null) {
            String text1A = hm[0];
            String text1B = hm[1];
            String text2A = hm[2];
            String text2B = hm[3];
            String midCommon = hm[4];
            LinkedList<Diff> diffsA = this.diffMain(text1A, text2A, checkLines, deadline);
            LinkedList<Diff> diffsB = this.diffMain(text1B, text2B, checkLines, deadline);
            diffs = diffsA;
            diffs.add(new Diff(Operation.EQUAL, midCommon));
            diffs.addAll((Collection<Diff>)diffsB);
            return diffs;
        }
        if (checkLines && text1.length() > 100 && text2.length() > 100) {
            return this.diffLineMode(text1, text2, deadline);
        }
        return this.diffBisect(text1, text2, deadline);
    }

    private final LinkedList<Diff> diffLineMode(String text1, String text2, long deadline) {
        LinesToCharsResult linesToCharsResult = this.diffLinesToChars(text1, text2);
        List<String> linearray = linesToCharsResult.getLineArray();
        LinkedList<Diff> diffs = this.diffMain(linesToCharsResult.getChars1(), linesToCharsResult.getChars2(), false, deadline);
        this.diffCharsToLines((List<Diff>)diffs, linearray);
        this.diffCleanupSemantic(diffs);
        diffs.add(new Diff(Operation.EQUAL, ""));
        int countDelete = 0;
        int countInsert = 0;
        Object textDelete = "";
        Object textInsert = "";
        ListIterator<Diff> listIterator = diffs.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"listIterator(...)");
        ListIterator<Diff> pointer = listIterator;
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[thisDiff.getOperation().ordinal()]) {
                case 1: {
                    ++countInsert;
                    textInsert = (String)textInsert + thisDiff.getText();
                    break;
                }
                case 2: {
                    ++countDelete;
                    textDelete = (String)textDelete + thisDiff.getText();
                    break;
                }
                case 3: {
                    if (countDelete >= 1 && countInsert >= 1) {
                        Iterator iterator;
                        pointer.previous();
                        for (int j = 0; j < countDelete + countInsert; ++j) {
                            pointer.previous();
                            pointer.remove();
                        }
                        Intrinsics.checkNotNullExpressionValue(this.diffMain((String)textDelete, (String)textInsert, false, deadline).iterator(), (String)"iterator(...)");
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                            Diff subDiff = (Diff)e;
                            pointer.add(subDiff);
                        }
                    }
                    countInsert = 0;
                    countDelete = 0;
                    textDelete = "";
                    textInsert = "";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        diffs.removeLast();
        return diffs;
    }

    private final LinkedList<Diff> diffBisect(String text1, String text2, long deadline) {
        int maxD;
        int text1Length = text1.length();
        int text2Length = text2.length();
        int vOffset = maxD = (text1Length + text2Length + 1) / 2;
        int vLength = 2 * maxD;
        int[] v1 = new int[vLength];
        int[] v2 = new int[vLength];
        for (int x = 0; x < vLength; ++x) {
            v1[x] = -1;
            v2[x] = -1;
        }
        v1[vOffset + 1] = 0;
        v2[vOffset + 1] = 0;
        int delta = text1Length - text2Length;
        boolean front = delta % 2 != 0;
        int k1start = 0;
        int k1end = 0;
        int k2start = 0;
        int k2end = 0;
        for (int d = 0; d < maxD && System.currentTimeMillis() <= deadline; ++d) {
            for (int k1 = -d + k1start; k1 <= d - k1end; k1 += 2) {
                int x2;
                int k2_offset;
                int y1;
                int k1_offset = vOffset + k1;
                int x1 = 0;
                x1 = k1 == -d || k1 != d && v1[k1_offset - 1] < v1[k1_offset + 1] ? v1[k1_offset + 1] : v1[k1_offset - 1] + 1;
                for (y1 = x1 - k1; x1 < text1Length && y1 < text2Length && text1.charAt(x1) == text2.charAt(y1); ++x1, ++y1) {
                }
                v1[k1_offset] = x1;
                if (x1 > text1Length) {
                    k1end += 2;
                    continue;
                }
                if (y1 > text2Length) {
                    k1start += 2;
                    continue;
                }
                if (!front || (k2_offset = vOffset + delta - k1) < 0 || k2_offset >= vLength || v2[k2_offset] == -1 || x1 < (x2 = text1Length - v2[k2_offset])) continue;
                return this.diffBisectsplit(text1, text2, x1, y1, deadline);
            }
            for (int k2 = -d + k2start; k2 <= d - k2end; k2 += 2) {
                int k1Offset;
                int y2;
                int k2_offset = vOffset + k2;
                int x2 = 0;
                x2 = k2 == -d || k2 != d && v2[k2_offset - 1] < v2[k2_offset + 1] ? v2[k2_offset + 1] : v2[k2_offset - 1] + 1;
                for (y2 = x2 - k2; x2 < text1Length && y2 < text2Length && text1.charAt(text1Length - x2 - 1) == text2.charAt(text2Length - y2 - 1); ++x2, ++y2) {
                }
                v2[k2_offset] = x2;
                if (x2 > text1Length) {
                    k2end += 2;
                    continue;
                }
                if (y2 > text2Length) {
                    k2start += 2;
                    continue;
                }
                if (front || (k1Offset = vOffset + delta - k2) < 0 || k1Offset >= vLength || v1[k1Offset] == -1) continue;
                int x1 = v1[k1Offset];
                int y1 = vOffset + x1 - k1Offset;
                if (x1 < (x2 = text1Length - x2)) continue;
                return this.diffBisectsplit(text1, text2, x1, y1, deadline);
            }
        }
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        diffs.add(new Diff(Operation.DELETE, text1));
        diffs.add(new Diff(Operation.INSERT, text2));
        return diffs;
    }

    private final LinkedList<Diff> diffBisectsplit(String text1, String text2, int x, int y, long deadline) {
        String string2 = text1.substring(0, x);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String text1a = string2;
        String string3 = text2.substring(0, y);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String text2a = string3;
        String string4 = text1.substring(x);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String text1b = string4;
        String string5 = text2.substring(y);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        String text2b = string5;
        LinkedList<Diff> diffs = this.diffMain(text1a, text2a, false, deadline);
        LinkedList<Diff> diffsb = this.diffMain(text1b, text2b, false, deadline);
        diffs.addAll((Collection<Diff>)diffsb);
        return diffs;
    }

    private final LinesToCharsResult diffLinesToChars(String text1, String text2) {
        List lineArray = new ArrayList();
        Map lineHash = new HashMap();
        lineArray.add("");
        String chars1 = this.diffLinesToCharsMunge(text1, lineArray, lineHash, 40000);
        String chars2 = this.diffLinesToCharsMunge(text2, lineArray, lineHash, 65535);
        return new LinesToCharsResult(chars1, chars2, lineArray);
    }

    private final String diffLinesToCharsMunge(String text, List<String> lineArray, Map<String, Integer> lineHash, int maxLines) {
        int lineStart = 0;
        int lineEnd = -1;
        String line = null;
        StringBuilder chars = new StringBuilder();
        while (lineEnd < text.length() - 1) {
            lineEnd = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)lineStart, (boolean)false, (int)4, null);
            if (lineEnd == -1) {
                lineEnd = text.length() - 1;
            }
            Intrinsics.checkNotNullExpressionValue((Object)text.substring(lineStart, lineEnd + 1), (String)"substring(...)");
            if (lineHash.containsKey(line)) {
                Integer n = lineHash.get(line);
                Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Int");
                v1 = chars.append(String.valueOf((char)n.intValue()));
            } else {
                if (lineArray.size() == maxLines) {
                    String string2 = text.substring(lineStart);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    line = string2;
                    lineEnd = text.length();
                }
                lineArray.add(line);
                lineHash.put(line, lineArray.size() - 1);
                v1 = chars.append(String.valueOf((char)(lineArray.size() - 1)));
            }
            lineStart = lineEnd + 1;
        }
        String string3 = chars.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    protected final void diffCharsToLines(@NotNull List<Diff> diffs, @NotNull List<String> lineArray) {
        Intrinsics.checkNotNullParameter(diffs, (String)"diffs");
        Intrinsics.checkNotNullParameter(lineArray, (String)"lineArray");
        StringBuilder text = null;
        for (Diff diff : diffs) {
            text = new StringBuilder();
            int n = diff.getText().length();
            for (int j = 0; j < n; ++j) {
                text.append(lineArray.get(diff.getText().charAt(j)));
            }
            String string2 = text.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            diff.setText(string2);
        }
    }

    public final int diffCommonPrefix(@Nullable String text1, @Nullable String text2) {
        String string2 = text1;
        Intrinsics.checkNotNull((Object)string2);
        double d = string2.length();
        String string3 = text2;
        Intrinsics.checkNotNull((Object)string3);
        int n = (int)Math.min(d, (double)string3.length());
        for (int i = 0; i < n; ++i) {
            if (text1.charAt(i) == text2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public final int diffCommonSuffix(@NotNull String text1, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        int text1Length = text1.length();
        int text2Length = text2.length();
        int n = (int)Math.min((double)text1Length, (double)text2Length);
        int i = 1;
        if (i <= n) {
            while (true) {
                if (text1.charAt(text1Length - i) != text2.charAt(text2Length - i)) {
                    return i - 1;
                }
                if (i == n) break;
                ++i;
            }
        }
        return n;
    }

    private final int diffCommonoverlap(String text1, String text2) {
        String newText1 = text1;
        String newText2 = text2;
        int text1Length = newText1.length();
        int text2Length = newText2.length();
        if (text1Length == 0 || text2Length == 0) {
            return 0;
        }
        if (text1Length > text2Length) {
            String string2 = newText1.substring(text1Length - text2Length);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            newText1 = string2;
        } else if (text1Length < text2Length) {
            String string3 = newText2.substring(0, text1Length);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            newText2 = string3;
        }
        int text_length = (int)Math.min((double)text1Length, (double)text2Length);
        if (Intrinsics.areEqual((Object)newText1, (Object)newText2)) {
            return text_length;
        }
        int best = 0;
        int length = 1;
        while (true) {
            String pattern;
            Intrinsics.checkNotNullExpressionValue((Object)newText1.substring(text_length - length), (String)"substring(...)");
            int found = StringsKt.indexOf$default((CharSequence)newText2, (String)pattern, (int)0, (boolean)false, (int)6, null);
            if (found == -1) {
                return best;
            }
            length += found;
            if (found != 0) {
                String string4 = newText1.substring(text_length - length);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                String string5 = newText2.substring(0, length);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                if (!Intrinsics.areEqual((Object)string4, (Object)string5)) continue;
            }
            best = length++;
        }
    }

    @Nullable
    protected final String[] diff_halfMatch(@NotNull String text1, @NotNull String text2) {
        String[] stringArray;
        String[] hm;
        String shorttext;
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        if (this.diffTimeout <= 0.0f) {
            return null;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        String string2 = shorttext = text1.length() > text2.length() ? text2 : text1;
        if (longtext.length() < 4 || shorttext.length() * 2 < longtext.length()) {
            return null;
        }
        String[] hm1 = this.diff_halfMatchI(longtext, shorttext, (longtext.length() + 3) / 4);
        String[] hm2 = this.diff_halfMatchI(longtext, shorttext, (longtext.length() + 1) / 2);
        if (hm1 == null && hm2 == null) {
            return null;
        }
        String[] stringArray2 = hm2 == null ? hm1 : (hm1 == null ? hm2 : (hm = hm1[4].length() > hm2[4].length() ? hm1 : hm2));
        if (text1.length() > text2.length()) {
            stringArray = hm;
        } else {
            String[] stringArray3 = new String[5];
            Intrinsics.checkNotNull((Object)hm);
            stringArray3[0] = hm[2];
            stringArray3[1] = hm[3];
            stringArray3[2] = hm[0];
            stringArray3[3] = hm[1];
            stringArray3[4] = hm[4];
            stringArray = stringArray3;
        }
        return stringArray;
    }

    private final String[] diff_halfMatchI(String longtext, String shorttext, int i) {
        String[] stringArray;
        String string2 = longtext.substring(i, i + longtext.length() / 4);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String seed = string2;
        int j = 0;
        j = -1;
        Object bestCommon = "";
        String bestLongTextA = "";
        String bestLongTextB = "";
        String bestShortTextA = "";
        String bestShortTextB = "";
        while (true) {
            int n;
            int it = n = StringsKt.indexOf$default((CharSequence)shorttext, (String)seed, (int)(j + 1), (boolean)false, (int)4, null);
            boolean bl = false;
            j = it;
            if (n == -1) break;
            String string3 = longtext.substring(i);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String string4 = shorttext.substring(j);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            int prefixLength = this.diffCommonPrefix(string3, string4);
            String string5 = longtext.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String string6 = shorttext.substring(0, j);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            int suffixLength = this.diffCommonSuffix(string5, string6);
            if (((String)bestCommon).length() >= suffixLength + prefixLength) continue;
            String string7 = shorttext.substring(j - suffixLength, j);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            String string8 = shorttext.substring(j, j + prefixLength);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
            bestCommon = string7 + string8;
            Intrinsics.checkNotNullExpressionValue((Object)longtext.substring(0, i - suffixLength), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)longtext.substring(i + prefixLength), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)shorttext.substring(0, j - suffixLength), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)shorttext.substring(j + prefixLength), (String)"substring(...)");
        }
        if (((String)bestCommon).length() * 2 >= longtext.length()) {
            String[] stringArray2 = new String[]{bestLongTextA, bestLongTextB, bestShortTextA, bestShortTextB, bestCommon};
            stringArray = stringArray2;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public final void diffCleanupSemantic(@NotNull LinkedList<Diff> diffs) {
        Intrinsics.checkNotNullParameter(diffs, (String)"diffs");
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Deque equalities = new ArrayDeque();
        String lastEquality = null;
        ListIterator<Diff> listIterator = diffs.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"listIterator(...)");
        ListIterator<Diff> pointer = listIterator;
        int length_insertions1 = 0;
        int length_deletions1 = 0;
        int length_insertions2 = 0;
        int length_deletions2 = 0;
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.getOperation() == Operation.EQUAL) {
                equalities.push(thisDiff);
                length_insertions1 = length_insertions2;
                length_deletions1 = length_deletions2;
                length_insertions2 = 0;
                length_deletions2 = 0;
                lastEquality = thisDiff.getText();
            } else {
                if (thisDiff.getOperation() == Operation.INSERT) {
                    String string2 = thisDiff.getText();
                    Intrinsics.checkNotNull((Object)string2);
                    length_insertions2 += string2.length();
                } else {
                    String string3 = thisDiff.getText();
                    Intrinsics.checkNotNull((Object)string3);
                    length_deletions2 += string3.length();
                }
                if (lastEquality != null && (double)lastEquality.length() <= Math.max((double)length_insertions1, (double)length_deletions1) && (double)lastEquality.length() <= Math.max((double)length_insertions2, (double)length_deletions2)) {
                    while (thisDiff != equalities.peek()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastEquality));
                    pointer.add(new Diff(Operation.INSERT, lastEquality));
                    equalities.pop();
                    if (!equalities.isEmpty()) {
                        equalities.pop();
                    }
                    if (equalities.isEmpty()) {
                        while (pointer.hasPrevious()) {
                            pointer.previous();
                        }
                    } else {
                        thisDiff = (Diff)equalities.peek();
                        while (thisDiff != pointer.previous()) {
                        }
                    }
                    length_insertions1 = 0;
                    length_insertions2 = 0;
                    length_deletions1 = 0;
                    length_deletions2 = 0;
                    lastEquality = null;
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
        this.diffCleanupsemanticlossless(diffs);
        ListIterator listIterator2 = diffs.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator2, (String)"listIterator(...)");
        pointer = listIterator2;
        Diff prevDiff = null;
        thisDiff = null;
        if (pointer.hasNext()) {
            prevDiff = (Diff)pointer.next();
            if (pointer.hasNext()) {
                thisDiff = (Diff)pointer.next();
            }
        }
        while (thisDiff != null) {
            block23: {
                block26: {
                    int overlap_length2;
                    String insertion;
                    String deletion;
                    block27: {
                        block24: {
                            int overlap_length1;
                            block25: {
                                Diff diff = prevDiff;
                                Intrinsics.checkNotNull((Object)diff);
                                if (diff.getOperation() != Operation.DELETE || thisDiff.getOperation() != Operation.INSERT) break block23;
                                deletion = prevDiff.getText();
                                overlap_length1 = this.diffCommonoverlap(deletion, insertion = thisDiff.getText());
                                if (overlap_length1 < (overlap_length2 = this.diffCommonoverlap(insertion, deletion))) break block24;
                                double d = overlap_length1;
                                String string4 = deletion;
                                Intrinsics.checkNotNull((Object)string4);
                                if (d >= (double)string4.length() / 2.0) break block25;
                                double d2 = overlap_length1;
                                String string5 = insertion;
                                Intrinsics.checkNotNull((Object)string5);
                                if (!(d2 >= (double)string5.length() / 2.0)) break block26;
                            }
                            pointer.previous();
                            String string6 = insertion;
                            Intrinsics.checkNotNull((Object)string6);
                            String string7 = string6.substring(0, overlap_length1);
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                            pointer.add(new Diff(Operation.EQUAL, string7));
                            String string8 = deletion.substring(0, deletion.length() - overlap_length1);
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                            prevDiff.setText(string8);
                            String string9 = insertion.substring(overlap_length1);
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                            thisDiff.setText(string9);
                            break block26;
                        }
                        double d = overlap_length2;
                        String string10 = deletion;
                        Intrinsics.checkNotNull((Object)string10);
                        if (d >= (double)string10.length() / 2.0) break block27;
                        double d3 = overlap_length2;
                        String string11 = insertion;
                        Intrinsics.checkNotNull((Object)string11);
                        if (!(d3 >= (double)string11.length() / 2.0)) break block26;
                    }
                    pointer.previous();
                    String string12 = deletion.substring(0, overlap_length2);
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"substring(...)");
                    pointer.add(new Diff(Operation.EQUAL, string12));
                    prevDiff.setOperation(Operation.INSERT);
                    String string13 = insertion;
                    Intrinsics.checkNotNull((Object)string13);
                    String string14 = string13.substring(0, insertion.length() - overlap_length2);
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"substring(...)");
                    prevDiff.setText(string14);
                    thisDiff.setOperation(Operation.DELETE);
                    String string15 = deletion.substring(overlap_length2);
                    Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"substring(...)");
                    thisDiff.setText(string15);
                }
                thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
            }
            prevDiff = thisDiff;
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    public final void diffCleanupsemanticlossless(@NotNull LinkedList<Diff> diffs) {
        Diff nextDiff;
        Intrinsics.checkNotNullParameter(diffs, (String)"diffs");
        Object equality1 = null;
        Object edit = null;
        Object equality2 = null;
        String commonString = null;
        int commonOffset = 0;
        int score = 0;
        int bestScore = 0;
        Object bestEquality1 = null;
        Object bestEdit = null;
        Object bestEquality2 = null;
        ListIterator listIterator = diffs.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"listIterator(...)");
        ListIterator pointer = listIterator;
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            Diff diff2 = prevDiff;
            Intrinsics.checkNotNull((Object)diff2);
            if (diff2.getOperation() == Operation.EQUAL && nextDiff.getOperation() == Operation.EQUAL) {
                equality1 = prevDiff.getText();
                Diff diff3 = thisDiff;
                Intrinsics.checkNotNull((Object)diff3);
                edit = diff3.getText();
                equality2 = nextDiff.getText();
                commonOffset = this.diffCommonSuffix((String)equality1, (String)edit);
                if (commonOffset != 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)((String)edit).substring(((String)edit).length() - commonOffset), (String)"substring(...)");
                    String string2 = ((String)equality1).substring(0, ((String)equality1).length() - commonOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    equality1 = string2;
                    String string3 = ((String)edit).substring(0, ((String)edit).length() - commonOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    edit = commonString + string3;
                    equality2 = commonString + (String)equality2;
                }
                bestEquality1 = equality1;
                bestEdit = edit;
                bestEquality2 = equality2;
                bestScore = this.diffCleanupSemanticScore((String)equality1, (String)edit) + this.diffCleanupSemanticScore((String)edit, (String)equality2);
                while (((CharSequence)edit).length() > 0 && ((CharSequence)equality2).length() > 0 && ((String)edit).charAt(0) == ((String)equality2).charAt(0)) {
                    equality1 = (String)equality1 + ((String)edit).charAt(0);
                    String string4 = ((String)edit).substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    edit = string4 + ((String)equality2).charAt(0);
                    Intrinsics.checkNotNullExpressionValue((Object)((String)equality2).substring(1), (String)"substring(...)");
                    score = this.diffCleanupSemanticScore((String)equality1, (String)edit) + this.diffCleanupSemanticScore((String)edit, (String)equality2);
                    if (score < bestScore) continue;
                    bestScore = score;
                    bestEquality1 = equality1;
                    bestEdit = edit;
                    bestEquality2 = equality2;
                }
                if (!Intrinsics.areEqual((Object)prevDiff.getText(), (Object)bestEquality1)) {
                    String string5 = bestEquality1;
                    Intrinsics.checkNotNull((Object)string5);
                    if (string5.length() != 0) {
                        prevDiff.setText((String)bestEquality1);
                    } else {
                        pointer.previous();
                        pointer.previous();
                        pointer.previous();
                        pointer.remove();
                        pointer.next();
                        Object e = pointer.next();
                        Intrinsics.checkNotNull(e);
                    }
                    thisDiff.setText((String)bestEdit);
                    String string6 = bestEquality2;
                    Intrinsics.checkNotNull((Object)string6);
                    if (string6.length() != 0) {
                        nextDiff.setText((String)bestEquality2);
                    } else {
                        pointer.remove();
                        nextDiff = thisDiff;
                        thisDiff = prevDiff;
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    private final int diffCleanupSemanticScore(String one, String two) {
        boolean blankLine2;
        if (((CharSequence)one).length() == 0 || ((CharSequence)two).length() == 0) {
            return 6;
        }
        char char1 = one.charAt(one.length() - 1);
        char char2 = two.charAt(0);
        boolean nonAlphaNumeric1 = !Character.isLetterOrDigit(char1);
        boolean nonAlphaNumeric2 = !Character.isLetterOrDigit(char2);
        boolean whitespace1 = nonAlphaNumeric1 && Character.isWhitespace(char1);
        boolean whitespace2 = nonAlphaNumeric2 && Character.isWhitespace(char2);
        boolean lineBreak1 = whitespace1 && Character.getType(char1) == 15;
        boolean lineBreak2 = whitespace2 && Character.getType(char2) == 15;
        boolean blankLine1 = lineBreak1 && this.BLANKLINEEND.matcher(one).find();
        boolean bl = blankLine2 = lineBreak2 && this.BLANKLINESTART.matcher(two).find();
        if (blankLine1 || blankLine2) {
            return 5;
        }
        if (lineBreak1 || lineBreak2) {
            return 4;
        }
        if (nonAlphaNumeric1 && !whitespace1 && whitespace2) {
            return 3;
        }
        if (whitespace1 || whitespace2) {
            return 2;
        }
        if (nonAlphaNumeric1 || nonAlphaNumeric2) {
            return 1;
        }
        return 0;
    }

    public final void diffCleanupMerge(@NotNull LinkedList<Diff> diffs) {
        Diff nextDiff;
        Object object;
        Intrinsics.checkNotNullParameter(diffs, (String)"diffs");
        diffs.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> listIterator = diffs.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"listIterator(...)");
        ListIterator<Diff> pointer = listIterator;
        int countDelete = 0;
        int countInsert = 0;
        Object textDelete = "";
        Object textInsert = "";
        Diff thisDiff = (Diff)pointer.next();
        Diff prevEqual = null;
        int commonlength = 0;
        while (thisDiff != null) {
            Operation operation = thisDiff.getOperation();
            Intrinsics.checkNotNull((Object)((Object)operation));
            switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
                case 1: {
                    ++countInsert;
                    textInsert = (String)textInsert + thisDiff.getText();
                    prevEqual = null;
                    break;
                }
                case 2: {
                    ++countDelete;
                    textDelete = (String)textDelete + thisDiff.getText();
                    prevEqual = null;
                    break;
                }
                case 3: {
                    if (countDelete + countInsert > 1) {
                        boolean bothTypes = countDelete != 0 && countInsert != 0;
                        pointer.previous();
                        while (countDelete-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        while (countInsert-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        if (bothTypes) {
                            commonlength = this.diffCommonPrefix((String)textInsert, (String)textDelete);
                            if (commonlength != 0) {
                                if (pointer.hasPrevious()) {
                                    boolean bl;
                                    thisDiff = (Diff)pointer.previous();
                                    boolean bl2 = bl = thisDiff.getOperation() == Operation.EQUAL;
                                    if (_Assertions.ENABLED && !bl) {
                                        boolean bl3 = false;
                                        String string2 = "Previous diff should have been an equality.";
                                        throw new AssertionError((Object)string2);
                                    }
                                    Diff diff = thisDiff;
                                    String string3 = diff.getText();
                                    String string4 = ((String)textInsert).substring(0, commonlength);
                                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                                    diff.setText(string3 + string4);
                                    object = pointer.next();
                                    Intrinsics.checkNotNull(object);
                                } else {
                                    String string5 = ((String)textInsert).substring(0, commonlength);
                                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                                    pointer.add(new Diff(Operation.EQUAL, string5));
                                }
                                String string6 = ((String)textInsert).substring(commonlength);
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                                textInsert = string6;
                                String string7 = ((String)textDelete).substring(commonlength);
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                                textDelete = string7;
                            }
                            if ((commonlength = this.diffCommonSuffix((String)textInsert, (String)textDelete)) != 0) {
                                thisDiff = (Diff)pointer.next();
                                String string8 = ((String)textInsert).substring(((String)textInsert).length() - commonlength);
                                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                                thisDiff.setText(string8 + thisDiff.getText());
                                String string9 = ((String)textInsert).substring(0, ((String)textInsert).length() - commonlength);
                                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                                textInsert = string9;
                                String string10 = ((String)textDelete).substring(0, ((String)textDelete).length() - commonlength);
                                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"substring(...)");
                                textDelete = string10;
                                pointer.previous();
                            }
                        }
                        if (((CharSequence)textDelete).length() > 0) {
                            pointer.add(new Diff(Operation.DELETE, (String)textDelete));
                        }
                        if (((CharSequence)textInsert).length() > 0) {
                            pointer.add(new Diff(Operation.INSERT, (String)textInsert));
                        }
                        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    } else if (prevEqual != null) {
                        Diff bothTypes = prevEqual;
                        bothTypes.setText(bothTypes.getText() + thisDiff.getText());
                        pointer.remove();
                        thisDiff = (Diff)pointer.previous();
                        pointer.next();
                    }
                    countInsert = 0;
                    countDelete = 0;
                    textDelete = "";
                    textInsert = "";
                    prevEqual = thisDiff;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        String string11 = diffs.getLast().getText();
        Intrinsics.checkNotNull((Object)string11);
        if (((CharSequence)string11).length() == 0) {
            diffs.removeLast();
        }
        boolean changes = false;
        ListIterator listIterator2 = diffs.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator2, (String)"listIterator(...)");
        pointer = listIterator2;
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            Diff diff2 = prevDiff;
            Intrinsics.checkNotNull((Object)diff2);
            if (diff2.getOperation() == Operation.EQUAL && nextDiff.getOperation() == Operation.EQUAL) {
                Diff diff3 = thisDiff;
                Intrinsics.checkNotNull((Object)diff3);
                String string12 = diff3.getText();
                Intrinsics.checkNotNull((Object)string12);
                String string13 = prevDiff.getText();
                Intrinsics.checkNotNull((Object)string13);
                if (StringsKt.endsWith$default((String)string12, (String)string13, (boolean)false, (int)2, null)) {
                    String string14 = prevDiff.getText();
                    String string15 = thisDiff.getText();
                    Intrinsics.checkNotNull((Object)string15);
                    String string16 = thisDiff.getText();
                    Intrinsics.checkNotNull((Object)string16);
                    int n = string16.length();
                    String string17 = prevDiff.getText();
                    Intrinsics.checkNotNull((Object)string17);
                    String string18 = string15.substring(0, n - string17.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"substring(...)");
                    thisDiff.setText(string14 + string18);
                    nextDiff.setText(prevDiff.getText() + nextDiff.getText());
                    pointer.previous();
                    pointer.previous();
                    pointer.previous();
                    pointer.remove();
                    pointer.next();
                    thisDiff = (Diff)pointer.next();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                } else {
                    String string19 = thisDiff.getText();
                    Intrinsics.checkNotNull((Object)string19);
                    String string20 = nextDiff.getText();
                    Intrinsics.checkNotNull((Object)string20);
                    if (StringsKt.startsWith$default((String)string19, (String)string20, (boolean)false, (int)2, null)) {
                        object = prevDiff;
                        ((Diff)object).setText(((Diff)object).getText() + nextDiff.getText());
                        String string21 = thisDiff.getText();
                        Intrinsics.checkNotNull((Object)string21);
                        String string22 = nextDiff.getText();
                        Intrinsics.checkNotNull((Object)string22);
                        String string23 = string21.substring(string22.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"substring(...)");
                        thisDiff.setText(string23 + nextDiff.getText());
                        pointer.remove();
                        nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                        changes = true;
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
    }

    @JvmOverloads
    @NotNull
    public final LinkedList<Diff> diffMain(@NotNull String text1, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        return DiffMatchPatch.diffMain$default(this, text1, text2, false, 4, null);
    }

    public DiffMatchPatch() {
        this(0.0f, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch$Diff;", "", "operation", "Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch$Operation;", "text", "", "<init>", "(Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch$Operation;Ljava/lang/String;)V", "getOperation", "()Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch$Operation;", "setOperation", "(Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch$Operation;)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "toString", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "Gitnuro"})
    @StabilityInferred(parameters=0)
    public static final class Diff {
        @NotNull
        private Operation operation;
        @NotNull
        private String text;
        public static final int $stable = 8;

        public Diff(@NotNull Operation operation, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.operation = operation;
            this.text = text;
        }

        @NotNull
        public final Operation getOperation() {
            return this.operation;
        }

        public final void setOperation(@NotNull Operation operation) {
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"<set-?>");
            this.operation = operation;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.text = string2;
        }

        @NotNull
        public String toString() {
            String string2 = this.text;
            Intrinsics.checkNotNull((Object)string2);
            String prettyText = StringsKt.replace$default((String)string2, (char)'\n', (char)'\u00b6', (boolean)false, (int)4, null);
            return "Diff(" + this.operation + ",\"" + prettyText + "\")";
        }

        @NotNull
        public final Operation component1() {
            return this.operation;
        }

        @NotNull
        public final String component2() {
            return this.text;
        }

        @NotNull
        public final Diff copy(@NotNull Operation operation, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new Diff(operation, text);
        }

        public static /* synthetic */ Diff copy$default(Diff diff, Operation operation, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                operation = diff.operation;
            }
            if ((n & 2) != 0) {
                string2 = diff.text;
            }
            return diff.copy(operation, string2);
        }

        public int hashCode() {
            int result = this.operation.hashCode();
            result = result * 31 + this.text.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Diff)) {
                return false;
            }
            Diff diff = (Diff)other;
            if (this.operation != diff.operation) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)diff.text);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\r\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch$LinesToCharsResult;", "", "chars1", "", "chars2", "lineArray", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getChars1", "()Ljava/lang/String;", "setChars1", "(Ljava/lang/String;)V", "getChars2", "setChars2", "getLineArray", "()Ljava/util/List;", "setLineArray", "(Ljava/util/List;)V", "Gitnuro"})
    protected static final class LinesToCharsResult {
        @NotNull
        private String chars1;
        @NotNull
        private String chars2;
        @NotNull
        private List<String> lineArray;

        public LinesToCharsResult(@NotNull String chars1, @NotNull String chars2, @NotNull List<String> lineArray) {
            Intrinsics.checkNotNullParameter((Object)chars1, (String)"chars1");
            Intrinsics.checkNotNullParameter((Object)chars2, (String)"chars2");
            Intrinsics.checkNotNullParameter(lineArray, (String)"lineArray");
            this.chars1 = chars1;
            this.chars2 = chars2;
            this.lineArray = lineArray;
        }

        @NotNull
        public final String getChars1() {
            return this.chars1;
        }

        public final void setChars1(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.chars1 = string2;
        }

        @NotNull
        public final String getChars2() {
            return this.chars2;
        }

        public final void setChars2(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.chars2 = string2;
        }

        @NotNull
        public final List<String> getLineArray() {
            return this.lineArray;
        }

        public final void setLineArray(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.lineArray = list;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetpackduba/gitnuro/git/diff/DiffMatchPatch$Operation;", "", "<init>", "(Ljava/lang/String;I)V", "DELETE", "INSERT", "EQUAL", "Gitnuro"})
    public static final class Operation
    extends Enum<Operation> {
        public static final /* enum */ Operation DELETE = new Operation();
        public static final /* enum */ Operation INSERT = new Operation();
        public static final /* enum */ Operation EQUAL = new Operation();
        private static final /* synthetic */ Operation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Operation[] values() {
            return (Operation[])$VALUES.clone();
        }

        public static Operation valueOf(String value) {
            return Enum.valueOf(Operation.class, value);
        }

        @NotNull
        public static EnumEntries<Operation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationArray = new Operation[]{Operation.DELETE, Operation.INSERT, Operation.EQUAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operation.values().length];
            try {
                nArray[Operation.INSERT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.DELETE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.EQUAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

