/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.branches;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.extensions.RefExtensionsKt;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0086\u0002J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0086\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetpackduba/gitnuro/git/branches/SetTrackingBranchUseCase;", "", "<init>", "()V", "invoke", "", "git", "Lorg/eclipse/jgit/api/Git;", "ref", "Lorg/eclipse/jgit/lib/Ref;", "remoteName", "", "remoteBranch", "refName", "remoteBranchName", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class SetTrackingBranchUseCase {
    public static final int $stable;

    @Inject
    public SetTrackingBranchUseCase() {
    }

    public final void invoke(@NotNull Git git, @NotNull Ref ref, @Nullable String remoteName, @Nullable Ref remoteBranch) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Ref ref2 = remoteBranch;
        this.invoke(git, RefExtensionsKt.getSimpleName(ref), remoteName, ref2 != null ? RefExtensionsKt.getSimpleName(ref2) : null);
    }

    public final void invoke(@NotNull Git git, @NotNull String refName, @Nullable String remoteName, @Nullable String remoteBranchName) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)refName, (String)"refName");
        Repository repository = git.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"getRepository(...)");
        Repository repository2 = repository;
        StoredConfig storedConfig = repository2.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)storedConfig, (String)"getConfig(...)");
        StoredConfig config = storedConfig;
        if (remoteName == null || remoteBranchName == null) {
            config.unset("branch", refName, "remote");
            config.unset("branch", refName, "merge");
        } else {
            config.setString("branch", refName, "remote", remoteName);
            config.setString("branch", refName, "merge", "refs/heads/" + remoteBranchName);
        }
        config.save();
    }
}

