/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git.branches;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.extensions.RefExtensionsKt;
import com.jetpackduba.gitnuro.git.branches.TrackingBranch;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002\u00a8\u0006\f"}, d2={"Lcom/jetpackduba/gitnuro/git/branches/GetTrackingBranchUseCase;", "", "<init>", "()V", "invoke", "Lcom/jetpackduba/gitnuro/git/branches/TrackingBranch;", "git", "Lorg/eclipse/jgit/api/Git;", "ref", "Lorg/eclipse/jgit/lib/Ref;", "refName", "", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class GetTrackingBranchUseCase {
    public static final int $stable;

    @Inject
    public GetTrackingBranchUseCase() {
    }

    @Nullable
    public final TrackingBranch invoke(@NotNull Git git, @NotNull Ref ref) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return this.invoke(git, RefExtensionsKt.getSimpleName(ref));
    }

    @Nullable
    public final TrackingBranch invoke(@NotNull Git git, @NotNull String refName) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)refName, (String)"refName");
        Repository repository = git.getRepository();
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"getRepository(...)");
        Repository repository2 = repository;
        StoredConfig storedConfig = repository2.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)storedConfig, (String)"getConfig(...)");
        Config config = (Config)storedConfig;
        String remote = config.getString("branch", refName, "remote");
        String branch = config.getString("branch", refName, "merge");
        if (remote != null && branch != null) {
            return new TrackingBranch(remote, StringsKt.removePrefix((String)branch, (CharSequence)"refs/heads/"));
        }
        return null;
    }
}

