/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.extensions.DiffEntryExtensionsKt;
import com.jetpackduba.gitnuro.git.EntryContent;
import com.jetpackduba.gitnuro.managers.TempFilesManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.diff.ContentSource;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.LfsFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetpackduba/gitnuro/git/RawFileManager;", "", "tempFilesManager", "Lcom/jetpackduba/gitnuro/managers/TempFilesManager;", "<init>", "(Lcom/jetpackduba/gitnuro/managers/TempFilesManager;)V", "getRawContent", "Lcom/jetpackduba/gitnuro/git/EntryContent;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "side", "Lorg/eclipse/jgit/diff/DiffEntry$Side;", "entry", "Lorg/eclipse/jgit/diff/DiffEntry;", "oldTreeIterator", "Lorg/eclipse/jgit/treewalk/AbstractTreeIterator;", "newTreeIterator", "source", "Lorg/eclipse/jgit/diff/ContentSource;", "iterator", "reader", "Lorg/eclipse/jgit/lib/ObjectReader;", "generateImageBinary", "Lcom/jetpackduba/gitnuro/git/EntryContent$ImageBinary;", "ldr", "Lorg/eclipse/jgit/lib/ObjectLoader;", "isImage", "", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class RawFileManager {
    @NotNull
    private final TempFilesManager tempFilesManager;
    public static final int $stable;

    @Inject
    public RawFileManager(@NotNull TempFilesManager tempFilesManager) {
        Intrinsics.checkNotNullParameter((Object)tempFilesManager, (String)"tempFilesManager");
        this.tempFilesManager = tempFilesManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EntryContent getRawContent(@NotNull Repository repository, @NotNull DiffEntry.Side side, @NotNull DiffEntry entry, @Nullable AbstractTreeIterator oldTreeIterator, @Nullable AbstractTreeIterator newTreeIterator) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (entry.getMode(side) == FileMode.MISSING) {
            return EntryContent.Missing.INSTANCE;
        }
        if (entry.getMode(side).getObjectType() == 1) {
            return EntryContent.Submodule.INSTANCE;
        }
        if (entry.getMode(side).getObjectType() != 3) {
            return EntryContent.InvalidObjectBlob.INSTANCE;
        }
        ObjectReader objectReader = repository.newObjectReader();
        Intrinsics.checkNotNullExpressionValue((Object)objectReader, (String)"newObjectReader(...)");
        ObjectReader reader = objectReader;
        AutoCloseable autoCloseable = (AutoCloseable)reader;
        Throwable throwable = null;
        try {
            EntryContent entryContent;
            ContentSource.Pair pair;
            ObjectReader it = (ObjectReader)autoCloseable;
            boolean bl = false;
            if (oldTreeIterator != null && newTreeIterator != null) {
                pair = new ContentSource.Pair(this.source(oldTreeIterator, reader), this.source(newTreeIterator, reader));
            } else {
                ContentSource cs = ContentSource.create((ObjectReader)reader);
                pair = new ContentSource.Pair(cs, cs);
            }
            ContentSource.Pair source = pair;
            ObjectLoader ldr = LfsFactory.getInstance().applySmudgeFilter(repository, source.open(side, entry), entry.getDiffAttribute());
            try {
                RawText rawText = RawText.load((ObjectLoader)ldr, (int)0x3200000);
                Intrinsics.checkNotNullExpressionValue((Object)rawText, (String)"load(...)");
                entryContent = new EntryContent.Text(rawText);
            }
            catch (BinaryBlobException ex) {
                EntryContent.BinaryContent binaryContent;
                if (this.isImage(entry)) {
                    Intrinsics.checkNotNull((Object)ldr);
                    binaryContent = this.generateImageBinary(ldr, entry, side);
                } else {
                    binaryContent = EntryContent.Binary.INSTANCE;
                }
                entryContent = binaryContent;
            }
            EntryContent entryContent2 = entryContent;
            return entryContent2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final ContentSource source(AbstractTreeIterator iterator, ObjectReader reader) {
        ContentSource contentSource;
        if (iterator instanceof WorkingTreeIterator) {
            ContentSource contentSource2 = ContentSource.create((WorkingTreeIterator)((WorkingTreeIterator)iterator));
            contentSource = contentSource2;
            Intrinsics.checkNotNullExpressionValue((Object)contentSource2, (String)"create(...)");
        } else {
            ContentSource contentSource3 = ContentSource.create((ObjectReader)reader);
            contentSource = contentSource3;
            Intrinsics.checkNotNullExpressionValue((Object)contentSource3, (String)"create(...)");
        }
        return contentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntryContent.ImageBinary generateImageBinary(ObjectLoader ldr, DiffEntry entry, DiffEntry.Side side) {
        File tempDir = this.tempFilesManager.tempDir();
        String string2 = entry.getId(side).name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
        String prefix = StringsKt.take((String)string2, (int)20) + "_" + side.name() + "_";
        String tempFileName = prefix + StringsKt.take((String)DiffEntryExtensionsKt.getFileName(entry), (int)(250 - prefix.length()));
        File tempFile = new File(tempDir, tempFileName);
        tempFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempFile);
        Closeable closeable = out;
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            ldr.copyTo((OutputStream)out);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string3 = tempFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        String string4 = Files.probeContentType(Path.of(entry.getNewPath(), new String[0]));
        if (string4 == null) {
            string4 = "";
        }
        return new EntryContent.ImageBinary(string3, string4);
    }

    private final boolean isImage(DiffEntry entry) {
        String contentType;
        String path = entry.getNewPath();
        String string2 = contentType = Files.probeContentType(Path.of(path, new String[0]));
        return string2 != null ? StringsKt.startsWith$default((String)string2, (String)"image/", (boolean)false, (int)2, null) : false;
    }
}

