/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.git;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.credentials.GpgCredentialsProvider;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.bouncycastle.openpgp.PGPException;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgSigner;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JD\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J:\u0010\u0014\u001a\u00020\u00152\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016JD\u0010\u0016\u001a\u00020\u00172\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J+\u0010\u001a\u001a\u00020\u00172!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00170\u001cH\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetpackduba/gitnuro/git/AppGpgSigner;", "Lorg/eclipse/jgit/gpg/bc/internal/BouncyCastleGpgSigner;", "gpgCredentials", "Lcom/jetpackduba/gitnuro/credentials/GpgCredentialsProvider;", "<init>", "(Lcom/jetpackduba/gitnuro/credentials/GpgCredentialsProvider;)V", "sign", "Lorg/eclipse/jgit/lib/GpgSignature;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "config", "Lorg/eclipse/jgit/lib/GpgConfig;", "data", "", "committer", "Lorg/eclipse/jgit/lib/PersonIdent;", "signingKey", "", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "canLocateSigningKey", "", "signObject", "", "object", "Lorg/eclipse/jgit/lib/ObjectBuilder;", "retryIfWrongPassphrase", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "isRetry", "getPgpExceptionTypeOrNull", "Lorg/bouncycastle/openpgp/PGPException;", "ex", "", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class AppGpgSigner
extends BouncyCastleGpgSigner {
    @NotNull
    private final GpgCredentialsProvider gpgCredentials;
    public static final int $stable = 8;

    @Inject
    public AppGpgSigner(@NotNull GpgCredentialsProvider gpgCredentials) {
        Intrinsics.checkNotNullParameter((Object)((Object)gpgCredentials), (String)"gpgCredentials");
        this.gpgCredentials = gpgCredentials;
    }

    @NotNull
    public GpgSignature sign(@Nullable Repository repository, @Nullable GpgConfig config, @Nullable byte[] data, @Nullable PersonIdent committer, @Nullable String signingKey, @Nullable CredentialsProvider credentialsProvider) {
        GpgSignature gpgSignature;
        try {
            Ref.ObjectRef gpgSignature2 = new Ref.ObjectRef();
            this.retryIfWrongPassphrase((Function1<? super Boolean, Unit>)((Function1)arg_0 -> AppGpgSigner.sign$lambda$0(this, gpgSignature2, repository, config, data, committer, signingKey, arg_0)));
            Object object = gpgSignature2.element;
            Intrinsics.checkNotNull((Object)object);
            gpgSignature = (GpgSignature)object;
        }
        catch (CanceledException ex) {
            System.out.println((Object)"Signing cancelled");
            throw ex;
        }
        return gpgSignature;
    }

    public boolean canLocateSigningKey(@Nullable Repository repository, @Nullable GpgConfig config, @Nullable PersonIdent committer, @Nullable String signingKey, @Nullable CredentialsProvider credentialsProvider) {
        return super.canLocateSigningKey(repository, config, committer, signingKey, (CredentialsProvider)this.gpgCredentials);
    }

    public void signObject(@Nullable Repository repository, @Nullable GpgConfig config, @Nullable ObjectBuilder object, @Nullable PersonIdent committer, @Nullable String signingKey, @Nullable CredentialsProvider credentialsProvider) {
        GpgCredentialsProvider gpgCredentialsProvider = this.gpgCredentials;
        try {
            this.retryIfWrongPassphrase((Function1<? super Boolean, Unit>)((Function1)arg_0 -> AppGpgSigner.signObject$lambda$1(gpgCredentialsProvider, this, repository, config, object, committer, signingKey, credentialsProvider, arg_0)));
        }
        catch (CanceledException ex) {
            System.out.println((Object)"Signing cancelled");
        }
    }

    private final void retryIfWrongPassphrase(Function1<? super Boolean, Unit> block) {
        boolean isPasswordCorrect = false;
        int retries = 0;
        while (!isPasswordCorrect) {
            isPasswordCorrect = true;
            try {
                block.invoke((Object)(retries > 0 ? 1 : 0));
            }
            catch (Exception ex) {
                String pgpMessage;
                PGPException pgpException;
                ex.printStackTrace();
                PGPException pGPException = pgpException = this.getPgpExceptionTypeOrNull(ex);
                String string2 = pgpMessage = pGPException != null ? pGPException.getMessage() : null;
                if (pgpMessage != null && StringsKt.contains$default((CharSequence)pgpMessage, (CharSequence)"Is the entered passphrase correct?", (boolean)false, (int)2, null)) {
                    isPasswordCorrect = false;
                    ++retries;
                    continue;
                }
                throw ex;
            }
        }
    }

    private final PGPException getPgpExceptionTypeOrNull(Throwable ex) {
        Throwable currentException = ex;
        while (currentException != null) {
            if (currentException instanceof PGPException) {
                return (PGPException)currentException;
            }
            currentException = Intrinsics.areEqual((Object)currentException.getCause(), (Object)currentException) ? null : currentException.getCause();
        }
        return null;
    }

    private static final Unit sign$lambda$0(AppGpgSigner this$0, Ref.ObjectRef $gpgSignature, Repository $repository, GpgConfig $config, byte[] $data, PersonIdent $committer, String $signingKey, boolean isRetry) {
        this$0.gpgCredentials.setRetry(isRetry);
        $gpgSignature.element = super.sign($repository, $config, $data, $committer, $signingKey, (CredentialsProvider)this$0.gpgCredentials);
        this$0.gpgCredentials.savePasswordInMemory();
        return Unit.INSTANCE;
    }

    private static final Unit signObject$lambda$1(GpgCredentialsProvider $gpgCredentialsProvider, AppGpgSigner this$0, Repository $repository, GpgConfig $config, ObjectBuilder $object, PersonIdent $committer, String $signingKey, CredentialsProvider $credentialsProvider, boolean isRetry) {
        $gpgCredentialsProvider.setRetry(isRetry);
        super.signObject($repository, $config, $object, $committer, $signingKey, $credentialsProvider);
        $gpgCredentialsProvider.savePasswordInMemory();
        return Unit.INSTANCE;
    }
}

