/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.extensions;

import com.jetpackduba.gitnuro.exceptions.SshException;
import com.jetpackduba.gitnuro.system.OSKt;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0011*\u00020\u0001\"\u001b\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\f\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\"\u0017\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005\u00a8\u0006\u0016"}, d2={"sha256", "", "getSha256$annotations", "(Ljava/lang/String;)V", "getSha256", "(Ljava/lang/String;)Ljava/lang/String;", "dirName", "getDirName", "dirPath", "getDirPath", "removeLineDelimiters", "replaceTabs", "lineDelimiter", "getLineDelimiter", "nullIfEmpty", "getNullIfEmpty", "lowercaseContains", "", "other", "throwIfSshMessage", "", "isHttpOrHttps", "Gitnuro"})
@SourceDebugExtension(value={"SMAP\nStringExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringExtensions.kt\ncom/jetpackduba/gitnuro/extensions/StringExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class StringExtensionsKt {
    @NotNull
    public static final String getSha256(@NotNull String $this$sha256) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = $this$sha256.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        return HexExtensionsKt.toHexString$default((byte[])byArray2, null, (int)1, null);
    }

    public static /* synthetic */ void getSha256$annotations(String string2) {
    }

    @NotNull
    public static final String getDirName(@NotNull String $this$dirName) {
        Intrinsics.checkNotNullParameter((Object)$this$dirName, (String)"<this>");
        String[] stringArray = new String[]{OSKt.getSystemSeparator()};
        List parts = StringsKt.split$default((CharSequence)$this$dirName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return !((Collection)parts).isEmpty() ? (String)CollectionsKt.last((List)parts) : $this$dirName;
    }

    @NotNull
    public static final String getDirPath(@NotNull String $this$dirPath) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$dirPath, (String)"<this>");
        String[] stringArray = new String[]{OSKt.getSystemSeparator()};
        List parts = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)$this$dirPath, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (((Collection)parts).size() > 1) {
            CollectionsKt.removeLast((List)parts);
            string2 = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)OSKt.getSystemSeparator(), null, null, (int)0, null, null, (int)62, null);
        } else {
            string2 = $this$dirPath;
        }
        return string2;
    }

    @NotNull
    public static final String removeLineDelimiters(@NotNull String $this$removeLineDelimiters) {
        Intrinsics.checkNotNullParameter((Object)$this$removeLineDelimiters, (String)"<this>");
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)$this$removeLineDelimiters, (CharSequence)"\r\n"), (CharSequence)"\n");
    }

    @NotNull
    public static final String replaceTabs(@NotNull String $this$replaceTabs) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceTabs, (String)"<this>");
        return StringsKt.replace$default((String)$this$replaceTabs, (String)"\t", (String)"    ", (boolean)false, (int)4, null);
    }

    @Nullable
    public static final String getLineDelimiter(@NotNull String $this$lineDelimiter) {
        Intrinsics.checkNotNullParameter((Object)$this$lineDelimiter, (String)"<this>");
        return StringsKt.contains$default((CharSequence)$this$lineDelimiter, (CharSequence)"\r\n", (boolean)false, (int)2, null) ? "\r\n" : (StringsKt.contains$default((CharSequence)$this$lineDelimiter, (CharSequence)"\n", (boolean)false, (int)2, null) ? "\n" : null);
    }

    @Nullable
    public static final String getNullIfEmpty(@NotNull String $this$nullIfEmpty) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$nullIfEmpty, (String)"<this>");
        CharSequence charSequence2 = $this$nullIfEmpty;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    public static final boolean lowercaseContains(@NotNull String $this$lowercaseContains, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)$this$lowercaseContains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string2 = $this$lowercaseContains.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        CharSequence charSequence = string2;
        String string3 = other.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)((Object)StringsKt.trim((CharSequence)string3)).toString(), (boolean)false, (int)2, null);
    }

    public static final void throwIfSshMessage(@NotNull String $this$throwIfSshMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$throwIfSshMessage, (String)"<this>");
        if (((CharSequence)$this$throwIfSshMessage).length() > 0) {
            throw new SshException($this$throwIfSshMessage);
        }
    }

    public static final boolean isHttpOrHttps(@NotNull String $this$isHttpOrHttps) {
        Intrinsics.checkNotNullParameter((Object)$this$isHttpOrHttps, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isHttpOrHttps, (String)"http://", (boolean)false, (int)2, null) | StringsKt.startsWith$default((String)$this$isHttpOrHttps, (String)"https://", (boolean)false, (int)2, null);
    }
}

