/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.di;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.jetpackduba.gitnuro.App;
import com.jetpackduba.gitnuro.AppEnvInfo;
import com.jetpackduba.gitnuro.AppEnvInfo_Factory;
import com.jetpackduba.gitnuro.App_MembersInjector;
import com.jetpackduba.gitnuro.Logging;
import com.jetpackduba.gitnuro.Logging_Factory;
import com.jetpackduba.gitnuro.credentials.CredentialsCacheRepository;
import com.jetpackduba.gitnuro.credentials.CredentialsCacheRepository_Factory;
import com.jetpackduba.gitnuro.credentials.CredentialsStateManager;
import com.jetpackduba.gitnuro.credentials.CredentialsStateManager_Factory;
import com.jetpackduba.gitnuro.credentials.GpgCredentialsProvider;
import com.jetpackduba.gitnuro.credentials.SshCredentialsProvider;
import com.jetpackduba.gitnuro.credentials.SshCredentialsProvider_Factory;
import com.jetpackduba.gitnuro.credentials.SshRemoteSession;
import com.jetpackduba.gitnuro.credentials.SshRemoteSession_Factory;
import com.jetpackduba.gitnuro.di.AppComponent;
import com.jetpackduba.gitnuro.di.modules.AppModule;
import com.jetpackduba.gitnuro.di.modules.AppModule_ProvideAppScopeFactory;
import com.jetpackduba.gitnuro.di.modules.AppModule_ProvideClipboardManagerFactory;
import com.jetpackduba.gitnuro.di.modules.NetworkModule;
import com.jetpackduba.gitnuro.di.modules.NetworkModule_ProvideKtorHttpClientFactory;
import com.jetpackduba.gitnuro.di.modules.ShellModule;
import com.jetpackduba.gitnuro.di.modules.ShellModule_ProvideShellManagerFactory;
import com.jetpackduba.gitnuro.di.modules.ShellModule_ProvideTerminalProviderFactory;
import com.jetpackduba.gitnuro.git.AppGpgSigner;
import com.jetpackduba.gitnuro.git.branches.GetBranchesUseCase;
import com.jetpackduba.gitnuro.git.branches.GetBranchesUseCase_Factory;
import com.jetpackduba.gitnuro.git.branches.GetCurrentBranchUseCase;
import com.jetpackduba.gitnuro.git.branches.GetCurrentBranchUseCase_Factory;
import com.jetpackduba.gitnuro.git.branches.GetTrackingBranchUseCase;
import com.jetpackduba.gitnuro.git.branches.GetTrackingBranchUseCase_Factory;
import com.jetpackduba.gitnuro.git.lfs.AuthenticateLfsServerWithSshUseCase;
import com.jetpackduba.gitnuro.git.lfs.AuthenticateLfsServerWithSshUseCase_Factory;
import com.jetpackduba.gitnuro.git.lfs.DownloadLfsObjectUseCase;
import com.jetpackduba.gitnuro.git.lfs.DownloadLfsObjectUseCase_Factory;
import com.jetpackduba.gitnuro.git.lfs.GetLfsObjectsUseCase;
import com.jetpackduba.gitnuro.git.lfs.GetLfsObjectsUseCase_Factory;
import com.jetpackduba.gitnuro.git.lfs.ProvideLfsCredentialsUseCase;
import com.jetpackduba.gitnuro.git.lfs.ProvideLfsCredentialsUseCase_Factory;
import com.jetpackduba.gitnuro.git.lfs.UploadLfsObjectUseCase;
import com.jetpackduba.gitnuro.git.lfs.UploadLfsObjectUseCase_Factory;
import com.jetpackduba.gitnuro.git.lfs.VerifyUploadLfsObjectUseCase;
import com.jetpackduba.gitnuro.git.lfs.VerifyUploadLfsObjectUseCase_Factory;
import com.jetpackduba.gitnuro.lfs.AppLfsFactory;
import com.jetpackduba.gitnuro.lfs.AppLfsFactory_Factory;
import com.jetpackduba.gitnuro.lfs.GetLfsUrlUseCase;
import com.jetpackduba.gitnuro.lfs.GetLfsUrlUseCase_Factory;
import com.jetpackduba.gitnuro.lfs.LfsCleanFilterFactory;
import com.jetpackduba.gitnuro.lfs.LfsCleanFilterFactory_Impl;
import com.jetpackduba.gitnuro.lfs.LfsCleanFilter_Factory;
import com.jetpackduba.gitnuro.lfs.LfsNetworkDataSource;
import com.jetpackduba.gitnuro.lfs.LfsNetworkDataSource_Factory;
import com.jetpackduba.gitnuro.lfs.LfsPrePushHookFactory;
import com.jetpackduba.gitnuro.lfs.LfsPrePushHookFactory_Impl;
import com.jetpackduba.gitnuro.lfs.LfsPrePushHook_Factory;
import com.jetpackduba.gitnuro.lfs.LfsRepository;
import com.jetpackduba.gitnuro.lfs.LfsRepository_Factory;
import com.jetpackduba.gitnuro.lfs.LfsSmudgeFilterFactory;
import com.jetpackduba.gitnuro.lfs.LfsSmudgeFilterFactory_Impl;
import com.jetpackduba.gitnuro.lfs.LfsSmudgeFilter_Factory;
import com.jetpackduba.gitnuro.managers.AppFilesManager;
import com.jetpackduba.gitnuro.managers.AppFilesManager_Factory;
import com.jetpackduba.gitnuro.managers.AppStateManager;
import com.jetpackduba.gitnuro.managers.AppStateManager_Factory;
import com.jetpackduba.gitnuro.managers.FlatpakShellManager;
import com.jetpackduba.gitnuro.managers.FlatpakShellManager_Factory;
import com.jetpackduba.gitnuro.managers.IShellManager;
import com.jetpackduba.gitnuro.managers.ShellManager;
import com.jetpackduba.gitnuro.managers.ShellManager_Factory;
import com.jetpackduba.gitnuro.managers.TempFilesManager;
import com.jetpackduba.gitnuro.managers.TempFilesManager_Factory;
import com.jetpackduba.gitnuro.repositories.AppSettingsRepository;
import com.jetpackduba.gitnuro.repositories.AppSettingsRepository_Factory;
import com.jetpackduba.gitnuro.system.OpenFilePickerUseCase;
import com.jetpackduba.gitnuro.system.OpenFilePickerUseCase_Factory;
import com.jetpackduba.gitnuro.terminal.ITerminalProvider;
import com.jetpackduba.gitnuro.terminal.LinuxTerminalProvider;
import com.jetpackduba.gitnuro.terminal.LinuxTerminalProvider_Factory;
import com.jetpackduba.gitnuro.terminal.MacTerminalProvider;
import com.jetpackduba.gitnuro.terminal.MacTerminalProvider_Factory;
import com.jetpackduba.gitnuro.terminal.WindowsTerminalProvider;
import com.jetpackduba.gitnuro.terminal.WindowsTerminalProvider_Factory;
import com.jetpackduba.gitnuro.ui.TabsManager;
import com.jetpackduba.gitnuro.ui.TabsManager_Factory;
import com.jetpackduba.gitnuro.ui.VerticalSplitPaneConfig;
import com.jetpackduba.gitnuro.ui.VerticalSplitPaneConfig_Factory;
import com.jetpackduba.gitnuro.updates.UpdatesRepository;
import com.jetpackduba.gitnuro.updates.UpdatesRepository_Factory;
import com.jetpackduba.gitnuro.viewmodels.SettingsViewModel;
import com.jetpackduba.gitnuro.viewmodels.SettingsViewModel_Factory;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.ktor.client.HttpClient;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.skiko.ClipboardManager;

@DaggerGenerated
public final class DaggerAppComponent {
    private DaggerAppComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AppComponent create() {
        return new Builder().build();
    }

    public static final class Builder {
        private AppModule appModule;
        private ShellModule shellModule;
        private NetworkModule networkModule;

        private Builder() {
        }

        public Builder appModule(AppModule appModule) {
            this.appModule = (AppModule)Preconditions.checkNotNull((Object)appModule);
            return this;
        }

        public Builder shellModule(ShellModule shellModule) {
            this.shellModule = (ShellModule)Preconditions.checkNotNull((Object)shellModule);
            return this;
        }

        public Builder networkModule(NetworkModule networkModule) {
            this.networkModule = (NetworkModule)Preconditions.checkNotNull((Object)networkModule);
            return this;
        }

        public AppComponent build() {
            if (this.appModule == null) {
                this.appModule = new AppModule();
            }
            if (this.shellModule == null) {
                this.shellModule = new ShellModule();
            }
            if (this.networkModule == null) {
                this.networkModule = new NetworkModule();
            }
            return new AppComponentImpl(this.appModule, this.shellModule, this.networkModule);
        }
    }

    private static final class AppComponentImpl
    implements AppComponent {
        private final ShellModule shellModule;
        private final AppModule appModule;
        private final AppComponentImpl appComponentImpl = this;
        Provider<AppSettingsRepository> appSettingsRepositoryProvider;
        Provider<CoroutineScope> provideAppScopeProvider;
        Provider<AppStateManager> appStateManagerProvider;
        Provider<AppEnvInfo> appEnvInfoProvider;
        Provider<TabsManager> tabsManagerProvider;
        Provider<TempFilesManager> tempFilesManagerProvider;
        Provider<Logging> loggingProvider;
        Provider<CredentialsStateManager> credentialsStateManagerProvider;
        Provider<GetCurrentBranchUseCase> getCurrentBranchUseCaseProvider;
        Provider<GetLfsUrlUseCase> getLfsUrlUseCaseProvider;
        Provider<HttpClient> provideKtorHttpClientProvider;
        Provider<LfsNetworkDataSource> lfsNetworkDataSourceProvider;
        Provider<LfsRepository> lfsRepositoryProvider;
        Provider<CredentialsCacheRepository> credentialsCacheRepositoryProvider;
        Provider<ProvideLfsCredentialsUseCase> provideLfsCredentialsUseCaseProvider;
        Provider<GetLfsObjectsUseCase> getLfsObjectsUseCaseProvider;
        Provider<UploadLfsObjectUseCase> uploadLfsObjectUseCaseProvider;
        Provider<VerifyUploadLfsObjectUseCase> verifyUploadLfsObjectUseCaseProvider;
        Provider<SshCredentialsProvider> sshCredentialsProvider;
        Provider<AuthenticateLfsServerWithSshUseCase> authenticateLfsServerWithSshUseCaseProvider;
        LfsPrePushHook_Factory lfsPrePushHookProvider;
        Provider<LfsPrePushHookFactory> lfsPrePushHookFactoryProvider;
        Provider<DownloadLfsObjectUseCase> downloadLfsObjectUseCaseProvider;
        LfsSmudgeFilter_Factory lfsSmudgeFilterProvider;
        Provider<LfsSmudgeFilterFactory> lfsSmudgeFilterFactoryProvider;
        LfsCleanFilter_Factory lfsCleanFilterProvider;
        Provider<LfsCleanFilterFactory> lfsCleanFilterFactoryProvider;
        Provider<AppLfsFactory> appLfsFactoryProvider;
        Provider<OpenFilePickerUseCase> openFilePickerUseCaseProvider;
        Provider<SettingsViewModel> settingsViewModelProvider;
        Provider<VerticalSplitPaneConfig> verticalSplitPaneConfigProvider;
        Provider<FlatpakShellManager> flatpakShellManagerProvider;
        Provider<IShellManager> provideShellManagerProvider;
        Provider<LinuxTerminalProvider> linuxTerminalProvider;
        Provider<WindowsTerminalProvider> windowsTerminalProvider;
        Provider<MacTerminalProvider> macTerminalProvider;
        Provider<UpdatesRepository> updatesRepositoryProvider;

        AppComponentImpl(AppModule appModuleParam, ShellModule shellModuleParam, NetworkModule networkModuleParam) {
            this.shellModule = shellModuleParam;
            this.appModule = appModuleParam;
            this.initialize(appModuleParam, shellModuleParam, networkModuleParam);
            this.initialize2(appModuleParam, shellModuleParam, networkModuleParam);
        }

        GpgCredentialsProvider gpgCredentialsProvider() {
            return new GpgCredentialsProvider((CredentialsStateManager)this.credentialsStateManagerProvider.get());
        }

        AppGpgSigner appGpgSigner() {
            return new AppGpgSigner(this.gpgCredentialsProvider());
        }

        private void initialize(AppModule appModuleParam, ShellModule shellModuleParam, NetworkModule networkModuleParam) {
            this.appSettingsRepositoryProvider = DoubleCheck.provider((Provider)AppSettingsRepository_Factory.create());
            this.provideAppScopeProvider = AppModule_ProvideAppScopeFactory.create(appModuleParam);
            this.appStateManagerProvider = DoubleCheck.provider((Provider)AppStateManager_Factory.create(this.appSettingsRepositoryProvider, this.provideAppScopeProvider));
            this.appEnvInfoProvider = DoubleCheck.provider((Provider)AppEnvInfo_Factory.create());
            this.tabsManagerProvider = DoubleCheck.provider((Provider)TabsManager_Factory.create(this.appSettingsRepositoryProvider));
            this.tempFilesManagerProvider = DoubleCheck.provider((Provider)TempFilesManager_Factory.create((Provider<AppFilesManager>)AppFilesManager_Factory.create()));
            this.loggingProvider = DoubleCheck.provider((Provider)Logging_Factory.create());
            this.credentialsStateManagerProvider = DoubleCheck.provider((Provider)CredentialsStateManager_Factory.create());
            this.getCurrentBranchUseCaseProvider = GetCurrentBranchUseCase_Factory.create((Provider<GetBranchesUseCase>)GetBranchesUseCase_Factory.create());
            this.getLfsUrlUseCaseProvider = GetLfsUrlUseCase_Factory.create((Provider<GetTrackingBranchUseCase>)GetTrackingBranchUseCase_Factory.create(), this.getCurrentBranchUseCaseProvider);
            this.provideKtorHttpClientProvider = NetworkModule_ProvideKtorHttpClientFactory.create(networkModuleParam);
            this.lfsNetworkDataSourceProvider = LfsNetworkDataSource_Factory.create(this.provideKtorHttpClientProvider);
            this.lfsRepositoryProvider = LfsRepository_Factory.create(this.lfsNetworkDataSourceProvider);
            this.credentialsCacheRepositoryProvider = DoubleCheck.provider((Provider)CredentialsCacheRepository_Factory.create());
            this.provideLfsCredentialsUseCaseProvider = ProvideLfsCredentialsUseCase_Factory.create(this.credentialsCacheRepositoryProvider, this.credentialsStateManagerProvider);
            this.getLfsObjectsUseCaseProvider = GetLfsObjectsUseCase_Factory.create(this.lfsRepositoryProvider, this.provideLfsCredentialsUseCaseProvider);
            this.uploadLfsObjectUseCaseProvider = UploadLfsObjectUseCase_Factory.create(this.lfsRepositoryProvider, this.provideLfsCredentialsUseCaseProvider);
            this.verifyUploadLfsObjectUseCaseProvider = VerifyUploadLfsObjectUseCase_Factory.create(this.lfsRepositoryProvider, this.provideLfsCredentialsUseCaseProvider);
            this.sshCredentialsProvider = SshCredentialsProvider_Factory.create(this.credentialsStateManagerProvider, this.credentialsCacheRepositoryProvider, this.appSettingsRepositoryProvider);
            this.authenticateLfsServerWithSshUseCaseProvider = AuthenticateLfsServerWithSshUseCase_Factory.create((Provider<SshRemoteSession>)SshRemoteSession_Factory.create(), this.sshCredentialsProvider);
            this.lfsPrePushHookProvider = LfsPrePushHook_Factory.create(this.getLfsUrlUseCaseProvider, this.getLfsObjectsUseCaseProvider, this.uploadLfsObjectUseCaseProvider, this.verifyUploadLfsObjectUseCaseProvider, this.authenticateLfsServerWithSshUseCaseProvider);
            this.lfsPrePushHookFactoryProvider = LfsPrePushHookFactory_Impl.createFactoryProvider(this.lfsPrePushHookProvider);
            this.downloadLfsObjectUseCaseProvider = DownloadLfsObjectUseCase_Factory.create(this.lfsRepositoryProvider, this.provideLfsCredentialsUseCaseProvider);
            this.lfsSmudgeFilterProvider = LfsSmudgeFilter_Factory.create(this.getLfsUrlUseCaseProvider, this.getLfsObjectsUseCaseProvider, this.authenticateLfsServerWithSshUseCaseProvider, this.downloadLfsObjectUseCaseProvider);
            this.lfsSmudgeFilterFactoryProvider = LfsSmudgeFilterFactory_Impl.createFactoryProvider(this.lfsSmudgeFilterProvider);
        }

        private void initialize2(AppModule appModuleParam, ShellModule shellModuleParam, NetworkModule networkModuleParam) {
            this.lfsCleanFilterProvider = LfsCleanFilter_Factory.create();
            this.lfsCleanFilterFactoryProvider = LfsCleanFilterFactory_Impl.createFactoryProvider(this.lfsCleanFilterProvider);
            this.appLfsFactoryProvider = DoubleCheck.provider((Provider)AppLfsFactory_Factory.create(this.lfsPrePushHookFactoryProvider, this.lfsSmudgeFilterFactoryProvider, this.lfsCleanFilterFactoryProvider));
            this.openFilePickerUseCaseProvider = OpenFilePickerUseCase_Factory.create((Provider<ShellManager>)ShellManager_Factory.create());
            this.settingsViewModelProvider = DoubleCheck.provider((Provider)SettingsViewModel_Factory.create(this.appSettingsRepositoryProvider, this.openFilePickerUseCaseProvider, this.loggingProvider, this.provideAppScopeProvider));
            this.verticalSplitPaneConfigProvider = DoubleCheck.provider((Provider)VerticalSplitPaneConfig_Factory.create(this.appSettingsRepositoryProvider));
            this.flatpakShellManagerProvider = FlatpakShellManager_Factory.create((Provider<ShellManager>)ShellManager_Factory.create());
            this.provideShellManagerProvider = ShellModule_ProvideShellManagerFactory.create(shellModuleParam, this.appEnvInfoProvider, (Provider<ShellManager>)ShellManager_Factory.create(), this.flatpakShellManagerProvider);
            this.linuxTerminalProvider = LinuxTerminalProvider_Factory.create(this.provideShellManagerProvider);
            this.windowsTerminalProvider = WindowsTerminalProvider_Factory.create(this.provideShellManagerProvider);
            this.macTerminalProvider = MacTerminalProvider_Factory.create(this.provideShellManagerProvider);
            this.updatesRepositoryProvider = DoubleCheck.provider((Provider)UpdatesRepository_Factory.create(this.provideKtorHttpClientProvider, this.provideAppScopeProvider));
        }

        @Override
        public void inject(App main) {
            this.injectApp(main);
        }

        @Override
        public AppStateManager appStateManager() {
            return (AppStateManager)this.appStateManagerProvider.get();
        }

        @Override
        public SettingsViewModel settingsViewModel() {
            return (SettingsViewModel)this.settingsViewModelProvider.get();
        }

        @Override
        public CredentialsStateManager credentialsStateManager() {
            return (CredentialsStateManager)this.credentialsStateManagerProvider.get();
        }

        @Override
        public AppSettingsRepository appPreferences() {
            return (AppSettingsRepository)this.appSettingsRepositoryProvider.get();
        }

        @Override
        public VerticalSplitPaneConfig verticalSplitPaneConfig() {
            return (VerticalSplitPaneConfig)this.verticalSplitPaneConfigProvider.get();
        }

        @Override
        public AppEnvInfo appEnvInfo() {
            return (AppEnvInfo)this.appEnvInfoProvider.get();
        }

        @Override
        public TabsManager tabsManager() {
            return (TabsManager)this.tabsManagerProvider.get();
        }

        @Override
        public IShellManager shellManager() {
            return ShellModule_ProvideShellManagerFactory.provideShellManager(this.shellModule, (AppEnvInfo)this.appEnvInfoProvider.get(), (javax.inject.Provider<ShellManager>)ShellManager_Factory.create(), this.flatpakShellManagerProvider);
        }

        @Override
        public ITerminalProvider terminalProvider() {
            return ShellModule_ProvideTerminalProviderFactory.provideTerminalProvider(this.shellModule, this.linuxTerminalProvider, this.windowsTerminalProvider, this.macTerminalProvider);
        }

        @Override
        public TempFilesManager tempFilesManager() {
            return (TempFilesManager)this.tempFilesManagerProvider.get();
        }

        @Override
        public UpdatesRepository updatesRepository() {
            return (UpdatesRepository)this.updatesRepositoryProvider.get();
        }

        @Override
        public CredentialsCacheRepository credentialsCacheRepository() {
            return (CredentialsCacheRepository)this.credentialsCacheRepositoryProvider.get();
        }

        @Override
        public ClipboardManager clipboardManager() {
            return AppModule_ProvideClipboardManagerFactory.provideClipboardManager(this.appModule);
        }

        @CanIgnoreReturnValue
        private App injectApp(App instance) {
            App_MembersInjector.injectAppStateManager(instance, (AppStateManager)this.appStateManagerProvider.get());
            App_MembersInjector.injectAppSettingsRepository(instance, (AppSettingsRepository)this.appSettingsRepositoryProvider.get());
            App_MembersInjector.injectAppEnvInfo(instance, (AppEnvInfo)this.appEnvInfoProvider.get());
            App_MembersInjector.injectTabsManager(instance, (TabsManager)this.tabsManagerProvider.get());
            App_MembersInjector.injectTempFilesManager(instance, (TempFilesManager)this.tempFilesManagerProvider.get());
            App_MembersInjector.injectLogging(instance, (Logging)this.loggingProvider.get());
            App_MembersInjector.injectSigner(instance, this.appGpgSigner());
            App_MembersInjector.injectLfsFactory(instance, (AppLfsFactory)((Object)this.appLfsFactoryProvider.get()));
            return instance;
        }
    }
}

