/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.credentials;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.credentials.SshProcess;
import com.jetpackduba.gitnuro.exceptions.SshException;
import com.jetpackduba.gitnuro.extensions.StringExtensionsKt;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetpackduba/gitnuro/credentials/SshRemoteSession;", "Lorg/eclipse/jgit/transport/RemoteSession;", "<init>", "()V", "session", "LSession;", "process", "Lcom/jetpackduba/gitnuro/credentials/SshProcess;", "exec", "Ljava/lang/Process;", "commandName", "", "timeout", "", "disconnect", "", "setup", "uri", "Lorg/eclipse/jgit/transport/URIish;", "sshCredentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class SshRemoteSession
implements RemoteSession {
    private Session session;
    private SshProcess process;
    public static final int $stable = 8;

    @Inject
    public SshRemoteSession() {
    }

    @NotNull
    public Process exec(@NotNull String commandName, int timeout) {
        Session session;
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        System.out.println((Object)("Running command " + commandName));
        this.process = new SshProcess();
        SshProcess sshProcess = this.process;
        if (sshProcess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            sshProcess = null;
        }
        if ((session = this.session) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            session = null;
        }
        sshProcess.setup(session, commandName);
        SshProcess sshProcess2 = this.process;
        if (sshProcess2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            sshProcess2 = null;
        }
        return sshProcess2;
    }

    public void disconnect() {
        SshProcess sshProcess = this.process;
        if (sshProcess == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            sshProcess = null;
        }
        sshProcess.closeChannel();
        Session session = this.session;
        if (session == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            session = null;
        }
        session.disconnect();
    }

    public final void setup(@NotNull URIish uri, @NotNull CredentialsProvider sshCredentialsProvider) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)sshCredentialsProvider, (String)"sshCredentialsProvider");
        Session session = Session.Companion.new();
        if (session == null) {
            throw new SshException("Could not obtain the session, this is likely a bug. Please file a report.");
        }
        Session session2 = session;
        Integer port = uri.getPort() == -1 ? null : Integer.valueOf(uri.getPort());
        String string2 = uri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
        String string3 = uri.getUser();
        if (string3 == null) {
            string3 = "";
        }
        StringExtensionsKt.throwIfSshMessage(session2.setup(string2, string3, port));
        int result = session2.publicKeyAuth("");
        if (result == 2) {
            CredentialItem.Password passwordCredentialItem = new CredentialItem.Password();
            CredentialItem[] credentialItemArray = new CredentialItem[]{passwordCredentialItem};
            sshCredentialsProvider.get(uri, credentialItemArray);
            char[] cArray = passwordCredentialItem.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getValue(...)");
            String password = ArraysKt.joinToString$default((char[])cArray, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            result = session2.publicKeyAuth(password);
            if (result != 1) {
                result = session2.passwordAuth(password);
            }
        }
        if (result != 1) {
            throw new Exception("Something went wrong with authentication. Code " + result);
        }
        this.session = session2;
    }
}

