/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.credentials;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.credentials.CredentialsAccepted;
import com.jetpackduba.gitnuro.credentials.CredentialsCacheRepository;
import com.jetpackduba.gitnuro.credentials.CredentialsCacheType;
import com.jetpackduba.gitnuro.credentials.CredentialsStateManager;
import com.jetpackduba.gitnuro.git.remote_operations.CredentialsCache;
import com.jetpackduba.gitnuro.repositories.AppSettingsRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J!\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J,\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetpackduba/gitnuro/credentials/SshCredentialsProvider;", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "Lcom/jetpackduba/gitnuro/git/remote_operations/CredentialsCache;", "credentialsStateManager", "Lcom/jetpackduba/gitnuro/credentials/CredentialsStateManager;", "credentialsCacheRepository", "Lcom/jetpackduba/gitnuro/credentials/CredentialsCacheRepository;", "appSettingsRepository", "Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;", "<init>", "(Lcom/jetpackduba/gitnuro/credentials/CredentialsStateManager;Lcom/jetpackduba/gitnuro/credentials/CredentialsCacheRepository;Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;)V", "credentialsCached", "Lcom/jetpackduba/gitnuro/credentials/CredentialsCacheType$SshCredentialsCache;", "isInteractive", "", "supports", "items", "", "Lorg/eclipse/jgit/transport/CredentialItem;", "([Lorg/eclipse/jgit/transport/CredentialItem;)Z", "get", "uri", "Lorg/eclipse/jgit/transport/URIish;", "(Lorg/eclipse/jgit/transport/URIish;[Lorg/eclipse/jgit/transport/CredentialItem;)Z", "cacheCredentialsIfNeeded", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Gitnuro"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSshCredentialsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshCredentialsProvider.kt\ncom/jetpackduba/gitnuro/credentials/SshCredentialsProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,59:1\n4135#2,11:60\n*S KotlinDebug\n*F\n+ 1 SshCredentialsProvider.kt\ncom/jetpackduba/gitnuro/credentials/SshCredentialsProvider\n*L\n28#1:60,11\n*E\n"})
public final class SshCredentialsProvider
extends CredentialsProvider
implements CredentialsCache {
    @NotNull
    private final CredentialsStateManager credentialsStateManager;
    @NotNull
    private final CredentialsCacheRepository credentialsCacheRepository;
    @NotNull
    private final AppSettingsRepository appSettingsRepository;
    @Nullable
    private CredentialsCacheType.SshCredentialsCache credentialsCached;
    public static final int $stable = 8;

    @Inject
    public SshCredentialsProvider(@NotNull CredentialsStateManager credentialsStateManager, @NotNull CredentialsCacheRepository credentialsCacheRepository, @NotNull AppSettingsRepository appSettingsRepository) {
        Intrinsics.checkNotNullParameter((Object)credentialsStateManager, (String)"credentialsStateManager");
        Intrinsics.checkNotNullParameter((Object)credentialsCacheRepository, (String)"credentialsCacheRepository");
        Intrinsics.checkNotNullParameter((Object)appSettingsRepository, (String)"appSettingsRepository");
        this.credentialsStateManager = credentialsStateManager;
        this.credentialsCacheRepository = credentialsCacheRepository;
        this.appSettingsRepository = appSettingsRepository;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items2) {
        Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
        return items2.length == 1 && ArraysKt.first((Object[])items2) instanceof CredentialItem.Password;
    }

    /*
     * WARNING - void declaration
     */
    public boolean get(@Nullable URIish uri, CredentialItem ... items2) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
        CredentialItem[] credentialItemArray = items2;
        boolean $i$f$filterIsInstance = false;
        void var6_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CredentialItem.Password)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        CredentialItem.Password passwordItem = (CredentialItem.Password)CollectionsKt.first((List)((List)destination$iv$iv));
        CredentialsCacheType.SshCredentialsCache cachedCredentials = this.credentialsCacheRepository.getCachedSshCredentials(String.valueOf(uri));
        boolean cacheCredentialsInMemory = this.appSettingsRepository.getCacheCredentialsInMemory();
        if (cachedCredentials == null || !cacheCredentialsInMemory) {
            CredentialsAccepted.SshCredentialsAccepted sshCredentials2 = (CredentialsAccepted.SshCredentialsAccepted)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CredentialsAccepted.SshCredentialsAccepted>, Object>(this, null){
                int label;
                final /* synthetic */ SshCredentialsProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = SshCredentialsProvider.access$getCredentialsStateManager$p(this.this$0).requestSshCredentials((Continuation<? super CredentialsAccepted.SshCredentialsAccepted>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super CredentialsAccepted.SshCredentialsAccepted> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            char[] cArray = sshCredentials2.getPassword().toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            passwordItem.setValue(cArray);
            if (cacheCredentialsInMemory) {
                this.credentialsCached = new CredentialsCacheType.SshCredentialsCache(String.valueOf(uri), sshCredentials2.getPassword());
            }
        } else {
            char[] cArray = cachedCredentials.getPassword().toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            passwordItem.setValue(cArray);
        }
        return true;
    }

    @Override
    @Nullable
    public Object cacheCredentialsIfNeeded(@NotNull Continuation<? super Unit> $completion) {
        CredentialsCacheType.SshCredentialsCache sshCredentialsCache = this.credentialsCached;
        if (sshCredentialsCache != null) {
            CredentialsCacheType.SshCredentialsCache cached = sshCredentialsCache;
            boolean bl = false;
            Object object = this.credentialsCacheRepository.cacheSshCredentials(cached.getUrl(), cached.getPassword(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CredentialsStateManager access$getCredentialsStateManager$p(SshCredentialsProvider $this) {
        return $this.credentialsStateManager;
    }
}

