/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.credentials;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.credentials.CredentialsAccepted;
import com.jetpackduba.gitnuro.credentials.CredentialsCacheRepository;
import com.jetpackduba.gitnuro.credentials.CredentialsCacheType;
import com.jetpackduba.gitnuro.credentials.CredentialsStateManager;
import com.jetpackduba.gitnuro.credentials.ExternalCredentialsHelper;
import com.jetpackduba.gitnuro.credentials.ExternalCredentialsRequestResult;
import com.jetpackduba.gitnuro.exceptions.NotSupportedHelper;
import com.jetpackduba.gitnuro.git.remote_operations.CredentialsCache;
import com.jetpackduba.gitnuro.logging.LoggerKt;
import com.jetpackduba.gitnuro.managers.IShellManager;
import com.jetpackduba.gitnuro.repositories.AppSettingsRepository;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B5\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J%\u0010\u0015\u001a\u00020\u00142\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u0017\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J*\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\"\u00020\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J-\u0010%\u001a\u00020&2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010'J\u001c\u0010(\u001a\u0004\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010)\u001a\u00020\u001fH\u0096@\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetpackduba/gitnuro/credentials/HttpCredentialsProvider;", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "Lcom/jetpackduba/gitnuro/git/remote_operations/CredentialsCache;", "credentialsStateManager", "Lcom/jetpackduba/gitnuro/credentials/CredentialsStateManager;", "shellManager", "Lcom/jetpackduba/gitnuro/managers/IShellManager;", "appSettingsRepository", "Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;", "credentialsCacheRepository", "Lcom/jetpackduba/gitnuro/credentials/CredentialsCacheRepository;", "git", "Lorg/eclipse/jgit/api/Git;", "<init>", "(Lcom/jetpackduba/gitnuro/credentials/CredentialsStateManager;Lcom/jetpackduba/gitnuro/managers/IShellManager;Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;Lcom/jetpackduba/gitnuro/credentials/CredentialsCacheRepository;Lorg/eclipse/jgit/api/Git;)V", "getGit", "()Lorg/eclipse/jgit/api/Git;", "credentialsCached", "Lcom/jetpackduba/gitnuro/credentials/CredentialsCacheType$HttpCredentialsCache;", "isInteractive", "", "supports", "items", "", "Lorg/eclipse/jgit/transport/CredentialItem;", "([Lorg/eclipse/jgit/transport/CredentialItem;)Z", "get", "uri", "Lorg/eclipse/jgit/transport/URIish;", "(Lorg/eclipse/jgit/transport/URIish;[Lorg/eclipse/jgit/transport/CredentialItem;)Z", "saveCredentialsInExternalHelper", "", "externalCredentialsHelper", "Lcom/jetpackduba/gitnuro/credentials/ExternalCredentialsHelper;", "credentials", "Lcom/jetpackduba/gitnuro/credentials/CredentialsAccepted$HttpCredentialsAccepted;", "askForCredentials", "handleExternalCredentialHelper", "Lcom/jetpackduba/gitnuro/credentials/ExternalCredentialsRequestResult;", "(Lcom/jetpackduba/gitnuro/credentials/ExternalCredentialsHelper;Lorg/eclipse/jgit/transport/URIish;[Lorg/eclipse/jgit/transport/CredentialItem;)Lcom/jetpackduba/gitnuro/credentials/ExternalCredentialsRequestResult;", "getExternalCredentialsHelper", "cacheCredentialsIfNeeded", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Gitnuro"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHttpCredentialsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpCredentialsProvider.kt\ncom/jetpackduba/gitnuro/credentials/HttpCredentialsProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n11228#2:298\n11563#2,3:299\n12637#2,2:302\n11228#2:304\n11563#2,3:305\n4135#2,11:308\n4135#2,11:321\n4135#2,11:332\n1310#2,2:344\n1310#2,2:346\n295#3,2:319\n1#4:343\n*S KotlinDebug\n*F\n+ 1 HttpCredentialsProvider.kt\ncom/jetpackduba/gitnuro/credentials/HttpCredentialsProvider\n*L\n39#1:298\n39#1:299,3\n46#1:302,2\n52#1:304\n52#1:305,3\n57#1:308,11\n61#1:321,11\n65#1:332,11\n200#1:344,2\n211#1:346,2\n58#1:319,2\n*E\n"})
public final class HttpCredentialsProvider
extends CredentialsProvider
implements CredentialsCache {
    @NotNull
    private final CredentialsStateManager credentialsStateManager;
    @NotNull
    private final IShellManager shellManager;
    @NotNull
    private final AppSettingsRepository appSettingsRepository;
    @NotNull
    private final CredentialsCacheRepository credentialsCacheRepository;
    @Nullable
    private final Git git;
    @Nullable
    private CredentialsCacheType.HttpCredentialsCache credentialsCached;
    public static final int $stable = 8;

    @AssistedInject
    public HttpCredentialsProvider(@NotNull CredentialsStateManager credentialsStateManager, @NotNull IShellManager shellManager, @NotNull AppSettingsRepository appSettingsRepository, @NotNull CredentialsCacheRepository credentialsCacheRepository, @Assisted @Nullable Git git) {
        Intrinsics.checkNotNullParameter((Object)credentialsStateManager, (String)"credentialsStateManager");
        Intrinsics.checkNotNullParameter((Object)shellManager, (String)"shellManager");
        Intrinsics.checkNotNullParameter((Object)appSettingsRepository, (String)"appSettingsRepository");
        Intrinsics.checkNotNullParameter((Object)credentialsCacheRepository, (String)"credentialsCacheRepository");
        this.credentialsStateManager = credentialsStateManager;
        this.shellManager = shellManager;
        this.appSettingsRepository = appSettingsRepository;
        this.credentialsCacheRepository = credentialsCacheRepository;
        this.git = git;
    }

    @Nullable
    public final Git getGit() {
        return this.git;
    }

    public boolean isInteractive() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean supports(CredentialItem ... items2) {
        boolean bl;
        boolean isUserPasswordAuth;
        boolean isEmpty;
        block2: {
            int n;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
            CredentialItem[] $this$map$iv = items2;
            boolean $i$f$map = false;
            CredentialItem[] credentialItemArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (n = 0; n < n2; ++n) {
                void credentialItem;
                void item$iv$iv;
                void var11_12 = item$iv$iv = $this$mapTo$iv$iv[n];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void v0 = credentialItem;
                collection.add(v0 != null ? v0.getPromptText() : null);
            }
            List fields = (List)destination$iv$iv;
            isEmpty = fields.isEmpty();
            isUserPasswordAuth = fields.size() == 2 && fields.contains("Username") && fields.contains("Password");
            CredentialItem[] $this$any$iv = items2;
            boolean $i$f$any = false;
            n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                CredentialItem element$iv;
                CredentialItem it = element$iv = $this$any$iv[n];
                boolean bl3 = false;
                if (!(it instanceof CredentialItem.YesNoType)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        boolean isAskingForSslDisable = bl;
        return isEmpty || isUserPasswordAuth || isAskingForSslDisable;
    }

    /*
     * WARNING - void declaration
     */
    public boolean get(@NotNull URIish uri, CredentialItem ... items2) {
        ExternalCredentialsHelper externalCredentialsHelper;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstance$iv2;
        Object v3;
        Object element$iv2;
        block15: {
            void $this$firstOrNull$iv;
            Iterator $this$filterIsInstanceTo$iv$iv3;
            Iterable $this$filterIsInstance$iv3;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
            CredentialItem[] $this$map$iv = items2;
            boolean $i$f$map22 = false;
            CredentialItem[] credentialItemArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_23 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName() + " - " + it.getPromptText());
            }
            List itemsMap = (List)destination$iv$iv;
            LoggerKt.printLog("HttpCredentialsProvider", "Items are " + itemsMap);
            CredentialItem[] $i$f$map22 = items2;
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv3;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
                if (!(element$iv$iv instanceof CredentialItem.YesNoType)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv3 = (List)destination$iv$iv2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                CredentialItem.YesNoType it = (CredentialItem.YesNoType)element$iv2;
                boolean bl = false;
                String string2 = it.getPromptText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPromptText(...)");
                CharSequence charSequence = string2;
                String string3 = JGitText.get().sslTrustNow;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sslTrustNow");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) continue;
                v3 = element$iv2;
                break block15;
            }
            v3 = null;
        }
        CredentialItem.YesNoType sslTrustNowItem = v3;
        CredentialItem[] $i$f$firstOrNull = items2;
        boolean $i$f$filterIsInstance22 = false;
        element$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        int n = ((void)$this$filterIsInstanceTo$iv$iv2).length;
        for (int item$iv$iv = 0; item$iv$iv < n; ++item$iv$iv) {
            void element$iv$iv = $this$filterIsInstanceTo$iv$iv2[item$iv$iv];
            if (!(element$iv$iv instanceof CredentialItem.Username)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        CredentialItem.Username userItem = (CredentialItem.Username)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        CredentialItem[] $i$f$filterIsInstance22 = items2;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CredentialItem.Password)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        CredentialItem.Password passwordItem = (CredentialItem.Password)CollectionsKt.firstOrNull((List)((List)destination$iv$iv3));
        if (userItem == null || passwordItem == null) {
            return false;
        }
        if (sslTrustNowItem != null) {
            sslTrustNowItem.setValue(this.appSettingsRepository.getVerifySsl());
        }
        if ((externalCredentialsHelper = this.getExternalCredentialsHelper(uri, this.git)) == null) {
            String string4 = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            CredentialsCacheType.HttpCredentialsCache cachedCredentials = this.credentialsCacheRepository.getCachedHttpCredentials(string4, false);
            if (cachedCredentials == null || !this.appSettingsRepository.getCacheCredentialsInMemory()) {
                CredentialsAccepted.HttpCredentialsAccepted credentials2 = this.askForCredentials();
                userItem.setValue(credentials2.getUser());
                char[] cArray = credentials2.getPassword().toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                passwordItem.setValue(cArray);
                if (this.appSettingsRepository.getCacheCredentialsInMemory()) {
                    String string5 = uri.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                    this.credentialsCached = new CredentialsCacheType.HttpCredentialsCache(string5, credentials2.getUser(), credentials2.getPassword(), false);
                }
                return true;
            }
            userItem.setValue(cachedCredentials.getUser());
            char[] cArray = cachedCredentials.getPassword().toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            passwordItem.setValue(cArray);
            return true;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.handleExternalCredentialHelper(externalCredentialsHelper, uri, items2).ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                CredentialsAccepted.HttpCredentialsAccepted credentials3 = this.askForCredentials();
                userItem.setValue(credentials3.getUser());
                char[] cArray = credentials3.getPassword().toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                passwordItem.setValue(cArray);
                this.saveCredentialsInExternalHelper(uri, externalCredentialsHelper, credentials3);
                return true;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveCredentialsInExternalHelper(URIish uri, ExternalCredentialsHelper externalCredentialsHelper, CredentialsAccepted.HttpCredentialsAccepted credentials2) {
        List arguments = CollectionsKt.listOf((Object)"store");
        Process process = this.shellManager.runCommandProcess(CollectionsKt.plus((Collection)externalCredentialsHelper.sanitizedCommand(), (Iterable)arguments));
        OutputStream output = process.getOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(output));
        Closeable closeable = bufferedWriter;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            bufferedWriter.write("protocol=" + uri.getScheme() + "\n");
            bufferedWriter.write("host=" + uri.getHost() + "\n");
            if (externalCredentialsHelper.getUseHttpPath()) {
                bufferedWriter.write("path=" + uri.getPath() + "\n");
            }
            bufferedWriter.write("username=" + credentials2.getUser() + "\n");
            bufferedWriter.write("password=" + credentials2.getPassword() + "\n");
            bufferedWriter.write("");
            bufferedWriter.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final CredentialsAccepted.HttpCredentialsAccepted askForCredentials() {
        return (CredentialsAccepted.HttpCredentialsAccepted)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CredentialsAccepted.HttpCredentialsAccepted>, Object>(this, null){
            int label;
            final /* synthetic */ HttpCredentialsProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HttpCredentialsProvider.access$getCredentialsStateManager$p(this.this$0).requestHttpCredentials((Continuation<? super CredentialsAccepted.HttpCredentialsAccepted>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super CredentialsAccepted.HttpCredentialsAccepted> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExternalCredentialsRequestResult handleExternalCredentialHelper(ExternalCredentialsHelper externalCredentialsHelper, URIish uri, CredentialItem[] items2) {
        Object object;
        List arguments = CollectionsKt.listOf((Object)"get");
        Process process = this.shellManager.runCommandProcess(CollectionsKt.plus((Collection)externalCredentialsHelper.sanitizedCommand(), (Iterable)arguments));
        OutputStream output = process.getOutputStream();
        InputStream input = process.getInputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(output));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input));
        Closeable closeable = bufferedWriter;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            bufferedWriter.write("protocol=" + uri.getScheme() + "\n");
            bufferedWriter.write("host=" + uri.getHost() + "\n");
            if (externalCredentialsHelper.getUseHttpPath()) {
                bufferedWriter.write("path=" + uri.getPath() + "\n");
            }
            bufferedWriter.write("");
            bufferedWriter.flush();
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        boolean usernameSet = false;
        boolean passwordSet = false;
        process.waitFor(1L, TimeUnit.MINUTES);
        if (process.isAlive()) {
            process.destroy();
            return ExternalCredentialsRequestResult.FAIL;
        }
        object = bufferedReader;
        Throwable throwable3 = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl = false;
            Ref.ObjectRef line = new Ref.ObjectRef();
            while (true) {
                CredentialItem passwordItem;
                CredentialItem credentialItem;
                String password;
                block22: {
                    String string2;
                    CredentialItem it2;
                    CredentialItem element$iv;
                    int n;
                    int n2;
                    boolean $i$f$firstOrNull;
                    CredentialItem[] $this$firstOrNull$iv;
                    List split;
                    String safeLine;
                    String string3;
                    String it3 = string3 = bufferedReader.readLine();
                    boolean bl22 = false;
                    line.element = it3;
                    if (string3 == null || usernameSet && passwordSet) break;
                    if ((String)line.element == null) continue;
                    if (StringsKt.startsWith$default((String)safeLine, (String)"username=", (boolean)false, (int)2, null)) {
                        CredentialItem userNameItem;
                        CredentialItem credentialItem2;
                        String userName;
                        block21: {
                            String string4;
                            String[] bl22 = new String[]{"="};
                            split = StringsKt.split$default((CharSequence)safeLine, (String[])bl22, (boolean)false, (int)0, (int)6, null);
                            if ((String)CollectionsKt.getOrNull((List)split, (int)1) == null) {
                                ExternalCredentialsRequestResult externalCredentialsRequestResult = ExternalCredentialsRequestResult.CREDENTIALS_NOT_STORED;
                                return externalCredentialsRequestResult;
                            }
                            userName = string4;
                            $this$firstOrNull$iv = items2;
                            $i$f$firstOrNull = false;
                            n2 = $this$firstOrNull$iv.length;
                            for (n = 0; n < n2; ++n) {
                                it2 = element$iv = $this$firstOrNull$iv[n];
                                boolean bl3 = false;
                                if (!(it2 instanceof CredentialItem.Username)) continue;
                                credentialItem2 = element$iv;
                                break block21;
                            }
                            credentialItem2 = null;
                        }
                        if (!((userNameItem = credentialItem2) instanceof CredentialItem.Username)) continue;
                        ((CredentialItem.Username)userNameItem).setValue(userName);
                        usernameSet = true;
                        continue;
                    }
                    if (!StringsKt.startsWith$default((String)safeLine, (String)"password=", (boolean)false, (int)2, null)) continue;
                    String[] userName = new String[]{"="};
                    split = StringsKt.split$default((CharSequence)safeLine, (String[])userName, (boolean)false, (int)0, (int)6, null);
                    if ((String)CollectionsKt.getOrNull((List)split, (int)1) == null) {
                        ExternalCredentialsRequestResult externalCredentialsRequestResult = ExternalCredentialsRequestResult.CREDENTIALS_NOT_STORED;
                        return externalCredentialsRequestResult;
                    }
                    password = string2;
                    $this$firstOrNull$iv = items2;
                    $i$f$firstOrNull = false;
                    n2 = $this$firstOrNull$iv.length;
                    for (n = 0; n < n2; ++n) {
                        it2 = element$iv = $this$firstOrNull$iv[n];
                        boolean bl4 = false;
                        if (!(it2 instanceof CredentialItem.Password)) continue;
                        credentialItem = element$iv;
                        break block22;
                    }
                    credentialItem = null;
                }
                if (!((passwordItem = credentialItem) instanceof CredentialItem.Password)) continue;
                CredentialItem.Password password2 = (CredentialItem.Password)passwordItem;
                char[] cArray = password.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                password2.setValue(cArray);
                passwordSet = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable3);
        }
        return usernameSet && passwordSet ? ExternalCredentialsRequestResult.SUCCESS : ExternalCredentialsRequestResult.CREDENTIALS_NOT_STORED;
    }

    private final ExternalCredentialsHelper getExternalCredentialsHelper(URIish uri, Git git) {
        Config config;
        if (git == null) {
            Config config2;
            String homePath = System.getProperty("user.home");
            File configFile = new File(homePath + "/.gitconfig");
            Config $this$getExternalCredentialsHelper_u24lambda_u2410 = config2 = new Config();
            boolean bl = false;
            if (configFile.exists()) {
                $this$getExternalCredentialsHelper_u24lambda_u2410.fromText(FilesKt.readText$default((File)configFile, null, (int)1, null));
            }
            config = config2;
        } else {
            config = (Config)git.getRepository().getConfig();
        }
        Config config3 = config;
        String hostWithProtocol = uri.getScheme() + "://" + uri.getHost();
        String genericCredentialHelper = config3.getString("credential", null, "helper");
        String uriSpecificCredentialHelper = config3.getString("credential", hostWithProtocol, "helper");
        String string2 = uriSpecificCredentialHelper;
        if (string2 == null && (string2 = genericCredentialHelper) == null) {
            return null;
        }
        String credentialHelperPath = string2;
        if (Intrinsics.areEqual((Object)credentialHelperPath, (Object)"cache") || Intrinsics.areEqual((Object)credentialHelperPath, (Object)"store")) {
            LoggerKt.printError$default("HttpCredentialsProvider", "Invalid credentials helper: \"" + credentialHelperPath + "\" is not yet supported", null, 4, null);
            return null;
        }
        if (Intrinsics.areEqual((Object)credentialHelperPath, (Object)"manager-core")) {
            throw new NotSupportedHelper("Invalid credentials helper \"" + credentialHelperPath + "\". Please specify the full path of Git Credential Manager in your .gitconfig");
        }
        String uriSpecificUseHttpHelper = config3.getString("credential", hostWithProtocol, "useHttpPath");
        boolean genericUseHttpHelper = config3.getBoolean("credential", "useHttpPath", false);
        String string3 = uriSpecificUseHttpHelper;
        boolean useHttpPath = string3 != null ? Boolean.parseBoolean(string3) : genericUseHttpHelper;
        return new ExternalCredentialsHelper(credentialHelperPath, useHttpPath);
    }

    @Override
    @Nullable
    public Object cacheCredentialsIfNeeded(@NotNull Continuation<? super Unit> $completion) {
        CredentialsCacheType.HttpCredentialsCache httpCredentialsCache = this.credentialsCached;
        if (httpCredentialsCache != null) {
            CredentialsCacheType.HttpCredentialsCache it = httpCredentialsCache;
            boolean bl = false;
            Object object = this.credentialsCacheRepository.cacheHttpCredentials(it, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CredentialsStateManager access$getCredentialsStateManager$p(HttpCredentialsProvider $this) {
        return $this.credentialsStateManager;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExternalCredentialsRequestResult.values().length];
            try {
                nArray[ExternalCredentialsRequestResult.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalCredentialsRequestResult.FAIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalCredentialsRequestResult.CREDENTIALS_NOT_STORED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

