/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.extensions.FileExtensionsKt;
import com.jetpackduba.gitnuro.system.OS;
import com.jetpackduba.gitnuro.system.OSKt;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J\u0006\u0010\u0010\u001a\u00020\u0011R\u001b\u0010\u000b\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/jetpackduba/gitnuro/Logging;", "", "<init>", "()V", "initLogging", "", "defaultLogsPath", "Ljava/io/File;", "macLogsDirectory", "windowsLogsDirectory", "linuxLogsDirectory", "logsDirectory", "getLogsDirectory", "()Ljava/io/File;", "logsDirectory$delegate", "Lkotlin/Lazy;", "logsFile", "", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class Logging {
    @NotNull
    private final Lazy logsDirectory$delegate = LazyKt.lazy(() -> Logging.logsDirectory_delegate$lambda$1(this));
    public static final int $stable = 8;

    @Inject
    public Logging() {
    }

    public final void initLogging() {
        Logger logger;
        PatternLayout layout = new PatternLayout("%d{yyyy-MM-dd HH:mm:ss} %-5p %c{1}:%L - %m%n");
        String filePath = this.logsFile();
        RollingFileAppender fileAppender = new RollingFileAppender((Layout)layout, filePath, true);
        fileAppender.setMaximumFileSize(0xA00000L);
        fileAppender.setMaxBackupIndex(5);
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
        Logger $this$initLogging_u24lambda_u240 = logger = LogManager.getRootLogger();
        boolean bl = false;
        $this$initLogging_u24lambda_u240.addAppender((Appender)fileAppender);
        $this$initLogging_u24lambda_u240.addAppender((Appender)consoleAppender);
        $this$initLogging_u24lambda_u240.setLevel(Level.INFO);
    }

    private final File defaultLogsPath() {
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            string2 = "";
        }
        String homePath = string2;
        return new File(homePath + "/gitnuro/");
    }

    private final File macLogsDirectory() {
        File logsDir = FileExtensionsKt.openDirectory(new File(System.getProperty("user.home") + "/Library/Logs/"), "com.jetpackduba.Gitnuro");
        return logsDir;
    }

    private final File windowsLogsDirectory() {
        String localAppData = System.getenv("LOCALAPPDATA");
        File gitnuroDir = FileExtensionsKt.openDirectory(new File(localAppData), "Gitnuro");
        File logsDir = FileExtensionsKt.openDirectory(gitnuroDir, "logs");
        return logsDir;
    }

    private final File linuxLogsDirectory() {
        String homePath = System.getProperty("user.home");
        String xdgStateHome = System.getenv("XDG_STATE_HOME");
        CharSequence charSequence = xdgStateHome;
        Object safeXdgStateHome = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? homePath + "/.local/state" : xdgStateHome;
        File gitnuroDir = FileExtensionsKt.openDirectory(new File((String)safeXdgStateHome), "gitnuro");
        File logsDir = FileExtensionsKt.openDirectory(gitnuroDir, "logs");
        return logsDir;
    }

    @NotNull
    public final File getLogsDirectory() {
        Lazy lazy = this.logsDirectory$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final String logsFile() {
        File file = new File(this.getLogsDirectory(), "gitnuro.log");
        String string2 = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return string2;
    }

    private static final File logsDirectory_delegate$lambda$1(Logging this$0) {
        File directory = switch (WhenMappings.$EnumSwitchMapping$0[OSKt.getCurrentOs().ordinal()]) {
            case 1 -> this$0.linuxLogsDirectory();
            case 2 -> this$0.windowsLogsDirectory();
            case 3 -> this$0.macLogsDirectory();
            case 4 -> this$0.defaultLogsPath();
            default -> throw new NoWhenBranchMatchedException();
        };
        if (!directory.exists()) {
            if (directory.isFile()) {
                directory.delete();
            }
            directory.mkdirs();
        }
        return directory;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.LINUX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.WINDOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MAC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

