/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionAdjustment;
import androidx.compose.foundation.text.selection.SelectionAdjustmentKt;
import androidx.compose.foundation.text.selection.SelectionLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e0\u0080\u0001\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/text/selection/SelectionAdjustment;", "", "adjust", "Landroidx/compose/foundation/text/selection/Selection;", "layout", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "Companion", "foundation"})
public interface SelectionAdjustment {
    @NotNull
    public static final Companion Companion = androidx.compose.foundation.text.selection.SelectionAdjustment$Companion.$$INSTANCE;

    @NotNull
    public Selection adjust(@NotNull SelectionLayout var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0010"}, d2={"Landroidx/compose/foundation/text/selection/SelectionAdjustment$Companion;", "", "<init>", "()V", "None", "Landroidx/compose/foundation/text/selection/SelectionAdjustment;", "getNone", "()Landroidx/compose/foundation/text/selection/SelectionAdjustment;", "Character", "getCharacter", "Word", "getWord", "Paragraph", "getParagraph", "CharacterWithWordAccelerate", "getCharacterWithWordAccelerate", "foundation"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final SelectionAdjustment None;
        @NotNull
        private static final SelectionAdjustment Character;
        @NotNull
        private static final SelectionAdjustment Word;
        @NotNull
        private static final SelectionAdjustment Paragraph;
        @NotNull
        private static final SelectionAdjustment CharacterWithWordAccelerate;

        private Companion() {
        }

        @NotNull
        public final SelectionAdjustment getNone() {
            return None;
        }

        @NotNull
        public final SelectionAdjustment getCharacter() {
            return Character;
        }

        @NotNull
        public final SelectionAdjustment getWord() {
            return Word;
        }

        @NotNull
        public final SelectionAdjustment getParagraph() {
            return Paragraph;
        }

        @NotNull
        public final SelectionAdjustment getCharacterWithWordAccelerate() {
            return CharacterWithWordAccelerate;
        }

        private static final Selection None$lambda$0(SelectionLayout layout2) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            return new Selection(layout2.getStartInfo().anchorForOffset(layout2.getStartInfo().getRawStartHandleOffset()), layout2.getEndInfo().anchorForOffset(layout2.getEndInfo().getRawEndHandleOffset()), layout2.getCrossStatus() == CrossStatus.CROSSED);
        }

        private static final Selection Character$lambda$1(SelectionLayout layout2) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            return SelectionAdjustmentKt.ensureAtLeastOneChar(None.adjust(layout2), layout2);
        }

        private static final Selection Word$lambda$2(SelectionLayout layout2) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            return SelectionAdjustmentKt.access$adjustToBoundaries(layout2, Word.1.1.INSTANCE);
        }

        private static final Selection Paragraph$lambda$3(SelectionLayout layout2) {
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            return SelectionAdjustmentKt.access$adjustToBoundaries(layout2, Paragraph.1.1.INSTANCE);
        }

        private static final Selection CharacterWithWordAccelerate$lambda$4(SelectionLayout layout2) {
            Selection selection;
            Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
            Selection selection2 = layout2.getPreviousSelection();
            if (selection2 == null) {
                return Word.adjust(layout2);
            }
            Selection previousSelection = selection2;
            Selection.AnchorInfo previousAnchor = null;
            Selection.AnchorInfo newAnchor = null;
            Selection.AnchorInfo startAnchor = null;
            Selection.AnchorInfo endAnchor = null;
            if (layout2.isStartHandle()) {
                previousAnchor = previousSelection.getStart();
                startAnchor = newAnchor = SelectionAdjustmentKt.access$updateSelectionBoundary(layout2, layout2.getStartInfo(), previousAnchor);
                endAnchor = previousSelection.getEnd();
            } else {
                previousAnchor = previousSelection.getEnd();
                newAnchor = SelectionAdjustmentKt.access$updateSelectionBoundary(layout2, layout2.getEndInfo(), previousAnchor);
                startAnchor = previousSelection.getStart();
                endAnchor = newAnchor;
            }
            if (Intrinsics.areEqual((Object)newAnchor, (Object)previousAnchor)) {
                selection = previousSelection;
            } else {
                boolean crossed = layout2.getCrossStatus() == CrossStatus.CROSSED || layout2.getCrossStatus() == CrossStatus.COLLAPSED && startAnchor.getOffset() > endAnchor.getOffset();
                selection = SelectionAdjustmentKt.ensureAtLeastOneChar(new Selection(startAnchor, endAnchor, crossed), layout2);
            }
            return selection;
        }

        static {
            $$INSTANCE = new Companion();
            None = Companion::None$lambda$0;
            Character = Companion::Character$lambda$1;
            Word = Companion::Word$lambda$2;
            Paragraph = Companion::Paragraph$lambda$3;
            CharacterWithWordAccelerate = Companion::CharacterWithWordAccelerate$lambda$4;
        }
    }
}

