/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntRect;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0013\u0010\t\u001a\u00020\n*\u00020\u000bH\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\"(\u0010\u0013\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\"(\u0010\u0013\u001a\u00020\u0001*\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00018@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u001a\"\u0004\b\u0017\u0010\u001b\"(\u0010\u0013\u001a\u00020\u0001*\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00018@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u001d\"\u0004\b\u0017\u0010\u001e\u00a8\u0006\u001f"}, d2={"isParentOf", "", "Ljava/awt/Component;", "component", "toAwtRectangle", "Ljava/awt/Rectangle;", "Landroidx/compose/ui/unit/IntRect;", "density", "Landroidx/compose/ui/unit/Density;", "toAwtColor", "Ljava/awt/Color;", "Landroidx/compose/ui/graphics/Color;", "toAwtColor-8_81llA", "(J)Ljava/awt/Color;", "getTransparentWindowBackground", "isWindowTransparent", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "value", "hasMacOsShadow", "Ljavax/swing/JComponent;", "getHasMacOsShadow", "(Ljavax/swing/JComponent;)Z", "setHasMacOsShadow", "(Ljavax/swing/JComponent;Z)V", "Ljavax/swing/JFrame;", "(Ljavax/swing/JFrame;)Z", "(Ljavax/swing/JFrame;Z)V", "Ljavax/swing/JDialog;", "(Ljavax/swing/JDialog;)Z", "(Ljavax/swing/JDialog;Z)V", "ui"})
public final class Utils_desktopKt {
    public static final boolean isParentOf(@NotNull Component $this$isParentOf, @Nullable Component component) {
        Container parent;
        Intrinsics.checkNotNullParameter((Object)$this$isParentOf, (String)"<this>");
        Component component2 = component;
        Container container2 = parent = component2 != null ? component2.getParent() : null;
        while (parent != null) {
            if (Intrinsics.areEqual((Object)parent, (Object)$this$isParentOf)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @NotNull
    public static final Rectangle toAwtRectangle(@NotNull IntRect $this$toAwtRectangle, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)$this$toAwtRectangle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        int left = (int)Math.floor((float)$this$toAwtRectangle.getLeft() / density.getDensity());
        int top = (int)Math.floor((float)$this$toAwtRectangle.getTop() / density.getDensity());
        int right = (int)Math.ceil((float)$this$toAwtRectangle.getRight() / density.getDensity());
        int bottom = (int)Math.ceil((float)$this$toAwtRectangle.getBottom() / density.getDensity());
        int width = right - left;
        int height = bottom - top;
        return new Rectangle(left, top, width, height);
    }

    @NotNull
    public static final Color toAwtColor-8_81llA(long $this$toAwtColor_u2d8_81llA) {
        return new Color(androidx.compose.ui.graphics.Color.getRed-impl((long)$this$toAwtColor_u2d8_81llA), androidx.compose.ui.graphics.Color.getGreen-impl((long)$this$toAwtColor_u2d8_81llA), androidx.compose.ui.graphics.Color.getBlue-impl((long)$this$toAwtColor_u2d8_81llA), androidx.compose.ui.graphics.Color.getAlpha-impl((long)$this$toAwtColor_u2d8_81llA));
    }

    @Nullable
    public static final Color getTransparentWindowBackground(boolean isWindowTransparent, @NotNull GraphicsApi renderApi) {
        Intrinsics.checkNotNullParameter((Object)renderApi, (String)"renderApi");
        boolean skikoTransparentWindowHack = OsArch_jvmKt.getHostOs() == OS.Windows && renderApi != GraphicsApi.DIRECT3D;
        return isWindowTransparent && !skikoTransparentWindowHack ? new Color(0, 0, 0, 0) : null;
    }

    private static final boolean getHasMacOsShadow(JComponent $this$hasMacOsShadow) {
        Object object = $this$hasMacOsShadow.getClientProperty("Window.shadow");
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : false;
    }

    private static final void setHasMacOsShadow(JComponent $this$hasMacOsShadow, boolean value) {
        $this$hasMacOsShadow.putClientProperty("Window.shadow", value);
    }

    public static final boolean getHasMacOsShadow(@NotNull JFrame $this$hasMacOsShadow) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMacOsShadow, (String)"<this>");
        JRootPane jRootPane = $this$hasMacOsShadow.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return Utils_desktopKt.getHasMacOsShadow(jRootPane);
    }

    public static final void setHasMacOsShadow(@NotNull JFrame $this$hasMacOsShadow, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMacOsShadow, (String)"<this>");
        JRootPane jRootPane = $this$hasMacOsShadow.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        Utils_desktopKt.setHasMacOsShadow(jRootPane, value);
    }

    public static final boolean getHasMacOsShadow(@NotNull JDialog $this$hasMacOsShadow) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMacOsShadow, (String)"<this>");
        JRootPane jRootPane = $this$hasMacOsShadow.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return Utils_desktopKt.getHasMacOsShadow(jRootPane);
    }

    public static final void setHasMacOsShadow(@NotNull JDialog $this$hasMacOsShadow, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMacOsShadow, (String)"<this>");
        JRootPane jRootPane = $this$hasMacOsShadow.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        Utils_desktopKt.setHasMacOsShadow(jRootPane, value);
    }
}

