/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tomlj.ErrorReporter;
import org.tomlj.KeyVisitor;
import org.tomlj.MutableTomlTable;
import org.tomlj.TomlParseError;
import org.tomlj.TomlPosition;
import org.tomlj.TomlVersion;
import org.tomlj.ValueVisitor;
import org.tomlj.internal.TomlParser;
import org.tomlj.internal.TomlParserBaseVisitor;

final class LineVisitor
extends TomlParserBaseVisitor<MutableTomlTable> {
    private final TomlVersion version;
    private final ErrorReporter errorReporter;
    private final MutableTomlTable rootTable;
    private MutableTomlTable currentTable;
    private final Map<MutableTomlTable, TomlPosition> openTables;

    LineVisitor(TomlVersion version, ErrorReporter errorReporter) {
        this.version = version;
        this.errorReporter = errorReporter;
        this.currentTable = this.rootTable = new MutableTomlTable(version, TomlPosition.positionAt(1, 1));
        this.openTables = new HashMap<MutableTomlTable, TomlPosition>();
    }

    @Override
    public MutableTomlTable visitKeyval(TomlParser.KeyvalContext ctx) {
        TomlParser.KeyContext keyContext = ctx.key();
        TomlParser.ValContext valContext = ctx.val();
        if (keyContext == null || valContext == null) {
            return this.rootTable;
        }
        try {
            List<String> path = keyContext.accept(new KeyVisitor(this.version));
            if (path == null || path.isEmpty()) {
                return this.rootTable;
            }
            if (!this.version.after(TomlVersion.V0_4_0) && path.size() > 1) {
                throw new TomlParseError("Dotted keys are not supported", new TomlPosition(keyContext));
            }
            Object value = valContext.accept(new ValueVisitor(this.version));
            if (value != null) {
                this.currentTable.set(path, value, new TomlPosition(ctx)).forEach(entry -> this.openTables.putIfAbsent((MutableTomlTable)entry.getKey(), (TomlPosition)entry.getValue()));
            }
            return this.rootTable;
        }
        catch (TomlParseError e) {
            this.errorReporter.reportError(e);
            return this.rootTable;
        }
    }

    @Override
    public MutableTomlTable visitStandardTable(TomlParser.StandardTableContext ctx) {
        this.defineOpenTables();
        TomlParser.KeyContext keyContext = ctx.key();
        if (keyContext == null) {
            this.errorReporter.reportError(new TomlParseError("Empty table key", new TomlPosition(ctx)));
            return this.rootTable;
        }
        List<String> path = keyContext.accept(new KeyVisitor(this.version));
        if (path == null) {
            return this.rootTable;
        }
        try {
            this.currentTable = this.rootTable.createTable(path, new TomlPosition(ctx));
        }
        catch (TomlParseError e) {
            this.errorReporter.reportError(e);
        }
        return this.rootTable;
    }

    @Override
    public MutableTomlTable visitArrayTable(TomlParser.ArrayTableContext ctx) {
        this.defineOpenTables();
        TomlParser.KeyContext keyContext = ctx.key();
        if (keyContext == null) {
            this.errorReporter.reportError(new TomlParseError("Empty table key", new TomlPosition(ctx)));
            return this.rootTable;
        }
        List<String> path = keyContext.accept(new KeyVisitor(this.version));
        if (path == null) {
            return this.rootTable;
        }
        try {
            this.currentTable = this.rootTable.createTableArray(path, new TomlPosition(ctx));
        }
        catch (TomlParseError e) {
            this.errorReporter.reportError(e);
        }
        return this.rootTable;
    }

    @Override
    protected MutableTomlTable aggregateResult(MutableTomlTable aggregate, MutableTomlTable nextResult) {
        return aggregate == null ? null : nextResult;
    }

    @Override
    protected MutableTomlTable defaultResult() {
        return this.rootTable;
    }

    private void defineOpenTables() {
        this.openTables.forEach(MutableTomlTable::define);
        this.openTables.clear();
    }
}

