/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.security;

import java.util.Objects;
import org.openqa.selenium.internal.Require;

public class Secret {
    private final String secret;

    public Secret(String secret) {
        this.secret = Require.nonNull("Secret", secret);
    }

    public static boolean matches(Secret first, Secret second) {
        if (first == null) {
            return second == null;
        }
        return first.matches(second);
    }

    public boolean matches(Secret other) {
        if (other == null) {
            return false;
        }
        return this.secret.equals(other.secret);
    }

    public String encode() {
        return this.secret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Secret)) {
            return false;
        }
        Secret that = (Secret)o;
        return Objects.equals(this.secret, that.secret);
    }

    public int hashCode() {
        return Objects.hash(this.secret);
    }

    private String toJson() {
        return this.secret;
    }

    private static Secret fromJson(String secret) {
        return new Secret(secret);
    }
}

