/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.api.incubator.config.DeclarativeConfigException;
import io.opentelemetry.api.incubator.config.GlobalConfigProvider;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.resources.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class IncubatingUtil {
    private IncubatingUtil() {
    }

    static AutoConfiguredOpenTelemetrySdk configureFromFile(Logger logger, String configurationFile, ComponentLoader componentLoader) {
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk;
        logger.fine("Autoconfiguring from configuration file: " + configurationFile);
        FileInputStream fis = new FileInputStream(configurationFile);
        try {
            autoConfiguredOpenTelemetrySdk = Objects.requireNonNull(IncubatingUtil.createWithFactory("file", () -> IncubatingUtil.getOpenTelemetrySdk(Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration").getMethod("parse", InputStream.class).invoke(null, fis), componentLoader)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("Configuration file not found", e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Error closing file", e);
            }
        }
        fis.close();
        return autoConfiguredOpenTelemetrySdk;
    }

    @Nullable
    public static AutoConfiguredOpenTelemetrySdk configureFromSpi(ComponentLoader componentLoader) {
        return IncubatingUtil.createWithFactory("SPI", () -> {
            Class<?> providerClass = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationProvider");
            Method getConfigurationModel = providerClass.getMethod("getConfigurationModel", new Class[0]);
            for (Object configProvider : componentLoader.load(providerClass)) {
                Object model = getConfigurationModel.invoke(configProvider, new Object[0]);
                if (model == null) continue;
                return IncubatingUtil.getOpenTelemetrySdk(model, componentLoader);
            }
            return null;
        });
    }

    private static AutoConfiguredOpenTelemetrySdk getOpenTelemetrySdk(Object model, ComponentLoader componentLoader) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        Class<?> openTelemetryConfiguration = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel");
        Class<?> declarativeConfiguration = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfiguration");
        Method create = declarativeConfiguration.getMethod("create", openTelemetryConfiguration, ComponentLoader.class);
        OpenTelemetrySdk sdk = (OpenTelemetrySdk)create.invoke(null, model, componentLoader);
        Class<?> sdkConfigProvider = Class.forName("io.opentelemetry.sdk.extension.incubator.fileconfig.SdkConfigProvider");
        Method createFileConfigProvider = sdkConfigProvider.getMethod("create", openTelemetryConfiguration, ComponentLoader.class);
        ConfigProvider configProvider = (ConfigProvider)createFileConfigProvider.invoke(null, model, componentLoader);
        return AutoConfiguredOpenTelemetrySdk.create(sdk, Resource.getDefault(), null, configProvider);
    }

    @Nullable
    static AutoConfiguredOpenTelemetrySdk createWithFactory(String name, Factory factory) {
        try {
            return factory.create();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new ConfigurationException(String.format("Error configuring from %s. Is opentelemetry-sdk-extension-incubator on the classpath?", name), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DeclarativeConfigException) {
                throw IncubatingUtil.toConfigurationException((DeclarativeConfigException)cause);
            }
            throw new ConfigurationException("Unexpected error configuring from " + name, e);
        }
    }

    private static ConfigurationException toConfigurationException(DeclarativeConfigException exception) {
        String message = Objects.requireNonNull(exception.getMessage());
        return new ConfigurationException(message, (Throwable)exception);
    }

    static void setGlobalConfigProvider(Object configProvider) {
        GlobalConfigProvider.set((ConfigProvider)((ConfigProvider)configProvider));
    }

    static interface Factory {
        @Nullable
        public AutoConfiguredOpenTelemetrySdk create() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException;
    }
}

