/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.PublicApi;
import graphql.util.FpKit;
import graphql.util.NodeAdapter;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.List;
import java.util.Queue;

@PublicApi
public class TreeTransformerUtil {
    public static <T> TraversalControl changeNode(TraverserContext<T> context, T changedNode) {
        boolean changed = context.isChanged();
        if (context.isParallel()) {
            List zippers = context.getVar(List.class);
            NodeAdapter adapter = context.getVar(NodeAdapter.class);
            if (changed) {
                TreeTransformerUtil.replaceZipperForNode(zippers, context.thisNode(), changedNode);
                context.changeNode(changedNode);
            } else {
                NodeZipper<T> nodeZipper = new NodeZipper<T>(changedNode, context.getBreadcrumbs(), adapter);
                zippers.add(nodeZipper);
                context.changeNode(changedNode);
            }
            return TraversalControl.CONTINUE;
        }
        NodeZipper<T> zipperWithChangedNode = context.getVar(NodeZipper.class).withNewNode(changedNode);
        List zippers = (List)context.getSharedContextData();
        if (changed) {
            TreeTransformerUtil.replaceZipperForNode(zippers, context.thisNode(), changedNode);
            context.changeNode(changedNode);
        } else {
            zippers.add(zipperWithChangedNode);
            context.changeNode(changedNode);
        }
        return TraversalControl.CONTINUE;
    }

    private static <T> void replaceZipperForNode(List<NodeZipper<T>> zippers, T currentNode, T newNode) {
        int index = FpKit.findIndex(zippers, zipper -> zipper.getCurNode() == currentNode);
        Assert.assertTrue(index >= 0, () -> "No current zipper found for provided node");
        NodeZipper<T> newZipper = zippers.get(index).withNewNode(newNode);
        zippers.set(index, newZipper);
    }

    public static <T> TraversalControl deleteNode(TraverserContext<T> context) {
        if (context.isParallel()) {
            NodeAdapter adapter = context.getVar(NodeAdapter.class);
            NodeZipper<T> deleteNodeZipper = new NodeZipper<T>(context.thisNode(), context.getBreadcrumbs(), adapter).deleteNode();
            List zippers = context.getVar(List.class);
            zippers.add(deleteNodeZipper);
            context.deleteNode();
            return TraversalControl.CONTINUE;
        }
        NodeZipper deleteNodeZipper = context.getVar(NodeZipper.class).deleteNode();
        Queue zippers = (Queue)context.getSharedContextData();
        zippers.add(deleteNodeZipper);
        context.deleteNode();
        return TraversalControl.CONTINUE;
    }

    public static <T> TraversalControl insertAfter(TraverserContext<T> context, T toInsertAfter) {
        if (context.isParallel()) {
            NodeAdapter adapter = context.getVar(NodeAdapter.class);
            NodeZipper<T> insertNodeZipper = new NodeZipper<T>(context.originalThisNode(), context.getBreadcrumbs(), adapter).insertAfter(toInsertAfter);
            List zippers = context.getVar(List.class);
            zippers.add(insertNodeZipper);
            return TraversalControl.CONTINUE;
        }
        NodeZipper<T> insertNodeZipper = context.getVar(NodeZipper.class).insertAfter(toInsertAfter);
        Queue zippers = (Queue)context.getSharedContextData();
        zippers.add(insertNodeZipper);
        return TraversalControl.CONTINUE;
    }

    public static <T> TraversalControl insertBefore(TraverserContext<T> context, T toInsertBefore) {
        if (context.isParallel()) {
            NodeAdapter adapter = context.getVar(NodeAdapter.class);
            NodeZipper<T> insertNodeZipper = new NodeZipper<T>(context.originalThisNode(), context.getBreadcrumbs(), adapter).insertBefore(toInsertBefore);
            List zippers = context.getVar(List.class);
            zippers.add(insertNodeZipper);
            return TraversalControl.CONTINUE;
        }
        NodeZipper<T> insertNodeZipper = context.getVar(NodeZipper.class).insertBefore(toInsertBefore);
        Queue zippers = (Queue)context.getSharedContextData();
        zippers.add(insertNodeZipper);
        return TraversalControl.CONTINUE;
    }
}

