/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.EngineRunningState;
import graphql.ExecutionInput;
import graphql.ExperimentalApi;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.CoercedVariables;
import graphql.execution.DataLoaderDispatchStrategy;
import graphql.execution.ExecutionContextBuilder;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategy;
import graphql.execution.NormalizedVariables;
import graphql.execution.ResultNodesInfo;
import graphql.execution.ResultPath;
import graphql.execution.ValueUnboxer;
import graphql.execution.incremental.IncrementalCallState;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.normalized.ExecutableNormalizedOperationFactory;
import graphql.schema.GraphQLSchema;
import graphql.util.FpKit;
import graphql.util.LockKit;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.dataloader.DataLoaderRegistry;

@PublicApi
public class ExecutionContext {
    private final GraphQLSchema graphQLSchema;
    private final ExecutionId executionId;
    private final InstrumentationState instrumentationState;
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final ImmutableMap<String, FragmentDefinition> fragmentsByName;
    private final OperationDefinition operationDefinition;
    private final Document document;
    private final CoercedVariables coercedVariables;
    private final Supplier<NormalizedVariables> normalizedVariables;
    private final Object root;
    private final Object context;
    private final GraphQLContext graphQLContext;
    private final Object localContext;
    private final Instrumentation instrumentation;
    private final AtomicReference<ImmutableList<GraphQLError>> errors = new AtomicReference(ImmutableKit.emptyList());
    private final LockKit.ReentrantLock errorsLock = new LockKit.ReentrantLock();
    private final Set<ResultPath> errorPaths = new HashSet<ResultPath>();
    private final DataLoaderRegistry dataLoaderRegistry;
    private final Locale locale;
    private final IncrementalCallState incrementalCallState = new IncrementalCallState();
    private final ValueUnboxer valueUnboxer;
    private final ExecutionInput executionInput;
    private final Supplier<ExecutableNormalizedOperation> queryTree;
    private final boolean propagateErrorsOnNonNullContractFailure;
    private final AtomicInteger isRunning = new AtomicInteger(0);
    private volatile DataLoaderDispatchStrategy dataLoaderDispatcherStrategy = DataLoaderDispatchStrategy.NO_OP;
    private final ResultNodesInfo resultNodesInfo = new ResultNodesInfo();
    private final EngineRunningState engineRunningState;

    ExecutionContext(ExecutionContextBuilder builder) {
        this.graphQLSchema = builder.graphQLSchema;
        this.executionId = builder.executionId;
        this.instrumentationState = builder.instrumentationState;
        this.queryStrategy = builder.queryStrategy;
        this.mutationStrategy = builder.mutationStrategy;
        this.subscriptionStrategy = builder.subscriptionStrategy;
        this.fragmentsByName = builder.fragmentsByName;
        this.coercedVariables = builder.coercedVariables;
        this.normalizedVariables = builder.normalizedVariables;
        this.document = builder.document;
        this.operationDefinition = builder.operationDefinition;
        this.context = builder.context;
        this.graphQLContext = builder.graphQLContext;
        this.root = builder.root;
        this.instrumentation = builder.instrumentation;
        this.dataLoaderRegistry = builder.dataLoaderRegistry;
        this.locale = builder.locale;
        this.valueUnboxer = builder.valueUnboxer;
        this.errors.set(builder.errors);
        this.localContext = builder.localContext;
        this.executionInput = builder.executionInput;
        this.dataLoaderDispatcherStrategy = builder.dataLoaderDispatcherStrategy;
        this.queryTree = FpKit.interThreadMemoize(() -> ExecutableNormalizedOperationFactory.createExecutableNormalizedOperation(this.graphQLSchema, this.operationDefinition, this.fragmentsByName, this.coercedVariables));
        this.propagateErrorsOnNonNullContractFailure = builder.propagateErrorsOnNonNullContractFailure;
        this.engineRunningState = builder.engineRunningState;
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public ExecutionInput getExecutionInput() {
        return this.executionInput;
    }

    public InstrumentationState getInstrumentationState() {
        return this.instrumentationState;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    public Map<String, FragmentDefinition> getFragmentsByName() {
        return this.fragmentsByName;
    }

    public Document getDocument() {
        return this.document;
    }

    public OperationDefinition getOperationDefinition() {
        return this.operationDefinition;
    }

    public CoercedVariables getCoercedVariables() {
        return this.coercedVariables;
    }

    public Supplier<NormalizedVariables> getNormalizedVariables() {
        return this.normalizedVariables;
    }

    @Deprecated(since="2021-07-05")
    public <T> T getContext() {
        return (T)this.context;
    }

    public GraphQLContext getGraphQLContext() {
        return this.graphQLContext;
    }

    public <T> T getLocalContext() {
        return (T)this.localContext;
    }

    public <T> T getRoot() {
        return (T)this.root;
    }

    public FragmentDefinition getFragment(String name) {
        return this.fragmentsByName.get(name);
    }

    public DataLoaderRegistry getDataLoaderRegistry() {
        return this.dataLoaderRegistry;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ValueUnboxer getValueUnboxer() {
        return this.valueUnboxer;
    }

    @ExperimentalApi
    public boolean propagateErrorsOnNonNullContractFailure() {
        return this.propagateErrorsOnNonNullContractFailure;
    }

    public boolean isQueryOperation() {
        return this.isOpType(OperationDefinition.Operation.QUERY);
    }

    public boolean isMutationOperation() {
        return this.isOpType(OperationDefinition.Operation.MUTATION);
    }

    public boolean isSubscriptionOperation() {
        return this.isOpType(OperationDefinition.Operation.SUBSCRIPTION);
    }

    private boolean isOpType(OperationDefinition.Operation operation) {
        if (this.operationDefinition != null) {
            return operation.equals((Object)this.operationDefinition.getOperation());
        }
        return false;
    }

    public void addError(GraphQLError error, ResultPath fieldPath) {
        this.errorsLock.runLocked(() -> {
            if (!this.errorPaths.add(fieldPath)) {
                return;
            }
            this.errors.set(ImmutableKit.addToList((Collection)this.errors.get(), error, new GraphQLError[0]));
        });
    }

    public void addError(GraphQLError error) {
        this.errorsLock.runLocked(() -> {
            if (error.getPath() != null) {
                ResultPath path = ResultPath.fromList(error.getPath());
                this.errorPaths.add(path);
            }
            this.errors.set(ImmutableKit.addToList((Collection)this.errors.get(), error, new GraphQLError[0]));
        });
    }

    public void addErrors(List<GraphQLError> errors) {
        if (errors.isEmpty()) {
            return;
        }
        this.errorsLock.runLocked(() -> {
            HashSet<ResultPath> newErrorPaths = new HashSet<ResultPath>();
            for (GraphQLError error : errors) {
                if (error.getPath() == null) continue;
                ResultPath path = ResultPath.fromList(error.getPath());
                newErrorPaths.add(path);
            }
            this.errorPaths.addAll(newErrorPaths);
            this.errors.set(ImmutableKit.concatLists((List)this.errors.get(), errors));
        });
    }

    public List<GraphQLError> getErrors() {
        return this.errors.get();
    }

    public ExecutionStrategy getQueryStrategy() {
        return this.queryStrategy;
    }

    public ExecutionStrategy getMutationStrategy() {
        return this.mutationStrategy;
    }

    public ExecutionStrategy getSubscriptionStrategy() {
        return this.subscriptionStrategy;
    }

    public IncrementalCallState getIncrementalCallState() {
        return this.incrementalCallState;
    }

    public ExecutionStrategy getStrategy(OperationDefinition.Operation operation) {
        if (operation == OperationDefinition.Operation.MUTATION) {
            return this.getMutationStrategy();
        }
        if (operation == OperationDefinition.Operation.SUBSCRIPTION) {
            return this.getSubscriptionStrategy();
        }
        return this.getQueryStrategy();
    }

    public Supplier<ExecutableNormalizedOperation> getNormalizedQueryTree() {
        return this.queryTree;
    }

    @Internal
    public void setDataLoaderDispatcherStrategy(DataLoaderDispatchStrategy dataLoaderDispatcherStrategy) {
        this.dataLoaderDispatcherStrategy = dataLoaderDispatcherStrategy;
    }

    @Internal
    public DataLoaderDispatchStrategy getDataLoaderDispatcherStrategy() {
        return this.dataLoaderDispatcherStrategy;
    }

    public ExecutionContext transform(Consumer<ExecutionContextBuilder> builderConsumer) {
        ExecutionContextBuilder builder = ExecutionContextBuilder.newExecutionContextBuilder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public ResultNodesInfo getResultNodesInfo() {
        return this.resultNodesInfo;
    }

    @Internal
    public boolean hasIncrementalSupport() {
        GraphQLContext graphqlContext = this.getGraphQLContext();
        return graphqlContext != null && graphqlContext.getBoolean("ENABLE_INCREMENTAL_SUPPORT");
    }

    @Internal
    public EngineRunningState getEngineRunningState() {
        return this.engineRunningState;
    }
}

