/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.UnsafeCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016Jr\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u001a\b\u0002\u0010\u0018\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014\u0018\u00010\u00132\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirForLoopChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBlockChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSpecialFunctionCall", "", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "reportSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "ambiguityFactory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "missingFactory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "noneApplicableFactory", "unsafeCallFactory", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirForLoopChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirForLoopChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirForLoopChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,164:1\n1549#2:165\n1620#2,3:166\n1549#2:169\n1620#2,3:170\n766#2:173\n857#2,2:174\n1855#2,2:176\n32#3:178\n*S KotlinDebug\n*F\n+ 1 FirForLoopChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirForLoopChecker\n*L\n112#1:165\n112#1:166,3\n114#1:169\n114#1:170,3\n132#1:173\n132#1:174,2\n132#1:176,2\n154#1:178\n*E\n"})
public final class FirForLoopChecker
extends FirExpressionChecker<FirBlock> {
    @NotNull
    public static final FirForLoopChecker INSTANCE = new FirForLoopChecker();

    private FirForLoopChecker() {
    }

    @Override
    public void check(@NotNull FirBlock expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block8: {
            Object source;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            KtSourceElement ktSourceElement = expression2.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
                return;
            }
            List<FirStatement> statements2 = expression2.getStatements();
            FirStatement firStatement = statements2.get(0);
            FirProperty firProperty = firStatement instanceof FirProperty ? (FirProperty)firStatement : null;
            if (firProperty == null) {
                return;
            }
            FirProperty iteratorDeclaration = firProperty;
            FirStatement firStatement2 = statements2.get(1);
            FirWhileLoop firWhileLoop = firStatement2 instanceof FirWhileLoop ? (FirWhileLoop)firStatement2 : null;
            if (firWhileLoop == null) {
                return;
            }
            FirWhileLoop whileLoop = firWhileLoop;
            KtSourceElement ktSourceElement2 = iteratorDeclaration.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
                return;
            }
            FirExpression firExpression2 = iteratorDeclaration.getInitializer();
            Intrinsics.checkNotNull((Object)firExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
            FirFunctionCall iteratorCall = (FirFunctionCall)firExpression2;
            Object object = iteratorCall.getExplicitReceiver();
            if (object == null || (object = ((FirExpression)object).getSource()) == null) {
                object = iteratorCall.getSource();
            }
            if (FirForLoopChecker.checkSpecialFunctionCall$default(this, iteratorCall, reporter, (KtSourceElement)(source = object), context2, FirErrors.INSTANCE.getITERATOR_AMBIGUITY(), FirErrors.INSTANCE.getITERATOR_MISSING(), null, FirErrors.INSTANCE.getITERATOR_ON_NULLABLE(), 64, null)) {
                return;
            }
            FirExpression firExpression3 = whileLoop.getCondition();
            Intrinsics.checkNotNull((Object)firExpression3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
            FirFunctionCall hasNextCall = (FirFunctionCall)firExpression3;
            FirForLoopChecker.checkSpecialFunctionCall$default(this, hasNextCall, reporter, (KtSourceElement)source, context2, FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_AMBIGUITY(), FirErrors.INSTANCE.getHAS_NEXT_MISSING(), FirErrors.INSTANCE.getHAS_NEXT_FUNCTION_NONE_APPLICABLE(), null, 128, null);
            Object object2 = CollectionsKt.firstOrNull(whileLoop.getBlock().getStatements());
            FirProperty firProperty2 = object2 instanceof FirProperty ? (FirProperty)object2 : null;
            if (firProperty2 == null) {
                return;
            }
            FirProperty loopParameter = firProperty2;
            Object object3 = loopParameter.getInitializer();
            if (!Intrinsics.areEqual((Object)(object3 != null && (object3 = ((FirExpression)object3).getSource()) != null ? ((KtSourceElement)object3).getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
                return;
            }
            FirExpression firExpression4 = loopParameter.getInitializer();
            Intrinsics.checkNotNull((Object)firExpression4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirFunctionCall");
            FirFunctionCall nextCall = (FirFunctionCall)firExpression4;
            FirForLoopChecker.checkSpecialFunctionCall$default(this, nextCall, reporter, (KtSourceElement)source, context2, FirErrors.INSTANCE.getNEXT_AMBIGUITY(), FirErrors.INSTANCE.getNEXT_MISSING(), FirErrors.INSTANCE.getNEXT_NONE_APPLICABLE(), null, 128, null);
            KtSourceElement loopParameterSource = loopParameter.getSource();
            KtKeywordToken ktKeywordToken = FirKeywordUtilsKt.getValOrVarKeyword(loopParameterSource);
            if (ktKeywordToken == null) break block8;
            KtKeywordToken it = ktKeywordToken;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)loopParameterSource, FirErrors.INSTANCE.getVAL_OR_VAR_ON_LOOP_PARAMETER(), (Object)it, (DiagnosticContext)context2, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkSpecialFunctionCall(FirFunctionCall call2, DiagnosticReporter reporter, KtSourceElement reportSource, CheckerContext context2, KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> ambiguityFactory, KtDiagnosticFactory0 missingFactory, KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> noneApplicableFactory, KtDiagnosticFactory0 unsafeCallFactory) {
        FirBasedSymbol<?> symbol2;
        FirNamedReference calleeReference = call2.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference)) {
            ConeDiagnostic diagnostic = ((FirDiagnosticHolder)((Object)calleeReference)).getDiagnostic();
            if (diagnostic instanceof ConeAmbiguityError) {
                if (CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability())) {
                    Collection<FirBasedSymbol<?>> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
                    KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> ktDiagnosticFactory1 = ambiguityFactory;
                    AbstractKtSourceElement abstractKtSourceElement = reportSource;
                    DiagnosticReporter diagnosticReporter = reporter;
                    boolean $i$f$map = false;
                    void var13_26 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getSymbol());
                    }
                    collection = (List)destination$iv$iv;
                    KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)collection, (DiagnosticContext)context2, null, 16, null);
                    return true;
                } else {
                    Collection<FirBasedSymbol<?>> collection;
                    if (noneApplicableFactory == null) return true;
                    Iterable $this$map$iv = ((ConeAmbiguityError)diagnostic).getCandidates();
                    KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> ktDiagnosticFactory1 = noneApplicableFactory;
                    AbstractKtSourceElement abstractKtSourceElement = reportSource;
                    DiagnosticReporter diagnosticReporter = reporter;
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        AbstractCandidate it = (AbstractCandidate)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getSymbol());
                    }
                    collection = (List)destination$iv$iv;
                    KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)collection, (DiagnosticContext)context2, null, 16, null);
                }
                return true;
            } else if (diagnostic instanceof ConeUnresolvedNameError) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportSource, missingFactory, (DiagnosticContext)context2, null, 8, null);
                return true;
            } else if (diagnostic instanceof ConeInapplicableWrongReceiver) {
                if (noneApplicableFactory != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportSource, noneApplicableFactory, ((ConeInapplicableWrongReceiver)diagnostic).getCandidateSymbols(), (DiagnosticContext)context2, null, 16, null);
                    return true;
                } else {
                    if (!Intrinsics.areEqual((Object)calleeReference.getName(), (Object)OperatorNameConventions.ITERATOR)) throw new IllegalStateException("ConeInapplicableWrongReceiver, but no diagnostic reported".toString());
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportSource, missingFactory, (DiagnosticContext)context2, null, 8, null);
                }
                return true;
            } else {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                if (!(diagnostic instanceof ConeInapplicableCandidateError) || unsafeCallFactory == null && noneApplicableFactory == null) return true;
                Iterable $this$filter$iv = ((ConeInapplicableCandidateError)diagnostic).getCandidate().getDiagnostics();
                boolean $i$f$filter = false;
                Iterable $this$mapTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ResolutionDiagnostic it = (ResolutionDiagnostic)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getApplicability() == ((ConeInapplicableCandidateError)diagnostic).getApplicability())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResolutionDiagnostic it = (ResolutionDiagnostic)element$iv;
                    boolean bl = false;
                    if (!(it instanceof UnsafeCall)) continue;
                    if (unsafeCallFactory != null) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportSource, unsafeCallFactory, (DiagnosticContext)context2, null, 8, null);
                        return true;
                    } else {
                        AbstractKtSourceElement abstractKtSourceElement = reportSource;
                        KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> ktDiagnosticFactory1 = noneApplicableFactory;
                        Intrinsics.checkNotNull(ktDiagnosticFactory1);
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)CollectionsKt.listOf(((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol()), (DiagnosticContext)context2, null, 16, null);
                    }
                    return true;
                }
            }
            return true;
        }
        if (!(calleeReference instanceof FirResolvedNamedReference) || !((symbol2 = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol()) instanceof FirNamedFunctionSymbol)) return false;
        FirCallableSymbol $this$isOperator$iv = (FirCallableSymbol)symbol2;
        boolean $i$f$isOperator = false;
        if ($this$isOperator$iv.getResolvedStatus().isOperator()) return false;
        AbstractKtSourceElement abstractKtSourceElement = reportSource;
        KtDiagnosticFactory2<FirNamedFunctionSymbol, String> ktDiagnosticFactory2 = FirErrors.INSTANCE.getOPERATOR_MODIFIER_REQUIRED();
        String string2 = ((FirNamedFunctionSymbol)symbol2).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory2, symbol2, (Object)string2, (DiagnosticContext)context2, null, 32, null);
        return false;
    }

    static /* synthetic */ boolean checkSpecialFunctionCall$default(FirForLoopChecker firForLoopChecker, FirFunctionCall firFunctionCall, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, CheckerContext checkerContext, KtDiagnosticFactory1 ktDiagnosticFactory1, KtDiagnosticFactory0 ktDiagnosticFactory0, KtDiagnosticFactory1 ktDiagnosticFactory12, KtDiagnosticFactory0 ktDiagnosticFactory02, int n, Object object) {
        if ((n & 0x40) != 0) {
            ktDiagnosticFactory12 = null;
        }
        if ((n & 0x80) != 0) {
            ktDiagnosticFactory02 = null;
        }
        return firForLoopChecker.checkSpecialFunctionCall(firFunctionCall, diagnosticReporter, ktSourceElement, checkerContext, ktDiagnosticFactory1, ktDiagnosticFactory0, ktDiagnosticFactory12, ktDiagnosticFactory02);
    }
}

