#pragma once

#include "td/tl/TlObject.h"

#include <string>

#include <cstdint>
#include <utility>
#include <vector>

namespace td {
class TlStorerToString;

namespace td_api {

using int32 = std::int32_t;
using int53 = std::int64_t;
using int64 = std::int64_t;

using string = std::string;

using bytes = std::string;

template <class Type>
using array = std::vector<Type>;

using BaseObject = ::td::TlObject;

template <class Type>
using object_ptr = ::td::tl_object_ptr<Type>;

template <class Type, class... Args>
object_ptr<Type> make_object(Args &&... args) {
  return object_ptr<Type>(new Type(std::forward<Args>(args)...));
}

template <class ToType, class FromType>
object_ptr<ToType> move_object_as(FromType &&from) {
  return object_ptr<ToType>(static_cast<ToType *>(from.release()));
}

std::string to_string(const BaseObject &value);

template <class T>
std::string to_string(const object_ptr<T> &value) {
  if (value == nullptr) {
    return "null";
  }

  return to_string(*value);
}

template <class T>
std::string to_string(const std::vector<object_ptr<T>> &values) {
  std::string result = "{\n";
  for (const auto &value : values) {
    if (value == nullptr) {
      result += "null\n";
    } else {
      result += to_string(*value);
    }
  }
  result += "}\n";
  return result;
}

class Object: public TlObject {
 public:
};

class Function: public TlObject {
 public:
};

class accentColor final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int32 built_in_accent_color_id_;
  array<int32> light_theme_colors_;
  array<int32> dark_theme_colors_;
  int32 min_channel_chat_boost_level_;

  accentColor();

  accentColor(int32 id_, int32 built_in_accent_color_id_, array<int32> &&light_theme_colors_, array<int32> &&dark_theme_colors_, int32 min_channel_chat_boost_level_);

  static const std::int32_t ID = -496870680;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class acceptedGiftTypes final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool unlimited_gifts_;
  bool limited_gifts_;
  bool upgraded_gifts_;
  bool premium_subscription_;

  acceptedGiftTypes();

  acceptedGiftTypes(bool unlimited_gifts_, bool limited_gifts_, bool upgraded_gifts_, bool premium_subscription_);

  static const std::int32_t ID = 1783521300;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class accountInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 registration_month_;
  int32 registration_year_;
  string phone_number_country_code_;
  int32 last_name_change_date_;
  int32 last_photo_change_date_;

  accountInfo();

  accountInfo(int32 registration_month_, int32 registration_year_, string const &phone_number_country_code_, int32 last_name_change_date_, int32 last_photo_change_date_);

  static const std::int32_t ID = 1803492711;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class accountTtl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 days_;

  accountTtl();

  explicit accountTtl(int32 days_);

  static const std::int32_t ID = 1324495492;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class ReactionType;

class addedReaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionType> type_;
  object_ptr<MessageSender> sender_id_;
  bool is_outgoing_;
  int32 date_;

  addedReaction();

  addedReaction(object_ptr<ReactionType> &&type_, object_ptr<MessageSender> &&sender_id_, bool is_outgoing_, int32 date_);

  static const std::int32_t ID = 1258586525;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class addedReaction;

class addedReactions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<addedReaction>> reactions_;
  string next_offset_;

  addedReactions();

  addedReactions(int32 total_count_, array<object_ptr<addedReaction>> &&reactions_, string const &next_offset_);

  static const std::int32_t ID = 226352304;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class address final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string country_code_;
  string state_;
  string city_;
  string street_line1_;
  string street_line2_;
  string postal_code_;

  address();

  address(string const &country_code_, string const &state_, string const &city_, string const &street_line1_, string const &street_line2_, string const &postal_code_);

  static const std::int32_t ID = -2043654342;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starAmount;

class affiliateInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 commission_per_mille_;
  int53 affiliate_chat_id_;
  object_ptr<starAmount> star_amount_;

  affiliateInfo();

  affiliateInfo(int32 commission_per_mille_, int53 affiliate_chat_id_, object_ptr<starAmount> &&star_amount_);

  static const std::int32_t ID = -1312695046;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class affiliateProgramParameters;

class starAmount;

class affiliateProgramInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<affiliateProgramParameters> parameters_;
  int32 end_date_;
  object_ptr<starAmount> daily_revenue_per_user_amount_;

  affiliateProgramInfo();

  affiliateProgramInfo(object_ptr<affiliateProgramParameters> &&parameters_, int32 end_date_, object_ptr<starAmount> &&daily_revenue_per_user_amount_);

  static const std::int32_t ID = -1761810251;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class affiliateProgramParameters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 commission_per_mille_;
  int32 month_count_;

  affiliateProgramParameters();

  affiliateProgramParameters(int32 commission_per_mille_, int32 month_count_);

  static const std::int32_t ID = 1642662996;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AffiliateProgramSortOrder: public Object {
 public:
};

class affiliateProgramSortOrderProfitability final : public AffiliateProgramSortOrder {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  affiliateProgramSortOrderProfitability();

  static const std::int32_t ID = -1963282585;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class affiliateProgramSortOrderCreationDate final : public AffiliateProgramSortOrder {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  affiliateProgramSortOrderCreationDate();

  static const std::int32_t ID = -1558628083;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class affiliateProgramSortOrderRevenue final : public AffiliateProgramSortOrder {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  affiliateProgramSortOrderRevenue();

  static const std::int32_t ID = 1923269304;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AffiliateType: public Object {
 public:
};

class affiliateTypeCurrentUser final : public AffiliateType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  affiliateTypeCurrentUser();

  static const std::int32_t ID = 1453785589;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class affiliateTypeBot final : public AffiliateType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  affiliateTypeBot();

  explicit affiliateTypeBot(int53 user_id_);

  static const std::int32_t ID = -1032587200;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class affiliateTypeChannel final : public AffiliateType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  affiliateTypeChannel();

  explicit affiliateTypeChannel(int53 chat_id_);

  static const std::int32_t ID = -683939735;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class alternativeVideo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 width_;
  int32 height_;
  string codec_;
  object_ptr<file> hls_file_;
  object_ptr<file> video_;

  alternativeVideo();

  alternativeVideo(int64 id_, int32 width_, int32 height_, string const &codec_, object_ptr<file> &&hls_file_, object_ptr<file> &&video_);

  static const std::int32_t ID = 483379470;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class animatedChatPhoto final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 length_;
  object_ptr<file> file_;
  double main_frame_timestamp_;

  animatedChatPhoto();

  animatedChatPhoto(int32 length_, object_ptr<file> &&file_, double main_frame_timestamp_);

  static const std::int32_t ID = 191994926;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class sticker;

class animatedEmoji final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<sticker> sticker_;
  int32 sticker_width_;
  int32 sticker_height_;
  int32 fitzpatrick_type_;
  object_ptr<file> sound_;

  animatedEmoji();

  animatedEmoji(object_ptr<sticker> &&sticker_, int32 sticker_width_, int32 sticker_height_, int32 fitzpatrick_type_, object_ptr<file> &&sound_);

  static const std::int32_t ID = 1378918079;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class minithumbnail;

class thumbnail;

class animation final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 duration_;
  int32 width_;
  int32 height_;
  string file_name_;
  string mime_type_;
  bool has_stickers_;
  object_ptr<minithumbnail> minithumbnail_;
  object_ptr<thumbnail> thumbnail_;
  object_ptr<file> animation_;

  animation();

  animation(int32 duration_, int32 width_, int32 height_, string const &file_name_, string const &mime_type_, bool has_stickers_, object_ptr<minithumbnail> &&minithumbnail_, object_ptr<thumbnail> &&thumbnail_, object_ptr<file> &&animation_);

  static const std::int32_t ID = -872359106;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class animation;

class animations final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<animation>> animations_;

  animations();

  explicit animations(array<object_ptr<animation>> &&animations_);

  static const std::int32_t ID = 344216945;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class archiveChatListSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool archive_and_mute_new_chats_from_unknown_users_;
  bool keep_unmuted_chats_archived_;
  bool keep_chats_from_folders_archived_;

  archiveChatListSettings();

  archiveChatListSettings(bool archive_and_mute_new_chats_from_unknown_users_, bool keep_unmuted_chats_archived_, bool keep_chats_from_folders_archived_);

  static const std::int32_t ID = 1058499236;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class attachmentMenuBotColor;

class file;

class attachmentMenuBot final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  bool supports_self_chat_;
  bool supports_user_chats_;
  bool supports_bot_chats_;
  bool supports_group_chats_;
  bool supports_channel_chats_;
  bool request_write_access_;
  bool is_added_;
  bool show_in_attachment_menu_;
  bool show_in_side_menu_;
  bool show_disclaimer_in_side_menu_;
  string name_;
  object_ptr<attachmentMenuBotColor> name_color_;
  object_ptr<file> default_icon_;
  object_ptr<file> ios_static_icon_;
  object_ptr<file> ios_animated_icon_;
  object_ptr<file> ios_side_menu_icon_;
  object_ptr<file> android_icon_;
  object_ptr<file> android_side_menu_icon_;
  object_ptr<file> macos_icon_;
  object_ptr<file> macos_side_menu_icon_;
  object_ptr<attachmentMenuBotColor> icon_color_;
  object_ptr<file> web_app_placeholder_;

  attachmentMenuBot();

  attachmentMenuBot(int53 bot_user_id_, bool supports_self_chat_, bool supports_user_chats_, bool supports_bot_chats_, bool supports_group_chats_, bool supports_channel_chats_, bool request_write_access_, bool is_added_, bool show_in_attachment_menu_, bool show_in_side_menu_, bool show_disclaimer_in_side_menu_, string const &name_, object_ptr<attachmentMenuBotColor> &&name_color_, object_ptr<file> &&default_icon_, object_ptr<file> &&ios_static_icon_, object_ptr<file> &&ios_animated_icon_, object_ptr<file> &&ios_side_menu_icon_, object_ptr<file> &&android_icon_, object_ptr<file> &&android_side_menu_icon_, object_ptr<file> &&macos_icon_, object_ptr<file> &&macos_side_menu_icon_, object_ptr<attachmentMenuBotColor> &&icon_color_, object_ptr<file> &&web_app_placeholder_);

  static const std::int32_t ID = -1183966273;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class attachmentMenuBotColor final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 light_color_;
  int32 dark_color_;

  attachmentMenuBotColor();

  attachmentMenuBotColor(int32 light_color_, int32 dark_color_);

  static const std::int32_t ID = 1680039612;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class minithumbnail;

class thumbnail;

class audio final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 duration_;
  string title_;
  string performer_;
  string file_name_;
  string mime_type_;
  object_ptr<minithumbnail> album_cover_minithumbnail_;
  object_ptr<thumbnail> album_cover_thumbnail_;
  array<object_ptr<thumbnail>> external_album_covers_;
  object_ptr<file> audio_;

  audio();

  audio(int32 duration_, string const &title_, string const &performer_, string const &file_name_, string const &mime_type_, object_ptr<minithumbnail> &&album_cover_minithumbnail_, object_ptr<thumbnail> &&album_cover_thumbnail_, array<object_ptr<thumbnail>> &&external_album_covers_, object_ptr<file> &&audio_);

  static const std::int32_t ID = -166398841;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AuthenticationCodeType;

class authenticationCodeInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  object_ptr<AuthenticationCodeType> type_;
  object_ptr<AuthenticationCodeType> next_type_;
  int32 timeout_;

  authenticationCodeInfo();

  authenticationCodeInfo(string const &phone_number_, object_ptr<AuthenticationCodeType> &&type_, object_ptr<AuthenticationCodeType> &&next_type_, int32 timeout_);

  static const std::int32_t ID = -860345416;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class FirebaseDeviceVerificationParameters;

class AuthenticationCodeType: public Object {
 public:
};

class authenticationCodeTypeTelegramMessage final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 length_;

  authenticationCodeTypeTelegramMessage();

  explicit authenticationCodeTypeTelegramMessage(int32 length_);

  static const std::int32_t ID = 2079628074;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authenticationCodeTypeSms final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 length_;

  authenticationCodeTypeSms();

  explicit authenticationCodeTypeSms(int32 length_);

  static const std::int32_t ID = 962650760;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authenticationCodeTypeSmsWord final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string first_letter_;

  authenticationCodeTypeSmsWord();

  explicit authenticationCodeTypeSmsWord(string const &first_letter_);

  static const std::int32_t ID = -1509540765;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authenticationCodeTypeSmsPhrase final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string first_word_;

  authenticationCodeTypeSmsPhrase();

  explicit authenticationCodeTypeSmsPhrase(string const &first_word_);

  static const std::int32_t ID = 784108753;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authenticationCodeTypeCall final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 length_;

  authenticationCodeTypeCall();

  explicit authenticationCodeTypeCall(int32 length_);

  static const std::int32_t ID = 1636265063;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authenticationCodeTypeFlashCall final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string pattern_;

  authenticationCodeTypeFlashCall();

  explicit authenticationCodeTypeFlashCall(string const &pattern_);

  static const std::int32_t ID = 1395882402;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authenticationCodeTypeMissedCall final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_prefix_;
  int32 length_;

  authenticationCodeTypeMissedCall();

  authenticationCodeTypeMissedCall(string const &phone_number_prefix_, int32 length_);

  static const std::int32_t ID = 700123783;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authenticationCodeTypeFragment final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int32 length_;

  authenticationCodeTypeFragment();

  authenticationCodeTypeFragment(string const &url_, int32 length_);

  static const std::int32_t ID = -2129693491;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authenticationCodeTypeFirebaseAndroid final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<FirebaseDeviceVerificationParameters> device_verification_parameters_;
  int32 length_;

  authenticationCodeTypeFirebaseAndroid();

  authenticationCodeTypeFirebaseAndroid(object_ptr<FirebaseDeviceVerificationParameters> &&device_verification_parameters_, int32 length_);

  static const std::int32_t ID = 1872475422;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authenticationCodeTypeFirebaseIos final : public AuthenticationCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string receipt_;
  int32 push_timeout_;
  int32 length_;

  authenticationCodeTypeFirebaseIos();

  authenticationCodeTypeFirebaseIos(string const &receipt_, int32 push_timeout_, int32 length_);

  static const std::int32_t ID = -11162989;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmailAddressResetState;

class authenticationCodeInfo;

class emailAddressAuthenticationCodeInfo;

class termsOfService;

class AuthorizationState: public Object {
 public:
};

class authorizationStateWaitTdlibParameters final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  authorizationStateWaitTdlibParameters();

  static const std::int32_t ID = 904720988;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateWaitPhoneNumber final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  authorizationStateWaitPhoneNumber();

  static const std::int32_t ID = 306402531;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateWaitPremiumPurchase final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string store_product_id_;

  authorizationStateWaitPremiumPurchase();

  explicit authorizationStateWaitPremiumPurchase(string const &store_product_id_);

  static const std::int32_t ID = -862487743;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateWaitEmailAddress final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool allow_apple_id_;
  bool allow_google_id_;

  authorizationStateWaitEmailAddress();

  authorizationStateWaitEmailAddress(bool allow_apple_id_, bool allow_google_id_);

  static const std::int32_t ID = 1040478663;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateWaitEmailCode final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool allow_apple_id_;
  bool allow_google_id_;
  object_ptr<emailAddressAuthenticationCodeInfo> code_info_;
  object_ptr<EmailAddressResetState> email_address_reset_state_;

  authorizationStateWaitEmailCode();

  authorizationStateWaitEmailCode(bool allow_apple_id_, bool allow_google_id_, object_ptr<emailAddressAuthenticationCodeInfo> &&code_info_, object_ptr<EmailAddressResetState> &&email_address_reset_state_);

  static const std::int32_t ID = -1868627365;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateWaitCode final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<authenticationCodeInfo> code_info_;

  authorizationStateWaitCode();

  explicit authorizationStateWaitCode(object_ptr<authenticationCodeInfo> &&code_info_);

  static const std::int32_t ID = 52643073;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateWaitOtherDeviceConfirmation final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  authorizationStateWaitOtherDeviceConfirmation();

  explicit authorizationStateWaitOtherDeviceConfirmation(string const &link_);

  static const std::int32_t ID = 860166378;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateWaitRegistration final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<termsOfService> terms_of_service_;

  authorizationStateWaitRegistration();

  explicit authorizationStateWaitRegistration(object_ptr<termsOfService> &&terms_of_service_);

  static const std::int32_t ID = 550350511;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateWaitPassword final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string password_hint_;
  bool has_recovery_email_address_;
  bool has_passport_data_;
  string recovery_email_address_pattern_;

  authorizationStateWaitPassword();

  authorizationStateWaitPassword(string const &password_hint_, bool has_recovery_email_address_, bool has_passport_data_, string const &recovery_email_address_pattern_);

  static const std::int32_t ID = 112238030;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateReady final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  authorizationStateReady();

  static const std::int32_t ID = -1834871737;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateLoggingOut final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  authorizationStateLoggingOut();

  static const std::int32_t ID = 154449270;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateClosing final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  authorizationStateClosing();

  static const std::int32_t ID = 445855311;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class authorizationStateClosed final : public AuthorizationState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  authorizationStateClosed();

  static const std::int32_t ID = 1526047584;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autoDownloadSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_auto_download_enabled_;
  int32 max_photo_file_size_;
  int53 max_video_file_size_;
  int53 max_other_file_size_;
  int32 video_upload_bitrate_;
  bool preload_large_videos_;
  bool preload_next_audio_;
  bool preload_stories_;
  bool use_less_data_for_calls_;

  autoDownloadSettings();

  autoDownloadSettings(bool is_auto_download_enabled_, int32 max_photo_file_size_, int53 max_video_file_size_, int53 max_other_file_size_, int32 video_upload_bitrate_, bool preload_large_videos_, bool preload_next_audio_, bool preload_stories_, bool use_less_data_for_calls_);

  static const std::int32_t ID = 991433696;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autoDownloadSettings;

class autoDownloadSettingsPresets final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<autoDownloadSettings> low_;
  object_ptr<autoDownloadSettings> medium_;
  object_ptr<autoDownloadSettings> high_;

  autoDownloadSettingsPresets();

  autoDownloadSettingsPresets(object_ptr<autoDownloadSettings> &&low_, object_ptr<autoDownloadSettings> &&medium_, object_ptr<autoDownloadSettings> &&high_);

  static const std::int32_t ID = -782099166;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autosaveSettingsException;

class scopeAutosaveSettings;

class autosaveSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<scopeAutosaveSettings> private_chat_settings_;
  object_ptr<scopeAutosaveSettings> group_settings_;
  object_ptr<scopeAutosaveSettings> channel_settings_;
  array<object_ptr<autosaveSettingsException>> exceptions_;

  autosaveSettings();

  autosaveSettings(object_ptr<scopeAutosaveSettings> &&private_chat_settings_, object_ptr<scopeAutosaveSettings> &&group_settings_, object_ptr<scopeAutosaveSettings> &&channel_settings_, array<object_ptr<autosaveSettingsException>> &&exceptions_);

  static const std::int32_t ID = 1629412502;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class scopeAutosaveSettings;

class autosaveSettingsException final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<scopeAutosaveSettings> settings_;

  autosaveSettingsException();

  autosaveSettingsException(int53 chat_id_, object_ptr<scopeAutosaveSettings> &&settings_);

  static const std::int32_t ID = 1483470280;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AutosaveSettingsScope: public Object {
 public:
};

class autosaveSettingsScopePrivateChats final : public AutosaveSettingsScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  autosaveSettingsScopePrivateChats();

  static const std::int32_t ID = 1395227007;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autosaveSettingsScopeGroupChats final : public AutosaveSettingsScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  autosaveSettingsScopeGroupChats();

  static const std::int32_t ID = 853544526;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autosaveSettingsScopeChannelChats final : public AutosaveSettingsScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  autosaveSettingsScopeChannelChats();

  static const std::int32_t ID = -499572783;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autosaveSettingsScopeChat final : public AutosaveSettingsScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  autosaveSettingsScopeChat();

  explicit autosaveSettingsScopeChat(int53 chat_id_);

  static const std::int32_t ID = -1632255255;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class gift;

class availableGift final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<gift> gift_;
  int32 resale_count_;
  int53 min_resale_star_count_;
  string title_;

  availableGift();

  availableGift(object_ptr<gift> &&gift_, int32 resale_count_, int53 min_resale_star_count_, string const &title_);

  static const std::int32_t ID = 850530502;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class availableGift;

class availableGifts final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<availableGift>> gifts_;

  availableGifts();

  explicit availableGifts(array<object_ptr<availableGift>> &&gifts_);

  static const std::int32_t ID = -1450341886;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType;

class availableReaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionType> type_;
  bool needs_premium_;

  availableReaction();

  availableReaction(object_ptr<ReactionType> &&type_, bool needs_premium_);

  static const std::int32_t ID = -117292153;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionUnavailabilityReason;

class availableReaction;

class availableReactions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<availableReaction>> top_reactions_;
  array<object_ptr<availableReaction>> recent_reactions_;
  array<object_ptr<availableReaction>> popular_reactions_;
  bool allow_custom_emoji_;
  bool are_tags_;
  object_ptr<ReactionUnavailabilityReason> unavailability_reason_;

  availableReactions();

  availableReactions(array<object_ptr<availableReaction>> &&top_reactions_, array<object_ptr<availableReaction>> &&recent_reactions_, array<object_ptr<availableReaction>> &&popular_reactions_, bool allow_custom_emoji_, bool are_tags_, object_ptr<ReactionUnavailabilityReason> &&unavailability_reason_);

  static const std::int32_t ID = 912529522;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BackgroundType;

class document;

class background final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  bool is_default_;
  bool is_dark_;
  string name_;
  object_ptr<document> document_;
  object_ptr<BackgroundType> type_;

  background();

  background(int64 id_, bool is_default_, bool is_dark_, string const &name_, object_ptr<document> &&document_, object_ptr<BackgroundType> &&type_);

  static const std::int32_t ID = -429971172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BackgroundFill: public Object {
 public:
};

class backgroundFillSolid final : public BackgroundFill {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 color_;

  backgroundFillSolid();

  explicit backgroundFillSolid(int32 color_);

  static const std::int32_t ID = 1010678813;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class backgroundFillGradient final : public BackgroundFill {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 top_color_;
  int32 bottom_color_;
  int32 rotation_angle_;

  backgroundFillGradient();

  backgroundFillGradient(int32 top_color_, int32 bottom_color_, int32 rotation_angle_);

  static const std::int32_t ID = -1839206017;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class backgroundFillFreeformGradient final : public BackgroundFill {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> colors_;

  backgroundFillFreeformGradient();

  explicit backgroundFillFreeformGradient(array<int32> &&colors_);

  static const std::int32_t ID = -1145469255;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BackgroundFill;

class BackgroundType: public Object {
 public:
};

class backgroundTypeWallpaper final : public BackgroundType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_blurred_;
  bool is_moving_;

  backgroundTypeWallpaper();

  backgroundTypeWallpaper(bool is_blurred_, bool is_moving_);

  static const std::int32_t ID = 1972128891;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class backgroundTypePattern final : public BackgroundType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BackgroundFill> fill_;
  int32 intensity_;
  bool is_inverted_;
  bool is_moving_;

  backgroundTypePattern();

  backgroundTypePattern(object_ptr<BackgroundFill> &&fill_, int32 intensity_, bool is_inverted_, bool is_moving_);

  static const std::int32_t ID = 1290213117;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class backgroundTypeFill final : public BackgroundType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BackgroundFill> fill_;

  backgroundTypeFill();

  explicit backgroundTypeFill(object_ptr<BackgroundFill> &&fill_);

  static const std::int32_t ID = 993008684;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class backgroundTypeChatTheme final : public BackgroundType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string theme_name_;

  backgroundTypeChatTheme();

  explicit backgroundTypeChatTheme(string const &theme_name_);

  static const std::int32_t ID = 1299879762;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class background;

class backgrounds final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<background>> backgrounds_;

  backgrounds();

  explicit backgrounds(array<object_ptr<background>> &&backgrounds_);

  static const std::int32_t ID = 724728704;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class bankCardActionOpenUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string url_;

  bankCardActionOpenUrl();

  bankCardActionOpenUrl(string const &text_, string const &url_);

  static const std::int32_t ID = -196454267;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class bankCardActionOpenUrl;

class bankCardInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  array<object_ptr<bankCardActionOpenUrl>> actions_;

  bankCardInfo();

  bankCardInfo(string const &title_, array<object_ptr<bankCardActionOpenUrl>> &&actions_);

  static const std::int32_t ID = -2116647730;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatMemberStatus;

class basicGroup final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 id_;
  int32 member_count_;
  object_ptr<ChatMemberStatus> status_;
  bool is_active_;
  int53 upgraded_to_supergroup_id_;

  basicGroup();

  basicGroup(int53 id_, int32 member_count_, object_ptr<ChatMemberStatus> &&status_, bool is_active_, int53 upgraded_to_supergroup_id_);

  static const std::int32_t ID = -194767217;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommands;

class chatInviteLink;

class chatMember;

class chatPhoto;

class basicGroupFullInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> photo_;
  string description_;
  int53 creator_user_id_;
  array<object_ptr<chatMember>> members_;
  bool can_hide_members_;
  bool can_toggle_aggressive_anti_spam_;
  object_ptr<chatInviteLink> invite_link_;
  array<object_ptr<botCommands>> bot_commands_;

  basicGroupFullInfo();

  basicGroupFullInfo(object_ptr<chatPhoto> &&photo_, string const &description_, int53 creator_user_id_, array<object_ptr<chatMember>> &&members_, bool can_hide_members_, bool can_toggle_aggressive_anti_spam_, object_ptr<chatInviteLink> &&invite_link_, array<object_ptr<botCommands>> &&bot_commands_);

  static const std::int32_t ID = -1879035520;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class birthdate final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 day_;
  int32 month_;
  int32 year_;

  birthdate();

  birthdate(int32 day_, int32 month_, int32 year_);

  static const std::int32_t ID = 1644064030;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BlockList: public Object {
 public:
};

class blockListMain final : public BlockList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  blockListMain();

  static const std::int32_t ID = 1352930172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class blockListStories final : public BlockList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  blockListStories();

  static const std::int32_t ID = 103323228;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommand final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string command_;
  string description_;

  botCommand();

  botCommand(string const &command_, string const &description_);

  static const std::int32_t ID = -1032140601;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotCommandScope: public Object {
 public:
};

class botCommandScopeDefault final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  botCommandScopeDefault();

  static const std::int32_t ID = 795652779;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopeAllPrivateChats final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  botCommandScopeAllPrivateChats();

  static const std::int32_t ID = -344889543;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopeAllGroupChats final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  botCommandScopeAllGroupChats();

  static const std::int32_t ID = -981088162;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopeAllChatAdministrators final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  botCommandScopeAllChatAdministrators();

  static const std::int32_t ID = 1998329169;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopeChat final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  botCommandScopeChat();

  explicit botCommandScopeChat(int53 chat_id_);

  static const std::int32_t ID = -430234971;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopeChatAdministrators final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  botCommandScopeChatAdministrators();

  explicit botCommandScopeChatAdministrators(int53 chat_id_);

  static const std::int32_t ID = 1119682126;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommandScopeChatMember final : public BotCommandScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 user_id_;

  botCommandScopeChatMember();

  botCommandScopeChatMember(int53 chat_id_, int53 user_id_);

  static const std::int32_t ID = -211380494;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommand;

class botCommands final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  array<object_ptr<botCommand>> commands_;

  botCommands();

  botCommands(int53 bot_user_id_, array<object_ptr<botCommand>> &&commands_);

  static const std::int32_t ID = 1741364468;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InternalLinkType;

class affiliateProgramInfo;

class animation;

class botCommand;

class botMenuButton;

class botVerificationParameters;

class chatAdministratorRights;

class photo;

class botInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string short_description_;
  string description_;
  object_ptr<photo> photo_;
  object_ptr<animation> animation_;
  object_ptr<botMenuButton> menu_button_;
  array<object_ptr<botCommand>> commands_;
  string privacy_policy_url_;
  object_ptr<chatAdministratorRights> default_group_administrator_rights_;
  object_ptr<chatAdministratorRights> default_channel_administrator_rights_;
  object_ptr<affiliateProgramInfo> affiliate_program_;
  int32 web_app_background_light_color_;
  int32 web_app_background_dark_color_;
  int32 web_app_header_light_color_;
  int32 web_app_header_dark_color_;
  object_ptr<botVerificationParameters> verification_parameters_;
  bool can_get_revenue_statistics_;
  bool can_manage_emoji_status_;
  bool has_media_previews_;
  object_ptr<InternalLinkType> edit_commands_link_;
  object_ptr<InternalLinkType> edit_description_link_;
  object_ptr<InternalLinkType> edit_description_media_link_;
  object_ptr<InternalLinkType> edit_settings_link_;

  botInfo();

  botInfo(string const &short_description_, string const &description_, object_ptr<photo> &&photo_, object_ptr<animation> &&animation_, object_ptr<botMenuButton> &&menu_button_, array<object_ptr<botCommand>> &&commands_, string const &privacy_policy_url_, object_ptr<chatAdministratorRights> &&default_group_administrator_rights_, object_ptr<chatAdministratorRights> &&default_channel_administrator_rights_, object_ptr<affiliateProgramInfo> &&affiliate_program_, int32 web_app_background_light_color_, int32 web_app_background_dark_color_, int32 web_app_header_light_color_, int32 web_app_header_dark_color_, object_ptr<botVerificationParameters> &&verification_parameters_, bool can_get_revenue_statistics_, bool can_manage_emoji_status_, bool has_media_previews_, object_ptr<InternalLinkType> &&edit_commands_link_, object_ptr<InternalLinkType> &&edit_description_link_, object_ptr<InternalLinkType> &&edit_description_media_link_, object_ptr<InternalLinkType> &&edit_settings_link_);

  static const std::int32_t ID = 1771886272;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StoryContent;

class botMediaPreview final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 date_;
  object_ptr<StoryContent> content_;

  botMediaPreview();

  botMediaPreview(int32 date_, object_ptr<StoryContent> &&content_);

  static const std::int32_t ID = -1632264984;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botMediaPreview;

class botMediaPreviewInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<botMediaPreview>> previews_;
  array<string> language_codes_;

  botMediaPreviewInfo();

  botMediaPreviewInfo(array<object_ptr<botMediaPreview>> &&previews_, array<string> &&language_codes_);

  static const std::int32_t ID = -284783012;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botMediaPreview;

class botMediaPreviews final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<botMediaPreview>> previews_;

  botMediaPreviews();

  explicit botMediaPreviews(array<object_ptr<botMediaPreview>> &&previews_);

  static const std::int32_t ID = -1787720586;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botMenuButton final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  string url_;

  botMenuButton();

  botMenuButton(string const &text_, string const &url_);

  static const std::int32_t ID = -944407322;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class botVerification final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  int64 icon_custom_emoji_id_;
  object_ptr<formattedText> custom_description_;

  botVerification();

  botVerification(int53 bot_user_id_, int64 icon_custom_emoji_id_, object_ptr<formattedText> &&custom_description_);

  static const std::int32_t ID = -1319061774;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class botVerificationParameters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 icon_custom_emoji_id_;
  string organization_name_;
  object_ptr<formattedText> default_custom_description_;
  bool can_set_custom_description_;

  botVerificationParameters();

  botVerificationParameters(int64 icon_custom_emoji_id_, string const &organization_name_, object_ptr<formattedText> &&default_custom_description_, bool can_set_custom_description_);

  static const std::int32_t ID = -723737249;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webApp;

class BotWriteAccessAllowReason: public Object {
 public:
};

class botWriteAccessAllowReasonConnectedWebsite final : public BotWriteAccessAllowReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string domain_name_;

  botWriteAccessAllowReasonConnectedWebsite();

  explicit botWriteAccessAllowReasonConnectedWebsite(string const &domain_name_);

  static const std::int32_t ID = 2016325603;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botWriteAccessAllowReasonAddedToAttachmentMenu final : public BotWriteAccessAllowReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  botWriteAccessAllowReasonAddedToAttachmentMenu();

  static const std::int32_t ID = -2104795235;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botWriteAccessAllowReasonLaunchedWebApp final : public BotWriteAccessAllowReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<webApp> web_app_;

  botWriteAccessAllowReasonLaunchedWebApp();

  explicit botWriteAccessAllowReasonLaunchedWebApp(object_ptr<webApp> &&web_app_);

  static const std::int32_t ID = -240843561;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botWriteAccessAllowReasonAcceptedRequest final : public BotWriteAccessAllowReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  botWriteAccessAllowReasonAcceptedRequest();

  static const std::int32_t ID = -1983497220;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessAwayMessageSchedule: public Object {
 public:
};

class businessAwayMessageScheduleAlways final : public BusinessAwayMessageSchedule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessAwayMessageScheduleAlways();

  static const std::int32_t ID = -910564679;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessAwayMessageScheduleOutsideOfOpeningHours final : public BusinessAwayMessageSchedule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessAwayMessageScheduleOutsideOfOpeningHours();

  static const std::int32_t ID = -968630506;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessAwayMessageScheduleCustom final : public BusinessAwayMessageSchedule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 start_date_;
  int32 end_date_;

  businessAwayMessageScheduleCustom();

  businessAwayMessageScheduleCustom(int32 start_date_, int32 end_date_);

  static const std::int32_t ID = -1967108654;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessAwayMessageSchedule;

class businessRecipients;

class businessAwayMessageSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  object_ptr<businessRecipients> recipients_;
  object_ptr<BusinessAwayMessageSchedule> schedule_;
  bool offline_only_;

  businessAwayMessageSettings();

  businessAwayMessageSettings(int32 shortcut_id_, object_ptr<businessRecipients> &&recipients_, object_ptr<BusinessAwayMessageSchedule> &&schedule_, bool offline_only_);

  static const std::int32_t ID = 353084137;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessBotManageBar final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string manage_url_;
  bool is_bot_paused_;
  bool can_bot_reply_;

  businessBotManageBar();

  businessBotManageBar(int53 bot_user_id_, string const &manage_url_, bool is_bot_paused_, bool can_bot_reply_);

  static const std::int32_t ID = -311399806;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessBotRights final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool can_reply_;
  bool can_read_messages_;
  bool can_delete_sent_messages_;
  bool can_delete_all_messages_;
  bool can_edit_name_;
  bool can_edit_bio_;
  bool can_edit_profile_photo_;
  bool can_edit_username_;
  bool can_view_gifts_and_stars_;
  bool can_sell_gifts_;
  bool can_change_gift_settings_;
  bool can_transfer_and_upgrade_gifts_;
  bool can_transfer_stars_;
  bool can_manage_stories_;

  businessBotRights();

  businessBotRights(bool can_reply_, bool can_read_messages_, bool can_delete_sent_messages_, bool can_delete_all_messages_, bool can_edit_name_, bool can_edit_bio_, bool can_edit_profile_photo_, bool can_edit_username_, bool can_view_gifts_and_stars_, bool can_sell_gifts_, bool can_change_gift_settings_, bool can_transfer_and_upgrade_gifts_, bool can_transfer_stars_, bool can_manage_stories_);

  static const std::int32_t ID = 1224839038;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class businessChatLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;
  object_ptr<formattedText> text_;
  string title_;
  int32 view_count_;

  businessChatLink();

  businessChatLink(string const &link_, object_ptr<formattedText> &&text_, string const &title_, int32 view_count_);

  static const std::int32_t ID = -1902539901;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class businessChatLinkInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<formattedText> text_;

  businessChatLinkInfo();

  businessChatLinkInfo(int53 chat_id_, object_ptr<formattedText> &&text_);

  static const std::int32_t ID = -864865105;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessChatLink;

class businessChatLinks final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<businessChatLink>> links_;

  businessChatLinks();

  explicit businessChatLinks(array<object_ptr<businessChatLink>> &&links_);

  static const std::int32_t ID = 79067036;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessBotRights;

class businessRecipients;

class businessConnectedBot final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  object_ptr<businessRecipients> recipients_;
  object_ptr<businessBotRights> rights_;

  businessConnectedBot();

  businessConnectedBot(int53 bot_user_id_, object_ptr<businessRecipients> &&recipients_, object_ptr<businessBotRights> &&rights_);

  static const std::int32_t ID = -1815439021;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessBotRights;

class businessConnection final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  int53 user_id_;
  int53 user_chat_id_;
  int32 date_;
  object_ptr<businessBotRights> rights_;
  bool is_enabled_;

  businessConnection();

  businessConnection(string const &id_, int53 user_id_, int53 user_chat_id_, int32 date_, object_ptr<businessBotRights> &&rights_, bool is_enabled_);

  static const std::int32_t ID = -995703933;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessFeature: public Object {
 public:
};

class businessFeatureLocation final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureLocation();

  static const std::int32_t ID = -1064304004;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureOpeningHours final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureOpeningHours();

  static const std::int32_t ID = 461054701;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureQuickReplies final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureQuickReplies();

  static const std::int32_t ID = -1674048894;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureGreetingMessage final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureGreetingMessage();

  static const std::int32_t ID = 1789424756;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureAwayMessage final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureAwayMessage();

  static const std::int32_t ID = 1090119901;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureAccountLinks final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureAccountLinks();

  static const std::int32_t ID = 1878693646;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureStartPage final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureStartPage();

  static const std::int32_t ID = 401471457;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureBots final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureBots();

  static const std::int32_t ID = 275084773;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureEmojiStatus final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureEmojiStatus();

  static const std::int32_t ID = -846282523;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureChatFolderTags final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureChatFolderTags();

  static const std::int32_t ID = -543880918;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeatureUpgradedStories final : public BusinessFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  businessFeatureUpgradedStories();

  static const std::int32_t ID = -1812245550;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessFeature;

class animation;

class businessFeaturePromotionAnimation final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BusinessFeature> feature_;
  object_ptr<animation> animation_;

  businessFeaturePromotionAnimation();

  businessFeaturePromotionAnimation(object_ptr<BusinessFeature> &&feature_, object_ptr<animation> &&animation_);

  static const std::int32_t ID = 2047174666;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessFeature;

class businessFeatures final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<BusinessFeature>> features_;

  businessFeatures();

  explicit businessFeatures(array<object_ptr<BusinessFeature>> &&features_);

  static const std::int32_t ID = -1532468184;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessRecipients;

class businessGreetingMessageSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  object_ptr<businessRecipients> recipients_;
  int32 inactivity_days_;

  businessGreetingMessageSettings();

  businessGreetingMessageSettings(int32 shortcut_id_, object_ptr<businessRecipients> &&recipients_, int32 inactivity_days_);

  static const std::int32_t ID = 1689140754;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessAwayMessageSettings;

class businessGreetingMessageSettings;

class businessLocation;

class businessOpeningHours;

class businessStartPage;

class businessInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<businessLocation> location_;
  object_ptr<businessOpeningHours> opening_hours_;
  object_ptr<businessOpeningHours> local_opening_hours_;
  int32 next_open_in_;
  int32 next_close_in_;
  object_ptr<businessGreetingMessageSettings> greeting_message_settings_;
  object_ptr<businessAwayMessageSettings> away_message_settings_;
  object_ptr<businessStartPage> start_page_;

  businessInfo();

  businessInfo(object_ptr<businessLocation> &&location_, object_ptr<businessOpeningHours> &&opening_hours_, object_ptr<businessOpeningHours> &&local_opening_hours_, int32 next_open_in_, int32 next_close_in_, object_ptr<businessGreetingMessageSettings> &&greeting_message_settings_, object_ptr<businessAwayMessageSettings> &&away_message_settings_, object_ptr<businessStartPage> &&start_page_);

  static const std::int32_t ID = 1428179342;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class location;

class businessLocation final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;
  string address_;

  businessLocation();

  businessLocation(object_ptr<location> &&location_, string const &address_);

  static const std::int32_t ID = -1084969126;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class businessMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;
  object_ptr<message> reply_to_message_;

  businessMessage();

  businessMessage(object_ptr<message> &&message_, object_ptr<message> &&reply_to_message_);

  static const std::int32_t ID = -94353850;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessMessage;

class businessMessages final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<businessMessage>> messages_;

  businessMessages();

  explicit businessMessages(array<object_ptr<businessMessage>> &&messages_);

  static const std::int32_t ID = -764562473;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessOpeningHoursInterval;

class businessOpeningHours final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string time_zone_id_;
  array<object_ptr<businessOpeningHoursInterval>> opening_hours_;

  businessOpeningHours();

  businessOpeningHours(string const &time_zone_id_, array<object_ptr<businessOpeningHoursInterval>> &&opening_hours_);

  static const std::int32_t ID = 816603700;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessOpeningHoursInterval final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 start_minute_;
  int32 end_minute_;

  businessOpeningHoursInterval();

  businessOpeningHoursInterval(int32 start_minute_, int32 end_minute_);

  static const std::int32_t ID = -1108322732;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessRecipients final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> chat_ids_;
  array<int53> excluded_chat_ids_;
  bool select_existing_chats_;
  bool select_new_chats_;
  bool select_contacts_;
  bool select_non_contacts_;
  bool exclude_selected_;

  businessRecipients();

  businessRecipients(array<int53> &&chat_ids_, array<int53> &&excluded_chat_ids_, bool select_existing_chats_, bool select_new_chats_, bool select_contacts_, bool select_non_contacts_, bool exclude_selected_);

  static const std::int32_t ID = 868656909;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class businessStartPage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  string message_;
  object_ptr<sticker> sticker_;

  businessStartPage();

  businessStartPage(string const &title_, string const &message_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = -1616709681;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CallState;

class call final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int53 user_id_;
  bool is_outgoing_;
  bool is_video_;
  object_ptr<CallState> state_;

  call();

  call(int32 id_, int53 user_id_, bool is_outgoing_, bool is_video_, object_ptr<CallState> &&state_);

  static const std::int32_t ID = 920360804;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CallDiscardReason: public Object {
 public:
};

class callDiscardReasonEmpty final : public CallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callDiscardReasonEmpty();

  static const std::int32_t ID = -1258917949;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callDiscardReasonMissed final : public CallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callDiscardReasonMissed();

  static const std::int32_t ID = 1680358012;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callDiscardReasonDeclined final : public CallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callDiscardReasonDeclined();

  static const std::int32_t ID = -1729926094;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callDiscardReasonDisconnected final : public CallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callDiscardReasonDisconnected();

  static const std::int32_t ID = -1342872670;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callDiscardReasonHungUp final : public CallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callDiscardReasonHungUp();

  static const std::int32_t ID = 438216166;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callDiscardReasonUpgradeToGroupCall final : public CallDiscardReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;

  callDiscardReasonUpgradeToGroupCall();

  explicit callDiscardReasonUpgradeToGroupCall(string const &invite_link_);

  static const std::int32_t ID = 1254509319;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callId final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;

  callId();

  explicit callId(int32 id_);

  static const std::int32_t ID = 65717769;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CallProblem: public Object {
 public:
};

class callProblemEcho final : public CallProblem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callProblemEcho();

  static const std::int32_t ID = 801116548;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProblemNoise final : public CallProblem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callProblemNoise();

  static const std::int32_t ID = 1053065359;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProblemInterruptions final : public CallProblem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callProblemInterruptions();

  static const std::int32_t ID = 1119493218;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProblemDistortedSpeech final : public CallProblem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callProblemDistortedSpeech();

  static const std::int32_t ID = 379960581;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProblemSilentLocal final : public CallProblem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callProblemSilentLocal();

  static const std::int32_t ID = 253652790;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProblemSilentRemote final : public CallProblem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callProblemSilentRemote();

  static const std::int32_t ID = 573634714;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProblemDropped final : public CallProblem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callProblemDropped();

  static const std::int32_t ID = -1207311487;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProblemDistortedVideo final : public CallProblem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callProblemDistortedVideo();

  static const std::int32_t ID = 385245706;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProblemPixelatedVideo final : public CallProblem {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callProblemPixelatedVideo();

  static const std::int32_t ID = 2115315411;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProtocol final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool udp_p2p_;
  bool udp_reflector_;
  int32 min_layer_;
  int32 max_layer_;
  array<string> library_versions_;

  callProtocol();

  callProtocol(bool udp_p2p_, bool udp_reflector_, int32 min_layer_, int32 max_layer_, array<string> &&library_versions_);

  static const std::int32_t ID = -1075562897;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CallServerType;

class callServer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  string ip_address_;
  string ipv6_address_;
  int32 port_;
  object_ptr<CallServerType> type_;

  callServer();

  callServer(int64 id_, string const &ip_address_, string const &ipv6_address_, int32 port_, object_ptr<CallServerType> &&type_);

  static const std::int32_t ID = 1865932695;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CallServerType: public Object {
 public:
};

class callServerTypeTelegramReflector final : public CallServerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes peer_tag_;
  bool is_tcp_;

  callServerTypeTelegramReflector();

  callServerTypeTelegramReflector(bytes const &peer_tag_, bool is_tcp_);

  static const std::int32_t ID = 850343189;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callServerTypeWebrtc final : public CallServerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string username_;
  string password_;
  bool supports_turn_;
  bool supports_stun_;

  callServerTypeWebrtc();

  callServerTypeWebrtc(string const &username_, string const &password_, bool supports_turn_, bool supports_stun_);

  static const std::int32_t ID = 1250622821;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CallDiscardReason;

class callProtocol;

class callServer;

class error;

class CallState: public Object {
 public:
};

class callStatePending final : public CallState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_created_;
  bool is_received_;

  callStatePending();

  callStatePending(bool is_created_, bool is_received_);

  static const std::int32_t ID = 1073048620;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callStateExchangingKeys final : public CallState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callStateExchangingKeys();

  static const std::int32_t ID = -1848149403;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callStateReady final : public CallState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<callProtocol> protocol_;
  array<object_ptr<callServer>> servers_;
  string config_;
  bytes encryption_key_;
  array<string> emojis_;
  bool allow_p2p_;
  bool is_group_call_supported_;
  string custom_parameters_;

  callStateReady();

  callStateReady(object_ptr<callProtocol> &&protocol_, array<object_ptr<callServer>> &&servers_, string const &config_, bytes const &encryption_key_, array<string> &&emojis_, bool allow_p2p_, bool is_group_call_supported_, string const &custom_parameters_);

  static const std::int32_t ID = -281776921;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callStateHangingUp final : public CallState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  callStateHangingUp();

  static const std::int32_t ID = -2133790038;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callStateDiscarded final : public CallState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<CallDiscardReason> reason_;
  bool need_rating_;
  bool need_debug_information_;
  bool need_log_;

  callStateDiscarded();

  callStateDiscarded(object_ptr<CallDiscardReason> &&reason_, bool need_rating_, bool need_debug_information_, bool need_log_);

  static const std::int32_t ID = 1394310213;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callStateError final : public CallState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<error> error_;

  callStateError();

  explicit callStateError(object_ptr<error> &&error_);

  static const std::int32_t ID = -975215467;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callbackQueryAnswer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  bool show_alert_;
  string url_;

  callbackQueryAnswer();

  callbackQueryAnswer(string const &text_, bool show_alert_, string const &url_);

  static const std::int32_t ID = 360867933;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CallbackQueryPayload: public Object {
 public:
};

class callbackQueryPayloadData final : public CallbackQueryPayload {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes data_;

  callbackQueryPayloadData();

  explicit callbackQueryPayloadData(bytes const &data_);

  static const std::int32_t ID = -1977729946;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callbackQueryPayloadDataWithPassword final : public CallbackQueryPayload {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string password_;
  bytes data_;

  callbackQueryPayloadDataWithPassword();

  callbackQueryPayloadDataWithPassword(string const &password_, bytes const &data_);

  static const std::int32_t ID = 1340266738;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callbackQueryPayloadGame final : public CallbackQueryPayload {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string game_short_name_;

  callbackQueryPayloadGame();

  explicit callbackQueryPayloadGame(string const &game_short_name_);

  static const std::int32_t ID = 1303571512;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CanPostStoryResult: public Object {
 public:
};

class canPostStoryResultOk final : public CanPostStoryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 story_count_;

  canPostStoryResultOk();

  explicit canPostStoryResultOk(int32 story_count_);

  static const std::int32_t ID = 2083205610;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canPostStoryResultPremiumNeeded final : public CanPostStoryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  canPostStoryResultPremiumNeeded();

  static const std::int32_t ID = 935130501;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canPostStoryResultBoostNeeded final : public CanPostStoryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  canPostStoryResultBoostNeeded();

  static const std::int32_t ID = 80246195;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canPostStoryResultActiveStoryLimitExceeded final : public CanPostStoryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  canPostStoryResultActiveStoryLimitExceeded();

  static const std::int32_t ID = -1640759002;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canPostStoryResultWeeklyLimitExceeded final : public CanPostStoryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 retry_after_;

  canPostStoryResultWeeklyLimitExceeded();

  explicit canPostStoryResultWeeklyLimitExceeded(int32 retry_after_);

  static const std::int32_t ID = 552858605;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canPostStoryResultMonthlyLimitExceeded final : public CanPostStoryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 retry_after_;

  canPostStoryResultMonthlyLimitExceeded();

  explicit canPostStoryResultMonthlyLimitExceeded(int32 retry_after_);

  static const std::int32_t ID = -784208562;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CanSendMessageToUserResult: public Object {
 public:
};

class canSendMessageToUserResultOk final : public CanSendMessageToUserResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  canSendMessageToUserResultOk();

  static const std::int32_t ID = 1530583042;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canSendMessageToUserResultUserHasPaidMessages final : public CanSendMessageToUserResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 outgoing_paid_message_star_count_;

  canSendMessageToUserResultUserHasPaidMessages();

  explicit canSendMessageToUserResultUserHasPaidMessages(int53 outgoing_paid_message_star_count_);

  static const std::int32_t ID = -1346487602;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canSendMessageToUserResultUserIsDeleted final : public CanSendMessageToUserResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  canSendMessageToUserResultUserIsDeleted();

  static const std::int32_t ID = -1944639903;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canSendMessageToUserResultUserRestrictsNewChats final : public CanSendMessageToUserResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  canSendMessageToUserResultUserRestrictsNewChats();

  static const std::int32_t ID = 1929699797;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CanTransferOwnershipResult: public Object {
 public:
};

class canTransferOwnershipResultOk final : public CanTransferOwnershipResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  canTransferOwnershipResultOk();

  static const std::int32_t ID = -89881021;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canTransferOwnershipResultPasswordNeeded final : public CanTransferOwnershipResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  canTransferOwnershipResultPasswordNeeded();

  static const std::int32_t ID = 1548372703;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canTransferOwnershipResultPasswordTooFresh final : public CanTransferOwnershipResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 retry_after_;

  canTransferOwnershipResultPasswordTooFresh();

  explicit canTransferOwnershipResultPasswordTooFresh(int32 retry_after_);

  static const std::int32_t ID = 811440913;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class canTransferOwnershipResultSessionTooFresh final : public CanTransferOwnershipResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 retry_after_;

  canTransferOwnershipResultSessionTooFresh();

  explicit canTransferOwnershipResultSessionTooFresh(int32 retry_after_);

  static const std::int32_t ID = 984664289;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BlockList;

class ChatActionBar;

class ChatAvailableReactions;

class ChatList;

class ChatType;

class MessageSender;

class businessBotManageBar;

class chatBackground;

class chatJoinRequestsInfo;

class chatNotificationSettings;

class chatPermissions;

class chatPhotoInfo;

class chatPosition;

class draftMessage;

class emojiStatus;

class message;

class videoChat;

class chat final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 id_;
  object_ptr<ChatType> type_;
  string title_;
  object_ptr<chatPhotoInfo> photo_;
  int32 accent_color_id_;
  int64 background_custom_emoji_id_;
  int32 profile_accent_color_id_;
  int64 profile_background_custom_emoji_id_;
  object_ptr<chatPermissions> permissions_;
  object_ptr<message> last_message_;
  array<object_ptr<chatPosition>> positions_;
  array<object_ptr<ChatList>> chat_lists_;
  object_ptr<MessageSender> message_sender_id_;
  object_ptr<BlockList> block_list_;
  bool has_protected_content_;
  bool is_translatable_;
  bool is_marked_as_unread_;
  bool view_as_topics_;
  bool has_scheduled_messages_;
  bool can_be_deleted_only_for_self_;
  bool can_be_deleted_for_all_users_;
  bool can_be_reported_;
  bool default_disable_notification_;
  int32 unread_count_;
  int53 last_read_inbox_message_id_;
  int53 last_read_outbox_message_id_;
  int32 unread_mention_count_;
  int32 unread_reaction_count_;
  object_ptr<chatNotificationSettings> notification_settings_;
  object_ptr<ChatAvailableReactions> available_reactions_;
  int32 message_auto_delete_time_;
  object_ptr<emojiStatus> emoji_status_;
  object_ptr<chatBackground> background_;
  string theme_name_;
  object_ptr<ChatActionBar> action_bar_;
  object_ptr<businessBotManageBar> business_bot_manage_bar_;
  object_ptr<videoChat> video_chat_;
  object_ptr<chatJoinRequestsInfo> pending_join_requests_;
  int53 reply_markup_message_id_;
  object_ptr<draftMessage> draft_message_;
  string client_data_;

  chat();

  chat(int53 id_, object_ptr<ChatType> &&type_, string const &title_, object_ptr<chatPhotoInfo> &&photo_, int32 accent_color_id_, int64 background_custom_emoji_id_, int32 profile_accent_color_id_, int64 profile_background_custom_emoji_id_, object_ptr<chatPermissions> &&permissions_, object_ptr<message> &&last_message_, array<object_ptr<chatPosition>> &&positions_, array<object_ptr<ChatList>> &&chat_lists_, object_ptr<MessageSender> &&message_sender_id_, object_ptr<BlockList> &&block_list_, bool has_protected_content_, bool is_translatable_, bool is_marked_as_unread_, bool view_as_topics_, bool has_scheduled_messages_, bool can_be_deleted_only_for_self_, bool can_be_deleted_for_all_users_, bool can_be_reported_, bool default_disable_notification_, int32 unread_count_, int53 last_read_inbox_message_id_, int53 last_read_outbox_message_id_, int32 unread_mention_count_, int32 unread_reaction_count_, object_ptr<chatNotificationSettings> &&notification_settings_, object_ptr<ChatAvailableReactions> &&available_reactions_, int32 message_auto_delete_time_, object_ptr<emojiStatus> &&emoji_status_, object_ptr<chatBackground> &&background_, string const &theme_name_, object_ptr<ChatActionBar> &&action_bar_, object_ptr<businessBotManageBar> &&business_bot_manage_bar_, object_ptr<videoChat> &&video_chat_, object_ptr<chatJoinRequestsInfo> &&pending_join_requests_, int53 reply_markup_message_id_, object_ptr<draftMessage> &&draft_message_, string const &client_data_);

  static const std::int32_t ID = 830601369;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatAction: public Object {
 public:
};

class chatActionTyping final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionTyping();

  static const std::int32_t ID = 380122167;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionRecordingVideo final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionRecordingVideo();

  static const std::int32_t ID = 216553362;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionUploadingVideo final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  chatActionUploadingVideo();

  explicit chatActionUploadingVideo(int32 progress_);

  static const std::int32_t ID = 1234185270;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionRecordingVoiceNote final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionRecordingVoiceNote();

  static const std::int32_t ID = -808850058;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionUploadingVoiceNote final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  chatActionUploadingVoiceNote();

  explicit chatActionUploadingVoiceNote(int32 progress_);

  static const std::int32_t ID = -613643666;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionUploadingPhoto final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  chatActionUploadingPhoto();

  explicit chatActionUploadingPhoto(int32 progress_);

  static const std::int32_t ID = 654240583;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionUploadingDocument final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  chatActionUploadingDocument();

  explicit chatActionUploadingDocument(int32 progress_);

  static const std::int32_t ID = 167884362;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionChoosingSticker final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionChoosingSticker();

  static const std::int32_t ID = 372753697;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionChoosingLocation final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionChoosingLocation();

  static const std::int32_t ID = -2017893596;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionChoosingContact final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionChoosingContact();

  static const std::int32_t ID = -1222507496;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionStartPlayingGame final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionStartPlayingGame();

  static const std::int32_t ID = -865884164;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionRecordingVideoNote final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionRecordingVideoNote();

  static const std::int32_t ID = 16523393;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionUploadingVideoNote final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 progress_;

  chatActionUploadingVideoNote();

  explicit chatActionUploadingVideoNote(int32 progress_);

  static const std::int32_t ID = 1172364918;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionWatchingAnimations final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoji_;

  chatActionWatchingAnimations();

  explicit chatActionWatchingAnimations(string const &emoji_);

  static const std::int32_t ID = 2052990641;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionCancel final : public ChatAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionCancel();

  static const std::int32_t ID = 1160523958;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class accountInfo;

class ChatActionBar: public Object {
 public:
};

class chatActionBarReportSpam final : public ChatActionBar {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool can_unarchive_;

  chatActionBarReportSpam();

  explicit chatActionBarReportSpam(bool can_unarchive_);

  static const std::int32_t ID = -1312758246;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionBarInviteMembers final : public ChatActionBar {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionBarInviteMembers();

  static const std::int32_t ID = 1985313904;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionBarReportAddBlock final : public ChatActionBar {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool can_unarchive_;
  object_ptr<accountInfo> account_info_;

  chatActionBarReportAddBlock();

  chatActionBarReportAddBlock(bool can_unarchive_, object_ptr<accountInfo> &&account_info_);

  static const std::int32_t ID = -1476817269;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionBarAddContact final : public ChatActionBar {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionBarAddContact();

  static const std::int32_t ID = -733325295;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionBarSharePhoneNumber final : public ChatActionBar {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatActionBarSharePhoneNumber();

  static const std::int32_t ID = 35188697;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActionBarJoinRequest final : public ChatActionBar {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  bool is_channel_;
  int32 request_date_;

  chatActionBarJoinRequest();

  chatActionBarJoinRequest(string const &title_, bool is_channel_, int32 request_date_);

  static const std::int32_t ID = 1037140744;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StoryList;

class storyInfo;

class chatActiveStories final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<StoryList> list_;
  int53 order_;
  int32 max_read_story_id_;
  array<object_ptr<storyInfo>> stories_;

  chatActiveStories();

  chatActiveStories(int53 chat_id_, object_ptr<StoryList> &&list_, int53 order_, int32 max_read_story_id_, array<object_ptr<storyInfo>> &&stories_);

  static const std::int32_t ID = -1398869529;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAdministrator final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string custom_title_;
  bool is_owner_;

  chatAdministrator();

  chatAdministrator(int53 user_id_, string const &custom_title_, bool is_owner_);

  static const std::int32_t ID = 1920449836;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAdministratorRights final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool can_manage_chat_;
  bool can_change_info_;
  bool can_post_messages_;
  bool can_edit_messages_;
  bool can_delete_messages_;
  bool can_invite_users_;
  bool can_restrict_members_;
  bool can_pin_messages_;
  bool can_manage_topics_;
  bool can_promote_members_;
  bool can_manage_video_chats_;
  bool can_post_stories_;
  bool can_edit_stories_;
  bool can_delete_stories_;
  bool is_anonymous_;

  chatAdministratorRights();

  chatAdministratorRights(bool can_manage_chat_, bool can_change_info_, bool can_post_messages_, bool can_edit_messages_, bool can_delete_messages_, bool can_invite_users_, bool can_restrict_members_, bool can_pin_messages_, bool can_manage_topics_, bool can_promote_members_, bool can_manage_video_chats_, bool can_post_stories_, bool can_edit_stories_, bool can_delete_stories_, bool is_anonymous_);

  static const std::int32_t ID = 1599049796;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAdministrator;

class chatAdministrators final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatAdministrator>> administrators_;

  chatAdministrators();

  explicit chatAdministrators(array<object_ptr<chatAdministrator>> &&administrators_);

  static const std::int32_t ID = -2126186435;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType;

class ChatAvailableReactions: public Object {
 public:
};

class chatAvailableReactionsAll final : public ChatAvailableReactions {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 max_reaction_count_;

  chatAvailableReactionsAll();

  explicit chatAvailableReactionsAll(int32 max_reaction_count_);

  static const std::int32_t ID = 694160279;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAvailableReactionsSome final : public ChatAvailableReactions {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<ReactionType>> reactions_;
  int32 max_reaction_count_;

  chatAvailableReactionsSome();

  chatAvailableReactionsSome(array<object_ptr<ReactionType>> &&reactions_, int32 max_reaction_count_);

  static const std::int32_t ID = 152513153;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class background;

class chatBackground final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<background> background_;
  int32 dark_theme_dimming_;

  chatBackground();

  chatBackground(object_ptr<background> &&background_, int32 dark_theme_dimming_);

  static const std::int32_t ID = 1653152104;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatBoostSource;

class chatBoost final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  int32 count_;
  object_ptr<ChatBoostSource> source_;
  int32 start_date_;
  int32 expiration_date_;

  chatBoost();

  chatBoost(string const &id_, int32 count_, object_ptr<ChatBoostSource> &&source_, int32 start_date_, int32 expiration_date_);

  static const std::int32_t ID = -1765815118;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostLevelFeatures;

class chatBoostFeatures final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatBoostLevelFeatures>> features_;
  int32 min_profile_background_custom_emoji_boost_level_;
  int32 min_background_custom_emoji_boost_level_;
  int32 min_emoji_status_boost_level_;
  int32 min_chat_theme_background_boost_level_;
  int32 min_custom_background_boost_level_;
  int32 min_custom_emoji_sticker_set_boost_level_;
  int32 min_automatic_translation_boost_level_;
  int32 min_speech_recognition_boost_level_;
  int32 min_sponsored_message_disable_boost_level_;

  chatBoostFeatures();

  chatBoostFeatures(array<object_ptr<chatBoostLevelFeatures>> &&features_, int32 min_profile_background_custom_emoji_boost_level_, int32 min_background_custom_emoji_boost_level_, int32 min_emoji_status_boost_level_, int32 min_chat_theme_background_boost_level_, int32 min_custom_background_boost_level_, int32 min_custom_emoji_sticker_set_boost_level_, int32 min_automatic_translation_boost_level_, int32 min_speech_recognition_boost_level_, int32 min_sponsored_message_disable_boost_level_);

  static const std::int32_t ID = -940531367;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostLevelFeatures final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 level_;
  int32 story_per_day_count_;
  int32 custom_emoji_reaction_count_;
  int32 title_color_count_;
  int32 profile_accent_color_count_;
  bool can_set_profile_background_custom_emoji_;
  int32 accent_color_count_;
  bool can_set_background_custom_emoji_;
  bool can_set_emoji_status_;
  int32 chat_theme_background_count_;
  bool can_set_custom_background_;
  bool can_set_custom_emoji_sticker_set_;
  bool can_enable_automatic_translation_;
  bool can_recognize_speech_;
  bool can_disable_sponsored_messages_;

  chatBoostLevelFeatures();

  chatBoostLevelFeatures(int32 level_, int32 story_per_day_count_, int32 custom_emoji_reaction_count_, int32 title_color_count_, int32 profile_accent_color_count_, bool can_set_profile_background_custom_emoji_, int32 accent_color_count_, bool can_set_background_custom_emoji_, bool can_set_emoji_status_, int32 chat_theme_background_count_, bool can_set_custom_background_, bool can_set_custom_emoji_sticker_set_, bool can_enable_automatic_translation_, bool can_recognize_speech_, bool can_disable_sponsored_messages_);

  static const std::int32_t ID = 975439470;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;
  bool is_public_;

  chatBoostLink();

  chatBoostLink(string const &link_, bool is_public_);

  static const std::int32_t ID = -1253999503;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostLinkInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_public_;
  int53 chat_id_;

  chatBoostLinkInfo();

  chatBoostLinkInfo(bool is_public_, int53 chat_id_);

  static const std::int32_t ID = -602785660;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostSlot final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 slot_id_;
  int53 currently_boosted_chat_id_;
  int32 start_date_;
  int32 expiration_date_;
  int32 cooldown_until_date_;

  chatBoostSlot();

  chatBoostSlot(int32 slot_id_, int53 currently_boosted_chat_id_, int32 start_date_, int32 expiration_date_, int32 cooldown_until_date_);

  static const std::int32_t ID = 123206343;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostSlot;

class chatBoostSlots final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatBoostSlot>> slots_;

  chatBoostSlots();

  explicit chatBoostSlots(array<object_ptr<chatBoostSlot>> &&slots_);

  static const std::int32_t ID = 1014966293;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatBoostSource: public Object {
 public:
};

class chatBoostSourceGiftCode final : public ChatBoostSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string gift_code_;

  chatBoostSourceGiftCode();

  chatBoostSourceGiftCode(int53 user_id_, string const &gift_code_);

  static const std::int32_t ID = -98299206;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostSourceGiveaway final : public ChatBoostSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string gift_code_;
  int53 star_count_;
  int53 giveaway_message_id_;
  bool is_unclaimed_;

  chatBoostSourceGiveaway();

  chatBoostSourceGiveaway(int53 user_id_, string const &gift_code_, int53 star_count_, int53 giveaway_message_id_, bool is_unclaimed_);

  static const std::int32_t ID = 1918145690;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostSourcePremium final : public ChatBoostSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  chatBoostSourcePremium();

  explicit chatBoostSourcePremium(int53 user_id_);

  static const std::int32_t ID = 972011;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class prepaidGiveaway;

class chatBoostStatus final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string boost_url_;
  array<int32> applied_slot_ids_;
  int32 level_;
  int32 gift_code_boost_count_;
  int32 boost_count_;
  int32 current_level_boost_count_;
  int32 next_level_boost_count_;
  int32 premium_member_count_;
  double premium_member_percentage_;
  array<object_ptr<prepaidGiveaway>> prepaid_giveaways_;

  chatBoostStatus();

  chatBoostStatus(string const &boost_url_, array<int32> &&applied_slot_ids_, int32 level_, int32 gift_code_boost_count_, int32 boost_count_, int32 current_level_boost_count_, int32 next_level_boost_count_, int32 premium_member_count_, double premium_member_percentage_, array<object_ptr<prepaidGiveaway>> &&prepaid_giveaways_);

  static const std::int32_t ID = -1050332618;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatEventAction;

class MessageSender;

class chatEvent final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 date_;
  object_ptr<MessageSender> member_id_;
  object_ptr<ChatEventAction> action_;

  chatEvent();

  chatEvent(int64 id_, int32 date_, object_ptr<MessageSender> &&member_id_, object_ptr<ChatEventAction> &&action_);

  static const std::int32_t ID = -652102704;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatAvailableReactions;

class ChatMemberStatus;

class MessageSender;

class chatBackground;

class chatInviteLink;

class chatLocation;

class chatPermissions;

class chatPhoto;

class emojiStatus;

class forumTopicInfo;

class message;

class ChatEventAction: public Object {
 public:
};

class chatEventMessageEdited final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> old_message_;
  object_ptr<message> new_message_;

  chatEventMessageEdited();

  chatEventMessageEdited(object_ptr<message> &&old_message_, object_ptr<message> &&new_message_);

  static const std::int32_t ID = -430967304;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMessageDeleted final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;
  bool can_report_anti_spam_false_positive_;

  chatEventMessageDeleted();

  chatEventMessageDeleted(object_ptr<message> &&message_, bool can_report_anti_spam_false_positive_);

  static const std::int32_t ID = 935316851;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMessagePinned final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;

  chatEventMessagePinned();

  explicit chatEventMessagePinned(object_ptr<message> &&message_);

  static const std::int32_t ID = 438742298;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMessageUnpinned final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;

  chatEventMessageUnpinned();

  explicit chatEventMessageUnpinned(object_ptr<message> &&message_);

  static const std::int32_t ID = -376161513;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventPollStopped final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;

  chatEventPollStopped();

  explicit chatEventPollStopped(object_ptr<message> &&message_);

  static const std::int32_t ID = 2009893861;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMemberJoined final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatEventMemberJoined();

  static const std::int32_t ID = -235468508;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMemberJoinedByInviteLink final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatInviteLink> invite_link_;
  bool via_chat_folder_invite_link_;

  chatEventMemberJoinedByInviteLink();

  chatEventMemberJoinedByInviteLink(object_ptr<chatInviteLink> &&invite_link_, bool via_chat_folder_invite_link_);

  static const std::int32_t ID = -1445536390;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMemberJoinedByRequest final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 approver_user_id_;
  object_ptr<chatInviteLink> invite_link_;

  chatEventMemberJoinedByRequest();

  chatEventMemberJoinedByRequest(int53 approver_user_id_, object_ptr<chatInviteLink> &&invite_link_);

  static const std::int32_t ID = -1647804865;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMemberInvited final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<ChatMemberStatus> status_;

  chatEventMemberInvited();

  chatEventMemberInvited(int53 user_id_, object_ptr<ChatMemberStatus> &&status_);

  static const std::int32_t ID = 953663433;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMemberLeft final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatEventMemberLeft();

  static const std::int32_t ID = -948420593;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMemberPromoted final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<ChatMemberStatus> old_status_;
  object_ptr<ChatMemberStatus> new_status_;

  chatEventMemberPromoted();

  chatEventMemberPromoted(int53 user_id_, object_ptr<ChatMemberStatus> &&old_status_, object_ptr<ChatMemberStatus> &&new_status_);

  static const std::int32_t ID = 525297761;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMemberRestricted final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> member_id_;
  object_ptr<ChatMemberStatus> old_status_;
  object_ptr<ChatMemberStatus> new_status_;

  chatEventMemberRestricted();

  chatEventMemberRestricted(object_ptr<MessageSender> &&member_id_, object_ptr<ChatMemberStatus> &&old_status_, object_ptr<ChatMemberStatus> &&new_status_);

  static const std::int32_t ID = 1603608069;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMemberSubscriptionExtended final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<ChatMemberStatus> old_status_;
  object_ptr<ChatMemberStatus> new_status_;

  chatEventMemberSubscriptionExtended();

  chatEventMemberSubscriptionExtended(int53 user_id_, object_ptr<ChatMemberStatus> &&old_status_, object_ptr<ChatMemberStatus> &&new_status_);

  static const std::int32_t ID = -1141198846;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventAvailableReactionsChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatAvailableReactions> old_available_reactions_;
  object_ptr<ChatAvailableReactions> new_available_reactions_;

  chatEventAvailableReactionsChanged();

  chatEventAvailableReactionsChanged(object_ptr<ChatAvailableReactions> &&old_available_reactions_, object_ptr<ChatAvailableReactions> &&new_available_reactions_);

  static const std::int32_t ID = -1749491521;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventBackgroundChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatBackground> old_background_;
  object_ptr<chatBackground> new_background_;

  chatEventBackgroundChanged();

  chatEventBackgroundChanged(object_ptr<chatBackground> &&old_background_, object_ptr<chatBackground> &&new_background_);

  static const std::int32_t ID = -1225953992;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventDescriptionChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string old_description_;
  string new_description_;

  chatEventDescriptionChanged();

  chatEventDescriptionChanged(string const &old_description_, string const &new_description_);

  static const std::int32_t ID = 39112478;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventEmojiStatusChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<emojiStatus> old_emoji_status_;
  object_ptr<emojiStatus> new_emoji_status_;

  chatEventEmojiStatusChanged();

  chatEventEmojiStatusChanged(object_ptr<emojiStatus> &&old_emoji_status_, object_ptr<emojiStatus> &&new_emoji_status_);

  static const std::int32_t ID = -2081850594;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventLinkedChatChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 old_linked_chat_id_;
  int53 new_linked_chat_id_;

  chatEventLinkedChatChanged();

  chatEventLinkedChatChanged(int53 old_linked_chat_id_, int53 new_linked_chat_id_);

  static const std::int32_t ID = 1797419439;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventLocationChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatLocation> old_location_;
  object_ptr<chatLocation> new_location_;

  chatEventLocationChanged();

  chatEventLocationChanged(object_ptr<chatLocation> &&old_location_, object_ptr<chatLocation> &&new_location_);

  static const std::int32_t ID = -405930674;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventMessageAutoDeleteTimeChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 old_message_auto_delete_time_;
  int32 new_message_auto_delete_time_;

  chatEventMessageAutoDeleteTimeChanged();

  chatEventMessageAutoDeleteTimeChanged(int32 old_message_auto_delete_time_, int32 new_message_auto_delete_time_);

  static const std::int32_t ID = 17317668;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventPermissionsChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPermissions> old_permissions_;
  object_ptr<chatPermissions> new_permissions_;

  chatEventPermissionsChanged();

  chatEventPermissionsChanged(object_ptr<chatPermissions> &&old_permissions_, object_ptr<chatPermissions> &&new_permissions_);

  static const std::int32_t ID = -1311557720;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventPhotoChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> old_photo_;
  object_ptr<chatPhoto> new_photo_;

  chatEventPhotoChanged();

  chatEventPhotoChanged(object_ptr<chatPhoto> &&old_photo_, object_ptr<chatPhoto> &&new_photo_);

  static const std::int32_t ID = -811572541;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventSlowModeDelayChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 old_slow_mode_delay_;
  int32 new_slow_mode_delay_;

  chatEventSlowModeDelayChanged();

  chatEventSlowModeDelayChanged(int32 old_slow_mode_delay_, int32 new_slow_mode_delay_);

  static const std::int32_t ID = -1653195765;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventStickerSetChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 old_sticker_set_id_;
  int64 new_sticker_set_id_;

  chatEventStickerSetChanged();

  chatEventStickerSetChanged(int64 old_sticker_set_id_, int64 new_sticker_set_id_);

  static const std::int32_t ID = -1243130481;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventCustomEmojiStickerSetChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 old_sticker_set_id_;
  int64 new_sticker_set_id_;

  chatEventCustomEmojiStickerSetChanged();

  chatEventCustomEmojiStickerSetChanged(int64 old_sticker_set_id_, int64 new_sticker_set_id_);

  static const std::int32_t ID = 118244123;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventTitleChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string old_title_;
  string new_title_;

  chatEventTitleChanged();

  chatEventTitleChanged(string const &old_title_, string const &new_title_);

  static const std::int32_t ID = 1134103250;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventUsernameChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string old_username_;
  string new_username_;

  chatEventUsernameChanged();

  chatEventUsernameChanged(string const &old_username_, string const &new_username_);

  static const std::int32_t ID = 1728558443;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventActiveUsernamesChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> old_usernames_;
  array<string> new_usernames_;

  chatEventActiveUsernamesChanged();

  chatEventActiveUsernamesChanged(array<string> &&old_usernames_, array<string> &&new_usernames_);

  static const std::int32_t ID = -1508790810;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventAccentColorChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 old_accent_color_id_;
  int64 old_background_custom_emoji_id_;
  int32 new_accent_color_id_;
  int64 new_background_custom_emoji_id_;

  chatEventAccentColorChanged();

  chatEventAccentColorChanged(int32 old_accent_color_id_, int64 old_background_custom_emoji_id_, int32 new_accent_color_id_, int64 new_background_custom_emoji_id_);

  static const std::int32_t ID = -427591885;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventProfileAccentColorChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 old_profile_accent_color_id_;
  int64 old_profile_background_custom_emoji_id_;
  int32 new_profile_accent_color_id_;
  int64 new_profile_background_custom_emoji_id_;

  chatEventProfileAccentColorChanged();

  chatEventProfileAccentColorChanged(int32 old_profile_accent_color_id_, int64 old_profile_background_custom_emoji_id_, int32 new_profile_accent_color_id_, int64 new_profile_background_custom_emoji_id_);

  static const std::int32_t ID = -1514612124;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventHasProtectedContentToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool has_protected_content_;

  chatEventHasProtectedContentToggled();

  explicit chatEventHasProtectedContentToggled(bool has_protected_content_);

  static const std::int32_t ID = -184270335;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventInvitesToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool can_invite_users_;

  chatEventInvitesToggled();

  explicit chatEventInvitesToggled(bool can_invite_users_);

  static const std::int32_t ID = -62548373;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventIsAllHistoryAvailableToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_all_history_available_;

  chatEventIsAllHistoryAvailableToggled();

  explicit chatEventIsAllHistoryAvailableToggled(bool is_all_history_available_);

  static const std::int32_t ID = -1599063019;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventHasAggressiveAntiSpamEnabledToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool has_aggressive_anti_spam_enabled_;

  chatEventHasAggressiveAntiSpamEnabledToggled();

  explicit chatEventHasAggressiveAntiSpamEnabledToggled(bool has_aggressive_anti_spam_enabled_);

  static const std::int32_t ID = -125348094;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventSignMessagesToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool sign_messages_;

  chatEventSignMessagesToggled();

  explicit chatEventSignMessagesToggled(bool sign_messages_);

  static const std::int32_t ID = -1313265634;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventShowMessageSenderToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool show_message_sender_;

  chatEventShowMessageSenderToggled();

  explicit chatEventShowMessageSenderToggled(bool show_message_sender_);

  static const std::int32_t ID = -794343453;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventAutomaticTranslationToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool has_automatic_translation_;

  chatEventAutomaticTranslationToggled();

  explicit chatEventAutomaticTranslationToggled(bool has_automatic_translation_);

  static const std::int32_t ID = 194147926;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventInviteLinkEdited final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatInviteLink> old_invite_link_;
  object_ptr<chatInviteLink> new_invite_link_;

  chatEventInviteLinkEdited();

  chatEventInviteLinkEdited(object_ptr<chatInviteLink> &&old_invite_link_, object_ptr<chatInviteLink> &&new_invite_link_);

  static const std::int32_t ID = -460190366;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventInviteLinkRevoked final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatInviteLink> invite_link_;

  chatEventInviteLinkRevoked();

  explicit chatEventInviteLinkRevoked(object_ptr<chatInviteLink> &&invite_link_);

  static const std::int32_t ID = -1579417629;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventInviteLinkDeleted final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatInviteLink> invite_link_;

  chatEventInviteLinkDeleted();

  explicit chatEventInviteLinkDeleted(object_ptr<chatInviteLink> &&invite_link_);

  static const std::int32_t ID = -1394974361;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventVideoChatCreated final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;

  chatEventVideoChatCreated();

  explicit chatEventVideoChatCreated(int32 group_call_id_);

  static const std::int32_t ID = 1822853755;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventVideoChatEnded final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;

  chatEventVideoChatEnded();

  explicit chatEventVideoChatEnded(int32 group_call_id_);

  static const std::int32_t ID = 1630039112;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventVideoChatMuteNewParticipantsToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool mute_new_participants_;

  chatEventVideoChatMuteNewParticipantsToggled();

  explicit chatEventVideoChatMuteNewParticipantsToggled(bool mute_new_participants_);

  static const std::int32_t ID = -126547970;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventVideoChatParticipantIsMutedToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> participant_id_;
  bool is_muted_;

  chatEventVideoChatParticipantIsMutedToggled();

  chatEventVideoChatParticipantIsMutedToggled(object_ptr<MessageSender> &&participant_id_, bool is_muted_);

  static const std::int32_t ID = 521165047;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventVideoChatParticipantVolumeLevelChanged final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> participant_id_;
  int32 volume_level_;

  chatEventVideoChatParticipantVolumeLevelChanged();

  chatEventVideoChatParticipantVolumeLevelChanged(object_ptr<MessageSender> &&participant_id_, int32 volume_level_);

  static const std::int32_t ID = 1131385534;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventIsForumToggled final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_forum_;

  chatEventIsForumToggled();

  explicit chatEventIsForumToggled(bool is_forum_);

  static const std::int32_t ID = 1516491033;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventForumTopicCreated final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<forumTopicInfo> topic_info_;

  chatEventForumTopicCreated();

  explicit chatEventForumTopicCreated(object_ptr<forumTopicInfo> &&topic_info_);

  static const std::int32_t ID = 2005269314;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventForumTopicEdited final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<forumTopicInfo> old_topic_info_;
  object_ptr<forumTopicInfo> new_topic_info_;

  chatEventForumTopicEdited();

  chatEventForumTopicEdited(object_ptr<forumTopicInfo> &&old_topic_info_, object_ptr<forumTopicInfo> &&new_topic_info_);

  static const std::int32_t ID = 1624910860;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventForumTopicToggleIsClosed final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<forumTopicInfo> topic_info_;

  chatEventForumTopicToggleIsClosed();

  explicit chatEventForumTopicToggleIsClosed(object_ptr<forumTopicInfo> &&topic_info_);

  static const std::int32_t ID = -962704070;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventForumTopicToggleIsHidden final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<forumTopicInfo> topic_info_;

  chatEventForumTopicToggleIsHidden();

  explicit chatEventForumTopicToggleIsHidden(object_ptr<forumTopicInfo> &&topic_info_);

  static const std::int32_t ID = -1609175250;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventForumTopicDeleted final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<forumTopicInfo> topic_info_;

  chatEventForumTopicDeleted();

  explicit chatEventForumTopicDeleted(object_ptr<forumTopicInfo> &&topic_info_);

  static const std::int32_t ID = -1332795123;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventForumTopicPinned final : public ChatEventAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<forumTopicInfo> old_topic_info_;
  object_ptr<forumTopicInfo> new_topic_info_;

  chatEventForumTopicPinned();

  chatEventForumTopicPinned(object_ptr<forumTopicInfo> &&old_topic_info_, object_ptr<forumTopicInfo> &&new_topic_info_);

  static const std::int32_t ID = 2143626222;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventLogFilters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool message_edits_;
  bool message_deletions_;
  bool message_pins_;
  bool member_joins_;
  bool member_leaves_;
  bool member_invites_;
  bool member_promotions_;
  bool member_restrictions_;
  bool info_changes_;
  bool setting_changes_;
  bool invite_link_changes_;
  bool video_chat_changes_;
  bool forum_changes_;
  bool subscription_extensions_;

  chatEventLogFilters();

  chatEventLogFilters(bool message_edits_, bool message_deletions_, bool message_pins_, bool member_joins_, bool member_leaves_, bool member_invites_, bool member_promotions_, bool member_restrictions_, bool info_changes_, bool setting_changes_, bool invite_link_changes_, bool video_chat_changes_, bool forum_changes_, bool subscription_extensions_);

  static const std::int32_t ID = -1032965711;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEvent;

class chatEvents final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatEvent>> events_;

  chatEvents();

  explicit chatEvents(array<object_ptr<chatEvent>> &&events_);

  static const std::int32_t ID = -585329664;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderIcon;

class chatFolderName;

class chatFolder final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatFolderName> name_;
  object_ptr<chatFolderIcon> icon_;
  int32 color_id_;
  bool is_shareable_;
  array<int53> pinned_chat_ids_;
  array<int53> included_chat_ids_;
  array<int53> excluded_chat_ids_;
  bool exclude_muted_;
  bool exclude_read_;
  bool exclude_archived_;
  bool include_contacts_;
  bool include_non_contacts_;
  bool include_bots_;
  bool include_groups_;
  bool include_channels_;

  chatFolder();

  chatFolder(object_ptr<chatFolderName> &&name_, object_ptr<chatFolderIcon> &&icon_, int32 color_id_, bool is_shareable_, array<int53> &&pinned_chat_ids_, array<int53> &&included_chat_ids_, array<int53> &&excluded_chat_ids_, bool exclude_muted_, bool exclude_read_, bool exclude_archived_, bool include_contacts_, bool include_non_contacts_, bool include_bots_, bool include_groups_, bool include_channels_);

  static const std::int32_t ID = 1596164696;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderIcon final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  chatFolderIcon();

  explicit chatFolderIcon(string const &name_);

  static const std::int32_t ID = -146104090;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderIcon;

class chatFolderName;

class chatFolderInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  object_ptr<chatFolderName> name_;
  object_ptr<chatFolderIcon> icon_;
  int32 color_id_;
  bool is_shareable_;
  bool has_my_invite_links_;

  chatFolderInfo();

  chatFolderInfo(int32 id_, object_ptr<chatFolderName> &&name_, object_ptr<chatFolderIcon> &&icon_, int32 color_id_, bool is_shareable_, bool has_my_invite_links_);

  static const std::int32_t ID = 815535117;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderInviteLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;
  string name_;
  array<int53> chat_ids_;

  chatFolderInviteLink();

  chatFolderInviteLink(string const &invite_link_, string const &name_, array<int53> &&chat_ids_);

  static const std::int32_t ID = 493969661;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderInfo;

class chatFolderInviteLinkInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatFolderInfo> chat_folder_info_;
  array<int53> missing_chat_ids_;
  array<int53> added_chat_ids_;

  chatFolderInviteLinkInfo();

  chatFolderInviteLinkInfo(object_ptr<chatFolderInfo> &&chat_folder_info_, array<int53> &&missing_chat_ids_, array<int53> &&added_chat_ids_);

  static const std::int32_t ID = 1119450395;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderInviteLink;

class chatFolderInviteLinks final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatFolderInviteLink>> invite_links_;

  chatFolderInviteLinks();

  explicit chatFolderInviteLinks(array<object_ptr<chatFolderInviteLink>> &&invite_links_);

  static const std::int32_t ID = 1853351525;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class chatFolderName final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  bool animate_custom_emoji_;

  chatFolderName();

  chatFolderName(object_ptr<formattedText> &&text_, bool animate_custom_emoji_);

  static const std::int32_t ID = -330482274;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starSubscriptionPricing;

class chatInviteLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;
  string name_;
  int53 creator_user_id_;
  int32 date_;
  int32 edit_date_;
  int32 expiration_date_;
  object_ptr<starSubscriptionPricing> subscription_pricing_;
  int32 member_limit_;
  int32 member_count_;
  int32 expired_member_count_;
  int32 pending_join_request_count_;
  bool creates_join_request_;
  bool is_primary_;
  bool is_revoked_;

  chatInviteLink();

  chatInviteLink(string const &invite_link_, string const &name_, int53 creator_user_id_, int32 date_, int32 edit_date_, int32 expiration_date_, object_ptr<starSubscriptionPricing> &&subscription_pricing_, int32 member_limit_, int32 member_count_, int32 expired_member_count_, int32 pending_join_request_count_, bool creates_join_request_, bool is_primary_, bool is_revoked_);

  static const std::int32_t ID = -957651664;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLinkCount final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 invite_link_count_;
  int32 revoked_invite_link_count_;

  chatInviteLinkCount();

  chatInviteLinkCount(int53 user_id_, int32 invite_link_count_, int32 revoked_invite_link_count_);

  static const std::int32_t ID = -1021999210;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLinkCount;

class chatInviteLinkCounts final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatInviteLinkCount>> invite_link_counts_;

  chatInviteLinkCounts();

  explicit chatInviteLinkCounts(array<object_ptr<chatInviteLinkCount>> &&invite_link_counts_);

  static const std::int32_t ID = 920326637;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InviteLinkChatType;

class chatInviteLinkSubscriptionInfo;

class chatPhotoInfo;

class verificationStatus;

class chatInviteLinkInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 accessible_for_;
  object_ptr<InviteLinkChatType> type_;
  string title_;
  object_ptr<chatPhotoInfo> photo_;
  int32 accent_color_id_;
  string description_;
  int32 member_count_;
  array<int53> member_user_ids_;
  object_ptr<chatInviteLinkSubscriptionInfo> subscription_info_;
  bool creates_join_request_;
  bool is_public_;
  object_ptr<verificationStatus> verification_status_;

  chatInviteLinkInfo();

  chatInviteLinkInfo(int53 chat_id_, int32 accessible_for_, object_ptr<InviteLinkChatType> &&type_, string const &title_, object_ptr<chatPhotoInfo> &&photo_, int32 accent_color_id_, string const &description_, int32 member_count_, array<int53> &&member_user_ids_, object_ptr<chatInviteLinkSubscriptionInfo> &&subscription_info_, bool creates_join_request_, bool is_public_, object_ptr<verificationStatus> &&verification_status_);

  static const std::int32_t ID = -1145310535;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLinkMember final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 joined_chat_date_;
  bool via_chat_folder_invite_link_;
  int53 approver_user_id_;

  chatInviteLinkMember();

  chatInviteLinkMember(int53 user_id_, int32 joined_chat_date_, bool via_chat_folder_invite_link_, int53 approver_user_id_);

  static const std::int32_t ID = 29156795;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLinkMember;

class chatInviteLinkMembers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<chatInviteLinkMember>> members_;

  chatInviteLinkMembers();

  chatInviteLinkMembers(int32 total_count_, array<object_ptr<chatInviteLinkMember>> &&members_);

  static const std::int32_t ID = 315635051;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starSubscriptionPricing;

class chatInviteLinkSubscriptionInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<starSubscriptionPricing> pricing_;
  bool can_reuse_;
  int64 form_id_;

  chatInviteLinkSubscriptionInfo();

  chatInviteLinkSubscriptionInfo(object_ptr<starSubscriptionPricing> &&pricing_, bool can_reuse_, int64 form_id_);

  static const std::int32_t ID = 953119592;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLink;

class chatInviteLinks final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<chatInviteLink>> invite_links_;

  chatInviteLinks();

  chatInviteLinks(int32 total_count_, array<object_ptr<chatInviteLink>> &&invite_links_);

  static const std::int32_t ID = 112891427;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatJoinRequest final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 date_;
  string bio_;

  chatJoinRequest();

  chatJoinRequest(int53 user_id_, int32 date_, string const &bio_);

  static const std::int32_t ID = 59341416;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatJoinRequest;

class chatJoinRequests final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<chatJoinRequest>> requests_;

  chatJoinRequests();

  chatJoinRequests(int32 total_count_, array<object_ptr<chatJoinRequest>> &&requests_);

  static const std::int32_t ID = 1291680519;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatJoinRequestsInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<int53> user_ids_;

  chatJoinRequestsInfo();

  chatJoinRequestsInfo(int32 total_count_, array<int53> &&user_ids_);

  static const std::int32_t ID = 888534463;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatList: public Object {
 public:
};

class chatListMain final : public ChatList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatListMain();

  static const std::int32_t ID = -400991316;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatListArchive final : public ChatList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatListArchive();

  static const std::int32_t ID = 362770115;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatListFolder final : public ChatList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;

  chatListFolder();

  explicit chatListFolder(int32 chat_folder_id_);

  static const std::int32_t ID = 385760856;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatList;

class chatLists final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<ChatList>> chat_lists_;

  chatLists();

  explicit chatLists(array<object_ptr<ChatList>> &&chat_lists_);

  static const std::int32_t ID = -258292771;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class location;

class chatLocation final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;
  string address_;

  chatLocation();

  chatLocation(object_ptr<location> &&location_, string const &address_);

  static const std::int32_t ID = -1566863583;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatMemberStatus;

class MessageSender;

class chatMember final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> member_id_;
  int53 inviter_user_id_;
  int32 joined_chat_date_;
  object_ptr<ChatMemberStatus> status_;

  chatMember();

  chatMember(object_ptr<MessageSender> &&member_id_, int53 inviter_user_id_, int32 joined_chat_date_, object_ptr<ChatMemberStatus> &&status_);

  static const std::int32_t ID = 1829953909;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAdministratorRights;

class chatPermissions;

class ChatMemberStatus: public Object {
 public:
};

class chatMemberStatusCreator final : public ChatMemberStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string custom_title_;
  bool is_anonymous_;
  bool is_member_;

  chatMemberStatusCreator();

  chatMemberStatusCreator(string const &custom_title_, bool is_anonymous_, bool is_member_);

  static const std::int32_t ID = -160019714;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMemberStatusAdministrator final : public ChatMemberStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string custom_title_;
  bool can_be_edited_;
  object_ptr<chatAdministratorRights> rights_;

  chatMemberStatusAdministrator();

  chatMemberStatusAdministrator(string const &custom_title_, bool can_be_edited_, object_ptr<chatAdministratorRights> &&rights_);

  static const std::int32_t ID = -70024163;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMemberStatusMember final : public ChatMemberStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 member_until_date_;

  chatMemberStatusMember();

  explicit chatMemberStatusMember(int32 member_until_date_);

  static const std::int32_t ID = -32707562;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMemberStatusRestricted final : public ChatMemberStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_member_;
  int32 restricted_until_date_;
  object_ptr<chatPermissions> permissions_;

  chatMemberStatusRestricted();

  chatMemberStatusRestricted(bool is_member_, int32 restricted_until_date_, object_ptr<chatPermissions> &&permissions_);

  static const std::int32_t ID = 1661432998;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMemberStatusLeft final : public ChatMemberStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatMemberStatusLeft();

  static const std::int32_t ID = -5815259;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMemberStatusBanned final : public ChatMemberStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 banned_until_date_;

  chatMemberStatusBanned();

  explicit chatMemberStatusBanned(int32 banned_until_date_);

  static const std::int32_t ID = -1653518666;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMember;

class chatMembers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<chatMember>> members_;

  chatMembers();

  chatMembers(int32 total_count_, array<object_ptr<chatMember>> &&members_);

  static const std::int32_t ID = -497558622;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatMembersFilter: public Object {
 public:
};

class chatMembersFilterContacts final : public ChatMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatMembersFilterContacts();

  static const std::int32_t ID = 1774485671;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMembersFilterAdministrators final : public ChatMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatMembersFilterAdministrators();

  static const std::int32_t ID = -1266893796;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMembersFilterMembers final : public ChatMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatMembersFilterMembers();

  static const std::int32_t ID = 670504342;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMembersFilterMention final : public ChatMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 message_thread_id_;

  chatMembersFilterMention();

  explicit chatMembersFilterMention(int53 message_thread_id_);

  static const std::int32_t ID = 856419831;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMembersFilterRestricted final : public ChatMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatMembersFilterRestricted();

  static const std::int32_t ID = 1256282813;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMembersFilterBanned final : public ChatMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatMembersFilterBanned();

  static const std::int32_t ID = -1863102648;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMembersFilterBots final : public ChatMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatMembersFilterBots();

  static const std::int32_t ID = -1422567288;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class chatMessageSender final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> sender_;
  bool needs_premium_;

  chatMessageSender();

  chatMessageSender(object_ptr<MessageSender> &&sender_, bool needs_premium_);

  static const std::int32_t ID = 760590010;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMessageSender;

class chatMessageSenders final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatMessageSender>> senders_;

  chatMessageSenders();

  explicit chatMessageSenders(array<object_ptr<chatMessageSender>> &&senders_);

  static const std::int32_t ID = -1866230970;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatNotificationSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool use_default_mute_for_;
  int32 mute_for_;
  bool use_default_sound_;
  int64 sound_id_;
  bool use_default_show_preview_;
  bool show_preview_;
  bool use_default_mute_stories_;
  bool mute_stories_;
  bool use_default_story_sound_;
  int64 story_sound_id_;
  bool use_default_show_story_poster_;
  bool show_story_poster_;
  bool use_default_disable_pinned_message_notifications_;
  bool disable_pinned_message_notifications_;
  bool use_default_disable_mention_notifications_;
  bool disable_mention_notifications_;

  chatNotificationSettings();

  chatNotificationSettings(bool use_default_mute_for_, int32 mute_for_, bool use_default_sound_, int64 sound_id_, bool use_default_show_preview_, bool show_preview_, bool use_default_mute_stories_, bool mute_stories_, bool use_default_story_sound_, int64 story_sound_id_, bool use_default_show_story_poster_, bool show_story_poster_, bool use_default_disable_pinned_message_notifications_, bool disable_pinned_message_notifications_, bool use_default_disable_mention_notifications_, bool disable_mention_notifications_);

  static const std::int32_t ID = 1459533846;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatPermissions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool can_send_basic_messages_;
  bool can_send_audios_;
  bool can_send_documents_;
  bool can_send_photos_;
  bool can_send_videos_;
  bool can_send_video_notes_;
  bool can_send_voice_notes_;
  bool can_send_polls_;
  bool can_send_other_messages_;
  bool can_add_link_previews_;
  bool can_change_info_;
  bool can_invite_users_;
  bool can_pin_messages_;
  bool can_create_topics_;

  chatPermissions();

  chatPermissions(bool can_send_basic_messages_, bool can_send_audios_, bool can_send_documents_, bool can_send_photos_, bool can_send_videos_, bool can_send_video_notes_, bool can_send_voice_notes_, bool can_send_polls_, bool can_send_other_messages_, bool can_add_link_previews_, bool can_change_info_, bool can_invite_users_, bool can_pin_messages_, bool can_create_topics_);

  static const std::int32_t ID = -118334855;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class animatedChatPhoto;

class chatPhotoSticker;

class minithumbnail;

class photoSize;

class chatPhoto final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 added_date_;
  object_ptr<minithumbnail> minithumbnail_;
  array<object_ptr<photoSize>> sizes_;
  object_ptr<animatedChatPhoto> animation_;
  object_ptr<animatedChatPhoto> small_animation_;
  object_ptr<chatPhotoSticker> sticker_;

  chatPhoto();

  chatPhoto(int64 id_, int32 added_date_, object_ptr<minithumbnail> &&minithumbnail_, array<object_ptr<photoSize>> &&sizes_, object_ptr<animatedChatPhoto> &&animation_, object_ptr<animatedChatPhoto> &&small_animation_, object_ptr<chatPhotoSticker> &&sticker_);

  static const std::int32_t ID = -1430870201;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class minithumbnail;

class chatPhotoInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<file> small_;
  object_ptr<file> big_;
  object_ptr<minithumbnail> minithumbnail_;
  bool has_animation_;
  bool is_personal_;

  chatPhotoInfo();

  chatPhotoInfo(object_ptr<file> &&small_, object_ptr<file> &&big_, object_ptr<minithumbnail> &&minithumbnail_, bool has_animation_, bool is_personal_);

  static const std::int32_t ID = 281195686;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BackgroundFill;

class ChatPhotoStickerType;

class chatPhotoSticker final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatPhotoStickerType> type_;
  object_ptr<BackgroundFill> background_fill_;

  chatPhotoSticker();

  chatPhotoSticker(object_ptr<ChatPhotoStickerType> &&type_, object_ptr<BackgroundFill> &&background_fill_);

  static const std::int32_t ID = -1459387485;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatPhotoStickerType: public Object {
 public:
};

class chatPhotoStickerTypeRegularOrMask final : public ChatPhotoStickerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 sticker_set_id_;
  int64 sticker_id_;

  chatPhotoStickerTypeRegularOrMask();

  chatPhotoStickerTypeRegularOrMask(int64 sticker_set_id_, int64 sticker_id_);

  static const std::int32_t ID = -415147620;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatPhotoStickerTypeCustomEmoji final : public ChatPhotoStickerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 custom_emoji_id_;

  chatPhotoStickerTypeCustomEmoji();

  explicit chatPhotoStickerTypeCustomEmoji(int64 custom_emoji_id_);

  static const std::int32_t ID = -266224943;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatPhoto;

class chatPhotos final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<chatPhoto>> photos_;

  chatPhotos();

  chatPhotos(int32 total_count_, array<object_ptr<chatPhoto>> &&photos_);

  static const std::int32_t ID = -1510699180;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatList;

class ChatSource;

class chatPosition final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatList> list_;
  int64 order_;
  bool is_pinned_;
  object_ptr<ChatSource> source_;

  chatPosition();

  chatPosition(object_ptr<ChatList> &&list_, int64 order_, bool is_pinned_, object_ptr<ChatSource> &&source_);

  static const std::int32_t ID = -622557355;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatRevenueAmount final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string cryptocurrency_;
  int64 total_amount_;
  int64 balance_amount_;
  int64 available_amount_;
  bool withdrawal_enabled_;

  chatRevenueAmount();

  chatRevenueAmount(string const &cryptocurrency_, int64 total_amount_, int64 balance_amount_, int64 available_amount_, bool withdrawal_enabled_);

  static const std::int32_t ID = -1505178024;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatisticalGraph;

class chatRevenueAmount;

class chatRevenueStatistics final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StatisticalGraph> revenue_by_hour_graph_;
  object_ptr<StatisticalGraph> revenue_graph_;
  object_ptr<chatRevenueAmount> revenue_amount_;
  double usd_rate_;

  chatRevenueStatistics();

  chatRevenueStatistics(object_ptr<StatisticalGraph> &&revenue_by_hour_graph_, object_ptr<StatisticalGraph> &&revenue_graph_, object_ptr<chatRevenueAmount> &&revenue_amount_, double usd_rate_);

  static const std::int32_t ID = 1667438779;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatRevenueTransactionType;

class chatRevenueTransaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string cryptocurrency_;
  int64 cryptocurrency_amount_;
  object_ptr<ChatRevenueTransactionType> type_;

  chatRevenueTransaction();

  chatRevenueTransaction(string const &cryptocurrency_, int64 cryptocurrency_amount_, object_ptr<ChatRevenueTransactionType> &&type_);

  static const std::int32_t ID = 80192767;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class RevenueWithdrawalState;

class ChatRevenueTransactionType: public Object {
 public:
};

class chatRevenueTransactionTypeEarnings final : public ChatRevenueTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 start_date_;
  int32 end_date_;

  chatRevenueTransactionTypeEarnings();

  chatRevenueTransactionTypeEarnings(int32 start_date_, int32 end_date_);

  static const std::int32_t ID = -400776056;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatRevenueTransactionTypeWithdrawal final : public ChatRevenueTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 withdrawal_date_;
  string provider_;
  object_ptr<RevenueWithdrawalState> state_;

  chatRevenueTransactionTypeWithdrawal();

  chatRevenueTransactionTypeWithdrawal(int32 withdrawal_date_, string const &provider_, object_ptr<RevenueWithdrawalState> &&state_);

  static const std::int32_t ID = 252939755;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatRevenueTransactionTypeRefund final : public ChatRevenueTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 refund_date_;
  string provider_;

  chatRevenueTransactionTypeRefund();

  chatRevenueTransactionTypeRefund(int32 refund_date_, string const &provider_);

  static const std::int32_t ID = 302430279;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatRevenueTransaction;

class chatRevenueTransactions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<chatRevenueTransaction>> transactions_;

  chatRevenueTransactions();

  chatRevenueTransactions(int32 total_count_, array<object_ptr<chatRevenueTransaction>> &&transactions_);

  static const std::int32_t ID = -553258171;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatSource: public Object {
 public:
};

class chatSourceMtprotoProxy final : public ChatSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  chatSourceMtprotoProxy();

  static const std::int32_t ID = 394074115;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatSourcePublicServiceAnnouncement final : public ChatSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string type_;
  string text_;

  chatSourcePublicServiceAnnouncement();

  chatSourcePublicServiceAnnouncement(string const &type_, string const &text_);

  static const std::int32_t ID = -328571244;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatisticalGraph;

class chatStatisticsAdministratorActionsInfo;

class chatStatisticsInteractionInfo;

class chatStatisticsInviterInfo;

class chatStatisticsMessageSenderInfo;

class dateRange;

class statisticalValue;

class ChatStatistics: public Object {
 public:
};

class chatStatisticsSupergroup final : public ChatStatistics {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<dateRange> period_;
  object_ptr<statisticalValue> member_count_;
  object_ptr<statisticalValue> message_count_;
  object_ptr<statisticalValue> viewer_count_;
  object_ptr<statisticalValue> sender_count_;
  object_ptr<StatisticalGraph> member_count_graph_;
  object_ptr<StatisticalGraph> join_graph_;
  object_ptr<StatisticalGraph> join_by_source_graph_;
  object_ptr<StatisticalGraph> language_graph_;
  object_ptr<StatisticalGraph> message_content_graph_;
  object_ptr<StatisticalGraph> action_graph_;
  object_ptr<StatisticalGraph> day_graph_;
  object_ptr<StatisticalGraph> week_graph_;
  array<object_ptr<chatStatisticsMessageSenderInfo>> top_senders_;
  array<object_ptr<chatStatisticsAdministratorActionsInfo>> top_administrators_;
  array<object_ptr<chatStatisticsInviterInfo>> top_inviters_;

  chatStatisticsSupergroup();

  chatStatisticsSupergroup(object_ptr<dateRange> &&period_, object_ptr<statisticalValue> &&member_count_, object_ptr<statisticalValue> &&message_count_, object_ptr<statisticalValue> &&viewer_count_, object_ptr<statisticalValue> &&sender_count_, object_ptr<StatisticalGraph> &&member_count_graph_, object_ptr<StatisticalGraph> &&join_graph_, object_ptr<StatisticalGraph> &&join_by_source_graph_, object_ptr<StatisticalGraph> &&language_graph_, object_ptr<StatisticalGraph> &&message_content_graph_, object_ptr<StatisticalGraph> &&action_graph_, object_ptr<StatisticalGraph> &&day_graph_, object_ptr<StatisticalGraph> &&week_graph_, array<object_ptr<chatStatisticsMessageSenderInfo>> &&top_senders_, array<object_ptr<chatStatisticsAdministratorActionsInfo>> &&top_administrators_, array<object_ptr<chatStatisticsInviterInfo>> &&top_inviters_);

  static const std::int32_t ID = -17244633;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatStatisticsChannel final : public ChatStatistics {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<dateRange> period_;
  object_ptr<statisticalValue> member_count_;
  object_ptr<statisticalValue> mean_message_view_count_;
  object_ptr<statisticalValue> mean_message_share_count_;
  object_ptr<statisticalValue> mean_message_reaction_count_;
  object_ptr<statisticalValue> mean_story_view_count_;
  object_ptr<statisticalValue> mean_story_share_count_;
  object_ptr<statisticalValue> mean_story_reaction_count_;
  double enabled_notifications_percentage_;
  object_ptr<StatisticalGraph> member_count_graph_;
  object_ptr<StatisticalGraph> join_graph_;
  object_ptr<StatisticalGraph> mute_graph_;
  object_ptr<StatisticalGraph> view_count_by_hour_graph_;
  object_ptr<StatisticalGraph> view_count_by_source_graph_;
  object_ptr<StatisticalGraph> join_by_source_graph_;
  object_ptr<StatisticalGraph> language_graph_;
  object_ptr<StatisticalGraph> message_interaction_graph_;
  object_ptr<StatisticalGraph> message_reaction_graph_;
  object_ptr<StatisticalGraph> story_interaction_graph_;
  object_ptr<StatisticalGraph> story_reaction_graph_;
  object_ptr<StatisticalGraph> instant_view_interaction_graph_;
  array<object_ptr<chatStatisticsInteractionInfo>> recent_interactions_;

  chatStatisticsChannel();

  chatStatisticsChannel(object_ptr<dateRange> &&period_, object_ptr<statisticalValue> &&member_count_, object_ptr<statisticalValue> &&mean_message_view_count_, object_ptr<statisticalValue> &&mean_message_share_count_, object_ptr<statisticalValue> &&mean_message_reaction_count_, object_ptr<statisticalValue> &&mean_story_view_count_, object_ptr<statisticalValue> &&mean_story_share_count_, object_ptr<statisticalValue> &&mean_story_reaction_count_, double enabled_notifications_percentage_, object_ptr<StatisticalGraph> &&member_count_graph_, object_ptr<StatisticalGraph> &&join_graph_, object_ptr<StatisticalGraph> &&mute_graph_, object_ptr<StatisticalGraph> &&view_count_by_hour_graph_, object_ptr<StatisticalGraph> &&view_count_by_source_graph_, object_ptr<StatisticalGraph> &&join_by_source_graph_, object_ptr<StatisticalGraph> &&language_graph_, object_ptr<StatisticalGraph> &&message_interaction_graph_, object_ptr<StatisticalGraph> &&message_reaction_graph_, object_ptr<StatisticalGraph> &&story_interaction_graph_, object_ptr<StatisticalGraph> &&story_reaction_graph_, object_ptr<StatisticalGraph> &&instant_view_interaction_graph_, array<object_ptr<chatStatisticsInteractionInfo>> &&recent_interactions_);

  static const std::int32_t ID = -1375151660;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatStatisticsAdministratorActionsInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 deleted_message_count_;
  int32 banned_user_count_;
  int32 restricted_user_count_;

  chatStatisticsAdministratorActionsInfo();

  chatStatisticsAdministratorActionsInfo(int53 user_id_, int32 deleted_message_count_, int32 banned_user_count_, int32 restricted_user_count_);

  static const std::int32_t ID = -406467202;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatStatisticsObjectType;

class chatStatisticsInteractionInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatStatisticsObjectType> object_type_;
  int32 view_count_;
  int32 forward_count_;
  int32 reaction_count_;

  chatStatisticsInteractionInfo();

  chatStatisticsInteractionInfo(object_ptr<ChatStatisticsObjectType> &&object_type_, int32 view_count_, int32 forward_count_, int32 reaction_count_);

  static const std::int32_t ID = 1766496909;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatStatisticsInviterInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 added_member_count_;

  chatStatisticsInviterInfo();

  chatStatisticsInviterInfo(int53 user_id_, int32 added_member_count_);

  static const std::int32_t ID = 629396619;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatStatisticsMessageSenderInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 sent_message_count_;
  int32 average_character_count_;

  chatStatisticsMessageSenderInfo();

  chatStatisticsMessageSenderInfo(int53 user_id_, int32 sent_message_count_, int32 average_character_count_);

  static const std::int32_t ID = 1762295371;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatStatisticsObjectType: public Object {
 public:
};

class chatStatisticsObjectTypeMessage final : public ChatStatisticsObjectType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 message_id_;

  chatStatisticsObjectTypeMessage();

  explicit chatStatisticsObjectTypeMessage(int53 message_id_);

  static const std::int32_t ID = 1872700662;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatStatisticsObjectTypeStory final : public ChatStatisticsObjectType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 story_id_;

  chatStatisticsObjectTypeStory();

  explicit chatStatisticsObjectTypeStory(int32 story_id_);

  static const std::int32_t ID = 364575152;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class themeSettings;

class chatTheme final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<themeSettings> light_settings_;
  object_ptr<themeSettings> dark_settings_;

  chatTheme();

  chatTheme(string const &name_, object_ptr<themeSettings> &&light_settings_, object_ptr<themeSettings> &&dark_settings_);

  static const std::int32_t ID = -113218503;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatType: public Object {
 public:
};

class chatTypePrivate final : public ChatType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  chatTypePrivate();

  explicit chatTypePrivate(int53 user_id_);

  static const std::int32_t ID = 1579049844;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatTypeBasicGroup final : public ChatType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 basic_group_id_;

  chatTypeBasicGroup();

  explicit chatTypeBasicGroup(int53 basic_group_id_);

  static const std::int32_t ID = 973884508;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatTypeSupergroup final : public ChatType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;
  bool is_channel_;

  chatTypeSupergroup();

  chatTypeSupergroup(int53 supergroup_id_, bool is_channel_);

  static const std::int32_t ID = -1472570774;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatTypeSecret final : public ChatType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 secret_chat_id_;
  int53 user_id_;

  chatTypeSecret();

  chatTypeSecret(int32 secret_chat_id_, int53 user_id_);

  static const std::int32_t ID = 862366513;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<int53> chat_ids_;

  chats();

  chats(int32 total_count_, array<int53> &&chat_ids_);

  static const std::int32_t ID = 1809654812;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CheckChatUsernameResult: public Object {
 public:
};

class checkChatUsernameResultOk final : public CheckChatUsernameResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  checkChatUsernameResultOk();

  static const std::int32_t ID = -1498956964;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class checkChatUsernameResultUsernameInvalid final : public CheckChatUsernameResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  checkChatUsernameResultUsernameInvalid();

  static const std::int32_t ID = -636979370;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class checkChatUsernameResultUsernameOccupied final : public CheckChatUsernameResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  checkChatUsernameResultUsernameOccupied();

  static const std::int32_t ID = 1320892201;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class checkChatUsernameResultUsernamePurchasable final : public CheckChatUsernameResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  checkChatUsernameResultUsernamePurchasable();

  static const std::int32_t ID = 5885529;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class checkChatUsernameResultPublicChatsTooMany final : public CheckChatUsernameResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  checkChatUsernameResultPublicChatsTooMany();

  static const std::int32_t ID = -659264388;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class checkChatUsernameResultPublicGroupsUnavailable final : public CheckChatUsernameResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  checkChatUsernameResultPublicGroupsUnavailable();

  static const std::int32_t ID = -51833641;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CheckStickerSetNameResult: public Object {
 public:
};

class checkStickerSetNameResultOk final : public CheckStickerSetNameResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  checkStickerSetNameResultOk();

  static const std::int32_t ID = -1404308904;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class checkStickerSetNameResultNameInvalid final : public CheckStickerSetNameResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  checkStickerSetNameResultNameInvalid();

  static const std::int32_t ID = 177992244;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class checkStickerSetNameResultNameOccupied final : public CheckStickerSetNameResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  checkStickerSetNameResultNameOccupied();

  static const std::int32_t ID = 1012980872;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class birthdate;

class closeBirthdayUser final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<birthdate> birthdate_;

  closeBirthdayUser();

  closeBirthdayUser(int53 user_id_, object_ptr<birthdate> &&birthdate_);

  static const std::int32_t ID = -2147067410;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class VectorPathCommand;

class closedVectorPath final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<VectorPathCommand>> commands_;

  closedVectorPath();

  explicit closedVectorPath(array<object_ptr<VectorPathCommand>> &&commands_);

  static const std::int32_t ID = 589951657;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class collectibleItemInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 purchase_date_;
  string currency_;
  int53 amount_;
  string cryptocurrency_;
  int64 cryptocurrency_amount_;
  string url_;

  collectibleItemInfo();

  collectibleItemInfo(int32 purchase_date_, string const &currency_, int53 amount_, string const &cryptocurrency_, int64 cryptocurrency_amount_, string const &url_);

  static const std::int32_t ID = 1460640717;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CollectibleItemType: public Object {
 public:
};

class collectibleItemTypeUsername final : public CollectibleItemType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string username_;

  collectibleItemTypeUsername();

  explicit collectibleItemTypeUsername(string const &username_);

  static const std::int32_t ID = 458680273;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class collectibleItemTypePhoneNumber final : public CollectibleItemType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;

  collectibleItemTypePhoneNumber();

  explicit collectibleItemTypePhoneNumber(string const &phone_number_);

  static const std::int32_t ID = 1256251714;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class affiliateProgramParameters;

class connectedAffiliateProgram final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int53 bot_user_id_;
  object_ptr<affiliateProgramParameters> parameters_;
  int32 connection_date_;
  bool is_disconnected_;
  int64 user_count_;
  int64 revenue_star_count_;

  connectedAffiliateProgram();

  connectedAffiliateProgram(string const &url_, int53 bot_user_id_, object_ptr<affiliateProgramParameters> &&parameters_, int32 connection_date_, bool is_disconnected_, int64 user_count_, int64 revenue_star_count_);

  static const std::int32_t ID = 1488942101;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class connectedAffiliateProgram;

class connectedAffiliatePrograms final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<connectedAffiliateProgram>> programs_;
  string next_offset_;

  connectedAffiliatePrograms();

  connectedAffiliatePrograms(int32 total_count_, array<object_ptr<connectedAffiliateProgram>> &&programs_, string const &next_offset_);

  static const std::int32_t ID = 1505880847;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class connectedWebsite final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  string domain_name_;
  int53 bot_user_id_;
  string browser_;
  string platform_;
  int32 log_in_date_;
  int32 last_active_date_;
  string ip_address_;
  string location_;

  connectedWebsite();

  connectedWebsite(int64 id_, string const &domain_name_, int53 bot_user_id_, string const &browser_, string const &platform_, int32 log_in_date_, int32 last_active_date_, string const &ip_address_, string const &location_);

  static const std::int32_t ID = 1978115978;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class connectedWebsite;

class connectedWebsites final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<connectedWebsite>> websites_;

  connectedWebsites();

  explicit connectedWebsites(array<object_ptr<connectedWebsite>> &&websites_);

  static const std::int32_t ID = -1727949694;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ConnectionState: public Object {
 public:
};

class connectionStateWaitingForNetwork final : public ConnectionState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  connectionStateWaitingForNetwork();

  static const std::int32_t ID = 1695405912;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class connectionStateConnectingToProxy final : public ConnectionState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  connectionStateConnectingToProxy();

  static const std::int32_t ID = -93187239;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class connectionStateConnecting final : public ConnectionState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  connectionStateConnecting();

  static const std::int32_t ID = -1298400670;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class connectionStateUpdating final : public ConnectionState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  connectionStateUpdating();

  static const std::int32_t ID = -188104009;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class connectionStateReady final : public ConnectionState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  connectionStateReady();

  static const std::int32_t ID = 48608492;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class contact final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string first_name_;
  string last_name_;
  string vcard_;
  int53 user_id_;

  contact();

  contact(string const &phone_number_, string const &first_name_, string const &last_name_, string const &vcard_, int53 user_id_);

  static const std::int32_t ID = -1993844876;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class count final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 count_;

  count();

  explicit count(int32 count_);

  static const std::int32_t ID = 1295577348;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class countryInfo;

class countries final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<countryInfo>> countries_;

  countries();

  explicit countries(array<object_ptr<countryInfo>> &&countries_);

  static const std::int32_t ID = 1854211813;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class countryInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string country_code_;
  string name_;
  string english_name_;
  bool is_hidden_;
  array<string> calling_codes_;

  countryInfo();

  countryInfo(string const &country_code_, string const &name_, string const &english_name_, bool is_hidden_, array<string> &&calling_codes_);

  static const std::int32_t ID = 1617195722;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class failedToAddMembers;

class createdBasicGroupChat final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<failedToAddMembers> failed_to_add_members_;

  createdBasicGroupChat();

  createdBasicGroupChat(int53 chat_id_, object_ptr<failedToAddMembers> &&failed_to_add_members_);

  static const std::int32_t ID = -20417068;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class currentWeather final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double temperature_;
  string emoji_;

  currentWeather();

  currentWeather(double temperature_, string const &emoji_);

  static const std::int32_t ID = -355555136;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class customRequestResult final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string result_;

  customRequestResult();

  explicit customRequestResult(string const &result_);

  static const std::int32_t ID = -2009960452;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class data final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes data_;

  data();

  explicit data(bytes const &data_);

  static const std::int32_t ID = 221197337;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class databaseStatistics final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string statistics_;

  databaseStatistics();

  explicit databaseStatistics(string const &statistics_);

  static const std::int32_t ID = -1123912880;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class date final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 day_;
  int32 month_;
  int32 year_;

  date();

  date(int32 day_, int32 month_, int32 year_);

  static const std::int32_t ID = -277956960;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class dateRange final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 start_date_;
  int32 end_date_;

  dateRange();

  dateRange(int32 start_date_, int32 end_date_);

  static const std::int32_t ID = 1360333926;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class datedFile final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<file> file_;
  int32 date_;

  datedFile();

  datedFile(object_ptr<file> &&file_, int32 date_);

  static const std::int32_t ID = -1840795491;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class deepLinkInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  bool need_update_application_;

  deepLinkInfo();

  deepLinkInfo(object_ptr<formattedText> &&text_, bool need_update_application_);

  static const std::int32_t ID = 1864081662;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class DeviceToken: public Object {
 public:
};

class deviceTokenFirebaseCloudMessaging final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;
  bool encrypt_;

  deviceTokenFirebaseCloudMessaging();

  deviceTokenFirebaseCloudMessaging(string const &token_, bool encrypt_);

  static const std::int32_t ID = -797881849;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenApplePush final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string device_token_;
  bool is_app_sandbox_;

  deviceTokenApplePush();

  deviceTokenApplePush(string const &device_token_, bool is_app_sandbox_);

  static const std::int32_t ID = 387541955;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenApplePushVoIP final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string device_token_;
  bool is_app_sandbox_;
  bool encrypt_;

  deviceTokenApplePushVoIP();

  deviceTokenApplePushVoIP(string const &device_token_, bool is_app_sandbox_, bool encrypt_);

  static const std::int32_t ID = 804275689;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenWindowsPush final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string access_token_;

  deviceTokenWindowsPush();

  explicit deviceTokenWindowsPush(string const &access_token_);

  static const std::int32_t ID = -1410514289;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenMicrosoftPush final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string channel_uri_;

  deviceTokenMicrosoftPush();

  explicit deviceTokenMicrosoftPush(string const &channel_uri_);

  static const std::int32_t ID = 1224269900;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenMicrosoftPushVoIP final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string channel_uri_;

  deviceTokenMicrosoftPushVoIP();

  explicit deviceTokenMicrosoftPushVoIP(string const &channel_uri_);

  static const std::int32_t ID = -785603759;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenWebPush final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string endpoint_;
  string p256dh_base64url_;
  string auth_base64url_;

  deviceTokenWebPush();

  deviceTokenWebPush(string const &endpoint_, string const &p256dh_base64url_, string const &auth_base64url_);

  static const std::int32_t ID = -1694507273;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenSimplePush final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string endpoint_;

  deviceTokenSimplePush();

  explicit deviceTokenSimplePush(string const &endpoint_);

  static const std::int32_t ID = 49584736;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenUbuntuPush final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  deviceTokenUbuntuPush();

  explicit deviceTokenUbuntuPush(string const &token_);

  static const std::int32_t ID = 1782320422;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenBlackBerryPush final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  deviceTokenBlackBerryPush();

  explicit deviceTokenBlackBerryPush(string const &token_);

  static const std::int32_t ID = 1559167234;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenTizenPush final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string reg_id_;

  deviceTokenTizenPush();

  explicit deviceTokenTizenPush(string const &reg_id_);

  static const std::int32_t ID = -1359947213;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deviceTokenHuaweiPush final : public DeviceToken {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;
  bool encrypt_;

  deviceTokenHuaweiPush();

  deviceTokenHuaweiPush(string const &token_, bool encrypt_);

  static const std::int32_t ID = 1989103142;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class DiceStickers: public Object {
 public:
};

class diceStickersRegular final : public DiceStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<sticker> sticker_;

  diceStickersRegular();

  explicit diceStickersRegular(object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = -740299570;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class diceStickersSlotMachine final : public DiceStickers {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<sticker> background_;
  object_ptr<sticker> lever_;
  object_ptr<sticker> left_reel_;
  object_ptr<sticker> center_reel_;
  object_ptr<sticker> right_reel_;

  diceStickersSlotMachine();

  diceStickersSlotMachine(object_ptr<sticker> &&background_, object_ptr<sticker> &&lever_, object_ptr<sticker> &&left_reel_, object_ptr<sticker> &&center_reel_, object_ptr<sticker> &&right_reel_);

  static const std::int32_t ID = -375223124;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class minithumbnail;

class thumbnail;

class document final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string file_name_;
  string mime_type_;
  object_ptr<minithumbnail> minithumbnail_;
  object_ptr<thumbnail> thumbnail_;
  object_ptr<file> document_;

  document();

  document(string const &file_name_, string const &mime_type_, object_ptr<minithumbnail> &&minithumbnail_, object_ptr<thumbnail> &&thumbnail_, object_ptr<file> &&document_);

  static const std::int32_t ID = -1357271080;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class downloadedFileCounts final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 active_count_;
  int32 paused_count_;
  int32 completed_count_;

  downloadedFileCounts();

  downloadedFileCounts(int32 active_count_, int32 paused_count_, int32 completed_count_);

  static const std::int32_t ID = -1973999550;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class InputMessageReplyTo;

class draftMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputMessageReplyTo> reply_to_;
  int32 date_;
  object_ptr<InputMessageContent> input_message_text_;
  int64 effect_id_;

  draftMessage();

  draftMessage(object_ptr<InputMessageReplyTo> &&reply_to_, int32 date_, object_ptr<InputMessageContent> &&input_message_text_, int64 effect_id_);

  static const std::int32_t ID = 1125328749;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmailAddressAuthentication: public Object {
 public:
};

class emailAddressAuthenticationCode final : public EmailAddressAuthentication {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  emailAddressAuthenticationCode();

  explicit emailAddressAuthenticationCode(string const &code_);

  static const std::int32_t ID = -993257022;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emailAddressAuthenticationAppleId final : public EmailAddressAuthentication {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  emailAddressAuthenticationAppleId();

  explicit emailAddressAuthenticationAppleId(string const &token_);

  static const std::int32_t ID = 633948265;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emailAddressAuthenticationGoogleId final : public EmailAddressAuthentication {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  emailAddressAuthenticationGoogleId();

  explicit emailAddressAuthenticationGoogleId(string const &token_);

  static const std::int32_t ID = -19142846;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emailAddressAuthenticationCodeInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string email_address_pattern_;
  int32 length_;

  emailAddressAuthenticationCodeInfo();

  emailAddressAuthenticationCodeInfo(string const &email_address_pattern_, int32 length_);

  static const std::int32_t ID = 1151066659;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmailAddressResetState: public Object {
 public:
};

class emailAddressResetStateAvailable final : public EmailAddressResetState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 wait_period_;

  emailAddressResetStateAvailable();

  explicit emailAddressResetStateAvailable(int32 wait_period_);

  static const std::int32_t ID = -1917177600;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emailAddressResetStatePending final : public EmailAddressResetState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 reset_in_;

  emailAddressResetStatePending();

  explicit emailAddressResetStatePending(int32 reset_in_);

  static const std::int32_t ID = -1885966805;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiCategory;

class emojiCategories final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<emojiCategory>> categories_;

  emojiCategories();

  explicit emojiCategories(array<object_ptr<emojiCategory>> &&categories_);

  static const std::int32_t ID = -1455387824;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiCategorySource;

class sticker;

class emojiCategory final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<sticker> icon_;
  object_ptr<EmojiCategorySource> source_;
  bool is_greeting_;

  emojiCategory();

  emojiCategory(string const &name_, object_ptr<sticker> &&icon_, object_ptr<EmojiCategorySource> &&source_, bool is_greeting_);

  static const std::int32_t ID = 571335919;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiCategorySource: public Object {
 public:
};

class emojiCategorySourceSearch final : public EmojiCategorySource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> emojis_;

  emojiCategorySourceSearch();

  explicit emojiCategorySourceSearch(array<string> &&emojis_);

  static const std::int32_t ID = -453260262;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiCategorySourcePremium final : public EmojiCategorySource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  emojiCategorySourcePremium();

  static const std::int32_t ID = -1932358388;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiCategoryType: public Object {
 public:
};

class emojiCategoryTypeDefault final : public EmojiCategoryType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  emojiCategoryTypeDefault();

  static const std::int32_t ID = 1188782699;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiCategoryTypeRegularStickers final : public EmojiCategoryType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  emojiCategoryTypeRegularStickers();

  static const std::int32_t ID = -1337484846;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiCategoryTypeEmojiStatus final : public EmojiCategoryType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  emojiCategoryTypeEmojiStatus();

  static const std::int32_t ID = 1381282631;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiCategoryTypeChatPhoto final : public EmojiCategoryType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  emojiCategoryTypeChatPhoto();

  static const std::int32_t ID = 1059063081;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiKeyword final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoji_;
  string keyword_;

  emojiKeyword();

  emojiKeyword(string const &emoji_, string const &keyword_);

  static const std::int32_t ID = -2112285985;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiKeyword;

class emojiKeywords final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<emojiKeyword>> emoji_keywords_;

  emojiKeywords();

  explicit emojiKeywords(array<object_ptr<emojiKeyword>> &&emoji_keywords_);

  static const std::int32_t ID = 689723339;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class emojiReaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoji_;
  string title_;
  bool is_active_;
  object_ptr<sticker> static_icon_;
  object_ptr<sticker> appear_animation_;
  object_ptr<sticker> select_animation_;
  object_ptr<sticker> activate_animation_;
  object_ptr<sticker> effect_animation_;
  object_ptr<sticker> around_animation_;
  object_ptr<sticker> center_animation_;

  emojiReaction();

  emojiReaction(string const &emoji_, string const &title_, bool is_active_, object_ptr<sticker> &&static_icon_, object_ptr<sticker> &&appear_animation_, object_ptr<sticker> &&select_animation_, object_ptr<sticker> &&activate_animation_, object_ptr<sticker> &&effect_animation_, object_ptr<sticker> &&around_animation_, object_ptr<sticker> &&center_animation_);

  static const std::int32_t ID = 1616063583;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiStatusType;

class emojiStatus final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EmojiStatusType> type_;
  int32 expiration_date_;

  emojiStatus();

  emojiStatus(object_ptr<EmojiStatusType> &&type_, int32 expiration_date_);

  static const std::int32_t ID = 973424912;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatusCustomEmojis final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> custom_emoji_ids_;

  emojiStatusCustomEmojis();

  explicit emojiStatusCustomEmojis(array<int64> &&custom_emoji_ids_);

  static const std::int32_t ID = 917123337;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGiftBackdropColors;

class EmojiStatusType: public Object {
 public:
};

class emojiStatusTypeCustomEmoji final : public EmojiStatusType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 custom_emoji_id_;

  emojiStatusTypeCustomEmoji();

  explicit emojiStatusTypeCustomEmoji(int64 custom_emoji_id_);

  static const std::int32_t ID = -1666780939;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatusTypeUpgradedGift final : public EmojiStatusType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 upgraded_gift_id_;
  string gift_title_;
  string gift_name_;
  int64 model_custom_emoji_id_;
  int64 symbol_custom_emoji_id_;
  object_ptr<upgradedGiftBackdropColors> backdrop_colors_;

  emojiStatusTypeUpgradedGift();

  emojiStatusTypeUpgradedGift(int64 upgraded_gift_id_, string const &gift_title_, string const &gift_name_, int64 model_custom_emoji_id_, int64 symbol_custom_emoji_id_, object_ptr<upgradedGiftBackdropColors> &&backdrop_colors_);

  static const std::int32_t ID = -837921804;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatus;

class emojiStatuses final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<emojiStatus>> emoji_statuses_;

  emojiStatuses();

  explicit emojiStatuses(array<object_ptr<emojiStatus>> &&emoji_statuses_);

  static const std::int32_t ID = 1186104146;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojis final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> emojis_;

  emojis();

  explicit emojis(array<string> &&emojis_);

  static const std::int32_t ID = 950339552;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class encryptedCredentials final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes data_;
  bytes hash_;
  bytes secret_;

  encryptedCredentials();

  encryptedCredentials(bytes const &data_, bytes const &hash_, bytes const &secret_);

  static const std::int32_t ID = 1331106766;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PassportElementType;

class datedFile;

class encryptedPassportElement final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PassportElementType> type_;
  bytes data_;
  object_ptr<datedFile> front_side_;
  object_ptr<datedFile> reverse_side_;
  object_ptr<datedFile> selfie_;
  array<object_ptr<datedFile>> translation_;
  array<object_ptr<datedFile>> files_;
  string value_;
  string hash_;

  encryptedPassportElement();

  encryptedPassportElement(object_ptr<PassportElementType> &&type_, bytes const &data_, object_ptr<datedFile> &&front_side_, object_ptr<datedFile> &&reverse_side_, object_ptr<datedFile> &&selfie_, array<object_ptr<datedFile>> &&translation_, array<object_ptr<datedFile>> &&files_, string const &value_, string const &hash_);

  static const std::int32_t ID = 2002386193;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class error final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 code_;
  string message_;

  error();

  error(int32 code_, string const &message_);

  static const std::int32_t ID = -1679978726;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class factCheck final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  string country_code_;

  factCheck();

  factCheck(object_ptr<formattedText> &&text_, string const &country_code_);

  static const std::int32_t ID = -1048184552;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class failedToAddMember final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  bool premium_would_allow_invite_;
  bool premium_required_to_send_messages_;

  failedToAddMember();

  failedToAddMember(int53 user_id_, bool premium_would_allow_invite_, bool premium_required_to_send_messages_);

  static const std::int32_t ID = -282891070;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class failedToAddMember;

class failedToAddMembers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<failedToAddMember>> failed_to_add_members_;

  failedToAddMembers();

  explicit failedToAddMembers(array<object_ptr<failedToAddMember>> &&failed_to_add_members_);

  static const std::int32_t ID = -272587152;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class localFile;

class remoteFile;

class file final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int53 size_;
  int53 expected_size_;
  object_ptr<localFile> local_;
  object_ptr<remoteFile> remote_;

  file();

  file(int32 id_, int53 size_, int53 expected_size_, object_ptr<localFile> &&local_, object_ptr<remoteFile> &&remote_);

  static const std::int32_t ID = 1263291956;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class fileDownload final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;
  object_ptr<message> message_;
  int32 add_date_;
  int32 complete_date_;
  bool is_paused_;

  fileDownload();

  fileDownload(int32 file_id_, object_ptr<message> &&message_, int32 add_date_, int32 complete_date_, bool is_paused_);

  static const std::int32_t ID = -2092100780;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileDownloadedPrefixSize final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 size_;

  fileDownloadedPrefixSize();

  explicit fileDownloadedPrefixSize(int53 size_);

  static const std::int32_t ID = -2015205381;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class FileType: public Object {
 public:
};

class fileTypeNone final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeNone();

  static const std::int32_t ID = 2003009189;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeAnimation final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeAnimation();

  static const std::int32_t ID = -290816582;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeAudio final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeAudio();

  static const std::int32_t ID = -709112160;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeDocument final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeDocument();

  static const std::int32_t ID = -564722929;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeNotificationSound final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeNotificationSound();

  static const std::int32_t ID = -1020289271;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypePhoto final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypePhoto();

  static const std::int32_t ID = -1718914651;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypePhotoStory final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypePhotoStory();

  static const std::int32_t ID = 2018995956;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeProfilePhoto final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeProfilePhoto();

  static const std::int32_t ID = 1795089315;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeSecret final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeSecret();

  static const std::int32_t ID = -1871899401;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeSecretThumbnail final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeSecretThumbnail();

  static const std::int32_t ID = -1401326026;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeSecure final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeSecure();

  static const std::int32_t ID = -1419133146;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeSelfDestructingPhoto final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeSelfDestructingPhoto();

  static const std::int32_t ID = 2077176475;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeSelfDestructingVideo final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeSelfDestructingVideo();

  static const std::int32_t ID = -1223900123;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeSelfDestructingVideoNote final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeSelfDestructingVideoNote();

  static const std::int32_t ID = 1495274177;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeSelfDestructingVoiceNote final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeSelfDestructingVoiceNote();

  static const std::int32_t ID = 1691409181;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeSticker final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeSticker();

  static const std::int32_t ID = 475233385;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeThumbnail final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeThumbnail();

  static const std::int32_t ID = -12443298;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeUnknown final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeUnknown();

  static const std::int32_t ID = -2011566768;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeVideo final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeVideo();

  static const std::int32_t ID = 1430816539;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeVideoNote final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeVideoNote();

  static const std::int32_t ID = -518412385;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeVideoStory final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeVideoStory();

  static const std::int32_t ID = -2146754143;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeVoiceNote final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeVoiceNote();

  static const std::int32_t ID = -588681661;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileTypeWallpaper final : public FileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  fileTypeWallpaper();

  static const std::int32_t ID = 1854930076;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class FirebaseAuthenticationSettings: public Object {
 public:
};

class firebaseAuthenticationSettingsAndroid final : public FirebaseAuthenticationSettings {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  firebaseAuthenticationSettingsAndroid();

  static const std::int32_t ID = -1771112932;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class firebaseAuthenticationSettingsIos final : public FirebaseAuthenticationSettings {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string device_token_;
  bool is_app_sandbox_;

  firebaseAuthenticationSettingsIos();

  firebaseAuthenticationSettingsIos(string const &device_token_, bool is_app_sandbox_);

  static const std::int32_t ID = 222930116;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class FirebaseDeviceVerificationParameters: public Object {
 public:
};

class firebaseDeviceVerificationParametersSafetyNet final : public FirebaseDeviceVerificationParameters {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes nonce_;

  firebaseDeviceVerificationParametersSafetyNet();

  explicit firebaseDeviceVerificationParametersSafetyNet(bytes const &nonce_);

  static const std::int32_t ID = 731296497;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class firebaseDeviceVerificationParametersPlayIntegrity final : public FirebaseDeviceVerificationParameters {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string nonce_;
  int64 cloud_project_number_;

  firebaseDeviceVerificationParametersPlayIntegrity();

  firebaseDeviceVerificationParametersPlayIntegrity(string const &nonce_, int64 cloud_project_number_);

  static const std::int32_t ID = -889936502;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntity;

class formattedText final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  array<object_ptr<textEntity>> entities_;

  formattedText();

  formattedText(string const &text_, array<object_ptr<textEntity>> &&entities_);

  static const std::int32_t ID = -252624564;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatNotificationSettings;

class draftMessage;

class forumTopicInfo;

class message;

class forumTopic final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<forumTopicInfo> info_;
  object_ptr<message> last_message_;
  int64 order_;
  bool is_pinned_;
  int32 unread_count_;
  int53 last_read_inbox_message_id_;
  int53 last_read_outbox_message_id_;
  int32 unread_mention_count_;
  int32 unread_reaction_count_;
  object_ptr<chatNotificationSettings> notification_settings_;
  object_ptr<draftMessage> draft_message_;

  forumTopic();

  forumTopic(object_ptr<forumTopicInfo> &&info_, object_ptr<message> &&last_message_, int64 order_, bool is_pinned_, int32 unread_count_, int53 last_read_inbox_message_id_, int53 last_read_outbox_message_id_, int32 unread_mention_count_, int32 unread_reaction_count_, object_ptr<chatNotificationSettings> &&notification_settings_, object_ptr<draftMessage> &&draft_message_);

  static const std::int32_t ID = -2094608976;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class forumTopicIcon final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 color_;
  int64 custom_emoji_id_;

  forumTopicIcon();

  forumTopicIcon(int32 color_, int64 custom_emoji_id_);

  static const std::int32_t ID = -818765421;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class forumTopicIcon;

class forumTopicInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_thread_id_;
  string name_;
  object_ptr<forumTopicIcon> icon_;
  int32 creation_date_;
  object_ptr<MessageSender> creator_id_;
  bool is_general_;
  bool is_outgoing_;
  bool is_closed_;
  bool is_hidden_;

  forumTopicInfo();

  forumTopicInfo(int53 chat_id_, int53 message_thread_id_, string const &name_, object_ptr<forumTopicIcon> &&icon_, int32 creation_date_, object_ptr<MessageSender> &&creator_id_, bool is_general_, bool is_outgoing_, bool is_closed_, bool is_hidden_);

  static const std::int32_t ID = -654857606;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class forumTopic;

class forumTopics final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<forumTopic>> topics_;
  int32 next_offset_date_;
  int53 next_offset_message_id_;
  int53 next_offset_message_thread_id_;

  forumTopics();

  forumTopics(int32 total_count_, array<object_ptr<forumTopic>> &&topics_, int32 next_offset_date_, int53 next_offset_message_id_, int53 next_offset_message_thread_id_);

  static const std::int32_t ID = 732819537;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class forwardSource final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<MessageSender> sender_id_;
  string sender_name_;
  int32 date_;
  bool is_outgoing_;

  forwardSource();

  forwardSource(int53 chat_id_, int53 message_id_, object_ptr<MessageSender> &&sender_id_, string const &sender_name_, int32 date_, bool is_outgoing_);

  static const std::int32_t ID = 1795337929;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class affiliateProgramInfo;

class foundAffiliateProgram final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  object_ptr<affiliateProgramInfo> info_;

  foundAffiliateProgram();

  foundAffiliateProgram(int53 bot_user_id_, object_ptr<affiliateProgramInfo> &&info_);

  static const std::int32_t ID = -966565242;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class foundAffiliateProgram;

class foundAffiliatePrograms final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<foundAffiliateProgram>> programs_;
  string next_offset_;

  foundAffiliatePrograms();

  foundAffiliatePrograms(int32 total_count_, array<object_ptr<foundAffiliateProgram>> &&programs_, string const &next_offset_);

  static const std::int32_t ID = 186317057;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoost;

class foundChatBoosts final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<chatBoost>> boosts_;
  string next_offset_;

  foundChatBoosts();

  foundChatBoosts(int32 total_count_, array<object_ptr<chatBoost>> &&boosts_, string const &next_offset_);

  static const std::int32_t ID = 51457680;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class foundChatMessages final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<message>> messages_;
  int53 next_from_message_id_;

  foundChatMessages();

  foundChatMessages(int32 total_count_, array<object_ptr<message>> &&messages_, int53 next_from_message_id_);

  static const std::int32_t ID = 427484196;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class downloadedFileCounts;

class fileDownload;

class foundFileDownloads final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<downloadedFileCounts> total_counts_;
  array<object_ptr<fileDownload>> files_;
  string next_offset_;

  foundFileDownloads();

  foundFileDownloads(object_ptr<downloadedFileCounts> &&total_counts_, array<object_ptr<fileDownload>> &&files_, string const &next_offset_);

  static const std::int32_t ID = 1395890392;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class foundMessages final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<message>> messages_;
  string next_offset_;

  foundMessages();

  foundMessages(int32 total_count_, array<object_ptr<message>> &&messages_, string const &next_offset_);

  static const std::int32_t ID = -529809608;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class foundPosition final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 position_;

  foundPosition();

  explicit foundPosition(int32 position_);

  static const std::int32_t ID = -1886724216;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class foundPositions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<int32> positions_;

  foundPositions();

  foundPositions(int32 total_count_, array<int32> &&positions_);

  static const std::int32_t ID = -80518368;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class story;

class foundStories final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<story>> stories_;
  string next_offset_;

  foundStories();

  foundStories(int32 total_count_, array<object_ptr<story>> &&stories_, string const &next_offset_);

  static const std::int32_t ID = 1678513512;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class foundUsers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> user_ids_;
  string next_offset_;

  foundUsers();

  foundUsers(array<int53> &&user_ids_, string const &next_offset_);

  static const std::int32_t ID = 1150570075;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webApp;

class foundWebApp final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<webApp> web_app_;
  bool request_write_access_;
  bool skip_confirmation_;

  foundWebApp();

  foundWebApp(object_ptr<webApp> &&web_app_, bool request_write_access_, bool skip_confirmation_);

  static const std::int32_t ID = -290926562;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class animation;

class formattedText;

class photo;

class game final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  string short_name_;
  string title_;
  object_ptr<formattedText> text_;
  string description_;
  object_ptr<photo> photo_;
  object_ptr<animation> animation_;

  game();

  game(int64 id_, string const &short_name_, string const &title_, object_ptr<formattedText> &&text_, string const &description_, object_ptr<photo> &&photo_, object_ptr<animation> &&animation_);

  static const std::int32_t ID = -1565597752;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class gameHighScore final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 position_;
  int53 user_id_;
  int32 score_;

  gameHighScore();

  gameHighScore(int32 position_, int53 user_id_, int32 score_);

  static const std::int32_t ID = 342871838;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class gameHighScore;

class gameHighScores final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<gameHighScore>> scores_;

  gameHighScores();

  explicit gameHighScores(array<object_ptr<gameHighScore>> &&scores_);

  static const std::int32_t ID = -725770727;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class gift final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  object_ptr<sticker> sticker_;
  int53 star_count_;
  int53 default_sell_star_count_;
  int53 upgrade_star_count_;
  bool is_for_birthday_;
  int32 remaining_count_;
  int32 total_count_;
  int32 first_send_date_;
  int32 last_send_date_;

  gift();

  gift(int64 id_, object_ptr<sticker> &&sticker_, int53 star_count_, int53 default_sell_star_count_, int53 upgrade_star_count_, bool is_for_birthday_, int32 remaining_count_, int32 total_count_, int32 first_send_date_, int32 last_send_date_);

  static const std::int32_t ID = 2096710701;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGift;

class giftForResale final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<upgradedGift> gift_;
  string received_gift_id_;

  giftForResale();

  giftForResale(object_ptr<upgradedGift> &&gift_, string const &received_gift_id_);

  static const std::int32_t ID = 1130990515;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GiftForResaleOrder: public Object {
 public:
};

class giftForResaleOrderPrice final : public GiftForResaleOrder {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  giftForResaleOrderPrice();

  static const std::int32_t ID = 1371740258;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giftForResaleOrderPriceChangeDate final : public GiftForResaleOrder {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  giftForResaleOrderPriceChangeDate();

  static const std::int32_t ID = -1694144054;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giftForResaleOrderNumber final : public GiftForResaleOrder {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  giftForResaleOrderNumber();

  static const std::int32_t ID = -1301157632;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class acceptedGiftTypes;

class giftSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool show_gift_button_;
  object_ptr<acceptedGiftTypes> accepted_gift_types_;

  giftSettings();

  giftSettings(bool show_gift_button_, object_ptr<acceptedGiftTypes> &&accepted_gift_types_);

  static const std::int32_t ID = 45783168;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGiftBackdrop;

class upgradedGiftModel;

class upgradedGiftSymbol;

class giftUpgradePreview final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<upgradedGiftModel>> models_;
  array<object_ptr<upgradedGiftSymbol>> symbols_;
  array<object_ptr<upgradedGiftBackdrop>> backdrops_;

  giftUpgradePreview();

  giftUpgradePreview(array<object_ptr<upgradedGiftModel>> &&models_, array<object_ptr<upgradedGiftSymbol>> &&symbols_, array<object_ptr<upgradedGiftBackdrop>> &&backdrops_);

  static const std::int32_t ID = 729908218;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giftForResale;

class upgradedGiftBackdropCount;

class upgradedGiftModelCount;

class upgradedGiftSymbolCount;

class giftsForResale final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<giftForResale>> gifts_;
  array<object_ptr<upgradedGiftModelCount>> models_;
  array<object_ptr<upgradedGiftSymbolCount>> symbols_;
  array<object_ptr<upgradedGiftBackdropCount>> backdrops_;
  string next_offset_;

  giftsForResale();

  giftsForResale(int32 total_count_, array<object_ptr<giftForResale>> &&gifts_, array<object_ptr<upgradedGiftModelCount>> &&models_, array<object_ptr<upgradedGiftSymbolCount>> &&symbols_, array<object_ptr<upgradedGiftBackdropCount>> &&backdrops_, string const &next_offset_);

  static const std::int32_t ID = 35082425;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GiveawayParticipantStatus;

class GiveawayInfo: public Object {
 public:
};

class giveawayInfoOngoing final : public GiveawayInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 creation_date_;
  object_ptr<GiveawayParticipantStatus> status_;
  bool is_ended_;

  giveawayInfoOngoing();

  giveawayInfoOngoing(int32 creation_date_, object_ptr<GiveawayParticipantStatus> &&status_, bool is_ended_);

  static const std::int32_t ID = 1649336400;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giveawayInfoCompleted final : public GiveawayInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 creation_date_;
  int32 actual_winners_selection_date_;
  bool was_refunded_;
  bool is_winner_;
  int32 winner_count_;
  int32 activation_count_;
  string gift_code_;
  int53 won_star_count_;

  giveawayInfoCompleted();

  giveawayInfoCompleted(int32 creation_date_, int32 actual_winners_selection_date_, bool was_refunded_, bool is_winner_, int32 winner_count_, int32 activation_count_, string const &gift_code_, int53 won_star_count_);

  static const std::int32_t ID = 848085852;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giveawayParameters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 boosted_chat_id_;
  array<int53> additional_chat_ids_;
  int32 winners_selection_date_;
  bool only_new_members_;
  bool has_public_winners_;
  array<string> country_codes_;
  string prize_description_;

  giveawayParameters();

  giveawayParameters(int53 boosted_chat_id_, array<int53> &&additional_chat_ids_, int32 winners_selection_date_, bool only_new_members_, bool has_public_winners_, array<string> &&country_codes_, string const &prize_description_);

  static const std::int32_t ID = 1171549354;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GiveawayParticipantStatus: public Object {
 public:
};

class giveawayParticipantStatusEligible final : public GiveawayParticipantStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  giveawayParticipantStatusEligible();

  static const std::int32_t ID = 304799383;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giveawayParticipantStatusParticipating final : public GiveawayParticipantStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  giveawayParticipantStatusParticipating();

  static const std::int32_t ID = 492036975;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giveawayParticipantStatusAlreadyWasMember final : public GiveawayParticipantStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 joined_chat_date_;

  giveawayParticipantStatusAlreadyWasMember();

  explicit giveawayParticipantStatusAlreadyWasMember(int32 joined_chat_date_);

  static const std::int32_t ID = 301577632;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giveawayParticipantStatusAdministrator final : public GiveawayParticipantStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  giveawayParticipantStatusAdministrator();

  explicit giveawayParticipantStatusAdministrator(int53 chat_id_);

  static const std::int32_t ID = -934593931;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giveawayParticipantStatusDisallowedCountry final : public GiveawayParticipantStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string user_country_code_;

  giveawayParticipantStatusDisallowedCountry();

  explicit giveawayParticipantStatusDisallowedCountry(string const &user_country_code_);

  static const std::int32_t ID = 1879794779;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GiveawayPrize: public Object {
 public:
};

class giveawayPrizePremium final : public GiveawayPrize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 month_count_;

  giveawayPrizePremium();

  explicit giveawayPrizePremium(int32 month_count_);

  static const std::int32_t ID = 454224248;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giveawayPrizeStars final : public GiveawayPrize {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;

  giveawayPrizeStars();

  explicit giveawayPrizeStars(int53 star_count_);

  static const std::int32_t ID = -1790173276;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallRecentSpeaker;

class groupCall final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  string title_;
  string invite_link_;
  int32 scheduled_start_date_;
  bool enabled_start_notification_;
  bool is_active_;
  bool is_video_chat_;
  bool is_rtmp_stream_;
  bool is_joined_;
  bool need_rejoin_;
  bool is_owned_;
  bool can_be_managed_;
  int32 participant_count_;
  bool has_hidden_listeners_;
  bool loaded_all_participants_;
  array<object_ptr<groupCallRecentSpeaker>> recent_speakers_;
  bool is_my_video_enabled_;
  bool is_my_video_paused_;
  bool can_enable_video_;
  bool mute_new_participants_;
  bool can_toggle_mute_new_participants_;
  int32 record_duration_;
  bool is_video_recorded_;
  int32 duration_;

  groupCall();

  groupCall(int32 id_, string const &title_, string const &invite_link_, int32 scheduled_start_date_, bool enabled_start_notification_, bool is_active_, bool is_video_chat_, bool is_rtmp_stream_, bool is_joined_, bool need_rejoin_, bool is_owned_, bool can_be_managed_, int32 participant_count_, bool has_hidden_listeners_, bool loaded_all_participants_, array<object_ptr<groupCallRecentSpeaker>> &&recent_speakers_, bool is_my_video_enabled_, bool is_my_video_paused_, bool can_enable_video_, bool mute_new_participants_, bool can_toggle_mute_new_participants_, int32 record_duration_, bool is_video_recorded_, int32 duration_);

  static const std::int32_t ID = -144438687;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GroupCallDataChannel: public Object {
 public:
};

class groupCallDataChannelMain final : public GroupCallDataChannel {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  groupCallDataChannelMain();

  static const std::int32_t ID = -32177779;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallDataChannelScreenSharing final : public GroupCallDataChannel {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  groupCallDataChannelScreenSharing();

  static const std::int32_t ID = -601649103;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallId final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;

  groupCallId();

  explicit groupCallId(int32 id_);

  static const std::int32_t ID = 350534469;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  string join_payload_;

  groupCallInfo();

  groupCallInfo(int32 group_call_id_, string const &join_payload_);

  static const std::int32_t ID = 892575956;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallJoinParameters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 audio_source_id_;
  string payload_;
  bool is_muted_;
  bool is_my_video_enabled_;

  groupCallJoinParameters();

  groupCallJoinParameters(int32 audio_source_id_, string const &payload_, bool is_muted_, bool is_my_video_enabled_);

  static const std::int32_t ID = 1763438054;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class groupCallParticipantVideoInfo;

class groupCallParticipant final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> participant_id_;
  int32 audio_source_id_;
  int32 screen_sharing_audio_source_id_;
  object_ptr<groupCallParticipantVideoInfo> video_info_;
  object_ptr<groupCallParticipantVideoInfo> screen_sharing_video_info_;
  string bio_;
  bool is_current_user_;
  bool is_speaking_;
  bool is_hand_raised_;
  bool can_be_muted_for_all_users_;
  bool can_be_unmuted_for_all_users_;
  bool can_be_muted_for_current_user_;
  bool can_be_unmuted_for_current_user_;
  bool is_muted_for_all_users_;
  bool is_muted_for_current_user_;
  bool can_unmute_self_;
  int32 volume_level_;
  string order_;

  groupCallParticipant();

  groupCallParticipant(object_ptr<MessageSender> &&participant_id_, int32 audio_source_id_, int32 screen_sharing_audio_source_id_, object_ptr<groupCallParticipantVideoInfo> &&video_info_, object_ptr<groupCallParticipantVideoInfo> &&screen_sharing_video_info_, string const &bio_, bool is_current_user_, bool is_speaking_, bool is_hand_raised_, bool can_be_muted_for_all_users_, bool can_be_unmuted_for_all_users_, bool can_be_muted_for_current_user_, bool can_be_unmuted_for_current_user_, bool is_muted_for_all_users_, bool is_muted_for_current_user_, bool can_unmute_self_, int32 volume_level_, string const &order_);

  static const std::int32_t ID = 2059182571;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallVideoSourceGroup;

class groupCallParticipantVideoInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<groupCallVideoSourceGroup>> source_groups_;
  string endpoint_id_;
  bool is_paused_;

  groupCallParticipantVideoInfo();

  groupCallParticipantVideoInfo(array<object_ptr<groupCallVideoSourceGroup>> &&source_groups_, string const &endpoint_id_, bool is_paused_);

  static const std::int32_t ID = -14294645;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class groupCallParticipants final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<MessageSender>> participant_ids_;

  groupCallParticipants();

  groupCallParticipants(int32 total_count_, array<object_ptr<MessageSender>> &&participant_ids_);

  static const std::int32_t ID = -1042491570;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class groupCallRecentSpeaker final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> participant_id_;
  bool is_speaking_;

  groupCallRecentSpeaker();

  groupCallRecentSpeaker(object_ptr<MessageSender> &&participant_id_, bool is_speaking_);

  static const std::int32_t ID = 1819519436;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GroupCallVideoQuality: public Object {
 public:
};

class groupCallVideoQualityThumbnail final : public GroupCallVideoQuality {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  groupCallVideoQualityThumbnail();

  static const std::int32_t ID = -379186304;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallVideoQualityMedium final : public GroupCallVideoQuality {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  groupCallVideoQualityMedium();

  static const std::int32_t ID = 394968234;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallVideoQualityFull final : public GroupCallVideoQuality {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  groupCallVideoQualityFull();

  static const std::int32_t ID = -2125916617;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallVideoSourceGroup final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string semantics_;
  array<int32> source_ids_;

  groupCallVideoSourceGroup();

  groupCallVideoSourceGroup(string const &semantics_, array<int32> &&source_ids_);

  static const std::int32_t ID = -1190900785;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class hashtags final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> hashtags_;

  hashtags();

  explicit hashtags(array<string> &&hashtags_);

  static const std::int32_t ID = 676798885;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class httpUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  httpUrl();

  explicit httpUrl(string const &url_);

  static const std::int32_t ID = -2018019930;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class date;

class datedFile;

class identityDocument final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string number_;
  object_ptr<date> expiration_date_;
  object_ptr<datedFile> front_side_;
  object_ptr<datedFile> reverse_side_;
  object_ptr<datedFile> selfie_;
  array<object_ptr<datedFile>> translation_;

  identityDocument();

  identityDocument(string const &number_, object_ptr<date> &&expiration_date_, object_ptr<datedFile> &&front_side_, object_ptr<datedFile> &&reverse_side_, object_ptr<datedFile> &&selfie_, array<object_ptr<datedFile>> &&translation_);

  static const std::int32_t ID = 1001703606;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class importedContacts final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> user_ids_;
  array<int32> importer_count_;

  importedContacts();

  importedContacts(array<int53> &&user_ids_, array<int32> &&importer_count_);

  static const std::int32_t ID = 2068432290;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InlineKeyboardButtonType;

class inlineKeyboardButton final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  object_ptr<InlineKeyboardButtonType> type_;

  inlineKeyboardButton();

  inlineKeyboardButton(string const &text_, object_ptr<InlineKeyboardButtonType> &&type_);

  static const std::int32_t ID = -372105704;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class TargetChat;

class InlineKeyboardButtonType: public Object {
 public:
};

class inlineKeyboardButtonTypeUrl final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  inlineKeyboardButtonTypeUrl();

  explicit inlineKeyboardButtonTypeUrl(string const &url_);

  static const std::int32_t ID = 1130741420;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButtonTypeLoginUrl final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int53 id_;
  string forward_text_;

  inlineKeyboardButtonTypeLoginUrl();

  inlineKeyboardButtonTypeLoginUrl(string const &url_, int53 id_, string const &forward_text_);

  static const std::int32_t ID = -1203413081;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButtonTypeWebApp final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  inlineKeyboardButtonTypeWebApp();

  explicit inlineKeyboardButtonTypeWebApp(string const &url_);

  static const std::int32_t ID = -1767471672;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButtonTypeCallback final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes data_;

  inlineKeyboardButtonTypeCallback();

  explicit inlineKeyboardButtonTypeCallback(bytes const &data_);

  static const std::int32_t ID = -1127515139;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButtonTypeCallbackWithPassword final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes data_;

  inlineKeyboardButtonTypeCallbackWithPassword();

  explicit inlineKeyboardButtonTypeCallbackWithPassword(bytes const &data_);

  static const std::int32_t ID = 908018248;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButtonTypeCallbackGame final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  inlineKeyboardButtonTypeCallbackGame();

  static const std::int32_t ID = -383429528;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButtonTypeSwitchInline final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string query_;
  object_ptr<TargetChat> target_chat_;

  inlineKeyboardButtonTypeSwitchInline();

  inlineKeyboardButtonTypeSwitchInline(string const &query_, object_ptr<TargetChat> &&target_chat_);

  static const std::int32_t ID = 544906485;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButtonTypeBuy final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  inlineKeyboardButtonTypeBuy();

  static const std::int32_t ID = 1360739440;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButtonTypeUser final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  inlineKeyboardButtonTypeUser();

  explicit inlineKeyboardButtonTypeUser(int53 user_id_);

  static const std::int32_t ID = 1836574114;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButtonTypeCopyText final : public InlineKeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  inlineKeyboardButtonTypeCopyText();

  explicit inlineKeyboardButtonTypeCopyText(string const &text_);

  static const std::int32_t ID = 68883206;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class animation;

class audio;

class contact;

class document;

class game;

class location;

class photo;

class sticker;

class thumbnail;

class venue;

class video;

class voiceNote;

class InlineQueryResult: public Object {
 public:
};

class inlineQueryResultArticle final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string url_;
  string title_;
  string description_;
  object_ptr<thumbnail> thumbnail_;

  inlineQueryResultArticle();

  inlineQueryResultArticle(string const &id_, string const &url_, string const &title_, string const &description_, object_ptr<thumbnail> &&thumbnail_);

  static const std::int32_t ID = 269930522;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultContact final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<contact> contact_;
  object_ptr<thumbnail> thumbnail_;

  inlineQueryResultContact();

  inlineQueryResultContact(string const &id_, object_ptr<contact> &&contact_, object_ptr<thumbnail> &&thumbnail_);

  static const std::int32_t ID = -181960174;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultLocation final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<location> location_;
  string title_;
  object_ptr<thumbnail> thumbnail_;

  inlineQueryResultLocation();

  inlineQueryResultLocation(string const &id_, object_ptr<location> &&location_, string const &title_, object_ptr<thumbnail> &&thumbnail_);

  static const std::int32_t ID = 466004752;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultVenue final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<venue> venue_;
  object_ptr<thumbnail> thumbnail_;

  inlineQueryResultVenue();

  inlineQueryResultVenue(string const &id_, object_ptr<venue> &&venue_, object_ptr<thumbnail> &&thumbnail_);

  static const std::int32_t ID = 1281036382;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultGame final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<game> game_;

  inlineQueryResultGame();

  inlineQueryResultGame(string const &id_, object_ptr<game> &&game_);

  static const std::int32_t ID = 1706916987;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultAnimation final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<animation> animation_;
  string title_;

  inlineQueryResultAnimation();

  inlineQueryResultAnimation(string const &id_, object_ptr<animation> &&animation_, string const &title_);

  static const std::int32_t ID = 2009984267;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultAudio final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<audio> audio_;

  inlineQueryResultAudio();

  inlineQueryResultAudio(string const &id_, object_ptr<audio> &&audio_);

  static const std::int32_t ID = 842650360;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultDocument final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<document> document_;
  string title_;
  string description_;

  inlineQueryResultDocument();

  inlineQueryResultDocument(string const &id_, object_ptr<document> &&document_, string const &title_, string const &description_);

  static const std::int32_t ID = -1491268539;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultPhoto final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<photo> photo_;
  string title_;
  string description_;

  inlineQueryResultPhoto();

  inlineQueryResultPhoto(string const &id_, object_ptr<photo> &&photo_, string const &title_, string const &description_);

  static const std::int32_t ID = 1848319440;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultSticker final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<sticker> sticker_;

  inlineQueryResultSticker();

  inlineQueryResultSticker(string const &id_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = -1848224245;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultVideo final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<video> video_;
  string title_;
  string description_;

  inlineQueryResultVideo();

  inlineQueryResultVideo(string const &id_, object_ptr<video> &&video_, string const &title_, string const &description_);

  static const std::int32_t ID = -1373158683;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultVoiceNote final : public InlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<voiceNote> voice_note_;
  string title_;

  inlineQueryResultVoiceNote();

  inlineQueryResultVoiceNote(string const &id_, object_ptr<voiceNote> &&voice_note_, string const &title_);

  static const std::int32_t ID = -1897393105;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InlineQueryResult;

class inlineQueryResultsButton;

class inlineQueryResults final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 inline_query_id_;
  object_ptr<inlineQueryResultsButton> button_;
  array<object_ptr<InlineQueryResult>> results_;
  string next_offset_;

  inlineQueryResults();

  inlineQueryResults(int64 inline_query_id_, object_ptr<inlineQueryResultsButton> &&button_, array<object_ptr<InlineQueryResult>> &&results_, string const &next_offset_);

  static const std::int32_t ID = 1830685615;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InlineQueryResultsButtonType;

class inlineQueryResultsButton final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  object_ptr<InlineQueryResultsButtonType> type_;

  inlineQueryResultsButton();

  inlineQueryResultsButton(string const &text_, object_ptr<InlineQueryResultsButtonType> &&type_);

  static const std::int32_t ID = -790689618;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InlineQueryResultsButtonType: public Object {
 public:
};

class inlineQueryResultsButtonTypeStartBot final : public InlineQueryResultsButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string parameter_;

  inlineQueryResultsButtonTypeStartBot();

  explicit inlineQueryResultsButtonTypeStartBot(string const &parameter_);

  static const std::int32_t ID = -23400235;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResultsButtonTypeWebApp final : public InlineQueryResultsButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  inlineQueryResultsButtonTypeWebApp();

  explicit inlineQueryResultsButtonTypeWebApp(string const &url_);

  static const std::int32_t ID = -1197382814;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class InputBackground: public Object {
 public:
};

class inputBackgroundLocal final : public InputBackground {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> background_;

  inputBackgroundLocal();

  explicit inputBackgroundLocal(object_ptr<InputFile> &&background_);

  static const std::int32_t ID = -1747094364;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBackgroundRemote final : public InputBackground {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 background_id_;

  inputBackgroundRemote();

  explicit inputBackgroundRemote(int64 background_id_);

  static const std::int32_t ID = -274976231;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputBackgroundPrevious final : public InputBackground {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 message_id_;

  inputBackgroundPrevious();

  explicit inputBackgroundPrevious(int53 message_id_);

  static const std::int32_t ID = -351905954;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class inputBusinessChatLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  string title_;

  inputBusinessChatLink();

  inputBusinessChatLink(object_ptr<formattedText> &&text_, string const &title_);

  static const std::int32_t ID = 237858296;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class inputBusinessStartPage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  string message_;
  object_ptr<InputFile> sticker_;

  inputBusinessStartPage();

  inputBusinessStartPage(string const &title_, string const &message_, object_ptr<InputFile> &&sticker_);

  static const std::int32_t ID = -327383072;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class chatPhotoSticker;

class InputChatPhoto: public Object {
 public:
};

class inputChatPhotoPrevious final : public InputChatPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 chat_photo_id_;

  inputChatPhotoPrevious();

  explicit inputChatPhotoPrevious(int64 chat_photo_id_);

  static const std::int32_t ID = 23128529;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputChatPhotoStatic final : public InputChatPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> photo_;

  inputChatPhotoStatic();

  explicit inputChatPhotoStatic(object_ptr<InputFile> &&photo_);

  static const std::int32_t ID = 1979179699;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputChatPhotoAnimation final : public InputChatPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> animation_;
  double main_frame_timestamp_;

  inputChatPhotoAnimation();

  inputChatPhotoAnimation(object_ptr<InputFile> &&animation_, double main_frame_timestamp_);

  static const std::int32_t ID = 90846242;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputChatPhotoSticker final : public InputChatPhoto {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhotoSticker> sticker_;

  inputChatPhotoSticker();

  explicit inputChatPhotoSticker(object_ptr<chatPhotoSticker> &&sticker_);

  static const std::int32_t ID = 1315861341;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputCredentials: public Object {
 public:
};

class inputCredentialsSaved final : public InputCredentials {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string saved_credentials_id_;

  inputCredentialsSaved();

  explicit inputCredentialsSaved(string const &saved_credentials_id_);

  static const std::int32_t ID = -2034385364;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputCredentialsNew final : public InputCredentials {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string data_;
  bool allow_save_;

  inputCredentialsNew();

  inputCredentialsNew(string const &data_, bool allow_save_);

  static const std::int32_t ID = -829689558;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputCredentialsApplePay final : public InputCredentials {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string data_;

  inputCredentialsApplePay();

  explicit inputCredentialsApplePay(string const &data_);

  static const std::int32_t ID = -1246570799;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputCredentialsGooglePay final : public InputCredentials {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string data_;

  inputCredentialsGooglePay();

  explicit inputCredentialsGooglePay(string const &data_);

  static const std::int32_t ID = 844384100;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile: public Object {
 public:
};

class inputFileId final : public InputFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;

  inputFileId();

  explicit inputFileId(int32 id_);

  static const std::int32_t ID = 1788906253;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputFileRemote final : public InputFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;

  inputFileRemote();

  explicit inputFileRemote(string const &id_);

  static const std::int32_t ID = -107574466;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputFileLocal final : public InputFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string path_;

  inputFileLocal();

  explicit inputFileLocal(string const &path_);

  static const std::int32_t ID = 2056030919;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputFileGenerated final : public InputFile {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string original_path_;
  string conversion_;
  int53 expected_size_;

  inputFileGenerated();

  inputFileGenerated(string const &original_path_, string const &conversion_, int53 expected_size_);

  static const std::int32_t ID = -1333385216;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputGroupCall: public Object {
 public:
};

class inputGroupCallLink final : public InputGroupCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  inputGroupCallLink();

  explicit inputGroupCallLink(string const &link_);

  static const std::int32_t ID = -812157480;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputGroupCallMessage final : public InputGroupCall {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  inputGroupCallMessage();

  inputGroupCallMessage(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -341793768;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class date;

class inputIdentityDocument final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string number_;
  object_ptr<date> expiration_date_;
  object_ptr<InputFile> front_side_;
  object_ptr<InputFile> reverse_side_;
  object_ptr<InputFile> selfie_;
  array<object_ptr<InputFile>> translation_;

  inputIdentityDocument();

  inputIdentityDocument(string const &number_, object_ptr<date> &&expiration_date_, object_ptr<InputFile> &&front_side_, object_ptr<InputFile> &&reverse_side_, object_ptr<InputFile> &&selfie_, array<object_ptr<InputFile>> &&translation_);

  static const std::int32_t ID = 767353688;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class ReplyMarkup;

class contact;

class location;

class venue;

class InputInlineQueryResult: public Object {
 public:
};

class inputInlineQueryResultAnimation final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;
  string thumbnail_url_;
  string thumbnail_mime_type_;
  string video_url_;
  string video_mime_type_;
  int32 video_duration_;
  int32 video_width_;
  int32 video_height_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultAnimation();

  inputInlineQueryResultAnimation(string const &id_, string const &title_, string const &thumbnail_url_, string const &thumbnail_mime_type_, string const &video_url_, string const &video_mime_type_, int32 video_duration_, int32 video_width_, int32 video_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = -1489808874;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultArticle final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string url_;
  string title_;
  string description_;
  string thumbnail_url_;
  int32 thumbnail_width_;
  int32 thumbnail_height_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultArticle();

  inputInlineQueryResultArticle(string const &id_, string const &url_, string const &title_, string const &description_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 1983218620;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultAudio final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;
  string performer_;
  string audio_url_;
  int32 audio_duration_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultAudio();

  inputInlineQueryResultAudio(string const &id_, string const &title_, string const &performer_, string const &audio_url_, int32 audio_duration_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 1260139988;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultContact final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<contact> contact_;
  string thumbnail_url_;
  int32 thumbnail_width_;
  int32 thumbnail_height_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultContact();

  inputInlineQueryResultContact(string const &id_, object_ptr<contact> &&contact_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 1846064594;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultDocument final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;
  string description_;
  string document_url_;
  string mime_type_;
  string thumbnail_url_;
  int32 thumbnail_width_;
  int32 thumbnail_height_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultDocument();

  inputInlineQueryResultDocument(string const &id_, string const &title_, string const &description_, string const &document_url_, string const &mime_type_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 578801869;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultGame final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string game_short_name_;
  object_ptr<ReplyMarkup> reply_markup_;

  inputInlineQueryResultGame();

  inputInlineQueryResultGame(string const &id_, string const &game_short_name_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = 966074327;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultLocation final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<location> location_;
  int32 live_period_;
  string title_;
  string thumbnail_url_;
  int32 thumbnail_width_;
  int32 thumbnail_height_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultLocation();

  inputInlineQueryResultLocation(string const &id_, object_ptr<location> &&location_, int32 live_period_, string const &title_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = -1887650218;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultPhoto final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;
  string description_;
  string thumbnail_url_;
  string photo_url_;
  int32 photo_width_;
  int32 photo_height_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultPhoto();

  inputInlineQueryResultPhoto(string const &id_, string const &title_, string const &description_, string const &thumbnail_url_, string const &photo_url_, int32 photo_width_, int32 photo_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = -1123338721;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultSticker final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string thumbnail_url_;
  string sticker_url_;
  int32 sticker_width_;
  int32 sticker_height_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultSticker();

  inputInlineQueryResultSticker(string const &id_, string const &thumbnail_url_, string const &sticker_url_, int32 sticker_width_, int32 sticker_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 274007129;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultVenue final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<venue> venue_;
  string thumbnail_url_;
  int32 thumbnail_width_;
  int32 thumbnail_height_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultVenue();

  inputInlineQueryResultVenue(string const &id_, object_ptr<venue> &&venue_, string const &thumbnail_url_, int32 thumbnail_width_, int32 thumbnail_height_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 541704509;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultVideo final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;
  string description_;
  string thumbnail_url_;
  string video_url_;
  string mime_type_;
  int32 video_width_;
  int32 video_height_;
  int32 video_duration_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultVideo();

  inputInlineQueryResultVideo(string const &id_, string const &title_, string const &description_, string const &thumbnail_url_, string const &video_url_, string const &mime_type_, int32 video_width_, int32 video_height_, int32 video_duration_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 1724073191;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInlineQueryResultVoiceNote final : public InputInlineQueryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;
  string voice_note_url_;
  int32 voice_note_duration_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  inputInlineQueryResultVoiceNote();

  inputInlineQueryResultVoiceNote(string const &id_, string const &title_, string const &voice_note_url_, int32 voice_note_duration_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = -1790072503;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class TelegramPaymentPurpose;

class InputInvoice: public Object {
 public:
};

class inputInvoiceMessage final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  inputInvoiceMessage();

  inputInvoiceMessage(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = 1490872848;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInvoiceName final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  inputInvoiceName();

  explicit inputInvoiceName(string const &name_);

  static const std::int32_t ID = -1312155917;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputInvoiceTelegram final : public InputInvoice {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<TelegramPaymentPurpose> purpose_;

  inputInvoiceTelegram();

  explicit inputInvoiceTelegram(object_ptr<TelegramPaymentPurpose> &&purpose_);

  static const std::int32_t ID = -1762853139;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class MessageSelfDestructType;

class PollType;

class contact;

class formattedText;

class inputPaidMedia;

class inputThumbnail;

class invoice;

class linkPreviewOptions;

class location;

class messageCopyOptions;

class venue;

class InputMessageContent: public Object {
 public:
};

class inputMessageText final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  object_ptr<linkPreviewOptions> link_preview_options_;
  bool clear_draft_;

  inputMessageText();

  inputMessageText(object_ptr<formattedText> &&text_, object_ptr<linkPreviewOptions> &&link_preview_options_, bool clear_draft_);

  static const std::int32_t ID = -212805484;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageAnimation final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> animation_;
  object_ptr<inputThumbnail> thumbnail_;
  array<int32> added_sticker_file_ids_;
  int32 duration_;
  int32 width_;
  int32 height_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;
  bool has_spoiler_;

  inputMessageAnimation();

  inputMessageAnimation(object_ptr<InputFile> &&animation_, object_ptr<inputThumbnail> &&thumbnail_, array<int32> &&added_sticker_file_ids_, int32 duration_, int32 width_, int32 height_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, bool has_spoiler_);

  static const std::int32_t ID = -210404059;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageAudio final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> audio_;
  object_ptr<inputThumbnail> album_cover_thumbnail_;
  int32 duration_;
  string title_;
  string performer_;
  object_ptr<formattedText> caption_;

  inputMessageAudio();

  inputMessageAudio(object_ptr<InputFile> &&audio_, object_ptr<inputThumbnail> &&album_cover_thumbnail_, int32 duration_, string const &title_, string const &performer_, object_ptr<formattedText> &&caption_);

  static const std::int32_t ID = -626786126;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageDocument final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> document_;
  object_ptr<inputThumbnail> thumbnail_;
  bool disable_content_type_detection_;
  object_ptr<formattedText> caption_;

  inputMessageDocument();

  inputMessageDocument(object_ptr<InputFile> &&document_, object_ptr<inputThumbnail> &&thumbnail_, bool disable_content_type_detection_, object_ptr<formattedText> &&caption_);

  static const std::int32_t ID = 1633383097;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagePaidMedia final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;
  array<object_ptr<inputPaidMedia>> paid_media_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;
  string payload_;

  inputMessagePaidMedia();

  inputMessagePaidMedia(int53 star_count_, array<object_ptr<inputPaidMedia>> &&paid_media_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, string const &payload_);

  static const std::int32_t ID = -1274819374;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagePhoto final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> photo_;
  object_ptr<inputThumbnail> thumbnail_;
  array<int32> added_sticker_file_ids_;
  int32 width_;
  int32 height_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;
  object_ptr<MessageSelfDestructType> self_destruct_type_;
  bool has_spoiler_;

  inputMessagePhoto();

  inputMessagePhoto(object_ptr<InputFile> &&photo_, object_ptr<inputThumbnail> &&thumbnail_, array<int32> &&added_sticker_file_ids_, int32 width_, int32 height_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, object_ptr<MessageSelfDestructType> &&self_destruct_type_, bool has_spoiler_);

  static const std::int32_t ID = -810129442;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageSticker final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> sticker_;
  object_ptr<inputThumbnail> thumbnail_;
  int32 width_;
  int32 height_;
  string emoji_;

  inputMessageSticker();

  inputMessageSticker(object_ptr<InputFile> &&sticker_, object_ptr<inputThumbnail> &&thumbnail_, int32 width_, int32 height_, string const &emoji_);

  static const std::int32_t ID = 1072805625;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageVideo final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> video_;
  object_ptr<inputThumbnail> thumbnail_;
  object_ptr<InputFile> cover_;
  int32 start_timestamp_;
  array<int32> added_sticker_file_ids_;
  int32 duration_;
  int32 width_;
  int32 height_;
  bool supports_streaming_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;
  object_ptr<MessageSelfDestructType> self_destruct_type_;
  bool has_spoiler_;

  inputMessageVideo();

  inputMessageVideo(object_ptr<InputFile> &&video_, object_ptr<inputThumbnail> &&thumbnail_, object_ptr<InputFile> &&cover_, int32 start_timestamp_, array<int32> &&added_sticker_file_ids_, int32 duration_, int32 width_, int32 height_, bool supports_streaming_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, object_ptr<MessageSelfDestructType> &&self_destruct_type_, bool has_spoiler_);

  static const std::int32_t ID = -605958271;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageVideoNote final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> video_note_;
  object_ptr<inputThumbnail> thumbnail_;
  int32 duration_;
  int32 length_;
  object_ptr<MessageSelfDestructType> self_destruct_type_;

  inputMessageVideoNote();

  inputMessageVideoNote(object_ptr<InputFile> &&video_note_, object_ptr<inputThumbnail> &&thumbnail_, int32 duration_, int32 length_, object_ptr<MessageSelfDestructType> &&self_destruct_type_);

  static const std::int32_t ID = -714598691;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageVoiceNote final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> voice_note_;
  int32 duration_;
  bytes waveform_;
  object_ptr<formattedText> caption_;
  object_ptr<MessageSelfDestructType> self_destruct_type_;

  inputMessageVoiceNote();

  inputMessageVoiceNote(object_ptr<InputFile> &&voice_note_, int32 duration_, bytes const &waveform_, object_ptr<formattedText> &&caption_, object_ptr<MessageSelfDestructType> &&self_destruct_type_);

  static const std::int32_t ID = 1461977004;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageLocation final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;
  int32 live_period_;
  int32 heading_;
  int32 proximity_alert_radius_;

  inputMessageLocation();

  inputMessageLocation(object_ptr<location> &&location_, int32 live_period_, int32 heading_, int32 proximity_alert_radius_);

  static const std::int32_t ID = 648735088;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageVenue final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<venue> venue_;

  inputMessageVenue();

  explicit inputMessageVenue(object_ptr<venue> &&venue_);

  static const std::int32_t ID = 1447926269;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageContact final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<contact> contact_;

  inputMessageContact();

  explicit inputMessageContact(object_ptr<contact> &&contact_);

  static const std::int32_t ID = -982446849;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageDice final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoji_;
  bool clear_draft_;

  inputMessageDice();

  inputMessageDice(string const &emoji_, bool clear_draft_);

  static const std::int32_t ID = 841574313;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageGame final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string game_short_name_;

  inputMessageGame();

  inputMessageGame(int53 bot_user_id_, string const &game_short_name_);

  static const std::int32_t ID = 1252944610;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageInvoice final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<invoice> invoice_;
  string title_;
  string description_;
  string photo_url_;
  int32 photo_size_;
  int32 photo_width_;
  int32 photo_height_;
  bytes payload_;
  string provider_token_;
  string provider_data_;
  string start_parameter_;
  object_ptr<inputPaidMedia> paid_media_;
  object_ptr<formattedText> paid_media_caption_;

  inputMessageInvoice();

  inputMessageInvoice(object_ptr<invoice> &&invoice_, string const &title_, string const &description_, string const &photo_url_, int32 photo_size_, int32 photo_width_, int32 photo_height_, bytes const &payload_, string const &provider_token_, string const &provider_data_, string const &start_parameter_, object_ptr<inputPaidMedia> &&paid_media_, object_ptr<formattedText> &&paid_media_caption_);

  static const std::int32_t ID = -1162047631;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessagePoll final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> question_;
  array<object_ptr<formattedText>> options_;
  bool is_anonymous_;
  object_ptr<PollType> type_;
  int32 open_period_;
  int32 close_date_;
  bool is_closed_;

  inputMessagePoll();

  inputMessagePoll(object_ptr<formattedText> &&question_, array<object_ptr<formattedText>> &&options_, bool is_anonymous_, object_ptr<PollType> &&type_, int32 open_period_, int32 close_date_, bool is_closed_);

  static const std::int32_t ID = -263337164;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageStory final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;

  inputMessageStory();

  inputMessageStory(int53 story_poster_chat_id_, int32 story_id_);

  static const std::int32_t ID = -370732053;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageForwarded final : public InputMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 from_chat_id_;
  int53 message_id_;
  bool in_game_share_;
  bool replace_video_start_timestamp_;
  int32 new_video_start_timestamp_;
  object_ptr<messageCopyOptions> copy_options_;

  inputMessageForwarded();

  inputMessageForwarded(int53 from_chat_id_, int53 message_id_, bool in_game_share_, bool replace_video_start_timestamp_, int32 new_video_start_timestamp_, object_ptr<messageCopyOptions> &&copy_options_);

  static const std::int32_t ID = -1076506316;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputTextQuote;

class InputMessageReplyTo: public Object {
 public:
};

class inputMessageReplyToMessage final : public InputMessageReplyTo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 message_id_;
  object_ptr<inputTextQuote> quote_;

  inputMessageReplyToMessage();

  inputMessageReplyToMessage(int53 message_id_, object_ptr<inputTextQuote> &&quote_);

  static const std::int32_t ID = -1033987837;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageReplyToExternalMessage final : public InputMessageReplyTo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<inputTextQuote> quote_;

  inputMessageReplyToExternalMessage();

  inputMessageReplyToExternalMessage(int53 chat_id_, int53 message_id_, object_ptr<inputTextQuote> &&quote_);

  static const std::int32_t ID = -1993530582;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputMessageReplyToStory final : public InputMessageReplyTo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;

  inputMessageReplyToStory();

  inputMessageReplyToStory(int53 story_poster_chat_id_, int32 story_id_);

  static const std::int32_t ID = -1723842320;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class InputPaidMediaType;

class inputThumbnail;

class inputPaidMedia final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputPaidMediaType> type_;
  object_ptr<InputFile> media_;
  object_ptr<inputThumbnail> thumbnail_;
  array<int32> added_sticker_file_ids_;
  int32 width_;
  int32 height_;

  inputPaidMedia();

  inputPaidMedia(object_ptr<InputPaidMediaType> &&type_, object_ptr<InputFile> &&media_, object_ptr<inputThumbnail> &&thumbnail_, array<int32> &&added_sticker_file_ids_, int32 width_, int32 height_);

  static const std::int32_t ID = 475844035;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class InputPaidMediaType: public Object {
 public:
};

class inputPaidMediaTypePhoto final : public InputPaidMediaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  inputPaidMediaTypePhoto();

  static const std::int32_t ID = -761660134;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPaidMediaTypeVideo final : public InputPaidMediaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> cover_;
  int32 start_timestamp_;
  int32 duration_;
  bool supports_streaming_;

  inputPaidMediaTypeVideo();

  inputPaidMediaTypeVideo(object_ptr<InputFile> &&cover_, int32 start_timestamp_, int32 duration_, bool supports_streaming_);

  static const std::int32_t ID = 1793741625;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class address;

class inputIdentityDocument;

class inputPersonalDocument;

class personalDetails;

class InputPassportElement: public Object {
 public:
};

class inputPassportElementPersonalDetails final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<personalDetails> personal_details_;

  inputPassportElementPersonalDetails();

  explicit inputPassportElementPersonalDetails(object_ptr<personalDetails> &&personal_details_);

  static const std::int32_t ID = 164791359;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementPassport final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputIdentityDocument> passport_;

  inputPassportElementPassport();

  explicit inputPassportElementPassport(object_ptr<inputIdentityDocument> &&passport_);

  static const std::int32_t ID = -497011356;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementDriverLicense final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputIdentityDocument> driver_license_;

  inputPassportElementDriverLicense();

  explicit inputPassportElementDriverLicense(object_ptr<inputIdentityDocument> &&driver_license_);

  static const std::int32_t ID = 304813264;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementIdentityCard final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputIdentityDocument> identity_card_;

  inputPassportElementIdentityCard();

  explicit inputPassportElementIdentityCard(object_ptr<inputIdentityDocument> &&identity_card_);

  static const std::int32_t ID = -9963390;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementInternalPassport final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputIdentityDocument> internal_passport_;

  inputPassportElementInternalPassport();

  explicit inputPassportElementInternalPassport(object_ptr<inputIdentityDocument> &&internal_passport_);

  static const std::int32_t ID = 715360043;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementAddress final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<address> address_;

  inputPassportElementAddress();

  explicit inputPassportElementAddress(object_ptr<address> &&address_);

  static const std::int32_t ID = 461630480;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementUtilityBill final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputPersonalDocument> utility_bill_;

  inputPassportElementUtilityBill();

  explicit inputPassportElementUtilityBill(object_ptr<inputPersonalDocument> &&utility_bill_);

  static const std::int32_t ID = 1389203841;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementBankStatement final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputPersonalDocument> bank_statement_;

  inputPassportElementBankStatement();

  explicit inputPassportElementBankStatement(object_ptr<inputPersonalDocument> &&bank_statement_);

  static const std::int32_t ID = -26585208;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementRentalAgreement final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputPersonalDocument> rental_agreement_;

  inputPassportElementRentalAgreement();

  explicit inputPassportElementRentalAgreement(object_ptr<inputPersonalDocument> &&rental_agreement_);

  static const std::int32_t ID = 1736154155;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementPassportRegistration final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputPersonalDocument> passport_registration_;

  inputPassportElementPassportRegistration();

  explicit inputPassportElementPassportRegistration(object_ptr<inputPersonalDocument> &&passport_registration_);

  static const std::int32_t ID = 1314562128;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementTemporaryRegistration final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputPersonalDocument> temporary_registration_;

  inputPassportElementTemporaryRegistration();

  explicit inputPassportElementTemporaryRegistration(object_ptr<inputPersonalDocument> &&temporary_registration_);

  static const std::int32_t ID = -1913238047;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementPhoneNumber final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;

  inputPassportElementPhoneNumber();

  explicit inputPassportElementPhoneNumber(string const &phone_number_);

  static const std::int32_t ID = 1319357497;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementEmailAddress final : public InputPassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string email_address_;

  inputPassportElementEmailAddress();

  explicit inputPassportElementEmailAddress(string const &email_address_);

  static const std::int32_t ID = -248605659;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPassportElementErrorSource;

class PassportElementType;

class inputPassportElementError final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PassportElementType> type_;
  string message_;
  object_ptr<InputPassportElementErrorSource> source_;

  inputPassportElementError();

  inputPassportElementError(object_ptr<PassportElementType> &&type_, string const &message_, object_ptr<InputPassportElementErrorSource> &&source_);

  static const std::int32_t ID = 285756898;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputPassportElementErrorSource: public Object {
 public:
};

class inputPassportElementErrorSourceUnspecified final : public InputPassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes element_hash_;

  inputPassportElementErrorSourceUnspecified();

  explicit inputPassportElementErrorSourceUnspecified(bytes const &element_hash_);

  static const std::int32_t ID = 267230319;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementErrorSourceDataField final : public InputPassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string field_name_;
  bytes data_hash_;

  inputPassportElementErrorSourceDataField();

  inputPassportElementErrorSourceDataField(string const &field_name_, bytes const &data_hash_);

  static const std::int32_t ID = -426795002;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementErrorSourceFrontSide final : public InputPassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes file_hash_;

  inputPassportElementErrorSourceFrontSide();

  explicit inputPassportElementErrorSourceFrontSide(bytes const &file_hash_);

  static const std::int32_t ID = 588023741;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementErrorSourceReverseSide final : public InputPassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes file_hash_;

  inputPassportElementErrorSourceReverseSide();

  explicit inputPassportElementErrorSourceReverseSide(bytes const &file_hash_);

  static const std::int32_t ID = 413072891;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementErrorSourceSelfie final : public InputPassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes file_hash_;

  inputPassportElementErrorSourceSelfie();

  explicit inputPassportElementErrorSourceSelfie(bytes const &file_hash_);

  static const std::int32_t ID = -773575528;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementErrorSourceTranslationFile final : public InputPassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes file_hash_;

  inputPassportElementErrorSourceTranslationFile();

  explicit inputPassportElementErrorSourceTranslationFile(bytes const &file_hash_);

  static const std::int32_t ID = 505842299;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementErrorSourceTranslationFiles final : public InputPassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<bytes> file_hashes_;

  inputPassportElementErrorSourceTranslationFiles();

  explicit inputPassportElementErrorSourceTranslationFiles(array<bytes> &&file_hashes_);

  static const std::int32_t ID = -527254048;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementErrorSourceFile final : public InputPassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes file_hash_;

  inputPassportElementErrorSourceFile();

  explicit inputPassportElementErrorSourceFile(bytes const &file_hash_);

  static const std::int32_t ID = -298492469;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputPassportElementErrorSourceFiles final : public InputPassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<bytes> file_hashes_;

  inputPassportElementErrorSourceFiles();

  explicit inputPassportElementErrorSourceFiles(array<bytes> &&file_hashes_);

  static const std::int32_t ID = -2008541640;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class inputPersonalDocument final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<InputFile>> files_;
  array<object_ptr<InputFile>> translation_;

  inputPersonalDocument();

  inputPersonalDocument(array<object_ptr<InputFile>> &&files_, array<object_ptr<InputFile>> &&translation_);

  static const std::int32_t ID = 1676966826;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class StickerFormat;

class maskPosition;

class inputSticker final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> sticker_;
  object_ptr<StickerFormat> format_;
  string emojis_;
  object_ptr<maskPosition> mask_position_;
  array<string> keywords_;

  inputSticker();

  inputSticker(object_ptr<InputFile> &&sticker_, object_ptr<StickerFormat> &&format_, string const &emojis_, object_ptr<maskPosition> &&mask_position_, array<string> &&keywords_);

  static const std::int32_t ID = 1589392402;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputStoryAreaType;

class storyAreaPosition;

class inputStoryArea final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<storyAreaPosition> position_;
  object_ptr<InputStoryAreaType> type_;

  inputStoryArea();

  inputStoryArea(object_ptr<storyAreaPosition> &&position_, object_ptr<InputStoryAreaType> &&type_);

  static const std::int32_t ID = 122859135;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType;

class location;

class locationAddress;

class InputStoryAreaType: public Object {
 public:
};

class inputStoryAreaTypeLocation final : public InputStoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;
  object_ptr<locationAddress> address_;

  inputStoryAreaTypeLocation();

  inputStoryAreaTypeLocation(object_ptr<location> &&location_, object_ptr<locationAddress> &&address_);

  static const std::int32_t ID = -1433714887;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStoryAreaTypeFoundVenue final : public InputStoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 query_id_;
  string result_id_;

  inputStoryAreaTypeFoundVenue();

  inputStoryAreaTypeFoundVenue(int64 query_id_, string const &result_id_);

  static const std::int32_t ID = -1395809130;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStoryAreaTypePreviousVenue final : public InputStoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string venue_provider_;
  string venue_id_;

  inputStoryAreaTypePreviousVenue();

  inputStoryAreaTypePreviousVenue(string const &venue_provider_, string const &venue_id_);

  static const std::int32_t ID = 1846693388;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStoryAreaTypeSuggestedReaction final : public InputStoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionType> reaction_type_;
  bool is_dark_;
  bool is_flipped_;

  inputStoryAreaTypeSuggestedReaction();

  inputStoryAreaTypeSuggestedReaction(object_ptr<ReactionType> &&reaction_type_, bool is_dark_, bool is_flipped_);

  static const std::int32_t ID = 2101826003;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStoryAreaTypeMessage final : public InputStoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  inputStoryAreaTypeMessage();

  inputStoryAreaTypeMessage(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -266607529;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStoryAreaTypeLink final : public InputStoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  inputStoryAreaTypeLink();

  explicit inputStoryAreaTypeLink(string const &url_);

  static const std::int32_t ID = 1408441160;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStoryAreaTypeWeather final : public InputStoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double temperature_;
  string emoji_;
  int32 background_color_;

  inputStoryAreaTypeWeather();

  inputStoryAreaTypeWeather(double temperature_, string const &emoji_, int32 background_color_);

  static const std::int32_t ID = -1212686691;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStoryAreaTypeUpgradedGift final : public InputStoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string gift_name_;

  inputStoryAreaTypeUpgradedGift();

  explicit inputStoryAreaTypeUpgradedGift(string const &gift_name_);

  static const std::int32_t ID = 793059694;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStoryArea;

class inputStoryAreas final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<inputStoryArea>> areas_;

  inputStoryAreas();

  explicit inputStoryAreas(array<object_ptr<inputStoryArea>> &&areas_);

  static const std::int32_t ID = -883247088;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class InputStoryContent: public Object {
 public:
};

class inputStoryContentPhoto final : public InputStoryContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> photo_;
  array<int32> added_sticker_file_ids_;

  inputStoryContentPhoto();

  inputStoryContentPhoto(object_ptr<InputFile> &&photo_, array<int32> &&added_sticker_file_ids_);

  static const std::int32_t ID = -309196727;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputStoryContentVideo final : public InputStoryContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> video_;
  array<int32> added_sticker_file_ids_;
  double duration_;
  double cover_frame_timestamp_;
  bool is_animation_;

  inputStoryContentVideo();

  inputStoryContentVideo(object_ptr<InputFile> &&video_, array<int32> &&added_sticker_file_ids_, double duration_, double cover_frame_timestamp_, bool is_animation_);

  static const std::int32_t ID = 3809243;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class inputTextQuote final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  int32 position_;

  inputTextQuote();

  inputTextQuote(object_ptr<formattedText> &&text_, int32 position_);

  static const std::int32_t ID = -1219859172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class inputThumbnail final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> thumbnail_;
  int32 width_;
  int32 height_;

  inputThumbnail();

  inputThumbnail(object_ptr<InputFile> &&thumbnail_, int32 width_, int32 height_);

  static const std::int32_t ID = 1582387236;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ProxyType;

class TargetChat;

class WebAppOpenMode;

class chatAdministratorRights;

class formattedText;

class InternalLinkType: public Object {
 public:
};

class internalLinkTypeActiveSessions final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeActiveSessions();

  static const std::int32_t ID = 1886108589;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeAttachmentMenuBot final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<TargetChat> target_chat_;
  string bot_username_;
  string url_;

  internalLinkTypeAttachmentMenuBot();

  internalLinkTypeAttachmentMenuBot(object_ptr<TargetChat> &&target_chat_, string const &bot_username_, string const &url_);

  static const std::int32_t ID = 1682719269;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeAuthenticationCode final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  internalLinkTypeAuthenticationCode();

  explicit internalLinkTypeAuthenticationCode(string const &code_);

  static const std::int32_t ID = -209235982;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeBackground final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string background_name_;

  internalLinkTypeBackground();

  explicit internalLinkTypeBackground(string const &background_name_);

  static const std::int32_t ID = 185411848;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeBotAddToChannel final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string bot_username_;
  object_ptr<chatAdministratorRights> administrator_rights_;

  internalLinkTypeBotAddToChannel();

  internalLinkTypeBotAddToChannel(string const &bot_username_, object_ptr<chatAdministratorRights> &&administrator_rights_);

  static const std::int32_t ID = 1401602752;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeBotStart final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string bot_username_;
  string start_parameter_;
  bool autostart_;

  internalLinkTypeBotStart();

  internalLinkTypeBotStart(string const &bot_username_, string const &start_parameter_, bool autostart_);

  static const std::int32_t ID = 1066950637;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeBotStartInGroup final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string bot_username_;
  string start_parameter_;
  object_ptr<chatAdministratorRights> administrator_rights_;

  internalLinkTypeBotStartInGroup();

  internalLinkTypeBotStartInGroup(string const &bot_username_, string const &start_parameter_, object_ptr<chatAdministratorRights> &&administrator_rights_);

  static const std::int32_t ID = -905081650;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeBusinessChat final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_name_;

  internalLinkTypeBusinessChat();

  explicit internalLinkTypeBusinessChat(string const &link_name_);

  static const std::int32_t ID = -1606751785;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeBuyStars final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;
  string purpose_;

  internalLinkTypeBuyStars();

  internalLinkTypeBuyStars(int53 star_count_, string const &purpose_);

  static const std::int32_t ID = -1454587065;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeChangePhoneNumber final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeChangePhoneNumber();

  static const std::int32_t ID = -265856255;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeChatAffiliateProgram final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string username_;
  string referrer_;

  internalLinkTypeChatAffiliateProgram();

  internalLinkTypeChatAffiliateProgram(string const &username_, string const &referrer_);

  static const std::int32_t ID = 632049700;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeChatBoost final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  internalLinkTypeChatBoost();

  explicit internalLinkTypeChatBoost(string const &url_);

  static const std::int32_t ID = -716571328;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeChatFolderInvite final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;

  internalLinkTypeChatFolderInvite();

  explicit internalLinkTypeChatFolderInvite(string const &invite_link_);

  static const std::int32_t ID = -1984804546;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeChatFolderSettings final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeChatFolderSettings();

  static const std::int32_t ID = -1073805988;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeChatInvite final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;

  internalLinkTypeChatInvite();

  explicit internalLinkTypeChatInvite(string const &invite_link_);

  static const std::int32_t ID = 428621017;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeDefaultMessageAutoDeleteTimerSettings final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeDefaultMessageAutoDeleteTimerSettings();

  static const std::int32_t ID = 732625201;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeEditProfileSettings final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeEditProfileSettings();

  static const std::int32_t ID = -1022472090;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeGame final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string bot_username_;
  string game_short_name_;

  internalLinkTypeGame();

  internalLinkTypeGame(string const &bot_username_, string const &game_short_name_);

  static const std::int32_t ID = -260788787;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeGroupCall final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;

  internalLinkTypeGroupCall();

  explicit internalLinkTypeGroupCall(string const &invite_link_);

  static const std::int32_t ID = 1953084438;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeInstantView final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string fallback_url_;

  internalLinkTypeInstantView();

  internalLinkTypeInstantView(string const &url_, string const &fallback_url_);

  static const std::int32_t ID = 1776607039;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeInvoice final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invoice_name_;

  internalLinkTypeInvoice();

  explicit internalLinkTypeInvoice(string const &invoice_name_);

  static const std::int32_t ID = -213094996;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeLanguagePack final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string language_pack_id_;

  internalLinkTypeLanguagePack();

  explicit internalLinkTypeLanguagePack(string const &language_pack_id_);

  static const std::int32_t ID = -1450766996;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeLanguageSettings final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeLanguageSettings();

  static const std::int32_t ID = -1340479770;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeMainWebApp final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string bot_username_;
  string start_parameter_;
  object_ptr<WebAppOpenMode> mode_;

  internalLinkTypeMainWebApp();

  internalLinkTypeMainWebApp(string const &bot_username_, string const &start_parameter_, object_ptr<WebAppOpenMode> &&mode_);

  static const std::int32_t ID = 1574925033;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeMessage final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  internalLinkTypeMessage();

  explicit internalLinkTypeMessage(string const &url_);

  static const std::int32_t ID = 978541650;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeMessageDraft final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  bool contains_link_;

  internalLinkTypeMessageDraft();

  internalLinkTypeMessageDraft(object_ptr<formattedText> &&text_, bool contains_link_);

  static const std::int32_t ID = 661633749;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeMyStars final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeMyStars();

  static const std::int32_t ID = 1613887070;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypePassportDataRequest final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string scope_;
  string public_key_;
  string nonce_;
  string callback_url_;

  internalLinkTypePassportDataRequest();

  internalLinkTypePassportDataRequest(int53 bot_user_id_, string const &scope_, string const &public_key_, string const &nonce_, string const &callback_url_);

  static const std::int32_t ID = -988819839;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypePhoneNumberConfirmation final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string hash_;
  string phone_number_;

  internalLinkTypePhoneNumberConfirmation();

  internalLinkTypePhoneNumberConfirmation(string const &hash_, string const &phone_number_);

  static const std::int32_t ID = 1757375254;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypePremiumFeatures final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string referrer_;

  internalLinkTypePremiumFeatures();

  explicit internalLinkTypePremiumFeatures(string const &referrer_);

  static const std::int32_t ID = 1216892745;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypePremiumGift final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string referrer_;

  internalLinkTypePremiumGift();

  explicit internalLinkTypePremiumGift(string const &referrer_);

  static const std::int32_t ID = 1523936577;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypePremiumGiftCode final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  internalLinkTypePremiumGiftCode();

  explicit internalLinkTypePremiumGiftCode(string const &code_);

  static const std::int32_t ID = -564356974;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypePrivacyAndSecuritySettings final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypePrivacyAndSecuritySettings();

  static const std::int32_t ID = -1386255665;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeProxy final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string server_;
  int32 port_;
  object_ptr<ProxyType> type_;

  internalLinkTypeProxy();

  internalLinkTypeProxy(string const &server_, int32 port_, object_ptr<ProxyType> &&type_);

  static const std::int32_t ID = -1313788694;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypePublicChat final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string chat_username_;
  string draft_text_;
  bool open_profile_;

  internalLinkTypePublicChat();

  internalLinkTypePublicChat(string const &chat_username_, string const &draft_text_, bool open_profile_);

  static const std::int32_t ID = 1769614592;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeQrCodeAuthentication final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeQrCodeAuthentication();

  static const std::int32_t ID = -1089332956;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeRestorePurchases final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeRestorePurchases();

  static const std::int32_t ID = 606090371;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeSettings final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeSettings();

  static const std::int32_t ID = 393561524;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeStickerSet final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string sticker_set_name_;
  bool expect_custom_emoji_;

  internalLinkTypeStickerSet();

  internalLinkTypeStickerSet(string const &sticker_set_name_, bool expect_custom_emoji_);

  static const std::int32_t ID = -1589227614;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeStory final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string story_poster_username_;
  int32 story_id_;

  internalLinkTypeStory();

  internalLinkTypeStory(string const &story_poster_username_, int32 story_id_);

  static const std::int32_t ID = 1852042869;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeTheme final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string theme_name_;

  internalLinkTypeTheme();

  explicit internalLinkTypeTheme(string const &theme_name_);

  static const std::int32_t ID = -200935417;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeThemeSettings final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeThemeSettings();

  static const std::int32_t ID = -1051903722;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeUnknownDeepLink final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  internalLinkTypeUnknownDeepLink();

  explicit internalLinkTypeUnknownDeepLink(string const &link_);

  static const std::int32_t ID = 625596379;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeUnsupportedProxy final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  internalLinkTypeUnsupportedProxy();

  static const std::int32_t ID = -566649079;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeUpgradedGift final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  internalLinkTypeUpgradedGift();

  explicit internalLinkTypeUpgradedGift(string const &name_);

  static const std::int32_t ID = -708405605;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeUserPhoneNumber final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;
  string draft_text_;
  bool open_profile_;

  internalLinkTypeUserPhoneNumber();

  internalLinkTypeUserPhoneNumber(string const &phone_number_, string const &draft_text_, bool open_profile_);

  static const std::int32_t ID = 273398536;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeUserToken final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  internalLinkTypeUserToken();

  explicit internalLinkTypeUserToken(string const &token_);

  static const std::int32_t ID = -1462248615;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeVideoChat final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string chat_username_;
  string invite_hash_;
  bool is_live_stream_;

  internalLinkTypeVideoChat();

  internalLinkTypeVideoChat(string const &chat_username_, string const &invite_hash_, bool is_live_stream_);

  static const std::int32_t ID = -2020149068;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class internalLinkTypeWebApp final : public InternalLinkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string bot_username_;
  string web_app_short_name_;
  string start_parameter_;
  object_ptr<WebAppOpenMode> mode_;

  internalLinkTypeWebApp();

  internalLinkTypeWebApp(string const &bot_username_, string const &web_app_short_name_, string const &start_parameter_, object_ptr<WebAppOpenMode> &&mode_);

  static const std::int32_t ID = 2062112045;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InviteGroupCallParticipantResult: public Object {
 public:
};

class inviteGroupCallParticipantResultUserPrivacyRestricted final : public InviteGroupCallParticipantResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  inviteGroupCallParticipantResultUserPrivacyRestricted();

  static const std::int32_t ID = 53003769;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inviteGroupCallParticipantResultUserAlreadyParticipant final : public InviteGroupCallParticipantResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  inviteGroupCallParticipantResultUserAlreadyParticipant();

  static const std::int32_t ID = 661526151;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inviteGroupCallParticipantResultUserWasBanned final : public InviteGroupCallParticipantResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  inviteGroupCallParticipantResultUserWasBanned();

  static const std::int32_t ID = -204345357;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inviteGroupCallParticipantResultSuccess final : public InviteGroupCallParticipantResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  inviteGroupCallParticipantResultSuccess();

  inviteGroupCallParticipantResultSuccess(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -1914309427;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InviteLinkChatType: public Object {
 public:
};

class inviteLinkChatTypeBasicGroup final : public InviteLinkChatType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  inviteLinkChatTypeBasicGroup();

  static const std::int32_t ID = 1296287214;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inviteLinkChatTypeSupergroup final : public InviteLinkChatType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  inviteLinkChatTypeSupergroup();

  static const std::int32_t ID = 1038640984;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inviteLinkChatTypeChannel final : public InviteLinkChatType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  inviteLinkChatTypeChannel();

  static const std::int32_t ID = 806547211;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class labeledPricePart;

class invoice final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  array<object_ptr<labeledPricePart>> price_parts_;
  int32 subscription_period_;
  int53 max_tip_amount_;
  array<int53> suggested_tip_amounts_;
  string recurring_payment_terms_of_service_url_;
  string terms_of_service_url_;
  bool is_test_;
  bool need_name_;
  bool need_phone_number_;
  bool need_email_address_;
  bool need_shipping_address_;
  bool send_phone_number_to_provider_;
  bool send_email_address_to_provider_;
  bool is_flexible_;

  invoice();

  invoice(string const &currency_, array<object_ptr<labeledPricePart>> &&price_parts_, int32 subscription_period_, int53 max_tip_amount_, array<int53> &&suggested_tip_amounts_, string const &recurring_payment_terms_of_service_url_, string const &terms_of_service_url_, bool is_test_, bool need_name_, bool need_phone_number_, bool need_email_address_, bool need_shipping_address_, bool send_phone_number_to_provider_, bool send_email_address_to_provider_, bool is_flexible_);

  static const std::int32_t ID = 113204876;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class JsonValue;

class jsonObjectMember final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string key_;
  object_ptr<JsonValue> value_;

  jsonObjectMember();

  jsonObjectMember(string const &key_, object_ptr<JsonValue> &&value_);

  static const std::int32_t ID = -1803309418;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class JsonValue;

class jsonObjectMember;

class JsonValue: public Object {
 public:
};

class jsonValueNull final : public JsonValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  jsonValueNull();

  static const std::int32_t ID = -92872499;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonValueBoolean final : public JsonValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool value_;

  jsonValueBoolean();

  explicit jsonValueBoolean(bool value_);

  static const std::int32_t ID = -2142186576;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonValueNumber final : public JsonValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double value_;

  jsonValueNumber();

  explicit jsonValueNumber(double value_);

  static const std::int32_t ID = -1010822033;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonValueString final : public JsonValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string value_;

  jsonValueString();

  explicit jsonValueString(string const &value_);

  static const std::int32_t ID = 1597947313;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonValueArray final : public JsonValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<JsonValue>> values_;

  jsonValueArray();

  explicit jsonValueArray(array<object_ptr<JsonValue>> &&values_);

  static const std::int32_t ID = -183913546;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class jsonValueObject final : public JsonValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<jsonObjectMember>> members_;

  jsonValueObject();

  explicit jsonValueObject(array<object_ptr<jsonObjectMember>> &&members_);

  static const std::int32_t ID = 520252026;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class KeyboardButtonType;

class keyboardButton final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  object_ptr<KeyboardButtonType> type_;

  keyboardButton();

  keyboardButton(string const &text_, object_ptr<KeyboardButtonType> &&type_);

  static const std::int32_t ID = -2069836172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAdministratorRights;

class KeyboardButtonType: public Object {
 public:
};

class keyboardButtonTypeText final : public KeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  keyboardButtonTypeText();

  static const std::int32_t ID = -1773037256;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonTypeRequestPhoneNumber final : public KeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  keyboardButtonTypeRequestPhoneNumber();

  static const std::int32_t ID = -1529235527;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonTypeRequestLocation final : public KeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  keyboardButtonTypeRequestLocation();

  static const std::int32_t ID = -125661955;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonTypeRequestPoll final : public KeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool force_regular_;
  bool force_quiz_;

  keyboardButtonTypeRequestPoll();

  keyboardButtonTypeRequestPoll(bool force_regular_, bool force_quiz_);

  static const std::int32_t ID = 1902435512;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonTypeRequestUsers final : public KeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  bool restrict_user_is_bot_;
  bool user_is_bot_;
  bool restrict_user_is_premium_;
  bool user_is_premium_;
  int32 max_quantity_;
  bool request_name_;
  bool request_username_;
  bool request_photo_;

  keyboardButtonTypeRequestUsers();

  keyboardButtonTypeRequestUsers(int32 id_, bool restrict_user_is_bot_, bool user_is_bot_, bool restrict_user_is_premium_, bool user_is_premium_, int32 max_quantity_, bool request_name_, bool request_username_, bool request_photo_);

  static const std::int32_t ID = -1738765315;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonTypeRequestChat final : public KeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  bool chat_is_channel_;
  bool restrict_chat_is_forum_;
  bool chat_is_forum_;
  bool restrict_chat_has_username_;
  bool chat_has_username_;
  bool chat_is_created_;
  object_ptr<chatAdministratorRights> user_administrator_rights_;
  object_ptr<chatAdministratorRights> bot_administrator_rights_;
  bool bot_is_member_;
  bool request_title_;
  bool request_username_;
  bool request_photo_;

  keyboardButtonTypeRequestChat();

  keyboardButtonTypeRequestChat(int32 id_, bool chat_is_channel_, bool restrict_chat_is_forum_, bool chat_is_forum_, bool restrict_chat_has_username_, bool chat_has_username_, bool chat_is_created_, object_ptr<chatAdministratorRights> &&user_administrator_rights_, object_ptr<chatAdministratorRights> &&bot_administrator_rights_, bool bot_is_member_, bool request_title_, bool request_username_, bool request_photo_);

  static const std::int32_t ID = 1511138485;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class keyboardButtonTypeWebApp final : public KeyboardButtonType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  keyboardButtonTypeWebApp();

  explicit keyboardButtonTypeWebApp(string const &url_);

  static const std::int32_t ID = 1892220770;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class labeledPricePart final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string label_;
  int53 amount_;

  labeledPricePart();

  labeledPricePart(string const &label_, int53 amount_);

  static const std::int32_t ID = 552789798;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class languagePackInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string base_language_pack_id_;
  string name_;
  string native_name_;
  string plural_code_;
  bool is_official_;
  bool is_rtl_;
  bool is_beta_;
  bool is_installed_;
  int32 total_string_count_;
  int32 translated_string_count_;
  int32 local_string_count_;
  string translation_url_;

  languagePackInfo();

  languagePackInfo(string const &id_, string const &base_language_pack_id_, string const &name_, string const &native_name_, string const &plural_code_, bool is_official_, bool is_rtl_, bool is_beta_, bool is_installed_, int32 total_string_count_, int32 translated_string_count_, int32 local_string_count_, string const &translation_url_);

  static const std::int32_t ID = 542199642;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LanguagePackStringValue;

class languagePackString final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string key_;
  object_ptr<LanguagePackStringValue> value_;

  languagePackString();

  languagePackString(string const &key_, object_ptr<LanguagePackStringValue> &&value_);

  static const std::int32_t ID = 1307632736;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LanguagePackStringValue: public Object {
 public:
};

class languagePackStringValueOrdinary final : public LanguagePackStringValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string value_;

  languagePackStringValueOrdinary();

  explicit languagePackStringValueOrdinary(string const &value_);

  static const std::int32_t ID = -249256352;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class languagePackStringValuePluralized final : public LanguagePackStringValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string zero_value_;
  string one_value_;
  string two_value_;
  string few_value_;
  string many_value_;
  string other_value_;

  languagePackStringValuePluralized();

  languagePackStringValuePluralized(string const &zero_value_, string const &one_value_, string const &two_value_, string const &few_value_, string const &many_value_, string const &other_value_);

  static const std::int32_t ID = 1906840261;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class languagePackStringValueDeleted final : public LanguagePackStringValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  languagePackStringValueDeleted();

  static const std::int32_t ID = 1834792698;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class languagePackString;

class languagePackStrings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<languagePackString>> strings_;

  languagePackStrings();

  explicit languagePackStrings(array<object_ptr<languagePackString>> &&strings_);

  static const std::int32_t ID = 1172082922;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LinkPreviewType;

class formattedText;

class linkPreview final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string display_url_;
  string site_name_;
  string title_;
  object_ptr<formattedText> description_;
  string author_;
  object_ptr<LinkPreviewType> type_;
  bool has_large_media_;
  bool show_large_media_;
  bool show_media_above_description_;
  bool skip_confirmation_;
  bool show_above_text_;
  int32 instant_view_version_;

  linkPreview();

  linkPreview(string const &url_, string const &display_url_, string const &site_name_, string const &title_, object_ptr<formattedText> &&description_, string const &author_, object_ptr<LinkPreviewType> &&type_, bool has_large_media_, bool show_large_media_, bool show_media_above_description_, bool skip_confirmation_, bool show_above_text_, int32 instant_view_version_);

  static const std::int32_t ID = 1729417714;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photo;

class video;

class LinkPreviewAlbumMedia: public Object {
 public:
};

class linkPreviewAlbumMediaPhoto final : public LinkPreviewAlbumMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;

  linkPreviewAlbumMediaPhoto();

  explicit linkPreviewAlbumMediaPhoto(object_ptr<photo> &&photo_);

  static const std::int32_t ID = -935480434;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewAlbumMediaVideo final : public LinkPreviewAlbumMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<video> video_;

  linkPreviewAlbumMediaVideo();

  explicit linkPreviewAlbumMediaVideo(object_ptr<video> &&video_);

  static const std::int32_t ID = 390616795;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewOptions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_disabled_;
  string url_;
  bool force_small_media_;
  bool force_large_media_;
  bool show_above_text_;

  linkPreviewOptions();

  linkPreviewOptions(bool is_disabled_, string const &url_, bool force_small_media_, bool force_large_media_, bool show_above_text_);

  static const std::int32_t ID = 1046590451;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BackgroundType;

class InviteLinkChatType;

class LinkPreviewAlbumMedia;

class animation;

class audio;

class chatPhoto;

class document;

class photo;

class sticker;

class themeSettings;

class upgradedGift;

class video;

class videoNote;

class voiceNote;

class LinkPreviewType: public Object {
 public:
};

class linkPreviewTypeAlbum final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<LinkPreviewAlbumMedia>> media_;
  string caption_;

  linkPreviewTypeAlbum();

  linkPreviewTypeAlbum(array<object_ptr<LinkPreviewAlbumMedia>> &&media_, string const &caption_);

  static const std::int32_t ID = -919156671;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeAnimation final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<animation> animation_;

  linkPreviewTypeAnimation();

  explicit linkPreviewTypeAnimation(object_ptr<animation> &&animation_);

  static const std::int32_t ID = -1386429132;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeApp final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;

  linkPreviewTypeApp();

  explicit linkPreviewTypeApp(object_ptr<photo> &&photo_);

  static const std::int32_t ID = -475623953;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeArticle final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;

  linkPreviewTypeArticle();

  explicit linkPreviewTypeArticle(object_ptr<photo> &&photo_);

  static const std::int32_t ID = 2093915097;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeAudio final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<audio> audio_;

  linkPreviewTypeAudio();

  explicit linkPreviewTypeAudio(object_ptr<audio> &&audio_);

  static const std::int32_t ID = 1977878482;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeBackground final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<document> document_;
  object_ptr<BackgroundType> background_type_;

  linkPreviewTypeBackground();

  linkPreviewTypeBackground(object_ptr<document> &&document_, object_ptr<BackgroundType> &&background_type_);

  static const std::int32_t ID = 977838560;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeChannelBoost final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> photo_;

  linkPreviewTypeChannelBoost();

  explicit linkPreviewTypeChannelBoost(object_ptr<chatPhoto> &&photo_);

  static const std::int32_t ID = -957086634;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeChat final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InviteLinkChatType> type_;
  object_ptr<chatPhoto> photo_;
  bool creates_join_request_;

  linkPreviewTypeChat();

  linkPreviewTypeChat(object_ptr<InviteLinkChatType> &&type_, object_ptr<chatPhoto> &&photo_, bool creates_join_request_);

  static const std::int32_t ID = -1372610270;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeDocument final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<document> document_;

  linkPreviewTypeDocument();

  explicit linkPreviewTypeDocument(object_ptr<document> &&document_);

  static const std::int32_t ID = -1090426462;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeEmbeddedAnimationPlayer final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  object_ptr<photo> thumbnail_;
  int32 duration_;
  int32 width_;
  int32 height_;

  linkPreviewTypeEmbeddedAnimationPlayer();

  linkPreviewTypeEmbeddedAnimationPlayer(string const &url_, object_ptr<photo> &&thumbnail_, int32 duration_, int32 width_, int32 height_);

  static const std::int32_t ID = -1436887547;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeEmbeddedAudioPlayer final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  object_ptr<photo> thumbnail_;
  int32 duration_;
  int32 width_;
  int32 height_;

  linkPreviewTypeEmbeddedAudioPlayer();

  linkPreviewTypeEmbeddedAudioPlayer(string const &url_, object_ptr<photo> &&thumbnail_, int32 duration_, int32 width_, int32 height_);

  static const std::int32_t ID = 571163292;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeEmbeddedVideoPlayer final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  object_ptr<photo> thumbnail_;
  int32 duration_;
  int32 width_;
  int32 height_;

  linkPreviewTypeEmbeddedVideoPlayer();

  linkPreviewTypeEmbeddedVideoPlayer(string const &url_, object_ptr<photo> &&thumbnail_, int32 duration_, int32 width_, int32 height_);

  static const std::int32_t ID = -1480606973;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeExternalAudio final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string mime_type_;
  int32 duration_;

  linkPreviewTypeExternalAudio();

  linkPreviewTypeExternalAudio(string const &url_, string const &mime_type_, int32 duration_);

  static const std::int32_t ID = -1971126291;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeExternalVideo final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string mime_type_;
  int32 width_;
  int32 height_;
  int32 duration_;

  linkPreviewTypeExternalVideo();

  linkPreviewTypeExternalVideo(string const &url_, string const &mime_type_, int32 width_, int32 height_, int32 duration_);

  static const std::int32_t ID = 1367198616;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeGroupCall final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  linkPreviewTypeGroupCall();

  static const std::int32_t ID = -1242459936;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeInvoice final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  linkPreviewTypeInvoice();

  static const std::int32_t ID = -729855782;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeMessage final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  linkPreviewTypeMessage();

  static const std::int32_t ID = 435470750;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypePhoto final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;

  linkPreviewTypePhoto();

  explicit linkPreviewTypePhoto(object_ptr<photo> &&photo_);

  static const std::int32_t ID = -1362122068;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypePremiumGiftCode final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  linkPreviewTypePremiumGiftCode();

  static const std::int32_t ID = 1309507761;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeShareableChatFolder final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  linkPreviewTypeShareableChatFolder();

  static const std::int32_t ID = -2141539524;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeSticker final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<sticker> sticker_;

  linkPreviewTypeSticker();

  explicit linkPreviewTypeSticker(object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = 610225445;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeStickerSet final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<sticker>> stickers_;

  linkPreviewTypeStickerSet();

  explicit linkPreviewTypeStickerSet(array<object_ptr<sticker>> &&stickers_);

  static const std::int32_t ID = -145958768;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeStory final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;

  linkPreviewTypeStory();

  linkPreviewTypeStory(int53 story_poster_chat_id_, int32 story_id_);

  static const std::int32_t ID = 1045709531;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeSupergroupBoost final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> photo_;

  linkPreviewTypeSupergroupBoost();

  explicit linkPreviewTypeSupergroupBoost(object_ptr<chatPhoto> &&photo_);

  static const std::int32_t ID = -1873345418;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeTheme final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<document>> documents_;
  object_ptr<themeSettings> settings_;

  linkPreviewTypeTheme();

  linkPreviewTypeTheme(array<object_ptr<document>> &&documents_, object_ptr<themeSettings> &&settings_);

  static const std::int32_t ID = -226118489;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeUnsupported final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  linkPreviewTypeUnsupported();

  static const std::int32_t ID = 1924738233;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeUpgradedGift final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<upgradedGift> gift_;

  linkPreviewTypeUpgradedGift();

  explicit linkPreviewTypeUpgradedGift(object_ptr<upgradedGift> &&gift_);

  static const std::int32_t ID = 293249807;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeUser final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> photo_;
  bool is_bot_;

  linkPreviewTypeUser();

  linkPreviewTypeUser(object_ptr<chatPhoto> &&photo_, bool is_bot_);

  static const std::int32_t ID = -1465024132;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeVideo final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<video> video_;
  object_ptr<photo> cover_;
  int32 start_timestamp_;

  linkPreviewTypeVideo();

  linkPreviewTypeVideo(object_ptr<video> &&video_, object_ptr<photo> &&cover_, int32 start_timestamp_);

  static const std::int32_t ID = 1573057926;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeVideoChat final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> photo_;
  bool is_live_stream_;

  linkPreviewTypeVideoChat();

  linkPreviewTypeVideoChat(object_ptr<chatPhoto> &&photo_, bool is_live_stream_);

  static const std::int32_t ID = 420015635;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeVideoNote final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<videoNote> video_note_;

  linkPreviewTypeVideoNote();

  explicit linkPreviewTypeVideoNote(object_ptr<videoNote> &&video_note_);

  static const std::int32_t ID = -814687391;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeVoiceNote final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<voiceNote> voice_note_;

  linkPreviewTypeVoiceNote();

  explicit linkPreviewTypeVoiceNote(object_ptr<voiceNote> &&voice_note_);

  static const std::int32_t ID = -757936341;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class linkPreviewTypeWebApp final : public LinkPreviewType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;

  linkPreviewTypeWebApp();

  explicit linkPreviewTypeWebApp(object_ptr<photo> &&photo_);

  static const std::int32_t ID = -1506873462;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class localFile final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string path_;
  bool can_be_downloaded_;
  bool can_be_deleted_;
  bool is_downloading_active_;
  bool is_downloading_completed_;
  int53 download_offset_;
  int53 downloaded_prefix_size_;
  int53 downloaded_size_;

  localFile();

  localFile(string const &path_, bool can_be_downloaded_, bool can_be_deleted_, bool is_downloading_active_, bool is_downloading_completed_, int53 download_offset_, int53 downloaded_prefix_size_, int53 downloaded_size_);

  static const std::int32_t ID = -1562732153;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class languagePackInfo;

class localizationTargetInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<languagePackInfo>> language_packs_;

  localizationTargetInfo();

  explicit localizationTargetInfo(array<object_ptr<languagePackInfo>> &&language_packs_);

  static const std::int32_t ID = -2048670809;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class location final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double latitude_;
  double longitude_;
  double horizontal_accuracy_;

  location();

  location(double latitude_, double longitude_, double horizontal_accuracy_);

  static const std::int32_t ID = -443392141;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class locationAddress final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string country_code_;
  string state_;
  string city_;
  string street_;

  locationAddress();

  locationAddress(string const &country_code_, string const &state_, string const &city_, string const &street_);

  static const std::int32_t ID = -1545940190;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LogStream: public Object {
 public:
};

class logStreamDefault final : public LogStream {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  logStreamDefault();

  static const std::int32_t ID = 1390581436;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class logStreamFile final : public LogStream {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string path_;
  int53 max_file_size_;
  bool redirect_stderr_;

  logStreamFile();

  logStreamFile(string const &path_, int53 max_file_size_, bool redirect_stderr_);

  static const std::int32_t ID = 1532136933;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class logStreamEmpty final : public LogStream {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  logStreamEmpty();

  static const std::int32_t ID = -499912244;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class logTags final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> tags_;

  logTags();

  explicit logTags(array<string> &&tags_);

  static const std::int32_t ID = -1604930601;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class logVerbosityLevel final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 verbosity_level_;

  logVerbosityLevel();

  explicit logVerbosityLevel(int32 verbosity_level_);

  static const std::int32_t ID = 1734624234;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LoginUrlInfo: public Object {
 public:
};

class loginUrlInfoOpen final : public LoginUrlInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  bool skip_confirmation_;

  loginUrlInfoOpen();

  loginUrlInfoOpen(string const &url_, bool skip_confirmation_);

  static const std::int32_t ID = 837282306;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class loginUrlInfoRequestConfirmation final : public LoginUrlInfo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string domain_;
  int53 bot_user_id_;
  bool request_write_access_;

  loginUrlInfoRequestConfirmation();

  loginUrlInfoRequestConfirmation(string const &url_, string const &domain_, int53 bot_user_id_, bool request_write_access_);

  static const std::int32_t ID = 2128290863;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class WebAppOpenMode;

class mainWebApp final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  object_ptr<WebAppOpenMode> mode_;

  mainWebApp();

  mainWebApp(string const &url_, object_ptr<WebAppOpenMode> &&mode_);

  static const std::int32_t ID = 1940368506;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MaskPoint: public Object {
 public:
};

class maskPointForehead final : public MaskPoint {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  maskPointForehead();

  static const std::int32_t ID = 1027512005;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class maskPointEyes final : public MaskPoint {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  maskPointEyes();

  static const std::int32_t ID = 1748310861;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class maskPointMouth final : public MaskPoint {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  maskPointMouth();

  static const std::int32_t ID = 411773406;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class maskPointChin final : public MaskPoint {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  maskPointChin();

  static const std::int32_t ID = 534995335;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MaskPoint;

class maskPosition final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MaskPoint> point_;
  double x_shift_;
  double y_shift_;
  double scale_;

  maskPosition();

  maskPosition(object_ptr<MaskPoint> &&point_, double x_shift_, double y_shift_, double scale_);

  static const std::int32_t ID = -2097433026;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageContent;

class MessageReplyTo;

class MessageSchedulingState;

class MessageSelfDestructType;

class MessageSender;

class MessageSendingState;

class ReplyMarkup;

class factCheck;

class messageForwardInfo;

class messageImportInfo;

class messageInteractionInfo;

class unreadReaction;

class message final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 id_;
  object_ptr<MessageSender> sender_id_;
  int53 chat_id_;
  object_ptr<MessageSendingState> sending_state_;
  object_ptr<MessageSchedulingState> scheduling_state_;
  bool is_outgoing_;
  bool is_pinned_;
  bool is_from_offline_;
  bool can_be_saved_;
  bool has_timestamped_media_;
  bool is_channel_post_;
  bool is_topic_message_;
  bool contains_unread_mention_;
  int32 date_;
  int32 edit_date_;
  object_ptr<messageForwardInfo> forward_info_;
  object_ptr<messageImportInfo> import_info_;
  object_ptr<messageInteractionInfo> interaction_info_;
  array<object_ptr<unreadReaction>> unread_reactions_;
  object_ptr<factCheck> fact_check_;
  object_ptr<MessageReplyTo> reply_to_;
  int53 message_thread_id_;
  int53 saved_messages_topic_id_;
  object_ptr<MessageSelfDestructType> self_destruct_type_;
  double self_destruct_in_;
  double auto_delete_in_;
  int53 via_bot_user_id_;
  int53 sender_business_bot_user_id_;
  int32 sender_boost_count_;
  int53 paid_message_star_count_;
  string author_signature_;
  int64 media_album_id_;
  int64 effect_id_;
  bool has_sensitive_content_;
  string restriction_reason_;
  object_ptr<MessageContent> content_;
  object_ptr<ReplyMarkup> reply_markup_;

  message();

  message(int53 id_, object_ptr<MessageSender> &&sender_id_, int53 chat_id_, object_ptr<MessageSendingState> &&sending_state_, object_ptr<MessageSchedulingState> &&scheduling_state_, bool is_outgoing_, bool is_pinned_, bool is_from_offline_, bool can_be_saved_, bool has_timestamped_media_, bool is_channel_post_, bool is_topic_message_, bool contains_unread_mention_, int32 date_, int32 edit_date_, object_ptr<messageForwardInfo> &&forward_info_, object_ptr<messageImportInfo> &&import_info_, object_ptr<messageInteractionInfo> &&interaction_info_, array<object_ptr<unreadReaction>> &&unread_reactions_, object_ptr<factCheck> &&fact_check_, object_ptr<MessageReplyTo> &&reply_to_, int53 message_thread_id_, int53 saved_messages_topic_id_, object_ptr<MessageSelfDestructType> &&self_destruct_type_, double self_destruct_in_, double auto_delete_in_, int53 via_bot_user_id_, int53 sender_business_bot_user_id_, int32 sender_boost_count_, int53 paid_message_star_count_, string const &author_signature_, int64 media_album_id_, int64 effect_id_, bool has_sensitive_content_, string const &restriction_reason_, object_ptr<MessageContent> &&content_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = 726001662;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageAutoDeleteTime final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 time_;

  messageAutoDeleteTime();

  explicit messageAutoDeleteTime(int32 time_);

  static const std::int32_t ID = 1972045589;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageCalendarDay;

class messageCalendar final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<messageCalendarDay>> days_;

  messageCalendar();

  messageCalendar(int32 total_count_, array<object_ptr<messageCalendarDay>> &&days_);

  static const std::int32_t ID = -1682890519;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class messageCalendarDay final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  object_ptr<message> message_;

  messageCalendarDay();

  messageCalendarDay(int32 total_count_, object_ptr<message> &&message_);

  static const std::int32_t ID = -376467614;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotWriteAccessAllowReason;

class CallDiscardReason;

class DiceStickers;

class GiveawayPrize;

class MessageSender;

class PaidMedia;

class PassportElementType;

class alternativeVideo;

class animatedEmoji;

class animation;

class audio;

class chatBackground;

class chatPhoto;

class contact;

class document;

class encryptedCredentials;

class encryptedPassportElement;

class formattedText;

class forumTopicIcon;

class game;

class gift;

class giveawayParameters;

class linkPreview;

class linkPreviewOptions;

class location;

class orderInfo;

class photo;

class poll;

class productInfo;

class sharedChat;

class sharedUser;

class sticker;

class upgradedGift;

class venue;

class video;

class videoNote;

class voiceNote;

class MessageContent: public Object {
 public:
};

class messageText final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  object_ptr<linkPreview> link_preview_;
  object_ptr<linkPreviewOptions> link_preview_options_;

  messageText();

  messageText(object_ptr<formattedText> &&text_, object_ptr<linkPreview> &&link_preview_, object_ptr<linkPreviewOptions> &&link_preview_options_);

  static const std::int32_t ID = 1751469188;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageAnimation final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<animation> animation_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;
  bool has_spoiler_;
  bool is_secret_;

  messageAnimation();

  messageAnimation(object_ptr<animation> &&animation_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, bool has_spoiler_, bool is_secret_);

  static const std::int32_t ID = -1899294424;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageAudio final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<audio> audio_;
  object_ptr<formattedText> caption_;

  messageAudio();

  messageAudio(object_ptr<audio> &&audio_, object_ptr<formattedText> &&caption_);

  static const std::int32_t ID = 276722716;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageDocument final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<document> document_;
  object_ptr<formattedText> caption_;

  messageDocument();

  messageDocument(object_ptr<document> &&document_, object_ptr<formattedText> &&caption_);

  static const std::int32_t ID = 596945783;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePaidMedia final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;
  array<object_ptr<PaidMedia>> media_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;

  messagePaidMedia();

  messagePaidMedia(int53 star_count_, array<object_ptr<PaidMedia>> &&media_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_);

  static const std::int32_t ID = -724750073;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePhoto final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;
  bool has_spoiler_;
  bool is_secret_;

  messagePhoto();

  messagePhoto(object_ptr<photo> &&photo_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, bool has_spoiler_, bool is_secret_);

  static const std::int32_t ID = 1967947295;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSticker final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<sticker> sticker_;
  bool is_premium_;

  messageSticker();

  messageSticker(object_ptr<sticker> &&sticker_, bool is_premium_);

  static const std::int32_t ID = -437199670;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageVideo final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<video> video_;
  array<object_ptr<alternativeVideo>> alternative_videos_;
  object_ptr<photo> cover_;
  int32 start_timestamp_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;
  bool has_spoiler_;
  bool is_secret_;

  messageVideo();

  messageVideo(object_ptr<video> &&video_, array<object_ptr<alternativeVideo>> &&alternative_videos_, object_ptr<photo> &&cover_, int32 start_timestamp_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_, bool has_spoiler_, bool is_secret_);

  static const std::int32_t ID = 374791437;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageVideoNote final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<videoNote> video_note_;
  bool is_viewed_;
  bool is_secret_;

  messageVideoNote();

  messageVideoNote(object_ptr<videoNote> &&video_note_, bool is_viewed_, bool is_secret_);

  static const std::int32_t ID = 963323014;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageVoiceNote final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<voiceNote> voice_note_;
  object_ptr<formattedText> caption_;
  bool is_listened_;

  messageVoiceNote();

  messageVoiceNote(object_ptr<voiceNote> &&voice_note_, object_ptr<formattedText> &&caption_, bool is_listened_);

  static const std::int32_t ID = 527777781;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageExpiredPhoto final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageExpiredPhoto();

  static const std::int32_t ID = -1404641801;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageExpiredVideo final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageExpiredVideo();

  static const std::int32_t ID = -1212209981;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageExpiredVideoNote final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageExpiredVideoNote();

  static const std::int32_t ID = 599540711;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageExpiredVoiceNote final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageExpiredVoiceNote();

  static const std::int32_t ID = 143684989;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageLocation final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;
  int32 live_period_;
  int32 expires_in_;
  int32 heading_;
  int32 proximity_alert_radius_;

  messageLocation();

  messageLocation(object_ptr<location> &&location_, int32 live_period_, int32 expires_in_, int32 heading_, int32 proximity_alert_radius_);

  static const std::int32_t ID = 303973492;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageVenue final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<venue> venue_;

  messageVenue();

  explicit messageVenue(object_ptr<venue> &&venue_);

  static const std::int32_t ID = -2146492043;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageContact final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<contact> contact_;

  messageContact();

  explicit messageContact(object_ptr<contact> &&contact_);

  static const std::int32_t ID = -512684966;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageAnimatedEmoji final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<animatedEmoji> animated_emoji_;
  string emoji_;

  messageAnimatedEmoji();

  messageAnimatedEmoji(object_ptr<animatedEmoji> &&animated_emoji_, string const &emoji_);

  static const std::int32_t ID = 908195298;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageDice final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<DiceStickers> initial_state_;
  object_ptr<DiceStickers> final_state_;
  string emoji_;
  int32 value_;
  int32 success_animation_frame_number_;

  messageDice();

  messageDice(object_ptr<DiceStickers> &&initial_state_, object_ptr<DiceStickers> &&final_state_, string const &emoji_, int32 value_, int32 success_animation_frame_number_);

  static const std::int32_t ID = 1115779641;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGame final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<game> game_;

  messageGame();

  explicit messageGame(object_ptr<game> &&game_);

  static const std::int32_t ID = -69441162;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePoll final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<poll> poll_;

  messagePoll();

  explicit messagePoll(object_ptr<poll> &&poll_);

  static const std::int32_t ID = -662130099;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageStory final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;
  bool via_mention_;

  messageStory();

  messageStory(int53 story_poster_chat_id_, int32 story_id_, bool via_mention_);

  static const std::int32_t ID = 1514236353;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageInvoice final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<productInfo> product_info_;
  string currency_;
  int53 total_amount_;
  string start_parameter_;
  bool is_test_;
  bool need_shipping_address_;
  int53 receipt_message_id_;
  object_ptr<PaidMedia> paid_media_;
  object_ptr<formattedText> paid_media_caption_;

  messageInvoice();

  messageInvoice(object_ptr<productInfo> &&product_info_, string const &currency_, int53 total_amount_, string const &start_parameter_, bool is_test_, bool need_shipping_address_, int53 receipt_message_id_, object_ptr<PaidMedia> &&paid_media_, object_ptr<formattedText> &&paid_media_caption_);

  static const std::int32_t ID = 263060806;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageCall final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_video_;
  object_ptr<CallDiscardReason> discard_reason_;
  int32 duration_;

  messageCall();

  messageCall(bool is_video_, object_ptr<CallDiscardReason> &&discard_reason_, int32 duration_);

  static const std::int32_t ID = 538893824;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGroupCall final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_active_;
  bool was_missed_;
  bool is_video_;
  int32 duration_;
  array<object_ptr<MessageSender>> other_participant_ids_;

  messageGroupCall();

  messageGroupCall(bool is_active_, bool was_missed_, bool is_video_, int32 duration_, array<object_ptr<MessageSender>> &&other_participant_ids_);

  static const std::int32_t ID = 1370396295;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageVideoChatScheduled final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  int32 start_date_;

  messageVideoChatScheduled();

  messageVideoChatScheduled(int32 group_call_id_, int32 start_date_);

  static const std::int32_t ID = -1855185481;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageVideoChatStarted final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;

  messageVideoChatStarted();

  explicit messageVideoChatStarted(int32 group_call_id_);

  static const std::int32_t ID = 521225561;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageVideoChatEnded final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 duration_;

  messageVideoChatEnded();

  explicit messageVideoChatEnded(int32 duration_);

  static const std::int32_t ID = 2032544855;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageInviteVideoChatParticipants final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  array<int53> user_ids_;

  messageInviteVideoChatParticipants();

  messageInviteVideoChatParticipants(int32 group_call_id_, array<int53> &&user_ids_);

  static const std::int32_t ID = -1459065585;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageBasicGroupChatCreate final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  array<int53> member_user_ids_;

  messageBasicGroupChatCreate();

  messageBasicGroupChatCreate(string const &title_, array<int53> &&member_user_ids_);

  static const std::int32_t ID = 795404060;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSupergroupChatCreate final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;

  messageSupergroupChatCreate();

  explicit messageSupergroupChatCreate(string const &title_);

  static const std::int32_t ID = -434325733;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatChangeTitle final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;

  messageChatChangeTitle();

  explicit messageChatChangeTitle(string const &title_);

  static const std::int32_t ID = 748272449;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatChangePhoto final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> photo_;

  messageChatChangePhoto();

  explicit messageChatChangePhoto(object_ptr<chatPhoto> &&photo_);

  static const std::int32_t ID = -813415093;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatDeletePhoto final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageChatDeletePhoto();

  static const std::int32_t ID = -184374809;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatAddMembers final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> member_user_ids_;

  messageChatAddMembers();

  explicit messageChatAddMembers(array<int53> &&member_user_ids_);

  static const std::int32_t ID = 1701117908;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatJoinByLink final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageChatJoinByLink();

  static const std::int32_t ID = 1846493311;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatJoinByRequest final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageChatJoinByRequest();

  static const std::int32_t ID = 1195428732;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatDeleteMember final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  messageChatDeleteMember();

  explicit messageChatDeleteMember(int53 user_id_);

  static const std::int32_t ID = 938029481;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatUpgradeTo final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;

  messageChatUpgradeTo();

  explicit messageChatUpgradeTo(int53 supergroup_id_);

  static const std::int32_t ID = 104813723;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatUpgradeFrom final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  int53 basic_group_id_;

  messageChatUpgradeFrom();

  messageChatUpgradeFrom(string const &title_, int53 basic_group_id_);

  static const std::int32_t ID = 325954268;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePinMessage final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 message_id_;

  messagePinMessage();

  explicit messagePinMessage(int53 message_id_);

  static const std::int32_t ID = 953503801;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageScreenshotTaken final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageScreenshotTaken();

  static const std::int32_t ID = -1564971605;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatSetBackground final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 old_background_message_id_;
  object_ptr<chatBackground> background_;
  bool only_for_self_;

  messageChatSetBackground();

  messageChatSetBackground(int53 old_background_message_id_, object_ptr<chatBackground> &&background_, bool only_for_self_);

  static const std::int32_t ID = 1029536832;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatSetTheme final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string theme_name_;

  messageChatSetTheme();

  explicit messageChatSetTheme(string const &theme_name_);

  static const std::int32_t ID = -1716612088;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatSetMessageAutoDeleteTime final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 message_auto_delete_time_;
  int53 from_user_id_;

  messageChatSetMessageAutoDeleteTime();

  messageChatSetMessageAutoDeleteTime(int32 message_auto_delete_time_, int53 from_user_id_);

  static const std::int32_t ID = 1637745966;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatBoost final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 boost_count_;

  messageChatBoost();

  explicit messageChatBoost(int32 boost_count_);

  static const std::int32_t ID = 1583310219;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageForumTopicCreated final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<forumTopicIcon> icon_;

  messageForumTopicCreated();

  messageForumTopicCreated(string const &name_, object_ptr<forumTopicIcon> &&icon_);

  static const std::int32_t ID = -1194440751;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageForumTopicEdited final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  bool edit_icon_custom_emoji_id_;
  int64 icon_custom_emoji_id_;

  messageForumTopicEdited();

  messageForumTopicEdited(string const &name_, bool edit_icon_custom_emoji_id_, int64 icon_custom_emoji_id_);

  static const std::int32_t ID = 12629888;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageForumTopicIsClosedToggled final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_closed_;

  messageForumTopicIsClosedToggled();

  explicit messageForumTopicIsClosedToggled(bool is_closed_);

  static const std::int32_t ID = 1264029664;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageForumTopicIsHiddenToggled final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_hidden_;

  messageForumTopicIsHiddenToggled();

  explicit messageForumTopicIsHiddenToggled(bool is_hidden_);

  static const std::int32_t ID = -1751936002;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSuggestProfilePhoto final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> photo_;

  messageSuggestProfilePhoto();

  explicit messageSuggestProfilePhoto(object_ptr<chatPhoto> &&photo_);

  static const std::int32_t ID = -1251926297;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageCustomServiceAction final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  messageCustomServiceAction();

  explicit messageCustomServiceAction(string const &text_);

  static const std::int32_t ID = 1435879282;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGameScore final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 game_message_id_;
  int64 game_id_;
  int32 score_;

  messageGameScore();

  messageGameScore(int53 game_message_id_, int64 game_id_, int32 score_);

  static const std::int32_t ID = 1344904575;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePaymentSuccessful final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 invoice_chat_id_;
  int53 invoice_message_id_;
  string currency_;
  int53 total_amount_;
  int32 subscription_until_date_;
  bool is_recurring_;
  bool is_first_recurring_;
  string invoice_name_;

  messagePaymentSuccessful();

  messagePaymentSuccessful(int53 invoice_chat_id_, int53 invoice_message_id_, string const &currency_, int53 total_amount_, int32 subscription_until_date_, bool is_recurring_, bool is_first_recurring_, string const &invoice_name_);

  static const std::int32_t ID = 1046878481;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePaymentSuccessfulBot final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 total_amount_;
  int32 subscription_until_date_;
  bool is_recurring_;
  bool is_first_recurring_;
  bytes invoice_payload_;
  string shipping_option_id_;
  object_ptr<orderInfo> order_info_;
  string telegram_payment_charge_id_;
  string provider_payment_charge_id_;

  messagePaymentSuccessfulBot();

  messagePaymentSuccessfulBot(string const &currency_, int53 total_amount_, int32 subscription_until_date_, bool is_recurring_, bool is_first_recurring_, bytes const &invoice_payload_, string const &shipping_option_id_, object_ptr<orderInfo> &&order_info_, string const &telegram_payment_charge_id_, string const &provider_payment_charge_id_);

  static const std::int32_t ID = -949596737;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePaymentRefunded final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> owner_id_;
  string currency_;
  int53 total_amount_;
  bytes invoice_payload_;
  string telegram_payment_charge_id_;
  string provider_payment_charge_id_;

  messagePaymentRefunded();

  messagePaymentRefunded(object_ptr<MessageSender> &&owner_id_, string const &currency_, int53 total_amount_, bytes const &invoice_payload_, string const &telegram_payment_charge_id_, string const &provider_payment_charge_id_);

  static const std::int32_t ID = 297580787;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGiftedPremium final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 gifter_user_id_;
  int53 receiver_user_id_;
  object_ptr<formattedText> text_;
  string currency_;
  int53 amount_;
  string cryptocurrency_;
  int64 cryptocurrency_amount_;
  int32 month_count_;
  object_ptr<sticker> sticker_;

  messageGiftedPremium();

  messageGiftedPremium(int53 gifter_user_id_, int53 receiver_user_id_, object_ptr<formattedText> &&text_, string const &currency_, int53 amount_, string const &cryptocurrency_, int64 cryptocurrency_amount_, int32 month_count_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = -456073094;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePremiumGiftCode final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> creator_id_;
  object_ptr<formattedText> text_;
  bool is_from_giveaway_;
  bool is_unclaimed_;
  string currency_;
  int53 amount_;
  string cryptocurrency_;
  int64 cryptocurrency_amount_;
  int32 month_count_;
  object_ptr<sticker> sticker_;
  string code_;

  messagePremiumGiftCode();

  messagePremiumGiftCode(object_ptr<MessageSender> &&creator_id_, object_ptr<formattedText> &&text_, bool is_from_giveaway_, bool is_unclaimed_, string const &currency_, int53 amount_, string const &cryptocurrency_, int64 cryptocurrency_amount_, int32 month_count_, object_ptr<sticker> &&sticker_, string const &code_);

  static const std::int32_t ID = 701640270;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGiveawayCreated final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;

  messageGiveawayCreated();

  explicit messageGiveawayCreated(int53 star_count_);

  static const std::int32_t ID = 972252063;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGiveaway final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<giveawayParameters> parameters_;
  int32 winner_count_;
  object_ptr<GiveawayPrize> prize_;
  object_ptr<sticker> sticker_;

  messageGiveaway();

  messageGiveaway(object_ptr<giveawayParameters> &&parameters_, int32 winner_count_, object_ptr<GiveawayPrize> &&prize_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = -345908568;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGiveawayCompleted final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 giveaway_message_id_;
  int32 winner_count_;
  bool is_star_giveaway_;
  int32 unclaimed_prize_count_;

  messageGiveawayCompleted();

  messageGiveawayCompleted(int53 giveaway_message_id_, int32 winner_count_, bool is_star_giveaway_, int32 unclaimed_prize_count_);

  static const std::int32_t ID = -467351305;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGiveawayWinners final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 boosted_chat_id_;
  int53 giveaway_message_id_;
  int32 additional_chat_count_;
  int32 actual_winners_selection_date_;
  bool only_new_members_;
  bool was_refunded_;
  object_ptr<GiveawayPrize> prize_;
  string prize_description_;
  int32 winner_count_;
  array<int53> winner_user_ids_;
  int32 unclaimed_prize_count_;

  messageGiveawayWinners();

  messageGiveawayWinners(int53 boosted_chat_id_, int53 giveaway_message_id_, int32 additional_chat_count_, int32 actual_winners_selection_date_, bool only_new_members_, bool was_refunded_, object_ptr<GiveawayPrize> &&prize_, string const &prize_description_, int32 winner_count_, array<int53> &&winner_user_ids_, int32 unclaimed_prize_count_);

  static const std::int32_t ID = 2098585405;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGiftedStars final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 gifter_user_id_;
  int53 receiver_user_id_;
  string currency_;
  int53 amount_;
  string cryptocurrency_;
  int64 cryptocurrency_amount_;
  int53 star_count_;
  string transaction_id_;
  object_ptr<sticker> sticker_;

  messageGiftedStars();

  messageGiftedStars(int53 gifter_user_id_, int53 receiver_user_id_, string const &currency_, int53 amount_, string const &cryptocurrency_, int64 cryptocurrency_amount_, int53 star_count_, string const &transaction_id_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = 1102954151;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGiveawayPrizeStars final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;
  string transaction_id_;
  int53 boosted_chat_id_;
  int53 giveaway_message_id_;
  bool is_unclaimed_;
  object_ptr<sticker> sticker_;

  messageGiveawayPrizeStars();

  messageGiveawayPrizeStars(int53 star_count_, string const &transaction_id_, int53 boosted_chat_id_, int53 giveaway_message_id_, bool is_unclaimed_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = -1441833501;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageGift final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<gift> gift_;
  object_ptr<MessageSender> sender_id_;
  string received_gift_id_;
  object_ptr<formattedText> text_;
  int53 sell_star_count_;
  int53 prepaid_upgrade_star_count_;
  bool is_private_;
  bool is_saved_;
  bool can_be_upgraded_;
  bool was_converted_;
  bool was_upgraded_;
  bool was_refunded_;
  string upgraded_received_gift_id_;

  messageGift();

  messageGift(object_ptr<gift> &&gift_, object_ptr<MessageSender> &&sender_id_, string const &received_gift_id_, object_ptr<formattedText> &&text_, int53 sell_star_count_, int53 prepaid_upgrade_star_count_, bool is_private_, bool is_saved_, bool can_be_upgraded_, bool was_converted_, bool was_upgraded_, bool was_refunded_, string const &upgraded_received_gift_id_);

  static const std::int32_t ID = 2090444659;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageUpgradedGift final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<upgradedGift> gift_;
  object_ptr<MessageSender> sender_id_;
  string received_gift_id_;
  bool is_upgrade_;
  bool is_saved_;
  bool can_be_transferred_;
  bool was_transferred_;
  int53 last_resale_star_count_;
  int53 transfer_star_count_;
  int32 next_transfer_date_;
  int32 next_resale_date_;
  int32 export_date_;

  messageUpgradedGift();

  messageUpgradedGift(object_ptr<upgradedGift> &&gift_, object_ptr<MessageSender> &&sender_id_, string const &received_gift_id_, bool is_upgrade_, bool is_saved_, bool can_be_transferred_, bool was_transferred_, int53 last_resale_star_count_, int53 transfer_star_count_, int32 next_transfer_date_, int32 next_resale_date_, int32 export_date_);

  static const std::int32_t ID = -1586797067;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageRefundedUpgradedGift final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<gift> gift_;
  object_ptr<MessageSender> sender_id_;
  bool is_upgrade_;

  messageRefundedUpgradedGift();

  messageRefundedUpgradedGift(object_ptr<gift> &&gift_, object_ptr<MessageSender> &&sender_id_, bool is_upgrade_);

  static const std::int32_t ID = -1308949479;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePaidMessagesRefunded final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 message_count_;
  int53 star_count_;

  messagePaidMessagesRefunded();

  messagePaidMessagesRefunded(int32 message_count_, int53 star_count_);

  static const std::int32_t ID = 580403343;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePaidMessagePriceChanged final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 paid_message_star_count_;

  messagePaidMessagePriceChanged();

  explicit messagePaidMessagePriceChanged(int53 paid_message_star_count_);

  static const std::int32_t ID = -344945397;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageContactRegistered final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageContactRegistered();

  static const std::int32_t ID = -1502020353;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageUsersShared final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<sharedUser>> users_;
  int32 button_id_;

  messageUsersShared();

  messageUsersShared(array<object_ptr<sharedUser>> &&users_, int32 button_id_);

  static const std::int32_t ID = -842442318;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageChatShared final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<sharedChat> chat_;
  int32 button_id_;

  messageChatShared();

  messageChatShared(object_ptr<sharedChat> &&chat_, int32 button_id_);

  static const std::int32_t ID = -1362699935;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageBotWriteAccessAllowed final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BotWriteAccessAllowReason> reason_;

  messageBotWriteAccessAllowed();

  explicit messageBotWriteAccessAllowed(object_ptr<BotWriteAccessAllowReason> &&reason_);

  static const std::int32_t ID = -1702185036;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageWebAppDataSent final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string button_text_;

  messageWebAppDataSent();

  explicit messageWebAppDataSent(string const &button_text_);

  static const std::int32_t ID = -83674862;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageWebAppDataReceived final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string button_text_;
  string data_;

  messageWebAppDataReceived();

  messageWebAppDataReceived(string const &button_text_, string const &data_);

  static const std::int32_t ID = -8578539;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePassportDataSent final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PassportElementType>> types_;

  messagePassportDataSent();

  explicit messagePassportDataSent(array<object_ptr<PassportElementType>> &&types_);

  static const std::int32_t ID = 1017405171;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePassportDataReceived final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<encryptedPassportElement>> elements_;
  object_ptr<encryptedCredentials> credentials_;

  messagePassportDataReceived();

  messagePassportDataReceived(array<object_ptr<encryptedPassportElement>> &&elements_, object_ptr<encryptedCredentials> &&credentials_);

  static const std::int32_t ID = -1367863624;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageProximityAlertTriggered final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> traveler_id_;
  object_ptr<MessageSender> watcher_id_;
  int32 distance_;

  messageProximityAlertTriggered();

  messageProximityAlertTriggered(object_ptr<MessageSender> &&traveler_id_, object_ptr<MessageSender> &&watcher_id_, int32 distance_);

  static const std::int32_t ID = 67761875;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageUnsupported final : public MessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageUnsupported();

  static const std::int32_t ID = -1816726139;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class messageCopyOptions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool send_copy_;
  bool replace_caption_;
  object_ptr<formattedText> new_caption_;
  bool new_show_caption_above_media_;

  messageCopyOptions();

  messageCopyOptions(bool send_copy_, bool replace_caption_, object_ptr<formattedText> &&new_caption_, bool new_show_caption_above_media_);

  static const std::int32_t ID = 1079772090;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageEffectType;

class sticker;

class messageEffect final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  object_ptr<sticker> static_icon_;
  string emoji_;
  bool is_premium_;
  object_ptr<MessageEffectType> type_;

  messageEffect();

  messageEffect(int64 id_, object_ptr<sticker> &&static_icon_, string const &emoji_, bool is_premium_, object_ptr<MessageEffectType> &&type_);

  static const std::int32_t ID = -1758836433;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class MessageEffectType: public Object {
 public:
};

class messageEffectTypeEmojiReaction final : public MessageEffectType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<sticker> select_animation_;
  object_ptr<sticker> effect_animation_;

  messageEffectTypeEmojiReaction();

  messageEffectTypeEmojiReaction(object_ptr<sticker> &&select_animation_, object_ptr<sticker> &&effect_animation_);

  static const std::int32_t ID = 1756079678;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEffectTypePremiumSticker final : public MessageEffectType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<sticker> sticker_;

  messageEffectTypePremiumSticker();

  explicit messageEffectTypePremiumSticker(object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = 1637231609;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageFileType: public Object {
 public:
};

class messageFileTypePrivate final : public MessageFileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  messageFileTypePrivate();

  explicit messageFileTypePrivate(string const &name_);

  static const std::int32_t ID = -521908524;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageFileTypeGroup final : public MessageFileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;

  messageFileTypeGroup();

  explicit messageFileTypeGroup(string const &title_);

  static const std::int32_t ID = -219836568;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageFileTypeUnknown final : public MessageFileType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageFileTypeUnknown();

  static const std::int32_t ID = 1176353458;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageOrigin;

class forwardSource;

class messageForwardInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageOrigin> origin_;
  int32 date_;
  object_ptr<forwardSource> source_;
  string public_service_announcement_type_;

  messageForwardInfo();

  messageForwardInfo(object_ptr<MessageOrigin> &&origin_, int32 date_, object_ptr<forwardSource> &&source_, string const &public_service_announcement_type_);

  static const std::int32_t ID = -880313475;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageImportInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string sender_name_;
  int32 date_;

  messageImportInfo();

  messageImportInfo(string const &sender_name_, int32 date_);

  static const std::int32_t ID = -421549105;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReactions;

class messageReplyInfo;

class messageInteractionInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 view_count_;
  int32 forward_count_;
  object_ptr<messageReplyInfo> reply_info_;
  object_ptr<messageReactions> reactions_;

  messageInteractionInfo();

  messageInteractionInfo(int32 view_count_, int32 forward_count_, object_ptr<messageReplyInfo> &&reply_info_, object_ptr<messageReactions> &&reactions_);

  static const std::int32_t ID = 733797893;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;
  bool is_public_;

  messageLink();

  messageLink(string const &link_, bool is_public_);

  static const std::int32_t ID = -1354089818;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class messageLinkInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_public_;
  int53 chat_id_;
  int53 message_thread_id_;
  object_ptr<message> message_;
  int32 media_timestamp_;
  bool for_album_;

  messageLinkInfo();

  messageLinkInfo(bool is_public_, int53 chat_id_, int53 message_thread_id_, object_ptr<message> &&message_, int32 media_timestamp_, bool for_album_);

  static const std::int32_t ID = 731315024;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageOrigin: public Object {
 public:
};

class messageOriginUser final : public MessageOrigin {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 sender_user_id_;

  messageOriginUser();

  explicit messageOriginUser(int53 sender_user_id_);

  static const std::int32_t ID = -1677684669;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageOriginHiddenUser final : public MessageOrigin {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string sender_name_;

  messageOriginHiddenUser();

  explicit messageOriginHiddenUser(string const &sender_name_);

  static const std::int32_t ID = -317971494;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageOriginChat final : public MessageOrigin {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 sender_chat_id_;
  string author_signature_;

  messageOriginChat();

  messageOriginChat(int53 sender_chat_id_, string const &author_signature_);

  static const std::int32_t ID = -205824332;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageOriginChannel final : public MessageOrigin {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  string author_signature_;

  messageOriginChannel();

  messageOriginChannel(int53 chat_id_, int53 message_id_, string const &author_signature_);

  static const std::int32_t ID = -1451535938;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePosition final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 position_;
  int53 message_id_;
  int32 date_;

  messagePosition();

  messagePosition(int32 position_, int53 message_id_, int32 date_);

  static const std::int32_t ID = 1292189935;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messagePosition;

class messagePositions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<messagePosition>> positions_;

  messagePositions();

  messagePositions(int32 total_count_, array<object_ptr<messagePosition>> &&positions_);

  static const std::int32_t ID = -1930466649;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageProperties final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool can_be_copied_to_secret_chat_;
  bool can_be_deleted_only_for_self_;
  bool can_be_deleted_for_all_users_;
  bool can_be_edited_;
  bool can_be_forwarded_;
  bool can_be_paid_;
  bool can_be_pinned_;
  bool can_be_replied_;
  bool can_be_replied_in_another_chat_;
  bool can_be_saved_;
  bool can_be_shared_in_story_;
  bool can_edit_media_;
  bool can_edit_scheduling_state_;
  bool can_get_embedding_code_;
  bool can_get_link_;
  bool can_get_media_timestamp_links_;
  bool can_get_message_thread_;
  bool can_get_read_date_;
  bool can_get_statistics_;
  bool can_get_viewers_;
  bool can_recognize_speech_;
  bool can_report_chat_;
  bool can_report_reactions_;
  bool can_report_supergroup_spam_;
  bool can_set_fact_check_;
  bool need_show_statistics_;

  messageProperties();

  messageProperties(bool can_be_copied_to_secret_chat_, bool can_be_deleted_only_for_self_, bool can_be_deleted_for_all_users_, bool can_be_edited_, bool can_be_forwarded_, bool can_be_paid_, bool can_be_pinned_, bool can_be_replied_, bool can_be_replied_in_another_chat_, bool can_be_saved_, bool can_be_shared_in_story_, bool can_edit_media_, bool can_edit_scheduling_state_, bool can_get_embedding_code_, bool can_get_link_, bool can_get_media_timestamp_links_, bool can_get_message_thread_, bool can_get_read_date_, bool can_get_statistics_, bool can_get_viewers_, bool can_recognize_speech_, bool can_report_chat_, bool can_report_reactions_, bool can_report_supergroup_spam_, bool can_set_fact_check_, bool need_show_statistics_);

  static const std::int32_t ID = -27014655;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class ReactionType;

class messageReaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionType> type_;
  int32 total_count_;
  bool is_chosen_;
  object_ptr<MessageSender> used_sender_id_;
  array<object_ptr<MessageSender>> recent_sender_ids_;

  messageReaction();

  messageReaction(object_ptr<ReactionType> &&type_, int32 total_count_, bool is_chosen_, object_ptr<MessageSender> &&used_sender_id_, array<object_ptr<MessageSender>> &&recent_sender_ids_);

  static const std::int32_t ID = -1093994369;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReaction;

class paidReactor;

class messageReactions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<messageReaction>> reactions_;
  bool are_tags_;
  array<object_ptr<paidReactor>> paid_reactors_;
  bool can_get_added_reactions_;

  messageReactions();

  messageReactions(array<object_ptr<messageReaction>> &&reactions_, bool are_tags_, array<object_ptr<paidReactor>> &&paid_reactors_, bool can_get_added_reactions_);

  static const std::int32_t ID = 1475966817;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageReadDate: public Object {
 public:
};

class messageReadDateRead final : public MessageReadDate {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 read_date_;

  messageReadDateRead();

  explicit messageReadDateRead(int32 read_date_);

  static const std::int32_t ID = 1972186672;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReadDateUnread final : public MessageReadDate {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageReadDateUnread();

  static const std::int32_t ID = 397549868;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReadDateTooOld final : public MessageReadDate {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageReadDateTooOld();

  static const std::int32_t ID = -1233773024;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReadDateUserPrivacyRestricted final : public MessageReadDate {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageReadDateUserPrivacyRestricted();

  static const std::int32_t ID = -1282567130;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReadDateMyPrivacyRestricted final : public MessageReadDate {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageReadDateMyPrivacyRestricted();

  static const std::int32_t ID = -693971852;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class messageReplyInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 reply_count_;
  array<object_ptr<MessageSender>> recent_replier_ids_;
  int53 last_read_inbox_message_id_;
  int53 last_read_outbox_message_id_;
  int53 last_message_id_;

  messageReplyInfo();

  messageReplyInfo(int32 reply_count_, array<object_ptr<MessageSender>> &&recent_replier_ids_, int53 last_read_inbox_message_id_, int53 last_read_outbox_message_id_, int53 last_message_id_);

  static const std::int32_t ID = -2093702263;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageContent;

class MessageOrigin;

class textQuote;

class MessageReplyTo: public Object {
 public:
};

class messageReplyToMessage final : public MessageReplyTo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<textQuote> quote_;
  object_ptr<MessageOrigin> origin_;
  int32 origin_send_date_;
  object_ptr<MessageContent> content_;

  messageReplyToMessage();

  messageReplyToMessage(int53 chat_id_, int53 message_id_, object_ptr<textQuote> &&quote_, object_ptr<MessageOrigin> &&origin_, int32 origin_send_date_, object_ptr<MessageContent> &&content_);

  static const std::int32_t ID = -300918393;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageReplyToStory final : public MessageReplyTo {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;

  messageReplyToStory();

  messageReplyToStory(int53 story_poster_chat_id_, int32 story_id_);

  static const std::int32_t ID = -674492596;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSchedulingState: public Object {
 public:
};

class messageSchedulingStateSendAtDate final : public MessageSchedulingState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 send_date_;

  messageSchedulingStateSendAtDate();

  explicit messageSchedulingStateSendAtDate(int32 send_date_);

  static const std::int32_t ID = -1485570073;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSchedulingStateSendWhenOnline final : public MessageSchedulingState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSchedulingStateSendWhenOnline();

  static const std::int32_t ID = 2092947464;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSchedulingStateSendWhenVideoProcessed final : public MessageSchedulingState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 send_date_;

  messageSchedulingStateSendWhenVideoProcessed();

  explicit messageSchedulingStateSendWhenVideoProcessed(int32 send_date_);

  static const std::int32_t ID = 2101578734;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSelfDestructType: public Object {
 public:
};

class messageSelfDestructTypeTimer final : public MessageSelfDestructType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 self_destruct_time_;

  messageSelfDestructTypeTimer();

  explicit messageSelfDestructTypeTimer(int32 self_destruct_time_);

  static const std::int32_t ID = 1351440333;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSelfDestructTypeImmediately final : public MessageSelfDestructType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSelfDestructTypeImmediately();

  static const std::int32_t ID = -1036218363;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSchedulingState;

class messageSendOptions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool disable_notification_;
  bool from_background_;
  bool protect_content_;
  bool allow_paid_broadcast_;
  int53 paid_message_star_count_;
  bool update_order_of_installed_sticker_sets_;
  object_ptr<MessageSchedulingState> scheduling_state_;
  int64 effect_id_;
  int32 sending_id_;
  bool only_preview_;

  messageSendOptions();

  messageSendOptions(bool disable_notification_, bool from_background_, bool protect_content_, bool allow_paid_broadcast_, int53 paid_message_star_count_, bool update_order_of_installed_sticker_sets_, object_ptr<MessageSchedulingState> &&scheduling_state_, int64 effect_id_, int32 sending_id_, bool only_preview_);

  static const std::int32_t ID = -128496262;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender: public Object {
 public:
};

class messageSenderUser final : public MessageSender {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  messageSenderUser();

  explicit messageSenderUser(int53 user_id_);

  static const std::int32_t ID = -336109341;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSenderChat final : public MessageSender {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  messageSenderChat();

  explicit messageSenderChat(int53 chat_id_);

  static const std::int32_t ID = -239660751;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class messageSenders final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<MessageSender>> senders_;

  messageSenders();

  messageSenders(int32 total_count_, array<object_ptr<MessageSender>> &&senders_);

  static const std::int32_t ID = -690158467;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class error;

class MessageSendingState: public Object {
 public:
};

class messageSendingStatePending final : public MessageSendingState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 sending_id_;

  messageSendingStatePending();

  explicit messageSendingStatePending(int32 sending_id_);

  static const std::int32_t ID = -215260236;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSendingStateFailed final : public MessageSendingState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<error> error_;
  bool can_retry_;
  bool need_another_sender_;
  bool need_another_reply_quote_;
  bool need_drop_reply_;
  int53 required_paid_message_star_count_;
  double retry_after_;

  messageSendingStateFailed();

  messageSendingStateFailed(object_ptr<error> &&error_, bool can_retry_, bool need_another_sender_, bool need_another_reply_quote_, bool need_drop_reply_, int53 required_paid_message_star_count_, double retry_after_);

  static const std::int32_t ID = -777630522;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSource: public Object {
 public:
};

class messageSourceChatHistory final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceChatHistory();

  static const std::int32_t ID = -1090386116;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSourceMessageThreadHistory final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceMessageThreadHistory();

  static const std::int32_t ID = 290427142;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSourceForumTopicHistory final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceForumTopicHistory();

  static const std::int32_t ID = -1518064457;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSourceHistoryPreview final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceHistoryPreview();

  static const std::int32_t ID = 1024254993;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSourceChatList final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceChatList();

  static const std::int32_t ID = -2047406102;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSourceSearch final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceSearch();

  static const std::int32_t ID = 1921333105;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSourceChatEventLog final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceChatEventLog();

  static const std::int32_t ID = -1028777540;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSourceNotification final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceNotification();

  static const std::int32_t ID = -1046406163;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSourceScreenshot final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceScreenshot();

  static const std::int32_t ID = 469982474;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSourceOther final : public MessageSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  messageSourceOther();

  static const std::int32_t ID = 901818114;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photo;

class messageSponsor final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  object_ptr<photo> photo_;
  string info_;

  messageSponsor();

  messageSponsor(string const &url_, object_ptr<photo> &&photo_, string const &info_);

  static const std::int32_t ID = 2009223646;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatisticalGraph;

class messageStatistics final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StatisticalGraph> message_interaction_graph_;
  object_ptr<StatisticalGraph> message_reaction_graph_;

  messageStatistics();

  messageStatistics(object_ptr<StatisticalGraph> &&message_interaction_graph_, object_ptr<StatisticalGraph> &&message_reaction_graph_);

  static const std::int32_t ID = -1563537657;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class draftMessage;

class message;

class messageReplyInfo;

class messageThreadInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_thread_id_;
  object_ptr<messageReplyInfo> reply_info_;
  int32 unread_message_count_;
  array<object_ptr<message>> messages_;
  object_ptr<draftMessage> draft_message_;

  messageThreadInfo();

  messageThreadInfo(int53 chat_id_, int53 message_thread_id_, object_ptr<messageReplyInfo> &&reply_info_, int32 unread_message_count_, array<object_ptr<message>> &&messages_, object_ptr<draftMessage> &&draft_message_);

  static const std::int32_t ID = -248536056;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageViewer final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 view_date_;

  messageViewer();

  messageViewer(int53 user_id_, int32 view_date_);

  static const std::int32_t ID = 1458639309;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageViewer;

class messageViewers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<messageViewer>> viewers_;

  messageViewers();

  explicit messageViewers(array<object_ptr<messageViewer>> &&viewers_);

  static const std::int32_t ID = 2116480287;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class messages final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<message>> messages_;

  messages();

  messages(int32 total_count_, array<object_ptr<message>> &&messages_);

  static const std::int32_t ID = -16498159;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class minithumbnail final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 width_;
  int32 height_;
  bytes data_;

  minithumbnail();

  minithumbnail(int32 width_, int32 height_, bytes const &data_);

  static const std::int32_t ID = -328540758;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NetworkStatisticsEntry;

class networkStatistics final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 since_date_;
  array<object_ptr<NetworkStatisticsEntry>> entries_;

  networkStatistics();

  networkStatistics(int32 since_date_, array<object_ptr<NetworkStatisticsEntry>> &&entries_);

  static const std::int32_t ID = 1615554212;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class FileType;

class NetworkType;

class NetworkStatisticsEntry: public Object {
 public:
};

class networkStatisticsEntryFile final : public NetworkStatisticsEntry {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<FileType> file_type_;
  object_ptr<NetworkType> network_type_;
  int53 sent_bytes_;
  int53 received_bytes_;

  networkStatisticsEntryFile();

  networkStatisticsEntryFile(object_ptr<FileType> &&file_type_, object_ptr<NetworkType> &&network_type_, int53 sent_bytes_, int53 received_bytes_);

  static const std::int32_t ID = 188452706;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class networkStatisticsEntryCall final : public NetworkStatisticsEntry {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<NetworkType> network_type_;
  int53 sent_bytes_;
  int53 received_bytes_;
  double duration_;

  networkStatisticsEntryCall();

  networkStatisticsEntryCall(object_ptr<NetworkType> &&network_type_, int53 sent_bytes_, int53 received_bytes_, double duration_);

  static const std::int32_t ID = 737000365;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NetworkType: public Object {
 public:
};

class networkTypeNone final : public NetworkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  networkTypeNone();

  static const std::int32_t ID = -1971691759;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class networkTypeMobile final : public NetworkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  networkTypeMobile();

  static const std::int32_t ID = 819228239;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class networkTypeMobileRoaming final : public NetworkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  networkTypeMobileRoaming();

  static const std::int32_t ID = -1435199760;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class networkTypeWiFi final : public NetworkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  networkTypeWiFi();

  static const std::int32_t ID = -633872070;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class networkTypeOther final : public NetworkType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  networkTypeOther();

  static const std::int32_t ID = 1942128539;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class newChatPrivacySettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool allow_new_chats_from_unknown_users_;
  int53 incoming_paid_message_star_count_;

  newChatPrivacySettings();

  newChatPrivacySettings(bool allow_new_chats_from_unknown_users_, int53 incoming_paid_message_star_count_);

  static const std::int32_t ID = 123716192;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationType;

class notification final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int32 date_;
  bool is_silent_;
  object_ptr<NotificationType> type_;

  notification();

  notification(int32 id_, int32 date_, bool is_silent_, object_ptr<NotificationType> &&type_);

  static const std::int32_t ID = 788743120;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationGroupType;

class notification;

class notificationGroup final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  object_ptr<NotificationGroupType> type_;
  int53 chat_id_;
  int32 total_count_;
  array<object_ptr<notification>> notifications_;

  notificationGroup();

  notificationGroup(int32 id_, object_ptr<NotificationGroupType> &&type_, int53 chat_id_, int32 total_count_, array<object_ptr<notification>> &&notifications_);

  static const std::int32_t ID = 780691541;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationGroupType: public Object {
 public:
};

class notificationGroupTypeMessages final : public NotificationGroupType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  notificationGroupTypeMessages();

  static const std::int32_t ID = -1702481123;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationGroupTypeMentions final : public NotificationGroupType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  notificationGroupTypeMentions();

  static const std::int32_t ID = -2050324051;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationGroupTypeSecretChat final : public NotificationGroupType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  notificationGroupTypeSecretChat();

  static const std::int32_t ID = 1390759476;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationGroupTypeCalls final : public NotificationGroupType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  notificationGroupTypeCalls();

  static const std::int32_t ID = 1379123538;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationSettingsScope: public Object {
 public:
};

class notificationSettingsScopePrivateChats final : public NotificationSettingsScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  notificationSettingsScopePrivateChats();

  static const std::int32_t ID = 937446759;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationSettingsScopeGroupChats final : public NotificationSettingsScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  notificationSettingsScopeGroupChats();

  static const std::int32_t ID = 1212142067;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationSettingsScopeChannelChats final : public NotificationSettingsScope {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  notificationSettingsScopeChannelChats();

  static const std::int32_t ID = 548013448;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class notificationSound final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 duration_;
  int32 date_;
  string title_;
  string data_;
  object_ptr<file> sound_;

  notificationSound();

  notificationSound(int64 id_, int32 duration_, int32 date_, string const &title_, string const &data_, object_ptr<file> &&sound_);

  static const std::int32_t ID = -185638601;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationSound;

class notificationSounds final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<notificationSound>> notification_sounds_;

  notificationSounds();

  explicit notificationSounds(array<object_ptr<notificationSound>> &&notification_sounds_);

  static const std::int32_t ID = -630813169;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class PushMessageContent;

class message;

class NotificationType: public Object {
 public:
};

class notificationTypeNewMessage final : public NotificationType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;
  bool show_preview_;

  notificationTypeNewMessage();

  notificationTypeNewMessage(object_ptr<message> &&message_, bool show_preview_);

  static const std::int32_t ID = -254745614;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationTypeNewSecretChat final : public NotificationType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  notificationTypeNewSecretChat();

  static const std::int32_t ID = 1198638768;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationTypeNewCall final : public NotificationType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 call_id_;

  notificationTypeNewCall();

  explicit notificationTypeNewCall(int32 call_id_);

  static const std::int32_t ID = 1712734585;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationTypeNewPushMessage final : public NotificationType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 message_id_;
  object_ptr<MessageSender> sender_id_;
  string sender_name_;
  bool is_outgoing_;
  object_ptr<PushMessageContent> content_;

  notificationTypeNewPushMessage();

  notificationTypeNewPushMessage(int53 message_id_, object_ptr<MessageSender> &&sender_id_, string const &sender_name_, bool is_outgoing_, object_ptr<PushMessageContent> &&content_);

  static const std::int32_t ID = -711680462;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  ok();

  static const std::int32_t ID = -722616727;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class OptionValue: public Object {
 public:
};

class optionValueBoolean final : public OptionValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool value_;

  optionValueBoolean();

  explicit optionValueBoolean(bool value_);

  static const std::int32_t ID = 63135518;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class optionValueEmpty final : public OptionValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  optionValueEmpty();

  static const std::int32_t ID = 918955155;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class optionValueInteger final : public OptionValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 value_;

  optionValueInteger();

  explicit optionValueInteger(int64 value_);

  static const std::int32_t ID = -186858780;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class optionValueString final : public OptionValue {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string value_;

  optionValueString();

  explicit optionValueString(string const &value_);

  static const std::int32_t ID = 756248212;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class address;

class orderInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  string phone_number_;
  string email_address_;
  object_ptr<address> shipping_address_;

  orderInfo();

  orderInfo(string const &name_, string const &phone_number_, string const &email_address_, object_ptr<address> &&shipping_address_);

  static const std::int32_t ID = 783997294;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class closedVectorPath;

class outline final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<closedVectorPath>> paths_;

  outline();

  explicit outline(array<object_ptr<closedVectorPath>> &&paths_);

  static const std::int32_t ID = -161506702;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PageBlock;

class RichText;

class animation;

class audio;

class chatPhotoInfo;

class location;

class pageBlockCaption;

class pageBlockListItem;

class pageBlockRelatedArticle;

class pageBlockTableCell;

class photo;

class video;

class voiceNote;

class PageBlock: public Object {
 public:
};

class pageBlockTitle final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> title_;

  pageBlockTitle();

  explicit pageBlockTitle(object_ptr<RichText> &&title_);

  static const std::int32_t ID = 1629664784;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockSubtitle final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> subtitle_;

  pageBlockSubtitle();

  explicit pageBlockSubtitle(object_ptr<RichText> &&subtitle_);

  static const std::int32_t ID = 264524263;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockAuthorDate final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> author_;
  int32 publish_date_;

  pageBlockAuthorDate();

  pageBlockAuthorDate(object_ptr<RichText> &&author_, int32 publish_date_);

  static const std::int32_t ID = 1300231184;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockHeader final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> header_;

  pageBlockHeader();

  explicit pageBlockHeader(object_ptr<RichText> &&header_);

  static const std::int32_t ID = 1402854811;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockSubheader final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> subheader_;

  pageBlockSubheader();

  explicit pageBlockSubheader(object_ptr<RichText> &&subheader_);

  static const std::int32_t ID = 1263956774;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockKicker final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> kicker_;

  pageBlockKicker();

  explicit pageBlockKicker(object_ptr<RichText> &&kicker_);

  static const std::int32_t ID = 1361282635;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockParagraph final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  pageBlockParagraph();

  explicit pageBlockParagraph(object_ptr<RichText> &&text_);

  static const std::int32_t ID = 1182402406;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockPreformatted final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string language_;

  pageBlockPreformatted();

  pageBlockPreformatted(object_ptr<RichText> &&text_, string const &language_);

  static const std::int32_t ID = -1066346178;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockFooter final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> footer_;

  pageBlockFooter();

  explicit pageBlockFooter(object_ptr<RichText> &&footer_);

  static const std::int32_t ID = 886429480;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockDivider final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pageBlockDivider();

  static const std::int32_t ID = -618614392;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockAnchor final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  pageBlockAnchor();

  explicit pageBlockAnchor(string const &name_);

  static const std::int32_t ID = -837994576;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockList final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<pageBlockListItem>> items_;

  pageBlockList();

  explicit pageBlockList(array<object_ptr<pageBlockListItem>> &&items_);

  static const std::int32_t ID = -1037074852;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockBlockQuote final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  object_ptr<RichText> credit_;

  pageBlockBlockQuote();

  pageBlockBlockQuote(object_ptr<RichText> &&text_, object_ptr<RichText> &&credit_);

  static const std::int32_t ID = 1657834142;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockPullQuote final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  object_ptr<RichText> credit_;

  pageBlockPullQuote();

  pageBlockPullQuote(object_ptr<RichText> &&text_, object_ptr<RichText> &&credit_);

  static const std::int32_t ID = 490242317;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockAnimation final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<animation> animation_;
  object_ptr<pageBlockCaption> caption_;
  bool need_autoplay_;

  pageBlockAnimation();

  pageBlockAnimation(object_ptr<animation> &&animation_, object_ptr<pageBlockCaption> &&caption_, bool need_autoplay_);

  static const std::int32_t ID = 1355669513;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockAudio final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<audio> audio_;
  object_ptr<pageBlockCaption> caption_;

  pageBlockAudio();

  pageBlockAudio(object_ptr<audio> &&audio_, object_ptr<pageBlockCaption> &&caption_);

  static const std::int32_t ID = -63371245;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockPhoto final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;
  object_ptr<pageBlockCaption> caption_;
  string url_;

  pageBlockPhoto();

  pageBlockPhoto(object_ptr<photo> &&photo_, object_ptr<pageBlockCaption> &&caption_, string const &url_);

  static const std::int32_t ID = 417601156;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockVideo final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<video> video_;
  object_ptr<pageBlockCaption> caption_;
  bool need_autoplay_;
  bool is_looped_;

  pageBlockVideo();

  pageBlockVideo(object_ptr<video> &&video_, object_ptr<pageBlockCaption> &&caption_, bool need_autoplay_, bool is_looped_);

  static const std::int32_t ID = 510041394;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockVoiceNote final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<voiceNote> voice_note_;
  object_ptr<pageBlockCaption> caption_;

  pageBlockVoiceNote();

  pageBlockVoiceNote(object_ptr<voiceNote> &&voice_note_, object_ptr<pageBlockCaption> &&caption_);

  static const std::int32_t ID = 1823310463;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockCover final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PageBlock> cover_;

  pageBlockCover();

  explicit pageBlockCover(object_ptr<PageBlock> &&cover_);

  static const std::int32_t ID = 972174080;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockEmbedded final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string html_;
  object_ptr<photo> poster_photo_;
  int32 width_;
  int32 height_;
  object_ptr<pageBlockCaption> caption_;
  bool is_full_width_;
  bool allow_scrolling_;

  pageBlockEmbedded();

  pageBlockEmbedded(string const &url_, string const &html_, object_ptr<photo> &&poster_photo_, int32 width_, int32 height_, object_ptr<pageBlockCaption> &&caption_, bool is_full_width_, bool allow_scrolling_);

  static const std::int32_t ID = -1942577763;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockEmbeddedPost final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string author_;
  object_ptr<photo> author_photo_;
  int32 date_;
  array<object_ptr<PageBlock>> page_blocks_;
  object_ptr<pageBlockCaption> caption_;

  pageBlockEmbeddedPost();

  pageBlockEmbeddedPost(string const &url_, string const &author_, object_ptr<photo> &&author_photo_, int32 date_, array<object_ptr<PageBlock>> &&page_blocks_, object_ptr<pageBlockCaption> &&caption_);

  static const std::int32_t ID = 397600949;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockCollage final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PageBlock>> page_blocks_;
  object_ptr<pageBlockCaption> caption_;

  pageBlockCollage();

  pageBlockCollage(array<object_ptr<PageBlock>> &&page_blocks_, object_ptr<pageBlockCaption> &&caption_);

  static const std::int32_t ID = 1163760110;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockSlideshow final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PageBlock>> page_blocks_;
  object_ptr<pageBlockCaption> caption_;

  pageBlockSlideshow();

  pageBlockSlideshow(array<object_ptr<PageBlock>> &&page_blocks_, object_ptr<pageBlockCaption> &&caption_);

  static const std::int32_t ID = 539217375;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockChatLink final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  object_ptr<chatPhotoInfo> photo_;
  int32 accent_color_id_;
  string username_;

  pageBlockChatLink();

  pageBlockChatLink(string const &title_, object_ptr<chatPhotoInfo> &&photo_, int32 accent_color_id_, string const &username_);

  static const std::int32_t ID = 1646188731;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockTable final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> caption_;
  array<array<object_ptr<pageBlockTableCell>>> cells_;
  bool is_bordered_;
  bool is_striped_;

  pageBlockTable();

  pageBlockTable(object_ptr<RichText> &&caption_, array<array<object_ptr<pageBlockTableCell>>> &&cells_, bool is_bordered_, bool is_striped_);

  static const std::int32_t ID = -942649288;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockDetails final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> header_;
  array<object_ptr<PageBlock>> page_blocks_;
  bool is_open_;

  pageBlockDetails();

  pageBlockDetails(object_ptr<RichText> &&header_, array<object_ptr<PageBlock>> &&page_blocks_, bool is_open_);

  static const std::int32_t ID = -1599869809;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockRelatedArticles final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> header_;
  array<object_ptr<pageBlockRelatedArticle>> articles_;

  pageBlockRelatedArticles();

  pageBlockRelatedArticles(object_ptr<RichText> &&header_, array<object_ptr<pageBlockRelatedArticle>> &&articles_);

  static const std::int32_t ID = -1807324374;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockMap final : public PageBlock {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;
  int32 zoom_;
  int32 width_;
  int32 height_;
  object_ptr<pageBlockCaption> caption_;

  pageBlockMap();

  pageBlockMap(object_ptr<location> &&location_, int32 zoom_, int32 width_, int32 height_, object_ptr<pageBlockCaption> &&caption_);

  static const std::int32_t ID = 1510961171;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class RichText;

class pageBlockCaption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  object_ptr<RichText> credit_;

  pageBlockCaption();

  pageBlockCaption(object_ptr<RichText> &&text_, object_ptr<RichText> &&credit_);

  static const std::int32_t ID = -1180064650;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PageBlockHorizontalAlignment: public Object {
 public:
};

class pageBlockHorizontalAlignmentLeft final : public PageBlockHorizontalAlignment {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pageBlockHorizontalAlignmentLeft();

  static const std::int32_t ID = 848701417;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockHorizontalAlignmentCenter final : public PageBlockHorizontalAlignment {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pageBlockHorizontalAlignmentCenter();

  static const std::int32_t ID = -1009203990;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockHorizontalAlignmentRight final : public PageBlockHorizontalAlignment {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pageBlockHorizontalAlignmentRight();

  static const std::int32_t ID = 1371369214;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PageBlock;

class pageBlockListItem final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string label_;
  array<object_ptr<PageBlock>> page_blocks_;

  pageBlockListItem();

  pageBlockListItem(string const &label_, array<object_ptr<PageBlock>> &&page_blocks_);

  static const std::int32_t ID = 323186259;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photo;

class pageBlockRelatedArticle final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string title_;
  string description_;
  object_ptr<photo> photo_;
  string author_;
  int32 publish_date_;

  pageBlockRelatedArticle();

  pageBlockRelatedArticle(string const &url_, string const &title_, string const &description_, object_ptr<photo> &&photo_, string const &author_, int32 publish_date_);

  static const std::int32_t ID = 481199251;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PageBlockHorizontalAlignment;

class PageBlockVerticalAlignment;

class RichText;

class pageBlockTableCell final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  bool is_header_;
  int32 colspan_;
  int32 rowspan_;
  object_ptr<PageBlockHorizontalAlignment> align_;
  object_ptr<PageBlockVerticalAlignment> valign_;

  pageBlockTableCell();

  pageBlockTableCell(object_ptr<RichText> &&text_, bool is_header_, int32 colspan_, int32 rowspan_, object_ptr<PageBlockHorizontalAlignment> &&align_, object_ptr<PageBlockVerticalAlignment> &&valign_);

  static const std::int32_t ID = 1417658214;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PageBlockVerticalAlignment: public Object {
 public:
};

class pageBlockVerticalAlignmentTop final : public PageBlockVerticalAlignment {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pageBlockVerticalAlignmentTop();

  static const std::int32_t ID = 195500454;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockVerticalAlignmentMiddle final : public PageBlockVerticalAlignment {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pageBlockVerticalAlignmentMiddle();

  static const std::int32_t ID = -2123096587;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pageBlockVerticalAlignmentBottom final : public PageBlockVerticalAlignment {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pageBlockVerticalAlignmentBottom();

  static const std::int32_t ID = 2092531158;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class minithumbnail;

class photo;

class video;

class PaidMedia: public Object {
 public:
};

class paidMediaPreview final : public PaidMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 width_;
  int32 height_;
  int32 duration_;
  object_ptr<minithumbnail> minithumbnail_;

  paidMediaPreview();

  paidMediaPreview(int32 width_, int32 height_, int32 duration_, object_ptr<minithumbnail> &&minithumbnail_);

  static const std::int32_t ID = -1128151948;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paidMediaPhoto final : public PaidMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;

  paidMediaPhoto();

  explicit paidMediaPhoto(object_ptr<photo> &&photo_);

  static const std::int32_t ID = -1165863654;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paidMediaVideo final : public PaidMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<video> video_;
  object_ptr<photo> cover_;
  int32 start_timestamp_;

  paidMediaVideo();

  paidMediaVideo(object_ptr<video> &&video_, object_ptr<photo> &&cover_, int32 start_timestamp_);

  static const std::int32_t ID = 870838318;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paidMediaUnsupported final : public PaidMedia {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  paidMediaUnsupported();

  static const std::int32_t ID = 112999974;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PaidReactionType: public Object {
 public:
};

class paidReactionTypeRegular final : public PaidReactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  paidReactionTypeRegular();

  static const std::int32_t ID = -1199187333;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paidReactionTypeAnonymous final : public PaidReactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  paidReactionTypeAnonymous();

  static const std::int32_t ID = 47892621;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paidReactionTypeChat final : public PaidReactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  paidReactionTypeChat();

  explicit paidReactionTypeChat(int53 chat_id_);

  static const std::int32_t ID = -675782044;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class paidReactor final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> sender_id_;
  int32 star_count_;
  bool is_top_;
  bool is_me_;
  bool is_anonymous_;

  paidReactor();

  paidReactor(object_ptr<MessageSender> &&sender_id_, int32 star_count_, bool is_top_, bool is_me_, bool is_anonymous_);

  static const std::int32_t ID = -1657303032;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportRequiredElement;

class passportAuthorizationForm final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  array<object_ptr<passportRequiredElement>> required_elements_;
  string privacy_policy_url_;

  passportAuthorizationForm();

  passportAuthorizationForm(int32 id_, array<object_ptr<passportRequiredElement>> &&required_elements_, string const &privacy_policy_url_);

  static const std::int32_t ID = -1070673218;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class address;

class identityDocument;

class personalDetails;

class personalDocument;

class PassportElement: public Object {
 public:
};

class passportElementPersonalDetails final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<personalDetails> personal_details_;

  passportElementPersonalDetails();

  explicit passportElementPersonalDetails(object_ptr<personalDetails> &&personal_details_);

  static const std::int32_t ID = 1217724035;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementPassport final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<identityDocument> passport_;

  passportElementPassport();

  explicit passportElementPassport(object_ptr<identityDocument> &&passport_);

  static const std::int32_t ID = -263985373;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementDriverLicense final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<identityDocument> driver_license_;

  passportElementDriverLicense();

  explicit passportElementDriverLicense(object_ptr<identityDocument> &&driver_license_);

  static const std::int32_t ID = 1643580589;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementIdentityCard final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<identityDocument> identity_card_;

  passportElementIdentityCard();

  explicit passportElementIdentityCard(object_ptr<identityDocument> &&identity_card_);

  static const std::int32_t ID = 2083775797;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementInternalPassport final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<identityDocument> internal_passport_;

  passportElementInternalPassport();

  explicit passportElementInternalPassport(object_ptr<identityDocument> &&internal_passport_);

  static const std::int32_t ID = 36220295;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementAddress final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<address> address_;

  passportElementAddress();

  explicit passportElementAddress(object_ptr<address> &&address_);

  static const std::int32_t ID = -782625232;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementUtilityBill final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<personalDocument> utility_bill_;

  passportElementUtilityBill();

  explicit passportElementUtilityBill(object_ptr<personalDocument> &&utility_bill_);

  static const std::int32_t ID = -234611246;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementBankStatement final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<personalDocument> bank_statement_;

  passportElementBankStatement();

  explicit passportElementBankStatement(object_ptr<personalDocument> &&bank_statement_);

  static const std::int32_t ID = -366464408;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementRentalAgreement final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<personalDocument> rental_agreement_;

  passportElementRentalAgreement();

  explicit passportElementRentalAgreement(object_ptr<personalDocument> &&rental_agreement_);

  static const std::int32_t ID = -290141400;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementPassportRegistration final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<personalDocument> passport_registration_;

  passportElementPassportRegistration();

  explicit passportElementPassportRegistration(object_ptr<personalDocument> &&passport_registration_);

  static const std::int32_t ID = 618323071;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTemporaryRegistration final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<personalDocument> temporary_registration_;

  passportElementTemporaryRegistration();

  explicit passportElementTemporaryRegistration(object_ptr<personalDocument> &&temporary_registration_);

  static const std::int32_t ID = 1237626864;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementPhoneNumber final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_;

  passportElementPhoneNumber();

  explicit passportElementPhoneNumber(string const &phone_number_);

  static const std::int32_t ID = -1320118375;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementEmailAddress final : public PassportElement {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string email_address_;

  passportElementEmailAddress();

  explicit passportElementEmailAddress(string const &email_address_);

  static const std::int32_t ID = -1528129531;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PassportElementErrorSource;

class PassportElementType;

class passportElementError final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PassportElementType> type_;
  string message_;
  object_ptr<PassportElementErrorSource> source_;

  passportElementError();

  passportElementError(object_ptr<PassportElementType> &&type_, string const &message_, object_ptr<PassportElementErrorSource> &&source_);

  static const std::int32_t ID = -1861902395;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PassportElementErrorSource: public Object {
 public:
};

class passportElementErrorSourceUnspecified final : public PassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementErrorSourceUnspecified();

  static const std::int32_t ID = -378320830;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementErrorSourceDataField final : public PassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string field_name_;

  passportElementErrorSourceDataField();

  explicit passportElementErrorSourceDataField(string const &field_name_);

  static const std::int32_t ID = -308650776;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementErrorSourceFrontSide final : public PassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementErrorSourceFrontSide();

  static const std::int32_t ID = 1895658292;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementErrorSourceReverseSide final : public PassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementErrorSourceReverseSide();

  static const std::int32_t ID = 1918630391;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementErrorSourceSelfie final : public PassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementErrorSourceSelfie();

  static const std::int32_t ID = -797043672;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementErrorSourceTranslationFile final : public PassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_index_;

  passportElementErrorSourceTranslationFile();

  explicit passportElementErrorSourceTranslationFile(int32 file_index_);

  static const std::int32_t ID = -689621228;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementErrorSourceTranslationFiles final : public PassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementErrorSourceTranslationFiles();

  static const std::int32_t ID = 581280796;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementErrorSourceFile final : public PassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_index_;

  passportElementErrorSourceFile();

  explicit passportElementErrorSourceFile(int32 file_index_);

  static const std::int32_t ID = 2020358960;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementErrorSourceFiles final : public PassportElementErrorSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementErrorSourceFiles();

  static const std::int32_t ID = 1894164178;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PassportElementType: public Object {
 public:
};

class passportElementTypePersonalDetails final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypePersonalDetails();

  static const std::int32_t ID = -1032136365;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypePassport final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypePassport();

  static const std::int32_t ID = -436360376;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypeDriverLicense final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypeDriverLicense();

  static const std::int32_t ID = 1827298379;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypeIdentityCard final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypeIdentityCard();

  static const std::int32_t ID = -502356132;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypeInternalPassport final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypeInternalPassport();

  static const std::int32_t ID = -793781959;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypeAddress final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypeAddress();

  static const std::int32_t ID = 496327874;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypeUtilityBill final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypeUtilityBill();

  static const std::int32_t ID = 627084906;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypeBankStatement final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypeBankStatement();

  static const std::int32_t ID = 574095667;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypeRentalAgreement final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypeRentalAgreement();

  static const std::int32_t ID = -2060583280;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypePassportRegistration final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypePassportRegistration();

  static const std::int32_t ID = -159478209;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypeTemporaryRegistration final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypeTemporaryRegistration();

  static const std::int32_t ID = 1092498527;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypePhoneNumber final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypePhoneNumber();

  static const std::int32_t ID = -995361172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementTypeEmailAddress final : public PassportElementType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  passportElementTypeEmailAddress();

  static const std::int32_t ID = -79321405;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PassportElement;

class passportElements final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PassportElement>> elements_;

  passportElements();

  explicit passportElements(array<object_ptr<PassportElement>> &&elements_);

  static const std::int32_t ID = 1264617556;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PassportElement;

class passportElementError;

class passportElementsWithErrors final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PassportElement>> elements_;
  array<object_ptr<passportElementError>> errors_;

  passportElementsWithErrors();

  passportElementsWithErrors(array<object_ptr<PassportElement>> &&elements_, array<object_ptr<passportElementError>> &&errors_);

  static const std::int32_t ID = 1308923044;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportSuitableElement;

class passportRequiredElement final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<passportSuitableElement>> suitable_elements_;

  passportRequiredElement();

  explicit passportRequiredElement(array<object_ptr<passportSuitableElement>> &&suitable_elements_);

  static const std::int32_t ID = -1983641651;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PassportElementType;

class passportSuitableElement final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PassportElementType> type_;
  bool is_selfie_required_;
  bool is_translation_required_;
  bool is_native_name_required_;

  passportSuitableElement();

  passportSuitableElement(object_ptr<PassportElementType> &&type_, bool is_selfie_required_, bool is_translation_required_, bool is_native_name_required_);

  static const std::int32_t ID = -789019876;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emailAddressAuthenticationCodeInfo;

class passwordState final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool has_password_;
  string password_hint_;
  bool has_recovery_email_address_;
  bool has_passport_data_;
  object_ptr<emailAddressAuthenticationCodeInfo> recovery_email_address_code_info_;
  string login_email_address_pattern_;
  int32 pending_reset_date_;

  passwordState();

  passwordState(bool has_password_, string const &password_hint_, bool has_recovery_email_address_, bool has_passport_data_, object_ptr<emailAddressAuthenticationCodeInfo> &&recovery_email_address_code_info_, string const &login_email_address_pattern_, int32 pending_reset_date_);

  static const std::int32_t ID = 483801128;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PaymentFormType;

class productInfo;

class paymentForm final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  object_ptr<PaymentFormType> type_;
  int53 seller_bot_user_id_;
  object_ptr<productInfo> product_info_;

  paymentForm();

  paymentForm(int64 id_, object_ptr<PaymentFormType> &&type_, int53 seller_bot_user_id_, object_ptr<productInfo> &&product_info_);

  static const std::int32_t ID = 1998651315;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PaymentProvider;

class invoice;

class orderInfo;

class paymentOption;

class savedCredentials;

class starSubscriptionPricing;

class PaymentFormType: public Object {
 public:
};

class paymentFormTypeRegular final : public PaymentFormType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<invoice> invoice_;
  int53 payment_provider_user_id_;
  object_ptr<PaymentProvider> payment_provider_;
  array<object_ptr<paymentOption>> additional_payment_options_;
  object_ptr<orderInfo> saved_order_info_;
  array<object_ptr<savedCredentials>> saved_credentials_;
  bool can_save_credentials_;
  bool need_password_;

  paymentFormTypeRegular();

  paymentFormTypeRegular(object_ptr<invoice> &&invoice_, int53 payment_provider_user_id_, object_ptr<PaymentProvider> &&payment_provider_, array<object_ptr<paymentOption>> &&additional_payment_options_, object_ptr<orderInfo> &&saved_order_info_, array<object_ptr<savedCredentials>> &&saved_credentials_, bool can_save_credentials_, bool need_password_);

  static const std::int32_t ID = -615089778;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentFormTypeStars final : public PaymentFormType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;

  paymentFormTypeStars();

  explicit paymentFormTypeStars(int53 star_count_);

  static const std::int32_t ID = 90938685;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentFormTypeStarSubscription final : public PaymentFormType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<starSubscriptionPricing> pricing_;

  paymentFormTypeStarSubscription();

  explicit paymentFormTypeStarSubscription(object_ptr<starSubscriptionPricing> &&pricing_);

  static const std::int32_t ID = 271444827;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  string url_;

  paymentOption();

  paymentOption(string const &title_, string const &url_);

  static const std::int32_t ID = -294020965;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PaymentProvider: public Object {
 public:
};

class paymentProviderSmartGlocal final : public PaymentProvider {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string public_token_;
  string tokenize_url_;

  paymentProviderSmartGlocal();

  paymentProviderSmartGlocal(string const &public_token_, string const &tokenize_url_);

  static const std::int32_t ID = -1174112396;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentProviderStripe final : public PaymentProvider {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string publishable_key_;
  bool need_country_;
  bool need_postal_code_;
  bool need_cardholder_name_;

  paymentProviderStripe();

  paymentProviderStripe(string const &publishable_key_, bool need_country_, bool need_postal_code_, bool need_cardholder_name_);

  static const std::int32_t ID = 370467227;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentProviderOther final : public PaymentProvider {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  paymentProviderOther();

  explicit paymentProviderOther(string const &url_);

  static const std::int32_t ID = -1336876828;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PaymentReceiptType;

class productInfo;

class paymentReceipt final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<productInfo> product_info_;
  int32 date_;
  int53 seller_bot_user_id_;
  object_ptr<PaymentReceiptType> type_;

  paymentReceipt();

  paymentReceipt(object_ptr<productInfo> &&product_info_, int32 date_, int53 seller_bot_user_id_, object_ptr<PaymentReceiptType> &&type_);

  static const std::int32_t ID = 758199186;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class invoice;

class orderInfo;

class shippingOption;

class PaymentReceiptType: public Object {
 public:
};

class paymentReceiptTypeRegular final : public PaymentReceiptType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 payment_provider_user_id_;
  object_ptr<invoice> invoice_;
  object_ptr<orderInfo> order_info_;
  object_ptr<shippingOption> shipping_option_;
  string credentials_title_;
  int53 tip_amount_;

  paymentReceiptTypeRegular();

  paymentReceiptTypeRegular(int53 payment_provider_user_id_, object_ptr<invoice> &&invoice_, object_ptr<orderInfo> &&order_info_, object_ptr<shippingOption> &&shipping_option_, string const &credentials_title_, int53 tip_amount_);

  static const std::int32_t ID = -1636362826;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentReceiptTypeStars final : public PaymentReceiptType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;
  string transaction_id_;

  paymentReceiptTypeStars();

  paymentReceiptTypeStars(int53 star_count_, string const &transaction_id_);

  static const std::int32_t ID = 294913868;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentResult final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool success_;
  string verification_url_;

  paymentResult();

  paymentResult(bool success_, string const &verification_url_);

  static const std::int32_t ID = -804263843;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class date;

class personalDetails final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string first_name_;
  string middle_name_;
  string last_name_;
  string native_first_name_;
  string native_middle_name_;
  string native_last_name_;
  object_ptr<date> birthdate_;
  string gender_;
  string country_code_;
  string residence_country_code_;

  personalDetails();

  personalDetails(string const &first_name_, string const &middle_name_, string const &last_name_, string const &native_first_name_, string const &native_middle_name_, string const &native_last_name_, object_ptr<date> &&birthdate_, string const &gender_, string const &country_code_, string const &residence_country_code_);

  static const std::int32_t ID = -1061656137;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class datedFile;

class personalDocument final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<datedFile>> files_;
  array<object_ptr<datedFile>> translation_;

  personalDocument();

  personalDocument(array<object_ptr<datedFile>> &&files_, array<object_ptr<datedFile>> &&translation_);

  static const std::int32_t ID = -1011634661;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class FirebaseAuthenticationSettings;

class phoneNumberAuthenticationSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool allow_flash_call_;
  bool allow_missed_call_;
  bool is_current_phone_number_;
  bool has_unknown_phone_number_;
  bool allow_sms_retriever_api_;
  object_ptr<FirebaseAuthenticationSettings> firebase_authentication_settings_;
  array<string> authentication_tokens_;

  phoneNumberAuthenticationSettings();

  phoneNumberAuthenticationSettings(bool allow_flash_call_, bool allow_missed_call_, bool is_current_phone_number_, bool has_unknown_phone_number_, bool allow_sms_retriever_api_, object_ptr<FirebaseAuthenticationSettings> &&firebase_authentication_settings_, array<string> &&authentication_tokens_);

  static const std::int32_t ID = 1881885547;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PhoneNumberCodeType: public Object {
 public:
};

class phoneNumberCodeTypeChange final : public PhoneNumberCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  phoneNumberCodeTypeChange();

  static const std::int32_t ID = 87144986;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneNumberCodeTypeVerify final : public PhoneNumberCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  phoneNumberCodeTypeVerify();

  static const std::int32_t ID = -1029402661;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneNumberCodeTypeConfirmOwnership final : public PhoneNumberCodeType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string hash_;

  phoneNumberCodeTypeConfirmOwnership();

  explicit phoneNumberCodeTypeConfirmOwnership(string const &hash_);

  static const std::int32_t ID = -485404696;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class countryInfo;

class phoneNumberInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<countryInfo> country_;
  string country_calling_code_;
  string formatted_phone_number_;
  bool is_anonymous_;

  phoneNumberInfo();

  phoneNumberInfo(object_ptr<countryInfo> &&country_, string const &country_calling_code_, string const &formatted_phone_number_, bool is_anonymous_);

  static const std::int32_t ID = -758933343;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class minithumbnail;

class photoSize;

class photo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool has_stickers_;
  object_ptr<minithumbnail> minithumbnail_;
  array<object_ptr<photoSize>> sizes_;

  photo();

  photo(bool has_stickers_, object_ptr<minithumbnail> &&minithumbnail_, array<object_ptr<photoSize>> &&sizes_);

  static const std::int32_t ID = -2022871583;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class photoSize final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string type_;
  object_ptr<file> photo_;
  int32 width_;
  int32 height_;
  array<int32> progressive_sizes_;

  photoSize();

  photoSize(string const &type_, object_ptr<file> &&photo_, int32 width_, int32 height_, array<int32> &&progressive_sizes_);

  static const std::int32_t ID = 1609182352;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class point final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double x_;
  double y_;

  point();

  point(double x_, double y_);

  static const std::int32_t ID = 437515705;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class PollType;

class formattedText;

class pollOption;

class poll final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  object_ptr<formattedText> question_;
  array<object_ptr<pollOption>> options_;
  int32 total_voter_count_;
  array<object_ptr<MessageSender>> recent_voter_ids_;
  bool is_anonymous_;
  object_ptr<PollType> type_;
  int32 open_period_;
  int32 close_date_;
  bool is_closed_;

  poll();

  poll(int64 id_, object_ptr<formattedText> &&question_, array<object_ptr<pollOption>> &&options_, int32 total_voter_count_, array<object_ptr<MessageSender>> &&recent_voter_ids_, bool is_anonymous_, object_ptr<PollType> &&type_, int32 open_period_, int32 close_date_, bool is_closed_);

  static const std::int32_t ID = 1913016502;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class pollOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  int32 voter_count_;
  int32 vote_percentage_;
  bool is_chosen_;
  bool is_being_chosen_;

  pollOption();

  pollOption(object_ptr<formattedText> &&text_, int32 voter_count_, int32 vote_percentage_, bool is_chosen_, bool is_being_chosen_);

  static const std::int32_t ID = 1676243088;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class PollType: public Object {
 public:
};

class pollTypeRegular final : public PollType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool allow_multiple_answers_;

  pollTypeRegular();

  explicit pollTypeRegular(bool allow_multiple_answers_);

  static const std::int32_t ID = 641265698;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pollTypeQuiz final : public PollType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 correct_option_id_;
  object_ptr<formattedText> explanation_;

  pollTypeQuiz();

  pollTypeQuiz(int32 correct_option_id_, object_ptr<formattedText> &&explanation_);

  static const std::int32_t ID = 657013913;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PremiumFeature: public Object {
 public:
};

class premiumFeatureIncreasedLimits final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureIncreasedLimits();

  static const std::int32_t ID = 1785455031;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureIncreasedUploadFileSize final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureIncreasedUploadFileSize();

  static const std::int32_t ID = 1825367155;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureImprovedDownloadSpeed final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureImprovedDownloadSpeed();

  static const std::int32_t ID = -267695554;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureVoiceRecognition final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureVoiceRecognition();

  static const std::int32_t ID = 1288216542;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureDisabledAds final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureDisabledAds();

  static const std::int32_t ID = -2008587702;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureUniqueReactions final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureUniqueReactions();

  static const std::int32_t ID = 766750743;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureUniqueStickers final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureUniqueStickers();

  static const std::int32_t ID = -2101773312;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureCustomEmoji final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureCustomEmoji();

  static const std::int32_t ID = 1332599628;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureAdvancedChatManagement final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureAdvancedChatManagement();

  static const std::int32_t ID = 796347674;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureProfileBadge final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureProfileBadge();

  static const std::int32_t ID = 233648322;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureEmojiStatus final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureEmojiStatus();

  static const std::int32_t ID = -36516639;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureAnimatedProfilePhoto final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureAnimatedProfilePhoto();

  static const std::int32_t ID = -100741914;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureForumTopicIcon final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureForumTopicIcon();

  static const std::int32_t ID = -823172286;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureAppIcons final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureAppIcons();

  static const std::int32_t ID = 1585050761;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureRealTimeChatTranslation final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureRealTimeChatTranslation();

  static const std::int32_t ID = -1143471488;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureUpgradedStories final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureUpgradedStories();

  static const std::int32_t ID = -1878522597;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureChatBoost final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureChatBoost();

  static const std::int32_t ID = 1576574747;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureAccentColor final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureAccentColor();

  static const std::int32_t ID = 907724190;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureBackgroundForBoth final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureBackgroundForBoth();

  static const std::int32_t ID = 575074042;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureSavedMessagesTags final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureSavedMessagesTags();

  static const std::int32_t ID = 1003219334;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureMessagePrivacy final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureMessagePrivacy();

  static const std::int32_t ID = 802322678;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureLastSeenTimes final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureLastSeenTimes();

  static const std::int32_t ID = -762230129;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureBusiness final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureBusiness();

  static const std::int32_t ID = -1503619324;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumFeatureMessageEffects final : public PremiumFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumFeatureMessageEffects();

  static const std::int32_t ID = -723300255;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PremiumFeature;

class animation;

class premiumFeaturePromotionAnimation final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PremiumFeature> feature_;
  object_ptr<animation> animation_;

  premiumFeaturePromotionAnimation();

  premiumFeaturePromotionAnimation(object_ptr<PremiumFeature> &&feature_, object_ptr<animation> &&animation_);

  static const std::int32_t ID = -1986155748;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InternalLinkType;

class PremiumFeature;

class premiumLimit;

class premiumFeatures final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PremiumFeature>> features_;
  array<object_ptr<premiumLimit>> limits_;
  object_ptr<InternalLinkType> payment_link_;

  premiumFeatures();

  premiumFeatures(array<object_ptr<PremiumFeature>> &&features_, array<object_ptr<premiumLimit>> &&limits_, object_ptr<InternalLinkType> &&payment_link_);

  static const std::int32_t ID = 1875162172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class premiumGiftCodeInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> creator_id_;
  int32 creation_date_;
  bool is_from_giveaway_;
  int53 giveaway_message_id_;
  int32 month_count_;
  int53 user_id_;
  int32 use_date_;

  premiumGiftCodeInfo();

  premiumGiftCodeInfo(object_ptr<MessageSender> &&creator_id_, int32 creation_date_, bool is_from_giveaway_, int53 giveaway_message_id_, int32 month_count_, int53 user_id_, int32 use_date_);

  static const std::int32_t ID = -1198544674;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class premiumGiftPaymentOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;
  int53 star_count_;
  int32 discount_percentage_;
  int32 month_count_;
  string store_product_id_;
  object_ptr<sticker> sticker_;

  premiumGiftPaymentOption();

  premiumGiftPaymentOption(string const &currency_, int53 amount_, int53 star_count_, int32 discount_percentage_, int32 month_count_, string const &store_product_id_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = -338085027;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumGiftPaymentOption;

class premiumGiftPaymentOptions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<premiumGiftPaymentOption>> options_;

  premiumGiftPaymentOptions();

  explicit premiumGiftPaymentOptions(array<object_ptr<premiumGiftPaymentOption>> &&options_);

  static const std::int32_t ID = -1347543032;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumGiveawayPaymentOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;
  int32 winner_count_;
  int32 month_count_;
  string store_product_id_;
  int32 store_product_quantity_;

  premiumGiveawayPaymentOption();

  premiumGiveawayPaymentOption(string const &currency_, int53 amount_, int32 winner_count_, int32 month_count_, string const &store_product_id_, int32 store_product_quantity_);

  static const std::int32_t ID = 1099221896;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumGiveawayPaymentOption;

class premiumGiveawayPaymentOptions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<premiumGiveawayPaymentOption>> options_;

  premiumGiveawayPaymentOptions();

  explicit premiumGiveawayPaymentOptions(array<object_ptr<premiumGiveawayPaymentOption>> &&options_);

  static const std::int32_t ID = -1587397823;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PremiumLimitType;

class premiumLimit final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PremiumLimitType> type_;
  int32 default_value_;
  int32 premium_value_;

  premiumLimit();

  premiumLimit(object_ptr<PremiumLimitType> &&type_, int32 default_value_, int32 premium_value_);

  static const std::int32_t ID = 2127786726;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PremiumLimitType: public Object {
 public:
};

class premiumLimitTypeSupergroupCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeSupergroupCount();

  static const std::int32_t ID = -247467131;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypePinnedChatCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypePinnedChatCount();

  static const std::int32_t ID = -998947871;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeCreatedPublicChatCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeCreatedPublicChatCount();

  static const std::int32_t ID = 446086841;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeSavedAnimationCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeSavedAnimationCount();

  static const std::int32_t ID = -19759735;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeFavoriteStickerCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeFavoriteStickerCount();

  static const std::int32_t ID = 639754787;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeChatFolderCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeChatFolderCount();

  static const std::int32_t ID = 377489774;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeChatFolderChosenChatCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeChatFolderChosenChatCount();

  static const std::int32_t ID = 1691435861;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypePinnedArchivedChatCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypePinnedArchivedChatCount();

  static const std::int32_t ID = 1485515276;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypePinnedSavedMessagesTopicCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypePinnedSavedMessagesTopicCount();

  static const std::int32_t ID = -1544854305;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeCaptionLength final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeCaptionLength();

  static const std::int32_t ID = 293984314;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeBioLength final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeBioLength();

  static const std::int32_t ID = -1146976765;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeChatFolderInviteLinkCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeChatFolderInviteLinkCount();

  static const std::int32_t ID = -128702950;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeShareableChatFolderCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeShareableChatFolderCount();

  static const std::int32_t ID = 1612625095;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeActiveStoryCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeActiveStoryCount();

  static const std::int32_t ID = -1926486372;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeWeeklyPostedStoryCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeWeeklyPostedStoryCount();

  static const std::int32_t ID = -506354313;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeMonthlyPostedStoryCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeMonthlyPostedStoryCount();

  static const std::int32_t ID = 26329490;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeStoryCaptionLength final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeStoryCaptionLength();

  static const std::int32_t ID = -1093324030;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeStorySuggestedReactionAreaCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeStorySuggestedReactionAreaCount();

  static const std::int32_t ID = -1170032633;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumLimitTypeSimilarChatCount final : public PremiumLimitType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumLimitTypeSimilarChatCount();

  static const std::int32_t ID = -1563549935;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InternalLinkType;

class premiumPaymentOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;
  int32 discount_percentage_;
  int32 month_count_;
  string store_product_id_;
  object_ptr<InternalLinkType> payment_link_;

  premiumPaymentOption();

  premiumPaymentOption(string const &currency_, int53 amount_, int32 discount_percentage_, int32 month_count_, string const &store_product_id_, object_ptr<InternalLinkType> &&payment_link_);

  static const std::int32_t ID = -1945346126;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessFeature;

class PremiumFeature;

class PremiumLimitType;

class PremiumStoryFeature;

class PremiumSource: public Object {
 public:
};

class premiumSourceLimitExceeded final : public PremiumSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PremiumLimitType> limit_type_;

  premiumSourceLimitExceeded();

  explicit premiumSourceLimitExceeded(object_ptr<PremiumLimitType> &&limit_type_);

  static const std::int32_t ID = -2052159742;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumSourceFeature final : public PremiumSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PremiumFeature> feature_;

  premiumSourceFeature();

  explicit premiumSourceFeature(object_ptr<PremiumFeature> &&feature_);

  static const std::int32_t ID = 445813541;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumSourceBusinessFeature final : public PremiumSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BusinessFeature> feature_;

  premiumSourceBusinessFeature();

  explicit premiumSourceBusinessFeature(object_ptr<BusinessFeature> &&feature_);

  static const std::int32_t ID = -1492946340;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumSourceStoryFeature final : public PremiumSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PremiumStoryFeature> feature_;

  premiumSourceStoryFeature();

  explicit premiumSourceStoryFeature(object_ptr<PremiumStoryFeature> &&feature_);

  static const std::int32_t ID = -1030737556;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumSourceLink final : public PremiumSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string referrer_;

  premiumSourceLink();

  explicit premiumSourceLink(string const &referrer_);

  static const std::int32_t ID = 2135071132;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumSourceSettings final : public PremiumSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumSourceSettings();

  static const std::int32_t ID = -285702859;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessFeaturePromotionAnimation;

class formattedText;

class premiumFeaturePromotionAnimation;

class premiumStatePaymentOption;

class premiumState final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> state_;
  array<object_ptr<premiumStatePaymentOption>> payment_options_;
  array<object_ptr<premiumFeaturePromotionAnimation>> animations_;
  array<object_ptr<businessFeaturePromotionAnimation>> business_animations_;

  premiumState();

  premiumState(object_ptr<formattedText> &&state_, array<object_ptr<premiumStatePaymentOption>> &&payment_options_, array<object_ptr<premiumFeaturePromotionAnimation>> &&animations_, array<object_ptr<businessFeaturePromotionAnimation>> &&business_animations_);

  static const std::int32_t ID = 1772082178;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumPaymentOption;

class premiumStatePaymentOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<premiumPaymentOption> payment_option_;
  bool is_current_;
  bool is_upgrade_;
  string last_transaction_id_;

  premiumStatePaymentOption();

  premiumStatePaymentOption(object_ptr<premiumPaymentOption> &&payment_option_, bool is_current_, bool is_upgrade_, string const &last_transaction_id_);

  static const std::int32_t ID = 2097591673;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PremiumStoryFeature: public Object {
 public:
};

class premiumStoryFeaturePriorityOrder final : public PremiumStoryFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumStoryFeaturePriorityOrder();

  static const std::int32_t ID = -1880001849;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumStoryFeatureStealthMode final : public PremiumStoryFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumStoryFeatureStealthMode();

  static const std::int32_t ID = 1194605988;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumStoryFeaturePermanentViewsHistory final : public PremiumStoryFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumStoryFeaturePermanentViewsHistory();

  static const std::int32_t ID = -1029683296;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumStoryFeatureCustomExpirationDuration final : public PremiumStoryFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumStoryFeatureCustomExpirationDuration();

  static const std::int32_t ID = -593229162;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumStoryFeatureSaveStories final : public PremiumStoryFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumStoryFeatureSaveStories();

  static const std::int32_t ID = -1501286467;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumStoryFeatureLinksAndFormatting final : public PremiumStoryFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumStoryFeatureLinksAndFormatting();

  static const std::int32_t ID = -622623753;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumStoryFeatureVideoQuality final : public PremiumStoryFeature {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  premiumStoryFeatureVideoQuality();

  static const std::int32_t ID = -1162887511;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GiveawayPrize;

class prepaidGiveaway final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 winner_count_;
  object_ptr<GiveawayPrize> prize_;
  int32 boost_count_;
  int32 payment_date_;

  prepaidGiveaway();

  prepaidGiveaway(int64 id_, int32 winner_count_, object_ptr<GiveawayPrize> &&prize_, int32 boost_count_, int32 payment_date_);

  static const std::int32_t ID = -277859441;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InlineQueryResult;

class targetChatTypes;

class preparedInlineMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 inline_query_id_;
  object_ptr<InlineQueryResult> result_;
  object_ptr<targetChatTypes> chat_types_;

  preparedInlineMessage();

  preparedInlineMessage(int64 inline_query_id_, object_ptr<InlineQueryResult> &&result_, object_ptr<targetChatTypes> &&chat_types_);

  static const std::int32_t ID = -1808892734;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class preparedInlineMessageId final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  int32 expiration_date_;

  preparedInlineMessageId();

  preparedInlineMessageId(string const &id_, int32 expiration_date_);

  static const std::int32_t ID = 940415972;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class photo;

class productInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  object_ptr<formattedText> description_;
  object_ptr<photo> photo_;

  productInfo();

  productInfo(string const &title_, object_ptr<formattedText> &&description_, object_ptr<photo> &&photo_);

  static const std::int32_t ID = -2015069020;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class profileAccentColors;

class profileAccentColor final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  object_ptr<profileAccentColors> light_theme_colors_;
  object_ptr<profileAccentColors> dark_theme_colors_;
  int32 min_supergroup_chat_boost_level_;
  int32 min_channel_chat_boost_level_;

  profileAccentColor();

  profileAccentColor(int32 id_, object_ptr<profileAccentColors> &&light_theme_colors_, object_ptr<profileAccentColors> &&dark_theme_colors_, int32 min_supergroup_chat_boost_level_, int32 min_channel_chat_boost_level_);

  static const std::int32_t ID = 557679253;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class profileAccentColors final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> palette_colors_;
  array<int32> background_colors_;
  array<int32> story_colors_;

  profileAccentColors();

  profileAccentColors(array<int32> &&palette_colors_, array<int32> &&background_colors_, array<int32> &&story_colors_);

  static const std::int32_t ID = -596042431;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class minithumbnail;

class profilePhoto final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  object_ptr<file> small_;
  object_ptr<file> big_;
  object_ptr<minithumbnail> minithumbnail_;
  bool has_animation_;
  bool is_personal_;

  profilePhoto();

  profilePhoto(int64 id_, object_ptr<file> &&small_, object_ptr<file> &&big_, object_ptr<minithumbnail> &&minithumbnail_, bool has_animation_, bool is_personal_);

  static const std::int32_t ID = -1025754018;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class proxy;

class proxies final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<proxy>> proxies_;

  proxies();

  explicit proxies(array<object_ptr<proxy>> &&proxies_);

  static const std::int32_t ID = 1200447205;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ProxyType;

class proxy final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  string server_;
  int32 port_;
  int32 last_used_date_;
  bool is_enabled_;
  object_ptr<ProxyType> type_;

  proxy();

  proxy(int32 id_, string const &server_, int32 port_, int32 last_used_date_, bool is_enabled_, object_ptr<ProxyType> &&type_);

  static const std::int32_t ID = 196049779;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ProxyType: public Object {
 public:
};

class proxyTypeSocks5 final : public ProxyType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string username_;
  string password_;

  proxyTypeSocks5();

  proxyTypeSocks5(string const &username_, string const &password_);

  static const std::int32_t ID = -890027341;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class proxyTypeHttp final : public ProxyType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string username_;
  string password_;
  bool http_only_;

  proxyTypeHttp();

  proxyTypeHttp(string const &username_, string const &password_, bool http_only_);

  static const std::int32_t ID = -1547188361;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class proxyTypeMtproto final : public ProxyType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string secret_;

  proxyTypeMtproto();

  explicit proxyTypeMtproto(string const &secret_);

  static const std::int32_t ID = -1964826627;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PublicChatType: public Object {
 public:
};

class publicChatTypeHasUsername final : public PublicChatType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  publicChatTypeHasUsername();

  static const std::int32_t ID = 350789758;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class publicChatTypeIsLocationBased final : public PublicChatType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  publicChatTypeIsLocationBased();

  static const std::int32_t ID = 1183735952;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class story;

class PublicForward: public Object {
 public:
};

class publicForwardMessage final : public PublicForward {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;

  publicForwardMessage();

  explicit publicForwardMessage(object_ptr<message> &&message_);

  static const std::int32_t ID = 51885010;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class publicForwardStory final : public PublicForward {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<story> story_;

  publicForwardStory();

  explicit publicForwardStory(object_ptr<story> &&story_);

  static const std::int32_t ID = 2145330863;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PublicForward;

class publicForwards final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<PublicForward>> forwards_;
  string next_offset_;

  publicForwards();

  publicForwards(int32 total_count_, array<object_ptr<PublicForward>> &&forwards_, string const &next_offset_);

  static const std::int32_t ID = -2011272719;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GiveawayPrize;

class animation;

class audio;

class document;

class photo;

class sticker;

class video;

class videoNote;

class voiceNote;

class PushMessageContent: public Object {
 public:
};

class pushMessageContentHidden final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_pinned_;

  pushMessageContentHidden();

  explicit pushMessageContentHidden(bool is_pinned_);

  static const std::int32_t ID = -316950436;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentAnimation final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<animation> animation_;
  string caption_;
  bool is_pinned_;

  pushMessageContentAnimation();

  pushMessageContentAnimation(object_ptr<animation> &&animation_, string const &caption_, bool is_pinned_);

  static const std::int32_t ID = 1034215396;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentAudio final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<audio> audio_;
  bool is_pinned_;

  pushMessageContentAudio();

  pushMessageContentAudio(object_ptr<audio> &&audio_, bool is_pinned_);

  static const std::int32_t ID = 381581426;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentContact final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  bool is_pinned_;

  pushMessageContentContact();

  pushMessageContentContact(string const &name_, bool is_pinned_);

  static const std::int32_t ID = -12219820;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentContactRegistered final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pushMessageContentContactRegistered();

  static const std::int32_t ID = -303962720;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentDocument final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<document> document_;
  bool is_pinned_;

  pushMessageContentDocument();

  pushMessageContentDocument(object_ptr<document> &&document_, bool is_pinned_);

  static const std::int32_t ID = -458379775;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentGame final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  bool is_pinned_;

  pushMessageContentGame();

  pushMessageContentGame(string const &title_, bool is_pinned_);

  static const std::int32_t ID = -515131109;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentGameScore final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  int32 score_;
  bool is_pinned_;

  pushMessageContentGameScore();

  pushMessageContentGameScore(string const &title_, int32 score_, bool is_pinned_);

  static const std::int32_t ID = 901303688;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentInvoice final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string price_;
  bool is_pinned_;

  pushMessageContentInvoice();

  pushMessageContentInvoice(string const &price_, bool is_pinned_);

  static const std::int32_t ID = -1731687492;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentLocation final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_live_;
  bool is_pinned_;

  pushMessageContentLocation();

  pushMessageContentLocation(bool is_live_, bool is_pinned_);

  static const std::int32_t ID = -1288005709;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentPaidMedia final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;
  bool is_pinned_;

  pushMessageContentPaidMedia();

  pushMessageContentPaidMedia(int53 star_count_, bool is_pinned_);

  static const std::int32_t ID = -1252595894;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentPhoto final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;
  string caption_;
  bool is_secret_;
  bool is_pinned_;

  pushMessageContentPhoto();

  pushMessageContentPhoto(object_ptr<photo> &&photo_, string const &caption_, bool is_secret_, bool is_pinned_);

  static const std::int32_t ID = 140631122;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentPoll final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string question_;
  bool is_regular_;
  bool is_pinned_;

  pushMessageContentPoll();

  pushMessageContentPoll(string const &question_, bool is_regular_, bool is_pinned_);

  static const std::int32_t ID = -44403654;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentPremiumGiftCode final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 month_count_;

  pushMessageContentPremiumGiftCode();

  explicit pushMessageContentPremiumGiftCode(int32 month_count_);

  static const std::int32_t ID = 413224997;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentGiveaway final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 winner_count_;
  object_ptr<GiveawayPrize> prize_;
  bool is_pinned_;

  pushMessageContentGiveaway();

  pushMessageContentGiveaway(int32 winner_count_, object_ptr<GiveawayPrize> &&prize_, bool is_pinned_);

  static const std::int32_t ID = -700547186;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentGift final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;

  pushMessageContentGift();

  explicit pushMessageContentGift(int53 star_count_);

  static const std::int32_t ID = -2069312245;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentUpgradedGift final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_upgrade_;

  pushMessageContentUpgradedGift();

  explicit pushMessageContentUpgradedGift(bool is_upgrade_);

  static const std::int32_t ID = -1711666466;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentScreenshotTaken final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pushMessageContentScreenshotTaken();

  static const std::int32_t ID = 214245369;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentSticker final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<sticker> sticker_;
  string emoji_;
  bool is_pinned_;

  pushMessageContentSticker();

  pushMessageContentSticker(object_ptr<sticker> &&sticker_, string const &emoji_, bool is_pinned_);

  static const std::int32_t ID = 1553513939;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentStory final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_mention_;
  bool is_pinned_;

  pushMessageContentStory();

  pushMessageContentStory(bool is_mention_, bool is_pinned_);

  static const std::int32_t ID = 599622223;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentText final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  bool is_pinned_;

  pushMessageContentText();

  pushMessageContentText(string const &text_, bool is_pinned_);

  static const std::int32_t ID = 274587305;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentVideo final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<video> video_;
  string caption_;
  bool is_secret_;
  bool is_pinned_;

  pushMessageContentVideo();

  pushMessageContentVideo(object_ptr<video> &&video_, string const &caption_, bool is_secret_, bool is_pinned_);

  static const std::int32_t ID = 310038831;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentVideoNote final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<videoNote> video_note_;
  bool is_pinned_;

  pushMessageContentVideoNote();

  pushMessageContentVideoNote(object_ptr<videoNote> &&video_note_, bool is_pinned_);

  static const std::int32_t ID = -1122764417;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentVoiceNote final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<voiceNote> voice_note_;
  bool is_pinned_;

  pushMessageContentVoiceNote();

  pushMessageContentVoiceNote(object_ptr<voiceNote> &&voice_note_, bool is_pinned_);

  static const std::int32_t ID = 88910987;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentBasicGroupChatCreate final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pushMessageContentBasicGroupChatCreate();

  static const std::int32_t ID = -2114855172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentVideoChatStarted final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pushMessageContentVideoChatStarted();

  static const std::int32_t ID = -566547393;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentVideoChatEnded final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pushMessageContentVideoChatEnded();

  static const std::int32_t ID = -1250265885;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentInviteVideoChatParticipants final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_current_user_;

  pushMessageContentInviteVideoChatParticipants();

  explicit pushMessageContentInviteVideoChatParticipants(bool is_current_user_);

  static const std::int32_t ID = 517620365;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentChatAddMembers final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string member_name_;
  bool is_current_user_;
  bool is_returned_;

  pushMessageContentChatAddMembers();

  pushMessageContentChatAddMembers(string const &member_name_, bool is_current_user_, bool is_returned_);

  static const std::int32_t ID = -1087145158;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentChatChangePhoto final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pushMessageContentChatChangePhoto();

  static const std::int32_t ID = -1114222051;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentChatChangeTitle final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;

  pushMessageContentChatChangeTitle();

  explicit pushMessageContentChatChangeTitle(string const &title_);

  static const std::int32_t ID = -1964902749;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentChatSetBackground final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_same_;

  pushMessageContentChatSetBackground();

  explicit pushMessageContentChatSetBackground(bool is_same_);

  static const std::int32_t ID = -1490331933;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentChatSetTheme final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string theme_name_;

  pushMessageContentChatSetTheme();

  explicit pushMessageContentChatSetTheme(string const &theme_name_);

  static const std::int32_t ID = 173882216;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentChatDeleteMember final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string member_name_;
  bool is_current_user_;
  bool is_left_;

  pushMessageContentChatDeleteMember();

  pushMessageContentChatDeleteMember(string const &member_name_, bool is_current_user_, bool is_left_);

  static const std::int32_t ID = 598714783;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentChatJoinByLink final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pushMessageContentChatJoinByLink();

  static const std::int32_t ID = 1553719113;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentChatJoinByRequest final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pushMessageContentChatJoinByRequest();

  static const std::int32_t ID = -205823627;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentRecurringPayment final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string amount_;

  pushMessageContentRecurringPayment();

  explicit pushMessageContentRecurringPayment(string const &amount_);

  static const std::int32_t ID = 1619211802;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentSuggestProfilePhoto final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  pushMessageContentSuggestProfilePhoto();

  static const std::int32_t ID = 2104225963;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentProximityAlertTriggered final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 distance_;

  pushMessageContentProximityAlertTriggered();

  explicit pushMessageContentProximityAlertTriggered(int32 distance_);

  static const std::int32_t ID = -264601594;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentMessageForwards final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;

  pushMessageContentMessageForwards();

  explicit pushMessageContentMessageForwards(int32 total_count_);

  static const std::int32_t ID = -1913083876;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushMessageContentMediaAlbum final : public PushMessageContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  bool has_photos_;
  bool has_videos_;
  bool has_audios_;
  bool has_documents_;

  pushMessageContentMediaAlbum();

  pushMessageContentMediaAlbum(int32 total_count_, bool has_photos_, bool has_videos_, bool has_audios_, bool has_documents_);

  static const std::int32_t ID = -748426897;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushReceiverId final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;

  pushReceiverId();

  explicit pushReceiverId(int64 id_);

  static const std::int32_t ID = 371056428;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageContent;

class MessageSendingState;

class ReplyMarkup;

class quickReplyMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 id_;
  object_ptr<MessageSendingState> sending_state_;
  bool can_be_edited_;
  int53 reply_to_message_id_;
  int53 via_bot_user_id_;
  int64 media_album_id_;
  object_ptr<MessageContent> content_;
  object_ptr<ReplyMarkup> reply_markup_;

  quickReplyMessage();

  quickReplyMessage(int53 id_, object_ptr<MessageSendingState> &&sending_state_, bool can_be_edited_, int53 reply_to_message_id_, int53 via_bot_user_id_, int64 media_album_id_, object_ptr<MessageContent> &&content_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = -1090965757;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class quickReplyMessage;

class quickReplyMessages final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<quickReplyMessage>> messages_;

  quickReplyMessages();

  explicit quickReplyMessages(array<object_ptr<quickReplyMessage>> &&messages_);

  static const std::int32_t ID = 743214375;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class quickReplyMessage;

class quickReplyShortcut final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  string name_;
  object_ptr<quickReplyMessage> first_message_;
  int32 message_count_;

  quickReplyShortcut();

  quickReplyShortcut(int32 id_, string const &name_, object_ptr<quickReplyMessage> &&first_message_, int32 message_count_);

  static const std::int32_t ID = -1107453291;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionNotificationSource;

class reactionNotificationSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionNotificationSource> message_reaction_source_;
  object_ptr<ReactionNotificationSource> story_reaction_source_;
  int64 sound_id_;
  bool show_preview_;

  reactionNotificationSettings();

  reactionNotificationSettings(object_ptr<ReactionNotificationSource> &&message_reaction_source_, object_ptr<ReactionNotificationSource> &&story_reaction_source_, int64 sound_id_, bool show_preview_);

  static const std::int32_t ID = 733017684;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionNotificationSource: public Object {
 public:
};

class reactionNotificationSourceNone final : public ReactionNotificationSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reactionNotificationSourceNone();

  static const std::int32_t ID = 366374940;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionNotificationSourceContacts final : public ReactionNotificationSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reactionNotificationSourceContacts();

  static const std::int32_t ID = 555501621;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionNotificationSourceAll final : public ReactionNotificationSource {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reactionNotificationSourceAll();

  static const std::int32_t ID = 1241689234;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType: public Object {
 public:
};

class reactionTypeEmoji final : public ReactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoji_;

  reactionTypeEmoji();

  explicit reactionTypeEmoji(string const &emoji_);

  static const std::int32_t ID = -1942084920;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionTypeCustomEmoji final : public ReactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 custom_emoji_id_;

  reactionTypeCustomEmoji();

  explicit reactionTypeCustomEmoji(int64 custom_emoji_id_);

  static const std::int32_t ID = -989117709;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionTypePaid final : public ReactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reactionTypePaid();

  static const std::int32_t ID = 436294381;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionUnavailabilityReason: public Object {
 public:
};

class reactionUnavailabilityReasonAnonymousAdministrator final : public ReactionUnavailabilityReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reactionUnavailabilityReasonAnonymousAdministrator();

  static const std::int32_t ID = -499612677;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reactionUnavailabilityReasonGuest final : public ReactionUnavailabilityReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reactionUnavailabilityReasonGuest();

  static const std::int32_t ID = 1357861444;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class readDatePrivacySettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool show_read_date_;

  readDatePrivacySettings();

  explicit readDatePrivacySettings(bool show_read_date_);

  static const std::int32_t ID = 1654842920;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class SentGift;

class formattedText;

class receivedGift final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string received_gift_id_;
  object_ptr<MessageSender> sender_id_;
  object_ptr<formattedText> text_;
  bool is_private_;
  bool is_saved_;
  bool is_pinned_;
  bool can_be_upgraded_;
  bool can_be_transferred_;
  bool was_refunded_;
  int32 date_;
  object_ptr<SentGift> gift_;
  int53 sell_star_count_;
  int53 prepaid_upgrade_star_count_;
  int53 transfer_star_count_;
  int32 next_transfer_date_;
  int32 next_resale_date_;
  int32 export_date_;

  receivedGift();

  receivedGift(string const &received_gift_id_, object_ptr<MessageSender> &&sender_id_, object_ptr<formattedText> &&text_, bool is_private_, bool is_saved_, bool is_pinned_, bool can_be_upgraded_, bool can_be_transferred_, bool was_refunded_, int32 date_, object_ptr<SentGift> &&gift_, int53 sell_star_count_, int53 prepaid_upgrade_star_count_, int53 transfer_star_count_, int32 next_transfer_date_, int32 next_resale_date_, int32 export_date_);

  static const std::int32_t ID = 61550296;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class receivedGift;

class receivedGifts final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<receivedGift>> gifts_;
  bool are_notifications_enabled_;
  string next_offset_;

  receivedGifts();

  receivedGifts(int32 total_count_, array<object_ptr<receivedGift>> &&gifts_, bool are_notifications_enabled_, string const &next_offset_);

  static const std::int32_t ID = 1237114400;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolder;

class recommendedChatFolder final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatFolder> folder_;
  string description_;

  recommendedChatFolder();

  recommendedChatFolder(object_ptr<chatFolder> &&folder_, string const &description_);

  static const std::int32_t ID = -2116569930;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class recommendedChatFolder;

class recommendedChatFolders final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<recommendedChatFolder>> chat_folders_;

  recommendedChatFolders();

  explicit recommendedChatFolders(array<object_ptr<recommendedChatFolder>> &&chat_folders_);

  static const std::int32_t ID = -739217656;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class recoveryEmailAddress final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string recovery_email_address_;

  recoveryEmailAddress();

  explicit recoveryEmailAddress(string const &recovery_email_address_);

  static const std::int32_t ID = 1290526187;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class remoteFile final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string unique_id_;
  bool is_uploading_active_;
  bool is_uploading_completed_;
  int53 uploaded_size_;

  remoteFile();

  remoteFile(string const &id_, string const &unique_id_, bool is_uploading_active_, bool is_uploading_completed_, int53 uploaded_size_);

  static const std::int32_t ID = 747731030;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineKeyboardButton;

class keyboardButton;

class ReplyMarkup: public Object {
 public:
};

class replyMarkupRemoveKeyboard final : public ReplyMarkup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_personal_;

  replyMarkupRemoveKeyboard();

  explicit replyMarkupRemoveKeyboard(bool is_personal_);

  static const std::int32_t ID = -691252879;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class replyMarkupForceReply final : public ReplyMarkup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_personal_;
  string input_field_placeholder_;

  replyMarkupForceReply();

  replyMarkupForceReply(bool is_personal_, string const &input_field_placeholder_);

  static const std::int32_t ID = 1101461919;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class replyMarkupShowKeyboard final : public ReplyMarkup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<array<object_ptr<keyboardButton>>> rows_;
  bool is_persistent_;
  bool resize_keyboard_;
  bool one_time_;
  bool is_personal_;
  string input_field_placeholder_;

  replyMarkupShowKeyboard();

  replyMarkupShowKeyboard(array<array<object_ptr<keyboardButton>>> &&rows_, bool is_persistent_, bool resize_keyboard_, bool one_time_, bool is_personal_, string const &input_field_placeholder_);

  static const std::int32_t ID = -791495984;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class replyMarkupInlineKeyboard final : public ReplyMarkup {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<array<object_ptr<inlineKeyboardButton>>> rows_;

  replyMarkupInlineKeyboard();

  explicit replyMarkupInlineKeyboard(array<array<object_ptr<inlineKeyboardButton>>> &&rows_);

  static const std::int32_t ID = -619317658;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportOption;

class ReportChatResult: public Object {
 public:
};

class reportChatResultOk final : public ReportChatResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportChatResultOk();

  static const std::int32_t ID = 1209685373;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportChatResultOptionRequired final : public ReportChatResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  array<object_ptr<reportOption>> options_;

  reportChatResultOptionRequired();

  reportChatResultOptionRequired(string const &title_, array<object_ptr<reportOption>> &&options_);

  static const std::int32_t ID = -881375669;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportChatResultTextRequired final : public ReportChatResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes option_id_;
  bool is_optional_;

  reportChatResultTextRequired();

  reportChatResultTextRequired(bytes const &option_id_, bool is_optional_);

  static const std::int32_t ID = -1949552447;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportChatResultMessagesRequired final : public ReportChatResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportChatResultMessagesRequired();

  static const std::int32_t ID = 106043280;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes id_;
  string text_;

  reportOption();

  reportOption(bytes const &id_, string const &text_);

  static const std::int32_t ID = 1106390048;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReportReason: public Object {
 public:
};

class reportReasonSpam final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonSpam();

  static const std::int32_t ID = -1207032897;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportReasonViolence final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonViolence();

  static const std::int32_t ID = 2038679353;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportReasonPornography final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonPornography();

  static const std::int32_t ID = 1306467575;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportReasonChildAbuse final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonChildAbuse();

  static const std::int32_t ID = 761086718;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportReasonCopyright final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonCopyright();

  static const std::int32_t ID = 1474441135;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportReasonUnrelatedLocation final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonUnrelatedLocation();

  static const std::int32_t ID = 87562288;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportReasonFake final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonFake();

  static const std::int32_t ID = 352862176;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportReasonIllegalDrugs final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonIllegalDrugs();

  static const std::int32_t ID = -61599200;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportReasonPersonalDetails final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonPersonalDetails();

  static const std::int32_t ID = -1588882414;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportReasonCustom final : public ReportReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportReasonCustom();

  static const std::int32_t ID = -1380459917;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportOption;

class ReportSponsoredResult: public Object {
 public:
};

class reportSponsoredResultOk final : public ReportSponsoredResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportSponsoredResultOk();

  static const std::int32_t ID = -128473456;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportSponsoredResultFailed final : public ReportSponsoredResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportSponsoredResultFailed();

  static const std::int32_t ID = 1231714278;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportSponsoredResultOptionRequired final : public ReportSponsoredResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  array<object_ptr<reportOption>> options_;

  reportSponsoredResultOptionRequired();

  reportSponsoredResultOptionRequired(string const &title_, array<object_ptr<reportOption>> &&options_);

  static const std::int32_t ID = -1646687318;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportSponsoredResultAdsHidden final : public ReportSponsoredResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportSponsoredResultAdsHidden();

  static const std::int32_t ID = -372279531;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportSponsoredResultPremiumRequired final : public ReportSponsoredResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportSponsoredResultPremiumRequired();

  static const std::int32_t ID = -55411887;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportOption;

class ReportStoryResult: public Object {
 public:
};

class reportStoryResultOk final : public ReportStoryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  reportStoryResultOk();

  static const std::int32_t ID = -1405328461;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportStoryResultOptionRequired final : public ReportStoryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  array<object_ptr<reportOption>> options_;

  reportStoryResultOptionRequired();

  reportStoryResultOptionRequired(string const &title_, array<object_ptr<reportOption>> &&options_);

  static const std::int32_t ID = 1632974839;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class reportStoryResultTextRequired final : public ReportStoryResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes option_id_;
  bool is_optional_;

  reportStoryResultTextRequired();

  reportStoryResultTextRequired(bytes const &option_id_, bool is_optional_);

  static const std::int32_t ID = 334339473;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ResendCodeReason: public Object {
 public:
};

class resendCodeReasonUserRequest final : public ResendCodeReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  resendCodeReasonUserRequest();

  static const std::int32_t ID = -441923456;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class resendCodeReasonVerificationFailed final : public ResendCodeReason {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string error_message_;

  resendCodeReasonVerificationFailed();

  explicit resendCodeReasonVerificationFailed(string const &error_message_);

  static const std::int32_t ID = 529870273;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ResetPasswordResult: public Object {
 public:
};

class resetPasswordResultOk final : public ResetPasswordResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  resetPasswordResultOk();

  static const std::int32_t ID = -1397267463;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class resetPasswordResultPending final : public ResetPasswordResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 pending_reset_date_;

  resetPasswordResultPending();

  explicit resetPasswordResultPending(int32 pending_reset_date_);

  static const std::int32_t ID = 1193925721;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class resetPasswordResultDeclined final : public ResetPasswordResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 retry_date_;

  resetPasswordResultDeclined();

  explicit resetPasswordResultDeclined(int32 retry_date_);

  static const std::int32_t ID = -1202200373;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class RevenueWithdrawalState: public Object {
 public:
};

class revenueWithdrawalStatePending final : public RevenueWithdrawalState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  revenueWithdrawalStatePending();

  static const std::int32_t ID = 1563512741;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class revenueWithdrawalStateSucceeded final : public RevenueWithdrawalState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 date_;
  string url_;

  revenueWithdrawalStateSucceeded();

  revenueWithdrawalStateSucceeded(int32 date_, string const &url_);

  static const std::int32_t ID = 265375242;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class revenueWithdrawalStateFailed final : public RevenueWithdrawalState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  revenueWithdrawalStateFailed();

  static const std::int32_t ID = -12504951;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class RichText;

class document;

class RichText: public Object {
 public:
};

class richTextPlain final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  richTextPlain();

  explicit richTextPlain(string const &text_);

  static const std::int32_t ID = 482617702;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextBold final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  richTextBold();

  explicit richTextBold(object_ptr<RichText> &&text_);

  static const std::int32_t ID = 1670844268;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextItalic final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  richTextItalic();

  explicit richTextItalic(object_ptr<RichText> &&text_);

  static const std::int32_t ID = 1853354047;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextUnderline final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  richTextUnderline();

  explicit richTextUnderline(object_ptr<RichText> &&text_);

  static const std::int32_t ID = -536019572;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextStrikethrough final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  richTextStrikethrough();

  explicit richTextStrikethrough(object_ptr<RichText> &&text_);

  static const std::int32_t ID = 723413585;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextFixed final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  richTextFixed();

  explicit richTextFixed(object_ptr<RichText> &&text_);

  static const std::int32_t ID = -1271496249;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextUrl final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string url_;
  bool is_cached_;

  richTextUrl();

  richTextUrl(object_ptr<RichText> &&text_, string const &url_, bool is_cached_);

  static const std::int32_t ID = 83939092;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextEmailAddress final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string email_address_;

  richTextEmailAddress();

  richTextEmailAddress(object_ptr<RichText> &&text_, string const &email_address_);

  static const std::int32_t ID = 40018679;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextSubscript final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  richTextSubscript();

  explicit richTextSubscript(object_ptr<RichText> &&text_);

  static const std::int32_t ID = -868197812;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextSuperscript final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  richTextSuperscript();

  explicit richTextSuperscript(object_ptr<RichText> &&text_);

  static const std::int32_t ID = -382241437;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextMarked final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;

  richTextMarked();

  explicit richTextMarked(object_ptr<RichText> &&text_);

  static const std::int32_t ID = -1271999614;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextPhoneNumber final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string phone_number_;

  richTextPhoneNumber();

  richTextPhoneNumber(object_ptr<RichText> &&text_, string const &phone_number_);

  static const std::int32_t ID = 128521539;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextIcon final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<document> document_;
  int32 width_;
  int32 height_;

  richTextIcon();

  richTextIcon(object_ptr<document> &&document_, int32 width_, int32 height_);

  static const std::int32_t ID = -1480316158;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextReference final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string anchor_name_;
  string url_;

  richTextReference();

  richTextReference(object_ptr<RichText> &&text_, string const &anchor_name_, string const &url_);

  static const std::int32_t ID = -1147530634;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextAnchor final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  richTextAnchor();

  explicit richTextAnchor(string const &name_);

  static const std::int32_t ID = 1316950068;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTextAnchorLink final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RichText> text_;
  string anchor_name_;
  string url_;

  richTextAnchorLink();

  richTextAnchorLink(object_ptr<RichText> &&text_, string const &anchor_name_, string const &url_);

  static const std::int32_t ID = -1541418282;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class richTexts final : public RichText {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<RichText>> texts_;

  richTexts();

  explicit richTexts(array<object_ptr<RichText>> &&texts_);

  static const std::int32_t ID = 1647457821;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class rtmpUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  string stream_key_;

  rtmpUrl();

  rtmpUrl(string const &url_, string const &stream_key_);

  static const std::int32_t ID = 1009302613;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class savedCredentials final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;

  savedCredentials();

  savedCredentials(string const &id_, string const &title_);

  static const std::int32_t ID = -370273060;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType;

class savedMessagesTag final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionType> tag_;
  string label_;
  int32 count_;

  savedMessagesTag();

  savedMessagesTag(object_ptr<ReactionType> &&tag_, string const &label_, int32 count_);

  static const std::int32_t ID = 1785183329;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class savedMessagesTag;

class savedMessagesTags final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<savedMessagesTag>> tags_;

  savedMessagesTags();

  explicit savedMessagesTags(array<object_ptr<savedMessagesTag>> &&tags_);

  static const std::int32_t ID = -1749291430;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SavedMessagesTopicType;

class draftMessage;

class message;

class savedMessagesTopic final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 id_;
  object_ptr<SavedMessagesTopicType> type_;
  bool is_pinned_;
  int64 order_;
  object_ptr<message> last_message_;
  object_ptr<draftMessage> draft_message_;

  savedMessagesTopic();

  savedMessagesTopic(int53 id_, object_ptr<SavedMessagesTopicType> &&type_, bool is_pinned_, int64 order_, object_ptr<message> &&last_message_, object_ptr<draftMessage> &&draft_message_);

  static const std::int32_t ID = -760684124;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SavedMessagesTopicType: public Object {
 public:
};

class savedMessagesTopicTypeMyNotes final : public SavedMessagesTopicType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  savedMessagesTopicTypeMyNotes();

  static const std::int32_t ID = -1282784779;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class savedMessagesTopicTypeAuthorHidden final : public SavedMessagesTopicType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  savedMessagesTopicTypeAuthorHidden();

  static const std::int32_t ID = 1882997141;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class savedMessagesTopicTypeSavedFromChat final : public SavedMessagesTopicType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  savedMessagesTopicTypeSavedFromChat();

  explicit savedMessagesTopicTypeSavedFromChat(int53 chat_id_);

  static const std::int32_t ID = -1723880104;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class scopeAutosaveSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool autosave_photos_;
  bool autosave_videos_;
  int53 max_video_file_size_;

  scopeAutosaveSettings();

  scopeAutosaveSettings(bool autosave_photos_, bool autosave_videos_, int53 max_video_file_size_);

  static const std::int32_t ID = 1546821427;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class scopeNotificationSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 mute_for_;
  int64 sound_id_;
  bool show_preview_;
  bool use_default_mute_stories_;
  bool mute_stories_;
  int64 story_sound_id_;
  bool show_story_poster_;
  bool disable_pinned_message_notifications_;
  bool disable_mention_notifications_;

  scopeNotificationSettings();

  scopeNotificationSettings(int32 mute_for_, int64 sound_id_, bool show_preview_, bool use_default_mute_stories_, bool mute_stories_, int64 story_sound_id_, bool show_story_poster_, bool disable_pinned_message_notifications_, bool disable_mention_notifications_);

  static const std::int32_t ID = 88369150;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SearchMessagesChatTypeFilter: public Object {
 public:
};

class searchMessagesChatTypeFilterPrivate final : public SearchMessagesChatTypeFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesChatTypeFilterPrivate();

  static const std::int32_t ID = 1169248975;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesChatTypeFilterGroup final : public SearchMessagesChatTypeFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesChatTypeFilterGroup();

  static const std::int32_t ID = -2059426022;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesChatTypeFilterChannel final : public SearchMessagesChatTypeFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesChatTypeFilterChannel();

  static const std::int32_t ID = -773540139;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SearchMessagesFilter: public Object {
 public:
};

class searchMessagesFilterEmpty final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterEmpty();

  static const std::int32_t ID = -869395657;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterAnimation final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterAnimation();

  static const std::int32_t ID = -155713339;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterAudio final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterAudio();

  static const std::int32_t ID = 867505275;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterDocument final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterDocument();

  static const std::int32_t ID = 1526331215;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterPhoto final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterPhoto();

  static const std::int32_t ID = 925932293;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterVideo final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterVideo();

  static const std::int32_t ID = 115538222;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterVoiceNote final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterVoiceNote();

  static const std::int32_t ID = 1841439357;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterPhotoAndVideo final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterPhotoAndVideo();

  static const std::int32_t ID = 1352130963;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterUrl final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterUrl();

  static const std::int32_t ID = -1828724341;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterChatPhoto final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterChatPhoto();

  static const std::int32_t ID = -1247751329;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterVideoNote final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterVideoNote();

  static const std::int32_t ID = 564323321;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterVoiceAndVideoNote final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterVoiceAndVideoNote();

  static const std::int32_t ID = 664174819;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterMention final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterMention();

  static const std::int32_t ID = 2001258652;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterUnreadMention final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterUnreadMention();

  static const std::int32_t ID = -95769149;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterUnreadReaction final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterUnreadReaction();

  static const std::int32_t ID = -1379651328;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterFailedToSend final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterFailedToSend();

  static const std::int32_t ID = -596322564;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class searchMessagesFilterPinned final : public SearchMessagesFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  searchMessagesFilterPinned();

  static const std::int32_t ID = 371805512;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class seconds final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double seconds_;

  seconds();

  explicit seconds(double seconds_);

  static const std::int32_t ID = 959899022;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecretChatState;

class secretChat final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int53 user_id_;
  object_ptr<SecretChatState> state_;
  bool is_outbound_;
  bytes key_hash_;
  int32 layer_;

  secretChat();

  secretChat(int32 id_, int53 user_id_, object_ptr<SecretChatState> &&state_, bool is_outbound_, bytes const &key_hash_, int32 layer_);

  static const std::int32_t ID = -676918325;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SecretChatState: public Object {
 public:
};

class secretChatStatePending final : public SecretChatState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  secretChatStatePending();

  static const std::int32_t ID = -1637050756;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secretChatStateReady final : public SecretChatState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  secretChatStateReady();

  static const std::int32_t ID = -1611352087;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secretChatStateClosed final : public SecretChatState {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  secretChatStateClosed();

  static const std::int32_t ID = -1945106707;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class gift;

class upgradedGift;

class SentGift: public Object {
 public:
};

class sentGiftRegular final : public SentGift {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<gift> gift_;

  sentGiftRegular();

  explicit sentGiftRegular(object_ptr<gift> &&gift_);

  static const std::int32_t ID = 594062617;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sentGiftUpgraded final : public SentGift {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<upgradedGift> gift_;

  sentGiftUpgraded();

  explicit sentGiftUpgraded(object_ptr<upgradedGift> &&gift_);

  static const std::int32_t ID = 627524736;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sentWebAppMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string inline_message_id_;

  sentWebAppMessage();

  explicit sentWebAppMessage(string const &inline_message_id_);

  static const std::int32_t ID = 1243934400;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SessionType;

class session final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  bool is_current_;
  bool is_password_pending_;
  bool is_unconfirmed_;
  bool can_accept_secret_chats_;
  bool can_accept_calls_;
  object_ptr<SessionType> type_;
  int32 api_id_;
  string application_name_;
  string application_version_;
  bool is_official_application_;
  string device_model_;
  string platform_;
  string system_version_;
  int32 log_in_date_;
  int32 last_active_date_;
  string ip_address_;
  string location_;

  session();

  session(int64 id_, bool is_current_, bool is_password_pending_, bool is_unconfirmed_, bool can_accept_secret_chats_, bool can_accept_calls_, object_ptr<SessionType> &&type_, int32 api_id_, string const &application_name_, string const &application_version_, bool is_official_application_, string const &device_model_, string const &platform_, string const &system_version_, int32 log_in_date_, int32 last_active_date_, string const &ip_address_, string const &location_);

  static const std::int32_t ID = 158702140;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SessionType: public Object {
 public:
};

class sessionTypeAndroid final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeAndroid();

  static const std::int32_t ID = -2071764840;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeApple final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeApple();

  static const std::int32_t ID = -1818635701;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeBrave final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeBrave();

  static const std::int32_t ID = -1216812563;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeChrome final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeChrome();

  static const std::int32_t ID = 1573464425;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeEdge final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeEdge();

  static const std::int32_t ID = -538916005;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeFirefox final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeFirefox();

  static const std::int32_t ID = 2122579364;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeIpad final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeIpad();

  static const std::int32_t ID = 1294647023;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeIphone final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeIphone();

  static const std::int32_t ID = 97616573;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeLinux final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeLinux();

  static const std::int32_t ID = -1487422871;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeMac final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeMac();

  static const std::int32_t ID = -612250975;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeOpera final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeOpera();

  static const std::int32_t ID = -1463673734;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeSafari final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeSafari();

  static const std::int32_t ID = 710646873;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeUbuntu final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeUbuntu();

  static const std::int32_t ID = 1569680069;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeUnknown final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeUnknown();

  static const std::int32_t ID = 233926704;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeVivaldi final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeVivaldi();

  static const std::int32_t ID = 1120503279;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeWindows final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeWindows();

  static const std::int32_t ID = -1676512600;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessionTypeXbox final : public SessionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  sessionTypeXbox();

  static const std::int32_t ID = 1856216492;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class session;

class sessions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<session>> sessions_;
  int32 inactive_session_ttl_days_;

  sessions();

  sessions(array<object_ptr<session>> &&sessions_, int32 inactive_session_ttl_days_);

  static const std::int32_t ID = 842912274;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photo;

class sharedChat final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string title_;
  string username_;
  object_ptr<photo> photo_;

  sharedChat();

  sharedChat(int53 chat_id_, string const &title_, string const &username_, object_ptr<photo> &&photo_);

  static const std::int32_t ID = 1250406426;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photo;

class sharedUser final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string first_name_;
  string last_name_;
  string username_;
  object_ptr<photo> photo_;

  sharedUser();

  sharedUser(int53 user_id_, string const &first_name_, string const &last_name_, string const &username_, object_ptr<photo> &&photo_);

  static const std::int32_t ID = 293020919;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class labeledPricePart;

class shippingOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string title_;
  array<object_ptr<labeledPricePart>> price_parts_;

  shippingOption();

  shippingOption(string const &id_, string const &title_, array<object_ptr<labeledPricePart>> &&price_parts_);

  static const std::int32_t ID = 1425690001;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class error;

class SpeechRecognitionResult: public Object {
 public:
};

class speechRecognitionResultPending final : public SpeechRecognitionResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string partial_text_;

  speechRecognitionResultPending();

  explicit speechRecognitionResultPending(string const &partial_text_);

  static const std::int32_t ID = -1631810048;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class speechRecognitionResultText final : public SpeechRecognitionResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  speechRecognitionResultText();

  explicit speechRecognitionResultText(string const &text_);

  static const std::int32_t ID = -2132377123;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class speechRecognitionResultError final : public SpeechRecognitionResult {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<error> error_;

  speechRecognitionResultError();

  explicit speechRecognitionResultError(object_ptr<error> &&error_);

  static const std::int32_t ID = 164774908;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sponsoredChat final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 unique_id_;
  int53 chat_id_;
  string sponsor_info_;
  string additional_info_;

  sponsoredChat();

  sponsoredChat(int53 unique_id_, int53 chat_id_, string const &sponsor_info_, string const &additional_info_);

  static const std::int32_t ID = -325763489;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sponsoredChat;

class sponsoredChats final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<sponsoredChat>> chats_;

  sponsoredChats();

  explicit sponsoredChats(array<object_ptr<sponsoredChat>> &&chats_);

  static const std::int32_t ID = 536300641;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageContent;

class messageSponsor;

class sponsoredMessage final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 message_id_;
  bool is_recommended_;
  bool can_be_reported_;
  object_ptr<MessageContent> content_;
  object_ptr<messageSponsor> sponsor_;
  string title_;
  string button_text_;
  int32 accent_color_id_;
  int64 background_custom_emoji_id_;
  string additional_info_;

  sponsoredMessage();

  sponsoredMessage(int53 message_id_, bool is_recommended_, bool can_be_reported_, object_ptr<MessageContent> &&content_, object_ptr<messageSponsor> &&sponsor_, string const &title_, string const &button_text_, int32 accent_color_id_, int64 background_custom_emoji_id_, string const &additional_info_);

  static const std::int32_t ID = -1215476699;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sponsoredMessage;

class sponsoredMessages final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<sponsoredMessage>> messages_;
  int32 messages_between_;

  sponsoredMessages();

  sponsoredMessages(array<object_ptr<sponsoredMessage>> &&messages_, int32 messages_between_);

  static const std::int32_t ID = -537674389;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starAmount final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;
  int32 nanostar_count_;

  starAmount();

  starAmount(int53 star_count_, int32 nanostar_count_);

  static const std::int32_t ID = 1863216512;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starCount final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 star_count_;

  starCount();

  explicit starCount(int53 star_count_);

  static const std::int32_t ID = -1566395144;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starGiveawayWinnerOption;

class starGiveawayPaymentOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;
  int53 star_count_;
  string store_product_id_;
  int32 yearly_boost_count_;
  array<object_ptr<starGiveawayWinnerOption>> winner_options_;
  bool is_default_;
  bool is_additional_;

  starGiveawayPaymentOption();

  starGiveawayPaymentOption(string const &currency_, int53 amount_, int53 star_count_, string const &store_product_id_, int32 yearly_boost_count_, array<object_ptr<starGiveawayWinnerOption>> &&winner_options_, bool is_default_, bool is_additional_);

  static const std::int32_t ID = 565089625;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starGiveawayPaymentOption;

class starGiveawayPaymentOptions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<starGiveawayPaymentOption>> options_;

  starGiveawayPaymentOptions();

  explicit starGiveawayPaymentOptions(array<object_ptr<starGiveawayPaymentOption>> &&options_);

  static const std::int32_t ID = -1216716679;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starGiveawayWinnerOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 winner_count_;
  int53 won_star_count_;
  bool is_default_;

  starGiveawayWinnerOption();

  starGiveawayWinnerOption(int32 winner_count_, int53 won_star_count_, bool is_default_);

  static const std::int32_t ID = -865888761;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starPaymentOption final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;
  int53 star_count_;
  string store_product_id_;
  bool is_additional_;

  starPaymentOption();

  starPaymentOption(string const &currency_, int53 amount_, int53 star_count_, string const &store_product_id_, bool is_additional_);

  static const std::int32_t ID = -1364056047;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starPaymentOption;

class starPaymentOptions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<starPaymentOption>> options_;

  starPaymentOptions();

  explicit starPaymentOptions(array<object_ptr<starPaymentOption>> &&options_);

  static const std::int32_t ID = -423720498;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatisticalGraph;

class starRevenueStatus;

class starRevenueStatistics final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StatisticalGraph> revenue_by_day_graph_;
  object_ptr<starRevenueStatus> status_;
  double usd_rate_;

  starRevenueStatistics();

  starRevenueStatistics(object_ptr<StatisticalGraph> &&revenue_by_day_graph_, object_ptr<starRevenueStatus> &&status_, double usd_rate_);

  static const std::int32_t ID = -1121086889;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starAmount;

class starRevenueStatus final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<starAmount> total_amount_;
  object_ptr<starAmount> current_amount_;
  object_ptr<starAmount> available_amount_;
  bool withdrawal_enabled_;
  int32 next_withdrawal_in_;

  starRevenueStatus();

  starRevenueStatus(object_ptr<starAmount> &&total_amount_, object_ptr<starAmount> &&current_amount_, object_ptr<starAmount> &&available_amount_, bool withdrawal_enabled_, int32 next_withdrawal_in_);

  static const std::int32_t ID = 2006266600;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StarSubscriptionType;

class starSubscriptionPricing;

class starSubscription final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  int53 chat_id_;
  int32 expiration_date_;
  bool is_canceled_;
  bool is_expiring_;
  object_ptr<starSubscriptionPricing> pricing_;
  object_ptr<StarSubscriptionType> type_;

  starSubscription();

  starSubscription(string const &id_, int53 chat_id_, int32 expiration_date_, bool is_canceled_, bool is_expiring_, object_ptr<starSubscriptionPricing> &&pricing_, object_ptr<StarSubscriptionType> &&type_);

  static const std::int32_t ID = 976753141;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starSubscriptionPricing final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 period_;
  int53 star_count_;

  starSubscriptionPricing();

  starSubscriptionPricing(int32 period_, int53 star_count_);

  static const std::int32_t ID = -1767733162;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photo;

class StarSubscriptionType: public Object {
 public:
};

class starSubscriptionTypeChannel final : public StarSubscriptionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool can_reuse_;
  string invite_link_;

  starSubscriptionTypeChannel();

  starSubscriptionTypeChannel(bool can_reuse_, string const &invite_link_);

  static const std::int32_t ID = -1030048011;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starSubscriptionTypeBot final : public StarSubscriptionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_canceled_by_bot_;
  string title_;
  object_ptr<photo> photo_;
  string invoice_link_;

  starSubscriptionTypeBot();

  starSubscriptionTypeBot(bool is_canceled_by_bot_, string const &title_, object_ptr<photo> &&photo_, string const &invoice_link_);

  static const std::int32_t ID = 226024914;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starAmount;

class starSubscription;

class starSubscriptions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<starAmount> star_amount_;
  array<object_ptr<starSubscription>> subscriptions_;
  int53 required_star_count_;
  string next_offset_;

  starSubscriptions();

  starSubscriptions(object_ptr<starAmount> &&star_amount_, array<object_ptr<starSubscription>> &&subscriptions_, int53 required_star_count_, string const &next_offset_);

  static const std::int32_t ID = 151169395;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StarTransactionType;

class starAmount;

class starTransaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  object_ptr<starAmount> star_amount_;
  bool is_refund_;
  int32 date_;
  object_ptr<StarTransactionType> type_;

  starTransaction();

  starTransaction(string const &id_, object_ptr<starAmount> &&star_amount_, bool is_refund_, int32 date_, object_ptr<StarTransactionType> &&type_);

  static const std::int32_t ID = 2139228816;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StarTransactionDirection: public Object {
 public:
};

class starTransactionDirectionIncoming final : public StarTransactionDirection {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  starTransactionDirectionIncoming();

  static const std::int32_t ID = -1295335866;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionDirectionOutgoing final : public StarTransactionDirection {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  starTransactionDirectionOutgoing();

  static const std::int32_t ID = 1854125472;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class PaidMedia;

class RevenueWithdrawalState;

class affiliateInfo;

class gift;

class productInfo;

class starAmount;

class sticker;

class upgradedGift;

class StarTransactionType: public Object {
 public:
};

class starTransactionTypePremiumBotDeposit final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  starTransactionTypePremiumBotDeposit();

  static const std::int32_t ID = -663156466;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeAppStoreDeposit final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  starTransactionTypeAppStoreDeposit();

  static const std::int32_t ID = 136853825;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeGooglePlayDeposit final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  starTransactionTypeGooglePlayDeposit();

  static const std::int32_t ID = -323111338;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeFragmentDeposit final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  starTransactionTypeFragmentDeposit();

  static const std::int32_t ID = 123887172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeUserDeposit final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<sticker> sticker_;

  starTransactionTypeUserDeposit();

  starTransactionTypeUserDeposit(int53 user_id_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = 204085481;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeGiveawayDeposit final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 giveaway_message_id_;

  starTransactionTypeGiveawayDeposit();

  starTransactionTypeGiveawayDeposit(int53 chat_id_, int53 giveaway_message_id_);

  static const std::int32_t ID = -1318977338;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeFragmentWithdrawal final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<RevenueWithdrawalState> withdrawal_state_;

  starTransactionTypeFragmentWithdrawal();

  explicit starTransactionTypeFragmentWithdrawal(object_ptr<RevenueWithdrawalState> &&withdrawal_state_);

  static const std::int32_t ID = -1355142766;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeTelegramAdsWithdrawal final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  starTransactionTypeTelegramAdsWithdrawal();

  static const std::int32_t ID = -1517386647;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeTelegramApiUsage final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 request_count_;

  starTransactionTypeTelegramApiUsage();

  explicit starTransactionTypeTelegramApiUsage(int32 request_count_);

  static const std::int32_t ID = 665332478;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeBotPaidMediaPurchase final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  array<object_ptr<PaidMedia>> media_;

  starTransactionTypeBotPaidMediaPurchase();

  starTransactionTypeBotPaidMediaPurchase(int53 user_id_, array<object_ptr<PaidMedia>> &&media_);

  static const std::int32_t ID = 976645509;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeBotPaidMediaSale final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  array<object_ptr<PaidMedia>> media_;
  string payload_;
  object_ptr<affiliateInfo> affiliate_;

  starTransactionTypeBotPaidMediaSale();

  starTransactionTypeBotPaidMediaSale(int53 user_id_, array<object_ptr<PaidMedia>> &&media_, string const &payload_, object_ptr<affiliateInfo> &&affiliate_);

  static const std::int32_t ID = -1034408372;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeChannelPaidMediaPurchase final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  array<object_ptr<PaidMedia>> media_;

  starTransactionTypeChannelPaidMediaPurchase();

  starTransactionTypeChannelPaidMediaPurchase(int53 chat_id_, int53 message_id_, array<object_ptr<PaidMedia>> &&media_);

  static const std::int32_t ID = -1321281338;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeChannelPaidMediaSale final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int53 message_id_;
  array<object_ptr<PaidMedia>> media_;

  starTransactionTypeChannelPaidMediaSale();

  starTransactionTypeChannelPaidMediaSale(int53 user_id_, int53 message_id_, array<object_ptr<PaidMedia>> &&media_);

  static const std::int32_t ID = 52587085;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeBotInvoicePurchase final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<productInfo> product_info_;

  starTransactionTypeBotInvoicePurchase();

  starTransactionTypeBotInvoicePurchase(int53 user_id_, object_ptr<productInfo> &&product_info_);

  static const std::int32_t ID = 501066764;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeBotInvoiceSale final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<productInfo> product_info_;
  bytes invoice_payload_;
  object_ptr<affiliateInfo> affiliate_;

  starTransactionTypeBotInvoiceSale();

  starTransactionTypeBotInvoiceSale(int53 user_id_, object_ptr<productInfo> &&product_info_, bytes const &invoice_payload_, object_ptr<affiliateInfo> &&affiliate_);

  static const std::int32_t ID = 1534954799;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeBotSubscriptionPurchase final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 subscription_period_;
  object_ptr<productInfo> product_info_;

  starTransactionTypeBotSubscriptionPurchase();

  starTransactionTypeBotSubscriptionPurchase(int53 user_id_, int32 subscription_period_, object_ptr<productInfo> &&product_info_);

  static const std::int32_t ID = 1086264149;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeBotSubscriptionSale final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 subscription_period_;
  object_ptr<productInfo> product_info_;
  bytes invoice_payload_;
  object_ptr<affiliateInfo> affiliate_;

  starTransactionTypeBotSubscriptionSale();

  starTransactionTypeBotSubscriptionSale(int53 user_id_, int32 subscription_period_, object_ptr<productInfo> &&product_info_, bytes const &invoice_payload_, object_ptr<affiliateInfo> &&affiliate_);

  static const std::int32_t ID = 526936201;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeChannelSubscriptionPurchase final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 subscription_period_;

  starTransactionTypeChannelSubscriptionPurchase();

  starTransactionTypeChannelSubscriptionPurchase(int53 chat_id_, int32 subscription_period_);

  static const std::int32_t ID = 940487633;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeChannelSubscriptionSale final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 subscription_period_;

  starTransactionTypeChannelSubscriptionSale();

  starTransactionTypeChannelSubscriptionSale(int53 user_id_, int32 subscription_period_);

  static const std::int32_t ID = -32342910;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeGiftPurchase final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> owner_id_;
  object_ptr<gift> gift_;

  starTransactionTypeGiftPurchase();

  starTransactionTypeGiftPurchase(object_ptr<MessageSender> &&owner_id_, object_ptr<gift> &&gift_);

  static const std::int32_t ID = -1819045664;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeGiftTransfer final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> owner_id_;
  object_ptr<upgradedGift> gift_;

  starTransactionTypeGiftTransfer();

  starTransactionTypeGiftTransfer(object_ptr<MessageSender> &&owner_id_, object_ptr<upgradedGift> &&gift_);

  static const std::int32_t ID = 9835767;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeGiftSale final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<gift> gift_;

  starTransactionTypeGiftSale();

  starTransactionTypeGiftSale(int53 user_id_, object_ptr<gift> &&gift_);

  static const std::int32_t ID = 1691750743;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeGiftUpgrade final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<upgradedGift> gift_;

  starTransactionTypeGiftUpgrade();

  starTransactionTypeGiftUpgrade(int53 user_id_, object_ptr<upgradedGift> &&gift_);

  static const std::int32_t ID = -632388839;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeUpgradedGiftPurchase final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<upgradedGift> gift_;

  starTransactionTypeUpgradedGiftPurchase();

  starTransactionTypeUpgradedGiftPurchase(int53 user_id_, object_ptr<upgradedGift> &&gift_);

  static const std::int32_t ID = -59050247;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeUpgradedGiftSale final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<upgradedGift> gift_;
  object_ptr<affiliateInfo> affiliate_;

  starTransactionTypeUpgradedGiftSale();

  starTransactionTypeUpgradedGiftSale(int53 user_id_, object_ptr<upgradedGift> &&gift_, object_ptr<affiliateInfo> &&affiliate_);

  static const std::int32_t ID = 2041948603;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeChannelPaidReactionSend final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  starTransactionTypeChannelPaidReactionSend();

  starTransactionTypeChannelPaidReactionSend(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -1071224896;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeChannelPaidReactionReceive final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int53 message_id_;

  starTransactionTypeChannelPaidReactionReceive();

  starTransactionTypeChannelPaidReactionReceive(int53 user_id_, int53 message_id_);

  static const std::int32_t ID = 601291243;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeAffiliateProgramCommission final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 commission_per_mille_;

  starTransactionTypeAffiliateProgramCommission();

  starTransactionTypeAffiliateProgramCommission(int53 chat_id_, int32 commission_per_mille_);

  static const std::int32_t ID = -1704757901;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypePaidMessageSend final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 message_count_;

  starTransactionTypePaidMessageSend();

  starTransactionTypePaidMessageSend(int53 chat_id_, int32 message_count_);

  static const std::int32_t ID = -1709611931;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypePaidMessageReceive final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> sender_id_;
  int32 message_count_;
  int32 commission_per_mille_;
  object_ptr<starAmount> commission_star_amount_;

  starTransactionTypePaidMessageReceive();

  starTransactionTypePaidMessageReceive(object_ptr<MessageSender> &&sender_id_, int32 message_count_, int32 commission_per_mille_, object_ptr<starAmount> &&commission_star_amount_);

  static const std::int32_t ID = -676839994;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypePremiumPurchase final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int32 month_count_;
  object_ptr<sticker> sticker_;

  starTransactionTypePremiumPurchase();

  starTransactionTypePremiumPurchase(int53 user_id_, int32 month_count_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = 998094851;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeBusinessBotTransferSend final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  starTransactionTypeBusinessBotTransferSend();

  explicit starTransactionTypeBusinessBotTransferSend(int53 user_id_);

  static const std::int32_t ID = 1221227814;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeBusinessBotTransferReceive final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  starTransactionTypeBusinessBotTransferReceive();

  explicit starTransactionTypeBusinessBotTransferReceive(int53 user_id_);

  static const std::int32_t ID = 532496778;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starTransactionTypeUnsupported final : public StarTransactionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  starTransactionTypeUnsupported();

  static const std::int32_t ID = 1993329330;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starAmount;

class starTransaction;

class starTransactions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<starAmount> star_amount_;
  array<object_ptr<starTransaction>> transactions_;
  string next_offset_;

  starTransactions();

  starTransactions(object_ptr<starAmount> &&star_amount_, array<object_ptr<starTransaction>> &&transactions_, string const &next_offset_);

  static const std::int32_t ID = 1218437859;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatisticalGraph: public Object {
 public:
};

class statisticalGraphData final : public StatisticalGraph {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string json_data_;
  string zoom_token_;

  statisticalGraphData();

  statisticalGraphData(string const &json_data_, string const &zoom_token_);

  static const std::int32_t ID = -1988940244;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statisticalGraphAsync final : public StatisticalGraph {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  statisticalGraphAsync();

  explicit statisticalGraphAsync(string const &token_);

  static const std::int32_t ID = 435891103;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statisticalGraphError final : public StatisticalGraph {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string error_message_;

  statisticalGraphError();

  explicit statisticalGraphError(string const &error_message_);

  static const std::int32_t ID = -1006788526;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class statisticalValue final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double value_;
  double previous_value_;
  double growth_rate_percentage_;

  statisticalValue();

  statisticalValue(double value_, double previous_value_, double growth_rate_percentage_);

  static const std::int32_t ID = 1651337846;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerFormat;

class StickerFullType;

class file;

class thumbnail;

class sticker final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int64 set_id_;
  int32 width_;
  int32 height_;
  string emoji_;
  object_ptr<StickerFormat> format_;
  object_ptr<StickerFullType> full_type_;
  object_ptr<thumbnail> thumbnail_;
  object_ptr<file> sticker_;

  sticker();

  sticker(int64 id_, int64 set_id_, int32 width_, int32 height_, string const &emoji_, object_ptr<StickerFormat> &&format_, object_ptr<StickerFullType> &&full_type_, object_ptr<thumbnail> &&thumbnail_, object_ptr<file> &&sticker_);

  static const std::int32_t ID = -647013057;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerFormat: public Object {
 public:
};

class stickerFormatWebp final : public StickerFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  stickerFormatWebp();

  static const std::int32_t ID = -2123043040;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerFormatTgs final : public StickerFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  stickerFormatTgs();

  static const std::int32_t ID = 1614588662;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerFormatWebm final : public StickerFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  stickerFormatWebm();

  static const std::int32_t ID = -2070162097;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class maskPosition;

class StickerFullType: public Object {
 public:
};

class stickerFullTypeRegular final : public StickerFullType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<file> premium_animation_;

  stickerFullTypeRegular();

  explicit stickerFullTypeRegular(object_ptr<file> &&premium_animation_);

  static const std::int32_t ID = -2006425865;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerFullTypeMask final : public StickerFullType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<maskPosition> mask_position_;

  stickerFullTypeMask();

  explicit stickerFullTypeMask(object_ptr<maskPosition> &&mask_position_);

  static const std::int32_t ID = 652197687;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerFullTypeCustomEmoji final : public StickerFullType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 custom_emoji_id_;
  bool needs_repainting_;

  stickerFullTypeCustomEmoji();

  stickerFullTypeCustomEmoji(int64 custom_emoji_id_, bool needs_repainting_);

  static const std::int32_t ID = -1015085653;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerType;

class emojis;

class outline;

class sticker;

class thumbnail;

class stickerSet final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  string title_;
  string name_;
  object_ptr<thumbnail> thumbnail_;
  object_ptr<outline> thumbnail_outline_;
  bool is_owned_;
  bool is_installed_;
  bool is_archived_;
  bool is_official_;
  object_ptr<StickerType> sticker_type_;
  bool needs_repainting_;
  bool is_allowed_as_chat_emoji_status_;
  bool is_viewed_;
  array<object_ptr<sticker>> stickers_;
  array<object_ptr<emojis>> emojis_;

  stickerSet();

  stickerSet(int64 id_, string const &title_, string const &name_, object_ptr<thumbnail> &&thumbnail_, object_ptr<outline> &&thumbnail_outline_, bool is_owned_, bool is_installed_, bool is_archived_, bool is_official_, object_ptr<StickerType> &&sticker_type_, bool needs_repainting_, bool is_allowed_as_chat_emoji_status_, bool is_viewed_, array<object_ptr<sticker>> &&stickers_, array<object_ptr<emojis>> &&emojis_);

  static const std::int32_t ID = -1783150210;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerType;

class outline;

class sticker;

class thumbnail;

class stickerSetInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  string title_;
  string name_;
  object_ptr<thumbnail> thumbnail_;
  object_ptr<outline> thumbnail_outline_;
  bool is_owned_;
  bool is_installed_;
  bool is_archived_;
  bool is_official_;
  object_ptr<StickerType> sticker_type_;
  bool needs_repainting_;
  bool is_allowed_as_chat_emoji_status_;
  bool is_viewed_;
  int32 size_;
  array<object_ptr<sticker>> covers_;

  stickerSetInfo();

  stickerSetInfo(int64 id_, string const &title_, string const &name_, object_ptr<thumbnail> &&thumbnail_, object_ptr<outline> &&thumbnail_outline_, bool is_owned_, bool is_installed_, bool is_archived_, bool is_official_, object_ptr<StickerType> &&sticker_type_, bool needs_repainting_, bool is_allowed_as_chat_emoji_status_, bool is_viewed_, int32 size_, array<object_ptr<sticker>> &&covers_);

  static const std::int32_t ID = -1649074729;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerSetInfo;

class stickerSets final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<stickerSetInfo>> sets_;

  stickerSets();

  stickerSets(int32 total_count_, array<object_ptr<stickerSetInfo>> &&sets_);

  static const std::int32_t ID = -1883828812;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerType: public Object {
 public:
};

class stickerTypeRegular final : public StickerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  stickerTypeRegular();

  static const std::int32_t ID = 56345973;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerTypeMask final : public StickerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  stickerTypeMask();

  static const std::int32_t ID = -1765394796;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerTypeCustomEmoji final : public StickerType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  stickerTypeCustomEmoji();

  static const std::int32_t ID = -120752249;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class stickers final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<sticker>> stickers_;

  stickers();

  explicit stickers(array<object_ptr<sticker>> &&stickers_);

  static const std::int32_t ID = 1974859260;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storageStatisticsByChat;

class storageStatistics final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 size_;
  int32 count_;
  array<object_ptr<storageStatisticsByChat>> by_chat_;

  storageStatistics();

  storageStatistics(int53 size_, int32 count_, array<object_ptr<storageStatisticsByChat>> &&by_chat_);

  static const std::int32_t ID = 217237013;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storageStatisticsByFileType;

class storageStatisticsByChat final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 size_;
  int32 count_;
  array<object_ptr<storageStatisticsByFileType>> by_file_type_;

  storageStatisticsByChat();

  storageStatisticsByChat(int53 chat_id_, int53 size_, int32 count_, array<object_ptr<storageStatisticsByFileType>> &&by_file_type_);

  static const std::int32_t ID = 635434531;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class FileType;

class storageStatisticsByFileType final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<FileType> file_type_;
  int53 size_;
  int32 count_;

  storageStatisticsByFileType();

  storageStatisticsByFileType(object_ptr<FileType> &&file_type_, int53 size_, int32 count_);

  static const std::int32_t ID = 714012840;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storageStatisticsFast final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 files_size_;
  int32 file_count_;
  int53 database_size_;
  int53 language_pack_database_size_;
  int53 log_size_;

  storageStatisticsFast();

  storageStatisticsFast(int53 files_size_, int32 file_count_, int53 database_size_, int53 language_pack_database_size_, int53 log_size_);

  static const std::int32_t ID = -884922271;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class giveawayParameters;

class StorePaymentPurpose: public Object {
 public:
};

class storePaymentPurposePremiumSubscription final : public StorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_restore_;
  bool is_upgrade_;

  storePaymentPurposePremiumSubscription();

  storePaymentPurposePremiumSubscription(bool is_restore_, bool is_upgrade_);

  static const std::int32_t ID = 1263894804;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storePaymentPurposePremiumGift final : public StorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;
  int53 user_id_;
  object_ptr<formattedText> text_;

  storePaymentPurposePremiumGift();

  storePaymentPurposePremiumGift(string const &currency_, int53 amount_, int53 user_id_, object_ptr<formattedText> &&text_);

  static const std::int32_t ID = -39502443;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storePaymentPurposePremiumGiftCodes final : public StorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 boosted_chat_id_;
  string currency_;
  int53 amount_;
  array<int53> user_ids_;
  object_ptr<formattedText> text_;

  storePaymentPurposePremiumGiftCodes();

  storePaymentPurposePremiumGiftCodes(int53 boosted_chat_id_, string const &currency_, int53 amount_, array<int53> &&user_ids_, object_ptr<formattedText> &&text_);

  static const std::int32_t ID = -1072286736;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storePaymentPurposePremiumGiveaway final : public StorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<giveawayParameters> parameters_;
  string currency_;
  int53 amount_;

  storePaymentPurposePremiumGiveaway();

  storePaymentPurposePremiumGiveaway(object_ptr<giveawayParameters> &&parameters_, string const &currency_, int53 amount_);

  static const std::int32_t ID = 1302624938;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storePaymentPurposeStarGiveaway final : public StorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<giveawayParameters> parameters_;
  string currency_;
  int53 amount_;
  int32 winner_count_;
  int53 star_count_;

  storePaymentPurposeStarGiveaway();

  storePaymentPurposeStarGiveaway(object_ptr<giveawayParameters> &&parameters_, string const &currency_, int53 amount_, int32 winner_count_, int53 star_count_);

  static const std::int32_t ID = 211212441;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storePaymentPurposeStars final : public StorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;
  int53 star_count_;

  storePaymentPurposeStars();

  storePaymentPurposeStars(string const &currency_, int53 amount_, int53 star_count_);

  static const std::int32_t ID = -1803497708;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storePaymentPurposeGiftedStars final : public StorePaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string currency_;
  int53 amount_;
  int53 star_count_;

  storePaymentPurposeGiftedStars();

  storePaymentPurposeGiftedStars(int53 user_id_, string const &currency_, int53 amount_, int53 star_count_);

  static const std::int32_t ID = 893691428;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StoreTransaction: public Object {
 public:
};

class storeTransactionAppStore final : public StoreTransaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes receipt_;

  storeTransactionAppStore();

  explicit storeTransactionAppStore(bytes const &receipt_);

  static const std::int32_t ID = 1625562441;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storeTransactionGooglePlay final : public StoreTransaction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string package_name_;
  string store_product_id_;
  string purchase_token_;

  storeTransactionGooglePlay();

  storeTransactionGooglePlay(string const &package_name_, string const &store_product_id_, string const &purchase_token_);

  static const std::int32_t ID = 1094018617;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class story;

class stories final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<story>> stories_;
  array<int32> pinned_story_ids_;

  stories();

  stories(int32 total_count_, array<object_ptr<story>> &&stories_, array<int32> &&pinned_story_ids_);

  static const std::int32_t ID = 670157595;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class ReactionType;

class StoryContent;

class StoryPrivacySettings;

class formattedText;

class storyArea;

class storyInteractionInfo;

class storyRepostInfo;

class story final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  int53 poster_chat_id_;
  object_ptr<MessageSender> poster_id_;
  int32 date_;
  bool is_being_posted_;
  bool is_being_edited_;
  bool is_edited_;
  bool is_posted_to_chat_page_;
  bool is_visible_only_for_self_;
  bool can_be_deleted_;
  bool can_be_edited_;
  bool can_be_forwarded_;
  bool can_be_replied_;
  bool can_toggle_is_posted_to_chat_page_;
  bool can_get_statistics_;
  bool can_get_interactions_;
  bool has_expired_viewers_;
  object_ptr<storyRepostInfo> repost_info_;
  object_ptr<storyInteractionInfo> interaction_info_;
  object_ptr<ReactionType> chosen_reaction_type_;
  object_ptr<StoryPrivacySettings> privacy_settings_;
  object_ptr<StoryContent> content_;
  array<object_ptr<storyArea>> areas_;
  object_ptr<formattedText> caption_;

  story();

  story(int32 id_, int53 poster_chat_id_, object_ptr<MessageSender> &&poster_id_, int32 date_, bool is_being_posted_, bool is_being_edited_, bool is_edited_, bool is_posted_to_chat_page_, bool is_visible_only_for_self_, bool can_be_deleted_, bool can_be_edited_, bool can_be_forwarded_, bool can_be_replied_, bool can_toggle_is_posted_to_chat_page_, bool can_get_statistics_, bool can_get_interactions_, bool has_expired_viewers_, object_ptr<storyRepostInfo> &&repost_info_, object_ptr<storyInteractionInfo> &&interaction_info_, object_ptr<ReactionType> &&chosen_reaction_type_, object_ptr<StoryPrivacySettings> &&privacy_settings_, object_ptr<StoryContent> &&content_, array<object_ptr<storyArea>> &&areas_, object_ptr<formattedText> &&caption_);

  static const std::int32_t ID = 1206531707;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StoryAreaType;

class storyAreaPosition;

class storyArea final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<storyAreaPosition> position_;
  object_ptr<StoryAreaType> type_;

  storyArea();

  storyArea(object_ptr<storyAreaPosition> &&position_, object_ptr<StoryAreaType> &&type_);

  static const std::int32_t ID = -906033314;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyAreaPosition final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double x_percentage_;
  double y_percentage_;
  double width_percentage_;
  double height_percentage_;
  double rotation_angle_;
  double corner_radius_percentage_;

  storyAreaPosition();

  storyAreaPosition(double x_percentage_, double y_percentage_, double width_percentage_, double height_percentage_, double rotation_angle_, double corner_radius_percentage_);

  static const std::int32_t ID = -1533023124;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType;

class location;

class locationAddress;

class venue;

class StoryAreaType: public Object {
 public:
};

class storyAreaTypeLocation final : public StoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;
  object_ptr<locationAddress> address_;

  storyAreaTypeLocation();

  storyAreaTypeLocation(object_ptr<location> &&location_, object_ptr<locationAddress> &&address_);

  static const std::int32_t ID = -1464612189;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyAreaTypeVenue final : public StoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<venue> venue_;

  storyAreaTypeVenue();

  explicit storyAreaTypeVenue(object_ptr<venue> &&venue_);

  static const std::int32_t ID = 414076166;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyAreaTypeSuggestedReaction final : public StoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionType> reaction_type_;
  int32 total_count_;
  bool is_dark_;
  bool is_flipped_;

  storyAreaTypeSuggestedReaction();

  storyAreaTypeSuggestedReaction(object_ptr<ReactionType> &&reaction_type_, int32 total_count_, bool is_dark_, bool is_flipped_);

  static const std::int32_t ID = -111177092;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyAreaTypeMessage final : public StoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  storyAreaTypeMessage();

  storyAreaTypeMessage(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -1074825548;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyAreaTypeLink final : public StoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  storyAreaTypeLink();

  explicit storyAreaTypeLink(string const &url_);

  static const std::int32_t ID = -127770235;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyAreaTypeWeather final : public StoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double temperature_;
  string emoji_;
  int32 background_color_;

  storyAreaTypeWeather();

  storyAreaTypeWeather(double temperature_, string const &emoji_, int32 background_color_);

  static const std::int32_t ID = -1504150082;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyAreaTypeUpgradedGift final : public StoryAreaType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string gift_name_;

  storyAreaTypeUpgradedGift();

  explicit storyAreaTypeUpgradedGift(string const &gift_name_);

  static const std::int32_t ID = 760281479;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class photo;

class storyVideo;

class StoryContent: public Object {
 public:
};

class storyContentPhoto final : public StoryContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<photo> photo_;

  storyContentPhoto();

  explicit storyContentPhoto(object_ptr<photo> &&photo_);

  static const std::int32_t ID = -731971504;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyContentVideo final : public StoryContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<storyVideo> video_;
  object_ptr<storyVideo> alternative_video_;

  storyContentVideo();

  storyContentVideo(object_ptr<storyVideo> &&video_, object_ptr<storyVideo> &&alternative_video_);

  static const std::int32_t ID = -1291754842;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyContentUnsupported final : public StoryContent {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  storyContentUnsupported();

  static const std::int32_t ID = -2033715858;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyFullId final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 poster_chat_id_;
  int32 story_id_;

  storyFullId();

  storyFullId(int53 poster_chat_id_, int32 story_id_);

  static const std::int32_t ID = 765952419;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 story_id_;
  int32 date_;
  bool is_for_close_friends_;

  storyInfo();

  storyInfo(int32 story_id_, int32 date_, bool is_for_close_friends_);

  static const std::int32_t ID = -1986542766;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BlockList;

class MessageSender;

class StoryInteractionType;

class storyInteraction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> actor_id_;
  int32 interaction_date_;
  object_ptr<BlockList> block_list_;
  object_ptr<StoryInteractionType> type_;

  storyInteraction();

  storyInteraction(object_ptr<MessageSender> &&actor_id_, int32 interaction_date_, object_ptr<BlockList> &&block_list_, object_ptr<StoryInteractionType> &&type_);

  static const std::int32_t ID = -702229982;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyInteractionInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 view_count_;
  int32 forward_count_;
  int32 reaction_count_;
  array<int53> recent_viewer_user_ids_;

  storyInteractionInfo();

  storyInteractionInfo(int32 view_count_, int32 forward_count_, int32 reaction_count_, array<int53> &&recent_viewer_user_ids_);

  static const std::int32_t ID = -846542065;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType;

class message;

class story;

class StoryInteractionType: public Object {
 public:
};

class storyInteractionTypeView final : public StoryInteractionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionType> chosen_reaction_type_;

  storyInteractionTypeView();

  explicit storyInteractionTypeView(object_ptr<ReactionType> &&chosen_reaction_type_);

  static const std::int32_t ID = 1407399888;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyInteractionTypeForward final : public StoryInteractionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;

  storyInteractionTypeForward();

  explicit storyInteractionTypeForward(object_ptr<message> &&message_);

  static const std::int32_t ID = 668089599;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyInteractionTypeRepost final : public StoryInteractionType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<story> story_;

  storyInteractionTypeRepost();

  explicit storyInteractionTypeRepost(object_ptr<story> &&story_);

  static const std::int32_t ID = -1021150780;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyInteraction;

class storyInteractions final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  int32 total_forward_count_;
  int32 total_reaction_count_;
  array<object_ptr<storyInteraction>> interactions_;
  string next_offset_;

  storyInteractions();

  storyInteractions(int32 total_count_, int32 total_forward_count_, int32 total_reaction_count_, array<object_ptr<storyInteraction>> &&interactions_, string const &next_offset_);

  static const std::int32_t ID = 1537062962;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StoryList: public Object {
 public:
};

class storyListMain final : public StoryList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  storyListMain();

  static const std::int32_t ID = -672222209;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyListArchive final : public StoryList {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  storyListArchive();

  static const std::int32_t ID = -41900223;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StoryOrigin: public Object {
 public:
};

class storyOriginPublicStory final : public StoryOrigin {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 story_id_;

  storyOriginPublicStory();

  storyOriginPublicStory(int53 chat_id_, int32 story_id_);

  static const std::int32_t ID = 741842878;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyOriginHiddenUser final : public StoryOrigin {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string poster_name_;

  storyOriginHiddenUser();

  explicit storyOriginHiddenUser(string const &poster_name_);

  static const std::int32_t ID = -96348585;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StoryPrivacySettings: public Object {
 public:
};

class storyPrivacySettingsEveryone final : public StoryPrivacySettings {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> except_user_ids_;

  storyPrivacySettingsEveryone();

  explicit storyPrivacySettingsEveryone(array<int53> &&except_user_ids_);

  static const std::int32_t ID = 890847843;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyPrivacySettingsContacts final : public StoryPrivacySettings {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> except_user_ids_;

  storyPrivacySettingsContacts();

  explicit storyPrivacySettingsContacts(array<int53> &&except_user_ids_);

  static const std::int32_t ID = 50285309;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyPrivacySettingsCloseFriends final : public StoryPrivacySettings {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  storyPrivacySettingsCloseFriends();

  static const std::int32_t ID = 2097122144;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyPrivacySettingsSelectedUsers final : public StoryPrivacySettings {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> user_ids_;

  storyPrivacySettingsSelectedUsers();

  explicit storyPrivacySettingsSelectedUsers(array<int53> &&user_ids_);

  static const std::int32_t ID = -1885772602;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StoryOrigin;

class storyRepostInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StoryOrigin> origin_;
  bool is_content_modified_;

  storyRepostInfo();

  storyRepostInfo(object_ptr<StoryOrigin> &&origin_, bool is_content_modified_);

  static const std::int32_t ID = -8412096;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatisticalGraph;

class storyStatistics final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StatisticalGraph> story_interaction_graph_;
  object_ptr<StatisticalGraph> story_reaction_graph_;

  storyStatistics();

  storyStatistics(object_ptr<StatisticalGraph> &&story_interaction_graph_, object_ptr<StatisticalGraph> &&story_reaction_graph_);

  static const std::int32_t ID = 1178897259;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class minithumbnail;

class thumbnail;

class storyVideo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  double duration_;
  int32 width_;
  int32 height_;
  bool has_stickers_;
  bool is_animation_;
  object_ptr<minithumbnail> minithumbnail_;
  object_ptr<thumbnail> thumbnail_;
  int32 preload_prefix_size_;
  double cover_frame_timestamp_;
  object_ptr<file> video_;

  storyVideo();

  storyVideo(double duration_, int32 width_, int32 height_, bool has_stickers_, bool is_animation_, object_ptr<minithumbnail> &&minithumbnail_, object_ptr<thumbnail> &&thumbnail_, int32 preload_prefix_size_, double cover_frame_timestamp_, object_ptr<file> &&video_);

  static const std::int32_t ID = 1445661253;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class SuggestedAction: public Object {
 public:
};

class suggestedActionEnableArchiveAndMuteNewChats final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionEnableArchiveAndMuteNewChats();

  static const std::int32_t ID = 2017586255;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionCheckPassword final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionCheckPassword();

  static const std::int32_t ID = 1910534839;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionCheckPhoneNumber final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionCheckPhoneNumber();

  static const std::int32_t ID = 648771563;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionViewChecksHint final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionViewChecksHint();

  static const std::int32_t ID = 891303239;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionConvertToBroadcastGroup final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;

  suggestedActionConvertToBroadcastGroup();

  explicit suggestedActionConvertToBroadcastGroup(int53 supergroup_id_);

  static const std::int32_t ID = -965071304;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionSetPassword final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 authorization_delay_;

  suggestedActionSetPassword();

  explicit suggestedActionSetPassword(int32 authorization_delay_);

  static const std::int32_t ID = 1863613848;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionUpgradePremium final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionUpgradePremium();

  static const std::int32_t ID = 1890220539;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionRestorePremium final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionRestorePremium();

  static const std::int32_t ID = -385229468;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionSubscribeToAnnualPremium final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionSubscribeToAnnualPremium();

  static const std::int32_t ID = 373913787;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionGiftPremiumForChristmas final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionGiftPremiumForChristmas();

  static const std::int32_t ID = -1816924561;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionSetBirthdate final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionSetBirthdate();

  static const std::int32_t ID = -356672766;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionSetProfilePhoto final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionSetProfilePhoto();

  static const std::int32_t ID = -1612563093;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionExtendPremium final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string manage_premium_subscription_url_;

  suggestedActionExtendPremium();

  explicit suggestedActionExtendPremium(string const &manage_premium_subscription_url_);

  static const std::int32_t ID = -566207286;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionExtendStarSubscriptions final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  suggestedActionExtendStarSubscriptions();

  static const std::int32_t ID = -47000234;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class suggestedActionCustom final : public SuggestedAction {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<formattedText> title_;
  object_ptr<formattedText> description_;
  string url_;

  suggestedActionCustom();

  suggestedActionCustom(string const &name_, object_ptr<formattedText> &&title_, object_ptr<formattedText> &&description_, string const &url_);

  static const std::int32_t ID = 2092876611;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatMemberStatus;

class usernames;

class verificationStatus;

class supergroup final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 id_;
  object_ptr<usernames> usernames_;
  int32 date_;
  object_ptr<ChatMemberStatus> status_;
  int32 member_count_;
  int32 boost_level_;
  bool has_automatic_translation_;
  bool has_linked_chat_;
  bool has_location_;
  bool sign_messages_;
  bool show_message_sender_;
  bool join_to_send_messages_;
  bool join_by_request_;
  bool is_slow_mode_enabled_;
  bool is_channel_;
  bool is_broadcast_group_;
  bool is_forum_;
  object_ptr<verificationStatus> verification_status_;
  bool has_sensitive_content_;
  string restriction_reason_;
  int53 paid_message_star_count_;
  bool has_active_stories_;
  bool has_unread_active_stories_;

  supergroup();

  supergroup(int53 id_, object_ptr<usernames> &&usernames_, int32 date_, object_ptr<ChatMemberStatus> &&status_, int32 member_count_, int32 boost_level_, bool has_automatic_translation_, bool has_linked_chat_, bool has_location_, bool sign_messages_, bool show_message_sender_, bool join_to_send_messages_, bool join_by_request_, bool is_slow_mode_enabled_, bool is_channel_, bool is_broadcast_group_, bool is_forum_, object_ptr<verificationStatus> &&verification_status_, bool has_sensitive_content_, string const &restriction_reason_, int53 paid_message_star_count_, bool has_active_stories_, bool has_unread_active_stories_);

  static const std::int32_t ID = -1355919719;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botCommands;

class botVerification;

class chatInviteLink;

class chatLocation;

class chatPhoto;

class supergroupFullInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> photo_;
  string description_;
  int32 member_count_;
  int32 administrator_count_;
  int32 restricted_count_;
  int32 banned_count_;
  int53 linked_chat_id_;
  int32 slow_mode_delay_;
  double slow_mode_delay_expires_in_;
  bool can_enable_paid_messages_;
  bool can_enable_paid_reaction_;
  bool can_get_members_;
  bool has_hidden_members_;
  bool can_hide_members_;
  bool can_set_sticker_set_;
  bool can_set_location_;
  bool can_get_statistics_;
  bool can_get_revenue_statistics_;
  bool can_get_star_revenue_statistics_;
  bool can_send_gift_;
  bool can_toggle_aggressive_anti_spam_;
  bool is_all_history_available_;
  bool can_have_sponsored_messages_;
  bool has_aggressive_anti_spam_enabled_;
  bool has_paid_media_allowed_;
  bool has_pinned_stories_;
  int32 gift_count_;
  int32 my_boost_count_;
  int32 unrestrict_boost_count_;
  int64 sticker_set_id_;
  int64 custom_emoji_sticker_set_id_;
  object_ptr<chatLocation> location_;
  object_ptr<chatInviteLink> invite_link_;
  array<object_ptr<botCommands>> bot_commands_;
  object_ptr<botVerification> bot_verification_;
  int53 upgraded_from_basic_group_id_;
  int53 upgraded_from_max_message_id_;

  supergroupFullInfo();

  supergroupFullInfo(object_ptr<chatPhoto> &&photo_, string const &description_, int32 member_count_, int32 administrator_count_, int32 restricted_count_, int32 banned_count_, int53 linked_chat_id_, int32 slow_mode_delay_, double slow_mode_delay_expires_in_, bool can_enable_paid_messages_, bool can_enable_paid_reaction_, bool can_get_members_, bool has_hidden_members_, bool can_hide_members_, bool can_set_sticker_set_, bool can_set_location_, bool can_get_statistics_, bool can_get_revenue_statistics_, bool can_get_star_revenue_statistics_, bool can_send_gift_, bool can_toggle_aggressive_anti_spam_, bool is_all_history_available_, bool can_have_sponsored_messages_, bool has_aggressive_anti_spam_enabled_, bool has_paid_media_allowed_, bool has_pinned_stories_, int32 gift_count_, int32 my_boost_count_, int32 unrestrict_boost_count_, int64 sticker_set_id_, int64 custom_emoji_sticker_set_id_, object_ptr<chatLocation> &&location_, object_ptr<chatInviteLink> &&invite_link_, array<object_ptr<botCommands>> &&bot_commands_, object_ptr<botVerification> &&bot_verification_, int53 upgraded_from_basic_group_id_, int53 upgraded_from_max_message_id_);

  static const std::int32_t ID = 2114051007;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SupergroupMembersFilter: public Object {
 public:
};

class supergroupMembersFilterRecent final : public SupergroupMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  supergroupMembersFilterRecent();

  static const std::int32_t ID = 1178199509;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class supergroupMembersFilterContacts final : public SupergroupMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string query_;

  supergroupMembersFilterContacts();

  explicit supergroupMembersFilterContacts(string const &query_);

  static const std::int32_t ID = -1282910856;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class supergroupMembersFilterAdministrators final : public SupergroupMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  supergroupMembersFilterAdministrators();

  static const std::int32_t ID = -2097380265;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class supergroupMembersFilterSearch final : public SupergroupMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string query_;

  supergroupMembersFilterSearch();

  explicit supergroupMembersFilterSearch(string const &query_);

  static const std::int32_t ID = -1696358469;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class supergroupMembersFilterRestricted final : public SupergroupMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string query_;

  supergroupMembersFilterRestricted();

  explicit supergroupMembersFilterRestricted(string const &query_);

  static const std::int32_t ID = -1107800034;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class supergroupMembersFilterBanned final : public SupergroupMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string query_;

  supergroupMembersFilterBanned();

  explicit supergroupMembersFilterBanned(string const &query_);

  static const std::int32_t ID = -1210621683;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class supergroupMembersFilterMention final : public SupergroupMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string query_;
  int53 message_thread_id_;

  supergroupMembersFilterMention();

  supergroupMembersFilterMention(string const &query_, int53 message_thread_id_);

  static const std::int32_t ID = 947915036;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class supergroupMembersFilterBots final : public SupergroupMembersFilter {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  supergroupMembersFilterBots();

  static const std::int32_t ID = 492138918;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class TMeUrlType;

class tMeUrl final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  object_ptr<TMeUrlType> type_;

  tMeUrl();

  tMeUrl(string const &url_, object_ptr<TMeUrlType> &&type_);

  static const std::int32_t ID = -1140786622;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLinkInfo;

class TMeUrlType: public Object {
 public:
};

class tMeUrlTypeUser final : public TMeUrlType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  tMeUrlTypeUser();

  explicit tMeUrlTypeUser(int53 user_id_);

  static const std::int32_t ID = 125336602;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class tMeUrlTypeSupergroup final : public TMeUrlType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;

  tMeUrlTypeSupergroup();

  explicit tMeUrlTypeSupergroup(int53 supergroup_id_);

  static const std::int32_t ID = -1353369944;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class tMeUrlTypeChatInvite final : public TMeUrlType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatInviteLinkInfo> info_;

  tMeUrlTypeChatInvite();

  explicit tMeUrlTypeChatInvite(object_ptr<chatInviteLinkInfo> &&info_);

  static const std::int32_t ID = 313907785;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class tMeUrlTypeStickerSet final : public TMeUrlType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 sticker_set_id_;

  tMeUrlTypeStickerSet();

  explicit tMeUrlTypeStickerSet(int64 sticker_set_id_);

  static const std::int32_t ID = 1602473196;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class tMeUrl;

class tMeUrls final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<tMeUrl>> urls_;

  tMeUrls();

  explicit tMeUrls(array<object_ptr<tMeUrl>> &&urls_);

  static const std::int32_t ID = -1130595098;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InternalLinkType;

class targetChatTypes;

class TargetChat: public Object {
 public:
};

class targetChatCurrent final : public TargetChat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  targetChatCurrent();

  static const std::int32_t ID = -416689904;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class targetChatChosen final : public TargetChat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<targetChatTypes> types_;

  targetChatChosen();

  explicit targetChatChosen(object_ptr<targetChatTypes> &&types_);

  static const std::int32_t ID = -1392978522;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class targetChatInternalLink final : public TargetChat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InternalLinkType> link_;

  targetChatInternalLink();

  explicit targetChatInternalLink(object_ptr<InternalLinkType> &&link_);

  static const std::int32_t ID = -579301408;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class targetChatTypes final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool allow_user_chats_;
  bool allow_bot_chats_;
  bool allow_group_chats_;
  bool allow_channel_chats_;

  targetChatTypes();

  targetChatTypes(bool allow_user_chats_, bool allow_bot_chats_, bool allow_group_chats_, bool allow_channel_chats_);

  static const std::int32_t ID = 1513098833;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class giveawayParameters;

class TelegramPaymentPurpose: public Object {
 public:
};

class telegramPaymentPurposePremiumGift final : public TelegramPaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;
  int53 user_id_;
  int32 month_count_;
  object_ptr<formattedText> text_;

  telegramPaymentPurposePremiumGift();

  telegramPaymentPurposePremiumGift(string const &currency_, int53 amount_, int53 user_id_, int32 month_count_, object_ptr<formattedText> &&text_);

  static const std::int32_t ID = -1600286150;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class telegramPaymentPurposePremiumGiftCodes final : public TelegramPaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 boosted_chat_id_;
  string currency_;
  int53 amount_;
  array<int53> user_ids_;
  int32 month_count_;
  object_ptr<formattedText> text_;

  telegramPaymentPurposePremiumGiftCodes();

  telegramPaymentPurposePremiumGiftCodes(int53 boosted_chat_id_, string const &currency_, int53 amount_, array<int53> &&user_ids_, int32 month_count_, object_ptr<formattedText> &&text_);

  static const std::int32_t ID = -1863495348;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class telegramPaymentPurposePremiumGiveaway final : public TelegramPaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<giveawayParameters> parameters_;
  string currency_;
  int53 amount_;
  int32 winner_count_;
  int32 month_count_;

  telegramPaymentPurposePremiumGiveaway();

  telegramPaymentPurposePremiumGiveaway(object_ptr<giveawayParameters> &&parameters_, string const &currency_, int53 amount_, int32 winner_count_, int32 month_count_);

  static const std::int32_t ID = -760757441;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class telegramPaymentPurposeStars final : public TelegramPaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;
  int53 star_count_;

  telegramPaymentPurposeStars();

  telegramPaymentPurposeStars(string const &currency_, int53 amount_, int53 star_count_);

  static const std::int32_t ID = -495718830;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class telegramPaymentPurposeGiftedStars final : public TelegramPaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string currency_;
  int53 amount_;
  int53 star_count_;

  telegramPaymentPurposeGiftedStars();

  telegramPaymentPurposeGiftedStars(int53 user_id_, string const &currency_, int53 amount_, int53 star_count_);

  static const std::int32_t ID = -1850308042;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class telegramPaymentPurposeStarGiveaway final : public TelegramPaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<giveawayParameters> parameters_;
  string currency_;
  int53 amount_;
  int32 winner_count_;
  int53 star_count_;

  telegramPaymentPurposeStarGiveaway();

  telegramPaymentPurposeStarGiveaway(object_ptr<giveawayParameters> &&parameters_, string const &currency_, int53 amount_, int32 winner_count_, int53 star_count_);

  static const std::int32_t ID = 1014604689;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class telegramPaymentPurposeJoinChat final : public TelegramPaymentPurpose {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;

  telegramPaymentPurposeJoinChat();

  explicit telegramPaymentPurposeJoinChat(string const &invite_link_);

  static const std::int32_t ID = -1914869880;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class temporaryPasswordState final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool has_password_;
  int32 valid_for_;

  temporaryPasswordState();

  temporaryPasswordState(bool has_password_, int32 valid_for_);

  static const std::int32_t ID = 939837410;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class termsOfService final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  int32 min_user_age_;
  bool show_popup_;

  termsOfService();

  termsOfService(object_ptr<formattedText> &&text_, int32 min_user_age_, bool show_popup_);

  static const std::int32_t ID = 739422597;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class testBytes final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bytes value_;

  testBytes();

  explicit testBytes(bytes const &value_);

  static const std::int32_t ID = -1541225250;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class testInt final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 value_;

  testInt();

  explicit testInt(int32 value_);

  static const std::int32_t ID = -574804983;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class testString final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string value_;

  testString();

  explicit testString(string const &value_);

  static const std::int32_t ID = -27891572;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class testVectorInt final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> value_;

  testVectorInt();

  explicit testVectorInt(array<int32> &&value_);

  static const std::int32_t ID = 593682027;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class testInt;

class testVectorIntObject final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<testInt>> value_;

  testVectorIntObject();

  explicit testVectorIntObject(array<object_ptr<testInt>> &&value_);

  static const std::int32_t ID = 125891546;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class testVectorString final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> value_;

  testVectorString();

  explicit testVectorString(array<string> &&value_);

  static const std::int32_t ID = 79339995;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class testString;

class testVectorStringObject final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<testString>> value_;

  testVectorStringObject();

  explicit testVectorStringObject(array<object_ptr<testString>> &&value_);

  static const std::int32_t ID = 80780537;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  text();

  explicit text(string const &text_);

  static const std::int32_t ID = 578181272;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntity;

class textEntities final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<textEntity>> entities_;

  textEntities();

  explicit textEntities(array<object_ptr<textEntity>> &&entities_);

  static const std::int32_t ID = -933199172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class TextEntityType;

class textEntity final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 offset_;
  int32 length_;
  object_ptr<TextEntityType> type_;

  textEntity();

  textEntity(int32 offset_, int32 length_, object_ptr<TextEntityType> &&type_);

  static const std::int32_t ID = -1951688280;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class TextEntityType: public Object {
 public:
};

class textEntityTypeMention final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeMention();

  static const std::int32_t ID = 934535013;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeHashtag final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeHashtag();

  static const std::int32_t ID = -1023958307;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeCashtag final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeCashtag();

  static const std::int32_t ID = 1222915915;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeBotCommand final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeBotCommand();

  static const std::int32_t ID = -1150997581;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeUrl final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeUrl();

  static const std::int32_t ID = -1312762756;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeEmailAddress final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeEmailAddress();

  static const std::int32_t ID = 1425545249;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypePhoneNumber final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypePhoneNumber();

  static const std::int32_t ID = -1160140246;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeBankCardNumber final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeBankCardNumber();

  static const std::int32_t ID = 105986320;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeBold final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeBold();

  static const std::int32_t ID = -1128210000;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeItalic final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeItalic();

  static const std::int32_t ID = -118253987;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeUnderline final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeUnderline();

  static const std::int32_t ID = 792317842;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeStrikethrough final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeStrikethrough();

  static const std::int32_t ID = 961529082;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeSpoiler final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeSpoiler();

  static const std::int32_t ID = 544019899;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeCode final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeCode();

  static const std::int32_t ID = -974534326;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypePre final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypePre();

  static const std::int32_t ID = 1648958606;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypePreCode final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string language_;

  textEntityTypePreCode();

  explicit textEntityTypePreCode(string const &language_);

  static const std::int32_t ID = -945325397;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeBlockQuote final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeBlockQuote();

  static const std::int32_t ID = -1003999032;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeExpandableBlockQuote final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textEntityTypeExpandableBlockQuote();

  static const std::int32_t ID = 36572261;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeTextUrl final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  textEntityTypeTextUrl();

  explicit textEntityTypeTextUrl(string const &url_);

  static const std::int32_t ID = 445719651;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeMentionName final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  textEntityTypeMentionName();

  explicit textEntityTypeMentionName(int53 user_id_);

  static const std::int32_t ID = -1570974289;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeCustomEmoji final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 custom_emoji_id_;

  textEntityTypeCustomEmoji();

  explicit textEntityTypeCustomEmoji(int64 custom_emoji_id_);

  static const std::int32_t ID = 1724820677;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntityTypeMediaTimestamp final : public TextEntityType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 media_timestamp_;

  textEntityTypeMediaTimestamp();

  explicit textEntityTypeMediaTimestamp(int32 media_timestamp_);

  static const std::int32_t ID = -1841898992;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class TextParseMode: public Object {
 public:
};

class textParseModeMarkdown final : public TextParseMode {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 version_;

  textParseModeMarkdown();

  explicit textParseModeMarkdown(int32 version_);

  static const std::int32_t ID = 360073407;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textParseModeHTML final : public TextParseMode {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  textParseModeHTML();

  static const std::int32_t ID = 1660208627;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class textQuote final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  int32 position_;
  bool is_manual_;

  textQuote();

  textQuote(object_ptr<formattedText> &&text_, int32 position_, bool is_manual_);

  static const std::int32_t ID = -2039105358;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class themeParameters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 background_color_;
  int32 secondary_background_color_;
  int32 header_background_color_;
  int32 bottom_bar_background_color_;
  int32 section_background_color_;
  int32 section_separator_color_;
  int32 text_color_;
  int32 accent_text_color_;
  int32 section_header_text_color_;
  int32 subtitle_text_color_;
  int32 destructive_text_color_;
  int32 hint_color_;
  int32 link_color_;
  int32 button_color_;
  int32 button_text_color_;

  themeParameters();

  themeParameters(int32 background_color_, int32 secondary_background_color_, int32 header_background_color_, int32 bottom_bar_background_color_, int32 section_background_color_, int32 section_separator_color_, int32 text_color_, int32 accent_text_color_, int32 section_header_text_color_, int32 subtitle_text_color_, int32 destructive_text_color_, int32 hint_color_, int32 link_color_, int32 button_color_, int32 button_text_color_);

  static const std::int32_t ID = -276589137;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BackgroundFill;

class background;

class themeSettings final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 accent_color_;
  object_ptr<background> background_;
  object_ptr<BackgroundFill> outgoing_message_fill_;
  bool animate_outgoing_message_fill_;
  int32 outgoing_message_accent_color_;

  themeSettings();

  themeSettings(int32 accent_color_, object_ptr<background> &&background_, object_ptr<BackgroundFill> &&outgoing_message_fill_, bool animate_outgoing_message_fill_, int32 outgoing_message_accent_color_);

  static const std::int32_t ID = -62120942;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ThumbnailFormat;

class file;

class thumbnail final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ThumbnailFormat> format_;
  int32 width_;
  int32 height_;
  object_ptr<file> file_;

  thumbnail();

  thumbnail(object_ptr<ThumbnailFormat> &&format_, int32 width_, int32 height_, object_ptr<file> &&file_);

  static const std::int32_t ID = 1243275371;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ThumbnailFormat: public Object {
 public:
};

class thumbnailFormatJpeg final : public ThumbnailFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  thumbnailFormatJpeg();

  static const std::int32_t ID = -653503352;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class thumbnailFormatGif final : public ThumbnailFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  thumbnailFormatGif();

  static const std::int32_t ID = 1252205962;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class thumbnailFormatMpeg4 final : public ThumbnailFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  thumbnailFormatMpeg4();

  static const std::int32_t ID = 278616062;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class thumbnailFormatPng final : public ThumbnailFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  thumbnailFormatPng();

  static const std::int32_t ID = 1577490421;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class thumbnailFormatTgs final : public ThumbnailFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  thumbnailFormatTgs();

  static const std::int32_t ID = 1315522642;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class thumbnailFormatWebm final : public ThumbnailFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  thumbnailFormatWebm();

  static const std::int32_t ID = -660084953;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class thumbnailFormatWebp final : public ThumbnailFormat {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  thumbnailFormatWebp();

  static const std::int32_t ID = -53588974;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class timeZone final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string id_;
  string name_;
  int32 utc_time_offset_;

  timeZone();

  timeZone(string const &id_, string const &name_, int32 utc_time_offset_);

  static const std::int32_t ID = -1189481763;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class timeZone;

class timeZones final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<timeZone>> time_zones_;

  timeZones();

  explicit timeZones(array<object_ptr<timeZone>> &&time_zones_);

  static const std::int32_t ID = -334655570;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class TopChatCategory: public Object {
 public:
};

class topChatCategoryUsers final : public TopChatCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  topChatCategoryUsers();

  static const std::int32_t ID = 1026706816;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topChatCategoryBots final : public TopChatCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  topChatCategoryBots();

  static const std::int32_t ID = -1577129195;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topChatCategoryGroups final : public TopChatCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  topChatCategoryGroups();

  static const std::int32_t ID = 1530056846;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topChatCategoryChannels final : public TopChatCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  topChatCategoryChannels();

  static const std::int32_t ID = -500825885;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topChatCategoryInlineBots final : public TopChatCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  topChatCategoryInlineBots();

  static const std::int32_t ID = 377023356;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topChatCategoryWebAppBots final : public TopChatCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  topChatCategoryWebAppBots();

  static const std::int32_t ID = 100062973;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topChatCategoryCalls final : public TopChatCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  topChatCategoryCalls();

  static const std::int32_t ID = 356208861;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class topChatCategoryForwardChats final : public TopChatCategory {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  topChatCategoryForwardChats();

  static const std::int32_t ID = 1695922133;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerSetInfo;

class trendingStickerSets final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<object_ptr<stickerSetInfo>> sets_;
  bool is_premium_;

  trendingStickerSets();

  trendingStickerSets(int32 total_count_, array<object_ptr<stickerSetInfo>> &&sets_, bool is_premium_);

  static const std::int32_t ID = 41028940;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class unconfirmedSession final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int32 log_in_date_;
  string device_model_;
  string location_;

  unconfirmedSession();

  unconfirmedSession(int64 id_, int32 log_in_date_, string const &device_model_, string const &location_);

  static const std::int32_t ID = -2062726663;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class ReactionType;

class unreadReaction final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionType> type_;
  object_ptr<MessageSender> sender_id_;
  bool is_big_;

  unreadReaction();

  unreadReaction(object_ptr<ReactionType> &&type_, object_ptr<MessageSender> &&sender_id_, bool is_big_);

  static const std::int32_t ID = -1940178046;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AuthorizationState;

class AutosaveSettingsScope;

class BlockList;

class CallbackQueryPayload;

class CanPostStoryResult;

class ChatAction;

class ChatActionBar;

class ChatAvailableReactions;

class ChatList;

class ChatType;

class ConnectionState;

class MessageContent;

class MessageSender;

class NotificationGroupType;

class NotificationSettingsScope;

class OptionValue;

class PaidReactionType;

class ReactionType;

class ReplyMarkup;

class StickerType;

class StoryList;

class SuggestedAction;

class UserPrivacySetting;

class UserStatus;

class accentColor;

class address;

class attachmentMenuBot;

class background;

class basicGroup;

class basicGroupFullInfo;

class businessBotManageBar;

class businessConnection;

class businessMessage;

class call;

class chat;

class chatActiveStories;

class chatBackground;

class chatBoost;

class chatFolderInfo;

class chatInviteLink;

class chatJoinRequest;

class chatJoinRequestsInfo;

class chatMember;

class chatNotificationSettings;

class chatPermissions;

class chatPhotoInfo;

class chatPosition;

class chatRevenueAmount;

class chatTheme;

class closeBirthdayUser;

class downloadedFileCounts;

class draftMessage;

class emojiStatus;

class error;

class factCheck;

class file;

class fileDownload;

class forumTopicInfo;

class groupCall;

class groupCallParticipant;

class languagePackString;

class location;

class message;

class messageInteractionInfo;

class messageReaction;

class notification;

class notificationGroup;

class orderInfo;

class poll;

class profileAccentColor;

class quickReplyMessage;

class quickReplyShortcut;

class reactionNotificationSettings;

class savedMessagesTags;

class savedMessagesTopic;

class scopeAutosaveSettings;

class scopeNotificationSettings;

class secretChat;

class starAmount;

class starRevenueStatus;

class sticker;

class stickerSet;

class story;

class supergroup;

class supergroupFullInfo;

class termsOfService;

class trendingStickerSets;

class unconfirmedSession;

class unreadReaction;

class user;

class userFullInfo;

class userPrivacySettingRules;

class videoChat;

class Update: public Object {
 public:
};

class updateAuthorizationState final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<AuthorizationState> authorization_state_;

  updateAuthorizationState();

  explicit updateAuthorizationState(object_ptr<AuthorizationState> &&authorization_state_);

  static const std::int32_t ID = 1622347490;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;

  updateNewMessage();

  explicit updateNewMessage(object_ptr<message> &&message_);

  static const std::int32_t ID = -563105266;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageSendAcknowledged final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  updateMessageSendAcknowledged();

  updateMessageSendAcknowledged(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = 1302843961;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageSendSucceeded final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;
  int53 old_message_id_;

  updateMessageSendSucceeded();

  updateMessageSendSucceeded(object_ptr<message> &&message_, int53 old_message_id_);

  static const std::int32_t ID = 1815715197;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageSendFailed final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<message> message_;
  int53 old_message_id_;
  object_ptr<error> error_;

  updateMessageSendFailed();

  updateMessageSendFailed(object_ptr<message> &&message_, int53 old_message_id_, object_ptr<error> &&error_);

  static const std::int32_t ID = -635701017;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageContent final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<MessageContent> new_content_;

  updateMessageContent();

  updateMessageContent(int53 chat_id_, int53 message_id_, object_ptr<MessageContent> &&new_content_);

  static const std::int32_t ID = 506903332;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageEdited final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int32 edit_date_;
  object_ptr<ReplyMarkup> reply_markup_;

  updateMessageEdited();

  updateMessageEdited(int53 chat_id_, int53 message_id_, int32 edit_date_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = -559545626;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageIsPinned final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  bool is_pinned_;

  updateMessageIsPinned();

  updateMessageIsPinned(int53 chat_id_, int53 message_id_, bool is_pinned_);

  static const std::int32_t ID = 1102848829;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageInteractionInfo final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<messageInteractionInfo> interaction_info_;

  updateMessageInteractionInfo();

  updateMessageInteractionInfo(int53 chat_id_, int53 message_id_, object_ptr<messageInteractionInfo> &&interaction_info_);

  static const std::int32_t ID = -1417659394;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageContentOpened final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  updateMessageContentOpened();

  updateMessageContentOpened(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -1520523131;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageMentionRead final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int32 unread_mention_count_;

  updateMessageMentionRead();

  updateMessageMentionRead(int53 chat_id_, int53 message_id_, int32 unread_mention_count_);

  static const std::int32_t ID = -252228282;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageUnreadReactions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  array<object_ptr<unreadReaction>> unread_reactions_;
  int32 unread_reaction_count_;

  updateMessageUnreadReactions();

  updateMessageUnreadReactions(int53 chat_id_, int53 message_id_, array<object_ptr<unreadReaction>> &&unread_reactions_, int32 unread_reaction_count_);

  static const std::int32_t ID = 942840008;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageFactCheck final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<factCheck> fact_check_;

  updateMessageFactCheck();

  updateMessageFactCheck(int53 chat_id_, int53 message_id_, object_ptr<factCheck> &&fact_check_);

  static const std::int32_t ID = 1014561538;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageLiveLocationViewed final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  updateMessageLiveLocationViewed();

  updateMessageLiveLocationViewed(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -1308260971;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateVideoPublished final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  updateVideoPublished();

  updateVideoPublished(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -352575406;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewChat final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chat> chat_;

  updateNewChat();

  explicit updateNewChat(object_ptr<chat> &&chat_);

  static const std::int32_t ID = 2075757773;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatTitle final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string title_;

  updateChatTitle();

  updateChatTitle(int53 chat_id_, string const &title_);

  static const std::int32_t ID = -175405660;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatPhoto final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<chatPhotoInfo> photo_;

  updateChatPhoto();

  updateChatPhoto(int53 chat_id_, object_ptr<chatPhotoInfo> &&photo_);

  static const std::int32_t ID = -324713921;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatAccentColors final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 accent_color_id_;
  int64 background_custom_emoji_id_;
  int32 profile_accent_color_id_;
  int64 profile_background_custom_emoji_id_;

  updateChatAccentColors();

  updateChatAccentColors(int53 chat_id_, int32 accent_color_id_, int64 background_custom_emoji_id_, int32 profile_accent_color_id_, int64 profile_background_custom_emoji_id_);

  static const std::int32_t ID = -1212614407;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatPermissions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<chatPermissions> permissions_;

  updateChatPermissions();

  updateChatPermissions(int53 chat_id_, object_ptr<chatPermissions> &&permissions_);

  static const std::int32_t ID = -1622010003;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatLastMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<message> last_message_;
  array<object_ptr<chatPosition>> positions_;

  updateChatLastMessage();

  updateChatLastMessage(int53 chat_id_, object_ptr<message> &&last_message_, array<object_ptr<chatPosition>> &&positions_);

  static const std::int32_t ID = -923244537;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatPosition final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<chatPosition> position_;

  updateChatPosition();

  updateChatPosition(int53 chat_id_, object_ptr<chatPosition> &&position_);

  static const std::int32_t ID = -8979849;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatAddedToList final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<ChatList> chat_list_;

  updateChatAddedToList();

  updateChatAddedToList(int53 chat_id_, object_ptr<ChatList> &&chat_list_);

  static const std::int32_t ID = -1418722068;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatRemovedFromList final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<ChatList> chat_list_;

  updateChatRemovedFromList();

  updateChatRemovedFromList(int53 chat_id_, object_ptr<ChatList> &&chat_list_);

  static const std::int32_t ID = 1294647836;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatReadInbox final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 last_read_inbox_message_id_;
  int32 unread_count_;

  updateChatReadInbox();

  updateChatReadInbox(int53 chat_id_, int53 last_read_inbox_message_id_, int32 unread_count_);

  static const std::int32_t ID = -797952281;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatReadOutbox final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 last_read_outbox_message_id_;

  updateChatReadOutbox();

  updateChatReadOutbox(int53 chat_id_, int53 last_read_outbox_message_id_);

  static const std::int32_t ID = 708334213;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatActionBar final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<ChatActionBar> action_bar_;

  updateChatActionBar();

  updateChatActionBar(int53 chat_id_, object_ptr<ChatActionBar> &&action_bar_);

  static const std::int32_t ID = -643671870;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatBusinessBotManageBar final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<businessBotManageBar> business_bot_manage_bar_;

  updateChatBusinessBotManageBar();

  updateChatBusinessBotManageBar(int53 chat_id_, object_ptr<businessBotManageBar> &&business_bot_manage_bar_);

  static const std::int32_t ID = -1104091145;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatAvailableReactions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<ChatAvailableReactions> available_reactions_;

  updateChatAvailableReactions();

  updateChatAvailableReactions(int53 chat_id_, object_ptr<ChatAvailableReactions> &&available_reactions_);

  static const std::int32_t ID = -1967909895;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatDraftMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<draftMessage> draft_message_;
  array<object_ptr<chatPosition>> positions_;

  updateChatDraftMessage();

  updateChatDraftMessage(int53 chat_id_, object_ptr<draftMessage> &&draft_message_, array<object_ptr<chatPosition>> &&positions_);

  static const std::int32_t ID = 1455190380;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatEmojiStatus final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<emojiStatus> emoji_status_;

  updateChatEmojiStatus();

  updateChatEmojiStatus(int53 chat_id_, object_ptr<emojiStatus> &&emoji_status_);

  static const std::int32_t ID = 2004444432;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatMessageSender final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<MessageSender> message_sender_id_;

  updateChatMessageSender();

  updateChatMessageSender(int53 chat_id_, object_ptr<MessageSender> &&message_sender_id_);

  static const std::int32_t ID = 2003849793;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatMessageAutoDeleteTime final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 message_auto_delete_time_;

  updateChatMessageAutoDeleteTime();

  updateChatMessageAutoDeleteTime(int53 chat_id_, int32 message_auto_delete_time_);

  static const std::int32_t ID = 1900174821;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatNotificationSettings final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<chatNotificationSettings> notification_settings_;

  updateChatNotificationSettings();

  updateChatNotificationSettings(int53 chat_id_, object_ptr<chatNotificationSettings> &&notification_settings_);

  static const std::int32_t ID = -803163050;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatPendingJoinRequests final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<chatJoinRequestsInfo> pending_join_requests_;

  updateChatPendingJoinRequests();

  updateChatPendingJoinRequests(int53 chat_id_, object_ptr<chatJoinRequestsInfo> &&pending_join_requests_);

  static const std::int32_t ID = 348578785;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatReplyMarkup final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 reply_markup_message_id_;

  updateChatReplyMarkup();

  updateChatReplyMarkup(int53 chat_id_, int53 reply_markup_message_id_);

  static const std::int32_t ID = 1309386144;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatBackground final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<chatBackground> background_;

  updateChatBackground();

  updateChatBackground(int53 chat_id_, object_ptr<chatBackground> &&background_);

  static const std::int32_t ID = -6473549;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatTheme final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string theme_name_;

  updateChatTheme();

  updateChatTheme(int53 chat_id_, string const &theme_name_);

  static const std::int32_t ID = 838063205;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatUnreadMentionCount final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 unread_mention_count_;

  updateChatUnreadMentionCount();

  updateChatUnreadMentionCount(int53 chat_id_, int32 unread_mention_count_);

  static const std::int32_t ID = -2131461348;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatUnreadReactionCount final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 unread_reaction_count_;

  updateChatUnreadReactionCount();

  updateChatUnreadReactionCount(int53 chat_id_, int32 unread_reaction_count_);

  static const std::int32_t ID = -2124399395;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatVideoChat final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<videoChat> video_chat_;

  updateChatVideoChat();

  updateChatVideoChat(int53 chat_id_, object_ptr<videoChat> &&video_chat_);

  static const std::int32_t ID = 637226150;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatDefaultDisableNotification final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool default_disable_notification_;

  updateChatDefaultDisableNotification();

  updateChatDefaultDisableNotification(int53 chat_id_, bool default_disable_notification_);

  static const std::int32_t ID = 464087707;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatHasProtectedContent final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool has_protected_content_;

  updateChatHasProtectedContent();

  updateChatHasProtectedContent(int53 chat_id_, bool has_protected_content_);

  static const std::int32_t ID = 1800406811;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatIsTranslatable final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool is_translatable_;

  updateChatIsTranslatable();

  updateChatIsTranslatable(int53 chat_id_, bool is_translatable_);

  static const std::int32_t ID = 2063799831;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatIsMarkedAsUnread final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool is_marked_as_unread_;

  updateChatIsMarkedAsUnread();

  updateChatIsMarkedAsUnread(int53 chat_id_, bool is_marked_as_unread_);

  static const std::int32_t ID = 1468347188;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatViewAsTopics final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool view_as_topics_;

  updateChatViewAsTopics();

  updateChatViewAsTopics(int53 chat_id_, bool view_as_topics_);

  static const std::int32_t ID = 1543444029;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatBlockList final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<BlockList> block_list_;

  updateChatBlockList();

  updateChatBlockList(int53 chat_id_, object_ptr<BlockList> &&block_list_);

  static const std::int32_t ID = -2027228018;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatHasScheduledMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool has_scheduled_messages_;

  updateChatHasScheduledMessages();

  updateChatHasScheduledMessages(int53 chat_id_, bool has_scheduled_messages_);

  static const std::int32_t ID = 2064958167;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatFolders final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatFolderInfo>> chat_folders_;
  int32 main_chat_list_position_;
  bool are_tags_enabled_;

  updateChatFolders();

  updateChatFolders(array<object_ptr<chatFolderInfo>> &&chat_folders_, int32 main_chat_list_position_, bool are_tags_enabled_);

  static const std::int32_t ID = 1998101395;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatOnlineMemberCount final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 online_member_count_;

  updateChatOnlineMemberCount();

  updateChatOnlineMemberCount(int53 chat_id_, int32 online_member_count_);

  static const std::int32_t ID = 487369373;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSavedMessagesTopic final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<savedMessagesTopic> topic_;

  updateSavedMessagesTopic();

  explicit updateSavedMessagesTopic(object_ptr<savedMessagesTopic> &&topic_);

  static const std::int32_t ID = -1618855120;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSavedMessagesTopicCount final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 topic_count_;

  updateSavedMessagesTopicCount();

  explicit updateSavedMessagesTopicCount(int32 topic_count_);

  static const std::int32_t ID = -70092335;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateQuickReplyShortcut final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<quickReplyShortcut> shortcut_;

  updateQuickReplyShortcut();

  explicit updateQuickReplyShortcut(object_ptr<quickReplyShortcut> &&shortcut_);

  static const std::int32_t ID = -963430193;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateQuickReplyShortcutDeleted final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;

  updateQuickReplyShortcutDeleted();

  explicit updateQuickReplyShortcutDeleted(int32 shortcut_id_);

  static const std::int32_t ID = -390480838;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateQuickReplyShortcuts final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> shortcut_ids_;

  updateQuickReplyShortcuts();

  explicit updateQuickReplyShortcuts(array<int32> &&shortcut_ids_);

  static const std::int32_t ID = -1994849731;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateQuickReplyShortcutMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  array<object_ptr<quickReplyMessage>> messages_;

  updateQuickReplyShortcutMessages();

  updateQuickReplyShortcutMessages(int32 shortcut_id_, array<object_ptr<quickReplyMessage>> &&messages_);

  static const std::int32_t ID = -1396685225;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateForumTopicInfo final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<forumTopicInfo> info_;

  updateForumTopicInfo();

  explicit updateForumTopicInfo(object_ptr<forumTopicInfo> &&info_);

  static const std::int32_t ID = 1420762696;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateForumTopic final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_thread_id_;
  bool is_pinned_;
  int53 last_read_inbox_message_id_;
  int53 last_read_outbox_message_id_;
  object_ptr<chatNotificationSettings> notification_settings_;

  updateForumTopic();

  updateForumTopic(int53 chat_id_, int53 message_thread_id_, bool is_pinned_, int53 last_read_inbox_message_id_, int53 last_read_outbox_message_id_, object_ptr<chatNotificationSettings> &&notification_settings_);

  static const std::int32_t ID = 266794534;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateScopeNotificationSettings final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<NotificationSettingsScope> scope_;
  object_ptr<scopeNotificationSettings> notification_settings_;

  updateScopeNotificationSettings();

  updateScopeNotificationSettings(object_ptr<NotificationSettingsScope> &&scope_, object_ptr<scopeNotificationSettings> &&notification_settings_);

  static const std::int32_t ID = -1203975309;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateReactionNotificationSettings final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<reactionNotificationSettings> notification_settings_;

  updateReactionNotificationSettings();

  explicit updateReactionNotificationSettings(object_ptr<reactionNotificationSettings> &&notification_settings_);

  static const std::int32_t ID = -447932436;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNotification final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 notification_group_id_;
  object_ptr<notification> notification_;

  updateNotification();

  updateNotification(int32 notification_group_id_, object_ptr<notification> &&notification_);

  static const std::int32_t ID = -1897496876;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNotificationGroup final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 notification_group_id_;
  object_ptr<NotificationGroupType> type_;
  int53 chat_id_;
  int53 notification_settings_chat_id_;
  int64 notification_sound_id_;
  int32 total_count_;
  array<object_ptr<notification>> added_notifications_;
  array<int32> removed_notification_ids_;

  updateNotificationGroup();

  updateNotificationGroup(int32 notification_group_id_, object_ptr<NotificationGroupType> &&type_, int53 chat_id_, int53 notification_settings_chat_id_, int64 notification_sound_id_, int32 total_count_, array<object_ptr<notification>> &&added_notifications_, array<int32> &&removed_notification_ids_);

  static const std::int32_t ID = 1381081378;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateActiveNotifications final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<notificationGroup>> groups_;

  updateActiveNotifications();

  explicit updateActiveNotifications(array<object_ptr<notificationGroup>> &&groups_);

  static const std::int32_t ID = -1306672221;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateHavePendingNotifications final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool have_delayed_notifications_;
  bool have_unreceived_notifications_;

  updateHavePendingNotifications();

  updateHavePendingNotifications(bool have_delayed_notifications_, bool have_unreceived_notifications_);

  static const std::int32_t ID = 179233243;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDeleteMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  array<int53> message_ids_;
  bool is_permanent_;
  bool from_cache_;

  updateDeleteMessages();

  updateDeleteMessages(int53 chat_id_, array<int53> &&message_ids_, bool is_permanent_, bool from_cache_);

  static const std::int32_t ID = 1669252686;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatAction final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_thread_id_;
  object_ptr<MessageSender> sender_id_;
  object_ptr<ChatAction> action_;

  updateChatAction();

  updateChatAction(int53 chat_id_, int53 message_thread_id_, object_ptr<MessageSender> &&sender_id_, object_ptr<ChatAction> &&action_);

  static const std::int32_t ID = -1698703832;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUserStatus final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<UserStatus> status_;

  updateUserStatus();

  updateUserStatus(int53 user_id_, object_ptr<UserStatus> &&status_);

  static const std::int32_t ID = 958468625;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUser final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<user> user_;

  updateUser();

  explicit updateUser(object_ptr<user> &&user_);

  static const std::int32_t ID = 1183394041;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBasicGroup final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<basicGroup> basic_group_;

  updateBasicGroup();

  explicit updateBasicGroup(object_ptr<basicGroup> &&basic_group_);

  static const std::int32_t ID = -1003239581;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSupergroup final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<supergroup> supergroup_;

  updateSupergroup();

  explicit updateSupergroup(object_ptr<supergroup> &&supergroup_);

  static const std::int32_t ID = -76782300;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSecretChat final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<secretChat> secret_chat_;

  updateSecretChat();

  explicit updateSecretChat(object_ptr<secretChat> &&secret_chat_);

  static const std::int32_t ID = -1666903253;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUserFullInfo final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<userFullInfo> user_full_info_;

  updateUserFullInfo();

  updateUserFullInfo(int53 user_id_, object_ptr<userFullInfo> &&user_full_info_);

  static const std::int32_t ID = -51197161;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBasicGroupFullInfo final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 basic_group_id_;
  object_ptr<basicGroupFullInfo> basic_group_full_info_;

  updateBasicGroupFullInfo();

  updateBasicGroupFullInfo(int53 basic_group_id_, object_ptr<basicGroupFullInfo> &&basic_group_full_info_);

  static const std::int32_t ID = 1391881151;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSupergroupFullInfo final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;
  object_ptr<supergroupFullInfo> supergroup_full_info_;

  updateSupergroupFullInfo();

  updateSupergroupFullInfo(int53 supergroup_id_, object_ptr<supergroupFullInfo> &&supergroup_full_info_);

  static const std::int32_t ID = 435539214;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateServiceNotification final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string type_;
  object_ptr<MessageContent> content_;

  updateServiceNotification();

  updateServiceNotification(string const &type_, object_ptr<MessageContent> &&content_);

  static const std::int32_t ID = 1318622637;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFile final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<file> file_;

  updateFile();

  explicit updateFile(object_ptr<file> &&file_);

  static const std::int32_t ID = 114132831;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFileGenerationStart final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 generation_id_;
  string original_path_;
  string destination_path_;
  string conversion_;

  updateFileGenerationStart();

  updateFileGenerationStart(int64 generation_id_, string const &original_path_, string const &destination_path_, string const &conversion_);

  static const std::int32_t ID = 216817388;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFileGenerationStop final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 generation_id_;

  updateFileGenerationStop();

  explicit updateFileGenerationStop(int64 generation_id_);

  static const std::int32_t ID = -1894449685;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFileDownloads final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 total_size_;
  int32 total_count_;
  int53 downloaded_size_;

  updateFileDownloads();

  updateFileDownloads(int53 total_size_, int32 total_count_, int53 downloaded_size_);

  static const std::int32_t ID = -389213497;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFileAddedToDownloads final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<fileDownload> file_download_;
  object_ptr<downloadedFileCounts> counts_;

  updateFileAddedToDownloads();

  updateFileAddedToDownloads(object_ptr<fileDownload> &&file_download_, object_ptr<downloadedFileCounts> &&counts_);

  static const std::int32_t ID = 1609929242;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFileDownload final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;
  int32 complete_date_;
  bool is_paused_;
  object_ptr<downloadedFileCounts> counts_;

  updateFileDownload();

  updateFileDownload(int32 file_id_, int32 complete_date_, bool is_paused_, object_ptr<downloadedFileCounts> &&counts_);

  static const std::int32_t ID = 875529162;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFileRemovedFromDownloads final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;
  object_ptr<downloadedFileCounts> counts_;

  updateFileRemovedFromDownloads();

  updateFileRemovedFromDownloads(int32 file_id_, object_ptr<downloadedFileCounts> &&counts_);

  static const std::int32_t ID = 1853625576;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateApplicationVerificationRequired final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 verification_id_;
  string nonce_;
  int64 cloud_project_number_;

  updateApplicationVerificationRequired();

  updateApplicationVerificationRequired(int53 verification_id_, string const &nonce_, int64 cloud_project_number_);

  static const std::int32_t ID = -979607081;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateApplicationRecaptchaVerificationRequired final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 verification_id_;
  string action_;
  string recaptcha_key_id_;

  updateApplicationRecaptchaVerificationRequired();

  updateApplicationRecaptchaVerificationRequired(int53 verification_id_, string const &action_, string const &recaptcha_key_id_);

  static const std::int32_t ID = -1796351554;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateCall final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<call> call_;

  updateCall();

  explicit updateCall(object_ptr<call> &&call_);

  static const std::int32_t ID = 1337184477;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateGroupCall final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<groupCall> group_call_;

  updateGroupCall();

  explicit updateGroupCall(object_ptr<groupCall> &&group_call_);

  static const std::int32_t ID = 808603136;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateGroupCallParticipant final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  object_ptr<groupCallParticipant> participant_;

  updateGroupCallParticipant();

  updateGroupCallParticipant(int32 group_call_id_, object_ptr<groupCallParticipant> &&participant_);

  static const std::int32_t ID = -803128071;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateGroupCallParticipants final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  array<int64> participant_user_ids_;

  updateGroupCallParticipants();

  updateGroupCallParticipants(int32 group_call_id_, array<int64> &&participant_user_ids_);

  static const std::int32_t ID = -1874006374;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateGroupCallVerificationState final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  int32 generation_;
  array<string> emojis_;

  updateGroupCallVerificationState();

  updateGroupCallVerificationState(int32 group_call_id_, int32 generation_, array<string> &&emojis_);

  static const std::int32_t ID = 682965060;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewCallSignalingData final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 call_id_;
  bytes data_;

  updateNewCallSignalingData();

  updateNewCallSignalingData(int32 call_id_, bytes const &data_);

  static const std::int32_t ID = 583634317;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUserPrivacySettingRules final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<UserPrivacySetting> setting_;
  object_ptr<userPrivacySettingRules> rules_;

  updateUserPrivacySettingRules();

  updateUserPrivacySettingRules(object_ptr<UserPrivacySetting> &&setting_, object_ptr<userPrivacySettingRules> &&rules_);

  static const std::int32_t ID = -912960778;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUnreadMessageCount final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatList> chat_list_;
  int32 unread_count_;
  int32 unread_unmuted_count_;

  updateUnreadMessageCount();

  updateUnreadMessageCount(object_ptr<ChatList> &&chat_list_, int32 unread_count_, int32 unread_unmuted_count_);

  static const std::int32_t ID = 78987721;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUnreadChatCount final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatList> chat_list_;
  int32 total_count_;
  int32 unread_count_;
  int32 unread_unmuted_count_;
  int32 marked_as_unread_count_;
  int32 marked_as_unread_unmuted_count_;

  updateUnreadChatCount();

  updateUnreadChatCount(object_ptr<ChatList> &&chat_list_, int32 total_count_, int32 unread_count_, int32 unread_unmuted_count_, int32 marked_as_unread_count_, int32 marked_as_unread_unmuted_count_);

  static const std::int32_t ID = 1994494530;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStory final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<story> story_;

  updateStory();

  explicit updateStory(object_ptr<story> &&story_);

  static const std::int32_t ID = 419845935;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStoryDeleted final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;

  updateStoryDeleted();

  updateStoryDeleted(int53 story_poster_chat_id_, int32 story_id_);

  static const std::int32_t ID = -582743166;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStoryPostSucceeded final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<story> story_;
  int32 old_story_id_;

  updateStoryPostSucceeded();

  updateStoryPostSucceeded(object_ptr<story> &&story_, int32 old_story_id_);

  static const std::int32_t ID = -1712432318;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStoryPostFailed final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<story> story_;
  object_ptr<error> error_;
  object_ptr<CanPostStoryResult> error_type_;

  updateStoryPostFailed();

  updateStoryPostFailed(object_ptr<story> &&story_, object_ptr<error> &&error_, object_ptr<CanPostStoryResult> &&error_type_);

  static const std::int32_t ID = 1248168444;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatActiveStories final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatActiveStories> active_stories_;

  updateChatActiveStories();

  explicit updateChatActiveStories(object_ptr<chatActiveStories> &&active_stories_);

  static const std::int32_t ID = 2037935148;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStoryListChatCount final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StoryList> story_list_;
  int32 chat_count_;

  updateStoryListChatCount();

  updateStoryListChatCount(object_ptr<StoryList> &&story_list_, int32 chat_count_);

  static const std::int32_t ID = -2009871041;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStoryStealthMode final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 active_until_date_;
  int32 cooldown_until_date_;

  updateStoryStealthMode();

  updateStoryStealthMode(int32 active_until_date_, int32 cooldown_until_date_);

  static const std::int32_t ID = 1878506778;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateOption final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<OptionValue> value_;

  updateOption();

  updateOption(string const &name_, object_ptr<OptionValue> &&value_);

  static const std::int32_t ID = 900822020;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStickerSet final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<stickerSet> sticker_set_;

  updateStickerSet();

  explicit updateStickerSet(object_ptr<stickerSet> &&sticker_set_);

  static const std::int32_t ID = 1879268812;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateInstalledStickerSets final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StickerType> sticker_type_;
  array<int64> sticker_set_ids_;

  updateInstalledStickerSets();

  updateInstalledStickerSets(object_ptr<StickerType> &&sticker_type_, array<int64> &&sticker_set_ids_);

  static const std::int32_t ID = -1735084182;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateTrendingStickerSets final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StickerType> sticker_type_;
  object_ptr<trendingStickerSets> sticker_sets_;

  updateTrendingStickerSets();

  updateTrendingStickerSets(object_ptr<StickerType> &&sticker_type_, object_ptr<trendingStickerSets> &&sticker_sets_);

  static const std::int32_t ID = 1266307239;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateRecentStickers final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_attached_;
  array<int32> sticker_ids_;

  updateRecentStickers();

  updateRecentStickers(bool is_attached_, array<int32> &&sticker_ids_);

  static const std::int32_t ID = 1906403540;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFavoriteStickers final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> sticker_ids_;

  updateFavoriteStickers();

  explicit updateFavoriteStickers(array<int32> &&sticker_ids_);

  static const std::int32_t ID = 1662240999;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSavedAnimations final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int32> animation_ids_;

  updateSavedAnimations();

  explicit updateSavedAnimations(array<int32> &&animation_ids_);

  static const std::int32_t ID = 65563814;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSavedNotificationSounds final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> notification_sound_ids_;

  updateSavedNotificationSounds();

  explicit updateSavedNotificationSounds(array<int64> &&notification_sound_ids_);

  static const std::int32_t ID = 1052725698;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDefaultBackground final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool for_dark_theme_;
  object_ptr<background> background_;

  updateDefaultBackground();

  updateDefaultBackground(bool for_dark_theme_, object_ptr<background> &&background_);

  static const std::int32_t ID = -716139217;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatThemes final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<chatTheme>> chat_themes_;

  updateChatThemes();

  explicit updateChatThemes(array<object_ptr<chatTheme>> &&chat_themes_);

  static const std::int32_t ID = -1588098376;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateAccentColors final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<accentColor>> colors_;
  array<int32> available_accent_color_ids_;

  updateAccentColors();

  updateAccentColors(array<object_ptr<accentColor>> &&colors_, array<int32> &&available_accent_color_ids_);

  static const std::int32_t ID = -1197047738;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateProfileAccentColors final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<profileAccentColor>> colors_;
  array<int32> available_accent_color_ids_;

  updateProfileAccentColors();

  updateProfileAccentColors(array<object_ptr<profileAccentColor>> &&colors_, array<int32> &&available_accent_color_ids_);

  static const std::int32_t ID = 605202104;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateLanguagePackStrings final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string localization_target_;
  string language_pack_id_;
  array<object_ptr<languagePackString>> strings_;

  updateLanguagePackStrings();

  updateLanguagePackStrings(string const &localization_target_, string const &language_pack_id_, array<object_ptr<languagePackString>> &&strings_);

  static const std::int32_t ID = -1056319886;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateConnectionState final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ConnectionState> state_;

  updateConnectionState();

  explicit updateConnectionState(object_ptr<ConnectionState> &&state_);

  static const std::int32_t ID = 1469292078;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateFreezeState final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_frozen_;
  int32 freezing_date_;
  int32 deletion_date_;
  string appeal_link_;

  updateFreezeState();

  updateFreezeState(bool is_frozen_, int32 freezing_date_, int32 deletion_date_, string const &appeal_link_);

  static const std::int32_t ID = 1692410540;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateTermsOfService final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string terms_of_service_id_;
  object_ptr<termsOfService> terms_of_service_;

  updateTermsOfService();

  updateTermsOfService(string const &terms_of_service_id_, object_ptr<termsOfService> &&terms_of_service_);

  static const std::int32_t ID = -1304640162;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateUnconfirmedSession final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<unconfirmedSession> session_;

  updateUnconfirmedSession();

  explicit updateUnconfirmedSession(object_ptr<unconfirmedSession> &&session_);

  static const std::int32_t ID = -22673268;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateAttachmentMenuBots final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<attachmentMenuBot>> bots_;

  updateAttachmentMenuBots();

  explicit updateAttachmentMenuBots(array<object_ptr<attachmentMenuBot>> &&bots_);

  static const std::int32_t ID = 291369922;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateWebAppMessageSent final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 web_app_launch_id_;

  updateWebAppMessageSent();

  explicit updateWebAppMessageSent(int64 web_app_launch_id_);

  static const std::int32_t ID = 1480790569;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateActiveEmojiReactions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> emojis_;

  updateActiveEmojiReactions();

  explicit updateActiveEmojiReactions(array<string> &&emojis_);

  static const std::int32_t ID = 77556818;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateAvailableMessageEffects final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> reaction_effect_ids_;
  array<int64> sticker_effect_ids_;

  updateAvailableMessageEffects();

  updateAvailableMessageEffects(array<int64> &&reaction_effect_ids_, array<int64> &&sticker_effect_ids_);

  static const std::int32_t ID = 1964701061;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDefaultReactionType final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ReactionType> reaction_type_;

  updateDefaultReactionType();

  explicit updateDefaultReactionType(object_ptr<ReactionType> &&reaction_type_);

  static const std::int32_t ID = 1264668933;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDefaultPaidReactionType final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PaidReactionType> type_;

  updateDefaultPaidReactionType();

  explicit updateDefaultPaidReactionType(object_ptr<PaidReactionType> &&type_);

  static const std::int32_t ID = 38198599;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSavedMessagesTags final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 saved_messages_topic_id_;
  object_ptr<savedMessagesTags> tags_;

  updateSavedMessagesTags();

  updateSavedMessagesTags(int53 saved_messages_topic_id_, object_ptr<savedMessagesTags> &&tags_);

  static const std::int32_t ID = 1938178634;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateActiveLiveLocationMessages final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<message>> messages_;

  updateActiveLiveLocationMessages();

  explicit updateActiveLiveLocationMessages(array<object_ptr<message>> &&messages_);

  static const std::int32_t ID = -1308142440;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateOwnedStarCount final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<starAmount> star_amount_;

  updateOwnedStarCount();

  explicit updateOwnedStarCount(object_ptr<starAmount> &&star_amount_);

  static const std::int32_t ID = -1350647928;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatRevenueAmount final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<chatRevenueAmount> revenue_amount_;

  updateChatRevenueAmount();

  updateChatRevenueAmount(int53 chat_id_, object_ptr<chatRevenueAmount> &&revenue_amount_);

  static const std::int32_t ID = -959857468;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateStarRevenueStatus final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> owner_id_;
  object_ptr<starRevenueStatus> status_;

  updateStarRevenueStatus();

  updateStarRevenueStatus(object_ptr<MessageSender> &&owner_id_, object_ptr<starRevenueStatus> &&status_);

  static const std::int32_t ID = -280232757;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSpeechRecognitionTrial final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 max_media_duration_;
  int32 weekly_count_;
  int32 left_count_;
  int32 next_reset_date_;

  updateSpeechRecognitionTrial();

  updateSpeechRecognitionTrial(int32 max_media_duration_, int32 weekly_count_, int32 left_count_, int32 next_reset_date_);

  static const std::int32_t ID = -11600703;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateDiceEmojis final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> emojis_;

  updateDiceEmojis();

  explicit updateDiceEmojis(array<string> &&emojis_);

  static const std::int32_t ID = -1069066940;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateAnimatedEmojiMessageClicked final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<sticker> sticker_;

  updateAnimatedEmojiMessageClicked();

  updateAnimatedEmojiMessageClicked(int53 chat_id_, int53 message_id_, object_ptr<sticker> &&sticker_);

  static const std::int32_t ID = -1558809595;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateAnimationSearchParameters final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string provider_;
  array<string> emojis_;

  updateAnimationSearchParameters();

  updateAnimationSearchParameters(string const &provider_, array<string> &&emojis_);

  static const std::int32_t ID = -1144983202;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSuggestedActions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<SuggestedAction>> added_actions_;
  array<object_ptr<SuggestedAction>> removed_actions_;

  updateSuggestedActions();

  updateSuggestedActions(array<object_ptr<SuggestedAction>> &&added_actions_, array<object_ptr<SuggestedAction>> &&removed_actions_);

  static const std::int32_t ID = 1459452346;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateSpeedLimitNotification final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_upload_;

  updateSpeedLimitNotification();

  explicit updateSpeedLimitNotification(bool is_upload_);

  static const std::int32_t ID = -964437912;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateContactCloseBirthdays final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<closeBirthdayUser>> close_birthday_users_;

  updateContactCloseBirthdays();

  explicit updateContactCloseBirthdays(array<object_ptr<closeBirthdayUser>> &&close_birthday_users_);

  static const std::int32_t ID = -36007873;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateAutosaveSettings final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<AutosaveSettingsScope> scope_;
  object_ptr<scopeAutosaveSettings> settings_;

  updateAutosaveSettings();

  updateAutosaveSettings(object_ptr<AutosaveSettingsScope> &&scope_, object_ptr<scopeAutosaveSettings> &&settings_);

  static const std::int32_t ID = -634958069;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBusinessConnection final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<businessConnection> connection_;

  updateBusinessConnection();

  explicit updateBusinessConnection(object_ptr<businessConnection> &&connection_);

  static const std::int32_t ID = -2043480970;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewBusinessMessage final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string connection_id_;
  object_ptr<businessMessage> message_;

  updateNewBusinessMessage();

  updateNewBusinessMessage(string const &connection_id_, object_ptr<businessMessage> &&message_);

  static const std::int32_t ID = -2034350524;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBusinessMessageEdited final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string connection_id_;
  object_ptr<businessMessage> message_;

  updateBusinessMessageEdited();

  updateBusinessMessageEdited(string const &connection_id_, object_ptr<businessMessage> &&message_);

  static const std::int32_t ID = -2119799415;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateBusinessMessagesDeleted final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string connection_id_;
  int53 chat_id_;
  array<int53> message_ids_;

  updateBusinessMessagesDeleted();

  updateBusinessMessagesDeleted(string const &connection_id_, int53 chat_id_, array<int53> &&message_ids_);

  static const std::int32_t ID = -1106703050;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewInlineQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int53 sender_user_id_;
  object_ptr<location> user_location_;
  object_ptr<ChatType> chat_type_;
  string query_;
  string offset_;

  updateNewInlineQuery();

  updateNewInlineQuery(int64 id_, int53 sender_user_id_, object_ptr<location> &&user_location_, object_ptr<ChatType> &&chat_type_, string const &query_, string const &offset_);

  static const std::int32_t ID = 1903279924;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewChosenInlineResult final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 sender_user_id_;
  object_ptr<location> user_location_;
  string query_;
  string result_id_;
  string inline_message_id_;

  updateNewChosenInlineResult();

  updateNewChosenInlineResult(int53 sender_user_id_, object_ptr<location> &&user_location_, string const &query_, string const &result_id_, string const &inline_message_id_);

  static const std::int32_t ID = -884191395;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewCallbackQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int53 sender_user_id_;
  int53 chat_id_;
  int53 message_id_;
  int64 chat_instance_;
  object_ptr<CallbackQueryPayload> payload_;

  updateNewCallbackQuery();

  updateNewCallbackQuery(int64 id_, int53 sender_user_id_, int53 chat_id_, int53 message_id_, int64 chat_instance_, object_ptr<CallbackQueryPayload> &&payload_);

  static const std::int32_t ID = -1989881762;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewInlineCallbackQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int53 sender_user_id_;
  string inline_message_id_;
  int64 chat_instance_;
  object_ptr<CallbackQueryPayload> payload_;

  updateNewInlineCallbackQuery();

  updateNewInlineCallbackQuery(int64 id_, int53 sender_user_id_, string const &inline_message_id_, int64 chat_instance_, object_ptr<CallbackQueryPayload> &&payload_);

  static const std::int32_t ID = -319212358;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewBusinessCallbackQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int53 sender_user_id_;
  string connection_id_;
  object_ptr<businessMessage> message_;
  int64 chat_instance_;
  object_ptr<CallbackQueryPayload> payload_;

  updateNewBusinessCallbackQuery();

  updateNewBusinessCallbackQuery(int64 id_, int53 sender_user_id_, string const &connection_id_, object_ptr<businessMessage> &&message_, int64 chat_instance_, object_ptr<CallbackQueryPayload> &&payload_);

  static const std::int32_t ID = 336745316;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewShippingQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int53 sender_user_id_;
  string invoice_payload_;
  object_ptr<address> shipping_address_;

  updateNewShippingQuery();

  updateNewShippingQuery(int64 id_, int53 sender_user_id_, string const &invoice_payload_, object_ptr<address> &&shipping_address_);

  static const std::int32_t ID = 693651058;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewPreCheckoutQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  int53 sender_user_id_;
  string currency_;
  int53 total_amount_;
  bytes invoice_payload_;
  string shipping_option_id_;
  object_ptr<orderInfo> order_info_;

  updateNewPreCheckoutQuery();

  updateNewPreCheckoutQuery(int64 id_, int53 sender_user_id_, string const &currency_, int53 total_amount_, bytes const &invoice_payload_, string const &shipping_option_id_, object_ptr<orderInfo> &&order_info_);

  static const std::int32_t ID = 708342217;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewCustomEvent final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string event_;

  updateNewCustomEvent();

  explicit updateNewCustomEvent(string const &event_);

  static const std::int32_t ID = 1994222092;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewCustomQuery final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  string data_;
  int32 timeout_;

  updateNewCustomQuery();

  updateNewCustomQuery(int64 id_, string const &data_, int32 timeout_);

  static const std::int32_t ID = -687670874;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePoll final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<poll> poll_;

  updatePoll();

  explicit updatePoll(object_ptr<poll> &&poll_);

  static const std::int32_t ID = -1771342902;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePollAnswer final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 poll_id_;
  object_ptr<MessageSender> voter_id_;
  array<int32> option_ids_;

  updatePollAnswer();

  updatePollAnswer(int64 poll_id_, object_ptr<MessageSender> &&voter_id_, array<int32> &&option_ids_);

  static const std::int32_t ID = 1104905219;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatMember final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 actor_user_id_;
  int32 date_;
  object_ptr<chatInviteLink> invite_link_;
  bool via_join_request_;
  bool via_chat_folder_invite_link_;
  object_ptr<chatMember> old_chat_member_;
  object_ptr<chatMember> new_chat_member_;

  updateChatMember();

  updateChatMember(int53 chat_id_, int53 actor_user_id_, int32 date_, object_ptr<chatInviteLink> &&invite_link_, bool via_join_request_, bool via_chat_folder_invite_link_, object_ptr<chatMember> &&old_chat_member_, object_ptr<chatMember> &&new_chat_member_);

  static const std::int32_t ID = -1736025145;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateNewChatJoinRequest final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<chatJoinRequest> request_;
  int53 user_chat_id_;
  object_ptr<chatInviteLink> invite_link_;

  updateNewChatJoinRequest();

  updateNewChatJoinRequest(int53 chat_id_, object_ptr<chatJoinRequest> &&request_, int53 user_chat_id_, object_ptr<chatInviteLink> &&invite_link_);

  static const std::int32_t ID = 2118694979;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateChatBoost final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<chatBoost> boost_;

  updateChatBoost();

  updateChatBoost(int53 chat_id_, object_ptr<chatBoost> &&boost_);

  static const std::int32_t ID = 1349680676;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageReaction final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<MessageSender> actor_id_;
  int32 date_;
  array<object_ptr<ReactionType>> old_reaction_types_;
  array<object_ptr<ReactionType>> new_reaction_types_;

  updateMessageReaction();

  updateMessageReaction(int53 chat_id_, int53 message_id_, object_ptr<MessageSender> &&actor_id_, int32 date_, array<object_ptr<ReactionType>> &&old_reaction_types_, array<object_ptr<ReactionType>> &&new_reaction_types_);

  static const std::int32_t ID = 1084895706;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updateMessageReactions final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int32 date_;
  array<object_ptr<messageReaction>> reactions_;

  updateMessageReactions();

  updateMessageReactions(int53 chat_id_, int53 message_id_, int32 date_, array<object_ptr<messageReaction>> &&reactions_);

  static const std::int32_t ID = 955237189;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updatePaidMediaPurchased final : public Update {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string payload_;

  updatePaidMediaPurchased();

  updatePaidMediaPurchased(int53 user_id_, string const &payload_);

  static const std::int32_t ID = -1542396325;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class Update;

class updates final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<Update>> updates_;

  updates();

  explicit updates(array<object_ptr<Update>> &&updates_);

  static const std::int32_t ID = 475842347;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGift;

class upgradeGiftResult final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<upgradedGift> gift_;
  string received_gift_id_;
  bool is_saved_;
  bool can_be_transferred_;
  int53 transfer_star_count_;
  int32 next_transfer_date_;
  int32 next_resale_date_;
  int32 export_date_;

  upgradeGiftResult();

  upgradeGiftResult(object_ptr<upgradedGift> &&gift_, string const &received_gift_id_, bool is_saved_, bool can_be_transferred_, int53 transfer_star_count_, int32 next_transfer_date_, int32 next_resale_date_, int32 export_date_);

  static const std::int32_t ID = 233376346;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class upgradedGiftBackdrop;

class upgradedGiftModel;

class upgradedGiftOriginalDetails;

class upgradedGiftSymbol;

class upgradedGift final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 id_;
  string title_;
  string name_;
  int32 number_;
  int32 total_upgraded_count_;
  int32 max_upgraded_count_;
  object_ptr<MessageSender> owner_id_;
  string owner_address_;
  string owner_name_;
  string gift_address_;
  object_ptr<upgradedGiftModel> model_;
  object_ptr<upgradedGiftSymbol> symbol_;
  object_ptr<upgradedGiftBackdrop> backdrop_;
  object_ptr<upgradedGiftOriginalDetails> original_details_;
  int53 resale_star_count_;

  upgradedGift();

  upgradedGift(int64 id_, string const &title_, string const &name_, int32 number_, int32 total_upgraded_count_, int32 max_upgraded_count_, object_ptr<MessageSender> &&owner_id_, string const &owner_address_, string const &owner_name_, string const &gift_address_, object_ptr<upgradedGiftModel> &&model_, object_ptr<upgradedGiftSymbol> &&symbol_, object_ptr<upgradedGiftBackdrop> &&backdrop_, object_ptr<upgradedGiftOriginalDetails> &&original_details_, int53 resale_star_count_);

  static const std::int32_t ID = 992832410;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UpgradedGiftAttributeId: public Object {
 public:
};

class upgradedGiftAttributeIdModel final : public UpgradedGiftAttributeId {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 sticker_id_;

  upgradedGiftAttributeIdModel();

  explicit upgradedGiftAttributeIdModel(int64 sticker_id_);

  static const std::int32_t ID = 1053287307;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGiftAttributeIdSymbol final : public UpgradedGiftAttributeId {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 sticker_id_;

  upgradedGiftAttributeIdSymbol();

  explicit upgradedGiftAttributeIdSymbol(int64 sticker_id_);

  static const std::int32_t ID = 1188205608;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGiftAttributeIdBackdrop final : public UpgradedGiftAttributeId {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 backdrop_id_;

  upgradedGiftAttributeIdBackdrop();

  explicit upgradedGiftAttributeIdBackdrop(int32 backdrop_id_);

  static const std::int32_t ID = 1461997935;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGiftBackdropColors;

class upgradedGiftBackdrop final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 id_;
  string name_;
  object_ptr<upgradedGiftBackdropColors> colors_;
  int32 rarity_per_mille_;

  upgradedGiftBackdrop();

  upgradedGiftBackdrop(int32 id_, string const &name_, object_ptr<upgradedGiftBackdropColors> &&colors_, int32 rarity_per_mille_);

  static const std::int32_t ID = -378289242;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGiftBackdropColors final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 center_color_;
  int32 edge_color_;
  int32 symbol_color_;
  int32 text_color_;

  upgradedGiftBackdropColors();

  upgradedGiftBackdropColors(int32 center_color_, int32 edge_color_, int32 symbol_color_, int32 text_color_);

  static const std::int32_t ID = 4227529;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGiftBackdrop;

class upgradedGiftBackdropCount final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<upgradedGiftBackdrop> backdrop_;
  int32 total_count_;

  upgradedGiftBackdropCount();

  upgradedGiftBackdropCount(object_ptr<upgradedGiftBackdrop> &&backdrop_, int32 total_count_);

  static const std::int32_t ID = -562274120;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class upgradedGiftModel final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<sticker> sticker_;
  int32 rarity_per_mille_;

  upgradedGiftModel();

  upgradedGiftModel(string const &name_, object_ptr<sticker> &&sticker_, int32 rarity_per_mille_);

  static const std::int32_t ID = 1360156751;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGiftModel;

class upgradedGiftModelCount final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<upgradedGiftModel> model_;
  int32 total_count_;

  upgradedGiftModelCount();

  upgradedGiftModelCount(object_ptr<upgradedGiftModel> &&model_, int32 total_count_);

  static const std::int32_t ID = -1127238023;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class formattedText;

class upgradedGiftOriginalDetails final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> sender_id_;
  object_ptr<MessageSender> receiver_id_;
  object_ptr<formattedText> text_;
  int32 date_;

  upgradedGiftOriginalDetails();

  upgradedGiftOriginalDetails(object_ptr<MessageSender> &&sender_id_, object_ptr<MessageSender> &&receiver_id_, object_ptr<formattedText> &&text_, int32 date_);

  static const std::int32_t ID = 55247728;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class upgradedGiftSymbol final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<sticker> sticker_;
  int32 rarity_per_mille_;

  upgradedGiftSymbol();

  upgradedGiftSymbol(string const &name_, object_ptr<sticker> &&sticker_, int32 rarity_per_mille_);

  static const std::int32_t ID = 1128318383;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class upgradedGiftSymbol;

class upgradedGiftSymbolCount final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<upgradedGiftSymbol> symbol_;
  int32 total_count_;

  upgradedGiftSymbolCount();

  upgradedGiftSymbolCount(object_ptr<upgradedGiftSymbol> &&symbol_, int32 total_count_);

  static const std::int32_t ID = -773579874;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UserStatus;

class UserType;

class emojiStatus;

class profilePhoto;

class usernames;

class verificationStatus;

class user final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 id_;
  string first_name_;
  string last_name_;
  object_ptr<usernames> usernames_;
  string phone_number_;
  object_ptr<UserStatus> status_;
  object_ptr<profilePhoto> profile_photo_;
  int32 accent_color_id_;
  int64 background_custom_emoji_id_;
  int32 profile_accent_color_id_;
  int64 profile_background_custom_emoji_id_;
  object_ptr<emojiStatus> emoji_status_;
  bool is_contact_;
  bool is_mutual_contact_;
  bool is_close_friend_;
  object_ptr<verificationStatus> verification_status_;
  bool is_premium_;
  bool is_support_;
  string restriction_reason_;
  bool has_active_stories_;
  bool has_unread_active_stories_;
  bool restricts_new_chats_;
  int53 paid_message_star_count_;
  bool have_access_;
  object_ptr<UserType> type_;
  string language_code_;
  bool added_to_attachment_menu_;

  user();

  user(int53 id_, string const &first_name_, string const &last_name_, object_ptr<usernames> &&usernames_, string const &phone_number_, object_ptr<UserStatus> &&status_, object_ptr<profilePhoto> &&profile_photo_, int32 accent_color_id_, int64 background_custom_emoji_id_, int32 profile_accent_color_id_, int64 profile_background_custom_emoji_id_, object_ptr<emojiStatus> &&emoji_status_, bool is_contact_, bool is_mutual_contact_, bool is_close_friend_, object_ptr<verificationStatus> &&verification_status_, bool is_premium_, bool is_support_, string const &restriction_reason_, bool has_active_stories_, bool has_unread_active_stories_, bool restricts_new_chats_, int53 paid_message_star_count_, bool have_access_, object_ptr<UserType> &&type_, string const &language_code_, bool added_to_attachment_menu_);

  static const std::int32_t ID = -1848524366;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BlockList;

class birthdate;

class botInfo;

class botVerification;

class businessInfo;

class chatPhoto;

class formattedText;

class giftSettings;

class userFullInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatPhoto> personal_photo_;
  object_ptr<chatPhoto> photo_;
  object_ptr<chatPhoto> public_photo_;
  object_ptr<BlockList> block_list_;
  bool can_be_called_;
  bool supports_video_calls_;
  bool has_private_calls_;
  bool has_private_forwards_;
  bool has_restricted_voice_and_video_note_messages_;
  bool has_posted_to_profile_stories_;
  bool has_sponsored_messages_enabled_;
  bool need_phone_number_privacy_exception_;
  bool set_chat_background_;
  object_ptr<formattedText> bio_;
  object_ptr<birthdate> birthdate_;
  int53 personal_chat_id_;
  int32 gift_count_;
  int32 group_in_common_count_;
  int53 incoming_paid_message_star_count_;
  int53 outgoing_paid_message_star_count_;
  object_ptr<giftSettings> gift_settings_;
  object_ptr<botVerification> bot_verification_;
  object_ptr<businessInfo> business_info_;
  object_ptr<botInfo> bot_info_;

  userFullInfo();

  userFullInfo(object_ptr<chatPhoto> &&personal_photo_, object_ptr<chatPhoto> &&photo_, object_ptr<chatPhoto> &&public_photo_, object_ptr<BlockList> &&block_list_, bool can_be_called_, bool supports_video_calls_, bool has_private_calls_, bool has_private_forwards_, bool has_restricted_voice_and_video_note_messages_, bool has_posted_to_profile_stories_, bool has_sponsored_messages_enabled_, bool need_phone_number_privacy_exception_, bool set_chat_background_, object_ptr<formattedText> &&bio_, object_ptr<birthdate> &&birthdate_, int53 personal_chat_id_, int32 gift_count_, int32 group_in_common_count_, int53 incoming_paid_message_star_count_, int53 outgoing_paid_message_star_count_, object_ptr<giftSettings> &&gift_settings_, object_ptr<botVerification> &&bot_verification_, object_ptr<businessInfo> &&business_info_, object_ptr<botInfo> &&bot_info_);

  static const std::int32_t ID = -121173496;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userLink final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;
  int32 expires_in_;

  userLink();

  userLink(string const &url_, int32 expires_in_);

  static const std::int32_t ID = 498138872;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UserPrivacySetting: public Object {
 public:
};

class userPrivacySettingShowStatus final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingShowStatus();

  static const std::int32_t ID = 1862829310;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingShowProfilePhoto final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingShowProfilePhoto();

  static const std::int32_t ID = 1408485877;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingShowLinkInForwardedMessages final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingShowLinkInForwardedMessages();

  static const std::int32_t ID = 592688870;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingShowPhoneNumber final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingShowPhoneNumber();

  static const std::int32_t ID = -791567831;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingShowBio final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingShowBio();

  static const std::int32_t ID = 959981409;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingShowBirthdate final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingShowBirthdate();

  static const std::int32_t ID = 1167504607;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingAllowChatInvites final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingAllowChatInvites();

  static const std::int32_t ID = 1271668007;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingAllowCalls final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingAllowCalls();

  static const std::int32_t ID = -906967291;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingAllowPeerToPeerCalls final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingAllowPeerToPeerCalls();

  static const std::int32_t ID = 352500032;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingAllowFindingByPhoneNumber final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingAllowFindingByPhoneNumber();

  static const std::int32_t ID = -1846645423;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingAllowPrivateVoiceAndVideoNoteMessages();

  static const std::int32_t ID = 338112060;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingAutosaveGifts final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingAutosaveGifts();

  static const std::int32_t ID = 1889167821;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingAllowUnpaidMessages final : public UserPrivacySetting {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingAllowUnpaidMessages();

  static const std::int32_t ID = 1430051047;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UserPrivacySettingRule: public Object {
 public:
};

class userPrivacySettingRuleAllowAll final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingRuleAllowAll();

  static const std::int32_t ID = -1967186881;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleAllowContacts final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingRuleAllowContacts();

  static const std::int32_t ID = -1892733680;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleAllowBots final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingRuleAllowBots();

  static const std::int32_t ID = 1404208925;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleAllowPremiumUsers final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingRuleAllowPremiumUsers();

  static const std::int32_t ID = 1624147265;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleAllowUsers final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> user_ids_;

  userPrivacySettingRuleAllowUsers();

  explicit userPrivacySettingRuleAllowUsers(array<int53> &&user_ids_);

  static const std::int32_t ID = 1110988334;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleAllowChatMembers final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> chat_ids_;

  userPrivacySettingRuleAllowChatMembers();

  explicit userPrivacySettingRuleAllowChatMembers(array<int53> &&chat_ids_);

  static const std::int32_t ID = -2048749863;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleRestrictAll final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingRuleRestrictAll();

  static const std::int32_t ID = -1406495408;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleRestrictContacts final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingRuleRestrictContacts();

  static const std::int32_t ID = 1008389378;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleRestrictBots final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userPrivacySettingRuleRestrictBots();

  static const std::int32_t ID = -1902547363;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleRestrictUsers final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> user_ids_;

  userPrivacySettingRuleRestrictUsers();

  explicit userPrivacySettingRuleRestrictUsers(array<int53> &&user_ids_);

  static const std::int32_t ID = 622796522;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userPrivacySettingRuleRestrictChatMembers final : public UserPrivacySettingRule {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> chat_ids_;

  userPrivacySettingRuleRestrictChatMembers();

  explicit userPrivacySettingRuleRestrictChatMembers(array<int53> &&chat_ids_);

  static const std::int32_t ID = 392530897;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UserPrivacySettingRule;

class userPrivacySettingRules final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<UserPrivacySettingRule>> rules_;

  userPrivacySettingRules();

  explicit userPrivacySettingRules(array<object_ptr<UserPrivacySettingRule>> &&rules_);

  static const std::int32_t ID = 322477541;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UserStatus: public Object {
 public:
};

class userStatusEmpty final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userStatusEmpty();

  static const std::int32_t ID = 164646985;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusOnline final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 expires_;

  userStatusOnline();

  explicit userStatusOnline(int32 expires_);

  static const std::int32_t ID = -1529460876;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusOffline final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 was_online_;

  userStatusOffline();

  explicit userStatusOffline(int32 was_online_);

  static const std::int32_t ID = -759984891;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusRecently final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool by_my_privacy_settings_;

  userStatusRecently();

  explicit userStatusRecently(bool by_my_privacy_settings_);

  static const std::int32_t ID = 262824117;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusLastWeek final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool by_my_privacy_settings_;

  userStatusLastWeek();

  explicit userStatusLastWeek(bool by_my_privacy_settings_);

  static const std::int32_t ID = 310385495;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userStatusLastMonth final : public UserStatus {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool by_my_privacy_settings_;

  userStatusLastMonth();

  explicit userStatusLastMonth(bool by_my_privacy_settings_);

  static const std::int32_t ID = -1194644996;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class userSupportInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> message_;
  string author_;
  int32 date_;

  userSupportInfo();

  userSupportInfo(object_ptr<formattedText> &&message_, string const &author_, int32 date_);

  static const std::int32_t ID = -1257366487;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class UserType: public Object {
 public:
};

class userTypeRegular final : public UserType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userTypeRegular();

  static const std::int32_t ID = -598644325;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userTypeDeleted final : public UserType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userTypeDeleted();

  static const std::int32_t ID = -1807729372;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userTypeBot final : public UserType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool can_be_edited_;
  bool can_join_groups_;
  bool can_read_all_group_messages_;
  bool has_main_web_app_;
  bool is_inline_;
  string inline_query_placeholder_;
  bool need_location_;
  bool can_connect_to_business_;
  bool can_be_added_to_attachment_menu_;
  int32 active_user_count_;

  userTypeBot();

  userTypeBot(bool can_be_edited_, bool can_join_groups_, bool can_read_all_group_messages_, bool has_main_web_app_, bool is_inline_, string const &inline_query_placeholder_, bool need_location_, bool can_connect_to_business_, bool can_be_added_to_attachment_menu_, int32 active_user_count_);

  static const std::int32_t ID = -1952199642;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class userTypeUnknown final : public UserType {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  userTypeUnknown();

  static const std::int32_t ID = -724541123;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class usernames final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<string> active_usernames_;
  array<string> disabled_usernames_;
  string editable_username_;

  usernames();

  usernames(array<string> &&active_usernames_, array<string> &&disabled_usernames_, string const &editable_username_);

  static const std::int32_t ID = 799608565;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class users final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 total_count_;
  array<int53> user_ids_;

  users();

  users(int32 total_count_, array<int53> &&user_ids_);

  static const std::int32_t ID = 171203420;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class shippingOption;

class validatedOrderInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string order_info_id_;
  array<object_ptr<shippingOption>> shipping_options_;

  validatedOrderInfo();

  validatedOrderInfo(string const &order_info_id_, array<object_ptr<shippingOption>> &&shipping_options_);

  static const std::int32_t ID = 1511451484;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class point;

class VectorPathCommand: public Object {
 public:
};

class vectorPathCommandLine final : public VectorPathCommand {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<point> end_point_;

  vectorPathCommandLine();

  explicit vectorPathCommandLine(object_ptr<point> &&end_point_);

  static const std::int32_t ID = -614056822;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class vectorPathCommandCubicBezierCurve final : public VectorPathCommand {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<point> start_control_point_;
  object_ptr<point> end_control_point_;
  object_ptr<point> end_point_;

  vectorPathCommandCubicBezierCurve();

  vectorPathCommandCubicBezierCurve(object_ptr<point> &&start_control_point_, object_ptr<point> &&end_control_point_, object_ptr<point> &&end_point_);

  static const std::int32_t ID = 1229733434;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class location;

class venue final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;
  string title_;
  string address_;
  string provider_;
  string id_;
  string type_;

  venue();

  venue(object_ptr<location> &&location_, string const &title_, string const &address_, string const &provider_, string const &id_, string const &type_);

  static const std::int32_t ID = 1070406393;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class verificationStatus final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_verified_;
  bool is_scam_;
  bool is_fake_;
  int64 bot_verification_icon_custom_emoji_id_;

  verificationStatus();

  verificationStatus(bool is_verified_, bool is_scam_, bool is_fake_, int64 bot_verification_icon_custom_emoji_id_);

  static const std::int32_t ID = 988193164;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class minithumbnail;

class thumbnail;

class video final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 duration_;
  int32 width_;
  int32 height_;
  string file_name_;
  string mime_type_;
  bool has_stickers_;
  bool supports_streaming_;
  object_ptr<minithumbnail> minithumbnail_;
  object_ptr<thumbnail> thumbnail_;
  object_ptr<file> video_;

  video();

  video(int32 duration_, int32 width_, int32 height_, string const &file_name_, string const &mime_type_, bool has_stickers_, bool supports_streaming_, object_ptr<minithumbnail> &&minithumbnail_, object_ptr<thumbnail> &&thumbnail_, object_ptr<file> &&video_);

  static const std::int32_t ID = 832856268;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class videoChat final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  bool has_participants_;
  object_ptr<MessageSender> default_participant_id_;

  videoChat();

  videoChat(int32 group_call_id_, bool has_participants_, object_ptr<MessageSender> &&default_participant_id_);

  static const std::int32_t ID = -1374319320;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class videoChatStream final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 channel_id_;
  int32 scale_;
  int53 time_offset_;

  videoChatStream();

  videoChatStream(int32 channel_id_, int32 scale_, int53 time_offset_);

  static const std::int32_t ID = -1151707172;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class videoChatStream;

class videoChatStreams final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<videoChatStream>> streams_;

  videoChatStreams();

  explicit videoChatStreams(array<object_ptr<videoChatStream>> &&streams_);

  static const std::int32_t ID = -434622720;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SpeechRecognitionResult;

class file;

class minithumbnail;

class thumbnail;

class videoNote final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 duration_;
  bytes waveform_;
  int32 length_;
  object_ptr<minithumbnail> minithumbnail_;
  object_ptr<thumbnail> thumbnail_;
  object_ptr<SpeechRecognitionResult> speech_recognition_result_;
  object_ptr<file> video_;

  videoNote();

  videoNote(int32 duration_, bytes const &waveform_, int32 length_, object_ptr<minithumbnail> &&minithumbnail_, object_ptr<thumbnail> &&thumbnail_, object_ptr<SpeechRecognitionResult> &&speech_recognition_result_, object_ptr<file> &&video_);

  static const std::int32_t ID = 2062096581;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SpeechRecognitionResult;

class file;

class voiceNote final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 duration_;
  bytes waveform_;
  string mime_type_;
  object_ptr<SpeechRecognitionResult> speech_recognition_result_;
  object_ptr<file> voice_;

  voiceNote();

  voiceNote(int32 duration_, bytes const &waveform_, string const &mime_type_, object_ptr<SpeechRecognitionResult> &&speech_recognition_result_, object_ptr<file> &&voice_);

  static const std::int32_t ID = -1175302923;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class animation;

class photo;

class webApp final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string short_name_;
  string title_;
  string description_;
  object_ptr<photo> photo_;
  object_ptr<animation> animation_;

  webApp();

  webApp(string const &short_name_, string const &title_, string const &description_, object_ptr<photo> &&photo_, object_ptr<animation> &&animation_);

  static const std::int32_t ID = 1616619763;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webAppInfo final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 launch_id_;
  string url_;

  webAppInfo();

  webAppInfo(int64 launch_id_, string const &url_);

  static const std::int32_t ID = 788378344;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class WebAppOpenMode: public Object {
 public:
};

class webAppOpenModeCompact final : public WebAppOpenMode {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  webAppOpenModeCompact();

  static const std::int32_t ID = 1711603675;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webAppOpenModeFullSize final : public WebAppOpenMode {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  webAppOpenModeFullSize();

  static const std::int32_t ID = 189320513;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class webAppOpenModeFullScreen final : public WebAppOpenMode {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  webAppOpenModeFullScreen();

  static const std::int32_t ID = 1871315357;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class WebAppOpenMode;

class themeParameters;

class webAppOpenParameters final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<themeParameters> theme_;
  string application_name_;
  object_ptr<WebAppOpenMode> mode_;

  webAppOpenParameters();

  webAppOpenParameters(object_ptr<themeParameters> &&theme_, string const &application_name_, object_ptr<WebAppOpenMode> &&mode_);

  static const std::int32_t ID = 1375356527;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InternalLinkType;

class PageBlock;

class webPageInstantView final : public Object {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<PageBlock>> page_blocks_;
  int32 view_count_;
  int32 version_;
  bool is_rtl_;
  bool is_full_;
  object_ptr<InternalLinkType> feedback_link_;

  webPageInstantView();

  webPageInstantView(array<object_ptr<PageBlock>> &&page_blocks_, int32 view_count_, int32 version_, bool is_rtl_, bool is_full_, object_ptr<InternalLinkType> &&feedback_link_);

  static const std::int32_t ID = 778202453;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callProtocol;

class ok;

class acceptCall final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 call_id_;
  object_ptr<callProtocol> protocol_;

  acceptCall();

  acceptCall(int32 call_id_, object_ptr<callProtocol> &&protocol_);

  static const std::int32_t ID = -646618416;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class acceptTermsOfService final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string terms_of_service_id_;

  acceptTermsOfService();

  explicit acceptTermsOfService(string const &terms_of_service_id_);

  static const std::int32_t ID = 2130576356;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class activateStoryStealthMode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  activateStoryStealthMode();

  static const std::int32_t ID = -1009023855;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputStoryContent;

class botMediaPreview;

class addBotMediaPreview final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string language_code_;
  object_ptr<InputStoryContent> content_;

  addBotMediaPreview();

  addBotMediaPreview(int53 bot_user_id_, string const &language_code_, object_ptr<InputStoryContent> &&content_);

  static const std::int32_t ID = 1347126571;

  using ReturnType = object_ptr<botMediaPreview>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class addChatFolderByInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;
  array<int53> chat_ids_;

  addChatFolderByInviteLink();

  addChatFolderByInviteLink(string const &invite_link_, array<int53> &&chat_ids_);

  static const std::int32_t ID = -858593816;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class failedToAddMembers;

class addChatMember final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 user_id_;
  int32 forward_limit_;

  addChatMember();

  addChatMember(int53 chat_id_, int53 user_id_, int32 forward_limit_);

  static const std::int32_t ID = 1720144407;

  using ReturnType = object_ptr<failedToAddMembers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class failedToAddMembers;

class addChatMembers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  array<int53> user_ids_;

  addChatMembers();

  addChatMembers(int53 chat_id_, array<int53> &&user_ids_);

  static const std::int32_t ID = -1675991329;

  using ReturnType = object_ptr<failedToAddMembers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatList;

class ok;

class addChatToList final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<ChatList> chat_list_;

  addChatToList();

  addChatToList(int53 chat_id_, object_ptr<ChatList> &&chat_list_);

  static const std::int32_t ID = -80523595;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class contact;

class ok;

class addContact final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<contact> contact_;
  bool share_phone_number_;

  addContact();

  addContact(object_ptr<contact> &&contact_, bool share_phone_number_);

  static const std::int32_t ID = 1869640000;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class addCustomServerLanguagePack final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string language_pack_id_;

  addCustomServerLanguagePack();

  explicit addCustomServerLanguagePack(string const &language_pack_id_);

  static const std::int32_t ID = 4492771;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class ok;

class addFavoriteSticker final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> sticker_;

  addFavoriteSticker();

  explicit addFavoriteSticker(object_ptr<InputFile> &&sticker_);

  static const std::int32_t ID = 324504799;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class addFileToDownloads final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;
  int53 chat_id_;
  int53 message_id_;
  int32 priority_;

  addFileToDownloads();

  addFileToDownloads(int32 file_id_, int53 chat_id_, int53 message_id_, int32 priority_);

  static const std::int32_t ID = 867533751;

  using ReturnType = object_ptr<file>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class InputMessageReplyTo;

class MessageSender;

class message;

class addLocalMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<MessageSender> sender_id_;
  object_ptr<InputMessageReplyTo> reply_to_;
  bool disable_notification_;
  object_ptr<InputMessageContent> input_message_content_;

  addLocalMessage();

  addLocalMessage(int53 chat_id_, object_ptr<MessageSender> &&sender_id_, object_ptr<InputMessageReplyTo> &&reply_to_, bool disable_notification_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = -166217823;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class addLogMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 verbosity_level_;
  string text_;

  addLogMessage();

  addLogMessage(int32 verbosity_level_, string const &text_);

  static const std::int32_t ID = 1597427692;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType;

class ok;

class addMessageReaction final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReactionType> reaction_type_;
  bool is_big_;
  bool update_recent_reactions_;

  addMessageReaction();

  addMessageReaction(int53 chat_id_, int53 message_id_, object_ptr<ReactionType> &&reaction_type_, bool is_big_, bool update_recent_reactions_);

  static const std::int32_t ID = 1419269613;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NetworkStatisticsEntry;

class ok;

class addNetworkStatistics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<NetworkStatisticsEntry> entry_;

  addNetworkStatistics();

  explicit addNetworkStatistics(object_ptr<NetworkStatisticsEntry> &&entry_);

  static const std::int32_t ID = 1264825305;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PaidReactionType;

class ok;

class addPendingPaidMessageReaction final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int53 star_count_;
  object_ptr<PaidReactionType> type_;

  addPendingPaidMessageReaction();

  addPendingPaidMessageReaction(int53 chat_id_, int53 message_id_, int53 star_count_, object_ptr<PaidReactionType> &&type_);

  static const std::int32_t ID = -342110765;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ProxyType;

class proxy;

class addProxy final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string server_;
  int32 port_;
  bool enable_;
  object_ptr<ProxyType> type_;

  addProxy();

  addProxy(string const &server_, int32 port_, bool enable_, object_ptr<ProxyType> &&type_);

  static const std::int32_t ID = 331529432;

  using ReturnType = object_ptr<proxy>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class quickReplyMessage;

class addQuickReplyShortcutInlineQueryResultMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string shortcut_name_;
  int53 reply_to_message_id_;
  int64 query_id_;
  string result_id_;
  bool hide_via_bot_;

  addQuickReplyShortcutInlineQueryResultMessage();

  addQuickReplyShortcutInlineQueryResultMessage(string const &shortcut_name_, int53 reply_to_message_id_, int64 query_id_, string const &result_id_, bool hide_via_bot_);

  static const std::int32_t ID = -2017449468;

  using ReturnType = object_ptr<quickReplyMessage>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class quickReplyMessage;

class addQuickReplyShortcutMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string shortcut_name_;
  int53 reply_to_message_id_;
  object_ptr<InputMessageContent> input_message_content_;

  addQuickReplyShortcutMessage();

  addQuickReplyShortcutMessage(string const &shortcut_name_, int53 reply_to_message_id_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 1058573098;

  using ReturnType = object_ptr<quickReplyMessage>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class quickReplyMessages;

class addQuickReplyShortcutMessageAlbum final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string shortcut_name_;
  int53 reply_to_message_id_;
  array<object_ptr<InputMessageContent>> input_message_contents_;

  addQuickReplyShortcutMessageAlbum();

  addQuickReplyShortcutMessageAlbum(string const &shortcut_name_, int53 reply_to_message_id_, array<object_ptr<InputMessageContent>> &&input_message_contents_);

  static const std::int32_t ID = 1348436244;

  using ReturnType = object_ptr<quickReplyMessages>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class stickers;

class addRecentSticker final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_attached_;
  object_ptr<InputFile> sticker_;

  addRecentSticker();

  addRecentSticker(bool is_attached_, object_ptr<InputFile> &&sticker_);

  static const std::int32_t ID = -1478109026;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class addRecentlyFoundChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  addRecentlyFoundChat();

  explicit addRecentlyFoundChat(int53 chat_id_);

  static const std::int32_t ID = -1746396787;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class ok;

class addSavedAnimation final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> animation_;

  addSavedAnimation();

  explicit addSavedAnimation(object_ptr<InputFile> &&animation_);

  static const std::int32_t ID = -1538525088;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class notificationSound;

class addSavedNotificationSound final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> sound_;

  addSavedNotificationSound();

  explicit addSavedNotificationSound(object_ptr<InputFile> &&sound_);

  static const std::int32_t ID = 1043956975;

  using ReturnType = object_ptr<notificationSound>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inputSticker;

class ok;

class addStickerToSet final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string name_;
  object_ptr<inputSticker> sticker_;

  addStickerToSet();

  addStickerToSet(int53 user_id_, string const &name_, object_ptr<inputSticker> &&sticker_);

  static const std::int32_t ID = 1457266235;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class allowBotToSendMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;

  allowBotToSendMessages();

  explicit allowBotToSendMessages(int53 bot_user_id_);

  static const std::int32_t ID = 1776928142;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class allowUnpaidMessagesFromUser final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  bool refund_payments_;

  allowUnpaidMessagesFromUser();

  allowUnpaidMessagesFromUser(int53 user_id_, bool refund_payments_);

  static const std::int32_t ID = 803569495;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class answerCallbackQuery final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 callback_query_id_;
  string text_;
  bool show_alert_;
  string url_;
  int32 cache_time_;

  answerCallbackQuery();

  answerCallbackQuery(int64 callback_query_id_, string const &text_, bool show_alert_, string const &url_, int32 cache_time_);

  static const std::int32_t ID = -1153028490;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class answerCustomQuery final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 custom_query_id_;
  string data_;

  answerCustomQuery();

  answerCustomQuery(int64 custom_query_id_, string const &data_);

  static const std::int32_t ID = -1293603521;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputInlineQueryResult;

class inlineQueryResultsButton;

class ok;

class answerInlineQuery final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 inline_query_id_;
  bool is_personal_;
  object_ptr<inlineQueryResultsButton> button_;
  array<object_ptr<InputInlineQueryResult>> results_;
  int32 cache_time_;
  string next_offset_;

  answerInlineQuery();

  answerInlineQuery(int64 inline_query_id_, bool is_personal_, object_ptr<inlineQueryResultsButton> &&button_, array<object_ptr<InputInlineQueryResult>> &&results_, int32 cache_time_, string const &next_offset_);

  static const std::int32_t ID = 1343853844;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class answerPreCheckoutQuery final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 pre_checkout_query_id_;
  string error_message_;

  answerPreCheckoutQuery();

  answerPreCheckoutQuery(int64 pre_checkout_query_id_, string const &error_message_);

  static const std::int32_t ID = -1486789653;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class shippingOption;

class answerShippingQuery final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 shipping_query_id_;
  array<object_ptr<shippingOption>> shipping_options_;
  string error_message_;

  answerShippingQuery();

  answerShippingQuery(int64 shipping_query_id_, array<object_ptr<shippingOption>> &&shipping_options_, string const &error_message_);

  static const std::int32_t ID = -434601324;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputInlineQueryResult;

class sentWebAppMessage;

class answerWebAppQuery final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string web_app_query_id_;
  object_ptr<InputInlineQueryResult> result_;

  answerWebAppQuery();

  answerWebAppQuery(string const &web_app_query_id_, object_ptr<InputInlineQueryResult> &&result_);

  static const std::int32_t ID = -1598776079;

  using ReturnType = object_ptr<sentWebAppMessage>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class applyPremiumGiftCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  applyPremiumGiftCode();

  explicit applyPremiumGiftCode(string const &code_);

  static const std::int32_t ID = -1347138530;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StorePaymentPurpose;

class StoreTransaction;

class ok;

class assignStoreTransaction final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StoreTransaction> transaction_;
  object_ptr<StorePaymentPurpose> purpose_;

  assignStoreTransaction();

  assignStoreTransaction(object_ptr<StoreTransaction> &&transaction_, object_ptr<StorePaymentPurpose> &&purpose_);

  static const std::int32_t ID = -2046202900;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class ok;

class banChatMember final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<MessageSender> member_id_;
  int32 banned_until_date_;
  bool revoke_messages_;

  banChatMember();

  banChatMember(int53 chat_id_, object_ptr<MessageSender> &&member_id_, int32 banned_until_date_, bool revoke_messages_);

  static const std::int32_t ID = -888111748;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class banGroupCallParticipants final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  array<int64> user_ids_;

  banGroupCallParticipants();

  banGroupCallParticipants(int32 group_call_id_, array<int64> &&user_ids_);

  static const std::int32_t ID = 624883173;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class blockMessageSenderFromReplies final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 message_id_;
  bool delete_message_;
  bool delete_all_messages_;
  bool report_spam_;

  blockMessageSenderFromReplies();

  blockMessageSenderFromReplies(int53 message_id_, bool delete_message_, bool delete_all_messages_, bool report_spam_);

  static const std::int32_t ID = -1214384757;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostSlots;

class boostChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  array<int32> slot_ids_;

  boostChat();

  boostChat(int53 chat_id_, array<int32> &&slot_ids_);

  static const std::int32_t ID = 1945750252;

  using ReturnType = object_ptr<chatBoostSlots>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class canBotSendMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;

  canBotSendMessages();

  explicit canBotSendMessages(int53 bot_user_id_);

  static const std::int32_t ID = 544052364;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CanPostStoryResult;

class canPostStory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  canPostStory();

  explicit canPostStory(int53 chat_id_);

  static const std::int32_t ID = 668621518;

  using ReturnType = object_ptr<CanPostStoryResult>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StorePaymentPurpose;

class ok;

class canPurchaseFromStore final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StorePaymentPurpose> purpose_;

  canPurchaseFromStore();

  explicit canPurchaseFromStore(object_ptr<StorePaymentPurpose> &&purpose_);

  static const std::int32_t ID = 1017811816;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CanSendMessageToUserResult;

class canSendMessageToUser final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  bool only_local_;

  canSendMessageToUser();

  canSendMessageToUser(int53 user_id_, bool only_local_);

  static const std::int32_t ID = 1529489462;

  using ReturnType = object_ptr<CanSendMessageToUserResult>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CanTransferOwnershipResult;

class canTransferOwnership final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  canTransferOwnership();

  static const std::int32_t ID = 634602508;

  using ReturnType = object_ptr<CanTransferOwnershipResult>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class cancelDownloadFile final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;
  bool only_if_pending_;

  cancelDownloadFile();

  cancelDownloadFile(int32 file_id_, bool only_if_pending_);

  static const std::int32_t ID = -1954524450;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class cancelPasswordReset final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  cancelPasswordReset();

  static const std::int32_t ID = 940733538;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class cancelPreliminaryUploadFile final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;

  cancelPreliminaryUploadFile();

  explicit cancelPreliminaryUploadFile(int32 file_id_);

  static const std::int32_t ID = 823412414;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passwordState;

class cancelRecoveryEmailAddressVerification final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  cancelRecoveryEmailAddressVerification();

  static const std::int32_t ID = -1516728691;

  using ReturnType = object_ptr<passwordState>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class contact;

class importedContacts;

class changeImportedContacts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<object_ptr<contact>> contacts_;

  changeImportedContacts();

  explicit changeImportedContacts(array<object_ptr<contact>> &&contacts_);

  static const std::int32_t ID = 1968207955;

  using ReturnType = object_ptr<importedContacts>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class changeStickerSet final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 set_id_;
  bool is_installed_;
  bool is_archived_;

  changeStickerSet();

  changeStickerSet(int64 set_id_, bool is_installed_, bool is_archived_);

  static const std::int32_t ID = 449357293;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkAuthenticationBotToken final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string token_;

  checkAuthenticationBotToken();

  explicit checkAuthenticationBotToken(string const &token_);

  static const std::int32_t ID = 639321206;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkAuthenticationCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  checkAuthenticationCode();

  explicit checkAuthenticationCode(string const &code_);

  static const std::int32_t ID = -302103382;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmailAddressAuthentication;

class ok;

class checkAuthenticationEmailCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EmailAddressAuthentication> code_;

  checkAuthenticationEmailCode();

  explicit checkAuthenticationEmailCode(object_ptr<EmailAddressAuthentication> &&code_);

  static const std::int32_t ID = -582827361;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkAuthenticationPassword final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string password_;

  checkAuthenticationPassword();

  explicit checkAuthenticationPassword(string const &password_);

  static const std::int32_t ID = -2025698400;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkAuthenticationPasswordRecoveryCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string recovery_code_;

  checkAuthenticationPasswordRecoveryCode();

  explicit checkAuthenticationPasswordRecoveryCode(string const &recovery_code_);

  static const std::int32_t ID = -603309083;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkAuthenticationPremiumPurchase final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string currency_;
  int53 amount_;

  checkAuthenticationPremiumPurchase();

  checkAuthenticationPremiumPurchase(string const &currency_, int53 amount_);

  static const std::int32_t ID = 1588959934;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderInviteLinkInfo;

class checkChatFolderInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;

  checkChatFolderInviteLink();

  explicit checkChatFolderInviteLink(string const &invite_link_);

  static const std::int32_t ID = 522557851;

  using ReturnType = object_ptr<chatFolderInviteLinkInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLinkInfo;

class checkChatInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string invite_link_;

  checkChatInviteLink();

  explicit checkChatInviteLink(string const &invite_link_);

  static const std::int32_t ID = -496940997;

  using ReturnType = object_ptr<chatInviteLinkInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CheckChatUsernameResult;

class checkChatUsername final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string username_;

  checkChatUsername();

  checkChatUsername(int53 chat_id_, string const &username_);

  static const std::int32_t ID = -119119344;

  using ReturnType = object_ptr<CheckChatUsernameResult>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PublicChatType;

class ok;

class checkCreatedPublicChatsLimit final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PublicChatType> type_;

  checkCreatedPublicChatsLimit();

  explicit checkCreatedPublicChatsLimit(object_ptr<PublicChatType> &&type_);

  static const std::int32_t ID = -445546591;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkEmailAddressVerificationCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  checkEmailAddressVerificationCode();

  explicit checkEmailAddressVerificationCode(string const &code_);

  static const std::int32_t ID = -426386685;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmailAddressAuthentication;

class ok;

class checkLoginEmailAddressCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EmailAddressAuthentication> code_;

  checkLoginEmailAddressCode();

  explicit checkLoginEmailAddressCode(object_ptr<EmailAddressAuthentication> &&code_);

  static const std::int32_t ID = -1454244766;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkPasswordRecoveryCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string recovery_code_;

  checkPasswordRecoveryCode();

  explicit checkPasswordRecoveryCode(string const &recovery_code_);

  static const std::int32_t ID = -200794600;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkPhoneNumberCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  checkPhoneNumberCode();

  explicit checkPhoneNumberCode(string const &code_);

  static const std::int32_t ID = -603626079;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumGiftCodeInfo;

class checkPremiumGiftCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  checkPremiumGiftCode();

  explicit checkPremiumGiftCode(string const &code_);

  static const std::int32_t ID = -1786063260;

  using ReturnType = object_ptr<premiumGiftCodeInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkQuickReplyShortcutName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  checkQuickReplyShortcutName();

  explicit checkQuickReplyShortcutName(string const &name_);

  static const std::int32_t ID = 2101203241;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passwordState;

class checkRecoveryEmailAddressCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string code_;

  checkRecoveryEmailAddressCode();

  explicit checkRecoveryEmailAddressCode(string const &code_);

  static const std::int32_t ID = -1997039589;

  using ReturnType = object_ptr<passwordState>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CheckStickerSetNameResult;

class checkStickerSetName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  checkStickerSetName();

  explicit checkStickerSetName(string const &name_);

  static const std::int32_t ID = -1789392642;

  using ReturnType = object_ptr<CheckStickerSetNameResult>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class checkWebAppFileDownload final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string file_name_;
  string url_;

  checkWebAppFileDownload();

  checkWebAppFileDownload(int53 bot_user_id_, string const &file_name_, string const &url_);

  static const std::int32_t ID = -389397278;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class cleanFileName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string file_name_;

  cleanFileName();

  explicit cleanFileName(string const &file_name_);

  static const std::int32_t ID = 967964667;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clearAllDraftMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool exclude_secret_chats_;

  clearAllDraftMessages();

  explicit clearAllDraftMessages(bool exclude_secret_chats_);

  static const std::int32_t ID = -46369573;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clearAutosaveSettingsExceptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  clearAutosaveSettingsExceptions();

  static const std::int32_t ID = 1475109874;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clearImportedContacts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  clearImportedContacts();

  static const std::int32_t ID = 869503298;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clearRecentEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  clearRecentEmojiStatuses();

  static const std::int32_t ID = -428749986;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clearRecentReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  clearRecentReactions();

  static const std::int32_t ID = 1298253650;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clearRecentStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_attached_;

  clearRecentStickers();

  explicit clearRecentStickers(bool is_attached_);

  static const std::int32_t ID = -321242684;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clearRecentlyFoundChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  clearRecentlyFoundChats();

  static const std::int32_t ID = -285582542;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clearSearchedForTags final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool clear_cashtags_;

  clearSearchedForTags();

  explicit clearSearchedForTags(bool clear_cashtags_);

  static const std::int32_t ID = 512017238;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class clickAnimatedEmojiMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  clickAnimatedEmojiMessage();

  clickAnimatedEmojiMessage(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = 196179554;

  using ReturnType = object_ptr<sticker>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clickChatSponsoredMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  bool is_media_click_;
  bool from_fullscreen_;

  clickChatSponsoredMessage();

  clickChatSponsoredMessage(int53 chat_id_, int53 message_id_, bool is_media_click_, bool from_fullscreen_);

  static const std::int32_t ID = 971995671;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class clickPremiumSubscriptionButton final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  clickPremiumSubscriptionButton();

  static const std::int32_t ID = -369319162;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class close final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  close();

  static const std::int32_t ID = -1187782273;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class closeChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  closeChat();

  explicit closeChat(int53 chat_id_);

  static const std::int32_t ID = 39749353;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class closeSecretChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 secret_chat_id_;

  closeSecretChat();

  explicit closeSecretChat(int32 secret_chat_id_);

  static const std::int32_t ID = -471006133;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class closeStory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;

  closeStory();

  closeStory(int53 story_poster_chat_id_, int32 story_id_);

  static const std::int32_t ID = 1553967851;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class closeWebApp final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 web_app_launch_id_;

  closeWebApp();

  explicit closeWebApp(int64 web_app_launch_id_);

  static const std::int32_t ID = 1755391174;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class commitPendingPaidMessageReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  commitPendingPaidMessageReactions();

  commitPendingPaidMessageReactions(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -171354618;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class session;

class confirmQrCodeAuthentication final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  confirmQrCodeAuthentication();

  explicit confirmQrCodeAuthentication(string const &link_);

  static const std::int32_t ID = -376199379;

  using ReturnType = object_ptr<session>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class confirmSession final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 session_id_;

  confirmSession();

  explicit confirmSession(int64 session_id_);

  static const std::int32_t ID = -674647009;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AffiliateType;

class connectedAffiliateProgram;

class connectAffiliateProgram final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<AffiliateType> affiliate_;
  int53 bot_user_id_;

  connectAffiliateProgram();

  connectAffiliateProgram(object_ptr<AffiliateType> &&affiliate_, int53 bot_user_id_);

  static const std::int32_t ID = 1661392684;

  using ReturnType = object_ptr<connectedAffiliateProgram>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chat;

class createBasicGroupChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 basic_group_id_;
  bool force_;

  createBasicGroupChat();

  createBasicGroupChat(int53 basic_group_id_, bool force_);

  static const std::int32_t ID = 1972024548;

  using ReturnType = object_ptr<chat>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessChatLink;

class inputBusinessChatLink;

class createBusinessChatLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<inputBusinessChatLink> link_info_;

  createBusinessChatLink();

  explicit createBusinessChatLink(object_ptr<inputBusinessChatLink> &&link_info_);

  static const std::int32_t ID = -1861018304;

  using ReturnType = object_ptr<businessChatLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class callId;

class callProtocol;

class createCall final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  object_ptr<callProtocol> protocol_;
  bool is_video_;

  createCall();

  createCall(int53 user_id_, object_ptr<callProtocol> &&protocol_, bool is_video_);

  static const std::int32_t ID = -1104663024;

  using ReturnType = object_ptr<callId>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolder;

class chatFolderInfo;

class createChatFolder final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatFolder> folder_;

  createChatFolder();

  explicit createChatFolder(object_ptr<chatFolder> &&folder_);

  static const std::int32_t ID = 1015399680;

  using ReturnType = object_ptr<chatFolderInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderInviteLink;

class createChatFolderInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;
  string name_;
  array<int53> chat_ids_;

  createChatFolderInviteLink();

  createChatFolderInviteLink(int32 chat_folder_id_, string const &name_, array<int53> &&chat_ids_);

  static const std::int32_t ID = -2037911099;

  using ReturnType = object_ptr<chatFolderInviteLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLink;

class createChatInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string name_;
  int32 expiration_date_;
  int32 member_limit_;
  bool creates_join_request_;

  createChatInviteLink();

  createChatInviteLink(int53 chat_id_, string const &name_, int32 expiration_date_, int32 member_limit_, bool creates_join_request_);

  static const std::int32_t ID = 287744833;

  using ReturnType = object_ptr<chatInviteLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLink;

class starSubscriptionPricing;

class createChatSubscriptionInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string name_;
  object_ptr<starSubscriptionPricing> subscription_pricing_;

  createChatSubscriptionInviteLink();

  createChatSubscriptionInviteLink(int53 chat_id_, string const &name_, object_ptr<starSubscriptionPricing> &&subscription_pricing_);

  static const std::int32_t ID = 2255717;

  using ReturnType = object_ptr<chatInviteLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class forumTopicIcon;

class forumTopicInfo;

class createForumTopic final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string name_;
  object_ptr<forumTopicIcon> icon_;

  createForumTopic();

  createForumTopic(int53 chat_id_, string const &name_, object_ptr<forumTopicIcon> &&icon_);

  static const std::int32_t ID = -1040570140;

  using ReturnType = object_ptr<forumTopicInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallInfo;

class groupCallJoinParameters;

class createGroupCall final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<groupCallJoinParameters> join_parameters_;

  createGroupCall();

  explicit createGroupCall(object_ptr<groupCallJoinParameters> &&join_parameters_);

  static const std::int32_t ID = 1930068672;

  using ReturnType = object_ptr<groupCallInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class httpUrl;

class createInvoiceLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;
  object_ptr<InputMessageContent> invoice_;

  createInvoiceLink();

  createInvoiceLink(string const &business_connection_id_, object_ptr<InputMessageContent> &&invoice_);

  static const std::int32_t ID = -814692249;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class createdBasicGroupChat;

class createNewBasicGroupChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int53> user_ids_;
  string title_;
  int32 message_auto_delete_time_;

  createNewBasicGroupChat();

  createNewBasicGroupChat(array<int53> &&user_ids_, string const &title_, int32 message_auto_delete_time_);

  static const std::int32_t ID = 1806454709;

  using ReturnType = object_ptr<createdBasicGroupChat>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chat;

class createNewSecretChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  createNewSecretChat();

  explicit createNewSecretChat(int53 user_id_);

  static const std::int32_t ID = -620682651;

  using ReturnType = object_ptr<chat>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerType;

class inputSticker;

class stickerSet;

class createNewStickerSet final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string title_;
  string name_;
  object_ptr<StickerType> sticker_type_;
  bool needs_repainting_;
  array<object_ptr<inputSticker>> stickers_;
  string source_;

  createNewStickerSet();

  createNewStickerSet(int53 user_id_, string const &title_, string const &name_, object_ptr<StickerType> &&sticker_type_, bool needs_repainting_, array<object_ptr<inputSticker>> &&stickers_, string const &source_);

  static const std::int32_t ID = -481065727;

  using ReturnType = object_ptr<stickerSet>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chat;

class chatLocation;

class createNewSupergroupChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;
  bool is_forum_;
  bool is_channel_;
  string description_;
  object_ptr<chatLocation> location_;
  int32 message_auto_delete_time_;
  bool for_import_;

  createNewSupergroupChat();

  createNewSupergroupChat(string const &title_, bool is_forum_, bool is_channel_, string const &description_, object_ptr<chatLocation> &&location_, int32 message_auto_delete_time_, bool for_import_);

  static const std::int32_t ID = 804058822;

  using ReturnType = object_ptr<chat>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chat;

class createPrivateChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  bool force_;

  createPrivateChat();

  createPrivateChat(int53 user_id_, bool force_);

  static const std::int32_t ID = -947758327;

  using ReturnType = object_ptr<chat>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chat;

class createSecretChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 secret_chat_id_;

  createSecretChat();

  explicit createSecretChat(int32 secret_chat_id_);

  static const std::int32_t ID = 1930285615;

  using ReturnType = object_ptr<chat>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chat;

class createSupergroupChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;
  bool force_;

  createSupergroupChat();

  createSupergroupChat(int53 supergroup_id_, bool force_);

  static const std::int32_t ID = 1187475691;

  using ReturnType = object_ptr<chat>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class temporaryPasswordState;

class createTemporaryPassword final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string password_;
  int32 valid_for_;

  createTemporaryPassword();

  createTemporaryPassword(string const &password_, int32 valid_for_);

  static const std::int32_t ID = -1626509434;

  using ReturnType = object_ptr<temporaryPasswordState>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCallId;

class createVideoChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string title_;
  int32 start_date_;
  bool is_rtmp_stream_;

  createVideoChat();

  createVideoChat(int53 chat_id_, string const &title_, int32 start_date_, bool is_rtmp_stream_);

  static const std::int32_t ID = 2124715405;

  using ReturnType = object_ptr<groupCallId>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class declineGroupCallInvitation final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  declineGroupCallInvitation();

  declineGroupCallInvitation(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = 1843919377;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GroupCallDataChannel;

class MessageSender;

class data;

class decryptGroupCallData final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  object_ptr<MessageSender> participant_id_;
  object_ptr<GroupCallDataChannel> data_channel_;
  bytes data_;

  decryptGroupCallData();

  decryptGroupCallData(int32 group_call_id_, object_ptr<MessageSender> &&participant_id_, object_ptr<GroupCallDataChannel> &&data_channel_, bytes const &data_);

  static const std::int32_t ID = 1781743076;

  using ReturnType = object_ptr<data>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteAccount final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string reason_;
  string password_;

  deleteAccount();

  deleteAccount(string const &reason_, string const &password_);

  static const std::int32_t ID = 1395816134;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteAllCallMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool revoke_;

  deleteAllCallMessages();

  explicit deleteAllCallMessages(bool revoke_);

  static const std::int32_t ID = -1466445325;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteAllRevokedChatInviteLinks final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 creator_user_id_;

  deleteAllRevokedChatInviteLinks();

  deleteAllRevokedChatInviteLinks(int53 chat_id_, int53 creator_user_id_);

  static const std::int32_t ID = 1112020698;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteBotMediaPreviews final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string language_code_;
  array<int32> file_ids_;

  deleteBotMediaPreviews();

  deleteBotMediaPreviews(int53 bot_user_id_, string const &language_code_, array<int32> &&file_ids_);

  static const std::int32_t ID = -1397512722;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteBusinessChatLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  deleteBusinessChatLink();

  explicit deleteBusinessChatLink(string const &link_);

  static const std::int32_t ID = -1101895865;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteBusinessConnectedBot final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;

  deleteBusinessConnectedBot();

  explicit deleteBusinessConnectedBot(int53 bot_user_id_);

  static const std::int32_t ID = -1633976747;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteBusinessMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;
  array<int53> message_ids_;

  deleteBusinessMessages();

  deleteBusinessMessages(string const &business_connection_id_, array<int53> &&message_ids_);

  static const std::int32_t ID = 1425721828;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteBusinessStory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;
  int32 story_id_;

  deleteBusinessStory();

  deleteBusinessStory(string const &business_connection_id_, int32 story_id_);

  static const std::int32_t ID = 1024585042;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  deleteChat();

  explicit deleteChat(int53 chat_id_);

  static const std::int32_t ID = -171253666;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteChatBackground final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool restore_previous_;

  deleteChatBackground();

  deleteChatBackground(int53 chat_id_, bool restore_previous_);

  static const std::int32_t ID = 320267896;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteChatFolder final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;
  array<int53> leave_chat_ids_;

  deleteChatFolder();

  deleteChatFolder(int32 chat_folder_id_, array<int53> &&leave_chat_ids_);

  static const std::int32_t ID = -1956364551;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteChatFolderInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;
  string invite_link_;

  deleteChatFolderInviteLink();

  deleteChatFolderInviteLink(int32 chat_folder_id_, string const &invite_link_);

  static const std::int32_t ID = -930057858;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteChatHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool remove_from_chat_list_;
  bool revoke_;

  deleteChatHistory();

  deleteChatHistory(int53 chat_id_, bool remove_from_chat_list_, bool revoke_);

  static const std::int32_t ID = -1472081761;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteChatMessagesByDate final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 min_date_;
  int32 max_date_;
  bool revoke_;

  deleteChatMessagesByDate();

  deleteChatMessagesByDate(int53 chat_id_, int32 min_date_, int32 max_date_, bool revoke_);

  static const std::int32_t ID = -1639653185;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class ok;

class deleteChatMessagesBySender final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<MessageSender> sender_id_;

  deleteChatMessagesBySender();

  deleteChatMessagesBySender(int53 chat_id_, object_ptr<MessageSender> &&sender_id_);

  static const std::int32_t ID = -1164235161;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteChatReplyMarkup final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  deleteChatReplyMarkup();

  deleteChatReplyMarkup(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = 100637531;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotCommandScope;

class ok;

class deleteCommands final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BotCommandScope> scope_;
  string language_code_;

  deleteCommands();

  deleteCommands(object_ptr<BotCommandScope> &&scope_, string const &language_code_);

  static const std::int32_t ID = 1002732586;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteDefaultBackground final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool for_dark_theme_;

  deleteDefaultBackground();

  explicit deleteDefaultBackground(bool for_dark_theme_);

  static const std::int32_t ID = -1297814210;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteFile final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;

  deleteFile();

  explicit deleteFile(int32 file_id_);

  static const std::int32_t ID = 1807653676;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteForumTopic final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_thread_id_;

  deleteForumTopic();

  deleteForumTopic(int53 chat_id_, int53 message_thread_id_);

  static const std::int32_t ID = 1864916152;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteLanguagePack final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string language_pack_id_;

  deleteLanguagePack();

  explicit deleteLanguagePack(string const &language_pack_id_);

  static const std::int32_t ID = -2108761026;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  array<int53> message_ids_;
  bool revoke_;

  deleteMessages();

  deleteMessages(int53 chat_id_, array<int53> &&message_ids_, bool revoke_);

  static const std::int32_t ID = 1130090173;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PassportElementType;

class ok;

class deletePassportElement final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PassportElementType> type_;

  deletePassportElement();

  explicit deletePassportElement(object_ptr<PassportElementType> &&type_);

  static const std::int32_t ID = -1719555468;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteProfilePhoto final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 profile_photo_id_;

  deleteProfilePhoto();

  explicit deleteProfilePhoto(int64 profile_photo_id_);

  static const std::int32_t ID = 1319794625;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteQuickReplyShortcut final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;

  deleteQuickReplyShortcut();

  explicit deleteQuickReplyShortcut(int32 shortcut_id_);

  static const std::int32_t ID = -246911978;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteQuickReplyShortcutMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  array<int53> message_ids_;

  deleteQuickReplyShortcutMessages();

  deleteQuickReplyShortcutMessages(int32 shortcut_id_, array<int53> &&message_ids_);

  static const std::int32_t ID = -40522947;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteRevokedChatInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string invite_link_;

  deleteRevokedChatInviteLink();

  deleteRevokedChatInviteLink(int53 chat_id_, string const &invite_link_);

  static const std::int32_t ID = -1859711873;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteSavedCredentials final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  deleteSavedCredentials();

  static const std::int32_t ID = 826300114;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteSavedMessagesTopicHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 saved_messages_topic_id_;

  deleteSavedMessagesTopicHistory();

  explicit deleteSavedMessagesTopicHistory(int53 saved_messages_topic_id_);

  static const std::int32_t ID = 1776237930;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteSavedMessagesTopicMessagesByDate final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 saved_messages_topic_id_;
  int32 min_date_;
  int32 max_date_;

  deleteSavedMessagesTopicMessagesByDate();

  deleteSavedMessagesTopicMessagesByDate(int53 saved_messages_topic_id_, int32 min_date_, int32 max_date_);

  static const std::int32_t ID = 1444389;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteSavedOrderInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  deleteSavedOrderInfo();

  static const std::int32_t ID = 1629058164;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteStickerSet final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  deleteStickerSet();

  explicit deleteStickerSet(string const &name_);

  static const std::int32_t ID = 1577745325;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class deleteStory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;

  deleteStory();

  deleteStory(int53 story_poster_chat_id_, int32 story_id_);

  static const std::int32_t ID = -2020144472;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class destroy final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  destroy();

  static const std::int32_t ID = 685331274;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class disableAllSupergroupUsernames final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;

  disableAllSupergroupUsernames();

  explicit disableAllSupergroupUsernames(int53 supergroup_id_);

  static const std::int32_t ID = 843511216;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class disableProxy final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  disableProxy();

  static const std::int32_t ID = -2100095102;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class discardCall final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 call_id_;
  bool is_disconnected_;
  string invite_link_;
  int32 duration_;
  bool is_video_;
  int64 connection_id_;

  discardCall();

  discardCall(int32 call_id_, bool is_disconnected_, string const &invite_link_, int32 duration_, bool is_video_, int64 connection_id_);

  static const std::int32_t ID = -1545983346;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AffiliateType;

class connectedAffiliateProgram;

class disconnectAffiliateProgram final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<AffiliateType> affiliate_;
  string url_;

  disconnectAffiliateProgram();

  disconnectAffiliateProgram(object_ptr<AffiliateType> &&affiliate_, string const &url_);

  static const std::int32_t ID = -105831172;

  using ReturnType = object_ptr<connectedAffiliateProgram>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class disconnectAllWebsites final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  disconnectAllWebsites();

  static const std::int32_t ID = -1082985981;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class disconnectWebsite final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 website_id_;

  disconnectWebsite();

  explicit disconnectWebsite(int64 website_id_);

  static const std::int32_t ID = -778767395;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class downloadFile final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;
  int32 priority_;
  int53 offset_;
  int53 limit_;
  bool synchronous_;

  downloadFile();

  downloadFile(int32 file_id_, int32 priority_, int53 offset_, int53 limit_, bool synchronous_);

  static const std::int32_t ID = 1059402292;

  using ReturnType = object_ptr<file>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputStoryContent;

class botMediaPreview;

class editBotMediaPreview final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string language_code_;
  int32 file_id_;
  object_ptr<InputStoryContent> content_;

  editBotMediaPreview();

  editBotMediaPreview(int53 bot_user_id_, string const &language_code_, int32 file_id_, object_ptr<InputStoryContent> &&content_);

  static const std::int32_t ID = -2037031582;

  using ReturnType = object_ptr<botMediaPreview>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessChatLink;

class inputBusinessChatLink;

class editBusinessChatLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;
  object_ptr<inputBusinessChatLink> link_info_;

  editBusinessChatLink();

  editBusinessChatLink(string const &link_, object_ptr<inputBusinessChatLink> &&link_info_);

  static const std::int32_t ID = 1594947110;

  using ReturnType = object_ptr<businessChatLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReplyMarkup;

class businessMessage;

class formattedText;

class editBusinessMessageCaption final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;

  editBusinessMessageCaption();

  editBusinessMessageCaption(string const &business_connection_id_, int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_);

  static const std::int32_t ID = -1071562045;

  using ReturnType = object_ptr<businessMessage>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReplyMarkup;

class businessMessage;

class location;

class editBusinessMessageLiveLocation final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<location> location_;
  int32 live_period_;
  int32 heading_;
  int32 proximity_alert_radius_;

  editBusinessMessageLiveLocation();

  editBusinessMessageLiveLocation(string const &business_connection_id_, int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<location> &&location_, int32 live_period_, int32 heading_, int32 proximity_alert_radius_);

  static const std::int32_t ID = 494972447;

  using ReturnType = object_ptr<businessMessage>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class ReplyMarkup;

class businessMessage;

class editBusinessMessageMedia final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  editBusinessMessageMedia();

  editBusinessMessageMedia(string const &business_connection_id_, int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = -60733576;

  using ReturnType = object_ptr<businessMessage>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReplyMarkup;

class businessMessage;

class editBusinessMessageReplyMarkup final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;

  editBusinessMessageReplyMarkup();

  editBusinessMessageReplyMarkup(string const &business_connection_id_, int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = 701787159;

  using ReturnType = object_ptr<businessMessage>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class ReplyMarkup;

class businessMessage;

class editBusinessMessageText final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  editBusinessMessageText();

  editBusinessMessageText(string const &business_connection_id_, int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = -1149169252;

  using ReturnType = object_ptr<businessMessage>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputStoryContent;

class StoryPrivacySettings;

class formattedText;

class inputStoryAreas;

class story;

class editBusinessStory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;
  object_ptr<InputStoryContent> content_;
  object_ptr<inputStoryAreas> areas_;
  object_ptr<formattedText> caption_;
  object_ptr<StoryPrivacySettings> privacy_settings_;

  editBusinessStory();

  editBusinessStory(int53 story_poster_chat_id_, int32 story_id_, object_ptr<InputStoryContent> &&content_, object_ptr<inputStoryAreas> &&areas_, object_ptr<formattedText> &&caption_, object_ptr<StoryPrivacySettings> &&privacy_settings_);

  static const std::int32_t ID = 472538940;

  using ReturnType = object_ptr<story>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolder;

class chatFolderInfo;

class editChatFolder final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;
  object_ptr<chatFolder> folder_;

  editChatFolder();

  editChatFolder(int32 chat_folder_id_, object_ptr<chatFolder> &&folder_);

  static const std::int32_t ID = 53672754;

  using ReturnType = object_ptr<chatFolderInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderInviteLink;

class editChatFolderInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;
  string invite_link_;
  string name_;
  array<int53> chat_ids_;

  editChatFolderInviteLink();

  editChatFolderInviteLink(int32 chat_folder_id_, string const &invite_link_, string const &name_, array<int53> &&chat_ids_);

  static const std::int32_t ID = -2141872095;

  using ReturnType = object_ptr<chatFolderInviteLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLink;

class editChatInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string invite_link_;
  string name_;
  int32 expiration_date_;
  int32 member_limit_;
  bool creates_join_request_;

  editChatInviteLink();

  editChatInviteLink(int53 chat_id_, string const &invite_link_, string const &name_, int32 expiration_date_, int32 member_limit_, bool creates_join_request_);

  static const std::int32_t ID = 1320303996;

  using ReturnType = object_ptr<chatInviteLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLink;

class editChatSubscriptionInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string invite_link_;
  string name_;

  editChatSubscriptionInviteLink();

  editChatSubscriptionInviteLink(int53 chat_id_, string const &invite_link_, string const &name_);

  static const std::int32_t ID = -951826989;

  using ReturnType = object_ptr<chatInviteLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class languagePackInfo;

class ok;

class editCustomLanguagePackInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<languagePackInfo> info_;

  editCustomLanguagePackInfo();

  explicit editCustomLanguagePackInfo(object_ptr<languagePackInfo> &&info_);

  static const std::int32_t ID = 1320751257;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class editForumTopic final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_thread_id_;
  string name_;
  bool edit_icon_custom_emoji_;
  int64 icon_custom_emoji_id_;

  editForumTopic();

  editForumTopic(int53 chat_id_, int53 message_thread_id_, string const &name_, bool edit_icon_custom_emoji_, int64 icon_custom_emoji_id_);

  static const std::int32_t ID = -1485402016;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReplyMarkup;

class formattedText;

class ok;

class editInlineMessageCaption final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string inline_message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;

  editInlineMessageCaption();

  editInlineMessageCaption(string const &inline_message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_);

  static const std::int32_t ID = 1409762552;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReplyMarkup;

class location;

class ok;

class editInlineMessageLiveLocation final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string inline_message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<location> location_;
  int32 live_period_;
  int32 heading_;
  int32 proximity_alert_radius_;

  editInlineMessageLiveLocation();

  editInlineMessageLiveLocation(string const &inline_message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<location> &&location_, int32 live_period_, int32 heading_, int32 proximity_alert_radius_);

  static const std::int32_t ID = 2134352044;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class ReplyMarkup;

class ok;

class editInlineMessageMedia final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string inline_message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  editInlineMessageMedia();

  editInlineMessageMedia(string const &inline_message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 23553921;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReplyMarkup;

class ok;

class editInlineMessageReplyMarkup final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string inline_message_id_;
  object_ptr<ReplyMarkup> reply_markup_;

  editInlineMessageReplyMarkup();

  editInlineMessageReplyMarkup(string const &inline_message_id_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = -67565858;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class ReplyMarkup;

class ok;

class editInlineMessageText final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string inline_message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  editInlineMessageText();

  editInlineMessageText(string const &inline_message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = -855457307;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReplyMarkup;

class formattedText;

class message;

class editMessageCaption final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<formattedText> caption_;
  bool show_caption_above_media_;

  editMessageCaption();

  editMessageCaption(int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<formattedText> &&caption_, bool show_caption_above_media_);

  static const std::int32_t ID = -2020117951;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReplyMarkup;

class location;

class message;

class editMessageLiveLocation final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<location> location_;
  int32 live_period_;
  int32 heading_;
  int32 proximity_alert_radius_;

  editMessageLiveLocation();

  editMessageLiveLocation(int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<location> &&location_, int32 live_period_, int32 heading_, int32 proximity_alert_radius_);

  static const std::int32_t ID = -1890511980;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class ReplyMarkup;

class message;

class editMessageMedia final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  editMessageMedia();

  editMessageMedia(int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = -1152678125;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReplyMarkup;

class message;

class editMessageReplyMarkup final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;

  editMessageReplyMarkup();

  editMessageReplyMarkup(int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_);

  static const std::int32_t ID = 332127881;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSchedulingState;

class ok;

class editMessageSchedulingState final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<MessageSchedulingState> scheduling_state_;

  editMessageSchedulingState();

  editMessageSchedulingState(int53 chat_id_, int53 message_id_, object_ptr<MessageSchedulingState> &&scheduling_state_);

  static const std::int32_t ID = -1372976192;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class ReplyMarkup;

class message;

class editMessageText final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReplyMarkup> reply_markup_;
  object_ptr<InputMessageContent> input_message_content_;

  editMessageText();

  editMessageText(int53 chat_id_, int53 message_id_, object_ptr<ReplyMarkup> &&reply_markup_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 196272567;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ProxyType;

class proxy;

class editProxy final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 proxy_id_;
  string server_;
  int32 port_;
  bool enable_;
  object_ptr<ProxyType> type_;

  editProxy();

  editProxy(int32 proxy_id_, string const &server_, int32 port_, bool enable_, object_ptr<ProxyType> &&type_);

  static const std::int32_t ID = -1605883821;

  using ReturnType = object_ptr<proxy>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputMessageContent;

class ok;

class editQuickReplyMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 shortcut_id_;
  int53 message_id_;
  object_ptr<InputMessageContent> input_message_content_;

  editQuickReplyMessage();

  editQuickReplyMessage(int32 shortcut_id_, int53 message_id_, object_ptr<InputMessageContent> &&input_message_content_);

  static const std::int32_t ID = 80517006;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class editStarSubscription final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string subscription_id_;
  bool is_canceled_;

  editStarSubscription();

  editStarSubscription(string const &subscription_id_, bool is_canceled_);

  static const std::int32_t ID = 2048538904;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputStoryContent;

class formattedText;

class inputStoryAreas;

class ok;

class editStory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;
  object_ptr<InputStoryContent> content_;
  object_ptr<inputStoryAreas> areas_;
  object_ptr<formattedText> caption_;

  editStory();

  editStory(int53 story_poster_chat_id_, int32 story_id_, object_ptr<InputStoryContent> &&content_, object_ptr<inputStoryAreas> &&areas_, object_ptr<formattedText> &&caption_);

  static const std::int32_t ID = 355296788;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class editStoryCover final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;
  double cover_frame_timestamp_;

  editStoryCover();

  editStoryCover(int53 story_poster_chat_id_, int32 story_id_, double cover_frame_timestamp_);

  static const std::int32_t ID = -1035823266;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class editUserStarSubscription final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  string telegram_payment_charge_id_;
  bool is_canceled_;

  editUserStarSubscription();

  editUserStarSubscription(int53 user_id_, string const &telegram_payment_charge_id_, bool is_canceled_);

  static const std::int32_t ID = 1370582665;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class enableProxy final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 proxy_id_;

  enableProxy();

  explicit enableProxy(int32 proxy_id_);

  static const std::int32_t ID = 1494450838;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GroupCallDataChannel;

class data;

class encryptGroupCallData final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;
  object_ptr<GroupCallDataChannel> data_channel_;
  bytes data_;
  int32 unencrypted_prefix_size_;

  encryptGroupCallData();

  encryptGroupCallData(int32 group_call_id_, object_ptr<GroupCallDataChannel> &&data_channel_, bytes const &data_, int32 unencrypted_prefix_size_);

  static const std::int32_t ID = -377997690;

  using ReturnType = object_ptr<data>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class endGroupCall final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;

  endGroupCall();

  explicit endGroupCall(int32 group_call_id_);

  static const std::int32_t ID = 573131959;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class endGroupCallRecording final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;

  endGroupCallRecording();

  explicit endGroupCallRecording(int32 group_call_id_);

  static const std::int32_t ID = -75799927;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ok;

class endGroupCallScreenSharing final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;

  endGroupCallScreenSharing();

  explicit endGroupCallScreenSharing(int32 group_call_id_);

  static const std::int32_t ID = -2047599540;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class error;

class ok;

class finishFileGeneration final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 generation_id_;
  object_ptr<error> error_;

  finishFileGeneration();

  finishFileGeneration(int64 generation_id_, object_ptr<error> &&error_);

  static const std::int32_t ID = -1055060835;

  using ReturnType = object_ptr<ok>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSendOptions;

class messages;

class forwardMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_thread_id_;
  int53 from_chat_id_;
  array<int53> message_ids_;
  object_ptr<messageSendOptions> options_;
  bool send_copy_;
  bool remove_caption_;

  forwardMessages();

  forwardMessages(int53 chat_id_, int53 message_thread_id_, int53 from_chat_id_, array<int53> &&message_ids_, object_ptr<messageSendOptions> &&options_, bool send_copy_, bool remove_caption_);

  static const std::int32_t ID = 966156347;

  using ReturnType = object_ptr<messages>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class accountTtl;

class getAccountTtl final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getAccountTtl();

  static const std::int32_t ID = -443905161;

  using ReturnType = object_ptr<accountTtl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sessions;

class getActiveSessions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getActiveSessions();

  static const std::int32_t ID = 1119710526;

  using ReturnType = object_ptr<sessions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElements;

class getAllPassportElements final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string password_;

  getAllPassportElements();

  explicit getAllPassportElements(string const &password_);

  static const std::int32_t ID = -2038945045;

  using ReturnType = object_ptr<passportElements>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerType;

class emojis;

class getAllStickerEmojis final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StickerType> sticker_type_;
  string query_;
  int53 chat_id_;
  bool return_only_main_emoji_;

  getAllStickerEmojis();

  getAllStickerEmojis(object_ptr<StickerType> &&sticker_type_, string const &query_, int53 chat_id_, bool return_only_main_emoji_);

  static const std::int32_t ID = 296562224;

  using ReturnType = object_ptr<emojis>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class animatedEmoji;

class getAnimatedEmoji final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoji_;

  getAnimatedEmoji();

  explicit getAnimatedEmoji(string const &emoji_);

  static const std::int32_t ID = 1065635702;

  using ReturnType = object_ptr<animatedEmoji>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class JsonValue;

class getApplicationConfig final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getApplicationConfig();

  static const std::int32_t ID = -1823144318;

  using ReturnType = object_ptr<JsonValue>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class httpUrl;

class getApplicationDownloadLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getApplicationDownloadLink();

  static const std::int32_t ID = 112013252;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class archiveChatListSettings;

class getArchiveChatListSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getArchiveChatListSettings();

  static const std::int32_t ID = -2087874976;

  using ReturnType = object_ptr<archiveChatListSettings>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerType;

class stickerSets;

class getArchivedStickerSets final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StickerType> sticker_type_;
  int64 offset_sticker_set_id_;
  int32 limit_;

  getArchivedStickerSets();

  getArchivedStickerSets(object_ptr<StickerType> &&sticker_type_, int64 offset_sticker_set_id_, int32 limit_);

  static const std::int32_t ID = 1001931341;

  using ReturnType = object_ptr<stickerSets>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerSets;

class getAttachedStickerSets final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;

  getAttachedStickerSets();

  explicit getAttachedStickerSets(int32 file_id_);

  static const std::int32_t ID = 1302172429;

  using ReturnType = object_ptr<stickerSets>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class attachmentMenuBot;

class getAttachmentMenuBot final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;

  getAttachmentMenuBot();

  explicit getAttachmentMenuBot(int53 bot_user_id_);

  static const std::int32_t ID = 1034248699;

  using ReturnType = object_ptr<attachmentMenuBot>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AuthorizationState;

class getAuthorizationState final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getAuthorizationState();

  static const std::int32_t ID = 1949154877;

  using ReturnType = object_ptr<AuthorizationState>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autoDownloadSettingsPresets;

class getAutoDownloadSettingsPresets final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getAutoDownloadSettingsPresets();

  static const std::int32_t ID = -1721088201;

  using ReturnType = object_ptr<autoDownloadSettingsPresets>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class autosaveSettings;

class getAutosaveSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getAutosaveSettings();

  static const std::int32_t ID = 2136207914;

  using ReturnType = object_ptr<autosaveSettings>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostSlots;

class getAvailableChatBoostSlots final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getAvailableChatBoostSlots();

  static const std::int32_t ID = 1929898965;

  using ReturnType = object_ptr<chatBoostSlots>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class availableGifts;

class getAvailableGifts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getAvailableGifts();

  static const std::int32_t ID = -4559695;

  using ReturnType = object_ptr<availableGifts>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BackgroundType;

class httpUrl;

class getBackgroundUrl final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;
  object_ptr<BackgroundType> type_;

  getBackgroundUrl();

  getBackgroundUrl(string const &name_, object_ptr<BackgroundType> &&type_);

  static const std::int32_t ID = 733769682;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class bankCardInfo;

class getBankCardInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string bank_card_number_;

  getBankCardInfo();

  explicit getBankCardInfo(string const &bank_card_number_);

  static const std::int32_t ID = -1310515792;

  using ReturnType = object_ptr<bankCardInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class basicGroup;

class getBasicGroup final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 basic_group_id_;

  getBasicGroup();

  explicit getBasicGroup(int53 basic_group_id_);

  static const std::int32_t ID = -1635174828;

  using ReturnType = object_ptr<basicGroup>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class basicGroupFullInfo;

class getBasicGroupFullInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 basic_group_id_;

  getBasicGroupFullInfo();

  explicit getBasicGroupFullInfo(int53 basic_group_id_);

  static const std::int32_t ID = -1822039253;

  using ReturnType = object_ptr<basicGroupFullInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BlockList;

class messageSenders;

class getBlockedMessageSenders final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BlockList> block_list_;
  int32 offset_;
  int32 limit_;

  getBlockedMessageSenders();

  getBlockedMessageSenders(object_ptr<BlockList> &&block_list_, int32 offset_, int32 limit_);

  static const std::int32_t ID = -1931137258;

  using ReturnType = object_ptr<messageSenders>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getBotInfoDescription final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string language_code_;

  getBotInfoDescription();

  getBotInfoDescription(int53 bot_user_id_, string const &language_code_);

  static const std::int32_t ID = -762841035;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getBotInfoShortDescription final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string language_code_;

  getBotInfoShortDescription();

  getBotInfoShortDescription(int53 bot_user_id_, string const &language_code_);

  static const std::int32_t ID = 1243358740;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botMediaPreviewInfo;

class getBotMediaPreviewInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string language_code_;

  getBotMediaPreviewInfo();

  getBotMediaPreviewInfo(int53 bot_user_id_, string const &language_code_);

  static const std::int32_t ID = 1358299446;

  using ReturnType = object_ptr<botMediaPreviewInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botMediaPreviews;

class getBotMediaPreviews final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;

  getBotMediaPreviews();

  explicit getBotMediaPreviews(int53 bot_user_id_);

  static const std::int32_t ID = 577131608;

  using ReturnType = object_ptr<botMediaPreviews>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getBotName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string language_code_;

  getBotName();

  getBotName(int53 bot_user_id_, string const &language_code_);

  static const std::int32_t ID = -1707118036;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class count;

class getBotSimilarBotCount final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  bool return_local_;

  getBotSimilarBotCount();

  getBotSimilarBotCount(int53 bot_user_id_, bool return_local_);

  static const std::int32_t ID = -1271545369;

  using ReturnType = object_ptr<count>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class users;

class getBotSimilarBots final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;

  getBotSimilarBots();

  explicit getBotSimilarBots(int53 bot_user_id_);

  static const std::int32_t ID = -825139275;

  using ReturnType = object_ptr<users>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starAmount;

class getBusinessAccountStarAmount final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;

  getBusinessAccountStarAmount();

  explicit getBusinessAccountStarAmount(string const &business_connection_id_);

  static const std::int32_t ID = -1817136693;

  using ReturnType = object_ptr<starAmount>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessChatLinkInfo;

class getBusinessChatLinkInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_name_;

  getBusinessChatLinkInfo();

  explicit getBusinessChatLinkInfo(string const &link_name_);

  static const std::int32_t ID = 797670986;

  using ReturnType = object_ptr<businessChatLinkInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessChatLinks;

class getBusinessChatLinks final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getBusinessChatLinks();

  static const std::int32_t ID = 710287703;

  using ReturnType = object_ptr<businessChatLinks>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessConnectedBot;

class getBusinessConnectedBot final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getBusinessConnectedBot();

  static const std::int32_t ID = 911058883;

  using ReturnType = object_ptr<businessConnectedBot>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class businessConnection;

class getBusinessConnection final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string connection_id_;

  getBusinessConnection();

  explicit getBusinessConnection(string const &connection_id_);

  static const std::int32_t ID = -2114706400;

  using ReturnType = object_ptr<businessConnection>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BusinessFeature;

class businessFeatures;

class getBusinessFeatures final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BusinessFeature> source_;

  getBusinessFeatures();

  explicit getBusinessFeatures(object_ptr<BusinessFeature> &&source_);

  static const std::int32_t ID = -997171199;

  using ReturnType = object_ptr<businessFeatures>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CallbackQueryPayload;

class callbackQueryAnswer;

class getCallbackQueryAnswer final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<CallbackQueryPayload> payload_;

  getCallbackQueryAnswer();

  getCallbackQueryAnswer(int53 chat_id_, int53 message_id_, object_ptr<CallbackQueryPayload> &&payload_);

  static const std::int32_t ID = 116357727;

  using ReturnType = object_ptr<callbackQueryAnswer>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class getCallbackQueryMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int64 callback_query_id_;

  getCallbackQueryMessage();

  getCallbackQueryMessage(int53 chat_id_, int53 message_id_, int64 callback_query_id_);

  static const std::int32_t ID = -1121939086;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chat;

class getChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChat();

  explicit getChat(int53 chat_id_);

  static const std::int32_t ID = 1866601536;

  using ReturnType = object_ptr<chat>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatActiveStories;

class getChatActiveStories final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatActiveStories();

  explicit getChatActiveStories(int53 chat_id_);

  static const std::int32_t ID = 776993781;

  using ReturnType = object_ptr<chatActiveStories>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatAdministrators;

class getChatAdministrators final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatAdministrators();

  explicit getChatAdministrators(int53 chat_id_);

  static const std::int32_t ID = 1544468155;

  using ReturnType = object_ptr<chatAdministrators>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stories;

class getChatArchivedStories final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 from_story_id_;
  int32 limit_;

  getChatArchivedStories();

  getChatArchivedStories(int53 chat_id_, int32 from_story_id_, int32 limit_);

  static const std::int32_t ID = -1356950392;

  using ReturnType = object_ptr<stories>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatMessageSenders;

class getChatAvailableMessageSenders final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatAvailableMessageSenders();

  explicit getChatAvailableMessageSenders(int53 chat_id_);

  static const std::int32_t ID = 1158670635;

  using ReturnType = object_ptr<chatMessageSenders>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSenders;

class getChatAvailablePaidMessageReactionSenders final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatAvailablePaidMessageReactionSenders();

  explicit getChatAvailablePaidMessageReactionSenders(int53 chat_id_);

  static const std::int32_t ID = -1244619639;

  using ReturnType = object_ptr<messageSenders>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostFeatures;

class getChatBoostFeatures final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_channel_;

  getChatBoostFeatures();

  explicit getChatBoostFeatures(bool is_channel_);

  static const std::int32_t ID = -389994336;

  using ReturnType = object_ptr<chatBoostFeatures>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostLevelFeatures;

class getChatBoostLevelFeatures final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_channel_;
  int32 level_;

  getChatBoostLevelFeatures();

  getChatBoostLevelFeatures(bool is_channel_, int32 level_);

  static const std::int32_t ID = 1172717195;

  using ReturnType = object_ptr<chatBoostLevelFeatures>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostLink;

class getChatBoostLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatBoostLink();

  explicit getChatBoostLink(int53 chat_id_);

  static const std::int32_t ID = 1458662533;

  using ReturnType = object_ptr<chatBoostLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostLinkInfo;

class getChatBoostLinkInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  getChatBoostLinkInfo();

  explicit getChatBoostLinkInfo(string const &url_);

  static const std::int32_t ID = 654068572;

  using ReturnType = object_ptr<chatBoostLinkInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatBoostStatus;

class getChatBoostStatus final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatBoostStatus();

  explicit getChatBoostStatus(int53 chat_id_);

  static const std::int32_t ID = -810775857;

  using ReturnType = object_ptr<chatBoostStatus>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class foundChatBoosts;

class getChatBoosts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool only_gift_codes_;
  string offset_;
  int32 limit_;

  getChatBoosts();

  getChatBoosts(int53 chat_id_, bool only_gift_codes_, string const &offset_, int32 limit_);

  static const std::int32_t ID = -1419859400;

  using ReturnType = object_ptr<foundChatBoosts>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatEventLogFilters;

class chatEvents;

class getChatEventLog final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string query_;
  int64 from_event_id_;
  int32 limit_;
  object_ptr<chatEventLogFilters> filters_;
  array<int53> user_ids_;

  getChatEventLog();

  getChatEventLog(int53 chat_id_, string const &query_, int64 from_event_id_, int32 limit_, object_ptr<chatEventLogFilters> &&filters_, array<int53> &&user_ids_);

  static const std::int32_t ID = -1281344669;

  using ReturnType = object_ptr<chatEvents>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolder;

class getChatFolder final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;

  getChatFolder();

  explicit getChatFolder(int32 chat_folder_id_);

  static const std::int32_t ID = 92809880;

  using ReturnType = object_ptr<chatFolder>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolder;

class count;

class getChatFolderChatCount final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatFolder> folder_;

  getChatFolderChatCount();

  explicit getChatFolderChatCount(object_ptr<chatFolder> &&folder_);

  static const std::int32_t ID = 2111097790;

  using ReturnType = object_ptr<count>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getChatFolderChatsToLeave final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;

  getChatFolderChatsToLeave();

  explicit getChatFolderChatsToLeave(int32 chat_folder_id_);

  static const std::int32_t ID = -1916672337;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolder;

class chatFolderIcon;

class getChatFolderDefaultIconName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<chatFolder> folder_;

  getChatFolderDefaultIconName();

  explicit getChatFolderDefaultIconName(object_ptr<chatFolder> &&folder_);

  static const std::int32_t ID = 754425959;

  using ReturnType = object_ptr<chatFolderIcon>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatFolderInviteLinks;

class getChatFolderInviteLinks final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;

  getChatFolderInviteLinks();

  explicit getChatFolderInviteLinks(int32 chat_folder_id_);

  static const std::int32_t ID = 329079776;

  using ReturnType = object_ptr<chatFolderInviteLinks>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getChatFolderNewChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;

  getChatFolderNewChats();

  explicit getChatFolderNewChats(int32 chat_folder_id_);

  static const std::int32_t ID = 2123181260;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages;

class getChatHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 from_message_id_;
  int32 offset_;
  int32 limit_;
  bool only_local_;

  getChatHistory();

  getChatHistory(int53 chat_id_, int53 from_message_id_, int32 offset_, int32 limit_, bool only_local_);

  static const std::int32_t ID = -799960451;

  using ReturnType = object_ptr<messages>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLink;

class getChatInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string invite_link_;

  getChatInviteLink();

  getChatInviteLink(int53 chat_id_, string const &invite_link_);

  static const std::int32_t ID = -479575555;

  using ReturnType = object_ptr<chatInviteLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLinkCounts;

class getChatInviteLinkCounts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatInviteLinkCounts();

  explicit getChatInviteLinkCounts(int53 chat_id_);

  static const std::int32_t ID = 890299025;

  using ReturnType = object_ptr<chatInviteLinkCounts>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLinkMember;

class chatInviteLinkMembers;

class getChatInviteLinkMembers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string invite_link_;
  bool only_with_expired_subscription_;
  object_ptr<chatInviteLinkMember> offset_member_;
  int32 limit_;

  getChatInviteLinkMembers();

  getChatInviteLinkMembers(int53 chat_id_, string const &invite_link_, bool only_with_expired_subscription_, object_ptr<chatInviteLinkMember> &&offset_member_, int32 limit_);

  static const std::int32_t ID = 1728376124;

  using ReturnType = object_ptr<chatInviteLinkMembers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatInviteLinks;

class getChatInviteLinks final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 creator_user_id_;
  bool is_revoked_;
  int32 offset_date_;
  string offset_invite_link_;
  int32 limit_;

  getChatInviteLinks();

  getChatInviteLinks(int53 chat_id_, int53 creator_user_id_, bool is_revoked_, int32 offset_date_, string const &offset_invite_link_, int32 limit_);

  static const std::int32_t ID = 883252396;

  using ReturnType = object_ptr<chatInviteLinks>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatJoinRequest;

class chatJoinRequests;

class getChatJoinRequests final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string invite_link_;
  string query_;
  object_ptr<chatJoinRequest> offset_request_;
  int32 limit_;

  getChatJoinRequests();

  getChatJoinRequests(int53 chat_id_, string const &invite_link_, string const &query_, object_ptr<chatJoinRequest> &&offset_request_, int32 limit_);

  static const std::int32_t ID = -388428126;

  using ReturnType = object_ptr<chatJoinRequests>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatLists;

class getChatListsToAddChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatListsToAddChat();

  explicit getChatListsToAddChat(int53 chat_id_);

  static const std::int32_t ID = 654956193;

  using ReturnType = object_ptr<chatLists>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class chatMember;

class getChatMember final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<MessageSender> member_id_;

  getChatMember();

  getChatMember(int53 chat_id_, object_ptr<MessageSender> &&member_id_);

  static const std::int32_t ID = -792636814;

  using ReturnType = object_ptr<chatMember>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class getChatMessageByDate final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 date_;

  getChatMessageByDate();

  getChatMessageByDate(int53 chat_id_, int32 date_);

  static const std::int32_t ID = 1062564150;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SearchMessagesFilter;

class messageCalendar;

class getChatMessageCalendar final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<SearchMessagesFilter> filter_;
  int53 from_message_id_;
  int53 saved_messages_topic_id_;

  getChatMessageCalendar();

  getChatMessageCalendar(int53 chat_id_, object_ptr<SearchMessagesFilter> &&filter_, int53 from_message_id_, int53 saved_messages_topic_id_);

  static const std::int32_t ID = -2119225929;

  using ReturnType = object_ptr<messageCalendar>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SearchMessagesFilter;

class count;

class getChatMessageCount final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<SearchMessagesFilter> filter_;
  int53 saved_messages_topic_id_;
  bool return_local_;

  getChatMessageCount();

  getChatMessageCount(int53 chat_id_, object_ptr<SearchMessagesFilter> &&filter_, int53 saved_messages_topic_id_, bool return_local_);

  static const std::int32_t ID = 955746569;

  using ReturnType = object_ptr<count>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SearchMessagesFilter;

class count;

class getChatMessagePosition final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<SearchMessagesFilter> filter_;
  int53 message_thread_id_;
  int53 saved_messages_topic_id_;

  getChatMessagePosition();

  getChatMessagePosition(int53 chat_id_, int53 message_id_, object_ptr<SearchMessagesFilter> &&filter_, int53 message_thread_id_, int53 saved_messages_topic_id_);

  static const std::int32_t ID = 136051911;

  using ReturnType = object_ptr<count>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationSettingsScope;

class chats;

class getChatNotificationSettingsExceptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<NotificationSettingsScope> scope_;
  bool compare_sound_;

  getChatNotificationSettingsExceptions();

  getChatNotificationSettingsExceptions(object_ptr<NotificationSettingsScope> &&scope_, bool compare_sound_);

  static const std::int32_t ID = 201199121;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class getChatPinnedMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatPinnedMessage();

  explicit getChatPinnedMessage(int53 chat_id_);

  static const std::int32_t ID = 359865008;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stories;

class getChatPostedToChatPageStories final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 from_story_id_;
  int32 limit_;

  getChatPostedToChatPageStories();

  getChatPostedToChatPageStories(int53 chat_id_, int32 from_story_id_, int32 limit_);

  static const std::int32_t ID = -46414037;

  using ReturnType = object_ptr<stories>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatRevenueStatistics;

class getChatRevenueStatistics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool is_dark_;

  getChatRevenueStatistics();

  getChatRevenueStatistics(int53 chat_id_, bool is_dark_);

  static const std::int32_t ID = 701995836;

  using ReturnType = object_ptr<chatRevenueStatistics>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chatRevenueTransactions;

class getChatRevenueTransactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 offset_;
  int32 limit_;

  getChatRevenueTransactions();

  getChatRevenueTransactions(int53 chat_id_, int32 offset_, int32 limit_);

  static const std::int32_t ID = 1194264341;

  using ReturnType = object_ptr<chatRevenueTransactions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class httpUrl;

class getChatRevenueWithdrawalUrl final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string password_;

  getChatRevenueWithdrawalUrl();

  getChatRevenueWithdrawalUrl(int53 chat_id_, string const &password_);

  static const std::int32_t ID = 506595104;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages;

class getChatScheduledMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatScheduledMessages();

  explicit getChatScheduledMessages(int53 chat_id_);

  static const std::int32_t ID = -549638149;

  using ReturnType = object_ptr<messages>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class count;

class getChatSimilarChatCount final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool return_local_;

  getChatSimilarChatCount();

  getChatSimilarChatCount(int53 chat_id_, bool return_local_);

  static const std::int32_t ID = 1178506894;

  using ReturnType = object_ptr<count>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getChatSimilarChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatSimilarChats();

  explicit getChatSimilarChats(int53 chat_id_);

  static const std::int32_t ID = -1152348285;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SearchMessagesFilter;

class messagePositions;

class getChatSparseMessagePositions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  object_ptr<SearchMessagesFilter> filter_;
  int53 from_message_id_;
  int32 limit_;
  int53 saved_messages_topic_id_;

  getChatSparseMessagePositions();

  getChatSparseMessagePositions(int53 chat_id_, object_ptr<SearchMessagesFilter> &&filter_, int53 from_message_id_, int32 limit_, int53 saved_messages_topic_id_);

  static const std::int32_t ID = 994389757;

  using ReturnType = object_ptr<messagePositions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sponsoredMessages;

class getChatSponsoredMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getChatSponsoredMessages();

  explicit getChatSponsoredMessages(int53 chat_id_);

  static const std::int32_t ID = 1353203864;

  using ReturnType = object_ptr<sponsoredMessages>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatStatistics;

class getChatStatistics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  bool is_dark_;

  getChatStatistics();

  getChatStatistics(int53 chat_id_, bool is_dark_);

  static const std::int32_t ID = 327057816;

  using ReturnType = object_ptr<ChatStatistics>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType;

class storyInteractions;

class getChatStoryInteractions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;
  object_ptr<ReactionType> reaction_type_;
  bool prefer_forwards_;
  string offset_;
  int32 limit_;

  getChatStoryInteractions();

  getChatStoryInteractions(int53 story_poster_chat_id_, int32 story_id_, object_ptr<ReactionType> &&reaction_type_, bool prefer_forwards_, string const &offset_, int32 limit_);

  static const std::int32_t ID = 354545268;

  using ReturnType = object_ptr<storyInteractions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ChatList;

class chats;

class getChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<ChatList> chat_list_;
  int32 limit_;

  getChats();

  getChats(object_ptr<ChatList> &&chat_list_, int32 limit_);

  static const std::int32_t ID = -972768574;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getChatsForChatFolderInviteLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_folder_id_;

  getChatsForChatFolderInviteLink();

  explicit getChatsForChatFolderInviteLink(int32 chat_folder_id_);

  static const std::int32_t ID = 1873561929;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getChatsToPostStories final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getChatsToPostStories();

  static const std::int32_t ID = 1893901427;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class users;

class getCloseFriends final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getCloseFriends();

  static const std::int32_t ID = -1445628722;

  using ReturnType = object_ptr<users>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class CollectibleItemType;

class collectibleItemInfo;

class getCollectibleItemInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<CollectibleItemType> type_;

  getCollectibleItemInfo();

  explicit getCollectibleItemInfo(object_ptr<CollectibleItemType> &&type_);

  static const std::int32_t ID = -217797238;

  using ReturnType = object_ptr<collectibleItemInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class BotCommandScope;

class botCommands;

class getCommands final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<BotCommandScope> scope_;
  string language_code_;

  getCommands();

  getCommands(object_ptr<BotCommandScope> &&scope_, string const &language_code_);

  static const std::int32_t ID = 1488621559;

  using ReturnType = object_ptr<botCommands>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AffiliateType;

class connectedAffiliateProgram;

class getConnectedAffiliateProgram final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<AffiliateType> affiliate_;
  int53 bot_user_id_;

  getConnectedAffiliateProgram();

  getConnectedAffiliateProgram(object_ptr<AffiliateType> &&affiliate_, int53 bot_user_id_);

  static const std::int32_t ID = -1755191440;

  using ReturnType = object_ptr<connectedAffiliateProgram>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class AffiliateType;

class connectedAffiliatePrograms;

class getConnectedAffiliatePrograms final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<AffiliateType> affiliate_;
  string offset_;
  int32 limit_;

  getConnectedAffiliatePrograms();

  getConnectedAffiliatePrograms(object_ptr<AffiliateType> &&affiliate_, string const &offset_, int32 limit_);

  static const std::int32_t ID = -1960029582;

  using ReturnType = object_ptr<connectedAffiliatePrograms>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class connectedWebsites;

class getConnectedWebsites final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getConnectedWebsites();

  static const std::int32_t ID = -170536110;

  using ReturnType = object_ptr<connectedWebsites>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class users;

class getContacts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getContacts();

  static const std::int32_t ID = -1417722768;

  using ReturnType = object_ptr<users>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class countries;

class getCountries final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getCountries();

  static const std::int32_t ID = -51902050;

  using ReturnType = object_ptr<countries>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getCountryCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getCountryCode();

  static const std::int32_t ID = 1540593906;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getCountryFlagEmoji final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string country_code_;

  getCountryFlagEmoji();

  explicit getCountryFlagEmoji(string const &country_code_);

  static const std::int32_t ID = 981871098;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PublicChatType;

class chats;

class getCreatedPublicChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PublicChatType> type_;

  getCreatedPublicChats();

  explicit getCreatedPublicChats(object_ptr<PublicChatType> &&type_);

  static const std::int32_t ID = 710354415;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class updates;

class getCurrentState final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getCurrentState();

  static const std::int32_t ID = -1191417719;

  using ReturnType = object_ptr<updates>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class currentWeather;

class location;

class getCurrentWeather final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;

  getCurrentWeather();

  explicit getCurrentWeather(object_ptr<location> &&location_);

  static const std::int32_t ID = -1965384759;

  using ReturnType = object_ptr<currentWeather>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getCustomEmojiReactionAnimations final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getCustomEmojiReactionAnimations();

  static const std::int32_t ID = 1232375250;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getCustomEmojiStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  array<int64> custom_emoji_ids_;

  getCustomEmojiStickers();

  explicit getCustomEmojiStickers(array<int64> &&custom_emoji_ids_);

  static const std::int32_t ID = -2127427955;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class databaseStatistics;

class getDatabaseStatistics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getDatabaseStatistics();

  static const std::int32_t ID = -1942760263;

  using ReturnType = object_ptr<databaseStatistics>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class deepLinkInfo;

class getDeepLinkInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  getDeepLinkInfo();

  explicit getDeepLinkInfo(string const &link_);

  static const std::int32_t ID = 680673150;

  using ReturnType = object_ptr<deepLinkInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getDefaultBackgroundCustomEmojiStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getDefaultBackgroundCustomEmojiStickers();

  static const std::int32_t ID = 485910542;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatusCustomEmojis;

class getDefaultChatEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getDefaultChatEmojiStatuses();

  static const std::int32_t ID = 1553698018;

  using ReturnType = object_ptr<emojiStatusCustomEmojis>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getDefaultChatPhotoCustomEmojiStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getDefaultChatPhotoCustomEmojiStickers();

  static const std::int32_t ID = -376342683;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatusCustomEmojis;

class getDefaultEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getDefaultEmojiStatuses();

  static const std::int32_t ID = -539392025;

  using ReturnType = object_ptr<emojiStatusCustomEmojis>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageAutoDeleteTime;

class getDefaultMessageAutoDeleteTime final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getDefaultMessageAutoDeleteTime();

  static const std::int32_t ID = -450857574;

  using ReturnType = object_ptr<messageAutoDeleteTime>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getDefaultProfilePhotoCustomEmojiStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getDefaultProfilePhotoCustomEmojiStickers();

  static const std::int32_t ID = 1280041655;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatusCustomEmojis;

class getDisallowedChatEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getDisallowedChatEmojiStatuses();

  static const std::int32_t ID = -2004787831;

  using ReturnType = object_ptr<emojiStatusCustomEmojis>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class EmojiCategoryType;

class emojiCategories;

class getEmojiCategories final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<EmojiCategoryType> type_;

  getEmojiCategories();

  explicit getEmojiCategories(object_ptr<EmojiCategoryType> &&type_);

  static const std::int32_t ID = 2139537774;

  using ReturnType = object_ptr<emojiCategories>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiReaction;

class getEmojiReaction final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string emoji_;

  getEmojiReaction();

  explicit getEmojiReaction(string const &emoji_);

  static const std::int32_t ID = -449572388;

  using ReturnType = object_ptr<emojiReaction>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class httpUrl;

class getEmojiSuggestionsUrl final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string language_code_;

  getEmojiSuggestionsUrl();

  explicit getEmojiSuggestionsUrl(string const &language_code_);

  static const std::int32_t ID = -1404101841;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class httpUrl;

class getExternalLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;
  bool allow_write_access_;

  getExternalLink();

  getExternalLink(string const &link_, bool allow_write_access_);

  static const std::int32_t ID = 1586688235;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LoginUrlInfo;

class getExternalLinkInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  getExternalLinkInfo();

  explicit getExternalLinkInfo(string const &link_);

  static const std::int32_t ID = 1175288383;

  using ReturnType = object_ptr<LoginUrlInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getFavoriteStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getFavoriteStickers();

  static const std::int32_t ID = -338964672;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class getFile final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;

  getFile();

  explicit getFile(int32 file_id_);

  static const std::int32_t ID = 1553923406;

  using ReturnType = object_ptr<file>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class fileDownloadedPrefixSize;

class getFileDownloadedPrefixSize final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;
  int53 offset_;

  getFileDownloadedPrefixSize();

  getFileDownloadedPrefixSize(int32 file_id_, int53 offset_);

  static const std::int32_t ID = 855948589;

  using ReturnType = object_ptr<fileDownloadedPrefixSize>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getFileExtension final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string mime_type_;

  getFileExtension();

  explicit getFileExtension(string const &mime_type_);

  static const std::int32_t ID = -106055372;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getFileMimeType final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string file_name_;

  getFileMimeType();

  explicit getFileMimeType(string const &file_name_);

  static const std::int32_t ID = -2073879671;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class forumTopic;

class getForumTopic final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_thread_id_;

  getForumTopic();

  getForumTopic(int53 chat_id_, int53 message_thread_id_);

  static const std::int32_t ID = -442761663;

  using ReturnType = object_ptr<forumTopic>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getForumTopicDefaultIcons final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getForumTopicDefaultIcons();

  static const std::int32_t ID = 1479898332;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageLink;

class getForumTopicLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_thread_id_;

  getForumTopicLink();

  getForumTopicLink(int53 chat_id_, int53 message_thread_id_);

  static const std::int32_t ID = -914650933;

  using ReturnType = object_ptr<messageLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class forumTopics;

class getForumTopics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string query_;
  int32 offset_date_;
  int53 offset_message_id_;
  int53 offset_message_thread_id_;
  int32 limit_;

  getForumTopics();

  getForumTopics(int53 chat_id_, string const &query_, int32 offset_date_, int53 offset_message_id_, int53 offset_message_thread_id_, int32 limit_);

  static const std::int32_t ID = -72647334;

  using ReturnType = object_ptr<forumTopics>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class gameHighScores;

class getGameHighScores final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int53 user_id_;

  getGameHighScores();

  getGameHighScores(int53 chat_id_, int53 message_id_, int53 user_id_);

  static const std::int32_t ID = 15746459;

  using ReturnType = object_ptr<gameHighScores>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class giftUpgradePreview;

class getGiftUpgradePreview final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 gift_id_;

  getGiftUpgradePreview();

  explicit getGiftUpgradePreview(int64 gift_id_);

  static const std::int32_t ID = -1110719907;

  using ReturnType = object_ptr<giftUpgradePreview>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class GiveawayInfo;

class getGiveawayInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  getGiveawayInfo();

  getGiveawayInfo(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -1215852357;

  using ReturnType = object_ptr<GiveawayInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getGreetingStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getGreetingStickers();

  static const std::int32_t ID = 374873372;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class foundUsers;

class getGrossingWebAppBots final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string offset_;
  int32 limit_;

  getGrossingWebAppBots();

  getGrossingWebAppBots(string const &offset_, int32 limit_);

  static const std::int32_t ID = 1696779802;

  using ReturnType = object_ptr<foundUsers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class groupCall;

class getGroupCall final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 group_call_id_;

  getGroupCall();

  explicit getGroupCall(int32 group_call_id_);

  static const std::int32_t ID = 1468491406;

  using ReturnType = object_ptr<groupCall>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputGroupCall;

class groupCallParticipants;

class getGroupCallParticipants final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputGroupCall> input_group_call_;
  int32 limit_;

  getGroupCallParticipants();

  getGroupCallParticipants(object_ptr<InputGroupCall> &&input_group_call_, int32 limit_);

  static const std::int32_t ID = 1986739394;

  using ReturnType = object_ptr<groupCallParticipants>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getGroupsInCommon final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;
  int53 offset_chat_id_;
  int32 limit_;

  getGroupsInCommon();

  getGroupsInCommon(int53 user_id_, int53 offset_chat_id_, int32 limit_);

  static const std::int32_t ID = 381539178;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class count;

class getImportedContactCount final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getImportedContactCount();

  static const std::int32_t ID = -656336346;

  using ReturnType = object_ptr<count>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getInactiveSupergroupChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getInactiveSupergroupChats();

  static const std::int32_t ID = -657720907;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class gameHighScores;

class getInlineGameHighScores final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string inline_message_id_;
  int53 user_id_;

  getInlineGameHighScores();

  getInlineGameHighScores(string const &inline_message_id_, int53 user_id_);

  static const std::int32_t ID = -533107798;

  using ReturnType = object_ptr<gameHighScores>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class inlineQueryResults;

class location;

class getInlineQueryResults final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  int53 chat_id_;
  object_ptr<location> user_location_;
  string query_;
  string offset_;

  getInlineQueryResults();

  getInlineQueryResults(int53 bot_user_id_, int53 chat_id_, object_ptr<location> &&user_location_, string const &query_, string const &offset_);

  static const std::int32_t ID = 2044524652;

  using ReturnType = object_ptr<inlineQueryResults>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class backgrounds;

class getInstalledBackgrounds final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool for_dark_theme_;

  getInstalledBackgrounds();

  explicit getInstalledBackgrounds(bool for_dark_theme_);

  static const std::int32_t ID = -1051406241;

  using ReturnType = object_ptr<backgrounds>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerType;

class stickerSets;

class getInstalledStickerSets final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StickerType> sticker_type_;

  getInstalledStickerSets();

  explicit getInstalledStickerSets(object_ptr<StickerType> &&sticker_type_);

  static const std::int32_t ID = 1630467830;

  using ReturnType = object_ptr<stickerSets>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InternalLinkType;

class httpUrl;

class getInternalLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InternalLinkType> type_;
  bool is_http_;

  getInternalLink();

  getInternalLink(object_ptr<InternalLinkType> &&type_, bool is_http_);

  static const std::int32_t ID = 962654640;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InternalLinkType;

class getInternalLinkType final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string link_;

  getInternalLinkType();

  explicit getInternalLinkType(string const &link_);

  static const std::int32_t ID = -1948428535;

  using ReturnType = object_ptr<InternalLinkType>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class JsonValue;

class text;

class getJsonString final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<JsonValue> json_value_;

  getJsonString();

  explicit getJsonString(object_ptr<JsonValue> &&json_value_);

  static const std::int32_t ID = 663458849;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class JsonValue;

class getJsonValue final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string json_;

  getJsonValue();

  explicit getJsonValue(string const &json_);

  static const std::int32_t ID = -1829086715;

  using ReturnType = object_ptr<JsonValue>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojis;

class getKeywordEmojis final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;
  array<string> input_language_codes_;

  getKeywordEmojis();

  getKeywordEmojis(string const &text_, array<string> &&input_language_codes_);

  static const std::int32_t ID = -1969795990;

  using ReturnType = object_ptr<emojis>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class languagePackInfo;

class getLanguagePackInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string language_pack_id_;

  getLanguagePackInfo();

  explicit getLanguagePackInfo(string const &language_pack_id_);

  static const std::int32_t ID = 2077809320;

  using ReturnType = object_ptr<languagePackInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LanguagePackStringValue;

class getLanguagePackString final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string language_pack_database_path_;
  string localization_target_;
  string language_pack_id_;
  string key_;

  getLanguagePackString();

  getLanguagePackString(string const &language_pack_database_path_, string const &localization_target_, string const &language_pack_id_, string const &key_);

  static const std::int32_t ID = 150789747;

  using ReturnType = object_ptr<LanguagePackStringValue>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class languagePackStrings;

class getLanguagePackStrings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string language_pack_id_;
  array<string> keys_;

  getLanguagePackStrings();

  getLanguagePackStrings(string const &language_pack_id_, array<string> &&keys_);

  static const std::int32_t ID = 1246259088;

  using ReturnType = object_ptr<languagePackStrings>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class linkPreview;

class linkPreviewOptions;

class getLinkPreview final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;
  object_ptr<linkPreviewOptions> link_preview_options_;

  getLinkPreview();

  getLinkPreview(object_ptr<formattedText> &&text_, object_ptr<linkPreviewOptions> &&link_preview_options_);

  static const std::int32_t ID = -1039572191;

  using ReturnType = object_ptr<linkPreview>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class localizationTargetInfo;

class getLocalizationTargetInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool only_local_;

  getLocalizationTargetInfo();

  explicit getLocalizationTargetInfo(bool only_local_);

  static const std::int32_t ID = 1849499526;

  using ReturnType = object_ptr<localizationTargetInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LogStream;

class getLogStream final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getLogStream();

  static const std::int32_t ID = 1167608667;

  using ReturnType = object_ptr<LogStream>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class logVerbosityLevel;

class getLogTagVerbosityLevel final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string tag_;

  getLogTagVerbosityLevel();

  explicit getLogTagVerbosityLevel(string const &tag_);

  static const std::int32_t ID = 951004547;

  using ReturnType = object_ptr<logVerbosityLevel>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class logTags;

class getLogTags final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getLogTags();

  static const std::int32_t ID = -254449190;

  using ReturnType = object_ptr<logTags>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class logVerbosityLevel;

class getLogVerbosityLevel final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getLogVerbosityLevel();

  static const std::int32_t ID = 594057956;

  using ReturnType = object_ptr<logVerbosityLevel>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class httpUrl;

class getLoginUrl final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int53 button_id_;
  bool allow_write_access_;

  getLoginUrl();

  getLoginUrl(int53 chat_id_, int53 message_id_, int53 button_id_, bool allow_write_access_);

  static const std::int32_t ID = 791844305;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class LoginUrlInfo;

class getLoginUrlInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int53 button_id_;

  getLoginUrlInfo();

  getLoginUrlInfo(int53 chat_id_, int53 message_id_, int53 button_id_);

  static const std::int32_t ID = -859202125;

  using ReturnType = object_ptr<LoginUrlInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class mainWebApp;

class webAppOpenParameters;

class getMainWebApp final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 bot_user_id_;
  string start_parameter_;
  object_ptr<webAppOpenParameters> parameters_;

  getMainWebApp();

  getMainWebApp(int53 chat_id_, int53 bot_user_id_, string const &start_parameter_, object_ptr<webAppOpenParameters> &&parameters_);

  static const std::int32_t ID = 594050214;

  using ReturnType = object_ptr<mainWebApp>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class file;

class location;

class getMapThumbnailFile final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<location> location_;
  int32 zoom_;
  int32 width_;
  int32 height_;
  int32 scale_;
  int53 chat_id_;

  getMapThumbnailFile();

  getMapThumbnailFile(object_ptr<location> &&location_, int32 zoom_, int32 width_, int32 height_, int32 scale_, int53 chat_id_);

  static const std::int32_t ID = -152660070;

  using ReturnType = object_ptr<file>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class formattedText;

class getMarkdownText final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<formattedText> text_;

  getMarkdownText();

  explicit getMarkdownText(object_ptr<formattedText> &&text_);

  static const std::int32_t ID = 164524584;

  using ReturnType = object_ptr<formattedText>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class user;

class getMe final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getMe();

  static const std::int32_t ID = -191516033;

  using ReturnType = object_ptr<user>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class botMenuButton;

class getMenuButton final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  getMenuButton();

  explicit getMenuButton(int53 user_id_);

  static const std::int32_t ID = -437324736;

  using ReturnType = object_ptr<botMenuButton>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class getMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  getMessage();

  getMessage(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -1821196160;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class ReactionType;

class addedReactions;

class getMessageAddedReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  object_ptr<ReactionType> reaction_type_;
  string offset_;
  int32 limit_;

  getMessageAddedReactions();

  getMessageAddedReactions(int53 chat_id_, int53 message_id_, object_ptr<ReactionType> &&reaction_type_, string const &offset_, int32 limit_);

  static const std::int32_t ID = 2110172754;

  using ReturnType = object_ptr<addedReactions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class availableReactions;

class getMessageAvailableReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int32 row_size_;

  getMessageAvailableReactions();

  getMessageAvailableReactions(int53 chat_id_, int53 message_id_, int32 row_size_);

  static const std::int32_t ID = 1994098354;

  using ReturnType = object_ptr<availableReactions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageEffect;

class getMessageEffect final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 effect_id_;

  getMessageEffect();

  explicit getMessageEffect(int64 effect_id_);

  static const std::int32_t ID = -1638843116;

  using ReturnType = object_ptr<messageEffect>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getMessageEmbeddingCode final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  bool for_album_;

  getMessageEmbeddingCode();

  getMessageEmbeddingCode(int53 chat_id_, int53 message_id_, bool for_album_);

  static const std::int32_t ID = 1654967561;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageFileType;

class getMessageFileType final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string message_file_head_;

  getMessageFileType();

  explicit getMessageFileType(string const &message_file_head_);

  static const std::int32_t ID = -490270764;

  using ReturnType = object_ptr<MessageFileType>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getMessageImportConfirmationText final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;

  getMessageImportConfirmationText();

  explicit getMessageImportConfirmationText(int53 chat_id_);

  static const std::int32_t ID = 390627752;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageLink;

class getMessageLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int32 media_timestamp_;
  bool for_album_;
  bool in_message_thread_;

  getMessageLink();

  getMessageLink(int53 chat_id_, int53 message_id_, int32 media_timestamp_, bool for_album_, bool in_message_thread_);

  static const std::int32_t ID = -984158342;

  using ReturnType = object_ptr<messageLink>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageLinkInfo;

class getMessageLinkInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string url_;

  getMessageLinkInfo();

  explicit getMessageLinkInfo(string const &url_);

  static const std::int32_t ID = -700533672;

  using ReturnType = object_ptr<messageLinkInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class getMessageLocally final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  getMessageLocally();

  getMessageLocally(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -603575444;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageProperties;

class getMessageProperties final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  getMessageProperties();

  getMessageProperties(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = 773382571;

  using ReturnType = object_ptr<messageProperties>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class publicForwards;

class getMessagePublicForwards final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  string offset_;
  int32 limit_;

  getMessagePublicForwards();

  getMessagePublicForwards(int53 chat_id_, int53 message_id_, string const &offset_, int32 limit_);

  static const std::int32_t ID = 1369285812;

  using ReturnType = object_ptr<publicForwards>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageReadDate;

class getMessageReadDate final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  getMessageReadDate();

  getMessageReadDate(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -1484455101;

  using ReturnType = object_ptr<MessageReadDate>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageStatistics;

class getMessageStatistics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  bool is_dark_;

  getMessageStatistics();

  getMessageStatistics(int53 chat_id_, int53 message_id_, bool is_dark_);

  static const std::int32_t ID = 1270194648;

  using ReturnType = object_ptr<messageStatistics>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageThreadInfo;

class getMessageThread final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  getMessageThread();

  getMessageThread(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = 2062695998;

  using ReturnType = object_ptr<messageThreadInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages;

class getMessageThreadHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int53 from_message_id_;
  int32 offset_;
  int32 limit_;

  getMessageThreadHistory();

  getMessageThreadHistory(int53 chat_id_, int53 message_id_, int53 from_message_id_, int32 offset_, int32 limit_);

  static const std::int32_t ID = -1808411608;

  using ReturnType = object_ptr<messages>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageViewers;

class getMessageViewers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  getMessageViewers();

  getMessageViewers(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -1584457010;

  using ReturnType = object_ptr<messageViewers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages;

class getMessages final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  array<int53> message_ids_;

  getMessages();

  getMessages(int53 chat_id_, array<int53> &&message_ids_);

  static const std::int32_t ID = 425299338;

  using ReturnType = object_ptr<messages>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class networkStatistics;

class getNetworkStatistics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool only_current_;

  getNetworkStatistics();

  explicit getNetworkStatistics(bool only_current_);

  static const std::int32_t ID = -986228706;

  using ReturnType = object_ptr<networkStatistics>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class newChatPrivacySettings;

class getNewChatPrivacySettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getNewChatPrivacySettings();

  static const std::int32_t ID = -1295299657;

  using ReturnType = object_ptr<newChatPrivacySettings>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class OptionValue;

class getOption final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string name_;

  getOption();

  explicit getOption(string const &name_);

  static const std::int32_t ID = -1572495746;

  using ReturnType = object_ptr<OptionValue>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class users;

class getOwnedBots final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getOwnedBots();

  static const std::int32_t ID = -1954035715;

  using ReturnType = object_ptr<users>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerSets;

class getOwnedStickerSets final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 offset_sticker_set_id_;
  int32 limit_;

  getOwnedStickerSets();

  getOwnedStickerSets(int64 offset_sticker_set_id_, int32 limit_);

  static const std::int32_t ID = 1493074208;

  using ReturnType = object_ptr<stickerSets>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starCount;

class getPaidMessageRevenue final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  getPaidMessageRevenue();

  explicit getPaidMessageRevenue(int53 user_id_);

  static const std::int32_t ID = 1976589102;

  using ReturnType = object_ptr<starCount>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportAuthorizationForm;

class getPassportAuthorizationForm final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string scope_;
  string public_key_;
  string nonce_;

  getPassportAuthorizationForm();

  getPassportAuthorizationForm(int53 bot_user_id_, string const &scope_, string const &public_key_, string const &nonce_);

  static const std::int32_t ID = 1636107398;

  using ReturnType = object_ptr<passportAuthorizationForm>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passportElementsWithErrors;

class getPassportAuthorizationFormAvailableElements final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 authorization_form_id_;
  string password_;

  getPassportAuthorizationFormAvailableElements();

  getPassportAuthorizationFormAvailableElements(int32 authorization_form_id_, string const &password_);

  static const std::int32_t ID = 1068700924;

  using ReturnType = object_ptr<passportElementsWithErrors>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PassportElement;

class PassportElementType;

class getPassportElement final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PassportElementType> type_;
  string password_;

  getPassportElement();

  getPassportElement(object_ptr<PassportElementType> &&type_, string const &password_);

  static const std::int32_t ID = -1882398342;

  using ReturnType = object_ptr<PassportElement>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class passwordState;

class getPasswordState final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getPasswordState();

  static const std::int32_t ID = -174752904;

  using ReturnType = object_ptr<passwordState>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputInvoice;

class paymentForm;

class themeParameters;

class getPaymentForm final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputInvoice> input_invoice_;
  object_ptr<themeParameters> theme_;

  getPaymentForm();

  getPaymentForm(object_ptr<InputInvoice> &&input_invoice_, object_ptr<themeParameters> &&theme_);

  static const std::int32_t ID = -1924172076;

  using ReturnType = object_ptr<paymentForm>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class paymentReceipt;

class getPaymentReceipt final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  getPaymentReceipt();

  getPaymentReceipt(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = 1013758294;

  using ReturnType = object_ptr<paymentReceipt>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneNumberInfo;

class getPhoneNumberInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string phone_number_prefix_;

  getPhoneNumberInfo();

  explicit getPhoneNumberInfo(string const &phone_number_prefix_);

  static const std::int32_t ID = -1608344583;

  using ReturnType = object_ptr<phoneNumberInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class phoneNumberInfo;

class getPhoneNumberInfoSync final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string language_code_;
  string phone_number_prefix_;

  getPhoneNumberInfoSync();

  getPhoneNumberInfoSync(string const &language_code_, string const &phone_number_prefix_);

  static const std::int32_t ID = 547061048;

  using ReturnType = object_ptr<phoneNumberInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messageSenders;

class getPollVoters final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;
  int32 option_id_;
  int32 offset_;
  int32 limit_;

  getPollVoters();

  getPollVoters(int53 chat_id_, int53 message_id_, int32 option_id_, int32 offset_, int32 limit_);

  static const std::int32_t ID = -1000625748;

  using ReturnType = object_ptr<messageSenders>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getPreferredCountryLanguage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string country_code_;

  getPreferredCountryLanguage();

  explicit getPreferredCountryLanguage(string const &country_code_);

  static const std::int32_t ID = -933049386;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PremiumSource;

class premiumFeatures;

class getPremiumFeatures final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PremiumSource> source_;

  getPremiumFeatures();

  explicit getPremiumFeatures(object_ptr<PremiumSource> &&source_);

  static const std::int32_t ID = -1260640695;

  using ReturnType = object_ptr<premiumFeatures>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumGiftPaymentOptions;

class getPremiumGiftPaymentOptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getPremiumGiftPaymentOptions();

  static const std::int32_t ID = -480334244;

  using ReturnType = object_ptr<premiumGiftPaymentOptions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumGiveawayPaymentOptions;

class getPremiumGiveawayPaymentOptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 boosted_chat_id_;

  getPremiumGiveawayPaymentOptions();

  explicit getPremiumGiveawayPaymentOptions(int53 boosted_chat_id_);

  static const std::int32_t ID = 1222168073;

  using ReturnType = object_ptr<premiumGiveawayPaymentOptions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sticker;

class getPremiumInfoSticker final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 month_count_;

  getPremiumInfoSticker();

  explicit getPremiumInfoSticker(int32 month_count_);

  static const std::int32_t ID = 2043562651;

  using ReturnType = object_ptr<sticker>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class PremiumLimitType;

class premiumLimit;

class getPremiumLimit final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<PremiumLimitType> limit_type_;

  getPremiumLimit();

  explicit getPremiumLimit(object_ptr<PremiumLimitType> &&limit_type_);

  static const std::int32_t ID = 1075313898;

  using ReturnType = object_ptr<premiumLimit>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class premiumState;

class getPremiumState final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getPremiumState();

  static const std::int32_t ID = 663632610;

  using ReturnType = object_ptr<premiumState>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getPremiumStickerExamples final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getPremiumStickerExamples();

  static const std::int32_t ID = 1399442328;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getPremiumStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 limit_;

  getPremiumStickers();

  explicit getPremiumStickers(int32 limit_);

  static const std::int32_t ID = -280950192;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class preparedInlineMessage;

class getPreparedInlineMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 bot_user_id_;
  string prepared_message_id_;

  getPreparedInlineMessage();

  getPreparedInlineMessage(int53 bot_user_id_, string const &prepared_message_id_);

  static const std::int32_t ID = -83179701;

  using ReturnType = object_ptr<preparedInlineMessage>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class proxies;

class getProxies final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getProxies();

  static const std::int32_t ID = -95026381;

  using ReturnType = object_ptr<proxies>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class httpUrl;

class getProxyLink final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 proxy_id_;

  getProxyLink();

  explicit getProxyLink(int32 proxy_id_);

  static const std::int32_t ID = -1054495112;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class pushReceiverId;

class getPushReceiverId final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string payload_;

  getPushReceiverId();

  explicit getPushReceiverId(string const &payload_);

  static const std::int32_t ID = -286505294;

  using ReturnType = object_ptr<pushReceiverId>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class readDatePrivacySettings;

class getReadDatePrivacySettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getReadDatePrivacySettings();

  static const std::int32_t ID = 451435451;

  using ReturnType = object_ptr<readDatePrivacySettings>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class receivedGift;

class getReceivedGift final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string received_gift_id_;

  getReceivedGift();

  explicit getReceivedGift(string const &received_gift_id_);

  static const std::int32_t ID = -446535239;

  using ReturnType = object_ptr<receivedGift>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class receivedGifts;

class getReceivedGifts final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string business_connection_id_;
  object_ptr<MessageSender> owner_id_;
  bool exclude_unsaved_;
  bool exclude_saved_;
  bool exclude_unlimited_;
  bool exclude_limited_;
  bool exclude_upgraded_;
  bool sort_by_price_;
  string offset_;
  int32 limit_;

  getReceivedGifts();

  getReceivedGifts(string const &business_connection_id_, object_ptr<MessageSender> &&owner_id_, bool exclude_unsaved_, bool exclude_saved_, bool exclude_unlimited_, bool exclude_limited_, bool exclude_upgraded_, bool sort_by_price_, string const &offset_, int32 limit_);

  static const std::int32_t ID = -586538672;

  using ReturnType = object_ptr<receivedGifts>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatuses;

class getRecentEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getRecentEmojiStatuses();

  static const std::int32_t ID = -1371914967;

  using ReturnType = object_ptr<emojiStatuses>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class users;

class getRecentInlineBots final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getRecentInlineBots();

  static const std::int32_t ID = 1437823548;

  using ReturnType = object_ptr<users>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickers;

class getRecentStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool is_attached_;

  getRecentStickers();

  explicit getRecentStickers(bool is_attached_);

  static const std::int32_t ID = -579622241;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getRecentlyOpenedChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 limit_;

  getRecentlyOpenedChats();

  explicit getRecentlyOpenedChats(int32 limit_);

  static const std::int32_t ID = -1924156893;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class tMeUrls;

class getRecentlyVisitedTMeUrls final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string referrer_;

  getRecentlyVisitedTMeUrls();

  explicit getRecentlyVisitedTMeUrls(string const &referrer_);

  static const std::int32_t ID = 806754961;

  using ReturnType = object_ptr<tMeUrls>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class recommendedChatFolders;

class getRecommendedChatFolders final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getRecommendedChatFolders();

  static const std::int32_t ID = -145540217;

  using ReturnType = object_ptr<recommendedChatFolders>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getRecommendedChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getRecommendedChats();

  static const std::int32_t ID = -649884303;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class recoveryEmailAddress;

class getRecoveryEmailAddress final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string password_;

  getRecoveryEmailAddress();

  explicit getRecoveryEmailAddress(string const &password_);

  static const std::int32_t ID = -1594770947;

  using ReturnType = object_ptr<recoveryEmailAddress>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class FileType;

class file;

class getRemoteFile final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string remote_file_id_;
  object_ptr<FileType> file_type_;

  getRemoteFile();

  getRemoteFile(string const &remote_file_id_, object_ptr<FileType> &&file_type_);

  static const std::int32_t ID = 2137204530;

  using ReturnType = object_ptr<file>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class getRepliedMessage final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int53 message_id_;

  getRepliedMessage();

  getRepliedMessage(int53 chat_id_, int53 message_id_);

  static const std::int32_t ID = -641918531;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class animations;

class getSavedAnimations final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getSavedAnimations();

  static const std::int32_t ID = 7051032;

  using ReturnType = object_ptr<animations>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class savedMessagesTags;

class getSavedMessagesTags final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 saved_messages_topic_id_;

  getSavedMessagesTags();

  explicit getSavedMessagesTags(int53 saved_messages_topic_id_);

  static const std::int32_t ID = -1932105815;

  using ReturnType = object_ptr<savedMessagesTags>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class messages;

class getSavedMessagesTopicHistory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 saved_messages_topic_id_;
  int53 from_message_id_;
  int32 offset_;
  int32 limit_;

  getSavedMessagesTopicHistory();

  getSavedMessagesTopicHistory(int53 saved_messages_topic_id_, int53 from_message_id_, int32 offset_, int32 limit_);

  static const std::int32_t ID = 2011552360;

  using ReturnType = object_ptr<messages>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class message;

class getSavedMessagesTopicMessageByDate final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 saved_messages_topic_id_;
  int32 date_;

  getSavedMessagesTopicMessageByDate();

  getSavedMessagesTopicMessageByDate(int53 saved_messages_topic_id_, int32 date_);

  static const std::int32_t ID = -1050786176;

  using ReturnType = object_ptr<message>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationSounds;

class getSavedNotificationSound final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 notification_sound_id_;

  getSavedNotificationSound();

  explicit getSavedNotificationSound(int64 notification_sound_id_);

  static const std::int32_t ID = 459569431;

  using ReturnType = object_ptr<notificationSounds>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class notificationSounds;

class getSavedNotificationSounds final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getSavedNotificationSounds();

  static const std::int32_t ID = -1070305368;

  using ReturnType = object_ptr<notificationSounds>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class orderInfo;

class getSavedOrderInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getSavedOrderInfo();

  static const std::int32_t ID = -1152016675;

  using ReturnType = object_ptr<orderInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class NotificationSettingsScope;

class scopeNotificationSettings;

class getScopeNotificationSettings final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<NotificationSettingsScope> scope_;

  getScopeNotificationSettings();

  explicit getScopeNotificationSettings(object_ptr<NotificationSettingsScope> &&scope_);

  static const std::int32_t ID = -995613361;

  using ReturnType = object_ptr<scopeNotificationSettings>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class sponsoredChats;

class getSearchSponsoredChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string query_;

  getSearchSponsoredChats();

  explicit getSearchSponsoredChats(string const &query_);

  static const std::int32_t ID = 1568505164;

  using ReturnType = object_ptr<sponsoredChats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class hashtags;

class getSearchedForTags final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string tag_prefix_;
  int32 limit_;

  getSearchedForTags();

  getSearchedForTags(string const &tag_prefix_, int32 limit_);

  static const std::int32_t ID = -1692716851;

  using ReturnType = object_ptr<hashtags>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class secretChat;

class getSecretChat final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 secret_chat_id_;

  getSecretChat();

  explicit getSecretChat(int32 secret_chat_id_);

  static const std::int32_t ID = 40599169;

  using ReturnType = object_ptr<secretChat>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class httpUrl;

class getStarAdAccountUrl final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> owner_id_;

  getStarAdAccountUrl();

  explicit getStarAdAccountUrl(object_ptr<MessageSender> &&owner_id_);

  static const std::int32_t ID = 1940473181;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starPaymentOptions;

class getStarGiftPaymentOptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 user_id_;

  getStarGiftPaymentOptions();

  explicit getStarGiftPaymentOptions(int53 user_id_);

  static const std::int32_t ID = -500735773;

  using ReturnType = object_ptr<starPaymentOptions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starGiveawayPaymentOptions;

class getStarGiveawayPaymentOptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getStarGiveawayPaymentOptions();

  static const std::int32_t ID = -883172578;

  using ReturnType = object_ptr<starGiveawayPaymentOptions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starPaymentOptions;

class getStarPaymentOptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getStarPaymentOptions();

  static const std::int32_t ID = 1838351940;

  using ReturnType = object_ptr<starPaymentOptions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class starRevenueStatistics;

class getStarRevenueStatistics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> owner_id_;
  bool is_dark_;

  getStarRevenueStatistics();

  getStarRevenueStatistics(object_ptr<MessageSender> &&owner_id_, bool is_dark_);

  static const std::int32_t ID = -260356841;

  using ReturnType = object_ptr<starRevenueStatistics>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class starSubscriptions;

class getStarSubscriptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  bool only_expiring_;
  string offset_;

  getStarSubscriptions();

  getStarSubscriptions(bool only_expiring_, string const &offset_);

  static const std::int32_t ID = -641223956;

  using ReturnType = object_ptr<starSubscriptions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class StarTransactionDirection;

class starTransactions;

class getStarTransactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> owner_id_;
  string subscription_id_;
  object_ptr<StarTransactionDirection> direction_;
  string offset_;
  int32 limit_;

  getStarTransactions();

  getStarTransactions(object_ptr<MessageSender> &&owner_id_, string const &subscription_id_, object_ptr<StarTransactionDirection> &&direction_, string const &offset_, int32 limit_);

  static const std::int32_t ID = -258541327;

  using ReturnType = object_ptr<starTransactions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class MessageSender;

class httpUrl;

class getStarWithdrawalUrl final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<MessageSender> owner_id_;
  int53 star_count_;
  string password_;

  getStarWithdrawalUrl();

  getStarWithdrawalUrl(object_ptr<MessageSender> &&owner_id_, int53 star_count_, string const &password_);

  static const std::int32_t ID = -1445841134;

  using ReturnType = object_ptr<httpUrl>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StatisticalGraph;

class getStatisticalGraph final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  string token_;
  int53 x_;

  getStatisticalGraph();

  getStatisticalGraph(int53 chat_id_, string const &token_, int53 x_);

  static const std::int32_t ID = 1100975515;

  using ReturnType = object_ptr<StatisticalGraph>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class InputFile;

class emojis;

class getStickerEmojis final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<InputFile> sticker_;

  getStickerEmojis();

  explicit getStickerEmojis(object_ptr<InputFile> &&sticker_);

  static const std::int32_t ID = -1895508665;

  using ReturnType = object_ptr<emojis>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class outline;

class getStickerOutline final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 sticker_file_id_;
  bool for_animated_emoji_;
  bool for_clicked_animated_emoji_message_;

  getStickerOutline();

  getStickerOutline(int32 sticker_file_id_, bool for_animated_emoji_, bool for_clicked_animated_emoji_message_);

  static const std::int32_t ID = -1550504539;

  using ReturnType = object_ptr<outline>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class stickerSet;

class getStickerSet final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 set_id_;

  getStickerSet();

  explicit getStickerSet(int64 set_id_);

  static const std::int32_t ID = 1052318659;

  using ReturnType = object_ptr<stickerSet>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getStickerSetName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int64 set_id_;

  getStickerSetName();

  explicit getStickerSetName(int64 set_id_);

  static const std::int32_t ID = 1039849089;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class StickerType;

class stickers;

class getStickers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<StickerType> sticker_type_;
  string query_;
  int32 limit_;
  int53 chat_id_;

  getStickers();

  getStickers(object_ptr<StickerType> &&sticker_type_, string const &query_, int32 limit_, int53 chat_id_);

  static const std::int32_t ID = 1158058819;

  using ReturnType = object_ptr<stickers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storageStatistics;

class getStorageStatistics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 chat_limit_;

  getStorageStatistics();

  explicit getStorageStatistics(int32 chat_limit_);

  static const std::int32_t ID = -853193929;

  using ReturnType = object_ptr<storageStatistics>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storageStatisticsFast;

class getStorageStatisticsFast final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getStorageStatisticsFast();

  static const std::int32_t ID = 61368066;

  using ReturnType = object_ptr<storageStatisticsFast>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class story;

class getStory final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;
  bool only_local_;

  getStory();

  getStory(int53 story_poster_chat_id_, int32 story_id_, bool only_local_);

  static const std::int32_t ID = -2011076366;

  using ReturnType = object_ptr<story>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class availableReactions;

class getStoryAvailableReactions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 row_size_;

  getStoryAvailableReactions();

  explicit getStoryAvailableReactions(int32 row_size_);

  static const std::int32_t ID = 595938619;

  using ReturnType = object_ptr<availableReactions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyInteractions;

class getStoryInteractions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 story_id_;
  string query_;
  bool only_contacts_;
  bool prefer_forwards_;
  bool prefer_with_reaction_;
  string offset_;
  int32 limit_;

  getStoryInteractions();

  getStoryInteractions(int32 story_id_, string const &query_, bool only_contacts_, bool prefer_forwards_, bool prefer_with_reaction_, string const &offset_, int32 limit_);

  static const std::int32_t ID = 483475469;

  using ReturnType = object_ptr<storyInteractions>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getStoryNotificationSettingsExceptions final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getStoryNotificationSettingsExceptions();

  static const std::int32_t ID = 627715760;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class publicForwards;

class getStoryPublicForwards final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 story_poster_chat_id_;
  int32 story_id_;
  string offset_;
  int32 limit_;

  getStoryPublicForwards();

  getStoryPublicForwards(int53 story_poster_chat_id_, int32 story_id_, string const &offset_, int32 limit_);

  static const std::int32_t ID = 1810378546;

  using ReturnType = object_ptr<publicForwards>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class storyStatistics;

class getStoryStatistics final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 chat_id_;
  int32 story_id_;
  bool is_dark_;

  getStoryStatistics();

  getStoryStatistics(int53 chat_id_, int32 story_id_, bool is_dark_);

  static const std::int32_t ID = 982926146;

  using ReturnType = object_ptr<storyStatistics>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getSuggestedFileName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int32 file_id_;
  string directory_;

  getSuggestedFileName();

  getSuggestedFileName(int32 file_id_, string const &directory_);

  static const std::int32_t ID = -2049399674;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getSuggestedStickerSetName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string title_;

  getSuggestedStickerSetName();

  explicit getSuggestedStickerSetName(string const &title_);

  static const std::int32_t ID = -1340995520;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getSuitableDiscussionChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getSuitableDiscussionChats();

  static const std::int32_t ID = 49044982;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class chats;

class getSuitablePersonalChats final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getSuitablePersonalChats();

  static const std::int32_t ID = -1870357515;

  using ReturnType = object_ptr<chats>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class supergroup;

class getSupergroup final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;

  getSupergroup();

  explicit getSupergroup(int53 supergroup_id_);

  static const std::int32_t ID = 989663458;

  using ReturnType = object_ptr<supergroup>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class supergroupFullInfo;

class getSupergroupFullInfo final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;

  getSupergroupFullInfo();

  explicit getSupergroupFullInfo(int53 supergroup_id_);

  static const std::int32_t ID = 1099776056;

  using ReturnType = object_ptr<supergroupFullInfo>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class SupergroupMembersFilter;

class chatMembers;

class getSupergroupMembers final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  int53 supergroup_id_;
  object_ptr<SupergroupMembersFilter> filter_;
  int32 offset_;
  int32 limit_;

  getSupergroupMembers();

  getSupergroupMembers(int53 supergroup_id_, object_ptr<SupergroupMembersFilter> &&filter_, int32 offset_, int32 limit_);

  static const std::int32_t ID = -570940984;

  using ReturnType = object_ptr<chatMembers>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class getSupportName final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getSupportName();

  static const std::int32_t ID = 1302205794;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class user;

class getSupportUser final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getSupportUser();

  static const std::int32_t ID = -1733497700;

  using ReturnType = object_ptr<user>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class temporaryPasswordState;

class getTemporaryPasswordState final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getTemporaryPasswordState();

  static const std::int32_t ID = -12670830;

  using ReturnType = object_ptr<temporaryPasswordState>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class textEntities;

class getTextEntities final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  string text_;

  getTextEntities();

  explicit getTextEntities(string const &text_);

  static const std::int32_t ID = -341490693;

  using ReturnType = object_ptr<textEntities>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class text;

class themeParameters;

class getThemeParametersJsonString final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:
  object_ptr<themeParameters> theme_;

  getThemeParametersJsonString();

  explicit getThemeParametersJsonString(object_ptr<themeParameters> &&theme_);

  static const std::int32_t ID = -1850145288;

  using ReturnType = object_ptr<text>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatusCustomEmojis;

class getThemedChatEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getThemedChatEmojiStatuses();

  static const std::int32_t ID = 1924568314;

  using ReturnType = object_ptr<emojiStatusCustomEmojis>;

  void store(TlStorerToString &s, const char *field_name) const final;
};

class emojiStatusCustomEmojis;

class getThemedEmojiStatuses final : public Function {
  std::int32_t get_id() const final {
    return ID;
  }

 public:

  getThemedEmojiStatuses();

  static const std::int32_t ID = -1468220543;

  using ReturnType = object_ptr<emojiStatusCustomEmojis>;

  void store