import UIKit
import Display

private let colorPairs: [(UInt32, UInt32)] = [
    (0xbdc3c7, 0x2c3e50),
    (0xee9ca7, 0xffdde1),
    (0x2193b0, 0x6dd5ed),
    (0xb92b27, 0x1565c0),
    (0x373b44, 0x4286f4),
    (0xff0099, 0x493240),
    (0x8e2de2, 0x4a00e0),
    (0x1f4037, 0x99f2c8),
    (0xf953c6, 0xb91d73),
    (0xc31432, 0x240b36),
    (0xf12711, 0xf5af19),
    (0x659999, 0xf4791f),
    (0xdd3e54, 0x6be585),
    (0x8360c3, 0x2ebf91),
    (0x544a7d, 0xffd452),
    (0x009fff, 0xec2f4b),
    (0x654ea3, 0xeaafc8),
    (0xa8ff78, 0x78ffd6),
    (0xed213a, 0x93291e),
    (0xfdc830, 0xf37335),
    (0x00b4db, 0x0083b0),
    (0xffefba, 0xffffff),
    (0x005aa7, 0xfffde4),
    (0xda4453, 0x89216b),
    (0x636363, 0xa2ab58),
    (0xad5389, 0x3c1053),
    (0xa8c0ff, 0x3f2b96),
    (0x333333, 0xdd1818),
    (0x4e54c8, 0x8f94fb),
    (0xbc4e9c, 0xf80759),
    (0x3e5151, 0xdecba4),
    (0x11998e, 0x38ef7d),
    (0x108dc7, 0xef8e38),
    (0xfc5c7d, 0x6a82fb),
    (0xfc466b, 0x3f5efb),
    (0xc94b4b, 0x4b134f),
    (0x23074d, 0xcc5333),
    (0xfffbd5, 0xb20a2c),
    (0x00b09b, 0x96c93d),
    (0xd3cce3, 0xe9e4f0),
    (0x3c3b3f, 0x605c3c),
    (0xcac531, 0xf3f9a7),
    (0x800080, 0xffc0cb),
    (0x00f260, 0x0575e6),
    (0xfc4a1a, 0xf7b733),
    (0x74ebd5, 0xacb6e5),
    (0x6d6027, 0xd3cbb8),
    (0xe1eec3, 0xf05053),
    (0x22c1c3, 0xfdbb2d),
    (0xff9966, 0xff5e62),
    (0x7f00ff, 0xe100ff),
    (0xc9d6ff, 0xe2e2e2),
    (0x396afc, 0x2948ff),
    (0xd9a7c7, 0xfffcdc),
    (0x642b73, 0xc6426e),
    (0x1c92d2, 0xf2fcfe),
    (0x000000, 0x0f9b0f),
    (0x36d1dc, 0x5b86e5),
    (0xcb356b, 0xbd3f32),
    (0x283c86, 0x45a247),
    (0xef3b36, 0xffffff),
    (0xc0392b, 0x8e44ad),
    (0x159957, 0x155799),
    (0x000046, 0x1cb5e0),
    (0x007991, 0x78ffd6),
    (0x56ccf2, 0x2f80ed),
    (0xf2994a, 0xf2c94c),
    (0xeb5757, 0x000000),
    (0xe44d26, 0xf16529),
    (0x4ac29a, 0xbdfff3),
    (0xb2fefa, 0x0ed2f7),
    (0x30e8bf, 0xff8235),
    (0xd66d75, 0xe29587),
    (0x20002c, 0xcbb4d4),
    (0xc33764, 0x1d2671),
    (0xf7971e, 0xffd200),
    (0x34e89e, 0x0f3443),
    (0x6190e8, 0xa7bfe8),
    (0x44a08d, 0x093637),
    (0x200122, 0x6f0000),
    (0x0575e6, 0x021b79),
    (0x4568dc, 0xb06ab3),
    (0x43c6ac, 0x191654),
    (0x093028, 0x237a57),
    (0x43c6ac, 0xf8ffae),
    (0xffafbd, 0xffc3a0),
    (0xf0f2f0, 0x000c40),
    (0xe8cbc0, 0x636fa4),
    (0xdce35b, 0x45b649),
    (0xc0c0aa, 0x1cefff),
    (0xdbe6f6, 0xc5796d),
    (0x3494e6, 0xec6ead),
    (0x67b26f, 0x4ca2cd),
    (0xf3904f, 0x3b4371),
    (0xee0979, 0xff6a00),
    (0x41295a, 0x2f0743),
    (0xf4c4f3, 0xfc67fa),
    (0x00c3ff, 0xffff1c),
    (0xff7e5f, 0xfeb47b),
    (0xfffc00, 0xffffff),
    (0xff00cc, 0x333399),
    (0xde6161, 0x2657eb),
    (0xef32d9, 0x89fffd),
    (0x3a6186, 0x89253e),
    (0x4ecdc4, 0x556270),
    (0xa1ffce, 0xfaffd1),
    (0xbe93c5, 0x7bc6cc),
    (0xbdc3c7, 0x2c3e50),
    (0xffd89b, 0x19547b),
    (0x808080, 0x3fada8),
    (0xfceabb, 0xf8b500),
    (0xf85032, 0xe73827),
    (0xf79d00, 0x64f38c),
    (0x56ab2f, 0xa8e063),
    (0x000428, 0x004e92),
    (0x42275a, 0x734b6d),
    (0x141e30, 0x243b55),
    (0x2c3e50, 0xfd746c),
    (0x2c3e50, 0x4ca1af),
    (0xe96443, 0x904e95),
    (0x0b486b, 0xf56217),
    (0x3a7bd5, 0x3a6073),
    (0x00d2ff, 0x928dab),
    (0x2196f3, 0xf44336),
    (0xff5f6d, 0xffc371),
    (0xff4b1f, 0xff9068),
    (0x16bffd, 0xcb3066),
    (0xeecda3, 0xef629f),
    (0x1d4350, 0xa43931),
    (0xf7ff00, 0xdb36a4),
    (0xff4b1f, 0x1fddff),
    (0xba5370, 0xf4e2d8),
    (0x4ca1af, 0xc4e0e5),
    (0x000000, 0x434343),
    (0x4b79a1, 0x283e51),
    (0x834d9b, 0xd04ed6),
    (0x0099f7, 0xf11712),
    (0x2980b9, 0x2c3e50),
    (0x5a3f37, 0x2c7744),
    (0x4da0b0, 0xd39d38),
    (0x5614b0, 0xdbd65c),
    (0x2f7336, 0xaa3a38),
    (0x1e3c72, 0x2a5298),
    (0x114357, 0xf29492),
    (0xfd746c, 0xff9068),
    (0xeacda3, 0xd6ae7b),
    (0x6a3093, 0xa044ff),
    (0x457fca, 0x5691c8),
    (0xb24592, 0xf15f79),
    (0xc02425, 0xf0cb35),
    (0x403a3e, 0xbe5869),
    (0xc2e59c, 0x64b3f4),
    (0xffb75e, 0xed8f03),
    (0x8e0e00, 0x1f1c18),
    (0x76b852, 0x8dc26f),
    (0x673ab7, 0x512da8),
    (0x00c9ff, 0x92fe9d),
    (0xf46b45, 0xeea849),
    (0x005c97, 0x363795),
    (0xe53935, 0xe35d5b),
    (0xfc00ff, 0x00dbde),
    (0x2c3e50, 0x3498db),
    (0xccccb2, 0x757519),
    (0x304352, 0xd7d2cc),
    (0xee9ca7, 0xffdde1),
    (0xba8b02, 0x181818),
    (0x525252, 0x3d72b4),
    (0x004ff9, 0xfff94c),
    (0x6a9113, 0x141517),
    (0xf1f2b5, 0x135058),
    (0xd1913c, 0xffd194),
    (0x7b4397, 0xdc2430),
    (0x8e9eab, 0xeef2f3),
    (0x136a8a, 0x267871),
    (0x00bf8f, 0x001510),
    (0xff0084, 0x33001b),
    (0x6441a5, 0x2a0845),
    (0xffb347, 0xffcc33),
    (0x43cea2, 0x185a9d),
    (0xffa17f, 0x00223e),
    (0x360033, 0x0b8793),
    (0x948e99, 0x2e1437),
    (0x1e130c, 0x9a8478),
    (0xd38312, 0xa83279),
    (0x73c8a9, 0x373b44),
    (0xabbaab, 0xffffff),
    (0xfdfc47, 0x24fe41),
    (0x83a4d4, 0xb6fbff),
    (0x485563, 0x29323c),
    (0x52c234, 0x061700),
    (0xfe8c00, 0xf83600),
    (0x00c6ff, 0x0072ff),
    (0x70e1f5, 0xffd194),
    (0x556270, 0xff6b6b),
    (0x9d50bb, 0x6e48aa),
    (0x780206, 0x061161),
    (0xb3ffab, 0x12fff7),
    (0xaaffa9, 0x11ffbd),
    (0x000000, 0xe74c3c),
    (0xf0c27b, 0x4b1248),
    (0xff4e50, 0xf9d423),
    (0xadd100, 0x7b920a),
    (0xfbd3e9, 0xbb377d),
    (0x606c88, 0x3f4c6b),
    (0xc9ffbf, 0xffafbd),
    (0x649173, 0xdbd5a4),
    (0xb993d6, 0x8ca6db),
    (0x870000, 0x190a05),
    (0x00d2ff, 0x3a7bd5),
    (0xd3959b, 0xbfe6ba),
    (0xdad299, 0xb0dab9),
    (0xf2709c, 0xff9472),
    (0xe6dada, 0x274046),
    (0x5d4157, 0xa8caba),
    (0xddd6f3, 0xfaaca8),
    (0x616161, 0x9bc5c3),
    (0x50c9c3, 0x96deda),
    (0x215f00, 0xe4e4d9),
    (0xc21500, 0xffc500),
    (0xefefbb, 0xd4d3dd),
    (0xffeeee, 0xddefbb),
    (0x666600, 0x999966),
    (0xde6262, 0xffb88c),
    (0xe9d362, 0x333333),
    (0xd53369, 0xcbad6d),
    (0xa73737, 0x7a2828),
    (0xf857a6, 0xff5858),
    (0x4b6cb7, 0x182848),
    (0xfc354c, 0x0abfbc),
    (0x414d0b, 0x727a17),
    (0xe43a15, 0xe65245),
    (0xc04848, 0x480048),
    (0x5f2c82, 0x49a09d),
    (0xec6f66, 0xf3a183),
    (0x7474bf, 0x348ac7),
    (0xece9e6, 0xffffff),
    (0xdae2f8, 0xd6a4a4),
    (0xed4264, 0xffedbc),
    (0xdc2424, 0x4a569d),
    (0x24c6dc, 0x514a9d),
    (0x283048, 0x859398),
    (0x3d7eaa, 0xffe47a),
    (0x1cd8d2, 0x93edc7),
    (0x232526, 0x414345),
    (0x757f9a, 0xd7dde8),
    (0x5c258d, 0x4389a2),
    (0x134e5e, 0x71b280),
    (0x2bc0e4, 0xeaecc6),
    (0x085078, 0x85d8ce),
    (0x4776e6, 0x8e54e9),
    (0x614385, 0x516395),
    (0x1f1c2c, 0x928dab),
    (0x16222a, 0x3a6073),
    (0xff8008, 0xffc837),
    (0x1d976c, 0x93f9b9),
    (0xeb3349, 0xf45c43),
    (0xdd5e89, 0xf7bb97),
    (0x4cb8c4, 0x3cd3ad),
    (0x1d2b64, 0xf8cdda),
    (0xff512f, 0xf09819),
    (0x1a2980, 0x26d0ce),
    (0xaa076b, 0x61045f),
    (0xff512f, 0xdd2476),
    (0xf09819, 0xedde5d),
    (0x403b4a, 0xe7e9bb),
    (0xe55d87, 0x5fc3e4),
    (0x003973, 0xe5e5be),
    (0x3ca55c, 0xb5ac49),
    (0x348f50, 0x56b4d3),
    (0xda22ff, 0x9733ee),
    (0xede574, 0xe1f5c4),
    (0xd31027, 0xea384d),
    (0x16a085, 0xf4d03f),
    (0x603813, 0xb29f94),
    (0xe52d27, 0xb31217),
    (0xff6e7f, 0xbfe9ff),
    (0x314755, 0x26a0da),
    (0x2b5876, 0x4e4376),
    (0xe65c00, 0xf9d423),
    (0x2193b0, 0x6dd5ed),
    (0xcc2b5e, 0x753a88),
    (0xec008c, 0xfc6767),
    (0x1488cc, 0x2b32b2),
    (0x00467f, 0xa5cc82),
    (0x076585, 0xffffff),
    (0xbbd2c5, 0x536976),
    (0x9796f0, 0xfbc7d4),
    (0xb79891, 0x94716b),
    (0x536976, 0x292e49),
    (0xacb6e5, 0x86fde8),
    (0xffe000, 0x799f0c),
    (0x00416a, 0xe4e5e6),
    (0xffe259, 0xffa751),
    (0x799f0c, 0xacbb78),
    (0x334d50, 0xcbcaa5),
    (0xf7f8f8, 0xacbb78),
    (0xffe000, 0x799f0c),
    (0x00416a, 0xe4e5e6)
]

public func generateGradientColors(color: UIColor) -> (UIColor, UIColor) {
    var nearest: (colors: (lhs: UInt32, rhs: UInt32), distance: Int32)?
    for (lhs, rhs) in colorPairs {
        let lhsDistance = color.distance(to: UIColor(rgb: lhs))
        let rhsDistance = color.distance(to: UIColor(rgb: rhs))
        if let currentNearest = nearest {
            if lhsDistance < currentNearest.distance || rhsDistance < currentNearest.distance {
                if lhsDistance < rhsDistance {
                    nearest = ((lhs, rhs), lhsDistance)
                } else {
                    nearest = ((rhs, lhs), rhsDistance)
                }
            }
        } else {
            if lhsDistance < rhsDistance {
                nearest = ((lhs, rhs), lhsDistance)
            } else {
                nearest = ((rhs, lhs), rhsDistance)
            }
        }
    }
    
    if let colors = nearest?.colors {
        let colorHsb = color.hsb
        let similarColorHsb = UIColor(rgb: colors.0).hsb
        let complementingColorHsb = UIColor(rgb: colors.1).hsb
        
        let correction = (similarColorHsb.0 > 0.0 ? colorHsb.0 / similarColorHsb.0 : 1.0, similarColorHsb.1 > 0.0 ? colorHsb.1 / similarColorHsb.1 : 1.0, similarColorHsb.2 > 0.0 ? colorHsb.2 / similarColorHsb.2 : 1.0)
        let correctedComplementingColor = UIColor(hue: min(1.0, complementingColorHsb.0 * correction.0), saturation: min(1.0, complementingColorHsb.1 * correction.1), brightness: min(1.0, complementingColorHsb.2 * correction.2), alpha: 1.0)
        return (color, correctedComplementingColor)
    } else {
        return (color, color)
    }
}
