//
//  STPBINRange.h
//  Stripe
//
//  Created by Jack Flintermann on 5/24/16.
//  Copyright © 2016 Stripe, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Stripe/STPCardBrand.h>

NS_ASSUME_NONNULL_BEGIN

@interface STPBINRange : NSObject

@property(nonatomic, readonly)NSUInteger length;
@property(nonatomic, readonly)STPCardBrand brand;

+ (NSArray<STPBINRange *> *)allRanges;
+ (NSArray<STPBINRange *> *)binRangesForNumber:(NSString *)number;
+ (NSArray<STPBINRange *> *)binRangesForBrand:(STPCardBrand)brand;
+ (instancetype)mostSpecificBINRangeForNumber:(NSString *)number;

@end

NS_ASSUME_NONNULL_END
