/*
 * Decompiled with CFR 0.152.
 */
package nicelee.memory.url;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class MemoryURLHandler
extends URLStreamHandler {
    private static Map<String, byte[]> memory = new LinkedHashMap<String, byte[]>();
    private static boolean allowAddSource = true;

    public static boolean addSource(String string, byte[] byArray) {
        if (allowAddSource) {
            if (memory.containsKey(string)) {
                return false;
            }
            memory.put(string, byArray);
            return true;
        }
        return false;
    }

    public static void lockMemory() {
        allowAddSource = false;
    }

    public static boolean memoryIsLocked() {
        return !allowAddSource;
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        return new MemoryURLConnection(uRL);
    }

    class MemoryURLConnection
    extends URLConnection {
        protected MemoryURLConnection(URL uRL) {
            super(uRL);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public String getContentType() {
            if (this.url.getPath().endsWith(".html")) {
                return "text/html; charset=UTF-8";
            }
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            String string = this.url.getPath().substring(1);
            boolean bl = "search".equals(this.url.getAuthority());
            for (byte[] byArray : memory.values()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                JarInputStream jarInputStream = new JarInputStream((InputStream)byteArrayInputStream, false);
                JarEntry jarEntry = jarInputStream.getNextJarEntry();
                while (jarEntry != null) {
                    if (!bl && jarEntry.getName().equals(string) || bl && jarEntry.getName().startsWith(string)) {
                        return jarInputStream;
                    }
                    jarEntry = jarInputStream.getNextJarEntry();
                }
                jarInputStream.close();
            }
            throw new IOException("No such resource in memory: " + string);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            throw new RuntimeException("Not Implemented");
        }
    }
}

