/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.thread;

import java.awt.Color;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nicelee.bilibili.downloaders.IDownloader;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.util.Logger;
import nicelee.ui.Audio;
import nicelee.ui.Global;
import nicelee.ui.item.DownloadInfoPanel;
import nicelee.ui.thread.BatchDownloadRbyRThread;

public class MonitoringThread
extends Thread {
    public MonitoringThread() {
        this.setName("Thread - Monitoring Download");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        ConcurrentHashMap<DownloadInfoPanel, IDownloader> concurrentHashMap = Global.downloadTaskList;
        Color color = new Color(153, 214, 92);
        Color color2 = new Color(255, 71, 10);
        Color color3 = new Color(255, 122, 122);
        Color color4 = new Color(255, 207, 61);
        if (Global.playSoundAfterMissionComplete) {
            Audio.init();
        }
        int n = 0;
        while (true) {
            int n2 = Global.maxFailRetry;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (Map.Entry<DownloadInfoPanel, IDownloader> entry : concurrentHashMap.entrySet()) {
                DownloadInfoPanel downloadInfoPanel = entry.getKey();
                IDownloader iDownloader = entry.getValue();
                String string = downloadInfoPanel.formattedTitle.replace("\\", "\\\\");
                try {
                    String string2;
                    File file = iDownloader.file();
                    if (file != null) {
                        string2 = file.getAbsolutePath();
                        if (Global.doRenameAfterComplete && iDownloader.currentStatus() == StatusEnum.SUCCESS) {
                            string2 = string2.replaceFirst("(?:av|h|cv|opus|BV|season|au|edd_)[0-9a-zA-Z_]+-[0-9]+-p[0-9]+", string);
                        }
                        downloadInfoPanel.getLbFileName().setText(string2);
                        downloadInfoPanel.getLbFileName().setToolTipText(string2);
                    }
                    switch (iDownloader.currentStatus()) {
                        case SUCCESS: {
                            ++n7;
                            if (downloadInfoPanel.getBackground() == color) break;
                            string2 = IDownloader.transToSizeStr(iDownloader.sumTotalFileSize());
                            downloadInfoPanel.getLbCurrentStatus().setText(this.genTips("%d/%d \u4e0b\u8f7d\u5b8c\u6210. ", iDownloader));
                            downloadInfoPanel.getLbDownFile().setText("\u6587\u4ef6\u5927\u5c0f: " + string2);
                            downloadInfoPanel.getBtnControl().setVisible(false);
                            downloadInfoPanel.setBackground(color);
                            BatchDownloadRbyRThread.taskSucceed(downloadInfoPanel.getClipInfo(), string, string2, "" + downloadInfoPanel.getRealqn());
                            break;
                        }
                        case FAIL: {
                            ++n5;
                            downloadInfoPanel.getLbDownFile().setText(this.genSizeCntStr("\u6587\u4ef6%d\u8fdb\u5ea6\uff1a %s/%s", iDownloader));
                            if (downloadInfoPanel.getFailCnt() == n2) {
                                if (!downloadInfoPanel.getLbCurrentStatus().getText().endsWith("\u4e0b\u8f7d\u5f02\u5e38. ")) {
                                    downloadInfoPanel.getLbCurrentStatus().setText(this.genTips("%d/%d \u4e0b\u8f7d\u5f02\u5e38. ", iDownloader));
                                    downloadInfoPanel.getBtnControl().setText("\u7ee7\u7eed\u4e0b\u8f7d");
                                    downloadInfoPanel.getBtnControl().setVisible(true);
                                    BatchDownloadRbyRThread.taskFail(downloadInfoPanel.getClipInfo(), "fail");
                                }
                            } else {
                                ++n6;
                                downloadInfoPanel.getLbCurrentStatus().setText(String.format("\u4e0b\u8f7d\u5f02\u5e38. \u5c1d\u8bd5\u91cd\u8fde %d ", downloadInfoPanel.getFailCnt()));
                                downloadInfoPanel.setFailCnt(downloadInfoPanel.getFailCnt() + 1);
                                downloadInfoPanel.continueTask();
                            }
                            downloadInfoPanel.setBackground(color2);
                            break;
                        }
                        case STOP: {
                            ++n5;
                            downloadInfoPanel.getLbCurrentStatus().setText(this.genTips("%d/%d \u4eba\u5de5\u505c\u6b62. ", iDownloader));
                            downloadInfoPanel.getLbDownFile().setText(this.genSizeCntStr("\u6587\u4ef6%d\u8fdb\u5ea6\uff1a %s/%s", iDownloader));
                            downloadInfoPanel.getBtnControl().setText("\u7ee7\u7eed\u4e0b\u8f7d");
                            downloadInfoPanel.getBtnControl().setVisible(true);
                            if (downloadInfoPanel.getBackground() == color || downloadInfoPanel.getBackground() == color3) break;
                            BatchDownloadRbyRThread.taskFail(downloadInfoPanel.getClipInfo(), "stop");
                            downloadInfoPanel.setBackground(color3);
                            break;
                        }
                        case PROCESSING: {
                            ++n4;
                            downloadInfoPanel.getLbCurrentStatus().setText(this.genTips("%d/%d \u8f6c\u7801\u4e2d... ", iDownloader));
                            downloadInfoPanel.getLbDownFile().setText("\u6587\u4ef6\u5927\u5c0f: " + IDownloader.transToSizeStr(iDownloader.sumTotalFileSize()));
                            downloadInfoPanel.setBackground(color4);
                            downloadInfoPanel.setBackground(null);
                            Logger.println("\u8f6c\u7801\u4e2d\u3002\u3002\u3002");
                            break;
                        }
                        case NONE: {
                            if (downloadInfoPanel.stopOnQueue) {
                                ++n5;
                                downloadInfoPanel.getLbCurrentStatus().setText(this.genTips("%d/%d \u4eba\u5de5\u505c\u6b62. ", iDownloader));
                                downloadInfoPanel.getLbDownFile().setText(this.genSizeCntStr("\u6587\u4ef6%d\u8fdb\u5ea6\uff1a %s/%s", iDownloader));
                                downloadInfoPanel.getBtnControl().setText("\u7ee7\u7eed\u4e0b\u8f7d");
                                downloadInfoPanel.getBtnControl().setVisible(true);
                                if (downloadInfoPanel.getBackground() == color || downloadInfoPanel.getBackground() == color3) break;
                                BatchDownloadRbyRThread.taskFail(downloadInfoPanel.getClipInfo(), "stop");
                                downloadInfoPanel.setBackground(color3);
                                break;
                            }
                            ++n8;
                            downloadInfoPanel.getLbCurrentStatus().setText("\u7b49\u5f85\u4e0b\u8f7d\u4e2d..");
                            downloadInfoPanel.getLbDownFile().setText("\u7b49\u5f85\u4e0b\u8f7d\u4e2d..");
                            downloadInfoPanel.getBtnControl().setText("\u6682\u505c");
                            downloadInfoPanel.getBtnControl().setVisible(false);
                            downloadInfoPanel.setBackground(color4);
                            break;
                        }
                        case DOWNLOADING: {
                            ++n4;
                            long l = System.currentTimeMillis();
                            int n9 = (int)(l - downloadInfoPanel.getLastCntTime());
                            int n10 = (int)(iDownloader.sumDownloadedFileSize() - downloadInfoPanel.getLastCnt());
                            int n11 = n10 / n9;
                            downloadInfoPanel.setLastCnt(iDownloader.sumDownloadedFileSize());
                            downloadInfoPanel.setLastCntTime(l);
                            String string3 = String.format("%d/%d \u6b63\u5728\u4e0b\u8f7d\u4e2d... %d kB/s", iDownloader.currentTask(), iDownloader.totalTaskCount(), n11);
                            downloadInfoPanel.getLbCurrentStatus().setText(string3);
                            downloadInfoPanel.getLbDownFile().setText(this.genSizeCntStr("\u6587\u4ef6%d\u8fdb\u5ea6\uff1a %s/%s", iDownloader));
                            downloadInfoPanel.getBtnControl().setText("\u6682\u505c");
                            downloadInfoPanel.getBtnControl().setVisible(true);
                            downloadInfoPanel.setBackground(null);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    if (iDownloader.currentStatus() == StatusEnum.STOP) {
                        ++n5;
                        downloadInfoPanel.getLbCurrentStatus().setText("\u4efb\u52a1\u53d6\u6d88");
                        downloadInfoPanel.getLbDownFile().setText("\u4efb\u52a1\u53d6\u6d88");
                        downloadInfoPanel.getBtnControl().setText("\u7ee7\u7eed\u4e0b\u8f7d");
                        downloadInfoPanel.getBtnControl().setVisible(true);
                        if (downloadInfoPanel.getBackground() == color || downloadInfoPanel.getBackground() == color3) continue;
                        BatchDownloadRbyRThread.taskFail(downloadInfoPanel.getClipInfo(), "stop");
                        downloadInfoPanel.setBackground(color3);
                        continue;
                    }
                    if (iDownloader.currentStatus() == StatusEnum.PROCESSING) {
                        ++n4;
                        downloadInfoPanel.getLbCurrentStatus().setText(this.genTips("%d/%d \u8f6c\u7801\u4e2d... ", iDownloader));
                        downloadInfoPanel.getLbDownFile().setText("\u6587\u4ef6\u5927\u5c0f: " + IDownloader.transToSizeStr(iDownloader.sumTotalFileSize()));
                        downloadInfoPanel.setBackground(color4);
                        downloadInfoPanel.setBackground(null);
                        Logger.println("\u8f6c\u7801\u4e2d\u3002\u3002\u3002");
                        continue;
                    }
                    if (downloadInfoPanel.stopOnQueue) {
                        ++n5;
                        downloadInfoPanel.getLbCurrentStatus().setText(this.genTips("%d/%d \u4eba\u5de5\u505c\u6b62. ", iDownloader));
                        downloadInfoPanel.getLbDownFile().setText(this.genSizeCntStr("\u6587\u4ef6%d\u8fdb\u5ea6\uff1a %s/%s", iDownloader));
                        downloadInfoPanel.getBtnControl().setText("\u7ee7\u7eed\u4e0b\u8f7d");
                        downloadInfoPanel.getBtnControl().setVisible(true);
                        if (downloadInfoPanel.getBackground() == color || downloadInfoPanel.getBackground() == color3) continue;
                        BatchDownloadRbyRThread.taskFail(downloadInfoPanel.getClipInfo(), "stop");
                        downloadInfoPanel.setBackground(color3);
                        continue;
                    }
                    ++n8;
                    downloadInfoPanel.getLbCurrentStatus().setText("\u7b49\u5f85\u4e0b\u8f7d\u4e2d..");
                    downloadInfoPanel.getLbDownFile().setText("\u7b49\u5f85\u4e0b\u8f7d\u4e2d..");
                    downloadInfoPanel.getBtnControl().setText("\u6682\u505c");
                    downloadInfoPanel.getBtnControl().setVisible(false);
                    downloadInfoPanel.setBackground(color4);
                }
            }
            n3 = concurrentHashMap.size();
            Global.downloadTab.refreshStatus(n3, n4 + n6, n5 - n6, n7, n8);
            if (Global.playSoundAfterMissionComplete && n > 0 && n4 == 0 && n6 == 0) {
                Audio.play();
            }
            n = n4;
            try {
                Thread.sleep(1500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    String genTips(String string, IDownloader iDownloader) {
        String string2 = String.format(string, iDownloader.currentTask(), iDownloader.totalTaskCount());
        return string2;
    }

    String genSizeCntStr(String string, IDownloader iDownloader) {
        String string2 = String.format(string, iDownloader.currentTask(), IDownloader.transToSizeStr(iDownloader.currentFileDownloadedSize()), IDownloader.transToSizeStr(iDownloader.currentFileTotalSize()));
        return string2;
    }
}

