/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.thread;

import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import nicelee.bilibili.INeedLogin;
import nicelee.bilibili.model.FavList;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.bilibili.util.Logger;
import nicelee.ui.DialogLogin;
import nicelee.ui.DialogSMSLogin;
import nicelee.ui.FrameQRCode;
import nicelee.ui.Global;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoginThread
extends Thread {
    @Override
    public void run() {
        try {
            this.login();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stopFrameWaiting();
        }
    }

    private void stopFrameWaiting() {
        if (Global.frWaiting != null) {
            Global.frWaiting.stop();
        }
    }

    public void login() {
        System.out.println("\u767b\u5f55\u7ebf\u7a0b\u88ab\u8c03\u7528...");
        INeedLogin iNeedLogin = new INeedLogin();
        if (Global.isLogin || !Global.needToLogin) {
            System.out.println("\u5df2\u7ecf\u767b\u5f55,\u6216\u6ca1\u6709\u53d1\u8d77\u767b\u5f55\u8bf7\u6c42");
            this.stopFrameWaiting();
            return;
        }
        String string = iNeedLogin.readCookies();
        if (string != null) {
            System.out.println("\u68c0\u67e5\u5230\u5b58\u5728\u672c\u5730Cookies...");
            Object object = HttpCookies.convertCookies(string);
            if (iNeedLogin.getLoginStatus((List<HttpCookie>)object)) {
                System.out.println("\u672c\u5730Cookies\u9a8c\u8bc1\u6709\u6548...");
                HttpCookies.setGlobalCookies((List<HttpCookie>)object);
                this.initUserInfo(iNeedLogin);
                System.out.println("\u6210\u529f\u767b\u5f55...");
                Global.isLogin = true;
                this.stopFrameWaiting();
                return;
            }
            System.out.println("\u672c\u5730Cookies\u9a8c\u8bc1\u65e0\u6548...");
            HttpCookies.setGlobalCookies(null);
        }
        System.out.println("\u6ca1\u6709\u68c0\u67e5\u5230\u672c\u5730Cookies...");
        this.stopFrameWaiting();
        switch (Global.loginType) {
            case "pwd": {
                this.PwdLogin(iNeedLogin);
                break;
            }
            case "qr": {
                this.QRLogin(iNeedLogin);
                break;
            }
            case "sms": {
                DialogSMSLogin dialogSMSLogin = new DialogSMSLogin(iNeedLogin);
                dialogSMSLogin.init();
                break;
            }
            default: {
                this.QRLogin(iNeedLogin);
            }
        }
        Logger.println("\u7ebf\u7a0b\u5373\u5c06\u7ed3\u675f\uff0c\u5f53\u524d\u767b\u5f55\u72b6\u6001\uff1a " + Global.isLogin);
        if (Global.isLogin) {
            iNeedLogin.saveCookiesAndToken();
            HttpCookies.setGlobalCookies(iNeedLogin.iCookies);
            iNeedLogin.getLoginStatus(iNeedLogin.iCookies);
            this.initUserInfo(iNeedLogin);
            System.out.println("\u6210\u529f\u767b\u5f55...");
        } else {
            Global.needToLogin = true;
        }
    }

    private void PwdLogin(INeedLogin iNeedLogin) {
        DialogLogin dialogLogin = new DialogLogin(iNeedLogin);
        dialogLogin.init();
    }

    private void QRLogin(INeedLogin iNeedLogin) {
        System.out.println("\u6b63\u5728\u83b7\u53d6\u9a8c\u8bc1AuthKey\u4ee5\u751f\u6210\u4e8c\u7ef4\u7801...");
        String string = iNeedLogin.getAuthKey();
        System.out.println("authKey: " + string);
        FrameQRCode frameQRCode = new FrameQRCode(iNeedLogin.qrCodeStr);
        frameQRCode.initUI();
        long l = System.currentTimeMillis();
        while (!Global.isLogin && Global.needToLogin && System.currentTimeMillis() - l < 60000L) {
            try {
                Global.isLogin = iNeedLogin.getAuthStatus(string);
                System.out.println("------------");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        System.out.println("\u767b\u5f55\u7ebf\u7a0b\u7ed3\u675f...");
        frameQRCode.dispose();
    }

    public void initUserInfo(INeedLogin iNeedLogin) {
        Object object;
        Object object2;
        try {
            object2 = new URL(iNeedLogin.user.getPoster());
            object = new ImageIcon((URL)object2);
            object = new ImageIcon(((ImageIcon)object).getImage().getScaledInstance(80, 80, 1));
            Global.index.jlHeader.setToolTipText("\u5f53\u524d\u7528\u6237\u4e3a: " + iNeedLogin.user.getName());
            Global.index.jlHeader.setIcon((Icon)object);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        try {
            object2 = "https://api.bilibili.com/medialist/gateway/base/created?pn=1&ps=100&is_space=0&jsonp=jsonp&up_mid=" + iNeedLogin.user.getUid();
            object = new HttpRequestUtil();
            String string = ((HttpRequestUtil)object).getContent((String)object2, new HttpHeaders().getAllFavListHeaders(iNeedLogin.user.getUid()), HttpCookies.getGlobalCookies());
            JSONArray jSONArray = new JSONObject(string).getJSONObject("data").getJSONArray("list");
            if (Global.index.cmbFavList.getItemCount() == 1) {
                Global.index.cmbFavList.addItem("\u7a0d\u540e\u518d\u770b");
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    FavList favList = new FavList(jSONObject.getLong("mid"), jSONObject.getLong("id"), jSONObject.getInt("media_count"), jSONObject.getString("title"));
                    Global.index.cmbFavList.addItem(favList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

