/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.item;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.util.Logger;
import nicelee.ui.Global;
import nicelee.ui.TabVideo;
import nicelee.ui.thread.GetVideoDetailThread;

public class MJTabVideo
extends TabVideo {
    private static final long serialVersionUID = 10112L;
    private JPopupMenu pop = null;
    private JMenuItem closeAll = null;
    private JMenuItem closeRight = null;
    private JMenuItem closeLeft = null;
    private JMenuItem closeThis = null;
    private JMenuItem downloadAll = null;
    private JMenuItem downloadThis = null;
    private JLabel label = null;
    private JTabbedPane jTabbedpane = null;
    private String searchContent;

    public MJTabVideo(JTabbedPane jTabbedPane, JLabel jLabel, String string) {
        super(jLabel);
        this.searchContent = string;
        this.jTabbedpane = jTabbedPane;
        this.label = jLabel;
        this.initial();
    }

    public void initial() {
        this.pop = new JPopupMenu();
        this.closeThis = new JMenuItem("\u5173\u95ed\u6b64\u6807\u7b7e");
        this.pop.add(this.closeThis);
        this.closeAll = new JMenuItem("\u5173\u95ed\u6240\u6709\u6807\u7b7e");
        this.pop.add(this.closeAll);
        this.closeLeft = new JMenuItem("\u5173\u95ed\u5de6\u4fa7\u6807\u7b7e");
        this.pop.add(this.closeLeft);
        this.closeRight = new JMenuItem("\u5173\u95ed\u53f3\u4fa7\u6807\u7b7e");
        this.pop.add(this.closeRight);
        this.pop.addSeparator();
        this.downloadThis = new JMenuItem("\u6279\u91cf\u4e0b\u8f7d\u6b64\u6807\u7b7e");
        this.pop.add(this.downloadThis);
        this.downloadAll = new JMenuItem("\u6279\u91cf\u4e0b\u8f7d\u5168\u90e8\u6807\u7b7e");
        this.pop.add(this.downloadAll);
        this.closeThis.addActionListener(this);
        this.closeAll.addActionListener(this);
        this.closeRight.addActionListener(this);
        this.closeLeft.addActionListener(this);
        this.downloadThis.addActionListener(this);
        this.downloadAll.addActionListener(this);
        this.label.add(this.pop);
        this.label.addMouseListener(this);
        this.btnNextPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Pattern pattern = Pattern.compile("(.*)p=([0-9]+)$");
                int n = 1;
                String string = null;
                Matcher matcher = pattern.matcher(MJTabVideo.this.searchContent);
                if (matcher.find()) {
                    n = Integer.parseInt(matcher.group(2));
                    string = matcher.group(1) + "p=" + (n + 1);
                } else {
                    string = MJTabVideo.this.searchContent + " p=" + (n + 1);
                }
                Logger.println(string);
                JLabel jLabel = new JLabel("\u6b63\u5728\u52a0\u8f7d\u4e2d...");
                MJTabVideo mJTabVideo = new MJTabVideo(MJTabVideo.this.jTabbedpane, jLabel, string);
                MJTabVideo.this.jTabbedpane.addTab("\u4f5c\u54c1\u9875", mJTabVideo);
                MJTabVideo.this.jTabbedpane.setTabComponentAt(MJTabVideo.this.jTabbedpane.indexOfComponent(mJTabVideo), jLabel);
                GetVideoDetailThread getVideoDetailThread = new GetVideoDetailThread(mJTabVideo, string);
                getVideoDetailThread.start();
                MJTabVideo.this.jTabbedpane.setSelectedComponent(mJTabVideo);
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.label) {
            System.out.println("MJTab label\u7684\u70b9\u51fb\u4e8b\u4ef6");
            if (mouseEvent.getButton() == 1) {
                if (mouseEvent.getClickCount() >= 2) {
                    this.jTabbedpane.remove(this);
                } else {
                    this.jTabbedpane.setSelectedComponent(this);
                }
            }
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.label) {
            if (mouseEvent.getButton() == 3) {
                this.pop.show(this.label, mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this.label) {
            super.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this.label) {
            super.mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != this.label) {
            super.mouseExited(mouseEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeThis) {
            this.jTabbedpane.remove(this);
        } else if (actionEvent.getSource() == this.closeAll) {
            for (int i = this.jTabbedpane.getTabCount() - 1; i >= 2; --i) {
                this.jTabbedpane.removeTabAt(i);
            }
        } else if (actionEvent.getSource() == this.closeLeft) {
            int n = this.jTabbedpane.indexOfComponent(this);
            for (int i = 0; i < n - 2; ++i) {
                this.jTabbedpane.removeTabAt(2);
            }
        } else if (actionEvent.getSource() == this.closeRight) {
            int n = this.jTabbedpane.indexOfComponent(this);
            for (int i = this.jTabbedpane.getTabCount() - 1; i > n; --i) {
                this.jTabbedpane.removeTabAt(i);
            }
        } else if (actionEvent.getSource() == this.downloadThis) {
            int n = VideoQualityEnum.getQN(Global.tab_qn);
            this.download(true, n);
        } else if (actionEvent.getSource() == this.downloadAll) {
            int n = VideoQualityEnum.getQN(Global.tab_qn);
            Global.index.downVideoTabs(true, n);
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

