/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.item;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public abstract class MJMenuWithRadioGroupBuilder {
    JMenu menu;
    ItemListener itemListener;
    JRadioButtonMenuItem[] menuItems;

    public MJMenuWithRadioGroupBuilder(String string, String ... stringArray) {
        this.menu = new JMenu(string);
        this.menuItems = new JRadioButtonMenuItem[stringArray.length];
        for (int i = 0; i < this.menuItems.length; ++i) {
            this.menuItems[i] = new JRadioButtonMenuItem(stringArray[i]);
        }
    }

    public MJMenuWithRadioGroupBuilder(String string, List<String> list) {
        this.menu = new JMenu(string);
        this.menuItems = new JRadioButtonMenuItem[list.size()];
        for (int i = 0; i < this.menuItems.length; ++i) {
            this.menuItems[i] = new JRadioButtonMenuItem(list.get(i));
        }
    }

    public MJMenuWithRadioGroupBuilder withMenuItemSelected(int n) {
        this.menuItems[n].setSelected(true);
        return this;
    }

    public MJMenuWithRadioGroupBuilder withItemListener(ItemListener itemListener) {
        this.itemListener = itemListener;
        return this;
    }

    public JMenu build() {
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.itemListener == null) {
            this.itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        for (int i = 0; i < MJMenuWithRadioGroupBuilder.this.menuItems.length; ++i) {
                            JRadioButtonMenuItem jRadioButtonMenuItem = MJMenuWithRadioGroupBuilder.this.menuItems[i];
                            if (jRadioButtonMenuItem != itemEvent.getSource()) continue;
                            MJMenuWithRadioGroupBuilder.this.onItemSelected(i, jRadioButtonMenuItem);
                            break;
                        }
                    }
                }
            };
        }
        for (JRadioButtonMenuItem jRadioButtonMenuItem : this.menuItems) {
            jRadioButtonMenuItem.addItemListener(this.itemListener);
            buttonGroup.add(jRadioButtonMenuItem);
            this.menu.add(jRadioButtonMenuItem);
        }
        this.init(this.menuItems);
        return this.menu;
    }

    public abstract void init(JRadioButtonMenuItem[] var1);

    public abstract void onItemSelected(int var1, JRadioButtonMenuItem var2);
}

