/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui;

import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import nicelee.bilibili.INeedLogin;
import nicelee.bilibili.PackageScanLoader;
import nicelee.bilibili.util.CmdUtil;
import nicelee.bilibili.util.ConfigUtil;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.RepoUtil;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.SysUtil;
import nicelee.bilibili.util.custom.System;
import nicelee.ui.FrameWaiting;
import nicelee.ui.Global;
import nicelee.ui.InitCheck;
import nicelee.ui.SysTray;
import nicelee.ui.TabDownload;
import nicelee.ui.TabIndex;
import nicelee.ui.item.JOptionPane;
import nicelee.ui.item.MJMenuBar;
import nicelee.ui.thread.BatchDownloadRbyRThread;
import nicelee.ui.thread.CookieRefreshThread;
import nicelee.ui.thread.LoginThread;
import nicelee.ui.thread.MonitoringThread;

public class FrameMain_v3_4
extends JFrame {
    private static final long serialVersionUID = 1L;
    JTabbedPane jTabbedpane;

    public static void main(String[] stringArray) {
        Thread thread;
        java.lang.System.out.println();
        boolean bl = SysUtil.surportFFmpegOfficially();
        java.lang.System.out.println("Java version:" + java.lang.System.getProperty("java.specification.version"));
        java.lang.System.out.println(ResourcesUtil.baseDirectory());
        ConfigUtil.initConfigs();
        if (stringArray.length == 1 && "-v".equalsIgnoreCase(stringArray[0])) {
            java.lang.System.out.println(Global.version);
            java.lang.System.exit(0);
        }
        InitCheck.checkFileAccess();
        Global.frWaiting = new FrameWaiting();
        Global.frWaiting.start();
        if (Global.lockCheck) {
            if (ConfigUtil.isRunning()) {
                Global.frWaiting.stop();
                JOptionPane.showMessageDialog(null, "\u7a0b\u5e8f\u5df2\u7ecf\u5728\u8fd0\u884c!", "\u8bf7\u6ce8\u610f!!", 2);
                return;
            }
            ConfigUtil.createLock();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ConfigUtil.deleteLock()));
        }
        System.init(Global.syncServerTime);
        FrameMain_v3_4.initUITheme();
        FrameMain_v3_4 frameMain_v3_4 = new FrameMain_v3_4();
        frameMain_v3_4.InitUI();
        MonitoringThread monitoringThread = new MonitoringThread();
        monitoringThread.start();
        INeedLogin iNeedLogin = new INeedLogin();
        String string = iNeedLogin.readCookies();
        if (string != null) {
            Global.needToLogin = true;
            if (Global.tryRefreshCookieOnStartup && !Global.runWASMinBrowser) {
                HttpCookies.setGlobalCookies(HttpCookies.convertCookies(string));
                CookieRefreshThread.showTips = false;
                thread = CookieRefreshThread.newInstance();
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CookieRefreshThread.showTips = true;
            }
        }
        thread = new LoginThread();
        thread.start();
        InitCheck.checkFFmpeg(bl);
        if (Global.saveToRepo) {
            RepoUtil.init(false);
        }
        PackageScanLoader.validParserClasses.isEmpty();
        if (Global.batchDownloadRbyRRunOnStartup) {
            new Thread(new Runnable((LoginThread)thread){
                final /* synthetic */ LoginThread val$loginTh;
                {
                    this.val$loginTh = loginThread;
                }

                @Override
                public void run() {
                    try {
                        this.val$loginTh.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    new BatchDownloadRbyRThread(Global.batchDownloadConfigName).start();
                }
            }).start();
        }
        java.lang.System.out.println("\u5982\u679c\u8fc7\u5ea6\u754c\u9762\u663e\u793a\u65f6\u95f4\u8fc7\u957f\uff0c\u53ef\u53cc\u51fb\u8df3\u8fc7");
        try {
            while (Global.frWaiting.isVisible()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            Global.frWaiting.stop();
        }
        Global.frWaiting = null;
        frameMain_v3_4.setVisible(true);
        frameMain_v3_4.setExtendedState(0);
        frameMain_v3_4.toFront();
    }

    static void initUITheme() {
        try {
            if (!Global.themeDefault) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                Font font = new Font("Dialog", 0, 12);
                Enumeration enumeration = UIManager.getDefaults().keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object object = UIManager.get(k);
                    if (!(object instanceof FontUIResource)) continue;
                    UIManager.put(k, font);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void InitUI() {
        this.setTitle("BiliBili Down~~" + Global.version);
        this.setSize(1200, 767);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        URL uRL = this.getClass().getResource("/resources/favicon.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setIconImage(imageIcon.getImage());
        MJMenuBar mJMenuBar = new MJMenuBar(this);
        this.setJMenuBar(mJMenuBar);
        Global.tabs = this.jTabbedpane = new JTabbedPane();
        this.jTabbedpane.setTabLayoutPolicy(1);
        Global.index = new TabIndex(this.jTabbedpane);
        this.jTabbedpane.addTab("\u4e3b\u9875", Global.index);
        Global.downloadTab = new TabDownload();
        this.jTabbedpane.addTab("\u4e0b\u8f7d\u9875", Global.downloadTab);
        this.setContentPane(this.jTabbedpane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                CmdUtil.deleteAllInactiveCmdTemp();
            }
        });
        SysTray.buildSysTray(this, imageIcon.getImage());
    }
}

