/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nicelee.bilibili.INeedLogin;
import nicelee.bilibili.util.Logger;
import nicelee.server.core.SocketServer;
import nicelee.ui.Global;
import nicelee.ui.item.JOptionPane;
import org.json.JSONObject;

public class DialogSMSLogin
extends JDialog
implements FocusListener,
MouseListener,
MouseMotionListener {
    public static DialogSMSLogin Instance;
    private static final long serialVersionUID = 3741671572332334944L;
    static final String tips = "\u8bf7\u8f93\u5165\u624b\u673a\u53f7(e.g. +86 18812344321)";
    static final Color colorLostFocus;
    static final Color colorGainFocus;
    private Point pressedPoint;
    private JButton btnClose;
    INeedLogin inl;
    JTextField jtUserName = new JTextField("\u8bf7\u8f93\u5165\u624b\u673a\u53f7(e.g. +86 18812344321)");
    JTextField jtSMSCode = new JTextField();
    JLabel lbGetSMS = new JLabel("\u83b7\u53d6\u77ed\u4fe1\u9a8c\u8bc1\u7801");
    JLabel lbLogin = new JLabel("\u767b\u5f55");
    JLabel lbTips = new JLabel("");
    boolean isRefreshingCaptcha = false;
    boolean isLogging = false;
    SocketServer socketServer;
    String countryCode;
    String phoneNumber;
    String captchaKey;

    public static void main(String[] stringArray) {
        try {
            DialogSMSLogin dialogSMSLogin = new DialogSMSLogin(new INeedLogin());
            dialogSMSLogin.init();
            Logger.println("-----------------");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DialogSMSLogin(INeedLogin iNeedLogin) {
        this.inl = iNeedLogin;
    }

    public void init() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DialogSMSLogin.this.socketServer = new SocketServer(Global.serverPort);
                DialogSMSLogin.this.socketServer.startServer();
            }
        }, "SMS\u767b\u5f55server").start();
        Instance = this;
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.setSize(522, 300);
        this.setUndecorated(true);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true));
        jPanel.setBackground(Color.WHITE);
        this.initSysButton(jPanel);
        ImageIcon imageIcon = new ImageIcon(DialogSMSLogin.class.getResource("/resources/banner.jpg"));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(520, 110, 4));
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setIcon(imageIcon);
        jLabel.setBounds(1, 1, 520, 90);
        jPanel.add(jLabel);
        Font font = new Font("Serif", 0, 18);
        Insets insets = new Insets(2, 10, 2, 0);
        this.jtUserName.setBounds(50, 80, 420, 40);
        this.jtSMSCode.setBounds(50, 130, 200, 40);
        this.jtUserName.setBackground(colorLostFocus);
        this.jtSMSCode.setBackground(colorLostFocus);
        this.jtUserName.setMargin(insets);
        this.jtSMSCode.setMargin(insets);
        this.jtUserName.setFont(font);
        this.jtSMSCode.setFont(font);
        this.lbGetSMS.setBounds(270, 130, 200, 40);
        this.lbGetSMS.setHorizontalAlignment(0);
        this.lbGetSMS.setBackground(Color.LIGHT_GRAY);
        this.lbGetSMS.setOpaque(true);
        this.lbGetSMS.setFont(font);
        this.lbLogin.setBounds(50, 200, 420, 40);
        this.lbLogin.setHorizontalAlignment(0);
        this.lbLogin.setBackground(Color.LIGHT_GRAY);
        this.lbLogin.setOpaque(true);
        this.lbLogin.setFont(font);
        this.lbTips.setBounds(50, 250, 420, 40);
        this.lbTips.setHorizontalAlignment(0);
        this.lbTips.setForeground(Color.RED);
        jPanel.add(this.jtUserName);
        jPanel.add(this.jtSMSCode);
        jPanel.add(this.lbGetSMS);
        jPanel.add(this.lbLogin);
        jPanel.add(this.lbTips);
        this.jtUserName.addFocusListener(this);
        this.lbGetSMS.addMouseListener(this);
        this.lbLogin.addMouseListener(this);
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.setLayout(null);
        if (Global.userName != null) {
            this.jtUserName.setText(Global.userName);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                DialogSMSLogin.this.lbLogin.requestFocus();
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Logger.println("socketServer \u5173\u95ed\u4e2d...");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (DialogSMSLogin.this.socketServer != null) {
                            DialogSMSLogin.this.socketServer.stopServer();
                        }
                    }
                }, "Thread to shutdown server").start();
            }
        });
        this.setModal(true);
        this.setVisible(true);
    }

    private void initSysButton(JPanel jPanel) {
        this.btnClose = new JButton();
        this.btnClose.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/xh.jpg")));
        this.btnClose.setFocusPainted(false);
        this.btnClose.setBorderPainted(false);
        this.btnClose.setContentAreaFilled(false);
        this.btnClose.setOpaque(true);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/x.jpg"));
        this.btnClose.setIcon(imageIcon);
        this.btnClose.setBounds(490, 5, 20, 20);
        jPanel.add(this.btnClose);
        this.btnClose.addMouseListener(this);
    }

    private void queryCaptcha() {
        Logger.println("\u5237\u65b0\u9a8c\u8bc1\u7801");
        this.isRefreshingCaptcha = true;
        this.lbTips.setText("");
        if (this.jtUserName.hasFocus()) {
            Global.userName = this.jtUserName.getText();
        }
        if (Global.userName == null || Global.userName.isEmpty()) {
            this.lbTips.setText("\u8f93\u5165\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        } else {
            try {
                JSONObject jSONObject = this.inl.getGeetest();
                String string = jSONObject.getString("token");
                String string2 = jSONObject.getJSONObject("geetest").getString("gt");
                String string3 = jSONObject.getJSONObject("geetest").getString("challenge");
                String string4 = String.format("http://localhost:%d/static/index.html?token=%s&gt=%s&challenge=%s&type=sms", Global.serverPort, string, string2, string3);
                boolean bl = Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
                if (bl) {
                    Desktop.getDesktop().browse(new URI(string4));
                } else {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection stringSelection = new StringSelection(string4);
                    clipboard.setContents(stringSelection, null);
                    JOptionPane.showMessageDialog(this, "\u8bf7\u901a\u8fc7\u6d4f\u89c8\u5668\u8bbf\u95ee\u4ee5\u4e0b\u7f51\u5740(\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f):\n" + string4, "\u8bf7\u6ce8\u610f", 2);
                }
                this.lbTips.setText("\u6781\u9a8c\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u4e2d...");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.isRefreshingCaptcha = false;
    }

    public void login() {
        this.lbTips.setText("");
        String string = this.jtSMSCode.getText();
        if (string.isEmpty()) {
            this.lbTips.setText("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            String string2 = this.inl.loginSMS(this.countryCode, this.phoneNumber, string, this.captchaKey);
            if (string2 == null) {
                this.lbTips.setText("\u767b\u5f55\u6210\u529f");
                Global.isLogin = true;
                WindowEvent windowEvent = new WindowEvent(this, 201);
                this.dispatchEvent(windowEvent);
            } else {
                this.lbTips.setText(string2);
            }
        }
    }

    public void sendSMS(String string, String string2, String string3, String string4) {
        this.lbTips.setText("");
        try {
            JSONObject jSONObject = this.inl.sendSMS(this.countryCode, this.phoneNumber, string, string2, string3, string4);
            this.captchaKey = jSONObject.getJSONObject("data").getString("captcha_key");
            this.lbTips.setText("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5df2\u7ecf\u53d1\u9001");
        }
        catch (Exception exception) {
            this.lbTips.setText("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5c1d\u8bd5");
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.jtUserName) {
            if (Global.userName != null) {
                this.jtUserName.setText(Global.userName);
            } else {
                this.jtUserName.setText("");
            }
        }
        JComponent jComponent = (JComponent)focusEvent.getSource();
        jComponent.setBackground(colorGainFocus);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object;
        if (focusEvent.getSource() == this.jtUserName) {
            object = this.jtUserName.getText();
            if (((String)object).isEmpty()) {
                this.jtUserName.setText(tips);
            } else {
                Global.userName = object;
            }
        }
        object = (JComponent)focusEvent.getSource();
        ((JComponent)object).setBackground(colorLostFocus);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.lbGetSMS) {
            Pattern pattern = Pattern.compile("^\\+(\\d{1,3}) +(\\d+)$");
            Matcher matcher = pattern.matcher(this.jtUserName.getText());
            if (matcher.find()) {
                this.countryCode = matcher.group(1);
                this.phoneNumber = matcher.group(2);
                this.queryCaptcha();
            } else {
                this.lbTips.setText("\u624b\u673a\u53f7\u4e0d\u7b26\u5408+\u56fd\u9645\u53f7 \u624b\u673a\u53f7\u7801\u7684\u683c\u5f0f(\u6ce8\u610f\u4e2d\u95f4\u7684\u7a7a\u683c)");
            }
        } else if (mouseEvent.getSource() == this.lbLogin) {
            if (this.captchaKey == null) {
                this.lbTips.setText("\u8bf7\u5148\u83b7\u53d6\u77ed\u4fe1\u9a8c\u8bc1\u7801!!");
            } else {
                this.login();
            }
        } else if (mouseEvent.getSource() == this.btnClose) {
            Logger.println("closing...");
            WindowEvent windowEvent = new WindowEvent(this, 201);
            this.dispatchEvent(windowEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.pressedPoint = mouseEvent.getPoint();
        } else if (mouseEvent.getSource() instanceof JLabel) {
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            jLabel.setBorder(BorderFactory.createLineBorder(Color.RED, 2, true));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JLabel) {
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            jLabel.setBorder(null);
        }
        this.pressedPoint = null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pressedPoint != null && mouseEvent.getSource() != this.btnClose) {
            Point point = this.getLocation();
            Point point2 = mouseEvent.getPoint();
            int n = point.x + point2.x - this.pressedPoint.x;
            int n2 = point.y + point2.y - this.pressedPoint.y;
            this.setLocation(n, n2);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    static {
        colorLostFocus = Color.getHSBColor(100.0f, 100.0f, 100.0f);
        colorGainFocus = Color.white;
    }
}

