/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util.danmuku;

public class Danmuku {
    double time;
    int type;
    int fontSizeType;
    int fontColor;
    String content;

    public Danmuku(double d, int n, int n2, int n3, String string) {
        this.time = d;
        this.type = n;
        this.fontSizeType = n2;
        this.fontColor = n3;
        this.content = string;
    }

    public double getTime() {
        return this.time;
    }

    public int getType() {
        return this.type;
    }

    public int getFontSizeType() {
        return this.fontSizeType;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public String getContent() {
        return this.content;
    }

    public static String getFontTypeStr(int n) {
        switch (n) {
            case 0: {
                return "UltraSmall";
            }
            case 1: {
                return "VerySmall";
            }
            case 2: {
                return "Small";
            }
            case 3: {
                return "Normal";
            }
            case 4: {
                return "Big";
            }
            case 5: {
                return "VeryBig";
            }
            case 6: {
                return "UltraBig";
            }
        }
        return "Normal";
    }

    public static int getFontSize(int n) {
        switch (n) {
            case 0: {
                return 24;
            }
            case 1: {
                return 32;
            }
            case 2: {
                return 36;
            }
            case 3: {
                return 55;
            }
            case 4: {
                return 72;
            }
            case 5: {
                return 90;
            }
            case 6: {
                return 128;
            }
        }
        return 50;
    }

    public static String getFormatTime(double d) {
        int n = (int)d;
        int n2 = n / 60;
        int n3 = n2 / 60;
        double d2 = d - (double)n;
        int n4 = (int)(d2 * 100.0);
        return String.format("%d:%02d:%02d.%02d", n3, n2 %= 60, n %= 60, n4);
    }

    public static String getColor(int n) {
        switch (n) {
            case 0xFFFFFF: {
                return "FFFFFF";
            }
            case 16646914: {
                return "FE0302";
            }
            case 16740868: {
                return "FF7204";
            }
            case 16755202: {
                return "FFAA02";
            }
            case 16765698: {
                return "FFD302";
            }
            case 0xFFFF00: {
                return "FFFF00";
            }
            case 0xA0EE00: {
                return "A0EE00";
            }
            case 52480: {
                return "00CD00";
            }
            case 4351678: {
                return "4266BE";
            }
            case 9033215: {
                return "89D5FF";
            }
            case 13369971: {
                return "CC0273";
            }
            case 0x9B9B9B: {
                return "9B9B9B";
            }
            case 0x222222: {
                return "222222";
            }
        }
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return String.format("%02X%02X%02X", n4, n3, n2);
    }
}

