/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util.check;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RafWBuffered {
    byte[] buffer;
    int pointer;
    RandomAccessFile raf;

    public RafWBuffered(File file, String string) throws FileNotFoundException {
        this(file, string, 0x200000);
    }

    public RafWBuffered(File file, String string, int n) throws FileNotFoundException {
        this.buffer = new byte[n];
        this.raf = new RandomAccessFile(file, string);
        this.pointer = 0;
    }

    public void write(int n) throws IOException {
        if (this.pointer == this.buffer.length) {
            this.raf.write(this.buffer);
            this.buffer[0] = (byte)(n & 0xFF);
            this.pointer = 1;
        } else {
            this.buffer[this.pointer] = (byte)(n & 0xFF);
            ++this.pointer;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.buffer.length - this.pointer;
        if (n3 >= n2) {
            System.arraycopy(byArray, n, this.buffer, this.pointer, n2);
            this.pointer += n2;
        } else {
            System.arraycopy(byArray, n, this.buffer, this.pointer, n3);
            this.raf.write(this.buffer);
            int n4 = n2 - n3;
            if (n4 > this.buffer.length) {
                this.raf.write(byArray, n + n3, n4);
                this.pointer = 0;
            } else {
                System.arraycopy(byArray, n + n3, this.buffer, 0, n4);
                this.pointer = n4;
            }
        }
    }

    public void seek(long l) throws IOException {
        this.flush();
        this.raf.seek(l);
    }

    public void close() throws IOException {
        this.flush();
        this.raf.close();
    }

    public void setLength(long l) throws IOException {
        this.flush();
        this.raf.setLength(l);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer() + (long)this.pointer;
    }

    public void flush() throws IOException {
        if (this.pointer > 0) {
            this.raf.write(this.buffer, 0, this.pointer);
            this.pointer = 0;
        }
    }
}

